<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "balance_detailed" table
 */
#[Entity]
#[Table(name: "balance_detailed")]
class BalanceDetailed extends AbstractEntity
{
    #[Column(type: "string", nullable: true)]
    private ?string $id;

    #[Column(type: "integer", nullable: true)]
    private ?int $account;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(name: "ref_account", type: "decimal", nullable: true)]
    private ?string $refAccount;

    #[Column(type: "decimal", nullable: true)]
    private ?string $debit;

    #[Column(type: "float", nullable: true)]
    private ?float $credit;

    #[Column(type: "string", nullable: true)]
    private ?string $balance;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $dated;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "string")]
    private string $type;

    #[Column(type: "string", nullable: true)]
    private ?string $reference;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $at;

    #[Column(type: "string", nullable: true)]
    private ?string $city;

    public function __construct()
    {
        $this->debit = "0.00";
        $this->credit = 0.00;
        $this->balance = "0.00";
    }

    public function getId(): ?string
    {
        return HtmlDecode($this->id);
    }

    public function setId(?string $value): static
    {
        $this->id = RemoveXss($value);
        return $this;
    }

    public function getAccount(): ?int
    {
        return $this->account;
    }

    public function setAccount(?int $value): static
    {
        $this->account = $value;
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getRefAccount(): ?string
    {
        return $this->refAccount;
    }

    public function setRefAccount(?string $value): static
    {
        $this->refAccount = $value;
        return $this;
    }

    public function getDebit(): ?string
    {
        return $this->debit;
    }

    public function setDebit(?string $value): static
    {
        $this->debit = $value;
        return $this;
    }

    public function getCredit(): ?float
    {
        return $this->credit;
    }

    public function setCredit(?float $value): static
    {
        $this->credit = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return HtmlDecode($this->balance);
    }

    public function setBalance(?string $value): static
    {
        $this->balance = RemoveXss($value);
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getType(): string
    {
        return HtmlDecode($this->type);
    }

    public function setType(string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getReference(): ?string
    {
        return HtmlDecode($this->reference);
    }

    public function setReference(?string $value): static
    {
        $this->reference = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getAt(): ?string
    {
        return HtmlDecode($this->at);
    }

    public function setAt(?string $value): static
    {
        $this->at = RemoveXss($value);
        return $this;
    }

    public function getCity(): ?string
    {
        return HtmlDecode($this->city);
    }

    public function setCity(?string $value): static
    {
        $this->city = RemoveXss($value);
        return $this;
    }
}
