<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "balance" table
 */
#[Entity]
#[Table(name: "balance")]
class Balance extends AbstractEntity
{
    #[Column(type: "string", nullable: true)]
    private ?string $id;

    #[Column(type: "string", nullable: true)]
    private ?string $reference;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(type: "integer", nullable: true)]
    private ?int $account;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(name: "ref_account", type: "decimal", nullable: true)]
    private ?string $refAccount;

    #[Column(type: "decimal", nullable: true)]
    private ?string $debit;

    #[Column(type: "float", nullable: true)]
    private ?float $credit;

    #[Column(type: "float", nullable: true)]
    private ?float $balance;

    #[Column(type: "string", nullable: true)]
    private ?string $at;

    #[Column(type: "string", nullable: true)]
    private ?string $city;

    public function getId(): ?string
    {
        return HtmlDecode($this->id);
    }

    public function setId(?string $value): static
    {
        $this->id = RemoveXss($value);
        return $this;
    }

    public function getReference(): ?string
    {
        return HtmlDecode($this->reference);
    }

    public function setReference(?string $value): static
    {
        $this->reference = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getAccount(): ?int
    {
        return $this->account;
    }

    public function setAccount(?int $value): static
    {
        $this->account = $value;
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getRefAccount(): ?string
    {
        return $this->refAccount;
    }

    public function setRefAccount(?string $value): static
    {
        $this->refAccount = $value;
        return $this;
    }

    public function getDebit(): ?string
    {
        return $this->debit;
    }

    public function setDebit(?string $value): static
    {
        $this->debit = $value;
        return $this;
    }

    public function getCredit(): ?float
    {
        return $this->credit;
    }

    public function setCredit(?float $value): static
    {
        $this->credit = $value;
        return $this;
    }

    public function getBalance(): ?float
    {
        return $this->balance;
    }

    public function setBalance(?float $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getAt(): ?string
    {
        return HtmlDecode($this->at);
    }

    public function setAt(?string $value): static
    {
        $this->at = RemoveXss($value);
        return $this;
    }

    public function getCity(): ?string
    {
        return HtmlDecode($this->city);
    }

    public function setCity(?string $value): static
    {
        $this->city = RemoveXss($value);
        return $this;
    }
}
