<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "b_incentive_pp" table
 */
#[Entity]
#[Table(name: "b_incentive_pp")]
class BIncentivePp extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer", nullable: true)]
    private ?int $partner;

    #[Column(type: "smallint")]
    private int $category;

    #[Column(type: "integer")]
    private int $type;

    #[Column(name: "target_amount", type: "integer")]
    private int $targetAmount;

    #[Column(name: "target_file", type: "integer")]
    private int $targetFile;

    #[Column(name: "file_inc", type: "integer")]
    private int $fileInc;

    #[Column(name: "neg_file_inc", type: "integer")]
    private int $negFileInc;

    #[Column(name: "inc_min_amount", type: "integer")]
    private int $incMinAmount;

    #[Column(name: "inc_max_amount", type: "integer")]
    private int $incMaxAmount;

    #[Column(name: "inc_percent", type: "decimal")]
    private string $incPercent;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->targetAmount = 0;
        $this->targetFile = 0;
        $this->fileInc = 0;
        $this->negFileInc = 0;
        $this->incMinAmount = 0;
        $this->incMaxAmount = 0;
        $this->incPercent = "0.000";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPartner(): ?int
    {
        return $this->partner;
    }

    public function setPartner(?int $value): static
    {
        $this->partner = $value;
        return $this;
    }

    public function getCategory(): int
    {
        return $this->category;
    }

    public function setCategory(int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getTargetAmount(): int
    {
        return $this->targetAmount;
    }

    public function setTargetAmount(int $value): static
    {
        $this->targetAmount = $value;
        return $this;
    }

    public function getTargetFile(): int
    {
        return $this->targetFile;
    }

    public function setTargetFile(int $value): static
    {
        $this->targetFile = $value;
        return $this;
    }

    public function getFileInc(): int
    {
        return $this->fileInc;
    }

    public function setFileInc(int $value): static
    {
        $this->fileInc = $value;
        return $this;
    }

    public function getNegFileInc(): int
    {
        return $this->negFileInc;
    }

    public function setNegFileInc(int $value): static
    {
        $this->negFileInc = $value;
        return $this;
    }

    public function getIncMinAmount(): int
    {
        return $this->incMinAmount;
    }

    public function setIncMinAmount(int $value): static
    {
        $this->incMinAmount = $value;
        return $this;
    }

    public function getIncMaxAmount(): int
    {
        return $this->incMaxAmount;
    }

    public function setIncMaxAmount(int $value): static
    {
        $this->incMaxAmount = $value;
        return $this;
    }

    public function getIncPercent(): string
    {
        return $this->incPercent;
    }

    public function setIncPercent(string $value): static
    {
        $this->incPercent = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
