<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "b_charges_plan" table
 */
#[Entity]
#[Table(name: "b_charges_plan")]
class BChargesPlan extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $location;

    #[Column(type: "string", nullable: true)]
    private ?string $grp;

    #[Column(name: "s_grp", type: "string", nullable: true)]
    private ?string $sGrp;

    #[Column(type: "string", nullable: true)]
    private ?string $description;

    #[Column(name: "plan_type", type: "integer", nullable: true)]
    private ?int $planType;

    #[Column(type: "smallint", nullable: true)]
    private ?int $method;

    #[Column(type: "integer", nullable: true)]
    private ?int $fix;

    #[Column(name: "`@`", options: ["name" => "@"], type: "decimal", nullable: true)]
    private ?string $40;

    #[Column(name: "min_range", type: "decimal", nullable: true)]
    private ?string $minRange;

    #[Column(name: "max_range", type: "decimal", nullable: true)]
    private ?string $maxRange;

    #[Column(name: "from_date", type: "datetime", nullable: true)]
    private ?DateTime $fromDate;

    #[Column(name: "to_date", type: "datetime", nullable: true)]
    private ?DateTime $toDate;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->fix = 1;
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): ?string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(?string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(?string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getSGrp(): ?string
    {
        return HtmlDecode($this->sGrp);
    }

    public function setSGrp(?string $value): static
    {
        $this->sGrp = RemoveXss($value);
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getPlanType(): ?int
    {
        return $this->planType;
    }

    public function setPlanType(?int $value): static
    {
        $this->planType = $value;
        return $this;
    }

    public function getMethod(): ?int
    {
        return $this->method;
    }

    public function setMethod(?int $value): static
    {
        $this->method = $value;
        return $this;
    }

    public function getFix(): ?int
    {
        return $this->fix;
    }

    public function setFix(?int $value): static
    {
        $this->fix = $value;
        return $this;
    }

    public function get40(): ?string
    {
        return $this->40;
    }

    public function set40(?string $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getMinRange(): ?string
    {
        return $this->minRange;
    }

    public function setMinRange(?string $value): static
    {
        $this->minRange = $value;
        return $this;
    }

    public function getMaxRange(): ?string
    {
        return $this->maxRange;
    }

    public function setMaxRange(?string $value): static
    {
        $this->maxRange = $value;
        return $this;
    }

    public function getFromDate(): ?DateTime
    {
        return $this->fromDate;
    }

    public function setFromDate(?DateTime $value): static
    {
        $this->fromDate = $value;
        return $this;
    }

    public function getToDate(): ?DateTime
    {
        return $this->toDate;
    }

    public function setToDate(?DateTime $value): static
    {
        $this->toDate = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
