<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "b_account_type" table
 */
#[Entity]
#[Table(name: "b_account_type")]
class BAccountType extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $location;

    #[Column(type: "integer", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "integer", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "string", nullable: true)]
    private ?string $description;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(type: "integer", nullable: true)]
    private ?int $minimum;

    #[Column(type: "integer", nullable: true)]
    private ?int $maximum;

    #[Column(name: "`int_@`", options: ["name" => "int_@"], type: "decimal", nullable: true)]
    private ?string $int;

    #[Column(name: "no_of_emi", type: "smallint", nullable: true)]
    private ?int $noOfEmi;

    #[Column(name: "repay_frequency", type: "smallint", nullable: true)]
    private ?int $repayFrequency;

    #[Column(name: "one_time_charge", type: "string", nullable: true)]
    private ?string $oneTimeCharge;

    #[Column(name: "action_charge", type: "string", nullable: true)]
    private ?string $actionCharge;

    #[Column(name: "month_charge", type: "string", nullable: true)]
    private ?string $monthCharge;

    #[Column(name: "quarter_charge", type: "string", nullable: true)]
    private ?string $quarterCharge;

    #[Column(name: "annual_charge", type: "string", nullable: true)]
    private ?string $annualCharge;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "repay_period", type: "smallint", nullable: true)]
    private ?int $repayPeriod;

    public function __construct()
    {
        $this->noOfEmi = 0;
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): ?string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(?string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getMinimum(): ?int
    {
        return $this->minimum;
    }

    public function setMinimum(?int $value): static
    {
        $this->minimum = $value;
        return $this;
    }

    public function getMaximum(): ?int
    {
        return $this->maximum;
    }

    public function setMaximum(?int $value): static
    {
        $this->maximum = $value;
        return $this;
    }

    public function getInt(): ?string
    {
        return $this->int;
    }

    public function setInt(?string $value): static
    {
        $this->int = $value;
        return $this;
    }

    public function getNoOfEmi(): ?int
    {
        return $this->noOfEmi;
    }

    public function setNoOfEmi(?int $value): static
    {
        $this->noOfEmi = $value;
        return $this;
    }

    public function getRepayFrequency(): ?int
    {
        return $this->repayFrequency;
    }

    public function setRepayFrequency(?int $value): static
    {
        $this->repayFrequency = $value;
        return $this;
    }

    public function getOneTimeCharge(): ?string
    {
        return HtmlDecode($this->oneTimeCharge);
    }

    public function setOneTimeCharge(?string $value): static
    {
        $this->oneTimeCharge = RemoveXss($value);
        return $this;
    }

    public function getActionCharge(): ?string
    {
        return HtmlDecode($this->actionCharge);
    }

    public function setActionCharge(?string $value): static
    {
        $this->actionCharge = RemoveXss($value);
        return $this;
    }

    public function getMonthCharge(): ?string
    {
        return HtmlDecode($this->monthCharge);
    }

    public function setMonthCharge(?string $value): static
    {
        $this->monthCharge = RemoveXss($value);
        return $this;
    }

    public function getQuarterCharge(): ?string
    {
        return HtmlDecode($this->quarterCharge);
    }

    public function setQuarterCharge(?string $value): static
    {
        $this->quarterCharge = RemoveXss($value);
        return $this;
    }

    public function getAnnualCharge(): ?string
    {
        return HtmlDecode($this->annualCharge);
    }

    public function setAnnualCharge(?string $value): static
    {
        $this->annualCharge = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRepayPeriod(): ?int
    {
        return $this->repayPeriod;
    }

    public function setRepayPeriod(?int $value): static
    {
        $this->repayPeriod = $value;
        return $this;
    }
}
