<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "b_account_int_log" table
 */
#[Entity]
#[Table(name: "b_account_int_log")]
class BAccountIntLog extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "account_no", type: "integer", nullable: true)]
    private ?int $accountNo;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "emi_no", type: "smallint", nullable: true)]
    private ?int $emiNo;

    #[Column(name: "emi_date", type: "date", nullable: true)]
    private ?DateTime $emiDate;

    #[Column(type: "decimal", nullable: true)]
    private ?string $principal;

    #[Column(type: "decimal", nullable: true)]
    private ?string $emi;

    #[Column(type: "decimal", nullable: true)]
    private ?string $interest;

    #[Column(type: "decimal", nullable: true)]
    private ?string $deposited;

    #[Column(type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(type: "string")]
    private string $description;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $url;

    public function __construct()
    {
        $this->accountNo = 0;
        $this->status = 1;
        $this->emi = "0.00";
        $this->interest = "0.00";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getAccountNo(): ?int
    {
        return $this->accountNo;
    }

    public function setAccountNo(?int $value): static
    {
        $this->accountNo = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getEmiNo(): ?int
    {
        return $this->emiNo;
    }

    public function setEmiNo(?int $value): static
    {
        $this->emiNo = $value;
        return $this;
    }

    public function getEmiDate(): ?DateTime
    {
        return $this->emiDate;
    }

    public function setEmiDate(?DateTime $value): static
    {
        $this->emiDate = $value;
        return $this;
    }

    public function getPrincipal(): ?string
    {
        return $this->principal;
    }

    public function setPrincipal(?string $value): static
    {
        $this->principal = $value;
        return $this;
    }

    public function getEmi(): ?string
    {
        return $this->emi;
    }

    public function setEmi(?string $value): static
    {
        $this->emi = $value;
        return $this;
    }

    public function getInterest(): ?string
    {
        return $this->interest;
    }

    public function setInterest(?string $value): static
    {
        $this->interest = $value;
        return $this;
    }

    public function getDeposited(): ?string
    {
        return $this->deposited;
    }

    public function setDeposited(?string $value): static
    {
        $this->deposited = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getDescription(): string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUrl(): ?string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(?string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }
}
