<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "b_account_info_agent" table
 */
#[Entity]
#[Table(name: "b_account_info_agent")]
class BAccountInfoAgent extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "b_type", type: "integer")]
    private int $bType;

    #[Column(type: "integer")]
    private int $grp;

    #[Column(name: "account_type", type: "smallint", nullable: true)]
    private ?int $accountType;

    #[Column(name: "aadhaar_no", type: "string", nullable: true)]
    private ?string $aadhaarNo;

    #[Column(name: "account_no", type: "string")]
    private string $accountNo;

    #[Column(name: "formal_name", type: "string", nullable: true)]
    private ?string $formalName;

    #[Column(type: "bigint", nullable: true)]
    private ?string $mobile;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(name: "pan_no", type: "string", nullable: true)]
    private ?string $panNo;

    #[Column(name: "id_proof", type: "string", nullable: true)]
    private ?string $idProof;

    #[Column(type: "string", nullable: true)]
    private ?string $agent;

    #[Column(name: "other_details", type: "text", nullable: true)]
    private ?string $otherDetails;

    #[Column(name: "loan_amount", type: "decimal")]
    private string $loanAmount;

    #[Column(name: "`int_@`", options: ["name" => "int_@"], type: "decimal", nullable: true)]
    private ?string $int;

    #[Column(name: "disbursement_amount", type: "decimal")]
    private string $disbursementAmount;

    #[Column(name: "emi_amount", type: "decimal")]
    private string $emiAmount;

    #[Column(name: "no_of_emi", type: "smallint", nullable: true)]
    private ?int $noOfEmi;

    #[Column(type: "smallint", nullable: true)]
    private ?int $frequency;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "integer", nullable: true)]
    private ?int $otp;

    #[Column(name: "otp_delivery_datetime", type: "datetime", nullable: true)]
    private ?DateTime $otpDeliveryDatetime;

    #[Column(name: "otp_verify_datetime", type: "datetime", nullable: true)]
    private ?DateTime $otpVerifyDatetime;

    #[Column(name: "fund_o", type: "decimal", nullable: true)]
    private ?string $fundO;

    #[Column(name: "fund_o_no", type: "string", nullable: true)]
    private ?string $fundONo;

    public function __construct()
    {
        $this->bType = 0;
        $this->status = 101;
        $this->noOfEmi = 0;
        $this->operator = 0;
        $this->fundO = "0.00";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBType(): int
    {
        return $this->bType;
    }

    public function setBType(int $value): static
    {
        $this->bType = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getAccountType(): ?int
    {
        return $this->accountType;
    }

    public function setAccountType(?int $value): static
    {
        $this->accountType = $value;
        return $this;
    }

    public function getAadhaarNo(): ?string
    {
        return HtmlDecode($this->aadhaarNo);
    }

    public function setAadhaarNo(?string $value): static
    {
        $this->aadhaarNo = RemoveXss($value);
        return $this;
    }

    public function getAccountNo(): string
    {
        return HtmlDecode($this->accountNo);
    }

    public function setAccountNo(string $value): static
    {
        $this->accountNo = RemoveXss($value);
        return $this;
    }

    public function getFormalName(): ?string
    {
        return HtmlDecode($this->formalName);
    }

    public function setFormalName(?string $value): static
    {
        $this->formalName = RemoveXss($value);
        return $this;
    }

    public function getMobile(): ?string
    {
        return $this->mobile;
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = $value;
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getPanNo(): ?string
    {
        return HtmlDecode($this->panNo);
    }

    public function setPanNo(?string $value): static
    {
        $this->panNo = RemoveXss($value);
        return $this;
    }

    public function getIdProof(): ?string
    {
        return HtmlDecode($this->idProof);
    }

    public function setIdProof(?string $value): static
    {
        $this->idProof = RemoveXss($value);
        return $this;
    }

    public function getAgent(): ?string
    {
        return HtmlDecode($this->agent);
    }

    public function setAgent(?string $value): static
    {
        $this->agent = RemoveXss($value);
        return $this;
    }

    public function getOtherDetails(): ?string
    {
        return HtmlDecode($this->otherDetails);
    }

    public function setOtherDetails(?string $value): static
    {
        $this->otherDetails = RemoveXss($value);
        return $this;
    }

    public function getLoanAmount(): string
    {
        return $this->loanAmount;
    }

    public function setLoanAmount(string $value): static
    {
        $this->loanAmount = $value;
        return $this;
    }

    public function getInt(): ?string
    {
        return $this->int;
    }

    public function setInt(?string $value): static
    {
        $this->int = $value;
        return $this;
    }

    public function getDisbursementAmount(): string
    {
        return $this->disbursementAmount;
    }

    public function setDisbursementAmount(string $value): static
    {
        $this->disbursementAmount = $value;
        return $this;
    }

    public function getEmiAmount(): string
    {
        return $this->emiAmount;
    }

    public function setEmiAmount(string $value): static
    {
        $this->emiAmount = $value;
        return $this;
    }

    public function getNoOfEmi(): ?int
    {
        return $this->noOfEmi;
    }

    public function setNoOfEmi(?int $value): static
    {
        $this->noOfEmi = $value;
        return $this;
    }

    public function getFrequency(): ?int
    {
        return $this->frequency;
    }

    public function setFrequency(?int $value): static
    {
        $this->frequency = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getOtp(): ?int
    {
        return $this->otp;
    }

    public function setOtp(?int $value): static
    {
        $this->otp = $value;
        return $this;
    }

    public function getOtpDeliveryDatetime(): ?DateTime
    {
        return $this->otpDeliveryDatetime;
    }

    public function setOtpDeliveryDatetime(?DateTime $value): static
    {
        $this->otpDeliveryDatetime = $value;
        return $this;
    }

    public function getOtpVerifyDatetime(): ?DateTime
    {
        return $this->otpVerifyDatetime;
    }

    public function setOtpVerifyDatetime(?DateTime $value): static
    {
        $this->otpVerifyDatetime = $value;
        return $this;
    }

    public function getFundO(): ?string
    {
        return $this->fundO;
    }

    public function setFundO(?string $value): static
    {
        $this->fundO = $value;
        return $this;
    }

    public function getFundONo(): ?string
    {
        return HtmlDecode($this->fundONo);
    }

    public function setFundONo(?string $value): static
    {
        $this->fundONo = RemoveXss($value);
        return $this;
    }
}
