<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "b_account_compiled" table
 */
#[Entity]
#[Table(name: "b_account_compiled")]
class BAccountCompiled extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "integer")]
    private int $grp;

    #[Column(name: "account_no", type: "string")]
    private string $accountNo;

    #[Column(name: "formal_name", type: "string", nullable: true)]
    private ?string $formalName;

    #[Column(type: "float", nullable: true)]
    private ?float $balance;

    #[Column(name: "loan_amount", type: "decimal")]
    private string $loanAmount;

    #[Column(name: "emi_amount", type: "decimal")]
    private string $emiAmount;

    #[Column(name: "no_of_emi", type: "smallint", nullable: true)]
    private ?int $noOfEmi;

    #[Column(name: "disbursement_amount", type: "decimal")]
    private string $disbursementAmount;

    #[Column(type: "smallint", nullable: true)]
    private ?int $frequency;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(name: "end_date", type: "date", nullable: true)]
    private ?DateTime $endDate;

    #[Column(name: "due_emi", type: "bigint")]
    private string $dueEmi;

    #[Column(type: "smallint", nullable: true)]
    private ?int $branch;

    #[Column(type: "bigint", nullable: true)]
    private ?string $mobile;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    public function __construct()
    {
        $this->id = 0;
        $this->grp = 10104;
        $this->noOfEmi = 0;
        $this->status = 101;
        $this->dueEmi = "0";
        $this->branch = 101;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getAccountNo(): string
    {
        return HtmlDecode($this->accountNo);
    }

    public function setAccountNo(string $value): static
    {
        $this->accountNo = RemoveXss($value);
        return $this;
    }

    public function getFormalName(): ?string
    {
        return HtmlDecode($this->formalName);
    }

    public function setFormalName(?string $value): static
    {
        $this->formalName = RemoveXss($value);
        return $this;
    }

    public function getBalance(): ?float
    {
        return $this->balance;
    }

    public function setBalance(?float $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getLoanAmount(): string
    {
        return $this->loanAmount;
    }

    public function setLoanAmount(string $value): static
    {
        $this->loanAmount = $value;
        return $this;
    }

    public function getEmiAmount(): string
    {
        return $this->emiAmount;
    }

    public function setEmiAmount(string $value): static
    {
        $this->emiAmount = $value;
        return $this;
    }

    public function getNoOfEmi(): ?int
    {
        return $this->noOfEmi;
    }

    public function setNoOfEmi(?int $value): static
    {
        $this->noOfEmi = $value;
        return $this;
    }

    public function getDisbursementAmount(): string
    {
        return $this->disbursementAmount;
    }

    public function setDisbursementAmount(string $value): static
    {
        $this->disbursementAmount = $value;
        return $this;
    }

    public function getFrequency(): ?int
    {
        return $this->frequency;
    }

    public function setFrequency(?int $value): static
    {
        $this->frequency = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getEndDate(): ?DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(?DateTime $value): static
    {
        $this->endDate = $value;
        return $this;
    }

    public function getDueEmi(): string
    {
        return $this->dueEmi;
    }

    public function setDueEmi(string $value): static
    {
        $this->dueEmi = $value;
        return $this;
    }

    public function getBranch(): ?int
    {
        return $this->branch;
    }

    public function setBranch(?int $value): static
    {
        $this->branch = $value;
        return $this;
    }

    public function getMobile(): ?string
    {
        return $this->mobile;
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = $value;
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }
}
