<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "auto_programme" table
 */
#[Entity]
#[Table(name: "auto_programme")]
class AutoProgramme extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    private int $apcid;

    #[Column(type: "string", nullable: true)]
    private ?string $grp;

    #[Column(type: "text")]
    private string $code;

    #[Column(type: "string")]
    private string $description;

    #[Column(name: "last_updated", type: "string", nullable: true)]
    private ?string $lastUpdated;

    #[Column(name: "user_level", type: "string", nullable: true)]
    private ?string $userLevel;

    #[Column(type: "string")]
    private string $id;

    public function __construct()
    {
        $this->userLevel = -1;
    }

    public function getApcid(): int
    {
        return $this->apcid;
    }

    public function setApcid(int $value): static
    {
        $this->apcid = $value;
        return $this;
    }

    public function getGrp(): ?string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(?string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getCode(): string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getDescription(): string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getLastUpdated(): ?string
    {
        return HtmlDecode($this->lastUpdated);
    }

    public function setLastUpdated(?string $value): static
    {
        $this->lastUpdated = RemoveXss($value);
        return $this;
    }

    public function getUserLevel(): ?string
    {
        return HtmlDecode($this->userLevel);
    }

    public function setUserLevel(?string $value): static
    {
        $this->userLevel = RemoveXss($value);
        return $this;
    }

    public function getId(): string
    {
        return HtmlDecode($this->id);
    }

    public function setId(string $value): static
    {
        $this->id = RemoveXss($value);
        return $this;
    }
}
