<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "audittrail_l" table
 */
#[Entity]
#[Table(name: "audittrail_l")]
class AudittrailL extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer")]
    private int $userid;

    #[Column(type: "string")]
    private string $ip;

    #[Column(name: "page_title", type: "string")]
    private string $pageTitle;

    #[Column(type: "string")]
    private string $url;

    #[Column(type: "string")]
    private string $comment;

    #[Column(name: "user_agent", type: "string")]
    private string $userAgent;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getUserid(): int
    {
        return $this->userid;
    }

    public function setUserid(int $value): static
    {
        $this->userid = $value;
        return $this;
    }

    public function getIp(): string
    {
        return HtmlDecode($this->ip);
    }

    public function setIp(string $value): static
    {
        $this->ip = RemoveXss($value);
        return $this;
    }

    public function getPageTitle(): string
    {
        return HtmlDecode($this->pageTitle);
    }

    public function setPageTitle(string $value): static
    {
        $this->pageTitle = RemoveXss($value);
        return $this;
    }

    public function getUrl(): string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getComment(): string
    {
        return HtmlDecode($this->comment);
    }

    public function setComment(string $value): static
    {
        $this->comment = RemoveXss($value);
        return $this;
    }

    public function getUserAgent(): string
    {
        return HtmlDecode($this->userAgent);
    }

    public function setUserAgent(string $value): static
    {
        $this->userAgent = RemoveXss($value);
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
