<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "apc" table
 */
#[Entity]
#[Table(name: "apc")]
class Apc extends AbstractEntity
{
    #[Column(type: "string", unique: true)]
    private string $id;

    #[Id]
    #[Column(type: "smallint", unique: true)]
    private int $apcid;

    #[Column(type: "string", nullable: true)]
    private ?string $grp;

    #[Column(type: "text")]
    private string $code;

    #[Column(type: "string")]
    private string $description;

    #[Column(type: "integer")]
    private int $cron;

    #[Column(name: "next_cycle", type: "datetime")]
    private DateTime $nextCycle;

    #[Column(type: "integer")]
    private int $delay;

    #[Column(name: "delay_method", type: "integer")]
    private int $delayMethod;

    #[Column(name: "last_updated", type: "string", nullable: true)]
    private ?string $lastUpdated;

    #[Column(name: "user_level", type: "string", nullable: true)]
    private ?string $userLevel;

    #[Column(type: "integer")]
    private int $visible;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "order_by", type: "integer")]
    private int $orderBy;

    #[Column(type: "string", nullable: true)]
    private ?string $url;

    public function getId(): string
    {
        return HtmlDecode($this->id);
    }

    public function setId(string $value): static
    {
        $this->id = RemoveXss($value);
        return $this;
    }

    public function getApcid(): int
    {
        return $this->apcid;
    }

    public function setApcid(int $value): static
    {
        $this->apcid = $value;
        return $this;
    }

    public function getGrp(): ?string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(?string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $value): static
    {
        $this->code = $value;
        return $this;
    }

    public function getDescription(): string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getCron(): int
    {
        return $this->cron;
    }

    public function setCron(int $value): static
    {
        $this->cron = $value;
        return $this;
    }

    public function getNextCycle(): DateTime
    {
        return $this->nextCycle;
    }

    public function setNextCycle(DateTime $value): static
    {
        $this->nextCycle = $value;
        return $this;
    }

    public function getDelay(): int
    {
        return $this->delay;
    }

    public function setDelay(int $value): static
    {
        $this->delay = $value;
        return $this;
    }

    public function getDelayMethod(): int
    {
        return $this->delayMethod;
    }

    public function setDelayMethod(int $value): static
    {
        $this->delayMethod = $value;
        return $this;
    }

    public function getLastUpdated(): ?string
    {
        return HtmlDecode($this->lastUpdated);
    }

    public function setLastUpdated(?string $value): static
    {
        $this->lastUpdated = RemoveXss($value);
        return $this;
    }

    public function getUserLevel(): ?string
    {
        return HtmlDecode($this->userLevel);
    }

    public function setUserLevel(?string $value): static
    {
        $this->userLevel = RemoveXss($value);
        return $this;
    }

    public function getVisible(): int
    {
        return $this->visible;
    }

    public function setVisible(int $value): static
    {
        $this->visible = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOrderBy(): int
    {
        return $this->orderBy;
    }

    public function setOrderBy(int $value): static
    {
        $this->orderBy = $value;
        return $this;
    }

    public function getUrl(): ?string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(?string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }
}
