<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "admin" table
 */
#[Entity]
#[Table(name: "`admin`")]
class Admin extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "bigint", nullable: true)]
    private ?string $mobile;

    #[Column(name: "formal_name", type: "string")]
    private string $formalName;

    #[Column(type: "string", nullable: true)]
    private ?string $password;

    #[Column(name: "user_name", type: "string", nullable: true)]
    private ?string $userName;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(type: "integer")]
    private int $category;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(name: "pp_id", type: "string", nullable: true)]
    private ?string $ppId;

    #[Column(type: "string")]
    private string $site;

    #[Column(name: "reports_to", type: "smallint", nullable: true)]
    private ?int $reportsTo;

    #[Column(type: "integer", nullable: true)]
    private ?int $userlevel;

    #[Column(type: "integer", nullable: true)]
    private ?int $activated;

    #[Column(type: "text", nullable: true)]
    private ?string $profile;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "reg_ip", type: "string", nullable: true)]
    private ?string $regIp;

    #[Column(name: "profile_old", type: "text", nullable: true)]
    private ?string $profileOld;

    public function __construct()
    {
        $this->companyId = User_Company_ID();
        $this->userlevel = 0;
        $this->activated = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getMobile(): ?string
    {
        return $this->mobile;
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = $value;
        return $this;
    }

    public function getFormalName(): string
    {
        return HtmlDecode($this->formalName);
    }

    public function setFormalName(string $value): static
    {
        $this->formalName = RemoveXss($value);
        return $this;
    }

    public function getPassword(): ?string
    {
        return HtmlDecode($this->password);
    }

    public function setPassword(?string $value): static
    {
        $this->password = RemoveXss($value);
        return $this;
    }

    public function getUserName(): ?string
    {
        return $this->userName;
    }

    public function setUserName(?string $value): static
    {
        $this->userName = $value;
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getCategory(): int
    {
        return $this->category;
    }

    public function setCategory(int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPpId(): ?string
    {
        return HtmlDecode($this->ppId);
    }

    public function setPpId(?string $value): static
    {
        $this->ppId = RemoveXss($value);
        return $this;
    }

    public function getSite(): string
    {
        return HtmlDecode($this->site);
    }

    public function setSite(string $value): static
    {
        $this->site = RemoveXss($value);
        return $this;
    }

    public function getReportsTo(): ?int
    {
        return $this->reportsTo;
    }

    public function setReportsTo(?int $value): static
    {
        $this->reportsTo = $value;
        return $this;
    }

    public function getUserlevel(): ?int
    {
        return $this->userlevel;
    }

    public function setUserlevel(?int $value): static
    {
        $this->userlevel = $value;
        return $this;
    }

    public function getActivated(): ?int
    {
        return $this->activated;
    }

    public function setActivated(?int $value): static
    {
        $this->activated = $value;
        return $this;
    }

    public function getProfile(): ?string
    {
        return HtmlDecode($this->profile);
    }

    public function setProfile(?string $value): static
    {
        $this->profile = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRegIp(): ?string
    {
        return HtmlDecode($this->regIp);
    }

    public function setRegIp(?string $value): static
    {
        $this->regIp = RemoveXss($value);
        return $this;
    }

    public function getProfileOld(): ?string
    {
        return HtmlDecode($this->profileOld);
    }

    public function setProfileOld(?string $value): static
    {
        $this->profileOld = RemoveXss($value);
        return $this;
    }

    // Get login arguments
    public function getLoginArguments(): array
    {
        return [
            "userName" => $this->get('user_name'),
            "userId" => $this->get('id'),
            "parentUserId" => $this->get('reports_to'),
            "userLevel" => $this->get('userlevel') ?? AdvancedSecurity::ANONYMOUS_USER_LEVEL_ID,
            "userPrimaryKey" => $this->get('id'),
        ];
    }
}
