<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "add_optional" table
 */
#[Entity]
#[Table(name: "add_optional")]
class AddOptional extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $one;

    #[Column(type: "string", nullable: true)]
    private ?string $two;

    #[Column(type: "string", nullable: true)]
    private ?string $three;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getOne(): ?string
    {
        return HtmlDecode($this->one);
    }

    public function setOne(?string $value): static
    {
        $this->one = RemoveXss($value);
        return $this;
    }

    public function getTwo(): ?string
    {
        return HtmlDecode($this->two);
    }

    public function setTwo(?string $value): static
    {
        $this->two = RemoveXss($value);
        return $this;
    }

    public function getThree(): ?string
    {
        return HtmlDecode($this->three);
    }

    public function setThree(?string $value): static
    {
        $this->three = RemoveXss($value);
        return $this;
    }
}
