<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for ww_yarn
 */
class WwYarn extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $yarn;
    public $ply_1_color;
    public $ply_1_qty;
    public $ply_2_color;
    public $ply_2_qty;
    public $ply_3_color;
    public $ply_3_qty;
    public $stock;
    public $operator;
    public $datetime;
    public $moq;
    public $m_stock;
    public $required;
    public $ordered;
    public $pending_order;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "ww_yarn";
        $this->TableName = 'ww_yarn';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "ww_yarn";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // yarn
        $this->yarn = new DbField(
            $this, // Table
            'x_yarn', // Variable name
            'yarn', // Name
            '`yarn`', // Expression
            '`yarn`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`yarn`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->yarn->addMethod("getSelectFilter", fn() => "`s_grp`= 2");
        $this->yarn->InputTextType = "text";
        $this->yarn->setSelectMultiple(false); // Select one
        $this->yarn->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->yarn->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->yarn->Lookup = new Lookup($this->yarn, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->yarn->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['yarn'] = &$this->yarn;

        // ply_1_color
        $this->ply_1_color = new DbField(
            $this, // Table
            'x_ply_1_color', // Variable name
            'ply_1_color', // Name
            '`ply_1_color`', // Expression
            '`ply_1_color`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ply_1_color`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ply_1_color->addMethod("getSelectFilter", fn() => "`status`=1 and `base_color` = 1");
        $this->ply_1_color->addMethod("getDefault", fn() => 0);
        $this->ply_1_color->InputTextType = "text";
        $this->ply_1_color->Raw = true;
        $this->ply_1_color->setSelectMultiple(false); // Select one
        $this->ply_1_color->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ply_1_color->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ply_1_color->Lookup = new Lookup($this->ply_1_color, 'ww_color', false, 'id', ["color","color_source","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "CONCAT(COALESCE(`color`, ''),'" . ValueSeparator(1, $this->ply_1_color) . "',COALESCE(`color_source`,''))");
        $this->ply_1_color->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ply_1_color->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ply_1_color'] = &$this->ply_1_color;

        // ply_1_qty
        $this->ply_1_qty = new DbField(
            $this, // Table
            'x_ply_1_qty', // Variable name
            'ply_1_qty', // Name
            '`ply_1_qty`', // Expression
            '`ply_1_qty`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ply_1_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ply_1_qty->addMethod("getDefault", fn() => 0.00);
        $this->ply_1_qty->InputTextType = "text";
        $this->ply_1_qty->Raw = true;
        $this->ply_1_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ply_1_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ply_1_qty'] = &$this->ply_1_qty;

        // ply_2_color
        $this->ply_2_color = new DbField(
            $this, // Table
            'x_ply_2_color', // Variable name
            'ply_2_color', // Name
            '`ply_2_color`', // Expression
            '`ply_2_color`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ply_2_color`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ply_2_color->addMethod("getSelectFilter", fn() => "`status`=1 and `base_color` = 1");
        $this->ply_2_color->addMethod("getDefault", fn() => 0);
        $this->ply_2_color->InputTextType = "text";
        $this->ply_2_color->Raw = true;
        $this->ply_2_color->setSelectMultiple(false); // Select one
        $this->ply_2_color->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ply_2_color->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ply_2_color->Lookup = new Lookup($this->ply_2_color, 'ww_color', false, 'id', ["color","color_source","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "CONCAT(COALESCE(`color`, ''),'" . ValueSeparator(1, $this->ply_2_color) . "',COALESCE(`color_source`,''))");
        $this->ply_2_color->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ply_2_color->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ply_2_color'] = &$this->ply_2_color;

        // ply_2_qty
        $this->ply_2_qty = new DbField(
            $this, // Table
            'x_ply_2_qty', // Variable name
            'ply_2_qty', // Name
            '`ply_2_qty`', // Expression
            '`ply_2_qty`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ply_2_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ply_2_qty->addMethod("getDefault", fn() => 0.00);
        $this->ply_2_qty->InputTextType = "text";
        $this->ply_2_qty->Raw = true;
        $this->ply_2_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ply_2_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ply_2_qty'] = &$this->ply_2_qty;

        // ply_3_color
        $this->ply_3_color = new DbField(
            $this, // Table
            'x_ply_3_color', // Variable name
            'ply_3_color', // Name
            '`ply_3_color`', // Expression
            '`ply_3_color`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ply_3_color`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ply_3_color->addMethod("getSelectFilter", fn() => "`status`=1 and `base_color` = 1");
        $this->ply_3_color->addMethod("getDefault", fn() => 0);
        $this->ply_3_color->InputTextType = "text";
        $this->ply_3_color->Raw = true;
        $this->ply_3_color->setSelectMultiple(false); // Select one
        $this->ply_3_color->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ply_3_color->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ply_3_color->Lookup = new Lookup($this->ply_3_color, 'ww_color', false, 'id', ["color","color_source","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "CONCAT(COALESCE(`color`, ''),'" . ValueSeparator(1, $this->ply_3_color) . "',COALESCE(`color_source`,''))");
        $this->ply_3_color->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ply_3_color->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ply_3_color'] = &$this->ply_3_color;

        // ply_3_qty
        $this->ply_3_qty = new DbField(
            $this, // Table
            'x_ply_3_qty', // Variable name
            'ply_3_qty', // Name
            '`ply_3_qty`', // Expression
            '`ply_3_qty`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ply_3_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ply_3_qty->addMethod("getDefault", fn() => 0.00);
        $this->ply_3_qty->InputTextType = "text";
        $this->ply_3_qty->Raw = true;
        $this->ply_3_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ply_3_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ply_3_qty'] = &$this->ply_3_qty;

        // stock
        $this->stock = new DbField(
            $this, // Table
            'x_stock', // Variable name
            'stock', // Name
            '`stock`', // Expression
            '`stock`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`stock`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->stock->addMethod("getDefault", fn() => 0.000);
        $this->stock->InputTextType = "text";
        $this->stock->Raw = true;
        $this->stock->Nullable = false; // NOT NULL field
        $this->stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->stock->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['stock'] = &$this->stock;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // moq
        $this->moq = new DbField(
            $this, // Table
            'x_moq', // Variable name
            'moq', // Name
            '`moq`', // Expression
            '`moq`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`moq`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->moq->addMethod("getDefault", fn() => 0.000);
        $this->moq->InputTextType = "text";
        $this->moq->Raw = true;
        $this->moq->Nullable = false; // NOT NULL field
        $this->moq->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->moq->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['moq'] = &$this->moq;

        // m_stock
        $this->m_stock = new DbField(
            $this, // Table
            'x_m_stock', // Variable name
            'm_stock', // Name
            '`m_stock`', // Expression
            '`m_stock`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`m_stock`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->m_stock->addMethod("getDefault", fn() => 0.000);
        $this->m_stock->InputTextType = "text";
        $this->m_stock->Raw = true;
        $this->m_stock->Nullable = false; // NOT NULL field
        $this->m_stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->m_stock->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['m_stock'] = &$this->m_stock;

        // required
        $this->required = new DbField(
            $this, // Table
            'x_required', // Variable name
            'required', // Name
            '`required`', // Expression
            '`required`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`required`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->required->addMethod("getDefault", fn() => 0.000);
        $this->required->InputTextType = "text";
        $this->required->Raw = true;
        $this->required->Nullable = false; // NOT NULL field
        $this->required->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->required->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['required'] = &$this->required;

        // ordered
        $this->ordered = new DbField(
            $this, // Table
            'x_ordered', // Variable name
            'ordered', // Name
            '`ordered`', // Expression
            '`ordered`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ordered`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ordered->addMethod("getDefault", fn() => 0.000);
        $this->ordered->InputTextType = "text";
        $this->ordered->Raw = true;
        $this->ordered->Nullable = false; // NOT NULL field
        $this->ordered->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ordered->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ordered'] = &$this->ordered;

        // pending_order
        $this->pending_order = new DbField(
            $this, // Table
            'x_pending_order', // Variable name
            'pending_order', // Name
            '`pending_order`', // Expression
            '`pending_order`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pending_order`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pending_order->addMethod("getDefault", fn() => 0.000);
        $this->pending_order->InputTextType = "text";
        $this->pending_order->Raw = true;
        $this->pending_order->Nullable = false; // NOT NULL field
        $this->pending_order->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pending_order->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pending_order'] = &$this->pending_order;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "ww_yarn";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->yarn->DbValue = $row['yarn'];
        $this->ply_1_color->DbValue = $row['ply_1_color'];
        $this->ply_1_qty->DbValue = $row['ply_1_qty'];
        $this->ply_2_color->DbValue = $row['ply_2_color'];
        $this->ply_2_qty->DbValue = $row['ply_2_qty'];
        $this->ply_3_color->DbValue = $row['ply_3_color'];
        $this->ply_3_qty->DbValue = $row['ply_3_qty'];
        $this->stock->DbValue = $row['stock'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->moq->DbValue = $row['moq'];
        $this->m_stock->DbValue = $row['m_stock'];
        $this->required->DbValue = $row['required'];
        $this->ordered->DbValue = $row['ordered'];
        $this->pending_order->DbValue = $row['pending_order'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("wwyarnlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "wwyarnview" => $Language->phrase("View"),
            "wwyarnedit" => $Language->phrase("Edit"),
            "wwyarnadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "wwyarnlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "WwYarnView",
            Config("API_ADD_ACTION") => "WwYarnAdd",
            Config("API_EDIT_ACTION") => "WwYarnEdit",
            Config("API_DELETE_ACTION") => "WwYarnDelete",
            Config("API_LIST_ACTION") => "WwYarnList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "wwyarnlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("wwyarnview", $parm);
        } else {
            $url = $this->keyUrl("wwyarnview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "wwyarnadd?" . $parm;
        } else {
            $url = "wwyarnadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("wwyarnedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("wwyarnlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("wwyarnadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("wwyarnlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("wwyarndelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->yarn->setDbValue($row['yarn']);
        $this->ply_1_color->setDbValue($row['ply_1_color']);
        $this->ply_1_qty->setDbValue($row['ply_1_qty']);
        $this->ply_2_color->setDbValue($row['ply_2_color']);
        $this->ply_2_qty->setDbValue($row['ply_2_qty']);
        $this->ply_3_color->setDbValue($row['ply_3_color']);
        $this->ply_3_qty->setDbValue($row['ply_3_qty']);
        $this->stock->setDbValue($row['stock']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->moq->setDbValue($row['moq']);
        $this->m_stock->setDbValue($row['m_stock']);
        $this->required->setDbValue($row['required']);
        $this->ordered->setDbValue($row['ordered']);
        $this->pending_order->setDbValue($row['pending_order']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "WwYarnList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // yarn

        // ply_1_color

        // ply_1_qty

        // ply_2_color

        // ply_2_qty

        // ply_3_color

        // ply_3_qty

        // stock

        // operator

        // datetime

        // moq

        // m_stock

        // required

        // ordered

        // pending_order

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // yarn
        $curVal = strval($this->yarn->CurrentValue);
        if ($curVal != "") {
            $this->yarn->ViewValue = $this->yarn->lookupCacheOption($curVal);
            if ($this->yarn->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->yarn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->yarn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->yarn->getSelectFilter($this); // PHP
                $sqlWrk = $this->yarn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->yarn->Lookup->renderViewRow($rswrk[0]);
                    $this->yarn->ViewValue = $this->yarn->displayValue($arwrk);
                } else {
                    $this->yarn->ViewValue = $this->yarn->CurrentValue;
                }
            }
        } else {
            $this->yarn->ViewValue = null;
        }

        // ply_1_color
        $curVal = strval($this->ply_1_color->CurrentValue);
        if ($curVal != "") {
            $this->ply_1_color->ViewValue = $this->ply_1_color->lookupCacheOption($curVal);
            if ($this->ply_1_color->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ply_1_color->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ply_1_color->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->ply_1_color->getSelectFilter($this); // PHP
                $sqlWrk = $this->ply_1_color->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ply_1_color->Lookup->renderViewRow($rswrk[0]);
                    $this->ply_1_color->ViewValue = $this->ply_1_color->displayValue($arwrk);
                } else {
                    $this->ply_1_color->ViewValue = FormatNumber($this->ply_1_color->CurrentValue, $this->ply_1_color->formatPattern());
                }
            }
        } else {
            $this->ply_1_color->ViewValue = null;
        }

        // ply_1_qty
        $this->ply_1_qty->ViewValue = $this->ply_1_qty->CurrentValue;
        $this->ply_1_qty->ViewValue = FormatNumber($this->ply_1_qty->ViewValue, $this->ply_1_qty->formatPattern());

        // ply_2_color
        $curVal = strval($this->ply_2_color->CurrentValue);
        if ($curVal != "") {
            $this->ply_2_color->ViewValue = $this->ply_2_color->lookupCacheOption($curVal);
            if ($this->ply_2_color->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ply_2_color->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ply_2_color->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->ply_2_color->getSelectFilter($this); // PHP
                $sqlWrk = $this->ply_2_color->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ply_2_color->Lookup->renderViewRow($rswrk[0]);
                    $this->ply_2_color->ViewValue = $this->ply_2_color->displayValue($arwrk);
                } else {
                    $this->ply_2_color->ViewValue = FormatNumber($this->ply_2_color->CurrentValue, $this->ply_2_color->formatPattern());
                }
            }
        } else {
            $this->ply_2_color->ViewValue = null;
        }

        // ply_2_qty
        $this->ply_2_qty->ViewValue = $this->ply_2_qty->CurrentValue;
        $this->ply_2_qty->ViewValue = FormatNumber($this->ply_2_qty->ViewValue, $this->ply_2_qty->formatPattern());

        // ply_3_color
        $curVal = strval($this->ply_3_color->CurrentValue);
        if ($curVal != "") {
            $this->ply_3_color->ViewValue = $this->ply_3_color->lookupCacheOption($curVal);
            if ($this->ply_3_color->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ply_3_color->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ply_3_color->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->ply_3_color->getSelectFilter($this); // PHP
                $sqlWrk = $this->ply_3_color->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ply_3_color->Lookup->renderViewRow($rswrk[0]);
                    $this->ply_3_color->ViewValue = $this->ply_3_color->displayValue($arwrk);
                } else {
                    $this->ply_3_color->ViewValue = FormatNumber($this->ply_3_color->CurrentValue, $this->ply_3_color->formatPattern());
                }
            }
        } else {
            $this->ply_3_color->ViewValue = null;
        }

        // ply_3_qty
        $this->ply_3_qty->ViewValue = $this->ply_3_qty->CurrentValue;
        $this->ply_3_qty->ViewValue = FormatNumber($this->ply_3_qty->ViewValue, $this->ply_3_qty->formatPattern());

        // stock
        $this->stock->ViewValue = $this->stock->CurrentValue;
        $this->stock->ViewValue = FormatNumber($this->stock->ViewValue, $this->stock->formatPattern());

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // moq
        $this->moq->ViewValue = $this->moq->CurrentValue;
        $this->moq->ViewValue = FormatNumber($this->moq->ViewValue, $this->moq->formatPattern());

        // m_stock
        $this->m_stock->ViewValue = $this->m_stock->CurrentValue;
        $this->m_stock->ViewValue = FormatNumber($this->m_stock->ViewValue, $this->m_stock->formatPattern());

        // required
        $this->required->ViewValue = $this->required->CurrentValue;
        $this->required->ViewValue = FormatNumber($this->required->ViewValue, $this->required->formatPattern());

        // ordered
        $this->ordered->ViewValue = $this->ordered->CurrentValue;
        $this->ordered->ViewValue = FormatNumber($this->ordered->ViewValue, $this->ordered->formatPattern());

        // pending_order
        $this->pending_order->ViewValue = $this->pending_order->CurrentValue;
        $this->pending_order->ViewValue = FormatNumber($this->pending_order->ViewValue, $this->pending_order->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // yarn
        $this->yarn->HrefValue = "";
        $this->yarn->TooltipValue = "";

        // ply_1_color
        $this->ply_1_color->HrefValue = "";
        $this->ply_1_color->TooltipValue = "";

        // ply_1_qty
        $this->ply_1_qty->HrefValue = "";
        $this->ply_1_qty->TooltipValue = "";

        // ply_2_color
        $this->ply_2_color->HrefValue = "";
        $this->ply_2_color->TooltipValue = "";

        // ply_2_qty
        $this->ply_2_qty->HrefValue = "";
        $this->ply_2_qty->TooltipValue = "";

        // ply_3_color
        $this->ply_3_color->HrefValue = "";
        $this->ply_3_color->TooltipValue = "";

        // ply_3_qty
        $this->ply_3_qty->HrefValue = "";
        $this->ply_3_qty->TooltipValue = "";

        // stock
        $this->stock->HrefValue = "";
        $this->stock->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // moq
        $this->moq->HrefValue = "";
        $this->moq->TooltipValue = "";

        // m_stock
        $this->m_stock->HrefValue = "";
        $this->m_stock->TooltipValue = "";

        // required
        $this->required->HrefValue = "";
        $this->required->TooltipValue = "";

        // ordered
        $this->ordered->HrefValue = "";
        $this->ordered->TooltipValue = "";

        // pending_order
        $this->pending_order->HrefValue = "";
        $this->pending_order->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // yarn
        $this->yarn->setupEditAttributes();
        $this->yarn->PlaceHolder = RemoveHtml($this->yarn->caption());

        // ply_1_color
        $this->ply_1_color->setupEditAttributes();
        $this->ply_1_color->PlaceHolder = RemoveHtml($this->ply_1_color->caption());

        // ply_1_qty
        $this->ply_1_qty->setupEditAttributes();
        $this->ply_1_qty->EditValue = $this->ply_1_qty->CurrentValue;
        $this->ply_1_qty->PlaceHolder = RemoveHtml($this->ply_1_qty->caption());
        if (strval($this->ply_1_qty->EditValue) != "" && is_numeric($this->ply_1_qty->EditValue)) {
            $this->ply_1_qty->EditValue = FormatNumber($this->ply_1_qty->EditValue, null);
        }

        // ply_2_color
        $this->ply_2_color->setupEditAttributes();
        $this->ply_2_color->PlaceHolder = RemoveHtml($this->ply_2_color->caption());

        // ply_2_qty
        $this->ply_2_qty->setupEditAttributes();
        $this->ply_2_qty->EditValue = $this->ply_2_qty->CurrentValue;
        $this->ply_2_qty->PlaceHolder = RemoveHtml($this->ply_2_qty->caption());
        if (strval($this->ply_2_qty->EditValue) != "" && is_numeric($this->ply_2_qty->EditValue)) {
            $this->ply_2_qty->EditValue = FormatNumber($this->ply_2_qty->EditValue, null);
        }

        // ply_3_color
        $this->ply_3_color->setupEditAttributes();
        $this->ply_3_color->PlaceHolder = RemoveHtml($this->ply_3_color->caption());

        // ply_3_qty
        $this->ply_3_qty->setupEditAttributes();
        $this->ply_3_qty->EditValue = $this->ply_3_qty->CurrentValue;
        $this->ply_3_qty->PlaceHolder = RemoveHtml($this->ply_3_qty->caption());
        if (strval($this->ply_3_qty->EditValue) != "" && is_numeric($this->ply_3_qty->EditValue)) {
            $this->ply_3_qty->EditValue = FormatNumber($this->ply_3_qty->EditValue, null);
        }

        // stock
        $this->stock->setupEditAttributes();
        $this->stock->EditValue = $this->stock->CurrentValue;
        $this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
        if (strval($this->stock->EditValue) != "" && is_numeric($this->stock->EditValue)) {
            $this->stock->EditValue = FormatNumber($this->stock->EditValue, null);
        }

        // operator

        // datetime

        // moq
        $this->moq->setupEditAttributes();
        $this->moq->EditValue = $this->moq->CurrentValue;
        $this->moq->PlaceHolder = RemoveHtml($this->moq->caption());
        if (strval($this->moq->EditValue) != "" && is_numeric($this->moq->EditValue)) {
            $this->moq->EditValue = FormatNumber($this->moq->EditValue, null);
        }

        // m_stock
        $this->m_stock->setupEditAttributes();
        $this->m_stock->EditValue = $this->m_stock->CurrentValue;
        $this->m_stock->PlaceHolder = RemoveHtml($this->m_stock->caption());
        if (strval($this->m_stock->EditValue) != "" && is_numeric($this->m_stock->EditValue)) {
            $this->m_stock->EditValue = FormatNumber($this->m_stock->EditValue, null);
        }

        // required
        $this->required->setupEditAttributes();
        $this->required->EditValue = $this->required->CurrentValue;
        $this->required->PlaceHolder = RemoveHtml($this->required->caption());
        if (strval($this->required->EditValue) != "" && is_numeric($this->required->EditValue)) {
            $this->required->EditValue = FormatNumber($this->required->EditValue, null);
        }

        // ordered
        $this->ordered->setupEditAttributes();
        $this->ordered->EditValue = $this->ordered->CurrentValue;
        $this->ordered->PlaceHolder = RemoveHtml($this->ordered->caption());
        if (strval($this->ordered->EditValue) != "" && is_numeric($this->ordered->EditValue)) {
            $this->ordered->EditValue = FormatNumber($this->ordered->EditValue, null);
        }

        // pending_order
        $this->pending_order->setupEditAttributes();
        $this->pending_order->EditValue = $this->pending_order->CurrentValue;
        $this->pending_order->PlaceHolder = RemoveHtml($this->pending_order->caption());
        if (strval($this->pending_order->EditValue) != "" && is_numeric($this->pending_order->EditValue)) {
            $this->pending_order->EditValue = FormatNumber($this->pending_order->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->yarn);
                    $doc->exportCaption($this->ply_1_color);
                    $doc->exportCaption($this->ply_1_qty);
                    $doc->exportCaption($this->ply_2_color);
                    $doc->exportCaption($this->ply_2_qty);
                    $doc->exportCaption($this->ply_3_color);
                    $doc->exportCaption($this->ply_3_qty);
                    $doc->exportCaption($this->stock);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->moq);
                    $doc->exportCaption($this->m_stock);
                    $doc->exportCaption($this->required);
                    $doc->exportCaption($this->ordered);
                    $doc->exportCaption($this->pending_order);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->yarn);
                    $doc->exportCaption($this->ply_1_color);
                    $doc->exportCaption($this->ply_1_qty);
                    $doc->exportCaption($this->ply_2_color);
                    $doc->exportCaption($this->ply_2_qty);
                    $doc->exportCaption($this->ply_3_color);
                    $doc->exportCaption($this->ply_3_qty);
                    $doc->exportCaption($this->stock);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->moq);
                    $doc->exportCaption($this->m_stock);
                    $doc->exportCaption($this->required);
                    $doc->exportCaption($this->ordered);
                    $doc->exportCaption($this->pending_order);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->yarn);
                        $doc->exportField($this->ply_1_color);
                        $doc->exportField($this->ply_1_qty);
                        $doc->exportField($this->ply_2_color);
                        $doc->exportField($this->ply_2_qty);
                        $doc->exportField($this->ply_3_color);
                        $doc->exportField($this->ply_3_qty);
                        $doc->exportField($this->stock);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->moq);
                        $doc->exportField($this->m_stock);
                        $doc->exportField($this->required);
                        $doc->exportField($this->ordered);
                        $doc->exportField($this->pending_order);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->yarn);
                        $doc->exportField($this->ply_1_color);
                        $doc->exportField($this->ply_1_qty);
                        $doc->exportField($this->ply_2_color);
                        $doc->exportField($this->ply_2_qty);
                        $doc->exportField($this->ply_3_color);
                        $doc->exportField($this->ply_3_qty);
                        $doc->exportField($this->stock);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->moq);
                        $doc->exportField($this->m_stock);
                        $doc->exportField($this->required);
                        $doc->exportField($this->ordered);
                        $doc->exportField($this->pending_order);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
