<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class WwColorReqSearch extends WwColorReq
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "WwColorReqSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "wwcolorreqsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->yarn->setVisibility();
        $this->forcast->setVisibility();
        $this->req_qty->setVisibility();
        $this->standard->setVisibility();
        $this->clariant->setVisibility();
        $this->poddar->setVisibility();
        $this->polyone->setVisibility();
        $this->period->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'ww_color_req';
        $this->TableName = 'ww_color_req';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (ww_color_req)
        if (!isset($GLOBALS["ww_color_req"]) || $GLOBALS["ww_color_req"]::class == PROJECT_NAMESPACE . "ww_color_req") {
            $GLOBALS["ww_color_req"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'ww_color_req');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "wwcolorreqview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->yarn->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->forcast->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->req_qty->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->standard->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->clariant->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->poddar->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->polyone->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->period->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->yarn);
        $this->setupLookupOptions($this->standard);
        $this->setupLookupOptions($this->clariant);
        $this->setupLookupOptions($this->poddar);
        $this->setupLookupOptions($this->polyone);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "wwcolorreqlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->yarn); // yarn
        $this->buildSearchUrl($srchUrl, $this->forcast); // forcast
        $this->buildSearchUrl($srchUrl, $this->req_qty); // req_qty
        $this->buildSearchUrl($srchUrl, $this->standard); // standard
        $this->buildSearchUrl($srchUrl, $this->clariant); // clariant
        $this->buildSearchUrl($srchUrl, $this->poddar); // poddar
        $this->buildSearchUrl($srchUrl, $this->polyone); // polyone
        $this->buildSearchUrl($srchUrl, $this->period); // period
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // yarn
        if ($this->yarn->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->yarn->AdvancedSearch->SearchValue)) {
            $this->yarn->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->yarn->AdvancedSearch->SearchValue);
        }
        if (is_array($this->yarn->AdvancedSearch->SearchValue2)) {
            $this->yarn->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->yarn->AdvancedSearch->SearchValue2);
        }

        // forcast
        if ($this->forcast->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // req_qty
        if ($this->req_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // standard
        if ($this->standard->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // clariant
        if ($this->clariant->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // poddar
        if ($this->poddar->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // polyone
        if ($this->polyone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // period
        if ($this->period->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // yarn
        $this->yarn->RowCssClass = "row";

        // forcast
        $this->forcast->RowCssClass = "row";

        // req_qty
        $this->req_qty->RowCssClass = "row";

        // standard
        $this->standard->RowCssClass = "row";

        // clariant
        $this->clariant->RowCssClass = "row";

        // poddar
        $this->poddar->RowCssClass = "row";

        // polyone
        $this->polyone->RowCssClass = "row";

        // period
        $this->period->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // yarn
            $curVal = strval($this->yarn->CurrentValue);
            if ($curVal != "") {
                $this->yarn->ViewValue = $this->yarn->lookupCacheOption($curVal);
                if ($this->yarn->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->yarn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->yarn->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->yarn->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->yarn->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->yarn->Lookup->renderViewRow($row);
                            $this->yarn->ViewValue->add($this->yarn->displayValue($arwrk));
                        }
                    } else {
                        $this->yarn->ViewValue = $this->yarn->CurrentValue;
                    }
                }
            } else {
                $this->yarn->ViewValue = null;
            }

            // forcast
            $this->forcast->ViewValue = $this->forcast->CurrentValue;
            $this->forcast->ViewValue = FormatNumber($this->forcast->ViewValue, $this->forcast->formatPattern());

            // req_qty
            $this->req_qty->ViewValue = $this->req_qty->CurrentValue;
            $this->req_qty->ViewValue = FormatNumber($this->req_qty->ViewValue, $this->req_qty->formatPattern());

            // standard
            $curVal = strval($this->standard->CurrentValue);
            if ($curVal != "") {
                $this->standard->ViewValue = $this->standard->lookupCacheOption($curVal);
                if ($this->standard->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->standard->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->standard->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->standard->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->standard->Lookup->renderViewRow($rswrk[0]);
                        $this->standard->ViewValue = $this->standard->displayValue($arwrk);
                    } else {
                        $this->standard->ViewValue = FormatNumber($this->standard->CurrentValue, $this->standard->formatPattern());
                    }
                }
            } else {
                $this->standard->ViewValue = null;
            }

            // clariant
            $curVal = strval($this->clariant->CurrentValue);
            if ($curVal != "") {
                $this->clariant->ViewValue = $this->clariant->lookupCacheOption($curVal);
                if ($this->clariant->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->clariant->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->clariant->Lookup->renderViewRow($rswrk[0]);
                        $this->clariant->ViewValue = $this->clariant->displayValue($arwrk);
                    } else {
                        $this->clariant->ViewValue = FormatNumber($this->clariant->CurrentValue, $this->clariant->formatPattern());
                    }
                }
            } else {
                $this->clariant->ViewValue = null;
            }

            // poddar
            $curVal = strval($this->poddar->CurrentValue);
            if ($curVal != "") {
                $this->poddar->ViewValue = $this->poddar->lookupCacheOption($curVal);
                if ($this->poddar->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->poddar->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->poddar->Lookup->renderViewRow($rswrk[0]);
                        $this->poddar->ViewValue = $this->poddar->displayValue($arwrk);
                    } else {
                        $this->poddar->ViewValue = FormatNumber($this->poddar->CurrentValue, $this->poddar->formatPattern());
                    }
                }
            } else {
                $this->poddar->ViewValue = null;
            }

            // polyone
            $curVal = strval($this->polyone->CurrentValue);
            if ($curVal != "") {
                $this->polyone->ViewValue = $this->polyone->lookupCacheOption($curVal);
                if ($this->polyone->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->polyone->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->polyone->Lookup->renderViewRow($rswrk[0]);
                        $this->polyone->ViewValue = $this->polyone->displayValue($arwrk);
                    } else {
                        $this->polyone->ViewValue = FormatNumber($this->polyone->CurrentValue, $this->polyone->formatPattern());
                    }
                }
            } else {
                $this->polyone->ViewValue = null;
            }

            // period
            $this->period->ViewValue = $this->period->CurrentValue;
            $this->period->ViewValue = FormatNumber($this->period->ViewValue, $this->period->formatPattern());

            // yarn
            $this->yarn->HrefValue = "";
            $this->yarn->TooltipValue = "";

            // forcast
            $this->forcast->HrefValue = "";
            $this->forcast->TooltipValue = "";

            // req_qty
            $this->req_qty->HrefValue = "";
            $this->req_qty->TooltipValue = "";

            // standard
            $this->standard->HrefValue = "";
            $this->standard->TooltipValue = "";

            // clariant
            $this->clariant->HrefValue = "";
            $this->clariant->TooltipValue = "";

            // poddar
            $this->poddar->HrefValue = "";
            $this->poddar->TooltipValue = "";

            // polyone
            $this->polyone->HrefValue = "";
            $this->polyone->TooltipValue = "";

            // period
            $this->period->HrefValue = "";
            $this->period->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // yarn
            $this->yarn->setupEditAttributes();
            $curVal = trim(strval($this->yarn->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->yarn->AdvancedSearch->ViewValue = $this->yarn->lookupCacheOption($curVal);
            } else {
                $this->yarn->AdvancedSearch->ViewValue = $this->yarn->Lookup !== null && is_array($this->yarn->lookupOptions()) && count($this->yarn->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->yarn->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->yarn->EditValue = array_values($this->yarn->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->yarn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->yarn->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->yarn->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->yarn->EditValue = $arwrk;
            }
            $this->yarn->PlaceHolder = RemoveHtml($this->yarn->caption());

            // forcast
            $this->forcast->setupEditAttributes();
            $this->forcast->EditValue = $this->forcast->AdvancedSearch->SearchValue;
            $this->forcast->PlaceHolder = RemoveHtml($this->forcast->caption());

            // req_qty
            $this->req_qty->setupEditAttributes();
            $this->req_qty->EditValue = $this->req_qty->AdvancedSearch->SearchValue;
            $this->req_qty->PlaceHolder = RemoveHtml($this->req_qty->caption());

            // standard
            $this->standard->setupEditAttributes();
            $curVal = trim(strval($this->standard->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->standard->AdvancedSearch->ViewValue = $this->standard->lookupCacheOption($curVal);
            } else {
                $this->standard->AdvancedSearch->ViewValue = $this->standard->Lookup !== null && is_array($this->standard->lookupOptions()) && count($this->standard->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->standard->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->standard->EditValue = array_values($this->standard->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->standard->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->standard->AdvancedSearch->SearchValue, $this->standard->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->standard->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->standard->EditValue = $arwrk;
            }
            $this->standard->PlaceHolder = RemoveHtml($this->standard->caption());

            // clariant
            $this->clariant->setupEditAttributes();
            $curVal = trim(strval($this->clariant->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->clariant->AdvancedSearch->ViewValue = $this->clariant->lookupCacheOption($curVal);
            } else {
                $this->clariant->AdvancedSearch->ViewValue = $this->clariant->Lookup !== null && is_array($this->clariant->lookupOptions()) && count($this->clariant->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->clariant->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->clariant->EditValue = array_values($this->clariant->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->clariant->AdvancedSearch->SearchValue, $this->clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->clariant->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->clariant->EditValue = $arwrk;
            }
            $this->clariant->PlaceHolder = RemoveHtml($this->clariant->caption());

            // poddar
            $this->poddar->setupEditAttributes();
            $curVal = trim(strval($this->poddar->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->poddar->AdvancedSearch->ViewValue = $this->poddar->lookupCacheOption($curVal);
            } else {
                $this->poddar->AdvancedSearch->ViewValue = $this->poddar->Lookup !== null && is_array($this->poddar->lookupOptions()) && count($this->poddar->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->poddar->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->poddar->EditValue = array_values($this->poddar->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->poddar->AdvancedSearch->SearchValue, $this->poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->poddar->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->poddar->EditValue = $arwrk;
            }
            $this->poddar->PlaceHolder = RemoveHtml($this->poddar->caption());

            // polyone
            $this->polyone->setupEditAttributes();
            $curVal = trim(strval($this->polyone->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->polyone->AdvancedSearch->ViewValue = $this->polyone->lookupCacheOption($curVal);
            } else {
                $this->polyone->AdvancedSearch->ViewValue = $this->polyone->Lookup !== null && is_array($this->polyone->lookupOptions()) && count($this->polyone->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->polyone->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->polyone->EditValue = array_values($this->polyone->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->polyone->AdvancedSearch->SearchValue, $this->polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->polyone->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->polyone->EditValue = $arwrk;
            }
            $this->polyone->PlaceHolder = RemoveHtml($this->polyone->caption());

            // period
            $this->period->setupEditAttributes();
            $this->period->EditValue = $this->period->AdvancedSearch->SearchValue;
            $this->period->PlaceHolder = RemoveHtml($this->period->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckNumber($this->forcast->AdvancedSearch->SearchValue)) {
            $this->forcast->addErrorMessage($this->forcast->getErrorMessage(false));
        }
        if (!CheckNumber($this->req_qty->AdvancedSearch->SearchValue)) {
            $this->req_qty->addErrorMessage($this->req_qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->period->AdvancedSearch->SearchValue)) {
            $this->period->addErrorMessage($this->period->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->yarn->AdvancedSearch->load();
        $this->forcast->AdvancedSearch->load();
        $this->req_qty->AdvancedSearch->load();
        $this->standard->AdvancedSearch->load();
        $this->clariant->AdvancedSearch->load();
        $this->poddar->AdvancedSearch->load();
        $this->polyone->AdvancedSearch->load();
        $this->period->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("wwcolorreqlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_yarn":
                    break;
                case "x_standard":
                    break;
                case "x_clariant":
                    break;
                case "x_poddar":
                    break;
                case "x_polyone":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
