<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class WwColorReqDetailedSearch extends WwColorReqDetailed
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "WwColorReqDetailedSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "wwcolorreqdetailedsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->yarn->setVisibility();
        $this->consumption_forcast->setVisibility();
        $this->p1_c_qty->setVisibility();
        $this->p1_st->setVisibility();
        $this->p1_clariant->setVisibility();
        $this->p1_poddar->setVisibility();
        $this->p1_polyone->setVisibility();
        $this->p2_c_qty->setVisibility();
        $this->p2_st->setVisibility();
        $this->p2_clariant->setVisibility();
        $this->p2_poddar->setVisibility();
        $this->p2_polyone->setVisibility();
        $this->p3_c_qty->setVisibility();
        $this->p3_st->setVisibility();
        $this->p3_clariant->setVisibility();
        $this->p3_poddar->setVisibility();
        $this->p3_polyone->setVisibility();
        $this->period->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'ww_color_req_detailed';
        $this->TableName = 'ww_color_req_detailed';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (ww_color_req_detailed)
        if (!isset($GLOBALS["ww_color_req_detailed"]) || $GLOBALS["ww_color_req_detailed"]::class == PROJECT_NAMESPACE . "ww_color_req_detailed") {
            $GLOBALS["ww_color_req_detailed"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'ww_color_req_detailed');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "wwcolorreqdetailedview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->yarn);
        $this->setupLookupOptions($this->p1_st);
        $this->setupLookupOptions($this->p1_clariant);
        $this->setupLookupOptions($this->p1_poddar);
        $this->setupLookupOptions($this->p1_polyone);
        $this->setupLookupOptions($this->p2_st);
        $this->setupLookupOptions($this->p2_clariant);
        $this->setupLookupOptions($this->p2_poddar);
        $this->setupLookupOptions($this->p2_polyone);
        $this->setupLookupOptions($this->p3_st);
        $this->setupLookupOptions($this->p3_clariant);
        $this->setupLookupOptions($this->p3_poddar);
        $this->setupLookupOptions($this->p3_polyone);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "wwcolorreqdetailedlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->yarn); // yarn
        $this->buildSearchUrl($srchUrl, $this->consumption_forcast); // consumption_forcast
        $this->buildSearchUrl($srchUrl, $this->p1_c_qty); // p1_c_qty
        $this->buildSearchUrl($srchUrl, $this->p1_st); // p1_st
        $this->buildSearchUrl($srchUrl, $this->p1_clariant); // p1_clariant
        $this->buildSearchUrl($srchUrl, $this->p1_poddar); // p1_poddar
        $this->buildSearchUrl($srchUrl, $this->p1_polyone); // p1_polyone
        $this->buildSearchUrl($srchUrl, $this->p2_c_qty); // p2_c_qty
        $this->buildSearchUrl($srchUrl, $this->p2_st); // p2_st
        $this->buildSearchUrl($srchUrl, $this->p2_clariant); // p2_clariant
        $this->buildSearchUrl($srchUrl, $this->p2_poddar); // p2_poddar
        $this->buildSearchUrl($srchUrl, $this->p2_polyone); // p2_polyone
        $this->buildSearchUrl($srchUrl, $this->p3_c_qty); // p3_c_qty
        $this->buildSearchUrl($srchUrl, $this->p3_st); // p3_st
        $this->buildSearchUrl($srchUrl, $this->p3_clariant); // p3_clariant
        $this->buildSearchUrl($srchUrl, $this->p3_poddar); // p3_poddar
        $this->buildSearchUrl($srchUrl, $this->p3_polyone); // p3_polyone
        $this->buildSearchUrl($srchUrl, $this->period); // period
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // yarn
        if ($this->yarn->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->yarn->AdvancedSearch->SearchValue)) {
            $this->yarn->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->yarn->AdvancedSearch->SearchValue);
        }
        if (is_array($this->yarn->AdvancedSearch->SearchValue2)) {
            $this->yarn->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->yarn->AdvancedSearch->SearchValue2);
        }

        // consumption_forcast
        if ($this->consumption_forcast->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p1_c_qty
        if ($this->p1_c_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p1_st
        if ($this->p1_st->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p1_clariant
        if ($this->p1_clariant->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p1_poddar
        if ($this->p1_poddar->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p1_polyone
        if ($this->p1_polyone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p2_c_qty
        if ($this->p2_c_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p2_st
        if ($this->p2_st->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p2_clariant
        if ($this->p2_clariant->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p2_poddar
        if ($this->p2_poddar->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p2_polyone
        if ($this->p2_polyone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p3_c_qty
        if ($this->p3_c_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p3_st
        if ($this->p3_st->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p3_clariant
        if ($this->p3_clariant->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p3_poddar
        if ($this->p3_poddar->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // p3_polyone
        if ($this->p3_polyone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // period
        if ($this->period->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // yarn
        $this->yarn->RowCssClass = "row";

        // consumption_forcast
        $this->consumption_forcast->RowCssClass = "row";

        // p1_c_qty
        $this->p1_c_qty->RowCssClass = "row";

        // p1_st
        $this->p1_st->RowCssClass = "row";

        // p1_clariant
        $this->p1_clariant->RowCssClass = "row";

        // p1_poddar
        $this->p1_poddar->RowCssClass = "row";

        // p1_polyone
        $this->p1_polyone->RowCssClass = "row";

        // p2_c_qty
        $this->p2_c_qty->RowCssClass = "row";

        // p2_st
        $this->p2_st->RowCssClass = "row";

        // p2_clariant
        $this->p2_clariant->RowCssClass = "row";

        // p2_poddar
        $this->p2_poddar->RowCssClass = "row";

        // p2_polyone
        $this->p2_polyone->RowCssClass = "row";

        // p3_c_qty
        $this->p3_c_qty->RowCssClass = "row";

        // p3_st
        $this->p3_st->RowCssClass = "row";

        // p3_clariant
        $this->p3_clariant->RowCssClass = "row";

        // p3_poddar
        $this->p3_poddar->RowCssClass = "row";

        // p3_polyone
        $this->p3_polyone->RowCssClass = "row";

        // period
        $this->period->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // yarn
            $curVal = strval($this->yarn->CurrentValue);
            if ($curVal != "") {
                $this->yarn->ViewValue = $this->yarn->lookupCacheOption($curVal);
                if ($this->yarn->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->yarn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->yarn->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->yarn->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->yarn->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->yarn->Lookup->renderViewRow($row);
                            $this->yarn->ViewValue->add($this->yarn->displayValue($arwrk));
                        }
                    } else {
                        $this->yarn->ViewValue = $this->yarn->CurrentValue;
                    }
                }
            } else {
                $this->yarn->ViewValue = null;
            }

            // consumption_forcast
            $this->consumption_forcast->ViewValue = $this->consumption_forcast->CurrentValue;
            $this->consumption_forcast->ViewValue = FormatNumber($this->consumption_forcast->ViewValue, $this->consumption_forcast->formatPattern());

            // p1_c_qty
            $this->p1_c_qty->ViewValue = $this->p1_c_qty->CurrentValue;
            $this->p1_c_qty->ViewValue = FormatNumber($this->p1_c_qty->ViewValue, $this->p1_c_qty->formatPattern());

            // p1_st
            $curVal = strval($this->p1_st->CurrentValue);
            if ($curVal != "") {
                $this->p1_st->ViewValue = $this->p1_st->lookupCacheOption($curVal);
                if ($this->p1_st->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p1_st->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p1_st->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p1_st->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p1_st->Lookup->renderViewRow($rswrk[0]);
                        $this->p1_st->ViewValue = $this->p1_st->displayValue($arwrk);
                    } else {
                        $this->p1_st->ViewValue = FormatNumber($this->p1_st->CurrentValue, $this->p1_st->formatPattern());
                    }
                }
            } else {
                $this->p1_st->ViewValue = null;
            }

            // p1_clariant
            $curVal = strval($this->p1_clariant->CurrentValue);
            if ($curVal != "") {
                $this->p1_clariant->ViewValue = $this->p1_clariant->lookupCacheOption($curVal);
                if ($this->p1_clariant->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p1_clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p1_clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p1_clariant->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p1_clariant->Lookup->renderViewRow($rswrk[0]);
                        $this->p1_clariant->ViewValue = $this->p1_clariant->displayValue($arwrk);
                    } else {
                        $this->p1_clariant->ViewValue = FormatNumber($this->p1_clariant->CurrentValue, $this->p1_clariant->formatPattern());
                    }
                }
            } else {
                $this->p1_clariant->ViewValue = null;
            }

            // p1_poddar
            $curVal = strval($this->p1_poddar->CurrentValue);
            if ($curVal != "") {
                $this->p1_poddar->ViewValue = $this->p1_poddar->lookupCacheOption($curVal);
                if ($this->p1_poddar->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p1_poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p1_poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p1_poddar->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p1_poddar->Lookup->renderViewRow($rswrk[0]);
                        $this->p1_poddar->ViewValue = $this->p1_poddar->displayValue($arwrk);
                    } else {
                        $this->p1_poddar->ViewValue = FormatNumber($this->p1_poddar->CurrentValue, $this->p1_poddar->formatPattern());
                    }
                }
            } else {
                $this->p1_poddar->ViewValue = null;
            }

            // p1_polyone
            $curVal = strval($this->p1_polyone->CurrentValue);
            if ($curVal != "") {
                $this->p1_polyone->ViewValue = $this->p1_polyone->lookupCacheOption($curVal);
                if ($this->p1_polyone->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p1_polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p1_polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p1_polyone->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p1_polyone->Lookup->renderViewRow($rswrk[0]);
                        $this->p1_polyone->ViewValue = $this->p1_polyone->displayValue($arwrk);
                    } else {
                        $this->p1_polyone->ViewValue = FormatNumber($this->p1_polyone->CurrentValue, $this->p1_polyone->formatPattern());
                    }
                }
            } else {
                $this->p1_polyone->ViewValue = null;
            }

            // p2_c_qty
            $this->p2_c_qty->ViewValue = $this->p2_c_qty->CurrentValue;
            $this->p2_c_qty->ViewValue = FormatNumber($this->p2_c_qty->ViewValue, $this->p2_c_qty->formatPattern());

            // p2_st
            $curVal = strval($this->p2_st->CurrentValue);
            if ($curVal != "") {
                $this->p2_st->ViewValue = $this->p2_st->lookupCacheOption($curVal);
                if ($this->p2_st->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p2_st->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p2_st->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p2_st->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p2_st->Lookup->renderViewRow($rswrk[0]);
                        $this->p2_st->ViewValue = $this->p2_st->displayValue($arwrk);
                    } else {
                        $this->p2_st->ViewValue = FormatNumber($this->p2_st->CurrentValue, $this->p2_st->formatPattern());
                    }
                }
            } else {
                $this->p2_st->ViewValue = null;
            }

            // p2_clariant
            $curVal = strval($this->p2_clariant->CurrentValue);
            if ($curVal != "") {
                $this->p2_clariant->ViewValue = $this->p2_clariant->lookupCacheOption($curVal);
                if ($this->p2_clariant->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p2_clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p2_clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p2_clariant->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p2_clariant->Lookup->renderViewRow($rswrk[0]);
                        $this->p2_clariant->ViewValue = $this->p2_clariant->displayValue($arwrk);
                    } else {
                        $this->p2_clariant->ViewValue = FormatNumber($this->p2_clariant->CurrentValue, $this->p2_clariant->formatPattern());
                    }
                }
            } else {
                $this->p2_clariant->ViewValue = null;
            }

            // p2_poddar
            $curVal = strval($this->p2_poddar->CurrentValue);
            if ($curVal != "") {
                $this->p2_poddar->ViewValue = $this->p2_poddar->lookupCacheOption($curVal);
                if ($this->p2_poddar->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p2_poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p2_poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p2_poddar->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p2_poddar->Lookup->renderViewRow($rswrk[0]);
                        $this->p2_poddar->ViewValue = $this->p2_poddar->displayValue($arwrk);
                    } else {
                        $this->p2_poddar->ViewValue = FormatNumber($this->p2_poddar->CurrentValue, $this->p2_poddar->formatPattern());
                    }
                }
            } else {
                $this->p2_poddar->ViewValue = null;
            }

            // p2_polyone
            $curVal = strval($this->p2_polyone->CurrentValue);
            if ($curVal != "") {
                $this->p2_polyone->ViewValue = $this->p2_polyone->lookupCacheOption($curVal);
                if ($this->p2_polyone->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p2_polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p2_polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p2_polyone->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p2_polyone->Lookup->renderViewRow($rswrk[0]);
                        $this->p2_polyone->ViewValue = $this->p2_polyone->displayValue($arwrk);
                    } else {
                        $this->p2_polyone->ViewValue = FormatNumber($this->p2_polyone->CurrentValue, $this->p2_polyone->formatPattern());
                    }
                }
            } else {
                $this->p2_polyone->ViewValue = null;
            }

            // p3_c_qty
            $this->p3_c_qty->ViewValue = $this->p3_c_qty->CurrentValue;
            $this->p3_c_qty->ViewValue = FormatNumber($this->p3_c_qty->ViewValue, $this->p3_c_qty->formatPattern());

            // p3_st
            if (strval($this->p3_st->CurrentValue) != "") {
                $this->p3_st->ViewValue = $this->p3_st->optionCaption($this->p3_st->CurrentValue);
            } else {
                $this->p3_st->ViewValue = null;
            }

            // p3_clariant
            $curVal = strval($this->p3_clariant->CurrentValue);
            if ($curVal != "") {
                $this->p3_clariant->ViewValue = $this->p3_clariant->lookupCacheOption($curVal);
                if ($this->p3_clariant->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p3_clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p3_clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p3_clariant->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p3_clariant->Lookup->renderViewRow($rswrk[0]);
                        $this->p3_clariant->ViewValue = $this->p3_clariant->displayValue($arwrk);
                    } else {
                        $this->p3_clariant->ViewValue = FormatNumber($this->p3_clariant->CurrentValue, $this->p3_clariant->formatPattern());
                    }
                }
            } else {
                $this->p3_clariant->ViewValue = null;
            }

            // p3_poddar
            $curVal = strval($this->p3_poddar->CurrentValue);
            if ($curVal != "") {
                $this->p3_poddar->ViewValue = $this->p3_poddar->lookupCacheOption($curVal);
                if ($this->p3_poddar->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p3_poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p3_poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p3_poddar->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p3_poddar->Lookup->renderViewRow($rswrk[0]);
                        $this->p3_poddar->ViewValue = $this->p3_poddar->displayValue($arwrk);
                    } else {
                        $this->p3_poddar->ViewValue = FormatNumber($this->p3_poddar->CurrentValue, $this->p3_poddar->formatPattern());
                    }
                }
            } else {
                $this->p3_poddar->ViewValue = null;
            }

            // p3_polyone
            $curVal = strval($this->p3_polyone->CurrentValue);
            if ($curVal != "") {
                $this->p3_polyone->ViewValue = $this->p3_polyone->lookupCacheOption($curVal);
                if ($this->p3_polyone->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->p3_polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p3_polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->p3_polyone->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->p3_polyone->Lookup->renderViewRow($rswrk[0]);
                        $this->p3_polyone->ViewValue = $this->p3_polyone->displayValue($arwrk);
                    } else {
                        $this->p3_polyone->ViewValue = FormatNumber($this->p3_polyone->CurrentValue, $this->p3_polyone->formatPattern());
                    }
                }
            } else {
                $this->p3_polyone->ViewValue = null;
            }

            // period
            $this->period->ViewValue = $this->period->CurrentValue;
            $this->period->ViewValue = FormatNumber($this->period->ViewValue, $this->period->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // yarn
            $this->yarn->HrefValue = "";
            $this->yarn->TooltipValue = "";

            // consumption_forcast
            $this->consumption_forcast->HrefValue = "";
            $this->consumption_forcast->TooltipValue = "";

            // p1_c_qty
            $this->p1_c_qty->HrefValue = "";
            $this->p1_c_qty->TooltipValue = "";

            // p1_st
            $this->p1_st->HrefValue = "";
            $this->p1_st->TooltipValue = "";

            // p1_clariant
            $this->p1_clariant->HrefValue = "";
            $this->p1_clariant->TooltipValue = "";

            // p1_poddar
            $this->p1_poddar->HrefValue = "";
            $this->p1_poddar->TooltipValue = "";

            // p1_polyone
            $this->p1_polyone->HrefValue = "";
            $this->p1_polyone->TooltipValue = "";

            // p2_c_qty
            $this->p2_c_qty->HrefValue = "";
            $this->p2_c_qty->TooltipValue = "";

            // p2_st
            $this->p2_st->HrefValue = "";
            $this->p2_st->TooltipValue = "";

            // p2_clariant
            $this->p2_clariant->HrefValue = "";
            $this->p2_clariant->TooltipValue = "";

            // p2_poddar
            $this->p2_poddar->HrefValue = "";
            $this->p2_poddar->TooltipValue = "";

            // p2_polyone
            $this->p2_polyone->HrefValue = "";
            $this->p2_polyone->TooltipValue = "";

            // p3_c_qty
            $this->p3_c_qty->HrefValue = "";
            $this->p3_c_qty->TooltipValue = "";

            // p3_st
            $this->p3_st->HrefValue = "";
            $this->p3_st->TooltipValue = "";

            // p3_clariant
            $this->p3_clariant->HrefValue = "";
            $this->p3_clariant->TooltipValue = "";

            // p3_poddar
            $this->p3_poddar->HrefValue = "";
            $this->p3_poddar->TooltipValue = "";

            // p3_polyone
            $this->p3_polyone->HrefValue = "";
            $this->p3_polyone->TooltipValue = "";

            // period
            $this->period->HrefValue = "";
            $this->period->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // yarn
            $this->yarn->setupEditAttributes();
            $curVal = trim(strval($this->yarn->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->yarn->AdvancedSearch->ViewValue = $this->yarn->lookupCacheOption($curVal);
            } else {
                $this->yarn->AdvancedSearch->ViewValue = $this->yarn->Lookup !== null && is_array($this->yarn->lookupOptions()) && count($this->yarn->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->yarn->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->yarn->EditValue = array_values($this->yarn->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->yarn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->yarn->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->yarn->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->yarn->EditValue = $arwrk;
            }
            $this->yarn->PlaceHolder = RemoveHtml($this->yarn->caption());

            // consumption_forcast
            $this->consumption_forcast->setupEditAttributes();
            $this->consumption_forcast->EditValue = $this->consumption_forcast->AdvancedSearch->SearchValue;
            $this->consumption_forcast->PlaceHolder = RemoveHtml($this->consumption_forcast->caption());

            // p1_c_qty
            $this->p1_c_qty->setupEditAttributes();
            $this->p1_c_qty->EditValue = $this->p1_c_qty->AdvancedSearch->SearchValue;
            $this->p1_c_qty->PlaceHolder = RemoveHtml($this->p1_c_qty->caption());

            // p1_st
            $this->p1_st->setupEditAttributes();
            $curVal = trim(strval($this->p1_st->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p1_st->AdvancedSearch->ViewValue = $this->p1_st->lookupCacheOption($curVal);
            } else {
                $this->p1_st->AdvancedSearch->ViewValue = $this->p1_st->Lookup !== null && is_array($this->p1_st->lookupOptions()) && count($this->p1_st->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p1_st->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p1_st->EditValue = array_values($this->p1_st->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p1_st->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p1_st->AdvancedSearch->SearchValue, $this->p1_st->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p1_st->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p1_st->EditValue = $arwrk;
            }
            $this->p1_st->PlaceHolder = RemoveHtml($this->p1_st->caption());

            // p1_clariant
            $this->p1_clariant->setupEditAttributes();
            $curVal = trim(strval($this->p1_clariant->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p1_clariant->AdvancedSearch->ViewValue = $this->p1_clariant->lookupCacheOption($curVal);
            } else {
                $this->p1_clariant->AdvancedSearch->ViewValue = $this->p1_clariant->Lookup !== null && is_array($this->p1_clariant->lookupOptions()) && count($this->p1_clariant->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p1_clariant->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p1_clariant->EditValue = array_values($this->p1_clariant->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p1_clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p1_clariant->AdvancedSearch->SearchValue, $this->p1_clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p1_clariant->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p1_clariant->EditValue = $arwrk;
            }
            $this->p1_clariant->PlaceHolder = RemoveHtml($this->p1_clariant->caption());

            // p1_poddar
            $this->p1_poddar->setupEditAttributes();
            $curVal = trim(strval($this->p1_poddar->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p1_poddar->AdvancedSearch->ViewValue = $this->p1_poddar->lookupCacheOption($curVal);
            } else {
                $this->p1_poddar->AdvancedSearch->ViewValue = $this->p1_poddar->Lookup !== null && is_array($this->p1_poddar->lookupOptions()) && count($this->p1_poddar->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p1_poddar->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p1_poddar->EditValue = array_values($this->p1_poddar->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p1_poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p1_poddar->AdvancedSearch->SearchValue, $this->p1_poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p1_poddar->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p1_poddar->EditValue = $arwrk;
            }
            $this->p1_poddar->PlaceHolder = RemoveHtml($this->p1_poddar->caption());

            // p1_polyone
            $this->p1_polyone->setupEditAttributes();
            $curVal = trim(strval($this->p1_polyone->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p1_polyone->AdvancedSearch->ViewValue = $this->p1_polyone->lookupCacheOption($curVal);
            } else {
                $this->p1_polyone->AdvancedSearch->ViewValue = $this->p1_polyone->Lookup !== null && is_array($this->p1_polyone->lookupOptions()) && count($this->p1_polyone->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p1_polyone->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p1_polyone->EditValue = array_values($this->p1_polyone->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p1_polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p1_polyone->AdvancedSearch->SearchValue, $this->p1_polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p1_polyone->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p1_polyone->EditValue = $arwrk;
            }
            $this->p1_polyone->PlaceHolder = RemoveHtml($this->p1_polyone->caption());

            // p2_c_qty
            $this->p2_c_qty->setupEditAttributes();
            $this->p2_c_qty->EditValue = $this->p2_c_qty->AdvancedSearch->SearchValue;
            $this->p2_c_qty->PlaceHolder = RemoveHtml($this->p2_c_qty->caption());

            // p2_st
            $this->p2_st->setupEditAttributes();
            $curVal = trim(strval($this->p2_st->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p2_st->AdvancedSearch->ViewValue = $this->p2_st->lookupCacheOption($curVal);
            } else {
                $this->p2_st->AdvancedSearch->ViewValue = $this->p2_st->Lookup !== null && is_array($this->p2_st->lookupOptions()) && count($this->p2_st->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p2_st->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p2_st->EditValue = array_values($this->p2_st->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p2_st->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p2_st->AdvancedSearch->SearchValue, $this->p2_st->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p2_st->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p2_st->EditValue = $arwrk;
            }
            $this->p2_st->PlaceHolder = RemoveHtml($this->p2_st->caption());

            // p2_clariant
            $this->p2_clariant->setupEditAttributes();
            $curVal = trim(strval($this->p2_clariant->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p2_clariant->AdvancedSearch->ViewValue = $this->p2_clariant->lookupCacheOption($curVal);
            } else {
                $this->p2_clariant->AdvancedSearch->ViewValue = $this->p2_clariant->Lookup !== null && is_array($this->p2_clariant->lookupOptions()) && count($this->p2_clariant->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p2_clariant->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p2_clariant->EditValue = array_values($this->p2_clariant->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p2_clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p2_clariant->AdvancedSearch->SearchValue, $this->p2_clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p2_clariant->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p2_clariant->EditValue = $arwrk;
            }
            $this->p2_clariant->PlaceHolder = RemoveHtml($this->p2_clariant->caption());

            // p2_poddar
            $this->p2_poddar->setupEditAttributes();
            $curVal = trim(strval($this->p2_poddar->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p2_poddar->AdvancedSearch->ViewValue = $this->p2_poddar->lookupCacheOption($curVal);
            } else {
                $this->p2_poddar->AdvancedSearch->ViewValue = $this->p2_poddar->Lookup !== null && is_array($this->p2_poddar->lookupOptions()) && count($this->p2_poddar->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p2_poddar->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p2_poddar->EditValue = array_values($this->p2_poddar->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p2_poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p2_poddar->AdvancedSearch->SearchValue, $this->p2_poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p2_poddar->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p2_poddar->EditValue = $arwrk;
            }
            $this->p2_poddar->PlaceHolder = RemoveHtml($this->p2_poddar->caption());

            // p2_polyone
            $this->p2_polyone->setupEditAttributes();
            $curVal = trim(strval($this->p2_polyone->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p2_polyone->AdvancedSearch->ViewValue = $this->p2_polyone->lookupCacheOption($curVal);
            } else {
                $this->p2_polyone->AdvancedSearch->ViewValue = $this->p2_polyone->Lookup !== null && is_array($this->p2_polyone->lookupOptions()) && count($this->p2_polyone->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p2_polyone->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p2_polyone->EditValue = array_values($this->p2_polyone->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p2_polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p2_polyone->AdvancedSearch->SearchValue, $this->p2_polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p2_polyone->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p2_polyone->EditValue = $arwrk;
            }
            $this->p2_polyone->PlaceHolder = RemoveHtml($this->p2_polyone->caption());

            // p3_c_qty
            $this->p3_c_qty->setupEditAttributes();
            $this->p3_c_qty->EditValue = $this->p3_c_qty->AdvancedSearch->SearchValue;
            $this->p3_c_qty->PlaceHolder = RemoveHtml($this->p3_c_qty->caption());

            // p3_st
            $this->p3_st->setupEditAttributes();
            $this->p3_st->EditValue = $this->p3_st->options(true);
            $this->p3_st->PlaceHolder = RemoveHtml($this->p3_st->caption());

            // p3_clariant
            $this->p3_clariant->setupEditAttributes();
            $curVal = trim(strval($this->p3_clariant->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p3_clariant->AdvancedSearch->ViewValue = $this->p3_clariant->lookupCacheOption($curVal);
            } else {
                $this->p3_clariant->AdvancedSearch->ViewValue = $this->p3_clariant->Lookup !== null && is_array($this->p3_clariant->lookupOptions()) && count($this->p3_clariant->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p3_clariant->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p3_clariant->EditValue = array_values($this->p3_clariant->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p3_clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p3_clariant->AdvancedSearch->SearchValue, $this->p3_clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p3_clariant->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p3_clariant->EditValue = $arwrk;
            }
            $this->p3_clariant->PlaceHolder = RemoveHtml($this->p3_clariant->caption());

            // p3_poddar
            $this->p3_poddar->setupEditAttributes();
            $curVal = trim(strval($this->p3_poddar->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p3_poddar->AdvancedSearch->ViewValue = $this->p3_poddar->lookupCacheOption($curVal);
            } else {
                $this->p3_poddar->AdvancedSearch->ViewValue = $this->p3_poddar->Lookup !== null && is_array($this->p3_poddar->lookupOptions()) && count($this->p3_poddar->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p3_poddar->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p3_poddar->EditValue = array_values($this->p3_poddar->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p3_poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p3_poddar->AdvancedSearch->SearchValue, $this->p3_poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p3_poddar->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p3_poddar->EditValue = $arwrk;
            }
            $this->p3_poddar->PlaceHolder = RemoveHtml($this->p3_poddar->caption());

            // p3_polyone
            $this->p3_polyone->setupEditAttributes();
            $curVal = trim(strval($this->p3_polyone->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->p3_polyone->AdvancedSearch->ViewValue = $this->p3_polyone->lookupCacheOption($curVal);
            } else {
                $this->p3_polyone->AdvancedSearch->ViewValue = $this->p3_polyone->Lookup !== null && is_array($this->p3_polyone->lookupOptions()) && count($this->p3_polyone->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->p3_polyone->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->p3_polyone->EditValue = array_values($this->p3_polyone->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->p3_polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->p3_polyone->AdvancedSearch->SearchValue, $this->p3_polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->p3_polyone->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->p3_polyone->EditValue = $arwrk;
            }
            $this->p3_polyone->PlaceHolder = RemoveHtml($this->p3_polyone->caption());

            // period
            $this->period->setupEditAttributes();
            $this->period->EditValue = $this->period->AdvancedSearch->SearchValue;
            $this->period->PlaceHolder = RemoveHtml($this->period->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckNumber($this->consumption_forcast->AdvancedSearch->SearchValue)) {
            $this->consumption_forcast->addErrorMessage($this->consumption_forcast->getErrorMessage(false));
        }
        if (!CheckNumber($this->p1_c_qty->AdvancedSearch->SearchValue)) {
            $this->p1_c_qty->addErrorMessage($this->p1_c_qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->p2_c_qty->AdvancedSearch->SearchValue)) {
            $this->p2_c_qty->addErrorMessage($this->p2_c_qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->p3_c_qty->AdvancedSearch->SearchValue)) {
            $this->p3_c_qty->addErrorMessage($this->p3_c_qty->getErrorMessage(false));
        }
        if (!CheckInteger($this->period->AdvancedSearch->SearchValue)) {
            $this->period->addErrorMessage($this->period->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->yarn->AdvancedSearch->load();
        $this->consumption_forcast->AdvancedSearch->load();
        $this->p1_c_qty->AdvancedSearch->load();
        $this->p1_st->AdvancedSearch->load();
        $this->p1_clariant->AdvancedSearch->load();
        $this->p1_poddar->AdvancedSearch->load();
        $this->p1_polyone->AdvancedSearch->load();
        $this->p2_c_qty->AdvancedSearch->load();
        $this->p2_st->AdvancedSearch->load();
        $this->p2_clariant->AdvancedSearch->load();
        $this->p2_poddar->AdvancedSearch->load();
        $this->p2_polyone->AdvancedSearch->load();
        $this->p3_c_qty->AdvancedSearch->load();
        $this->p3_st->AdvancedSearch->load();
        $this->p3_clariant->AdvancedSearch->load();
        $this->p3_poddar->AdvancedSearch->load();
        $this->p3_polyone->AdvancedSearch->load();
        $this->period->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("wwcolorreqdetailedlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_yarn":
                    break;
                case "x_p1_st":
                    break;
                case "x_p1_clariant":
                    break;
                case "x_p1_poddar":
                    break;
                case "x_p1_polyone":
                    break;
                case "x_p2_st":
                    break;
                case "x_p2_clariant":
                    break;
                case "x_p2_poddar":
                    break;
                case "x_p2_polyone":
                    break;
                case "x_p3_st":
                    break;
                case "x_p3_clariant":
                    break;
                case "x_p3_poddar":
                    break;
                case "x_p3_polyone":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
