<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for ww_color_req_detailed
 */
class WwColorReqDetailed extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $yarn;
    public $consumption_forcast;
    public $p1_c_qty;
    public $p1_st;
    public $p1_clariant;
    public $p1_poddar;
    public $p1_polyone;
    public $p2_c_qty;
    public $p2_st;
    public $p2_clariant;
    public $p2_poddar;
    public $p2_polyone;
    public $p3_c_qty;
    public $p3_st;
    public $p3_clariant;
    public $p3_poddar;
    public $p3_polyone;
    public $period;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "ww_color_req_detailed";
        $this->TableName = 'ww_color_req_detailed';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "ww_color_req_detailed";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // yarn
        $this->yarn = new DbField(
            $this, // Table
            'x_yarn', // Variable name
            'yarn', // Name
            '`yarn`', // Expression
            '`yarn`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`yarn`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->yarn->InputTextType = "text";
        $this->yarn->setSelectMultiple(true); // Select multiple
        $this->yarn->Lookup = new Lookup($this->yarn, 'ww_yarn', false, 'id', ["yarn","","",""], '', '', [], [], [], [], [], [], false, '`yarn` ASC', '', "`yarn`");
        $this->yarn->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['yarn'] = &$this->yarn;

        // consumption_forcast
        $this->consumption_forcast = new DbField(
            $this, // Table
            'x_consumption_forcast', // Variable name
            'consumption_forcast', // Name
            '`consumption_forcast`', // Expression
            '`consumption_forcast`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`consumption_forcast`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->consumption_forcast->addMethod("getDefault", fn() => 0);
        $this->consumption_forcast->InputTextType = "text";
        $this->consumption_forcast->Raw = true;
        $this->consumption_forcast->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->consumption_forcast->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['consumption_forcast'] = &$this->consumption_forcast;

        // p1_c_qty
        $this->p1_c_qty = new DbField(
            $this, // Table
            'x_p1_c_qty', // Variable name
            'p1_c_qty', // Name
            '`p1_c_qty`', // Expression
            '`p1_c_qty`', // Basic search expression
            5, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p1_c_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->p1_c_qty->InputTextType = "text";
        $this->p1_c_qty->Raw = true;
        $this->p1_c_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->p1_c_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p1_c_qty'] = &$this->p1_c_qty;

        // p1_st
        $this->p1_st = new DbField(
            $this, // Table
            'x_p1_st', // Variable name
            'p1_st', // Name
            '`p1_st`', // Expression
            '`p1_st`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p1_st`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p1_st->InputTextType = "text";
        $this->p1_st->Raw = true;
        $this->p1_st->setSelectMultiple(false); // Select one
        $this->p1_st->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p1_st->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p1_st->Lookup = new Lookup($this->p1_st, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p1_st->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p1_st->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p1_st'] = &$this->p1_st;

        // p1_clariant
        $this->p1_clariant = new DbField(
            $this, // Table
            'x_p1_clariant', // Variable name
            'p1_clariant', // Name
            '`p1_clariant`', // Expression
            '`p1_clariant`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p1_clariant`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p1_clariant->InputTextType = "text";
        $this->p1_clariant->Raw = true;
        $this->p1_clariant->setSelectMultiple(false); // Select one
        $this->p1_clariant->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p1_clariant->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p1_clariant->Lookup = new Lookup($this->p1_clariant, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p1_clariant->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p1_clariant->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p1_clariant'] = &$this->p1_clariant;

        // p1_poddar
        $this->p1_poddar = new DbField(
            $this, // Table
            'x_p1_poddar', // Variable name
            'p1_poddar', // Name
            '`p1_poddar`', // Expression
            '`p1_poddar`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p1_poddar`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p1_poddar->InputTextType = "text";
        $this->p1_poddar->Raw = true;
        $this->p1_poddar->setSelectMultiple(false); // Select one
        $this->p1_poddar->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p1_poddar->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p1_poddar->Lookup = new Lookup($this->p1_poddar, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p1_poddar->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p1_poddar->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p1_poddar'] = &$this->p1_poddar;

        // p1_polyone
        $this->p1_polyone = new DbField(
            $this, // Table
            'x_p1_polyone', // Variable name
            'p1_polyone', // Name
            '`p1_polyone`', // Expression
            '`p1_polyone`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p1_polyone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p1_polyone->InputTextType = "text";
        $this->p1_polyone->Raw = true;
        $this->p1_polyone->setSelectMultiple(false); // Select one
        $this->p1_polyone->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p1_polyone->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p1_polyone->Lookup = new Lookup($this->p1_polyone, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p1_polyone->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p1_polyone->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p1_polyone'] = &$this->p1_polyone;

        // p2_c_qty
        $this->p2_c_qty = new DbField(
            $this, // Table
            'x_p2_c_qty', // Variable name
            'p2_c_qty', // Name
            '`p2_c_qty`', // Expression
            '`p2_c_qty`', // Basic search expression
            5, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p2_c_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->p2_c_qty->InputTextType = "text";
        $this->p2_c_qty->Raw = true;
        $this->p2_c_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->p2_c_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p2_c_qty'] = &$this->p2_c_qty;

        // p2_st
        $this->p2_st = new DbField(
            $this, // Table
            'x_p2_st', // Variable name
            'p2_st', // Name
            '`p2_st`', // Expression
            '`p2_st`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p2_st`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p2_st->InputTextType = "text";
        $this->p2_st->Raw = true;
        $this->p2_st->setSelectMultiple(false); // Select one
        $this->p2_st->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p2_st->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p2_st->Lookup = new Lookup($this->p2_st, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p2_st->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p2_st->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p2_st'] = &$this->p2_st;

        // p2_clariant
        $this->p2_clariant = new DbField(
            $this, // Table
            'x_p2_clariant', // Variable name
            'p2_clariant', // Name
            '`p2_clariant`', // Expression
            '`p2_clariant`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p2_clariant`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p2_clariant->InputTextType = "text";
        $this->p2_clariant->Raw = true;
        $this->p2_clariant->setSelectMultiple(false); // Select one
        $this->p2_clariant->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p2_clariant->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p2_clariant->Lookup = new Lookup($this->p2_clariant, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p2_clariant->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p2_clariant->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p2_clariant'] = &$this->p2_clariant;

        // p2_poddar
        $this->p2_poddar = new DbField(
            $this, // Table
            'x_p2_poddar', // Variable name
            'p2_poddar', // Name
            '`p2_poddar`', // Expression
            '`p2_poddar`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p2_poddar`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p2_poddar->InputTextType = "text";
        $this->p2_poddar->Raw = true;
        $this->p2_poddar->setSelectMultiple(false); // Select one
        $this->p2_poddar->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p2_poddar->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p2_poddar->Lookup = new Lookup($this->p2_poddar, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p2_poddar->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p2_poddar->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p2_poddar'] = &$this->p2_poddar;

        // p2_polyone
        $this->p2_polyone = new DbField(
            $this, // Table
            'x_p2_polyone', // Variable name
            'p2_polyone', // Name
            '`p2_polyone`', // Expression
            '`p2_polyone`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p2_polyone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p2_polyone->InputTextType = "text";
        $this->p2_polyone->Raw = true;
        $this->p2_polyone->setSelectMultiple(false); // Select one
        $this->p2_polyone->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p2_polyone->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p2_polyone->Lookup = new Lookup($this->p2_polyone, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p2_polyone->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p2_polyone->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p2_polyone'] = &$this->p2_polyone;

        // p3_c_qty
        $this->p3_c_qty = new DbField(
            $this, // Table
            'x_p3_c_qty', // Variable name
            'p3_c_qty', // Name
            '`p3_c_qty`', // Expression
            '`p3_c_qty`', // Basic search expression
            5, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p3_c_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->p3_c_qty->InputTextType = "text";
        $this->p3_c_qty->Raw = true;
        $this->p3_c_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->p3_c_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p3_c_qty'] = &$this->p3_c_qty;

        // p3_st
        $this->p3_st = new DbField(
            $this, // Table
            'x_p3_st', // Variable name
            'p3_st', // Name
            '`p3_st`', // Expression
            '`p3_st`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p3_st`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p3_st->InputTextType = "text";
        $this->p3_st->Raw = true;
        $this->p3_st->setSelectMultiple(false); // Select one
        $this->p3_st->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p3_st->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p3_st->Lookup = new Lookup($this->p3_st, 'ww_color_req_detailed', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->p3_st->OptionCount = 3;
        $this->p3_st->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p3_st'] = &$this->p3_st;

        // p3_clariant
        $this->p3_clariant = new DbField(
            $this, // Table
            'x_p3_clariant', // Variable name
            'p3_clariant', // Name
            '`p3_clariant`', // Expression
            '`p3_clariant`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p3_clariant`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p3_clariant->InputTextType = "text";
        $this->p3_clariant->Raw = true;
        $this->p3_clariant->setSelectMultiple(false); // Select one
        $this->p3_clariant->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p3_clariant->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p3_clariant->Lookup = new Lookup($this->p3_clariant, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p3_clariant->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p3_clariant->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p3_clariant'] = &$this->p3_clariant;

        // p3_poddar
        $this->p3_poddar = new DbField(
            $this, // Table
            'x_p3_poddar', // Variable name
            'p3_poddar', // Name
            '`p3_poddar`', // Expression
            '`p3_poddar`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p3_poddar`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p3_poddar->InputTextType = "text";
        $this->p3_poddar->Raw = true;
        $this->p3_poddar->setSelectMultiple(false); // Select one
        $this->p3_poddar->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p3_poddar->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p3_poddar->Lookup = new Lookup($this->p3_poddar, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p3_poddar->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p3_poddar->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p3_poddar'] = &$this->p3_poddar;

        // p3_polyone
        $this->p3_polyone = new DbField(
            $this, // Table
            'x_p3_polyone', // Variable name
            'p3_polyone', // Name
            '`p3_polyone`', // Expression
            '`p3_polyone`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p3_polyone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->p3_polyone->InputTextType = "text";
        $this->p3_polyone->Raw = true;
        $this->p3_polyone->setSelectMultiple(false); // Select one
        $this->p3_polyone->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->p3_polyone->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->p3_polyone->Lookup = new Lookup($this->p3_polyone, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->p3_polyone->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->p3_polyone->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['p3_polyone'] = &$this->p3_polyone;

        // period
        $this->period = new DbField(
            $this, // Table
            'x_period', // Variable name
            'period', // Name
            '`period`', // Expression
            '`period`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`period`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->period->InputTextType = "text";
        $this->period->Raw = true;
        $this->period->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->period->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['period'] = &$this->period;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "ww_color_req_detailed";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->yarn->DbValue = $row['yarn'];
        $this->consumption_forcast->DbValue = $row['consumption_forcast'];
        $this->p1_c_qty->DbValue = $row['p1_c_qty'];
        $this->p1_st->DbValue = $row['p1_st'];
        $this->p1_clariant->DbValue = $row['p1_clariant'];
        $this->p1_poddar->DbValue = $row['p1_poddar'];
        $this->p1_polyone->DbValue = $row['p1_polyone'];
        $this->p2_c_qty->DbValue = $row['p2_c_qty'];
        $this->p2_st->DbValue = $row['p2_st'];
        $this->p2_clariant->DbValue = $row['p2_clariant'];
        $this->p2_poddar->DbValue = $row['p2_poddar'];
        $this->p2_polyone->DbValue = $row['p2_polyone'];
        $this->p3_c_qty->DbValue = $row['p3_c_qty'];
        $this->p3_st->DbValue = $row['p3_st'];
        $this->p3_clariant->DbValue = $row['p3_clariant'];
        $this->p3_poddar->DbValue = $row['p3_poddar'];
        $this->p3_polyone->DbValue = $row['p3_polyone'];
        $this->period->DbValue = $row['period'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("wwcolorreqdetailedlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "wwcolorreqdetailedview" => $Language->phrase("View"),
            "wwcolorreqdetailededit" => $Language->phrase("Edit"),
            "wwcolorreqdetailedadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "wwcolorreqdetailedlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "WwColorReqDetailedView",
            Config("API_ADD_ACTION") => "WwColorReqDetailedAdd",
            Config("API_EDIT_ACTION") => "WwColorReqDetailedEdit",
            Config("API_DELETE_ACTION") => "WwColorReqDetailedDelete",
            Config("API_LIST_ACTION") => "WwColorReqDetailedList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "wwcolorreqdetailedlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("wwcolorreqdetailedview", $parm);
        } else {
            $url = $this->keyUrl("wwcolorreqdetailedview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "wwcolorreqdetailedadd?" . $parm;
        } else {
            $url = "wwcolorreqdetailedadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("wwcolorreqdetailededit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("wwcolorreqdetailedlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("wwcolorreqdetailedadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("wwcolorreqdetailedlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("wwcolorreqdetaileddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->yarn->setDbValue($row['yarn']);
        $this->consumption_forcast->setDbValue($row['consumption_forcast']);
        $this->p1_c_qty->setDbValue($row['p1_c_qty']);
        $this->p1_st->setDbValue($row['p1_st']);
        $this->p1_clariant->setDbValue($row['p1_clariant']);
        $this->p1_poddar->setDbValue($row['p1_poddar']);
        $this->p1_polyone->setDbValue($row['p1_polyone']);
        $this->p2_c_qty->setDbValue($row['p2_c_qty']);
        $this->p2_st->setDbValue($row['p2_st']);
        $this->p2_clariant->setDbValue($row['p2_clariant']);
        $this->p2_poddar->setDbValue($row['p2_poddar']);
        $this->p2_polyone->setDbValue($row['p2_polyone']);
        $this->p3_c_qty->setDbValue($row['p3_c_qty']);
        $this->p3_st->setDbValue($row['p3_st']);
        $this->p3_clariant->setDbValue($row['p3_clariant']);
        $this->p3_poddar->setDbValue($row['p3_poddar']);
        $this->p3_polyone->setDbValue($row['p3_polyone']);
        $this->period->setDbValue($row['period']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "WwColorReqDetailedList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // yarn

        // consumption_forcast

        // p1_c_qty

        // p1_st

        // p1_clariant

        // p1_poddar

        // p1_polyone

        // p2_c_qty

        // p2_st

        // p2_clariant

        // p2_poddar

        // p2_polyone

        // p3_c_qty

        // p3_st

        // p3_clariant

        // p3_poddar

        // p3_polyone

        // period

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // yarn
        $curVal = strval($this->yarn->CurrentValue);
        if ($curVal != "") {
            $this->yarn->ViewValue = $this->yarn->lookupCacheOption($curVal);
            if ($this->yarn->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->yarn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->yarn->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->yarn->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->yarn->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->yarn->Lookup->renderViewRow($row);
                        $this->yarn->ViewValue->add($this->yarn->displayValue($arwrk));
                    }
                } else {
                    $this->yarn->ViewValue = $this->yarn->CurrentValue;
                }
            }
        } else {
            $this->yarn->ViewValue = null;
        }

        // consumption_forcast
        $this->consumption_forcast->ViewValue = $this->consumption_forcast->CurrentValue;
        $this->consumption_forcast->ViewValue = FormatNumber($this->consumption_forcast->ViewValue, $this->consumption_forcast->formatPattern());

        // p1_c_qty
        $this->p1_c_qty->ViewValue = $this->p1_c_qty->CurrentValue;
        $this->p1_c_qty->ViewValue = FormatNumber($this->p1_c_qty->ViewValue, $this->p1_c_qty->formatPattern());

        // p1_st
        $curVal = strval($this->p1_st->CurrentValue);
        if ($curVal != "") {
            $this->p1_st->ViewValue = $this->p1_st->lookupCacheOption($curVal);
            if ($this->p1_st->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p1_st->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p1_st->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p1_st->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p1_st->Lookup->renderViewRow($rswrk[0]);
                    $this->p1_st->ViewValue = $this->p1_st->displayValue($arwrk);
                } else {
                    $this->p1_st->ViewValue = FormatNumber($this->p1_st->CurrentValue, $this->p1_st->formatPattern());
                }
            }
        } else {
            $this->p1_st->ViewValue = null;
        }

        // p1_clariant
        $curVal = strval($this->p1_clariant->CurrentValue);
        if ($curVal != "") {
            $this->p1_clariant->ViewValue = $this->p1_clariant->lookupCacheOption($curVal);
            if ($this->p1_clariant->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p1_clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p1_clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p1_clariant->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p1_clariant->Lookup->renderViewRow($rswrk[0]);
                    $this->p1_clariant->ViewValue = $this->p1_clariant->displayValue($arwrk);
                } else {
                    $this->p1_clariant->ViewValue = FormatNumber($this->p1_clariant->CurrentValue, $this->p1_clariant->formatPattern());
                }
            }
        } else {
            $this->p1_clariant->ViewValue = null;
        }

        // p1_poddar
        $curVal = strval($this->p1_poddar->CurrentValue);
        if ($curVal != "") {
            $this->p1_poddar->ViewValue = $this->p1_poddar->lookupCacheOption($curVal);
            if ($this->p1_poddar->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p1_poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p1_poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p1_poddar->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p1_poddar->Lookup->renderViewRow($rswrk[0]);
                    $this->p1_poddar->ViewValue = $this->p1_poddar->displayValue($arwrk);
                } else {
                    $this->p1_poddar->ViewValue = FormatNumber($this->p1_poddar->CurrentValue, $this->p1_poddar->formatPattern());
                }
            }
        } else {
            $this->p1_poddar->ViewValue = null;
        }

        // p1_polyone
        $curVal = strval($this->p1_polyone->CurrentValue);
        if ($curVal != "") {
            $this->p1_polyone->ViewValue = $this->p1_polyone->lookupCacheOption($curVal);
            if ($this->p1_polyone->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p1_polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p1_polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p1_polyone->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p1_polyone->Lookup->renderViewRow($rswrk[0]);
                    $this->p1_polyone->ViewValue = $this->p1_polyone->displayValue($arwrk);
                } else {
                    $this->p1_polyone->ViewValue = FormatNumber($this->p1_polyone->CurrentValue, $this->p1_polyone->formatPattern());
                }
            }
        } else {
            $this->p1_polyone->ViewValue = null;
        }

        // p2_c_qty
        $this->p2_c_qty->ViewValue = $this->p2_c_qty->CurrentValue;
        $this->p2_c_qty->ViewValue = FormatNumber($this->p2_c_qty->ViewValue, $this->p2_c_qty->formatPattern());

        // p2_st
        $curVal = strval($this->p2_st->CurrentValue);
        if ($curVal != "") {
            $this->p2_st->ViewValue = $this->p2_st->lookupCacheOption($curVal);
            if ($this->p2_st->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p2_st->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p2_st->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p2_st->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p2_st->Lookup->renderViewRow($rswrk[0]);
                    $this->p2_st->ViewValue = $this->p2_st->displayValue($arwrk);
                } else {
                    $this->p2_st->ViewValue = FormatNumber($this->p2_st->CurrentValue, $this->p2_st->formatPattern());
                }
            }
        } else {
            $this->p2_st->ViewValue = null;
        }

        // p2_clariant
        $curVal = strval($this->p2_clariant->CurrentValue);
        if ($curVal != "") {
            $this->p2_clariant->ViewValue = $this->p2_clariant->lookupCacheOption($curVal);
            if ($this->p2_clariant->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p2_clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p2_clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p2_clariant->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p2_clariant->Lookup->renderViewRow($rswrk[0]);
                    $this->p2_clariant->ViewValue = $this->p2_clariant->displayValue($arwrk);
                } else {
                    $this->p2_clariant->ViewValue = FormatNumber($this->p2_clariant->CurrentValue, $this->p2_clariant->formatPattern());
                }
            }
        } else {
            $this->p2_clariant->ViewValue = null;
        }

        // p2_poddar
        $curVal = strval($this->p2_poddar->CurrentValue);
        if ($curVal != "") {
            $this->p2_poddar->ViewValue = $this->p2_poddar->lookupCacheOption($curVal);
            if ($this->p2_poddar->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p2_poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p2_poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p2_poddar->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p2_poddar->Lookup->renderViewRow($rswrk[0]);
                    $this->p2_poddar->ViewValue = $this->p2_poddar->displayValue($arwrk);
                } else {
                    $this->p2_poddar->ViewValue = FormatNumber($this->p2_poddar->CurrentValue, $this->p2_poddar->formatPattern());
                }
            }
        } else {
            $this->p2_poddar->ViewValue = null;
        }

        // p2_polyone
        $curVal = strval($this->p2_polyone->CurrentValue);
        if ($curVal != "") {
            $this->p2_polyone->ViewValue = $this->p2_polyone->lookupCacheOption($curVal);
            if ($this->p2_polyone->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p2_polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p2_polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p2_polyone->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p2_polyone->Lookup->renderViewRow($rswrk[0]);
                    $this->p2_polyone->ViewValue = $this->p2_polyone->displayValue($arwrk);
                } else {
                    $this->p2_polyone->ViewValue = FormatNumber($this->p2_polyone->CurrentValue, $this->p2_polyone->formatPattern());
                }
            }
        } else {
            $this->p2_polyone->ViewValue = null;
        }

        // p3_c_qty
        $this->p3_c_qty->ViewValue = $this->p3_c_qty->CurrentValue;
        $this->p3_c_qty->ViewValue = FormatNumber($this->p3_c_qty->ViewValue, $this->p3_c_qty->formatPattern());

        // p3_st
        if (strval($this->p3_st->CurrentValue) != "") {
            $this->p3_st->ViewValue = $this->p3_st->optionCaption($this->p3_st->CurrentValue);
        } else {
            $this->p3_st->ViewValue = null;
        }

        // p3_clariant
        $curVal = strval($this->p3_clariant->CurrentValue);
        if ($curVal != "") {
            $this->p3_clariant->ViewValue = $this->p3_clariant->lookupCacheOption($curVal);
            if ($this->p3_clariant->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p3_clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p3_clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p3_clariant->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p3_clariant->Lookup->renderViewRow($rswrk[0]);
                    $this->p3_clariant->ViewValue = $this->p3_clariant->displayValue($arwrk);
                } else {
                    $this->p3_clariant->ViewValue = FormatNumber($this->p3_clariant->CurrentValue, $this->p3_clariant->formatPattern());
                }
            }
        } else {
            $this->p3_clariant->ViewValue = null;
        }

        // p3_poddar
        $curVal = strval($this->p3_poddar->CurrentValue);
        if ($curVal != "") {
            $this->p3_poddar->ViewValue = $this->p3_poddar->lookupCacheOption($curVal);
            if ($this->p3_poddar->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p3_poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p3_poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p3_poddar->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p3_poddar->Lookup->renderViewRow($rswrk[0]);
                    $this->p3_poddar->ViewValue = $this->p3_poddar->displayValue($arwrk);
                } else {
                    $this->p3_poddar->ViewValue = FormatNumber($this->p3_poddar->CurrentValue, $this->p3_poddar->formatPattern());
                }
            }
        } else {
            $this->p3_poddar->ViewValue = null;
        }

        // p3_polyone
        $curVal = strval($this->p3_polyone->CurrentValue);
        if ($curVal != "") {
            $this->p3_polyone->ViewValue = $this->p3_polyone->lookupCacheOption($curVal);
            if ($this->p3_polyone->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->p3_polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->p3_polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->p3_polyone->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->p3_polyone->Lookup->renderViewRow($rswrk[0]);
                    $this->p3_polyone->ViewValue = $this->p3_polyone->displayValue($arwrk);
                } else {
                    $this->p3_polyone->ViewValue = FormatNumber($this->p3_polyone->CurrentValue, $this->p3_polyone->formatPattern());
                }
            }
        } else {
            $this->p3_polyone->ViewValue = null;
        }

        // period
        $this->period->ViewValue = $this->period->CurrentValue;
        $this->period->ViewValue = FormatNumber($this->period->ViewValue, $this->period->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // yarn
        $this->yarn->HrefValue = "";
        $this->yarn->TooltipValue = "";

        // consumption_forcast
        $this->consumption_forcast->HrefValue = "";
        $this->consumption_forcast->TooltipValue = "";

        // p1_c_qty
        $this->p1_c_qty->HrefValue = "";
        $this->p1_c_qty->TooltipValue = "";

        // p1_st
        $this->p1_st->HrefValue = "";
        $this->p1_st->TooltipValue = "";

        // p1_clariant
        $this->p1_clariant->HrefValue = "";
        $this->p1_clariant->TooltipValue = "";

        // p1_poddar
        $this->p1_poddar->HrefValue = "";
        $this->p1_poddar->TooltipValue = "";

        // p1_polyone
        $this->p1_polyone->HrefValue = "";
        $this->p1_polyone->TooltipValue = "";

        // p2_c_qty
        $this->p2_c_qty->HrefValue = "";
        $this->p2_c_qty->TooltipValue = "";

        // p2_st
        $this->p2_st->HrefValue = "";
        $this->p2_st->TooltipValue = "";

        // p2_clariant
        $this->p2_clariant->HrefValue = "";
        $this->p2_clariant->TooltipValue = "";

        // p2_poddar
        $this->p2_poddar->HrefValue = "";
        $this->p2_poddar->TooltipValue = "";

        // p2_polyone
        $this->p2_polyone->HrefValue = "";
        $this->p2_polyone->TooltipValue = "";

        // p3_c_qty
        $this->p3_c_qty->HrefValue = "";
        $this->p3_c_qty->TooltipValue = "";

        // p3_st
        $this->p3_st->HrefValue = "";
        $this->p3_st->TooltipValue = "";

        // p3_clariant
        $this->p3_clariant->HrefValue = "";
        $this->p3_clariant->TooltipValue = "";

        // p3_poddar
        $this->p3_poddar->HrefValue = "";
        $this->p3_poddar->TooltipValue = "";

        // p3_polyone
        $this->p3_polyone->HrefValue = "";
        $this->p3_polyone->TooltipValue = "";

        // period
        $this->period->HrefValue = "";
        $this->period->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // yarn
        $this->yarn->setupEditAttributes();
        $this->yarn->PlaceHolder = RemoveHtml($this->yarn->caption());

        // consumption_forcast
        $this->consumption_forcast->setupEditAttributes();
        $this->consumption_forcast->EditValue = $this->consumption_forcast->CurrentValue;
        $this->consumption_forcast->PlaceHolder = RemoveHtml($this->consumption_forcast->caption());
        if (strval($this->consumption_forcast->EditValue) != "" && is_numeric($this->consumption_forcast->EditValue)) {
            $this->consumption_forcast->EditValue = FormatNumber($this->consumption_forcast->EditValue, null);
        }

        // p1_c_qty
        $this->p1_c_qty->setupEditAttributes();
        $this->p1_c_qty->EditValue = $this->p1_c_qty->CurrentValue;
        $this->p1_c_qty->PlaceHolder = RemoveHtml($this->p1_c_qty->caption());
        if (strval($this->p1_c_qty->EditValue) != "" && is_numeric($this->p1_c_qty->EditValue)) {
            $this->p1_c_qty->EditValue = FormatNumber($this->p1_c_qty->EditValue, null);
        }

        // p1_st
        $this->p1_st->setupEditAttributes();
        $this->p1_st->PlaceHolder = RemoveHtml($this->p1_st->caption());

        // p1_clariant
        $this->p1_clariant->setupEditAttributes();
        $this->p1_clariant->PlaceHolder = RemoveHtml($this->p1_clariant->caption());

        // p1_poddar
        $this->p1_poddar->setupEditAttributes();
        $this->p1_poddar->PlaceHolder = RemoveHtml($this->p1_poddar->caption());

        // p1_polyone
        $this->p1_polyone->setupEditAttributes();
        $this->p1_polyone->PlaceHolder = RemoveHtml($this->p1_polyone->caption());

        // p2_c_qty
        $this->p2_c_qty->setupEditAttributes();
        $this->p2_c_qty->EditValue = $this->p2_c_qty->CurrentValue;
        $this->p2_c_qty->PlaceHolder = RemoveHtml($this->p2_c_qty->caption());
        if (strval($this->p2_c_qty->EditValue) != "" && is_numeric($this->p2_c_qty->EditValue)) {
            $this->p2_c_qty->EditValue = FormatNumber($this->p2_c_qty->EditValue, null);
        }

        // p2_st
        $this->p2_st->setupEditAttributes();
        $this->p2_st->PlaceHolder = RemoveHtml($this->p2_st->caption());

        // p2_clariant
        $this->p2_clariant->setupEditAttributes();
        $this->p2_clariant->PlaceHolder = RemoveHtml($this->p2_clariant->caption());

        // p2_poddar
        $this->p2_poddar->setupEditAttributes();
        $this->p2_poddar->PlaceHolder = RemoveHtml($this->p2_poddar->caption());

        // p2_polyone
        $this->p2_polyone->setupEditAttributes();
        $this->p2_polyone->PlaceHolder = RemoveHtml($this->p2_polyone->caption());

        // p3_c_qty
        $this->p3_c_qty->setupEditAttributes();
        $this->p3_c_qty->EditValue = $this->p3_c_qty->CurrentValue;
        $this->p3_c_qty->PlaceHolder = RemoveHtml($this->p3_c_qty->caption());
        if (strval($this->p3_c_qty->EditValue) != "" && is_numeric($this->p3_c_qty->EditValue)) {
            $this->p3_c_qty->EditValue = FormatNumber($this->p3_c_qty->EditValue, null);
        }

        // p3_st
        $this->p3_st->setupEditAttributes();
        $this->p3_st->EditValue = $this->p3_st->options(true);
        $this->p3_st->PlaceHolder = RemoveHtml($this->p3_st->caption());

        // p3_clariant
        $this->p3_clariant->setupEditAttributes();
        $this->p3_clariant->PlaceHolder = RemoveHtml($this->p3_clariant->caption());

        // p3_poddar
        $this->p3_poddar->setupEditAttributes();
        $this->p3_poddar->PlaceHolder = RemoveHtml($this->p3_poddar->caption());

        // p3_polyone
        $this->p3_polyone->setupEditAttributes();
        $this->p3_polyone->PlaceHolder = RemoveHtml($this->p3_polyone->caption());

        // period
        $this->period->setupEditAttributes();
        $this->period->EditValue = $this->period->CurrentValue;
        $this->period->PlaceHolder = RemoveHtml($this->period->caption());
        if (strval($this->period->EditValue) != "" && is_numeric($this->period->EditValue)) {
            $this->period->EditValue = FormatNumber($this->period->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->yarn);
                    $doc->exportCaption($this->consumption_forcast);
                    $doc->exportCaption($this->p1_c_qty);
                    $doc->exportCaption($this->p1_st);
                    $doc->exportCaption($this->p1_clariant);
                    $doc->exportCaption($this->p1_poddar);
                    $doc->exportCaption($this->p1_polyone);
                    $doc->exportCaption($this->p2_c_qty);
                    $doc->exportCaption($this->p2_st);
                    $doc->exportCaption($this->p2_clariant);
                    $doc->exportCaption($this->p2_poddar);
                    $doc->exportCaption($this->p2_polyone);
                    $doc->exportCaption($this->p3_c_qty);
                    $doc->exportCaption($this->p3_st);
                    $doc->exportCaption($this->p3_clariant);
                    $doc->exportCaption($this->p3_poddar);
                    $doc->exportCaption($this->p3_polyone);
                    $doc->exportCaption($this->period);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->yarn);
                    $doc->exportCaption($this->consumption_forcast);
                    $doc->exportCaption($this->p1_c_qty);
                    $doc->exportCaption($this->p1_st);
                    $doc->exportCaption($this->p1_clariant);
                    $doc->exportCaption($this->p1_poddar);
                    $doc->exportCaption($this->p1_polyone);
                    $doc->exportCaption($this->p2_c_qty);
                    $doc->exportCaption($this->p2_st);
                    $doc->exportCaption($this->p2_clariant);
                    $doc->exportCaption($this->p2_poddar);
                    $doc->exportCaption($this->p2_polyone);
                    $doc->exportCaption($this->p3_c_qty);
                    $doc->exportCaption($this->p3_st);
                    $doc->exportCaption($this->p3_clariant);
                    $doc->exportCaption($this->p3_poddar);
                    $doc->exportCaption($this->p3_polyone);
                    $doc->exportCaption($this->period);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->yarn);
                        $doc->exportField($this->consumption_forcast);
                        $doc->exportField($this->p1_c_qty);
                        $doc->exportField($this->p1_st);
                        $doc->exportField($this->p1_clariant);
                        $doc->exportField($this->p1_poddar);
                        $doc->exportField($this->p1_polyone);
                        $doc->exportField($this->p2_c_qty);
                        $doc->exportField($this->p2_st);
                        $doc->exportField($this->p2_clariant);
                        $doc->exportField($this->p2_poddar);
                        $doc->exportField($this->p2_polyone);
                        $doc->exportField($this->p3_c_qty);
                        $doc->exportField($this->p3_st);
                        $doc->exportField($this->p3_clariant);
                        $doc->exportField($this->p3_poddar);
                        $doc->exportField($this->p3_polyone);
                        $doc->exportField($this->period);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->yarn);
                        $doc->exportField($this->consumption_forcast);
                        $doc->exportField($this->p1_c_qty);
                        $doc->exportField($this->p1_st);
                        $doc->exportField($this->p1_clariant);
                        $doc->exportField($this->p1_poddar);
                        $doc->exportField($this->p1_polyone);
                        $doc->exportField($this->p2_c_qty);
                        $doc->exportField($this->p2_st);
                        $doc->exportField($this->p2_clariant);
                        $doc->exportField($this->p2_poddar);
                        $doc->exportField($this->p2_polyone);
                        $doc->exportField($this->p3_c_qty);
                        $doc->exportField($this->p3_st);
                        $doc->exportField($this->p3_clariant);
                        $doc->exportField($this->p3_poddar);
                        $doc->exportField($this->p3_polyone);
                        $doc->exportField($this->period);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
