<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for ww_color
 */
class WwColor extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $color;
    public $color_source;
    public $base_color;
    public $match_clariant;
    public $match_poddar;
    public $match_polyone;
    public $moq;
    public $m_stock;
    public $stock;
    public $required;
    public $ordered;
    public $pending_order;
    public $status;
    public $operator;
    public $datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "ww_color";
        $this->TableName = 'ww_color';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "ww_color";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // color
        $this->color = new DbField(
            $this, // Table
            'x_color', // Variable name
            'color', // Name
            '`color`', // Expression
            '`color`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`color`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->color->InputTextType = "text";
        $this->color->Required = true; // Required field
        $this->color->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['color'] = &$this->color;

        // color_source
        $this->color_source = new DbField(
            $this, // Table
            'x_color_source', // Variable name
            'color_source', // Name
            '`color_source`', // Expression
            '`color_source`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`color_source`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->color_source->InputTextType = "text";
        $this->color_source->Required = true; // Required field
        $this->color_source->setSelectMultiple(false); // Select one
        $this->color_source->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->color_source->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->color_source->Lookup = new Lookup($this->color_source, 'ww_color', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->color_source->OptionCount = 3;
        $this->color_source->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['color_source'] = &$this->color_source;

        // base_color
        $this->base_color = new DbField(
            $this, // Table
            'x_base_color', // Variable name
            'base_color', // Name
            '`base_color`', // Expression
            '`base_color`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`base_color`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->base_color->addMethod("getDefault", fn() => 0);
        $this->base_color->InputTextType = "text";
        $this->base_color->Raw = true;
        $this->base_color->Nullable = false; // NOT NULL field
        $this->base_color->setSelectMultiple(false); // Select one
        $this->base_color->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->base_color->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->base_color->Lookup = new Lookup($this->base_color, 'ww_color', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->base_color->OptionCount = 2;
        $this->base_color->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->base_color->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['base_color'] = &$this->base_color;

        // match_clariant
        $this->match_clariant = new DbField(
            $this, // Table
            'x_match_clariant', // Variable name
            'match_clariant', // Name
            '`match_clariant`', // Expression
            '`match_clariant`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`match_clariant`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->match_clariant->addMethod("getSelectFilter", fn() => "`color_source` = 'Clariant' or `id` = 0");
        $this->match_clariant->InputTextType = "text";
        $this->match_clariant->Raw = true;
        $this->match_clariant->Nullable = false; // NOT NULL field
        $this->match_clariant->Required = true; // Required field
        $this->match_clariant->setSelectMultiple(false); // Select one
        $this->match_clariant->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->match_clariant->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->match_clariant->Lookup = new Lookup($this->match_clariant, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->match_clariant->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->match_clariant->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['match_clariant'] = &$this->match_clariant;

        // match_poddar
        $this->match_poddar = new DbField(
            $this, // Table
            'x_match_poddar', // Variable name
            'match_poddar', // Name
            '`match_poddar`', // Expression
            '`match_poddar`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`match_poddar`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->match_poddar->addMethod("getSelectFilter", fn() => "`color_source` =  'Poddar' or `id` = 0");
        $this->match_poddar->InputTextType = "text";
        $this->match_poddar->Raw = true;
        $this->match_poddar->Nullable = false; // NOT NULL field
        $this->match_poddar->Required = true; // Required field
        $this->match_poddar->setSelectMultiple(false); // Select one
        $this->match_poddar->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->match_poddar->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->match_poddar->Lookup = new Lookup($this->match_poddar, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->match_poddar->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->match_poddar->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['match_poddar'] = &$this->match_poddar;

        // match_polyone
        $this->match_polyone = new DbField(
            $this, // Table
            'x_match_polyone', // Variable name
            'match_polyone', // Name
            '`match_polyone`', // Expression
            '`match_polyone`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`match_polyone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->match_polyone->addMethod("getSelectFilter", fn() => "`color_source` =  'Polyone' or `id` = 0");
        $this->match_polyone->InputTextType = "text";
        $this->match_polyone->Raw = true;
        $this->match_polyone->Nullable = false; // NOT NULL field
        $this->match_polyone->Required = true; // Required field
        $this->match_polyone->setSelectMultiple(false); // Select one
        $this->match_polyone->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->match_polyone->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->match_polyone->Lookup = new Lookup($this->match_polyone, 'ww_color', false, 'id', ["color","","",""], '', '', [], [], [], [], [], [], false, '`color` ASC', '', "`color`");
        $this->match_polyone->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->match_polyone->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['match_polyone'] = &$this->match_polyone;

        // moq
        $this->moq = new DbField(
            $this, // Table
            'x_moq', // Variable name
            'moq', // Name
            '`moq`', // Expression
            '`moq`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`moq`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->moq->addMethod("getDefault", fn() => 0);
        $this->moq->InputTextType = "text";
        $this->moq->Raw = true;
        $this->moq->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->moq->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['moq'] = &$this->moq;

        // m_stock
        $this->m_stock = new DbField(
            $this, // Table
            'x_m_stock', // Variable name
            'm_stock', // Name
            '`m_stock`', // Expression
            '`m_stock`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`m_stock`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->m_stock->addMethod("getDefault", fn() => 0);
        $this->m_stock->InputTextType = "text";
        $this->m_stock->Raw = true;
        $this->m_stock->Nullable = false; // NOT NULL field
        $this->m_stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->m_stock->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['m_stock'] = &$this->m_stock;

        // stock
        $this->stock = new DbField(
            $this, // Table
            'x_stock', // Variable name
            'stock', // Name
            '`stock`', // Expression
            '`stock`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`stock`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->stock->addMethod("getDefault", fn() => 0);
        $this->stock->InputTextType = "text";
        $this->stock->Raw = true;
        $this->stock->Nullable = false; // NOT NULL field
        $this->stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->stock->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['stock'] = &$this->stock;

        // required
        $this->required = new DbField(
            $this, // Table
            'x_required', // Variable name
            'required', // Name
            '`required`', // Expression
            '`required`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`required`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->required->addMethod("getDefault", fn() => 0);
        $this->required->InputTextType = "text";
        $this->required->Raw = true;
        $this->required->Nullable = false; // NOT NULL field
        $this->required->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->required->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['required'] = &$this->required;

        // ordered
        $this->ordered = new DbField(
            $this, // Table
            'x_ordered', // Variable name
            'ordered', // Name
            '`ordered`', // Expression
            '`ordered`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ordered`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ordered->addMethod("getDefault", fn() => 0);
        $this->ordered->InputTextType = "text";
        $this->ordered->Raw = true;
        $this->ordered->Nullable = false; // NOT NULL field
        $this->ordered->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ordered->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ordered'] = &$this->ordered;

        // pending_order
        $this->pending_order = new DbField(
            $this, // Table
            'x_pending_order', // Variable name
            'pending_order', // Name
            '`pending_order`', // Expression
            '`pending_order`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pending_order`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pending_order->addMethod("getDefault", fn() => 0);
        $this->pending_order->InputTextType = "text";
        $this->pending_order->Raw = true;
        $this->pending_order->Nullable = false; // NOT NULL field
        $this->pending_order->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pending_order->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pending_order'] = &$this->pending_order;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 1);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'ww_color', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "ww_color";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->color->DbValue = $row['color'];
        $this->color_source->DbValue = $row['color_source'];
        $this->base_color->DbValue = $row['base_color'];
        $this->match_clariant->DbValue = $row['match_clariant'];
        $this->match_poddar->DbValue = $row['match_poddar'];
        $this->match_polyone->DbValue = $row['match_polyone'];
        $this->moq->DbValue = $row['moq'];
        $this->m_stock->DbValue = $row['m_stock'];
        $this->stock->DbValue = $row['stock'];
        $this->required->DbValue = $row['required'];
        $this->ordered->DbValue = $row['ordered'];
        $this->pending_order->DbValue = $row['pending_order'];
        $this->status->DbValue = $row['status'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("wwcolorlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "wwcolorview" => $Language->phrase("View"),
            "wwcoloredit" => $Language->phrase("Edit"),
            "wwcoloradd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "wwcolorlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "WwColorView",
            Config("API_ADD_ACTION") => "WwColorAdd",
            Config("API_EDIT_ACTION") => "WwColorEdit",
            Config("API_DELETE_ACTION") => "WwColorDelete",
            Config("API_LIST_ACTION") => "WwColorList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "wwcolorlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("wwcolorview", $parm);
        } else {
            $url = $this->keyUrl("wwcolorview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "wwcoloradd?" . $parm;
        } else {
            $url = "wwcoloradd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("wwcoloredit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("wwcolorlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("wwcoloradd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("wwcolorlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("wwcolordelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->color->setDbValue($row['color']);
        $this->color_source->setDbValue($row['color_source']);
        $this->base_color->setDbValue($row['base_color']);
        $this->match_clariant->setDbValue($row['match_clariant']);
        $this->match_poddar->setDbValue($row['match_poddar']);
        $this->match_polyone->setDbValue($row['match_polyone']);
        $this->moq->setDbValue($row['moq']);
        $this->m_stock->setDbValue($row['m_stock']);
        $this->stock->setDbValue($row['stock']);
        $this->required->setDbValue($row['required']);
        $this->ordered->setDbValue($row['ordered']);
        $this->pending_order->setDbValue($row['pending_order']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "WwColorList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // color

        // color_source

        // base_color

        // match_clariant

        // match_poddar

        // match_polyone

        // moq

        // m_stock

        // stock

        // required

        // ordered

        // pending_order

        // status

        // operator

        // datetime

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // color
        $this->color->ViewValue = $this->color->CurrentValue;

        // color_source
        if (strval($this->color_source->CurrentValue) != "") {
            $this->color_source->ViewValue = $this->color_source->optionCaption($this->color_source->CurrentValue);
        } else {
            $this->color_source->ViewValue = null;
        }

        // base_color
        if (strval($this->base_color->CurrentValue) != "") {
            $this->base_color->ViewValue = $this->base_color->optionCaption($this->base_color->CurrentValue);
        } else {
            $this->base_color->ViewValue = null;
        }

        // match_clariant
        $curVal = strval($this->match_clariant->CurrentValue);
        if ($curVal != "") {
            $this->match_clariant->ViewValue = $this->match_clariant->lookupCacheOption($curVal);
            if ($this->match_clariant->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->match_clariant->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->match_clariant->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->match_clariant->getSelectFilter($this); // PHP
                $sqlWrk = $this->match_clariant->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->match_clariant->Lookup->renderViewRow($rswrk[0]);
                    $this->match_clariant->ViewValue = $this->match_clariant->displayValue($arwrk);
                } else {
                    $this->match_clariant->ViewValue = FormatNumber($this->match_clariant->CurrentValue, $this->match_clariant->formatPattern());
                }
            }
        } else {
            $this->match_clariant->ViewValue = null;
        }

        // match_poddar
        $curVal = strval($this->match_poddar->CurrentValue);
        if ($curVal != "") {
            $this->match_poddar->ViewValue = $this->match_poddar->lookupCacheOption($curVal);
            if ($this->match_poddar->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->match_poddar->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->match_poddar->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->match_poddar->getSelectFilter($this); // PHP
                $sqlWrk = $this->match_poddar->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->match_poddar->Lookup->renderViewRow($rswrk[0]);
                    $this->match_poddar->ViewValue = $this->match_poddar->displayValue($arwrk);
                } else {
                    $this->match_poddar->ViewValue = FormatNumber($this->match_poddar->CurrentValue, $this->match_poddar->formatPattern());
                }
            }
        } else {
            $this->match_poddar->ViewValue = null;
        }

        // match_polyone
        $curVal = strval($this->match_polyone->CurrentValue);
        if ($curVal != "") {
            $this->match_polyone->ViewValue = $this->match_polyone->lookupCacheOption($curVal);
            if ($this->match_polyone->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->match_polyone->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->match_polyone->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->match_polyone->getSelectFilter($this); // PHP
                $sqlWrk = $this->match_polyone->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->match_polyone->Lookup->renderViewRow($rswrk[0]);
                    $this->match_polyone->ViewValue = $this->match_polyone->displayValue($arwrk);
                } else {
                    $this->match_polyone->ViewValue = FormatNumber($this->match_polyone->CurrentValue, $this->match_polyone->formatPattern());
                }
            }
        } else {
            $this->match_polyone->ViewValue = null;
        }

        // moq
        $this->moq->ViewValue = $this->moq->CurrentValue;
        $this->moq->ViewValue = FormatNumber($this->moq->ViewValue, $this->moq->formatPattern());

        // m_stock
        $this->m_stock->ViewValue = $this->m_stock->CurrentValue;
        $this->m_stock->ViewValue = FormatNumber($this->m_stock->ViewValue, $this->m_stock->formatPattern());

        // stock
        $this->stock->ViewValue = $this->stock->CurrentValue;
        $this->stock->ViewValue = FormatNumber($this->stock->ViewValue, $this->stock->formatPattern());

        // required
        $this->required->ViewValue = $this->required->CurrentValue;
        $this->required->ViewValue = FormatNumber($this->required->ViewValue, $this->required->formatPattern());

        // ordered
        $this->ordered->ViewValue = $this->ordered->CurrentValue;
        $this->ordered->ViewValue = FormatNumber($this->ordered->ViewValue, $this->ordered->formatPattern());

        // pending_order
        $this->pending_order->ViewValue = $this->pending_order->CurrentValue;
        $this->pending_order->ViewValue = FormatNumber($this->pending_order->ViewValue, $this->pending_order->formatPattern());

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // color
        $this->color->HrefValue = "";
        $this->color->TooltipValue = "";

        // color_source
        $this->color_source->HrefValue = "";
        $this->color_source->TooltipValue = "";

        // base_color
        $this->base_color->HrefValue = "";
        $this->base_color->TooltipValue = "";

        // match_clariant
        $this->match_clariant->HrefValue = "";
        $this->match_clariant->TooltipValue = "";

        // match_poddar
        $this->match_poddar->HrefValue = "";
        $this->match_poddar->TooltipValue = "";

        // match_polyone
        $this->match_polyone->HrefValue = "";
        $this->match_polyone->TooltipValue = "";

        // moq
        $this->moq->HrefValue = "";
        $this->moq->TooltipValue = "";

        // m_stock
        $this->m_stock->HrefValue = "";
        $this->m_stock->TooltipValue = "";

        // stock
        $this->stock->HrefValue = "";
        $this->stock->TooltipValue = "";

        // required
        $this->required->HrefValue = "";
        $this->required->TooltipValue = "";

        // ordered
        $this->ordered->HrefValue = "";
        $this->ordered->TooltipValue = "";

        // pending_order
        $this->pending_order->HrefValue = "";
        $this->pending_order->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // color
        $this->color->setupEditAttributes();
        if (!$this->color->Raw) {
            $this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
        }
        $this->color->EditValue = $this->color->CurrentValue;
        $this->color->PlaceHolder = RemoveHtml($this->color->caption());

        // color_source
        $this->color_source->setupEditAttributes();
        $this->color_source->EditValue = $this->color_source->options(true);
        $this->color_source->PlaceHolder = RemoveHtml($this->color_source->caption());

        // base_color
        $this->base_color->setupEditAttributes();
        $this->base_color->EditValue = $this->base_color->options(true);
        $this->base_color->PlaceHolder = RemoveHtml($this->base_color->caption());

        // match_clariant
        $this->match_clariant->setupEditAttributes();
        $this->match_clariant->PlaceHolder = RemoveHtml($this->match_clariant->caption());

        // match_poddar
        $this->match_poddar->setupEditAttributes();
        $this->match_poddar->PlaceHolder = RemoveHtml($this->match_poddar->caption());

        // match_polyone
        $this->match_polyone->setupEditAttributes();
        $this->match_polyone->PlaceHolder = RemoveHtml($this->match_polyone->caption());

        // moq
        $this->moq->setupEditAttributes();
        $this->moq->EditValue = $this->moq->CurrentValue;
        $this->moq->PlaceHolder = RemoveHtml($this->moq->caption());
        if (strval($this->moq->EditValue) != "" && is_numeric($this->moq->EditValue)) {
            $this->moq->EditValue = FormatNumber($this->moq->EditValue, null);
        }

        // m_stock
        $this->m_stock->setupEditAttributes();
        $this->m_stock->EditValue = $this->m_stock->CurrentValue;
        $this->m_stock->PlaceHolder = RemoveHtml($this->m_stock->caption());
        if (strval($this->m_stock->EditValue) != "" && is_numeric($this->m_stock->EditValue)) {
            $this->m_stock->EditValue = FormatNumber($this->m_stock->EditValue, null);
        }

        // stock
        $this->stock->setupEditAttributes();
        $this->stock->EditValue = $this->stock->CurrentValue;
        $this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
        if (strval($this->stock->EditValue) != "" && is_numeric($this->stock->EditValue)) {
            $this->stock->EditValue = FormatNumber($this->stock->EditValue, null);
        }

        // required
        $this->required->setupEditAttributes();
        $this->required->EditValue = $this->required->CurrentValue;
        $this->required->PlaceHolder = RemoveHtml($this->required->caption());
        if (strval($this->required->EditValue) != "" && is_numeric($this->required->EditValue)) {
            $this->required->EditValue = FormatNumber($this->required->EditValue, null);
        }

        // ordered
        $this->ordered->setupEditAttributes();
        $this->ordered->EditValue = $this->ordered->CurrentValue;
        $this->ordered->PlaceHolder = RemoveHtml($this->ordered->caption());
        if (strval($this->ordered->EditValue) != "" && is_numeric($this->ordered->EditValue)) {
            $this->ordered->EditValue = FormatNumber($this->ordered->EditValue, null);
        }

        // pending_order
        $this->pending_order->setupEditAttributes();
        $this->pending_order->EditValue = $this->pending_order->CurrentValue;
        $this->pending_order->PlaceHolder = RemoveHtml($this->pending_order->caption());
        if (strval($this->pending_order->EditValue) != "" && is_numeric($this->pending_order->EditValue)) {
            $this->pending_order->EditValue = FormatNumber($this->pending_order->EditValue, null);
        }

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // operator

        // datetime

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->color);
                    $doc->exportCaption($this->color_source);
                    $doc->exportCaption($this->base_color);
                    $doc->exportCaption($this->match_clariant);
                    $doc->exportCaption($this->match_poddar);
                    $doc->exportCaption($this->match_polyone);
                    $doc->exportCaption($this->moq);
                    $doc->exportCaption($this->m_stock);
                    $doc->exportCaption($this->stock);
                    $doc->exportCaption($this->required);
                    $doc->exportCaption($this->ordered);
                    $doc->exportCaption($this->pending_order);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->color);
                    $doc->exportCaption($this->color_source);
                    $doc->exportCaption($this->base_color);
                    $doc->exportCaption($this->match_clariant);
                    $doc->exportCaption($this->match_poddar);
                    $doc->exportCaption($this->match_polyone);
                    $doc->exportCaption($this->moq);
                    $doc->exportCaption($this->m_stock);
                    $doc->exportCaption($this->stock);
                    $doc->exportCaption($this->required);
                    $doc->exportCaption($this->ordered);
                    $doc->exportCaption($this->pending_order);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->color);
                        $doc->exportField($this->color_source);
                        $doc->exportField($this->base_color);
                        $doc->exportField($this->match_clariant);
                        $doc->exportField($this->match_poddar);
                        $doc->exportField($this->match_polyone);
                        $doc->exportField($this->moq);
                        $doc->exportField($this->m_stock);
                        $doc->exportField($this->stock);
                        $doc->exportField($this->required);
                        $doc->exportField($this->ordered);
                        $doc->exportField($this->pending_order);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->color);
                        $doc->exportField($this->color_source);
                        $doc->exportField($this->base_color);
                        $doc->exportField($this->match_clariant);
                        $doc->exportField($this->match_poddar);
                        $doc->exportField($this->match_polyone);
                        $doc->exportField($this->moq);
                        $doc->exportField($this->m_stock);
                        $doc->exportField($this->stock);
                        $doc->exportField($this->required);
                        $doc->exportField($this->ordered);
                        $doc->exportField($this->pending_order);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
