<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for ww
 */
class Ww extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $ID;
    public $sno;
    public $_sort;
    public $s_id;
    public $shade;
    public $consumption;
    public $forecast;
    public $percent;
    public $per;
    public $c_id;
    public $clairant;
    public $Field7;
    public $p_id;
    public $poddar;
    public $po_id;
    public $polyone;
    public $supplier;
    public $QTYFOR3MONTHSFORCAST;
    public $MBNumber;
    public $Company;
    public $Required;
    public $Field15;
    public $CURRENTSTOCK;
    public $ORDERED;
    public $LeadTime;
    public $StockWk;
    public $Field20;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "ww";
        $this->TableName = 'ww';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "ww";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ID
        $this->ID = new DbField(
            $this, // Table
            'x_ID', // Variable name
            'ID', // Name
            '`ID`', // Expression
            '`ID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->ID->InputTextType = "text";
        $this->ID->Raw = true;
        $this->ID->IsAutoIncrement = true; // Autoincrement field
        $this->ID->IsPrimaryKey = true; // Primary key field
        $this->ID->Nullable = false; // NOT NULL field
        $this->ID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ID->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ID'] = &$this->ID;

        // sno
        $this->sno = new DbField(
            $this, // Table
            'x_sno', // Variable name
            'sno', // Name
            '`sno`', // Expression
            '`sno`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sno`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sno->InputTextType = "text";
        $this->sno->Raw = true;
        $this->sno->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sno->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sno'] = &$this->sno;

        // sort
        $this->_sort = new DbField(
            $this, // Table
            'x__sort', // Variable name
            'sort', // Name
            '`sort`', // Expression
            '`sort`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sort`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_sort->InputTextType = "text";
        $this->_sort->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sort'] = &$this->_sort;

        // s_id
        $this->s_id = new DbField(
            $this, // Table
            'x_s_id', // Variable name
            's_id', // Name
            '`s_id`', // Expression
            '`s_id`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->s_id->InputTextType = "text";
        $this->s_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_id'] = &$this->s_id;

        // shade
        $this->shade = new DbField(
            $this, // Table
            'x_shade', // Variable name
            'shade', // Name
            '`shade`', // Expression
            '`shade`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shade`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->shade->InputTextType = "text";
        $this->shade->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['shade'] = &$this->shade;

        // consumption
        $this->consumption = new DbField(
            $this, // Table
            'x_consumption', // Variable name
            'consumption', // Name
            '`consumption`', // Expression
            '`consumption`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`consumption`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->consumption->InputTextType = "text";
        $this->consumption->Raw = true;
        $this->consumption->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->consumption->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['consumption'] = &$this->consumption;

        // forecast
        $this->forecast = new DbField(
            $this, // Table
            'x_forecast', // Variable name
            'forecast', // Name
            '`forecast`', // Expression
            '`forecast`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`forecast`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->forecast->InputTextType = "text";
        $this->forecast->Raw = true;
        $this->forecast->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->forecast->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['forecast'] = &$this->forecast;

        // percent
        $this->percent = new DbField(
            $this, // Table
            'x_percent', // Variable name
            'percent', // Name
            '`percent`', // Expression
            '`percent`', // Basic search expression
            131, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`percent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->percent->addMethod("getDefault", fn() => 0.000);
        $this->percent->InputTextType = "text";
        $this->percent->Raw = true;
        $this->percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->percent->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['percent'] = &$this->percent;

        // per
        $this->per = new DbField(
            $this, // Table
            'x_per', // Variable name
            'per', // Name
            '`per`', // Expression
            '`per`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`per`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->per->InputTextType = "text";
        $this->per->Raw = true;
        $this->per->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->per->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['per'] = &$this->per;

        // c_id
        $this->c_id = new DbField(
            $this, // Table
            'x_c_id', // Variable name
            'c_id', // Name
            '`c_id`', // Expression
            '`c_id`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`c_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->c_id->InputTextType = "text";
        $this->c_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['c_id'] = &$this->c_id;

        // clairant
        $this->clairant = new DbField(
            $this, // Table
            'x_clairant', // Variable name
            'clairant', // Name
            '`clairant`', // Expression
            '`clairant`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`clairant`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->clairant->InputTextType = "text";
        $this->clairant->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['clairant'] = &$this->clairant;

        // Field7
        $this->Field7 = new DbField(
            $this, // Table
            'x_Field7', // Variable name
            'Field7', // Name
            '`Field7`', // Expression
            '`Field7`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Field7`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Field7->InputTextType = "text";
        $this->Field7->Raw = true;
        $this->Field7->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Field7->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Field7'] = &$this->Field7;

        // p_id
        $this->p_id = new DbField(
            $this, // Table
            'x_p_id', // Variable name
            'p_id', // Name
            '`p_id`', // Expression
            '`p_id`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`p_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->p_id->InputTextType = "text";
        $this->p_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['p_id'] = &$this->p_id;

        // poddar
        $this->poddar = new DbField(
            $this, // Table
            'x_poddar', // Variable name
            'poddar', // Name
            '`poddar`', // Expression
            '`poddar`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`poddar`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->poddar->InputTextType = "text";
        $this->poddar->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['poddar'] = &$this->poddar;

        // po_id
        $this->po_id = new DbField(
            $this, // Table
            'x_po_id', // Variable name
            'po_id', // Name
            '`po_id`', // Expression
            '`po_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_id->InputTextType = "text";
        $this->po_id->Raw = true;
        $this->po_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_id'] = &$this->po_id;

        // polyone
        $this->polyone = new DbField(
            $this, // Table
            'x_polyone', // Variable name
            'polyone', // Name
            '`polyone`', // Expression
            '`polyone`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`polyone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->polyone->InputTextType = "text";
        $this->polyone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['polyone'] = &$this->polyone;

        // supplier
        $this->supplier = new DbField(
            $this, // Table
            'x_supplier', // Variable name
            'supplier', // Name
            '`supplier`', // Expression
            '`supplier`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`supplier`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->supplier->InputTextType = "text";
        $this->supplier->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['supplier'] = &$this->supplier;

        // QTY FOR 3 MONTHS FORCAST
        $this->QTYFOR3MONTHSFORCAST = new DbField(
            $this, // Table
            'x_QTYFOR3MONTHSFORCAST', // Variable name
            'QTY FOR 3 MONTHS FORCAST', // Name
            '`QTY FOR 3 MONTHS FORCAST`', // Expression
            '`QTY FOR 3 MONTHS FORCAST`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`QTY FOR 3 MONTHS FORCAST`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->QTYFOR3MONTHSFORCAST->InputTextType = "text";
        $this->QTYFOR3MONTHSFORCAST->Raw = true;
        $this->QTYFOR3MONTHSFORCAST->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->QTYFOR3MONTHSFORCAST->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['QTY FOR 3 MONTHS FORCAST'] = &$this->QTYFOR3MONTHSFORCAST;

        // MB Number
        $this->MBNumber = new DbField(
            $this, // Table
            'x_MBNumber', // Variable name
            'MB Number', // Name
            '`MB Number`', // Expression
            '`MB Number`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MB Number`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MBNumber->InputTextType = "text";
        $this->MBNumber->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['MB Number'] = &$this->MBNumber;

        // Company
        $this->Company = new DbField(
            $this, // Table
            'x_Company', // Variable name
            'Company', // Name
            '`Company`', // Expression
            '`Company`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Company`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Company->InputTextType = "text";
        $this->Company->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Company'] = &$this->Company;

        // Required
        $this->Required = new DbField(
            $this, // Table
            'x_Required', // Variable name
            'Required', // Name
            '`Required`', // Expression
            '`Required`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Required`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Required->InputTextType = "text";
        $this->Required->Raw = true;
        $this->Required->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Required->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Required'] = &$this->Required;

        // Field15
        $this->Field15 = new DbField(
            $this, // Table
            'x_Field15', // Variable name
            'Field15', // Name
            '`Field15`', // Expression
            '`Field15`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Field15`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Field15->InputTextType = "text";
        $this->Field15->Raw = true;
        $this->Field15->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Field15->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Field15'] = &$this->Field15;

        // CURRENT STOCK
        $this->CURRENTSTOCK = new DbField(
            $this, // Table
            'x_CURRENTSTOCK', // Variable name
            'CURRENT STOCK', // Name
            '`CURRENT STOCK`', // Expression
            '`CURRENT STOCK`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`CURRENT STOCK`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->CURRENTSTOCK->InputTextType = "text";
        $this->CURRENTSTOCK->Raw = true;
        $this->CURRENTSTOCK->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->CURRENTSTOCK->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['CURRENT STOCK'] = &$this->CURRENTSTOCK;

        // ORDERED
        $this->ORDERED = new DbField(
            $this, // Table
            'x_ORDERED', // Variable name
            'ORDERED', // Name
            '`ORDERED`', // Expression
            '`ORDERED`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ORDERED`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ORDERED->InputTextType = "text";
        $this->ORDERED->Raw = true;
        $this->ORDERED->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ORDERED->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ORDERED'] = &$this->ORDERED;

        // Lead Time
        $this->LeadTime = new DbField(
            $this, // Table
            'x_LeadTime', // Variable name
            'Lead Time', // Name
            '`Lead Time`', // Expression
            '`Lead Time`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Lead Time`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->LeadTime->InputTextType = "text";
        $this->LeadTime->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Lead Time'] = &$this->LeadTime;

        // Stock Wk
        $this->StockWk = new DbField(
            $this, // Table
            'x_StockWk', // Variable name
            'Stock Wk', // Name
            '`Stock Wk`', // Expression
            '`Stock Wk`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Stock Wk`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->StockWk->InputTextType = "text";
        $this->StockWk->Raw = true;
        $this->StockWk->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->StockWk->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Stock Wk'] = &$this->StockWk;

        // Field20
        $this->Field20 = new DbField(
            $this, // Table
            'x_Field20', // Variable name
            'Field20', // Name
            '`Field20`', // Expression
            '`Field20`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Field20`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Field20->InputTextType = "text";
        $this->Field20->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Field20'] = &$this->Field20;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "ww";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->ID->setDbValue($conn->lastInsertId());
            $rs['ID'] = $this->ID->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['ID']) && !EmptyValue($this->ID->CurrentValue)) {
                $rs['ID'] = $this->ID->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('ID', $rs)) {
                AddFilter($where, QuotedName('ID', $this->Dbid) . '=' . QuotedValue($rs['ID'], $this->ID->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->ID->DbValue = $row['ID'];
        $this->sno->DbValue = $row['sno'];
        $this->_sort->DbValue = $row['sort'];
        $this->s_id->DbValue = $row['s_id'];
        $this->shade->DbValue = $row['shade'];
        $this->consumption->DbValue = $row['consumption'];
        $this->forecast->DbValue = $row['forecast'];
        $this->percent->DbValue = $row['percent'];
        $this->per->DbValue = $row['per'];
        $this->c_id->DbValue = $row['c_id'];
        $this->clairant->DbValue = $row['clairant'];
        $this->Field7->DbValue = $row['Field7'];
        $this->p_id->DbValue = $row['p_id'];
        $this->poddar->DbValue = $row['poddar'];
        $this->po_id->DbValue = $row['po_id'];
        $this->polyone->DbValue = $row['polyone'];
        $this->supplier->DbValue = $row['supplier'];
        $this->QTYFOR3MONTHSFORCAST->DbValue = $row['QTY FOR 3 MONTHS FORCAST'];
        $this->MBNumber->DbValue = $row['MB Number'];
        $this->Company->DbValue = $row['Company'];
        $this->Required->DbValue = $row['Required'];
        $this->Field15->DbValue = $row['Field15'];
        $this->CURRENTSTOCK->DbValue = $row['CURRENT STOCK'];
        $this->ORDERED->DbValue = $row['ORDERED'];
        $this->LeadTime->DbValue = $row['Lead Time'];
        $this->StockWk->DbValue = $row['Stock Wk'];
        $this->Field20->DbValue = $row['Field20'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`ID` = @ID@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->ID->CurrentValue : $this->ID->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->ID->CurrentValue = $keys[0];
            } else {
                $this->ID->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('ID', $row) ? $row['ID'] : null;
        } else {
            $val = !EmptyValue($this->ID->OldValue) && !$current ? $this->ID->OldValue : $this->ID->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@ID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("wwlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "wwview" => $Language->phrase("View"),
            "wwedit" => $Language->phrase("Edit"),
            "wwadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "wwlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "WwView",
            Config("API_ADD_ACTION") => "WwAdd",
            Config("API_EDIT_ACTION") => "WwEdit",
            Config("API_DELETE_ACTION") => "WwDelete",
            Config("API_LIST_ACTION") => "WwList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "wwlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("wwview", $parm);
        } else {
            $url = $this->keyUrl("wwview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "wwadd?" . $parm;
        } else {
            $url = "wwadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("wwedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("wwlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("wwadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("wwlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("wwdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"ID\":" . VarToJson($this->ID->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->ID->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->ID->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("ID") ?? Route("ID")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->ID->CurrentValue = $key;
            } else {
                $this->ID->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->ID->setDbValue($row['ID']);
        $this->sno->setDbValue($row['sno']);
        $this->_sort->setDbValue($row['sort']);
        $this->s_id->setDbValue($row['s_id']);
        $this->shade->setDbValue($row['shade']);
        $this->consumption->setDbValue($row['consumption']);
        $this->forecast->setDbValue($row['forecast']);
        $this->percent->setDbValue($row['percent']);
        $this->per->setDbValue($row['per']);
        $this->c_id->setDbValue($row['c_id']);
        $this->clairant->setDbValue($row['clairant']);
        $this->Field7->setDbValue($row['Field7']);
        $this->p_id->setDbValue($row['p_id']);
        $this->poddar->setDbValue($row['poddar']);
        $this->po_id->setDbValue($row['po_id']);
        $this->polyone->setDbValue($row['polyone']);
        $this->supplier->setDbValue($row['supplier']);
        $this->QTYFOR3MONTHSFORCAST->setDbValue($row['QTY FOR 3 MONTHS FORCAST']);
        $this->MBNumber->setDbValue($row['MB Number']);
        $this->Company->setDbValue($row['Company']);
        $this->Required->setDbValue($row['Required']);
        $this->Field15->setDbValue($row['Field15']);
        $this->CURRENTSTOCK->setDbValue($row['CURRENT STOCK']);
        $this->ORDERED->setDbValue($row['ORDERED']);
        $this->LeadTime->setDbValue($row['Lead Time']);
        $this->StockWk->setDbValue($row['Stock Wk']);
        $this->Field20->setDbValue($row['Field20']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "WwList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ID

        // sno

        // sort

        // s_id

        // shade

        // consumption

        // forecast

        // percent

        // per

        // c_id

        // clairant

        // Field7

        // p_id

        // poddar

        // po_id

        // polyone

        // supplier

        // QTY FOR 3 MONTHS FORCAST

        // MB Number

        // Company

        // Required

        // Field15

        // CURRENT STOCK

        // ORDERED

        // Lead Time

        // Stock Wk

        // Field20

        // ID
        $this->ID->ViewValue = $this->ID->CurrentValue;

        // sno
        $this->sno->ViewValue = $this->sno->CurrentValue;
        $this->sno->ViewValue = FormatNumber($this->sno->ViewValue, $this->sno->formatPattern());

        // sort
        $this->_sort->ViewValue = $this->_sort->CurrentValue;

        // s_id
        $this->s_id->ViewValue = $this->s_id->CurrentValue;

        // shade
        $this->shade->ViewValue = $this->shade->CurrentValue;

        // consumption
        $this->consumption->ViewValue = $this->consumption->CurrentValue;
        $this->consumption->ViewValue = FormatNumber($this->consumption->ViewValue, $this->consumption->formatPattern());

        // forecast
        $this->forecast->ViewValue = $this->forecast->CurrentValue;
        $this->forecast->ViewValue = FormatNumber($this->forecast->ViewValue, $this->forecast->formatPattern());

        // percent
        $this->percent->ViewValue = $this->percent->CurrentValue;
        $this->percent->ViewValue = FormatNumber($this->percent->ViewValue, $this->percent->formatPattern());

        // per
        $this->per->ViewValue = $this->per->CurrentValue;
        $this->per->ViewValue = FormatNumber($this->per->ViewValue, $this->per->formatPattern());

        // c_id
        $this->c_id->ViewValue = $this->c_id->CurrentValue;

        // clairant
        $this->clairant->ViewValue = $this->clairant->CurrentValue;

        // Field7
        $this->Field7->ViewValue = $this->Field7->CurrentValue;
        $this->Field7->ViewValue = FormatNumber($this->Field7->ViewValue, $this->Field7->formatPattern());

        // p_id
        $this->p_id->ViewValue = $this->p_id->CurrentValue;

        // poddar
        $this->poddar->ViewValue = $this->poddar->CurrentValue;

        // po_id
        $this->po_id->ViewValue = $this->po_id->CurrentValue;
        $this->po_id->ViewValue = FormatNumber($this->po_id->ViewValue, $this->po_id->formatPattern());

        // polyone
        $this->polyone->ViewValue = $this->polyone->CurrentValue;

        // supplier
        $this->supplier->ViewValue = $this->supplier->CurrentValue;

        // QTY FOR 3 MONTHS FORCAST
        $this->QTYFOR3MONTHSFORCAST->ViewValue = $this->QTYFOR3MONTHSFORCAST->CurrentValue;
        $this->QTYFOR3MONTHSFORCAST->ViewValue = FormatNumber($this->QTYFOR3MONTHSFORCAST->ViewValue, $this->QTYFOR3MONTHSFORCAST->formatPattern());

        // MB Number
        $this->MBNumber->ViewValue = $this->MBNumber->CurrentValue;

        // Company
        $this->Company->ViewValue = $this->Company->CurrentValue;

        // Required
        $this->Required->ViewValue = $this->Required->CurrentValue;
        $this->Required->ViewValue = FormatNumber($this->Required->ViewValue, $this->Required->formatPattern());

        // Field15
        $this->Field15->ViewValue = $this->Field15->CurrentValue;
        $this->Field15->ViewValue = FormatNumber($this->Field15->ViewValue, $this->Field15->formatPattern());

        // CURRENT STOCK
        $this->CURRENTSTOCK->ViewValue = $this->CURRENTSTOCK->CurrentValue;
        $this->CURRENTSTOCK->ViewValue = FormatNumber($this->CURRENTSTOCK->ViewValue, $this->CURRENTSTOCK->formatPattern());

        // ORDERED
        $this->ORDERED->ViewValue = $this->ORDERED->CurrentValue;
        $this->ORDERED->ViewValue = FormatNumber($this->ORDERED->ViewValue, $this->ORDERED->formatPattern());

        // Lead Time
        $this->LeadTime->ViewValue = $this->LeadTime->CurrentValue;

        // Stock Wk
        $this->StockWk->ViewValue = $this->StockWk->CurrentValue;
        $this->StockWk->ViewValue = FormatNumber($this->StockWk->ViewValue, $this->StockWk->formatPattern());

        // Field20
        $this->Field20->ViewValue = $this->Field20->CurrentValue;

        // ID
        $this->ID->HrefValue = "";
        $this->ID->TooltipValue = "";

        // sno
        $this->sno->HrefValue = "";
        $this->sno->TooltipValue = "";

        // sort
        $this->_sort->HrefValue = "";
        $this->_sort->TooltipValue = "";

        // s_id
        $this->s_id->HrefValue = "";
        $this->s_id->TooltipValue = "";

        // shade
        $this->shade->HrefValue = "";
        $this->shade->TooltipValue = "";

        // consumption
        $this->consumption->HrefValue = "";
        $this->consumption->TooltipValue = "";

        // forecast
        $this->forecast->HrefValue = "";
        $this->forecast->TooltipValue = "";

        // percent
        $this->percent->HrefValue = "";
        $this->percent->TooltipValue = "";

        // per
        $this->per->HrefValue = "";
        $this->per->TooltipValue = "";

        // c_id
        $this->c_id->HrefValue = "";
        $this->c_id->TooltipValue = "";

        // clairant
        $this->clairant->HrefValue = "";
        $this->clairant->TooltipValue = "";

        // Field7
        $this->Field7->HrefValue = "";
        $this->Field7->TooltipValue = "";

        // p_id
        $this->p_id->HrefValue = "";
        $this->p_id->TooltipValue = "";

        // poddar
        $this->poddar->HrefValue = "";
        $this->poddar->TooltipValue = "";

        // po_id
        $this->po_id->HrefValue = "";
        $this->po_id->TooltipValue = "";

        // polyone
        $this->polyone->HrefValue = "";
        $this->polyone->TooltipValue = "";

        // supplier
        $this->supplier->HrefValue = "";
        $this->supplier->TooltipValue = "";

        // QTY FOR 3 MONTHS FORCAST
        $this->QTYFOR3MONTHSFORCAST->HrefValue = "";
        $this->QTYFOR3MONTHSFORCAST->TooltipValue = "";

        // MB Number
        $this->MBNumber->HrefValue = "";
        $this->MBNumber->TooltipValue = "";

        // Company
        $this->Company->HrefValue = "";
        $this->Company->TooltipValue = "";

        // Required
        $this->Required->HrefValue = "";
        $this->Required->TooltipValue = "";

        // Field15
        $this->Field15->HrefValue = "";
        $this->Field15->TooltipValue = "";

        // CURRENT STOCK
        $this->CURRENTSTOCK->HrefValue = "";
        $this->CURRENTSTOCK->TooltipValue = "";

        // ORDERED
        $this->ORDERED->HrefValue = "";
        $this->ORDERED->TooltipValue = "";

        // Lead Time
        $this->LeadTime->HrefValue = "";
        $this->LeadTime->TooltipValue = "";

        // Stock Wk
        $this->StockWk->HrefValue = "";
        $this->StockWk->TooltipValue = "";

        // Field20
        $this->Field20->HrefValue = "";
        $this->Field20->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ID
        $this->ID->setupEditAttributes();
        $this->ID->EditValue = $this->ID->CurrentValue;

        // sno
        $this->sno->setupEditAttributes();
        $this->sno->EditValue = $this->sno->CurrentValue;
        $this->sno->PlaceHolder = RemoveHtml($this->sno->caption());
        if (strval($this->sno->EditValue) != "" && is_numeric($this->sno->EditValue)) {
            $this->sno->EditValue = FormatNumber($this->sno->EditValue, null);
        }

        // sort
        $this->_sort->setupEditAttributes();
        if (!$this->_sort->Raw) {
            $this->_sort->CurrentValue = HtmlDecode($this->_sort->CurrentValue);
        }
        $this->_sort->EditValue = $this->_sort->CurrentValue;
        $this->_sort->PlaceHolder = RemoveHtml($this->_sort->caption());

        // s_id
        $this->s_id->setupEditAttributes();
        if (!$this->s_id->Raw) {
            $this->s_id->CurrentValue = HtmlDecode($this->s_id->CurrentValue);
        }
        $this->s_id->EditValue = $this->s_id->CurrentValue;
        $this->s_id->PlaceHolder = RemoveHtml($this->s_id->caption());

        // shade
        $this->shade->setupEditAttributes();
        if (!$this->shade->Raw) {
            $this->shade->CurrentValue = HtmlDecode($this->shade->CurrentValue);
        }
        $this->shade->EditValue = $this->shade->CurrentValue;
        $this->shade->PlaceHolder = RemoveHtml($this->shade->caption());

        // consumption
        $this->consumption->setupEditAttributes();
        $this->consumption->EditValue = $this->consumption->CurrentValue;
        $this->consumption->PlaceHolder = RemoveHtml($this->consumption->caption());
        if (strval($this->consumption->EditValue) != "" && is_numeric($this->consumption->EditValue)) {
            $this->consumption->EditValue = FormatNumber($this->consumption->EditValue, null);
        }

        // forecast
        $this->forecast->setupEditAttributes();
        $this->forecast->EditValue = $this->forecast->CurrentValue;
        $this->forecast->PlaceHolder = RemoveHtml($this->forecast->caption());
        if (strval($this->forecast->EditValue) != "" && is_numeric($this->forecast->EditValue)) {
            $this->forecast->EditValue = FormatNumber($this->forecast->EditValue, null);
        }

        // percent
        $this->percent->setupEditAttributes();
        $this->percent->EditValue = $this->percent->CurrentValue;
        $this->percent->PlaceHolder = RemoveHtml($this->percent->caption());
        if (strval($this->percent->EditValue) != "" && is_numeric($this->percent->EditValue)) {
            $this->percent->EditValue = FormatNumber($this->percent->EditValue, null);
        }

        // per
        $this->per->setupEditAttributes();
        $this->per->EditValue = $this->per->CurrentValue;
        $this->per->PlaceHolder = RemoveHtml($this->per->caption());
        if (strval($this->per->EditValue) != "" && is_numeric($this->per->EditValue)) {
            $this->per->EditValue = FormatNumber($this->per->EditValue, null);
        }

        // c_id
        $this->c_id->setupEditAttributes();
        if (!$this->c_id->Raw) {
            $this->c_id->CurrentValue = HtmlDecode($this->c_id->CurrentValue);
        }
        $this->c_id->EditValue = $this->c_id->CurrentValue;
        $this->c_id->PlaceHolder = RemoveHtml($this->c_id->caption());

        // clairant
        $this->clairant->setupEditAttributes();
        if (!$this->clairant->Raw) {
            $this->clairant->CurrentValue = HtmlDecode($this->clairant->CurrentValue);
        }
        $this->clairant->EditValue = $this->clairant->CurrentValue;
        $this->clairant->PlaceHolder = RemoveHtml($this->clairant->caption());

        // Field7
        $this->Field7->setupEditAttributes();
        $this->Field7->EditValue = $this->Field7->CurrentValue;
        $this->Field7->PlaceHolder = RemoveHtml($this->Field7->caption());
        if (strval($this->Field7->EditValue) != "" && is_numeric($this->Field7->EditValue)) {
            $this->Field7->EditValue = FormatNumber($this->Field7->EditValue, null);
        }

        // p_id
        $this->p_id->setupEditAttributes();
        if (!$this->p_id->Raw) {
            $this->p_id->CurrentValue = HtmlDecode($this->p_id->CurrentValue);
        }
        $this->p_id->EditValue = $this->p_id->CurrentValue;
        $this->p_id->PlaceHolder = RemoveHtml($this->p_id->caption());

        // poddar
        $this->poddar->setupEditAttributes();
        if (!$this->poddar->Raw) {
            $this->poddar->CurrentValue = HtmlDecode($this->poddar->CurrentValue);
        }
        $this->poddar->EditValue = $this->poddar->CurrentValue;
        $this->poddar->PlaceHolder = RemoveHtml($this->poddar->caption());

        // po_id
        $this->po_id->setupEditAttributes();
        $this->po_id->EditValue = $this->po_id->CurrentValue;
        $this->po_id->PlaceHolder = RemoveHtml($this->po_id->caption());
        if (strval($this->po_id->EditValue) != "" && is_numeric($this->po_id->EditValue)) {
            $this->po_id->EditValue = FormatNumber($this->po_id->EditValue, null);
        }

        // polyone
        $this->polyone->setupEditAttributes();
        if (!$this->polyone->Raw) {
            $this->polyone->CurrentValue = HtmlDecode($this->polyone->CurrentValue);
        }
        $this->polyone->EditValue = $this->polyone->CurrentValue;
        $this->polyone->PlaceHolder = RemoveHtml($this->polyone->caption());

        // supplier
        $this->supplier->setupEditAttributes();
        if (!$this->supplier->Raw) {
            $this->supplier->CurrentValue = HtmlDecode($this->supplier->CurrentValue);
        }
        $this->supplier->EditValue = $this->supplier->CurrentValue;
        $this->supplier->PlaceHolder = RemoveHtml($this->supplier->caption());

        // QTY FOR 3 MONTHS FORCAST
        $this->QTYFOR3MONTHSFORCAST->setupEditAttributes();
        $this->QTYFOR3MONTHSFORCAST->EditValue = $this->QTYFOR3MONTHSFORCAST->CurrentValue;
        $this->QTYFOR3MONTHSFORCAST->PlaceHolder = RemoveHtml($this->QTYFOR3MONTHSFORCAST->caption());
        if (strval($this->QTYFOR3MONTHSFORCAST->EditValue) != "" && is_numeric($this->QTYFOR3MONTHSFORCAST->EditValue)) {
            $this->QTYFOR3MONTHSFORCAST->EditValue = FormatNumber($this->QTYFOR3MONTHSFORCAST->EditValue, null);
        }

        // MB Number
        $this->MBNumber->setupEditAttributes();
        if (!$this->MBNumber->Raw) {
            $this->MBNumber->CurrentValue = HtmlDecode($this->MBNumber->CurrentValue);
        }
        $this->MBNumber->EditValue = $this->MBNumber->CurrentValue;
        $this->MBNumber->PlaceHolder = RemoveHtml($this->MBNumber->caption());

        // Company
        $this->Company->setupEditAttributes();
        if (!$this->Company->Raw) {
            $this->Company->CurrentValue = HtmlDecode($this->Company->CurrentValue);
        }
        $this->Company->EditValue = $this->Company->CurrentValue;
        $this->Company->PlaceHolder = RemoveHtml($this->Company->caption());

        // Required
        $this->Required->setupEditAttributes();
        $this->Required->EditValue = $this->Required->CurrentValue;
        $this->Required->PlaceHolder = RemoveHtml($this->Required->caption());
        if (strval($this->Required->EditValue) != "" && is_numeric($this->Required->EditValue)) {
            $this->Required->EditValue = FormatNumber($this->Required->EditValue, null);
        }

        // Field15
        $this->Field15->setupEditAttributes();
        $this->Field15->EditValue = $this->Field15->CurrentValue;
        $this->Field15->PlaceHolder = RemoveHtml($this->Field15->caption());
        if (strval($this->Field15->EditValue) != "" && is_numeric($this->Field15->EditValue)) {
            $this->Field15->EditValue = FormatNumber($this->Field15->EditValue, null);
        }

        // CURRENT STOCK
        $this->CURRENTSTOCK->setupEditAttributes();
        $this->CURRENTSTOCK->EditValue = $this->CURRENTSTOCK->CurrentValue;
        $this->CURRENTSTOCK->PlaceHolder = RemoveHtml($this->CURRENTSTOCK->caption());
        if (strval($this->CURRENTSTOCK->EditValue) != "" && is_numeric($this->CURRENTSTOCK->EditValue)) {
            $this->CURRENTSTOCK->EditValue = FormatNumber($this->CURRENTSTOCK->EditValue, null);
        }

        // ORDERED
        $this->ORDERED->setupEditAttributes();
        $this->ORDERED->EditValue = $this->ORDERED->CurrentValue;
        $this->ORDERED->PlaceHolder = RemoveHtml($this->ORDERED->caption());
        if (strval($this->ORDERED->EditValue) != "" && is_numeric($this->ORDERED->EditValue)) {
            $this->ORDERED->EditValue = FormatNumber($this->ORDERED->EditValue, null);
        }

        // Lead Time
        $this->LeadTime->setupEditAttributes();
        if (!$this->LeadTime->Raw) {
            $this->LeadTime->CurrentValue = HtmlDecode($this->LeadTime->CurrentValue);
        }
        $this->LeadTime->EditValue = $this->LeadTime->CurrentValue;
        $this->LeadTime->PlaceHolder = RemoveHtml($this->LeadTime->caption());

        // Stock Wk
        $this->StockWk->setupEditAttributes();
        $this->StockWk->EditValue = $this->StockWk->CurrentValue;
        $this->StockWk->PlaceHolder = RemoveHtml($this->StockWk->caption());
        if (strval($this->StockWk->EditValue) != "" && is_numeric($this->StockWk->EditValue)) {
            $this->StockWk->EditValue = FormatNumber($this->StockWk->EditValue, null);
        }

        // Field20
        $this->Field20->setupEditAttributes();
        if (!$this->Field20->Raw) {
            $this->Field20->CurrentValue = HtmlDecode($this->Field20->CurrentValue);
        }
        $this->Field20->EditValue = $this->Field20->CurrentValue;
        $this->Field20->PlaceHolder = RemoveHtml($this->Field20->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ID);
                    $doc->exportCaption($this->sno);
                    $doc->exportCaption($this->_sort);
                    $doc->exportCaption($this->s_id);
                    $doc->exportCaption($this->shade);
                    $doc->exportCaption($this->consumption);
                    $doc->exportCaption($this->forecast);
                    $doc->exportCaption($this->percent);
                    $doc->exportCaption($this->per);
                    $doc->exportCaption($this->c_id);
                    $doc->exportCaption($this->clairant);
                    $doc->exportCaption($this->Field7);
                    $doc->exportCaption($this->p_id);
                    $doc->exportCaption($this->poddar);
                    $doc->exportCaption($this->po_id);
                    $doc->exportCaption($this->polyone);
                    $doc->exportCaption($this->supplier);
                    $doc->exportCaption($this->QTYFOR3MONTHSFORCAST);
                    $doc->exportCaption($this->MBNumber);
                    $doc->exportCaption($this->Company);
                    $doc->exportCaption($this->Required);
                    $doc->exportCaption($this->Field15);
                    $doc->exportCaption($this->CURRENTSTOCK);
                    $doc->exportCaption($this->ORDERED);
                    $doc->exportCaption($this->LeadTime);
                    $doc->exportCaption($this->StockWk);
                    $doc->exportCaption($this->Field20);
                } else {
                    $doc->exportCaption($this->ID);
                    $doc->exportCaption($this->sno);
                    $doc->exportCaption($this->_sort);
                    $doc->exportCaption($this->s_id);
                    $doc->exportCaption($this->shade);
                    $doc->exportCaption($this->consumption);
                    $doc->exportCaption($this->forecast);
                    $doc->exportCaption($this->percent);
                    $doc->exportCaption($this->per);
                    $doc->exportCaption($this->c_id);
                    $doc->exportCaption($this->clairant);
                    $doc->exportCaption($this->Field7);
                    $doc->exportCaption($this->p_id);
                    $doc->exportCaption($this->poddar);
                    $doc->exportCaption($this->po_id);
                    $doc->exportCaption($this->polyone);
                    $doc->exportCaption($this->supplier);
                    $doc->exportCaption($this->QTYFOR3MONTHSFORCAST);
                    $doc->exportCaption($this->MBNumber);
                    $doc->exportCaption($this->Company);
                    $doc->exportCaption($this->Required);
                    $doc->exportCaption($this->Field15);
                    $doc->exportCaption($this->CURRENTSTOCK);
                    $doc->exportCaption($this->ORDERED);
                    $doc->exportCaption($this->LeadTime);
                    $doc->exportCaption($this->StockWk);
                    $doc->exportCaption($this->Field20);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ID);
                        $doc->exportField($this->sno);
                        $doc->exportField($this->_sort);
                        $doc->exportField($this->s_id);
                        $doc->exportField($this->shade);
                        $doc->exportField($this->consumption);
                        $doc->exportField($this->forecast);
                        $doc->exportField($this->percent);
                        $doc->exportField($this->per);
                        $doc->exportField($this->c_id);
                        $doc->exportField($this->clairant);
                        $doc->exportField($this->Field7);
                        $doc->exportField($this->p_id);
                        $doc->exportField($this->poddar);
                        $doc->exportField($this->po_id);
                        $doc->exportField($this->polyone);
                        $doc->exportField($this->supplier);
                        $doc->exportField($this->QTYFOR3MONTHSFORCAST);
                        $doc->exportField($this->MBNumber);
                        $doc->exportField($this->Company);
                        $doc->exportField($this->Required);
                        $doc->exportField($this->Field15);
                        $doc->exportField($this->CURRENTSTOCK);
                        $doc->exportField($this->ORDERED);
                        $doc->exportField($this->LeadTime);
                        $doc->exportField($this->StockWk);
                        $doc->exportField($this->Field20);
                    } else {
                        $doc->exportField($this->ID);
                        $doc->exportField($this->sno);
                        $doc->exportField($this->_sort);
                        $doc->exportField($this->s_id);
                        $doc->exportField($this->shade);
                        $doc->exportField($this->consumption);
                        $doc->exportField($this->forecast);
                        $doc->exportField($this->percent);
                        $doc->exportField($this->per);
                        $doc->exportField($this->c_id);
                        $doc->exportField($this->clairant);
                        $doc->exportField($this->Field7);
                        $doc->exportField($this->p_id);
                        $doc->exportField($this->poddar);
                        $doc->exportField($this->po_id);
                        $doc->exportField($this->polyone);
                        $doc->exportField($this->supplier);
                        $doc->exportField($this->QTYFOR3MONTHSFORCAST);
                        $doc->exportField($this->MBNumber);
                        $doc->exportField($this->Company);
                        $doc->exportField($this->Required);
                        $doc->exportField($this->Field15);
                        $doc->exportField($this->CURRENTSTOCK);
                        $doc->exportField($this->ORDERED);
                        $doc->exportField($this->LeadTime);
                        $doc->exportField($this->StockWk);
                        $doc->exportField($this->Field20);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
