<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class WoolImportCalculator1Search extends WoolImportCalculator1
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "WoolImportCalculator1Search";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "woolimportcalculator1search";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->rid->setVisibility();
        $this->product_code->setVisibility();
        $this->godown_arrival_date->setVisibility();
        $this->net_weight->setVisibility();
        $this->containers->setVisibility();
        $this->packets->setVisibility();
        $this->purchase_amount->setVisibility();
        $this->purchase_custom_duty->setVisibility();
        $this->s_custom_duty->setVisibility();
        $this->port_clearing_charge->setVisibility();
        $this->s_port_clearing_charge->setVisibility();
        $this->cha_commission->setVisibility();
        $this->s_cha_commission->setVisibility();
        $this->transportation_charges->setVisibility();
        $this->s_transportation_charges->setVisibility();
        $this->unloading_charges->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'wool_import_calculator1';
        $this->TableName = 'wool_import_calculator1';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (wool_import_calculator1)
        if (!isset($GLOBALS["wool_import_calculator1"]) || $GLOBALS["wool_import_calculator1"]::class == PROJECT_NAMESPACE . "wool_import_calculator1") {
            $GLOBALS["wool_import_calculator1"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'wool_import_calculator1');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "woolimportcalculator1view"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "woolimportcalculator1list" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->rid); // rid
        $this->buildSearchUrl($srchUrl, $this->product_code); // product_code
        $this->buildSearchUrl($srchUrl, $this->godown_arrival_date); // godown_arrival_date
        $this->buildSearchUrl($srchUrl, $this->net_weight); // net_weight
        $this->buildSearchUrl($srchUrl, $this->containers); // containers
        $this->buildSearchUrl($srchUrl, $this->packets); // packets
        $this->buildSearchUrl($srchUrl, $this->purchase_amount); // purchase_amount
        $this->buildSearchUrl($srchUrl, $this->purchase_custom_duty); // purchase_custom_duty
        $this->buildSearchUrl($srchUrl, $this->s_custom_duty); // s_custom_duty
        $this->buildSearchUrl($srchUrl, $this->port_clearing_charge); // port_clearing_charge
        $this->buildSearchUrl($srchUrl, $this->s_port_clearing_charge); // s_port_clearing_charge
        $this->buildSearchUrl($srchUrl, $this->cha_commission); // cha_commission
        $this->buildSearchUrl($srchUrl, $this->s_cha_commission); // s_cha_commission
        $this->buildSearchUrl($srchUrl, $this->transportation_charges); // transportation_charges
        $this->buildSearchUrl($srchUrl, $this->s_transportation_charges); // s_transportation_charges
        $this->buildSearchUrl($srchUrl, $this->unloading_charges); // unloading_charges
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // rid
        if ($this->rid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_code
        if ($this->product_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // godown_arrival_date
        if ($this->godown_arrival_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // net_weight
        if ($this->net_weight->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // containers
        if ($this->containers->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packets
        if ($this->packets->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // purchase_amount
        if ($this->purchase_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // purchase_custom_duty
        if ($this->purchase_custom_duty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_custom_duty
        if ($this->s_custom_duty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // port_clearing_charge
        if ($this->port_clearing_charge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_port_clearing_charge
        if ($this->s_port_clearing_charge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cha_commission
        if ($this->cha_commission->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_cha_commission
        if ($this->s_cha_commission->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // transportation_charges
        if ($this->transportation_charges->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_transportation_charges
        if ($this->s_transportation_charges->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // unloading_charges
        if ($this->unloading_charges->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // rid
        $this->rid->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // godown_arrival_date
        $this->godown_arrival_date->RowCssClass = "row";

        // net_weight
        $this->net_weight->RowCssClass = "row";

        // containers
        $this->containers->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // purchase_amount
        $this->purchase_amount->RowCssClass = "row";

        // purchase_custom_duty
        $this->purchase_custom_duty->RowCssClass = "row";

        // s_custom_duty
        $this->s_custom_duty->RowCssClass = "row";

        // port_clearing_charge
        $this->port_clearing_charge->RowCssClass = "row";

        // s_port_clearing_charge
        $this->s_port_clearing_charge->RowCssClass = "row";

        // cha_commission
        $this->cha_commission->RowCssClass = "row";

        // s_cha_commission
        $this->s_cha_commission->RowCssClass = "row";

        // transportation_charges
        $this->transportation_charges->RowCssClass = "row";

        // s_transportation_charges
        $this->s_transportation_charges->RowCssClass = "row";

        // unloading_charges
        $this->unloading_charges->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // godown_arrival_date
            $this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
            $this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, $this->godown_arrival_date->formatPattern());

            // net_weight
            $this->net_weight->ViewValue = $this->net_weight->CurrentValue;
            $this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, $this->net_weight->formatPattern());

            // containers
            $this->containers->ViewValue = $this->containers->CurrentValue;
            $this->containers->ViewValue = FormatNumber($this->containers->ViewValue, $this->containers->formatPattern());

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;

            // purchase_amount
            $this->purchase_amount->ViewValue = $this->purchase_amount->CurrentValue;
            $this->purchase_amount->ViewValue = FormatNumber($this->purchase_amount->ViewValue, $this->purchase_amount->formatPattern());

            // purchase_custom_duty
            $this->purchase_custom_duty->ViewValue = $this->purchase_custom_duty->CurrentValue;

            // s_custom_duty
            $this->s_custom_duty->ViewValue = $this->s_custom_duty->CurrentValue;

            // port_clearing_charge
            $this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;

            // s_port_clearing_charge
            $this->s_port_clearing_charge->ViewValue = $this->s_port_clearing_charge->CurrentValue;

            // cha_commission
            $this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;

            // s_cha_commission
            $this->s_cha_commission->ViewValue = $this->s_cha_commission->CurrentValue;

            // transportation_charges
            $this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;

            // s_transportation_charges
            $this->s_transportation_charges->ViewValue = $this->s_transportation_charges->CurrentValue;

            // unloading_charges
            $this->unloading_charges->ViewValue = $this->unloading_charges->CurrentValue;

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";

            // product_code
            if (!EmptyValue($this->product_code->CurrentValue)) {
                $this->product_code->HrefValue = $this->product_code->getLinkPrefix() . $this->product_code->CurrentValue; // Add prefix/suffix
                $this->product_code->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
                }
            } else {
                $this->product_code->HrefValue = "";
            }
            $this->product_code->TooltipValue = "";

            // godown_arrival_date
            $this->godown_arrival_date->HrefValue = "";
            $this->godown_arrival_date->TooltipValue = "";

            // net_weight
            $this->net_weight->HrefValue = "";
            $this->net_weight->TooltipValue = "";

            // containers
            $this->containers->HrefValue = "";
            $this->containers->TooltipValue = "";

            // packets
            $this->packets->HrefValue = "";
            $this->packets->TooltipValue = "";

            // purchase_amount
            $this->purchase_amount->HrefValue = "";
            $this->purchase_amount->TooltipValue = "";

            // purchase_custom_duty
            $this->purchase_custom_duty->HrefValue = "";
            $this->purchase_custom_duty->TooltipValue = "";

            // s_custom_duty
            $this->s_custom_duty->HrefValue = "";
            $this->s_custom_duty->TooltipValue = "";

            // port_clearing_charge
            $this->port_clearing_charge->HrefValue = "";
            $this->port_clearing_charge->TooltipValue = "";

            // s_port_clearing_charge
            $this->s_port_clearing_charge->HrefValue = "";
            $this->s_port_clearing_charge->TooltipValue = "";

            // cha_commission
            $this->cha_commission->HrefValue = "";
            $this->cha_commission->TooltipValue = "";

            // s_cha_commission
            $this->s_cha_commission->HrefValue = "";
            $this->s_cha_commission->TooltipValue = "";

            // transportation_charges
            $this->transportation_charges->HrefValue = "";
            $this->transportation_charges->TooltipValue = "";

            // s_transportation_charges
            $this->s_transportation_charges->HrefValue = "";
            $this->s_transportation_charges->TooltipValue = "";

            // unloading_charges
            $this->unloading_charges->HrefValue = "";
            $this->unloading_charges->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->AdvancedSearch->SearchValue;
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // product_code
            $this->product_code->setupEditAttributes();
            if (!$this->product_code->Raw) {
                $this->product_code->AdvancedSearch->SearchValue = HtmlDecode($this->product_code->AdvancedSearch->SearchValue);
            }
            $this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // godown_arrival_date
            $this->godown_arrival_date->setupEditAttributes();
            $this->godown_arrival_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->godown_arrival_date->AdvancedSearch->SearchValue, $this->godown_arrival_date->formatPattern()), $this->godown_arrival_date->formatPattern()));
            $this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());

            // net_weight
            $this->net_weight->setupEditAttributes();
            $this->net_weight->EditValue = $this->net_weight->AdvancedSearch->SearchValue;
            $this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());

            // containers
            $this->containers->setupEditAttributes();
            $this->containers->EditValue = $this->containers->AdvancedSearch->SearchValue;
            $this->containers->PlaceHolder = RemoveHtml($this->containers->caption());

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->AdvancedSearch->SearchValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

            // purchase_amount
            $this->purchase_amount->setupEditAttributes();
            $this->purchase_amount->EditValue = $this->purchase_amount->AdvancedSearch->SearchValue;
            $this->purchase_amount->PlaceHolder = RemoveHtml($this->purchase_amount->caption());

            // purchase_custom_duty
            $this->purchase_custom_duty->setupEditAttributes();
            if (!$this->purchase_custom_duty->Raw) {
                $this->purchase_custom_duty->AdvancedSearch->SearchValue = HtmlDecode($this->purchase_custom_duty->AdvancedSearch->SearchValue);
            }
            $this->purchase_custom_duty->EditValue = HtmlEncode($this->purchase_custom_duty->AdvancedSearch->SearchValue);
            $this->purchase_custom_duty->PlaceHolder = RemoveHtml($this->purchase_custom_duty->caption());

            // s_custom_duty
            $this->s_custom_duty->setupEditAttributes();
            if (!$this->s_custom_duty->Raw) {
                $this->s_custom_duty->AdvancedSearch->SearchValue = HtmlDecode($this->s_custom_duty->AdvancedSearch->SearchValue);
            }
            $this->s_custom_duty->EditValue = HtmlEncode($this->s_custom_duty->AdvancedSearch->SearchValue);
            $this->s_custom_duty->PlaceHolder = RemoveHtml($this->s_custom_duty->caption());

            // port_clearing_charge
            $this->port_clearing_charge->setupEditAttributes();
            if (!$this->port_clearing_charge->Raw) {
                $this->port_clearing_charge->AdvancedSearch->SearchValue = HtmlDecode($this->port_clearing_charge->AdvancedSearch->SearchValue);
            }
            $this->port_clearing_charge->EditValue = HtmlEncode($this->port_clearing_charge->AdvancedSearch->SearchValue);
            $this->port_clearing_charge->PlaceHolder = RemoveHtml($this->port_clearing_charge->caption());

            // s_port_clearing_charge
            $this->s_port_clearing_charge->setupEditAttributes();
            if (!$this->s_port_clearing_charge->Raw) {
                $this->s_port_clearing_charge->AdvancedSearch->SearchValue = HtmlDecode($this->s_port_clearing_charge->AdvancedSearch->SearchValue);
            }
            $this->s_port_clearing_charge->EditValue = HtmlEncode($this->s_port_clearing_charge->AdvancedSearch->SearchValue);
            $this->s_port_clearing_charge->PlaceHolder = RemoveHtml($this->s_port_clearing_charge->caption());

            // cha_commission
            $this->cha_commission->setupEditAttributes();
            if (!$this->cha_commission->Raw) {
                $this->cha_commission->AdvancedSearch->SearchValue = HtmlDecode($this->cha_commission->AdvancedSearch->SearchValue);
            }
            $this->cha_commission->EditValue = HtmlEncode($this->cha_commission->AdvancedSearch->SearchValue);
            $this->cha_commission->PlaceHolder = RemoveHtml($this->cha_commission->caption());

            // s_cha_commission
            $this->s_cha_commission->setupEditAttributes();
            if (!$this->s_cha_commission->Raw) {
                $this->s_cha_commission->AdvancedSearch->SearchValue = HtmlDecode($this->s_cha_commission->AdvancedSearch->SearchValue);
            }
            $this->s_cha_commission->EditValue = HtmlEncode($this->s_cha_commission->AdvancedSearch->SearchValue);
            $this->s_cha_commission->PlaceHolder = RemoveHtml($this->s_cha_commission->caption());

            // transportation_charges
            $this->transportation_charges->setupEditAttributes();
            if (!$this->transportation_charges->Raw) {
                $this->transportation_charges->AdvancedSearch->SearchValue = HtmlDecode($this->transportation_charges->AdvancedSearch->SearchValue);
            }
            $this->transportation_charges->EditValue = HtmlEncode($this->transportation_charges->AdvancedSearch->SearchValue);
            $this->transportation_charges->PlaceHolder = RemoveHtml($this->transportation_charges->caption());

            // s_transportation_charges
            $this->s_transportation_charges->setupEditAttributes();
            if (!$this->s_transportation_charges->Raw) {
                $this->s_transportation_charges->AdvancedSearch->SearchValue = HtmlDecode($this->s_transportation_charges->AdvancedSearch->SearchValue);
            }
            $this->s_transportation_charges->EditValue = HtmlEncode($this->s_transportation_charges->AdvancedSearch->SearchValue);
            $this->s_transportation_charges->PlaceHolder = RemoveHtml($this->s_transportation_charges->caption());

            // unloading_charges
            $this->unloading_charges->setupEditAttributes();
            if (!$this->unloading_charges->Raw) {
                $this->unloading_charges->AdvancedSearch->SearchValue = HtmlDecode($this->unloading_charges->AdvancedSearch->SearchValue);
            }
            $this->unloading_charges->EditValue = HtmlEncode($this->unloading_charges->AdvancedSearch->SearchValue);
            $this->unloading_charges->PlaceHolder = RemoveHtml($this->unloading_charges->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->rid->AdvancedSearch->SearchValue)) {
            $this->rid->addErrorMessage($this->rid->getErrorMessage(false));
        }
        if (!CheckDate($this->godown_arrival_date->AdvancedSearch->SearchValue, $this->godown_arrival_date->formatPattern())) {
            $this->godown_arrival_date->addErrorMessage($this->godown_arrival_date->getErrorMessage(false));
        }
        if (!CheckNumber($this->net_weight->AdvancedSearch->SearchValue)) {
            $this->net_weight->addErrorMessage($this->net_weight->getErrorMessage(false));
        }
        if (!CheckNumber($this->containers->AdvancedSearch->SearchValue)) {
            $this->containers->addErrorMessage($this->containers->getErrorMessage(false));
        }
        if (!CheckInteger($this->packets->AdvancedSearch->SearchValue)) {
            $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
        }
        if (!CheckNumber($this->purchase_amount->AdvancedSearch->SearchValue)) {
            $this->purchase_amount->addErrorMessage($this->purchase_amount->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->rid->AdvancedSearch->load();
        $this->product_code->AdvancedSearch->load();
        $this->godown_arrival_date->AdvancedSearch->load();
        $this->net_weight->AdvancedSearch->load();
        $this->containers->AdvancedSearch->load();
        $this->packets->AdvancedSearch->load();
        $this->purchase_amount->AdvancedSearch->load();
        $this->purchase_custom_duty->AdvancedSearch->load();
        $this->s_custom_duty->AdvancedSearch->load();
        $this->port_clearing_charge->AdvancedSearch->load();
        $this->s_port_clearing_charge->AdvancedSearch->load();
        $this->cha_commission->AdvancedSearch->load();
        $this->s_cha_commission->AdvancedSearch->load();
        $this->transportation_charges->AdvancedSearch->load();
        $this->s_transportation_charges->AdvancedSearch->load();
        $this->unloading_charges->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("woolimportcalculator1list"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
