<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class VehicleInfoAdd extends VehicleInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "VehicleInfoAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "vehicleinfoadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->type->setVisibility();
        $this->vehicle_owner->setVisibility();
        $this->no->setVisibility();
        $this->driver->setVisibility();
        $this->driver_name->setVisibility();
        $this->dor->setVisibility();
        $this->km_hour->setVisibility();
        $this->chassis_no->setVisibility();
        $this->engine_no->setVisibility();
        $this->load_average->setVisibility();
        $this->unload_average->setVisibility();
        $this->load_expenses->setVisibility();
        $this->unload_expenses->setVisibility();
        $this->insurance->setVisibility();
        $this->state_tax->setVisibility();
        $this->national_permit->setVisibility();
        $this->pollution->setVisibility();
        $this->fitness->setVisibility();
        $this->other_due->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->running_status->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'vehicle_info';
        $this->TableName = 'vehicle_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (vehicle_info)
        if (!isset($GLOBALS["vehicle_info"]) || $GLOBALS["vehicle_info"]::class == PROJECT_NAMESPACE . "vehicle_info") {
            $GLOBALS["vehicle_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'vehicle_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "vehicleinfoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->vehicle_owner);
        $this->setupLookupOptions($this->driver);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->running_status);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("vehicleinfolist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "vehicleinfolist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "vehicleinfoview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "vehicleinfolist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "vehicleinfolist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->type->DefaultValue = $this->type->getDefault(); // PHP
        $this->type->OldValue = $this->type->DefaultValue;
        $this->km_hour->DefaultValue = $this->km_hour->getDefault(); // PHP
        $this->km_hour->OldValue = $this->km_hour->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->running_status->DefaultValue = $this->running_status->getDefault(); // PHP
        $this->running_status->OldValue = $this->running_status->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'type' first before field var 'x_type'
        $val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
        if (!$this->type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->type->Visible = false; // Disable update for API request
            } else {
                $this->type->setFormValue($val);
            }
        }

        // Check field name 'vehicle_owner' first before field var 'x_vehicle_owner'
        $val = $CurrentForm->hasValue("vehicle_owner") ? $CurrentForm->getValue("vehicle_owner") : $CurrentForm->getValue("x_vehicle_owner");
        if (!$this->vehicle_owner->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_owner->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_owner->setFormValue($val);
            }
        }

        // Check field name 'no' first before field var 'x_no'
        $val = $CurrentForm->hasValue("no") ? $CurrentForm->getValue("no") : $CurrentForm->getValue("x_no");
        if (!$this->no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->no->Visible = false; // Disable update for API request
            } else {
                $this->no->setFormValue($val);
            }
        }

        // Check field name 'driver' first before field var 'x_driver'
        $val = $CurrentForm->hasValue("driver") ? $CurrentForm->getValue("driver") : $CurrentForm->getValue("x_driver");
        if (!$this->driver->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->driver->Visible = false; // Disable update for API request
            } else {
                $this->driver->setFormValue($val);
            }
        }

        // Check field name 'driver_name' first before field var 'x_driver_name'
        $val = $CurrentForm->hasValue("driver_name") ? $CurrentForm->getValue("driver_name") : $CurrentForm->getValue("x_driver_name");
        if (!$this->driver_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->driver_name->Visible = false; // Disable update for API request
            } else {
                $this->driver_name->setFormValue($val);
            }
        }

        // Check field name 'dor' first before field var 'x_dor'
        $val = $CurrentForm->hasValue("dor") ? $CurrentForm->getValue("dor") : $CurrentForm->getValue("x_dor");
        if (!$this->dor->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dor->Visible = false; // Disable update for API request
            } else {
                $this->dor->setFormValue($val, true, $validate);
            }
            $this->dor->CurrentValue = UnFormatDateTime($this->dor->CurrentValue, $this->dor->formatPattern());
        }

        // Check field name 'km_hour' first before field var 'x_km_hour'
        $val = $CurrentForm->hasValue("km_hour") ? $CurrentForm->getValue("km_hour") : $CurrentForm->getValue("x_km_hour");
        if (!$this->km_hour->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->km_hour->Visible = false; // Disable update for API request
            } else {
                $this->km_hour->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'chassis_no' first before field var 'x_chassis_no'
        $val = $CurrentForm->hasValue("chassis_no") ? $CurrentForm->getValue("chassis_no") : $CurrentForm->getValue("x_chassis_no");
        if (!$this->chassis_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->chassis_no->Visible = false; // Disable update for API request
            } else {
                $this->chassis_no->setFormValue($val);
            }
        }

        // Check field name 'engine_no' first before field var 'x_engine_no'
        $val = $CurrentForm->hasValue("engine_no") ? $CurrentForm->getValue("engine_no") : $CurrentForm->getValue("x_engine_no");
        if (!$this->engine_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->engine_no->Visible = false; // Disable update for API request
            } else {
                $this->engine_no->setFormValue($val);
            }
        }

        // Check field name 'load_average' first before field var 'x_load_average'
        $val = $CurrentForm->hasValue("load_average") ? $CurrentForm->getValue("load_average") : $CurrentForm->getValue("x_load_average");
        if (!$this->load_average->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_average->Visible = false; // Disable update for API request
            } else {
                $this->load_average->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'unload_average' first before field var 'x_unload_average'
        $val = $CurrentForm->hasValue("unload_average") ? $CurrentForm->getValue("unload_average") : $CurrentForm->getValue("x_unload_average");
        if (!$this->unload_average->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unload_average->Visible = false; // Disable update for API request
            } else {
                $this->unload_average->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'load_expenses' first before field var 'x_load_expenses'
        $val = $CurrentForm->hasValue("load_expenses") ? $CurrentForm->getValue("load_expenses") : $CurrentForm->getValue("x_load_expenses");
        if (!$this->load_expenses->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_expenses->Visible = false; // Disable update for API request
            } else {
                $this->load_expenses->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'unload_expenses' first before field var 'x_unload_expenses'
        $val = $CurrentForm->hasValue("unload_expenses") ? $CurrentForm->getValue("unload_expenses") : $CurrentForm->getValue("x_unload_expenses");
        if (!$this->unload_expenses->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unload_expenses->Visible = false; // Disable update for API request
            } else {
                $this->unload_expenses->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'insurance' first before field var 'x_insurance'
        $val = $CurrentForm->hasValue("insurance") ? $CurrentForm->getValue("insurance") : $CurrentForm->getValue("x_insurance");
        if (!$this->insurance->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->insurance->Visible = false; // Disable update for API request
            } else {
                $this->insurance->setFormValue($val, true, $validate);
            }
            $this->insurance->CurrentValue = UnFormatDateTime($this->insurance->CurrentValue, $this->insurance->formatPattern());
        }

        // Check field name 'state_tax' first before field var 'x_state_tax'
        $val = $CurrentForm->hasValue("state_tax") ? $CurrentForm->getValue("state_tax") : $CurrentForm->getValue("x_state_tax");
        if (!$this->state_tax->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->state_tax->Visible = false; // Disable update for API request
            } else {
                $this->state_tax->setFormValue($val, true, $validate);
            }
            $this->state_tax->CurrentValue = UnFormatDateTime($this->state_tax->CurrentValue, $this->state_tax->formatPattern());
        }

        // Check field name 'national_permit' first before field var 'x_national_permit'
        $val = $CurrentForm->hasValue("national_permit") ? $CurrentForm->getValue("national_permit") : $CurrentForm->getValue("x_national_permit");
        if (!$this->national_permit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->national_permit->Visible = false; // Disable update for API request
            } else {
                $this->national_permit->setFormValue($val, true, $validate);
            }
            $this->national_permit->CurrentValue = UnFormatDateTime($this->national_permit->CurrentValue, $this->national_permit->formatPattern());
        }

        // Check field name 'pollution' first before field var 'x_pollution'
        $val = $CurrentForm->hasValue("pollution") ? $CurrentForm->getValue("pollution") : $CurrentForm->getValue("x_pollution");
        if (!$this->pollution->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pollution->Visible = false; // Disable update for API request
            } else {
                $this->pollution->setFormValue($val, true, $validate);
            }
            $this->pollution->CurrentValue = UnFormatDateTime($this->pollution->CurrentValue, $this->pollution->formatPattern());
        }

        // Check field name 'fitness' first before field var 'x_fitness'
        $val = $CurrentForm->hasValue("fitness") ? $CurrentForm->getValue("fitness") : $CurrentForm->getValue("x_fitness");
        if (!$this->fitness->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fitness->Visible = false; // Disable update for API request
            } else {
                $this->fitness->setFormValue($val, true, $validate);
            }
            $this->fitness->CurrentValue = UnFormatDateTime($this->fitness->CurrentValue, $this->fitness->formatPattern());
        }

        // Check field name 'other_due' first before field var 'x_other_due'
        $val = $CurrentForm->hasValue("other_due") ? $CurrentForm->getValue("other_due") : $CurrentForm->getValue("x_other_due");
        if (!$this->other_due->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other_due->Visible = false; // Disable update for API request
            } else {
                $this->other_due->setFormValue($val, true, $validate);
            }
            $this->other_due->CurrentValue = UnFormatDateTime($this->other_due->CurrentValue, $this->other_due->formatPattern());
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->type->CurrentValue = $this->type->FormValue;
        $this->vehicle_owner->CurrentValue = $this->vehicle_owner->FormValue;
        $this->no->CurrentValue = $this->no->FormValue;
        $this->driver->CurrentValue = $this->driver->FormValue;
        $this->driver_name->CurrentValue = $this->driver_name->FormValue;
        $this->dor->CurrentValue = $this->dor->FormValue;
        $this->dor->CurrentValue = UnFormatDateTime($this->dor->CurrentValue, $this->dor->formatPattern());
        $this->km_hour->CurrentValue = $this->km_hour->FormValue;
        $this->chassis_no->CurrentValue = $this->chassis_no->FormValue;
        $this->engine_no->CurrentValue = $this->engine_no->FormValue;
        $this->load_average->CurrentValue = $this->load_average->FormValue;
        $this->unload_average->CurrentValue = $this->unload_average->FormValue;
        $this->load_expenses->CurrentValue = $this->load_expenses->FormValue;
        $this->unload_expenses->CurrentValue = $this->unload_expenses->FormValue;
        $this->insurance->CurrentValue = $this->insurance->FormValue;
        $this->insurance->CurrentValue = UnFormatDateTime($this->insurance->CurrentValue, $this->insurance->formatPattern());
        $this->state_tax->CurrentValue = $this->state_tax->FormValue;
        $this->state_tax->CurrentValue = UnFormatDateTime($this->state_tax->CurrentValue, $this->state_tax->formatPattern());
        $this->national_permit->CurrentValue = $this->national_permit->FormValue;
        $this->national_permit->CurrentValue = UnFormatDateTime($this->national_permit->CurrentValue, $this->national_permit->formatPattern());
        $this->pollution->CurrentValue = $this->pollution->FormValue;
        $this->pollution->CurrentValue = UnFormatDateTime($this->pollution->CurrentValue, $this->pollution->formatPattern());
        $this->fitness->CurrentValue = $this->fitness->FormValue;
        $this->fitness->CurrentValue = UnFormatDateTime($this->fitness->CurrentValue, $this->fitness->formatPattern());
        $this->other_due->CurrentValue = $this->other_due->FormValue;
        $this->other_due->CurrentValue = UnFormatDateTime($this->other_due->CurrentValue, $this->other_due->formatPattern());
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->type->setDbValue($row['type']);
        $this->vehicle_owner->setDbValue($row['vehicle_owner']);
        $this->no->setDbValue($row['no']);
        $this->driver->setDbValue($row['driver']);
        $this->driver_name->setDbValue($row['driver_name']);
        $this->dor->setDbValue($row['dor']);
        $this->km_hour->setDbValue($row['km_hour']);
        $this->chassis_no->setDbValue($row['chassis_no']);
        $this->engine_no->setDbValue($row['engine_no']);
        $this->load_average->setDbValue($row['load_average']);
        $this->unload_average->setDbValue($row['unload_average']);
        $this->load_expenses->setDbValue($row['load_expenses']);
        $this->unload_expenses->setDbValue($row['unload_expenses']);
        $this->insurance->setDbValue($row['insurance']);
        $this->state_tax->setDbValue($row['state_tax']);
        $this->national_permit->setDbValue($row['national_permit']);
        $this->pollution->setDbValue($row['pollution']);
        $this->fitness->setDbValue($row['fitness']);
        $this->other_due->setDbValue($row['other_due']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->running_status->setDbValue($row['running_status']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['vehicle_owner'] = $this->vehicle_owner->DefaultValue;
        $row['no'] = $this->no->DefaultValue;
        $row['driver'] = $this->driver->DefaultValue;
        $row['driver_name'] = $this->driver_name->DefaultValue;
        $row['dor'] = $this->dor->DefaultValue;
        $row['km_hour'] = $this->km_hour->DefaultValue;
        $row['chassis_no'] = $this->chassis_no->DefaultValue;
        $row['engine_no'] = $this->engine_no->DefaultValue;
        $row['load_average'] = $this->load_average->DefaultValue;
        $row['unload_average'] = $this->unload_average->DefaultValue;
        $row['load_expenses'] = $this->load_expenses->DefaultValue;
        $row['unload_expenses'] = $this->unload_expenses->DefaultValue;
        $row['insurance'] = $this->insurance->DefaultValue;
        $row['state_tax'] = $this->state_tax->DefaultValue;
        $row['national_permit'] = $this->national_permit->DefaultValue;
        $row['pollution'] = $this->pollution->DefaultValue;
        $row['fitness'] = $this->fitness->DefaultValue;
        $row['other_due'] = $this->other_due->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['running_status'] = $this->running_status->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // vehicle_owner
        $this->vehicle_owner->RowCssClass = "row";

        // no
        $this->no->RowCssClass = "row";

        // driver
        $this->driver->RowCssClass = "row";

        // driver_name
        $this->driver_name->RowCssClass = "row";

        // dor
        $this->dor->RowCssClass = "row";

        // km_hour
        $this->km_hour->RowCssClass = "row";

        // chassis_no
        $this->chassis_no->RowCssClass = "row";

        // engine_no
        $this->engine_no->RowCssClass = "row";

        // load_average
        $this->load_average->RowCssClass = "row";

        // unload_average
        $this->unload_average->RowCssClass = "row";

        // load_expenses
        $this->load_expenses->RowCssClass = "row";

        // unload_expenses
        $this->unload_expenses->RowCssClass = "row";

        // insurance
        $this->insurance->RowCssClass = "row";

        // state_tax
        $this->state_tax->RowCssClass = "row";

        // national_permit
        $this->national_permit->RowCssClass = "row";

        // pollution
        $this->pollution->RowCssClass = "row";

        // fitness
        $this->fitness->RowCssClass = "row";

        // other_due
        $this->other_due->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // running_status
        $this->running_status->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // vehicle_owner
            $curVal = strval($this->vehicle_owner->CurrentValue);
            if ($curVal != "") {
                $this->vehicle_owner->ViewValue = $this->vehicle_owner->lookupCacheOption($curVal);
                if ($this->vehicle_owner->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle_owner->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle_owner->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle_owner->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle_owner->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle_owner->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle_owner->ViewValue = $this->vehicle_owner->displayValue($arwrk);
                    } else {
                        $this->vehicle_owner->ViewValue = FormatNumber($this->vehicle_owner->CurrentValue, $this->vehicle_owner->formatPattern());
                    }
                }
            } else {
                $this->vehicle_owner->ViewValue = null;
            }

            // no
            $this->no->ViewValue = $this->no->CurrentValue;

            // driver
            $curVal = strval($this->driver->CurrentValue);
            if ($curVal != "") {
                $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
                if ($this->driver->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                    $sqlWrk = $this->driver->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->driver->Lookup->renderViewRow($rswrk[0]);
                        $this->driver->ViewValue = $this->driver->displayValue($arwrk);
                    } else {
                        $this->driver->ViewValue = FormatNumber($this->driver->CurrentValue, $this->driver->formatPattern());
                    }
                }
            } else {
                $this->driver->ViewValue = null;
            }

            // driver_name
            $this->driver_name->ViewValue = $this->driver_name->CurrentValue;

            // dor
            $this->dor->ViewValue = $this->dor->CurrentValue;
            $this->dor->ViewValue = FormatDateTime($this->dor->ViewValue, $this->dor->formatPattern());

            // km_hour
            $this->km_hour->ViewValue = $this->km_hour->CurrentValue;
            $this->km_hour->ViewValue = FormatNumber($this->km_hour->ViewValue, $this->km_hour->formatPattern());

            // chassis_no
            $this->chassis_no->ViewValue = $this->chassis_no->CurrentValue;

            // engine_no
            $this->engine_no->ViewValue = $this->engine_no->CurrentValue;

            // load_average
            $this->load_average->ViewValue = $this->load_average->CurrentValue;
            $this->load_average->ViewValue = FormatNumber($this->load_average->ViewValue, $this->load_average->formatPattern());

            // unload_average
            $this->unload_average->ViewValue = $this->unload_average->CurrentValue;
            $this->unload_average->ViewValue = FormatNumber($this->unload_average->ViewValue, $this->unload_average->formatPattern());

            // load_expenses
            $this->load_expenses->ViewValue = $this->load_expenses->CurrentValue;
            $this->load_expenses->ViewValue = FormatNumber($this->load_expenses->ViewValue, $this->load_expenses->formatPattern());

            // unload_expenses
            $this->unload_expenses->ViewValue = $this->unload_expenses->CurrentValue;
            $this->unload_expenses->ViewValue = FormatNumber($this->unload_expenses->ViewValue, $this->unload_expenses->formatPattern());

            // insurance
            $this->insurance->ViewValue = $this->insurance->CurrentValue;
            $this->insurance->ViewValue = FormatDateTime($this->insurance->ViewValue, $this->insurance->formatPattern());

            // state_tax
            $this->state_tax->ViewValue = $this->state_tax->CurrentValue;
            $this->state_tax->ViewValue = FormatDateTime($this->state_tax->ViewValue, $this->state_tax->formatPattern());

            // national_permit
            $this->national_permit->ViewValue = $this->national_permit->CurrentValue;
            $this->national_permit->ViewValue = FormatDateTime($this->national_permit->ViewValue, $this->national_permit->formatPattern());

            // pollution
            $this->pollution->ViewValue = $this->pollution->CurrentValue;
            $this->pollution->ViewValue = FormatDateTime($this->pollution->ViewValue, $this->pollution->formatPattern());

            // fitness
            $this->fitness->ViewValue = $this->fitness->CurrentValue;
            $this->fitness->ViewValue = FormatDateTime($this->fitness->ViewValue, $this->fitness->formatPattern());

            // other_due
            $this->other_due->ViewValue = $this->other_due->CurrentValue;
            $this->other_due->ViewValue = FormatDateTime($this->other_due->ViewValue, $this->other_due->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // running_status
            if (strval($this->running_status->CurrentValue) != "") {
                $this->running_status->ViewValue = $this->running_status->optionCaption($this->running_status->CurrentValue);
            } else {
                $this->running_status->ViewValue = null;
            }

            // type
            $this->type->HrefValue = "";

            // vehicle_owner
            $this->vehicle_owner->HrefValue = "";

            // no
            $this->no->HrefValue = "";

            // driver
            $this->driver->HrefValue = "";

            // driver_name
            $this->driver_name->HrefValue = "";

            // dor
            $this->dor->HrefValue = "";

            // km_hour
            $this->km_hour->HrefValue = "";

            // chassis_no
            $this->chassis_no->HrefValue = "";

            // engine_no
            $this->engine_no->HrefValue = "";

            // load_average
            $this->load_average->HrefValue = "";

            // unload_average
            $this->unload_average->HrefValue = "";

            // load_expenses
            $this->load_expenses->HrefValue = "";

            // unload_expenses
            $this->unload_expenses->HrefValue = "";

            // insurance
            $this->insurance->HrefValue = "";

            // state_tax
            $this->state_tax->HrefValue = "";

            // national_permit
            $this->national_permit->HrefValue = "";

            // pollution
            $this->pollution->HrefValue = "";

            // fitness
            $this->fitness->HrefValue = "";

            // other_due
            $this->other_due->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // type
            $this->type->setupEditAttributes();
            $this->type->EditValue = $this->type->options(true);
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // vehicle_owner
            $this->vehicle_owner->setupEditAttributes();
            $curVal = trim(strval($this->vehicle_owner->CurrentValue));
            if ($curVal != "") {
                $this->vehicle_owner->ViewValue = $this->vehicle_owner->lookupCacheOption($curVal);
            } else {
                $this->vehicle_owner->ViewValue = $this->vehicle_owner->Lookup !== null && is_array($this->vehicle_owner->lookupOptions()) && count($this->vehicle_owner->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->vehicle_owner->ViewValue !== null) { // Load from cache
                $this->vehicle_owner->EditValue = array_values($this->vehicle_owner->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->vehicle_owner->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->vehicle_owner->CurrentValue, $this->vehicle_owner->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->vehicle_owner->getSelectFilter($this); // PHP
                $sqlWrk = $this->vehicle_owner->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->vehicle_owner->EditValue = $arwrk;
            }
            $this->vehicle_owner->PlaceHolder = RemoveHtml($this->vehicle_owner->caption());

            // no
            $this->no->setupEditAttributes();
            if (!$this->no->Raw) {
                $this->no->CurrentValue = HtmlDecode($this->no->CurrentValue);
            }
            $this->no->EditValue = HtmlEncode($this->no->CurrentValue);
            $this->no->PlaceHolder = RemoveHtml($this->no->caption());

            // driver
            $this->driver->setupEditAttributes();
            $curVal = trim(strval($this->driver->CurrentValue));
            if ($curVal != "") {
                $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
            } else {
                $this->driver->ViewValue = $this->driver->Lookup !== null && is_array($this->driver->lookupOptions()) && count($this->driver->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->driver->ViewValue !== null) { // Load from cache
                $this->driver->EditValue = array_values($this->driver->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->driver->CurrentValue, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                $sqlWrk = $this->driver->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->driver->EditValue = $arwrk;
            }
            $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

            // driver_name
            $this->driver_name->setupEditAttributes();
            if (!$this->driver_name->Raw) {
                $this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
            }
            $this->driver_name->EditValue = HtmlEncode($this->driver_name->CurrentValue);
            $this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

            // dor
            $this->dor->setupEditAttributes();
            $this->dor->EditValue = HtmlEncode(FormatDateTime($this->dor->CurrentValue, $this->dor->formatPattern()));
            $this->dor->PlaceHolder = RemoveHtml($this->dor->caption());

            // km_hour
            $this->km_hour->setupEditAttributes();
            $this->km_hour->EditValue = $this->km_hour->CurrentValue;
            $this->km_hour->PlaceHolder = RemoveHtml($this->km_hour->caption());
            if (strval($this->km_hour->EditValue) != "" && is_numeric($this->km_hour->EditValue)) {
                $this->km_hour->EditValue = FormatNumber($this->km_hour->EditValue, null);
            }

            // chassis_no
            $this->chassis_no->setupEditAttributes();
            if (!$this->chassis_no->Raw) {
                $this->chassis_no->CurrentValue = HtmlDecode($this->chassis_no->CurrentValue);
            }
            $this->chassis_no->EditValue = HtmlEncode($this->chassis_no->CurrentValue);
            $this->chassis_no->PlaceHolder = RemoveHtml($this->chassis_no->caption());

            // engine_no
            $this->engine_no->setupEditAttributes();
            if (!$this->engine_no->Raw) {
                $this->engine_no->CurrentValue = HtmlDecode($this->engine_no->CurrentValue);
            }
            $this->engine_no->EditValue = HtmlEncode($this->engine_no->CurrentValue);
            $this->engine_no->PlaceHolder = RemoveHtml($this->engine_no->caption());

            // load_average
            $this->load_average->setupEditAttributes();
            $this->load_average->EditValue = $this->load_average->CurrentValue;
            $this->load_average->PlaceHolder = RemoveHtml($this->load_average->caption());
            if (strval($this->load_average->EditValue) != "" && is_numeric($this->load_average->EditValue)) {
                $this->load_average->EditValue = FormatNumber($this->load_average->EditValue, null);
            }

            // unload_average
            $this->unload_average->setupEditAttributes();
            $this->unload_average->EditValue = $this->unload_average->CurrentValue;
            $this->unload_average->PlaceHolder = RemoveHtml($this->unload_average->caption());
            if (strval($this->unload_average->EditValue) != "" && is_numeric($this->unload_average->EditValue)) {
                $this->unload_average->EditValue = FormatNumber($this->unload_average->EditValue, null);
            }

            // load_expenses
            $this->load_expenses->setupEditAttributes();
            $this->load_expenses->EditValue = $this->load_expenses->CurrentValue;
            $this->load_expenses->PlaceHolder = RemoveHtml($this->load_expenses->caption());
            if (strval($this->load_expenses->EditValue) != "" && is_numeric($this->load_expenses->EditValue)) {
                $this->load_expenses->EditValue = FormatNumber($this->load_expenses->EditValue, null);
            }

            // unload_expenses
            $this->unload_expenses->setupEditAttributes();
            $this->unload_expenses->EditValue = $this->unload_expenses->CurrentValue;
            $this->unload_expenses->PlaceHolder = RemoveHtml($this->unload_expenses->caption());
            if (strval($this->unload_expenses->EditValue) != "" && is_numeric($this->unload_expenses->EditValue)) {
                $this->unload_expenses->EditValue = FormatNumber($this->unload_expenses->EditValue, null);
            }

            // insurance
            $this->insurance->setupEditAttributes();
            $this->insurance->EditValue = HtmlEncode(FormatDateTime($this->insurance->CurrentValue, $this->insurance->formatPattern()));
            $this->insurance->PlaceHolder = RemoveHtml($this->insurance->caption());

            // state_tax
            $this->state_tax->setupEditAttributes();
            $this->state_tax->EditValue = HtmlEncode(FormatDateTime($this->state_tax->CurrentValue, $this->state_tax->formatPattern()));
            $this->state_tax->PlaceHolder = RemoveHtml($this->state_tax->caption());

            // national_permit
            $this->national_permit->setupEditAttributes();
            $this->national_permit->EditValue = HtmlEncode(FormatDateTime($this->national_permit->CurrentValue, $this->national_permit->formatPattern()));
            $this->national_permit->PlaceHolder = RemoveHtml($this->national_permit->caption());

            // pollution
            $this->pollution->setupEditAttributes();
            $this->pollution->EditValue = HtmlEncode(FormatDateTime($this->pollution->CurrentValue, $this->pollution->formatPattern()));
            $this->pollution->PlaceHolder = RemoveHtml($this->pollution->caption());

            // fitness
            $this->fitness->setupEditAttributes();
            $this->fitness->EditValue = HtmlEncode(FormatDateTime($this->fitness->CurrentValue, $this->fitness->formatPattern()));
            $this->fitness->PlaceHolder = RemoveHtml($this->fitness->caption());

            // other_due
            $this->other_due->setupEditAttributes();
            $this->other_due->EditValue = HtmlEncode(FormatDateTime($this->other_due->CurrentValue, $this->other_due->formatPattern()));
            $this->other_due->PlaceHolder = RemoveHtml($this->other_due->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // Add refer script

            // type
            $this->type->HrefValue = "";

            // vehicle_owner
            $this->vehicle_owner->HrefValue = "";

            // no
            $this->no->HrefValue = "";

            // driver
            $this->driver->HrefValue = "";

            // driver_name
            $this->driver_name->HrefValue = "";

            // dor
            $this->dor->HrefValue = "";

            // km_hour
            $this->km_hour->HrefValue = "";

            // chassis_no
            $this->chassis_no->HrefValue = "";

            // engine_no
            $this->engine_no->HrefValue = "";

            // load_average
            $this->load_average->HrefValue = "";

            // unload_average
            $this->unload_average->HrefValue = "";

            // load_expenses
            $this->load_expenses->HrefValue = "";

            // unload_expenses
            $this->unload_expenses->HrefValue = "";

            // insurance
            $this->insurance->HrefValue = "";

            // state_tax
            $this->state_tax->HrefValue = "";

            // national_permit
            $this->national_permit->HrefValue = "";

            // pollution
            $this->pollution->HrefValue = "";

            // fitness
            $this->fitness->HrefValue = "";

            // other_due
            $this->other_due->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Render add option
    public function renderAddOpt($row)
    {
        global $Security, $Language, $CurrentLanguage;

        // Set up CurrentValue
        $this->type->CurrentValue = $row["type"] ?? null;
        $this->vehicle_owner->CurrentValue = $row["vehicle_owner"] ?? null;
        $this->no->CurrentValue = $row["no"] ?? null;
        $this->driver->CurrentValue = $row["driver"] ?? null;
        $this->driver_name->CurrentValue = $row["driver_name"] ?? null;
        $this->dor->CurrentValue = $row["dor"] ?? null;
        $this->km_hour->CurrentValue = $row["km_hour"] ?? null;
        $this->chassis_no->CurrentValue = $row["chassis_no"] ?? null;
        $this->engine_no->CurrentValue = $row["engine_no"] ?? null;
        $this->load_average->CurrentValue = $row["load_average"] ?? null;
        $this->unload_average->CurrentValue = $row["unload_average"] ?? null;
        $this->load_expenses->CurrentValue = $row["load_expenses"] ?? null;
        $this->unload_expenses->CurrentValue = $row["unload_expenses"] ?? null;
        $this->insurance->CurrentValue = $row["insurance"] ?? null;
        $this->state_tax->CurrentValue = $row["state_tax"] ?? null;
        $this->national_permit->CurrentValue = $row["national_permit"] ?? null;
        $this->pollution->CurrentValue = $row["pollution"] ?? null;
        $this->fitness->CurrentValue = $row["fitness"] ?? null;
        $this->other_due->CurrentValue = $row["other_due"] ?? null;
        $this->status->CurrentValue = $row["status"] ?? null;
        $this->operator->CurrentValue = $row["operator"] ?? null;
        $this->datetime->CurrentValue = $row["datetime"] ?? null;

        // type
        if (strval($this->type->CurrentValue) != "") {
            $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
        } else {
            $this->type->ViewValue = null;
        }

        // vehicle_owner
        $curVal = strval($this->vehicle_owner->CurrentValue);
        if ($curVal != "") {
            $this->vehicle_owner->ViewValue = $this->vehicle_owner->lookupCacheOption($curVal);
            if ($this->vehicle_owner->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->vehicle_owner->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle_owner->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->vehicle_owner->getSelectFilter($this); // PHP
                $sqlWrk = $this->vehicle_owner->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->vehicle_owner->Lookup->renderViewRow($rswrk[0]);
                    $this->vehicle_owner->ViewValue = $this->vehicle_owner->displayValue($arwrk);
                } else {
                    $this->vehicle_owner->ViewValue = FormatNumber($this->vehicle_owner->CurrentValue, $this->vehicle_owner->formatPattern());
                }
            }
        } else {
            $this->vehicle_owner->ViewValue = null;
        }

        // no
        $this->no->ViewValue = $this->no->CurrentValue;

        // driver
        $curVal = strval($this->driver->CurrentValue);
        if ($curVal != "") {
            $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
            if ($this->driver->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                $sqlWrk = $this->driver->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->driver->Lookup->renderViewRow($rswrk[0]);
                    $this->driver->ViewValue = $this->driver->displayValue($arwrk);
                } else {
                    $this->driver->ViewValue = FormatNumber($this->driver->CurrentValue, $this->driver->formatPattern());
                }
            }
        } else {
            $this->driver->ViewValue = null;
        }

        // driver_name
        $this->driver_name->ViewValue = $this->driver_name->CurrentValue;

        // dor
        $this->dor->ViewValue = $this->dor->CurrentValue;
        $this->dor->ViewValue = FormatDateTime($this->dor->ViewValue, $this->dor->formatPattern());

        // km_hour
        $this->km_hour->ViewValue = $this->km_hour->CurrentValue;
        $this->km_hour->ViewValue = FormatNumber($this->km_hour->ViewValue, $this->km_hour->formatPattern());

        // chassis_no
        $this->chassis_no->ViewValue = $this->chassis_no->CurrentValue;

        // engine_no
        $this->engine_no->ViewValue = $this->engine_no->CurrentValue;

        // load_average
        $this->load_average->ViewValue = $this->load_average->CurrentValue;
        $this->load_average->ViewValue = FormatNumber($this->load_average->ViewValue, $this->load_average->formatPattern());

        // unload_average
        $this->unload_average->ViewValue = $this->unload_average->CurrentValue;
        $this->unload_average->ViewValue = FormatNumber($this->unload_average->ViewValue, $this->unload_average->formatPattern());

        // load_expenses
        $this->load_expenses->ViewValue = $this->load_expenses->CurrentValue;
        $this->load_expenses->ViewValue = FormatNumber($this->load_expenses->ViewValue, $this->load_expenses->formatPattern());

        // unload_expenses
        $this->unload_expenses->ViewValue = $this->unload_expenses->CurrentValue;
        $this->unload_expenses->ViewValue = FormatNumber($this->unload_expenses->ViewValue, $this->unload_expenses->formatPattern());

        // insurance
        $this->insurance->ViewValue = $this->insurance->CurrentValue;
        $this->insurance->ViewValue = FormatDateTime($this->insurance->ViewValue, $this->insurance->formatPattern());

        // state_tax
        $this->state_tax->ViewValue = $this->state_tax->CurrentValue;
        $this->state_tax->ViewValue = FormatDateTime($this->state_tax->ViewValue, $this->state_tax->formatPattern());

        // national_permit
        $this->national_permit->ViewValue = $this->national_permit->CurrentValue;
        $this->national_permit->ViewValue = FormatDateTime($this->national_permit->ViewValue, $this->national_permit->formatPattern());

        // pollution
        $this->pollution->ViewValue = $this->pollution->CurrentValue;
        $this->pollution->ViewValue = FormatDateTime($this->pollution->ViewValue, $this->pollution->formatPattern());

        // fitness
        $this->fitness->ViewValue = $this->fitness->CurrentValue;
        $this->fitness->ViewValue = FormatDateTime($this->fitness->ViewValue, $this->fitness->formatPattern());

        // other_due
        $this->other_due->ViewValue = $this->other_due->CurrentValue;
        $this->other_due->ViewValue = FormatDateTime($this->other_due->ViewValue, $this->other_due->formatPattern());

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // Set up $row
        $row["vehicle_owner"] = $this->vehicle_owner->ViewValue;
        $row["no"] = $this->no->ViewValue;
        $row["driver"] = $this->driver->ViewValue;
        $row["driver_name"] = $this->driver_name->ViewValue;
        $row["dor"] = $this->dor->ViewValue;
        $row["km_hour"] = $this->km_hour->ViewValue;
        $row["chassis_no"] = $this->chassis_no->ViewValue;
        $row["engine_no"] = $this->engine_no->ViewValue;
        $row["load_average"] = $this->load_average->ViewValue;
        $row["unload_average"] = $this->unload_average->ViewValue;
        $row["load_expenses"] = $this->load_expenses->ViewValue;
        $row["unload_expenses"] = $this->unload_expenses->ViewValue;
        $row["insurance"] = $this->insurance->ViewValue;
        $row["state_tax"] = $this->state_tax->ViewValue;
        $row["national_permit"] = $this->national_permit->ViewValue;
        $row["pollution"] = $this->pollution->ViewValue;
        $row["fitness"] = $this->fitness->ViewValue;
        $row["other_due"] = $this->other_due->ViewValue;
        $row["status"] = $this->status->ViewValue;
        $row["operator"] = $this->operator->ViewValue;
        $row["datetime"] = $this->datetime->ViewValue;
        return $row;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->type->Visible && $this->type->Required) {
                if (!$this->type->IsDetailKey && EmptyValue($this->type->FormValue)) {
                    $this->type->addErrorMessage(str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
                }
            }
            if ($this->vehicle_owner->Visible && $this->vehicle_owner->Required) {
                if (!$this->vehicle_owner->IsDetailKey && EmptyValue($this->vehicle_owner->FormValue)) {
                    $this->vehicle_owner->addErrorMessage(str_replace("%s", $this->vehicle_owner->caption(), $this->vehicle_owner->RequiredErrorMessage));
                }
            }
            if ($this->no->Visible && $this->no->Required) {
                if (!$this->no->IsDetailKey && EmptyValue($this->no->FormValue)) {
                    $this->no->addErrorMessage(str_replace("%s", $this->no->caption(), $this->no->RequiredErrorMessage));
                }
            }
            if ($this->driver->Visible && $this->driver->Required) {
                if (!$this->driver->IsDetailKey && EmptyValue($this->driver->FormValue)) {
                    $this->driver->addErrorMessage(str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
                }
            }
            if ($this->driver_name->Visible && $this->driver_name->Required) {
                if (!$this->driver_name->IsDetailKey && EmptyValue($this->driver_name->FormValue)) {
                    $this->driver_name->addErrorMessage(str_replace("%s", $this->driver_name->caption(), $this->driver_name->RequiredErrorMessage));
                }
            }
            if ($this->dor->Visible && $this->dor->Required) {
                if (!$this->dor->IsDetailKey && EmptyValue($this->dor->FormValue)) {
                    $this->dor->addErrorMessage(str_replace("%s", $this->dor->caption(), $this->dor->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dor->FormValue, $this->dor->formatPattern())) {
                $this->dor->addErrorMessage($this->dor->getErrorMessage(false));
            }
            if ($this->km_hour->Visible && $this->km_hour->Required) {
                if (!$this->km_hour->IsDetailKey && EmptyValue($this->km_hour->FormValue)) {
                    $this->km_hour->addErrorMessage(str_replace("%s", $this->km_hour->caption(), $this->km_hour->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->km_hour->FormValue)) {
                $this->km_hour->addErrorMessage($this->km_hour->getErrorMessage(false));
            }
            if ($this->chassis_no->Visible && $this->chassis_no->Required) {
                if (!$this->chassis_no->IsDetailKey && EmptyValue($this->chassis_no->FormValue)) {
                    $this->chassis_no->addErrorMessage(str_replace("%s", $this->chassis_no->caption(), $this->chassis_no->RequiredErrorMessage));
                }
            }
            if ($this->engine_no->Visible && $this->engine_no->Required) {
                if (!$this->engine_no->IsDetailKey && EmptyValue($this->engine_no->FormValue)) {
                    $this->engine_no->addErrorMessage(str_replace("%s", $this->engine_no->caption(), $this->engine_no->RequiredErrorMessage));
                }
            }
            if ($this->load_average->Visible && $this->load_average->Required) {
                if (!$this->load_average->IsDetailKey && EmptyValue($this->load_average->FormValue)) {
                    $this->load_average->addErrorMessage(str_replace("%s", $this->load_average->caption(), $this->load_average->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->load_average->FormValue)) {
                $this->load_average->addErrorMessage($this->load_average->getErrorMessage(false));
            }
            if ($this->unload_average->Visible && $this->unload_average->Required) {
                if (!$this->unload_average->IsDetailKey && EmptyValue($this->unload_average->FormValue)) {
                    $this->unload_average->addErrorMessage(str_replace("%s", $this->unload_average->caption(), $this->unload_average->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->unload_average->FormValue)) {
                $this->unload_average->addErrorMessage($this->unload_average->getErrorMessage(false));
            }
            if ($this->load_expenses->Visible && $this->load_expenses->Required) {
                if (!$this->load_expenses->IsDetailKey && EmptyValue($this->load_expenses->FormValue)) {
                    $this->load_expenses->addErrorMessage(str_replace("%s", $this->load_expenses->caption(), $this->load_expenses->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->load_expenses->FormValue)) {
                $this->load_expenses->addErrorMessage($this->load_expenses->getErrorMessage(false));
            }
            if ($this->unload_expenses->Visible && $this->unload_expenses->Required) {
                if (!$this->unload_expenses->IsDetailKey && EmptyValue($this->unload_expenses->FormValue)) {
                    $this->unload_expenses->addErrorMessage(str_replace("%s", $this->unload_expenses->caption(), $this->unload_expenses->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->unload_expenses->FormValue)) {
                $this->unload_expenses->addErrorMessage($this->unload_expenses->getErrorMessage(false));
            }
            if ($this->insurance->Visible && $this->insurance->Required) {
                if (!$this->insurance->IsDetailKey && EmptyValue($this->insurance->FormValue)) {
                    $this->insurance->addErrorMessage(str_replace("%s", $this->insurance->caption(), $this->insurance->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->insurance->FormValue, $this->insurance->formatPattern())) {
                $this->insurance->addErrorMessage($this->insurance->getErrorMessage(false));
            }
            if ($this->state_tax->Visible && $this->state_tax->Required) {
                if (!$this->state_tax->IsDetailKey && EmptyValue($this->state_tax->FormValue)) {
                    $this->state_tax->addErrorMessage(str_replace("%s", $this->state_tax->caption(), $this->state_tax->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->state_tax->FormValue, $this->state_tax->formatPattern())) {
                $this->state_tax->addErrorMessage($this->state_tax->getErrorMessage(false));
            }
            if ($this->national_permit->Visible && $this->national_permit->Required) {
                if (!$this->national_permit->IsDetailKey && EmptyValue($this->national_permit->FormValue)) {
                    $this->national_permit->addErrorMessage(str_replace("%s", $this->national_permit->caption(), $this->national_permit->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->national_permit->FormValue, $this->national_permit->formatPattern())) {
                $this->national_permit->addErrorMessage($this->national_permit->getErrorMessage(false));
            }
            if ($this->pollution->Visible && $this->pollution->Required) {
                if (!$this->pollution->IsDetailKey && EmptyValue($this->pollution->FormValue)) {
                    $this->pollution->addErrorMessage(str_replace("%s", $this->pollution->caption(), $this->pollution->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->pollution->FormValue, $this->pollution->formatPattern())) {
                $this->pollution->addErrorMessage($this->pollution->getErrorMessage(false));
            }
            if ($this->fitness->Visible && $this->fitness->Required) {
                if (!$this->fitness->IsDetailKey && EmptyValue($this->fitness->FormValue)) {
                    $this->fitness->addErrorMessage(str_replace("%s", $this->fitness->caption(), $this->fitness->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->fitness->FormValue, $this->fitness->formatPattern())) {
                $this->fitness->addErrorMessage($this->fitness->getErrorMessage(false));
            }
            if ($this->other_due->Visible && $this->other_due->Required) {
                if (!$this->other_due->IsDetailKey && EmptyValue($this->other_due->FormValue)) {
                    $this->other_due->addErrorMessage(str_replace("%s", $this->other_due->caption(), $this->other_due->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->other_due->FormValue, $this->other_due->formatPattern())) {
                $this->other_due->addErrorMessage($this->other_due->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            if (Post("addopt") == "1") { // Render for add option response
                $row = $this->renderAddOpt($row);
            }
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // type
        $this->type->setDbValueDef($rsnew, $this->type->CurrentValue, strval($this->type->CurrentValue) == "");

        // vehicle_owner
        $this->vehicle_owner->setDbValueDef($rsnew, $this->vehicle_owner->CurrentValue, false);

        // no
        $this->no->setDbValueDef($rsnew, $this->no->CurrentValue, false);

        // driver
        $this->driver->setDbValueDef($rsnew, $this->driver->CurrentValue, false);

        // driver_name
        $this->driver_name->setDbValueDef($rsnew, $this->driver_name->CurrentValue, false);

        // dor
        $this->dor->setDbValueDef($rsnew, UnFormatDateTime($this->dor->CurrentValue, $this->dor->formatPattern()), false);

        // km_hour
        $this->km_hour->setDbValueDef($rsnew, $this->km_hour->CurrentValue, strval($this->km_hour->CurrentValue) == "");

        // chassis_no
        $this->chassis_no->setDbValueDef($rsnew, $this->chassis_no->CurrentValue, false);

        // engine_no
        $this->engine_no->setDbValueDef($rsnew, $this->engine_no->CurrentValue, false);

        // load_average
        $this->load_average->setDbValueDef($rsnew, $this->load_average->CurrentValue, false);

        // unload_average
        $this->unload_average->setDbValueDef($rsnew, $this->unload_average->CurrentValue, false);

        // load_expenses
        $this->load_expenses->setDbValueDef($rsnew, $this->load_expenses->CurrentValue, false);

        // unload_expenses
        $this->unload_expenses->setDbValueDef($rsnew, $this->unload_expenses->CurrentValue, false);

        // insurance
        $this->insurance->setDbValueDef($rsnew, UnFormatDateTime($this->insurance->CurrentValue, $this->insurance->formatPattern()), false);

        // state_tax
        $this->state_tax->setDbValueDef($rsnew, UnFormatDateTime($this->state_tax->CurrentValue, $this->state_tax->formatPattern()), false);

        // national_permit
        $this->national_permit->setDbValueDef($rsnew, UnFormatDateTime($this->national_permit->CurrentValue, $this->national_permit->formatPattern()), false);

        // pollution
        $this->pollution->setDbValueDef($rsnew, UnFormatDateTime($this->pollution->CurrentValue, $this->pollution->formatPattern()), false);

        // fitness
        $this->fitness->setDbValueDef($rsnew, UnFormatDateTime($this->fitness->CurrentValue, $this->fitness->formatPattern()), false);

        // other_due
        $this->other_due->setDbValueDef($rsnew, UnFormatDateTime($this->other_due->CurrentValue, $this->other_due->formatPattern()), false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, strval($this->status->CurrentValue) == "");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['type'])) { // type
            $this->type->setFormValue($row['type']);
        }
        if (isset($row['vehicle_owner'])) { // vehicle_owner
            $this->vehicle_owner->setFormValue($row['vehicle_owner']);
        }
        if (isset($row['no'])) { // no
            $this->no->setFormValue($row['no']);
        }
        if (isset($row['driver'])) { // driver
            $this->driver->setFormValue($row['driver']);
        }
        if (isset($row['driver_name'])) { // driver_name
            $this->driver_name->setFormValue($row['driver_name']);
        }
        if (isset($row['dor'])) { // dor
            $this->dor->setFormValue($row['dor']);
        }
        if (isset($row['km_hour'])) { // km_hour
            $this->km_hour->setFormValue($row['km_hour']);
        }
        if (isset($row['chassis_no'])) { // chassis_no
            $this->chassis_no->setFormValue($row['chassis_no']);
        }
        if (isset($row['engine_no'])) { // engine_no
            $this->engine_no->setFormValue($row['engine_no']);
        }
        if (isset($row['load_average'])) { // load_average
            $this->load_average->setFormValue($row['load_average']);
        }
        if (isset($row['unload_average'])) { // unload_average
            $this->unload_average->setFormValue($row['unload_average']);
        }
        if (isset($row['load_expenses'])) { // load_expenses
            $this->load_expenses->setFormValue($row['load_expenses']);
        }
        if (isset($row['unload_expenses'])) { // unload_expenses
            $this->unload_expenses->setFormValue($row['unload_expenses']);
        }
        if (isset($row['insurance'])) { // insurance
            $this->insurance->setFormValue($row['insurance']);
        }
        if (isset($row['state_tax'])) { // state_tax
            $this->state_tax->setFormValue($row['state_tax']);
        }
        if (isset($row['national_permit'])) { // national_permit
            $this->national_permit->setFormValue($row['national_permit']);
        }
        if (isset($row['pollution'])) { // pollution
            $this->pollution->setFormValue($row['pollution']);
        }
        if (isset($row['fitness'])) { // fitness
            $this->fitness->setFormValue($row['fitness']);
        }
        if (isset($row['other_due'])) { // other_due
            $this->other_due->setFormValue($row['other_due']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("vehicleinfolist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_type":
                    break;
                case "x_vehicle_owner":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_driver":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                case "x_running_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
