<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for vehicle_info
 */
class VehicleInfo extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $type;
    public $vehicle_owner;
    public $no;
    public $driver;
    public $driver_name;
    public $dor;
    public $km_hour;
    public $chassis_no;
    public $engine_no;
    public $load_average;
    public $unload_average;
    public $load_expenses;
    public $unload_expenses;
    public $insurance;
    public $state_tax;
    public $national_permit;
    public $pollution;
    public $fitness;
    public $other_due;
    public $status;
    public $operator;
    public $datetime;
    public $running_status;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "vehicle_info";
        $this->TableName = 'vehicle_info';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "vehicle_info";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // type
        $this->type = new DbField(
            $this, // Table
            'x_type', // Variable name
            'type', // Name
            '`type`', // Expression
            '`type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->type->addMethod("getDefault", fn() => 1);
        $this->type->InputTextType = "text";
        $this->type->Raw = true;
        $this->type->Nullable = false; // NOT NULL field
        $this->type->setSelectMultiple(false); // Select one
        $this->type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->type->Lookup = new Lookup($this->type, 'vehicle_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->type->OptionCount = 2;
        $this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['type'] = &$this->type;

        // vehicle_owner
        $this->vehicle_owner = new DbField(
            $this, // Table
            'x_vehicle_owner', // Variable name
            'vehicle_owner', // Name
            '`vehicle_owner`', // Expression
            '`vehicle_owner`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_owner`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->vehicle_owner->addMethod("getSelectFilter", fn() => "`category`= 902 and `status` = 1");
        $this->vehicle_owner->InputTextType = "text";
        $this->vehicle_owner->Raw = true;
        $this->vehicle_owner->setSelectMultiple(false); // Select one
        $this->vehicle_owner->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->vehicle_owner->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->vehicle_owner->Lookup = new Lookup($this->vehicle_owner, 'production_partner', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->vehicle_owner->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->vehicle_owner->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['vehicle_owner'] = &$this->vehicle_owner;

        // no
        $this->no = new DbField(
            $this, // Table
            'x_no', // Variable name
            'no', // Name
            '`no`', // Expression
            '`no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->no->InputTextType = "text";
        $this->no->Nullable = false; // NOT NULL field
        $this->no->Required = true; // Required field
        $this->no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['no'] = &$this->no;

        // driver
        $this->driver = new DbField(
            $this, // Table
            'x_driver', // Variable name
            'driver', // Name
            '`driver`', // Expression
            '`driver`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`driver`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->driver->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->driver->InputTextType = "text";
        $this->driver->Raw = true;
        $this->driver->Sortable = false; // Allow sort
        $this->driver->setSelectMultiple(false); // Select one
        $this->driver->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->driver->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->driver->Lookup = new Lookup($this->driver, 't_driver_info', false, 'id', ["name","mobile","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->driver) . "',COALESCE(`mobile`,''))");
        $this->driver->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->driver->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['driver'] = &$this->driver;

        // driver_name
        $this->driver_name = new DbField(
            $this, // Table
            'x_driver_name', // Variable name
            'driver_name', // Name
            '`driver_name`', // Expression
            '`driver_name`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`driver_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->driver_name->InputTextType = "text";
        $this->driver_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['driver_name'] = &$this->driver_name;

        // dor
        $this->dor = new DbField(
            $this, // Table
            'x_dor', // Variable name
            'dor', // Name
            '`dor`', // Expression
            CastDateFieldForLike("`dor`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`dor`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dor->InputTextType = "text";
        $this->dor->Raw = true;
        $this->dor->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->dor->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['dor'] = &$this->dor;

        // km_hour
        $this->km_hour = new DbField(
            $this, // Table
            'x_km_hour', // Variable name
            'km_hour', // Name
            '`km_hour`', // Expression
            '`km_hour`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`km_hour`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->km_hour->addMethod("getDefault", fn() => 0.00);
        $this->km_hour->InputTextType = "text";
        $this->km_hour->Raw = true;
        $this->km_hour->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->km_hour->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['km_hour'] = &$this->km_hour;

        // chassis_no
        $this->chassis_no = new DbField(
            $this, // Table
            'x_chassis_no', // Variable name
            'chassis_no', // Name
            '`chassis_no`', // Expression
            '`chassis_no`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`chassis_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->chassis_no->InputTextType = "text";
        $this->chassis_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['chassis_no'] = &$this->chassis_no;

        // engine_no
        $this->engine_no = new DbField(
            $this, // Table
            'x_engine_no', // Variable name
            'engine_no', // Name
            '`engine_no`', // Expression
            '`engine_no`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`engine_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->engine_no->InputTextType = "text";
        $this->engine_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['engine_no'] = &$this->engine_no;

        // load_average
        $this->load_average = new DbField(
            $this, // Table
            'x_load_average', // Variable name
            'load_average', // Name
            '`load_average`', // Expression
            '`load_average`', // Basic search expression
            131, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`load_average`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->load_average->InputTextType = "text";
        $this->load_average->Raw = true;
        $this->load_average->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->load_average->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['load_average'] = &$this->load_average;

        // unload_average
        $this->unload_average = new DbField(
            $this, // Table
            'x_unload_average', // Variable name
            'unload_average', // Name
            '`unload_average`', // Expression
            '`unload_average`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unload_average`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->unload_average->InputTextType = "text";
        $this->unload_average->Raw = true;
        $this->unload_average->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->unload_average->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unload_average'] = &$this->unload_average;

        // load_expenses
        $this->load_expenses = new DbField(
            $this, // Table
            'x_load_expenses', // Variable name
            'load_expenses', // Name
            '`load_expenses`', // Expression
            '`load_expenses`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`load_expenses`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->load_expenses->InputTextType = "text";
        $this->load_expenses->Raw = true;
        $this->load_expenses->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->load_expenses->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['load_expenses'] = &$this->load_expenses;

        // unload_expenses
        $this->unload_expenses = new DbField(
            $this, // Table
            'x_unload_expenses', // Variable name
            'unload_expenses', // Name
            '`unload_expenses`', // Expression
            '`unload_expenses`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unload_expenses`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->unload_expenses->InputTextType = "text";
        $this->unload_expenses->Raw = true;
        $this->unload_expenses->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->unload_expenses->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unload_expenses'] = &$this->unload_expenses;

        // insurance
        $this->insurance = new DbField(
            $this, // Table
            'x_insurance', // Variable name
            'insurance', // Name
            '`insurance`', // Expression
            CastDateFieldForLike("`insurance`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`insurance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->insurance->InputTextType = "text";
        $this->insurance->Raw = true;
        $this->insurance->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->insurance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['insurance'] = &$this->insurance;

        // state_tax
        $this->state_tax = new DbField(
            $this, // Table
            'x_state_tax', // Variable name
            'state_tax', // Name
            '`state_tax`', // Expression
            CastDateFieldForLike("`state_tax`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`state_tax`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->state_tax->InputTextType = "text";
        $this->state_tax->Raw = true;
        $this->state_tax->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->state_tax->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['state_tax'] = &$this->state_tax;

        // national_permit
        $this->national_permit = new DbField(
            $this, // Table
            'x_national_permit', // Variable name
            'national_permit', // Name
            '`national_permit`', // Expression
            CastDateFieldForLike("`national_permit`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`national_permit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->national_permit->InputTextType = "text";
        $this->national_permit->Raw = true;
        $this->national_permit->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->national_permit->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['national_permit'] = &$this->national_permit;

        // pollution
        $this->pollution = new DbField(
            $this, // Table
            'x_pollution', // Variable name
            'pollution', // Name
            '`pollution`', // Expression
            CastDateFieldForLike("`pollution`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`pollution`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pollution->InputTextType = "text";
        $this->pollution->Raw = true;
        $this->pollution->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->pollution->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pollution'] = &$this->pollution;

        // fitness
        $this->fitness = new DbField(
            $this, // Table
            'x_fitness', // Variable name
            'fitness', // Name
            '`fitness`', // Expression
            CastDateFieldForLike("`fitness`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`fitness`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fitness->InputTextType = "text";
        $this->fitness->Raw = true;
        $this->fitness->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->fitness->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['fitness'] = &$this->fitness;

        // other_due
        $this->other_due = new DbField(
            $this, // Table
            'x_other_due', // Variable name
            'other_due', // Name
            '`other_due`', // Expression
            CastDateFieldForLike("`other_due`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`other_due`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->other_due->InputTextType = "text";
        $this->other_due->Raw = true;
        $this->other_due->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->other_due->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['other_due'] = &$this->other_due;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 1);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->Required = true; // Required field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'vehicle_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // running_status
        $this->running_status = new DbField(
            $this, // Table
            'x_running_status', // Variable name
            'running_status', // Name
            '`running_status`', // Expression
            '`running_status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`running_status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->running_status->addMethod("getDefault", fn() => 0);
        $this->running_status->InputTextType = "text";
        $this->running_status->Raw = true;
        $this->running_status->Nullable = false; // NOT NULL field
        $this->running_status->setSelectMultiple(false); // Select one
        $this->running_status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->running_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->running_status->Lookup = new Lookup($this->running_status, 'vehicle_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->running_status->OptionCount = 2;
        $this->running_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->running_status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['running_status'] = &$this->running_status;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "vehicle_info";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->type->DbValue = $row['type'];
        $this->vehicle_owner->DbValue = $row['vehicle_owner'];
        $this->no->DbValue = $row['no'];
        $this->driver->DbValue = $row['driver'];
        $this->driver_name->DbValue = $row['driver_name'];
        $this->dor->DbValue = $row['dor'];
        $this->km_hour->DbValue = $row['km_hour'];
        $this->chassis_no->DbValue = $row['chassis_no'];
        $this->engine_no->DbValue = $row['engine_no'];
        $this->load_average->DbValue = $row['load_average'];
        $this->unload_average->DbValue = $row['unload_average'];
        $this->load_expenses->DbValue = $row['load_expenses'];
        $this->unload_expenses->DbValue = $row['unload_expenses'];
        $this->insurance->DbValue = $row['insurance'];
        $this->state_tax->DbValue = $row['state_tax'];
        $this->national_permit->DbValue = $row['national_permit'];
        $this->pollution->DbValue = $row['pollution'];
        $this->fitness->DbValue = $row['fitness'];
        $this->other_due->DbValue = $row['other_due'];
        $this->status->DbValue = $row['status'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->running_status->DbValue = $row['running_status'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("vehicleinfolist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "vehicleinfoview" => $Language->phrase("View"),
            "vehicleinfoedit" => $Language->phrase("Edit"),
            "vehicleinfoadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "vehicleinfolist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "VehicleInfoView",
            Config("API_ADD_ACTION") => "VehicleInfoAdd",
            Config("API_EDIT_ACTION") => "VehicleInfoEdit",
            Config("API_DELETE_ACTION") => "VehicleInfoDelete",
            Config("API_LIST_ACTION") => "VehicleInfoList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "vehicleinfolist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("vehicleinfoview", $parm);
        } else {
            $url = $this->keyUrl("vehicleinfoview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "vehicleinfoadd?" . $parm;
        } else {
            $url = "vehicleinfoadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("vehicleinfoedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("vehicleinfolist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("vehicleinfoadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("vehicleinfolist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("vehicleinfodelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->type->setDbValue($row['type']);
        $this->vehicle_owner->setDbValue($row['vehicle_owner']);
        $this->no->setDbValue($row['no']);
        $this->driver->setDbValue($row['driver']);
        $this->driver_name->setDbValue($row['driver_name']);
        $this->dor->setDbValue($row['dor']);
        $this->km_hour->setDbValue($row['km_hour']);
        $this->chassis_no->setDbValue($row['chassis_no']);
        $this->engine_no->setDbValue($row['engine_no']);
        $this->load_average->setDbValue($row['load_average']);
        $this->unload_average->setDbValue($row['unload_average']);
        $this->load_expenses->setDbValue($row['load_expenses']);
        $this->unload_expenses->setDbValue($row['unload_expenses']);
        $this->insurance->setDbValue($row['insurance']);
        $this->state_tax->setDbValue($row['state_tax']);
        $this->national_permit->setDbValue($row['national_permit']);
        $this->pollution->setDbValue($row['pollution']);
        $this->fitness->setDbValue($row['fitness']);
        $this->other_due->setDbValue($row['other_due']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->running_status->setDbValue($row['running_status']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "VehicleInfoList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // type

        // vehicle_owner

        // no

        // driver
        $this->driver->CellCssStyle = "white-space: nowrap;";

        // driver_name

        // dor

        // km_hour

        // chassis_no

        // engine_no

        // load_average

        // unload_average

        // load_expenses

        // unload_expenses

        // insurance

        // state_tax

        // national_permit

        // pollution

        // fitness

        // other_due

        // status

        // operator

        // datetime

        // running_status

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // type
        if (strval($this->type->CurrentValue) != "") {
            $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
        } else {
            $this->type->ViewValue = null;
        }

        // vehicle_owner
        $curVal = strval($this->vehicle_owner->CurrentValue);
        if ($curVal != "") {
            $this->vehicle_owner->ViewValue = $this->vehicle_owner->lookupCacheOption($curVal);
            if ($this->vehicle_owner->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->vehicle_owner->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle_owner->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->vehicle_owner->getSelectFilter($this); // PHP
                $sqlWrk = $this->vehicle_owner->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->vehicle_owner->Lookup->renderViewRow($rswrk[0]);
                    $this->vehicle_owner->ViewValue = $this->vehicle_owner->displayValue($arwrk);
                } else {
                    $this->vehicle_owner->ViewValue = FormatNumber($this->vehicle_owner->CurrentValue, $this->vehicle_owner->formatPattern());
                }
            }
        } else {
            $this->vehicle_owner->ViewValue = null;
        }

        // no
        $this->no->ViewValue = $this->no->CurrentValue;

        // driver
        $curVal = strval($this->driver->CurrentValue);
        if ($curVal != "") {
            $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
            if ($this->driver->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                $sqlWrk = $this->driver->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->driver->Lookup->renderViewRow($rswrk[0]);
                    $this->driver->ViewValue = $this->driver->displayValue($arwrk);
                } else {
                    $this->driver->ViewValue = FormatNumber($this->driver->CurrentValue, $this->driver->formatPattern());
                }
            }
        } else {
            $this->driver->ViewValue = null;
        }

        // driver_name
        $this->driver_name->ViewValue = $this->driver_name->CurrentValue;

        // dor
        $this->dor->ViewValue = $this->dor->CurrentValue;
        $this->dor->ViewValue = FormatDateTime($this->dor->ViewValue, $this->dor->formatPattern());

        // km_hour
        $this->km_hour->ViewValue = $this->km_hour->CurrentValue;
        $this->km_hour->ViewValue = FormatNumber($this->km_hour->ViewValue, $this->km_hour->formatPattern());

        // chassis_no
        $this->chassis_no->ViewValue = $this->chassis_no->CurrentValue;

        // engine_no
        $this->engine_no->ViewValue = $this->engine_no->CurrentValue;

        // load_average
        $this->load_average->ViewValue = $this->load_average->CurrentValue;
        $this->load_average->ViewValue = FormatNumber($this->load_average->ViewValue, $this->load_average->formatPattern());

        // unload_average
        $this->unload_average->ViewValue = $this->unload_average->CurrentValue;
        $this->unload_average->ViewValue = FormatNumber($this->unload_average->ViewValue, $this->unload_average->formatPattern());

        // load_expenses
        $this->load_expenses->ViewValue = $this->load_expenses->CurrentValue;
        $this->load_expenses->ViewValue = FormatNumber($this->load_expenses->ViewValue, $this->load_expenses->formatPattern());

        // unload_expenses
        $this->unload_expenses->ViewValue = $this->unload_expenses->CurrentValue;
        $this->unload_expenses->ViewValue = FormatNumber($this->unload_expenses->ViewValue, $this->unload_expenses->formatPattern());

        // insurance
        $this->insurance->ViewValue = $this->insurance->CurrentValue;
        $this->insurance->ViewValue = FormatDateTime($this->insurance->ViewValue, $this->insurance->formatPattern());

        // state_tax
        $this->state_tax->ViewValue = $this->state_tax->CurrentValue;
        $this->state_tax->ViewValue = FormatDateTime($this->state_tax->ViewValue, $this->state_tax->formatPattern());

        // national_permit
        $this->national_permit->ViewValue = $this->national_permit->CurrentValue;
        $this->national_permit->ViewValue = FormatDateTime($this->national_permit->ViewValue, $this->national_permit->formatPattern());

        // pollution
        $this->pollution->ViewValue = $this->pollution->CurrentValue;
        $this->pollution->ViewValue = FormatDateTime($this->pollution->ViewValue, $this->pollution->formatPattern());

        // fitness
        $this->fitness->ViewValue = $this->fitness->CurrentValue;
        $this->fitness->ViewValue = FormatDateTime($this->fitness->ViewValue, $this->fitness->formatPattern());

        // other_due
        $this->other_due->ViewValue = $this->other_due->CurrentValue;
        $this->other_due->ViewValue = FormatDateTime($this->other_due->ViewValue, $this->other_due->formatPattern());

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // running_status
        if (strval($this->running_status->CurrentValue) != "") {
            $this->running_status->ViewValue = $this->running_status->optionCaption($this->running_status->CurrentValue);
        } else {
            $this->running_status->ViewValue = null;
        }

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // type
        $this->type->HrefValue = "";
        $this->type->TooltipValue = "";

        // vehicle_owner
        $this->vehicle_owner->HrefValue = "";
        $this->vehicle_owner->TooltipValue = "";

        // no
        $this->no->HrefValue = "";
        $this->no->TooltipValue = "";

        // driver
        $this->driver->HrefValue = "";
        $this->driver->TooltipValue = "";

        // driver_name
        $this->driver_name->HrefValue = "";
        $this->driver_name->TooltipValue = "";

        // dor
        $this->dor->HrefValue = "";
        $this->dor->TooltipValue = "";

        // km_hour
        $this->km_hour->HrefValue = "";
        $this->km_hour->TooltipValue = "";

        // chassis_no
        $this->chassis_no->HrefValue = "";
        $this->chassis_no->TooltipValue = "";

        // engine_no
        $this->engine_no->HrefValue = "";
        $this->engine_no->TooltipValue = "";

        // load_average
        $this->load_average->HrefValue = "";
        $this->load_average->TooltipValue = "";

        // unload_average
        $this->unload_average->HrefValue = "";
        $this->unload_average->TooltipValue = "";

        // load_expenses
        $this->load_expenses->HrefValue = "";
        $this->load_expenses->TooltipValue = "";

        // unload_expenses
        $this->unload_expenses->HrefValue = "";
        $this->unload_expenses->TooltipValue = "";

        // insurance
        $this->insurance->HrefValue = "";
        $this->insurance->TooltipValue = "";

        // state_tax
        $this->state_tax->HrefValue = "";
        $this->state_tax->TooltipValue = "";

        // national_permit
        $this->national_permit->HrefValue = "";
        $this->national_permit->TooltipValue = "";

        // pollution
        $this->pollution->HrefValue = "";
        $this->pollution->TooltipValue = "";

        // fitness
        $this->fitness->HrefValue = "";
        $this->fitness->TooltipValue = "";

        // other_due
        $this->other_due->HrefValue = "";
        $this->other_due->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // running_status
        $this->running_status->HrefValue = "";
        $this->running_status->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // type
        $this->type->setupEditAttributes();
        $this->type->EditValue = $this->type->options(true);
        $this->type->PlaceHolder = RemoveHtml($this->type->caption());

        // vehicle_owner
        $this->vehicle_owner->setupEditAttributes();
        $this->vehicle_owner->PlaceHolder = RemoveHtml($this->vehicle_owner->caption());

        // no
        $this->no->setupEditAttributes();
        if (!$this->no->Raw) {
            $this->no->CurrentValue = HtmlDecode($this->no->CurrentValue);
        }
        $this->no->EditValue = $this->no->CurrentValue;
        $this->no->PlaceHolder = RemoveHtml($this->no->caption());

        // driver
        $this->driver->setupEditAttributes();
        $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

        // driver_name
        $this->driver_name->setupEditAttributes();
        if (!$this->driver_name->Raw) {
            $this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
        }
        $this->driver_name->EditValue = $this->driver_name->CurrentValue;
        $this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

        // dor
        $this->dor->setupEditAttributes();
        $this->dor->EditValue = FormatDateTime($this->dor->CurrentValue, $this->dor->formatPattern());
        $this->dor->PlaceHolder = RemoveHtml($this->dor->caption());

        // km_hour
        $this->km_hour->setupEditAttributes();
        $this->km_hour->EditValue = $this->km_hour->CurrentValue;
        $this->km_hour->PlaceHolder = RemoveHtml($this->km_hour->caption());
        if (strval($this->km_hour->EditValue) != "" && is_numeric($this->km_hour->EditValue)) {
            $this->km_hour->EditValue = FormatNumber($this->km_hour->EditValue, null);
        }

        // chassis_no
        $this->chassis_no->setupEditAttributes();
        if (!$this->chassis_no->Raw) {
            $this->chassis_no->CurrentValue = HtmlDecode($this->chassis_no->CurrentValue);
        }
        $this->chassis_no->EditValue = $this->chassis_no->CurrentValue;
        $this->chassis_no->PlaceHolder = RemoveHtml($this->chassis_no->caption());

        // engine_no
        $this->engine_no->setupEditAttributes();
        if (!$this->engine_no->Raw) {
            $this->engine_no->CurrentValue = HtmlDecode($this->engine_no->CurrentValue);
        }
        $this->engine_no->EditValue = $this->engine_no->CurrentValue;
        $this->engine_no->PlaceHolder = RemoveHtml($this->engine_no->caption());

        // load_average
        $this->load_average->setupEditAttributes();
        $this->load_average->EditValue = $this->load_average->CurrentValue;
        $this->load_average->PlaceHolder = RemoveHtml($this->load_average->caption());
        if (strval($this->load_average->EditValue) != "" && is_numeric($this->load_average->EditValue)) {
            $this->load_average->EditValue = FormatNumber($this->load_average->EditValue, null);
        }

        // unload_average
        $this->unload_average->setupEditAttributes();
        $this->unload_average->EditValue = $this->unload_average->CurrentValue;
        $this->unload_average->PlaceHolder = RemoveHtml($this->unload_average->caption());
        if (strval($this->unload_average->EditValue) != "" && is_numeric($this->unload_average->EditValue)) {
            $this->unload_average->EditValue = FormatNumber($this->unload_average->EditValue, null);
        }

        // load_expenses
        $this->load_expenses->setupEditAttributes();
        $this->load_expenses->EditValue = $this->load_expenses->CurrentValue;
        $this->load_expenses->PlaceHolder = RemoveHtml($this->load_expenses->caption());
        if (strval($this->load_expenses->EditValue) != "" && is_numeric($this->load_expenses->EditValue)) {
            $this->load_expenses->EditValue = FormatNumber($this->load_expenses->EditValue, null);
        }

        // unload_expenses
        $this->unload_expenses->setupEditAttributes();
        $this->unload_expenses->EditValue = $this->unload_expenses->CurrentValue;
        $this->unload_expenses->PlaceHolder = RemoveHtml($this->unload_expenses->caption());
        if (strval($this->unload_expenses->EditValue) != "" && is_numeric($this->unload_expenses->EditValue)) {
            $this->unload_expenses->EditValue = FormatNumber($this->unload_expenses->EditValue, null);
        }

        // insurance
        $this->insurance->setupEditAttributes();
        $this->insurance->EditValue = FormatDateTime($this->insurance->CurrentValue, $this->insurance->formatPattern());
        $this->insurance->PlaceHolder = RemoveHtml($this->insurance->caption());

        // state_tax
        $this->state_tax->setupEditAttributes();
        $this->state_tax->EditValue = FormatDateTime($this->state_tax->CurrentValue, $this->state_tax->formatPattern());
        $this->state_tax->PlaceHolder = RemoveHtml($this->state_tax->caption());

        // national_permit
        $this->national_permit->setupEditAttributes();
        $this->national_permit->EditValue = FormatDateTime($this->national_permit->CurrentValue, $this->national_permit->formatPattern());
        $this->national_permit->PlaceHolder = RemoveHtml($this->national_permit->caption());

        // pollution
        $this->pollution->setupEditAttributes();
        $this->pollution->EditValue = FormatDateTime($this->pollution->CurrentValue, $this->pollution->formatPattern());
        $this->pollution->PlaceHolder = RemoveHtml($this->pollution->caption());

        // fitness
        $this->fitness->setupEditAttributes();
        $this->fitness->EditValue = FormatDateTime($this->fitness->CurrentValue, $this->fitness->formatPattern());
        $this->fitness->PlaceHolder = RemoveHtml($this->fitness->caption());

        // other_due
        $this->other_due->setupEditAttributes();
        $this->other_due->EditValue = FormatDateTime($this->other_due->CurrentValue, $this->other_due->formatPattern());
        $this->other_due->PlaceHolder = RemoveHtml($this->other_due->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // operator

        // datetime

        // running_status
        $this->running_status->setupEditAttributes();
        if (strval($this->running_status->CurrentValue) != "") {
            $this->running_status->EditValue = $this->running_status->optionCaption($this->running_status->CurrentValue);
        } else {
            $this->running_status->EditValue = null;
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->vehicle_owner);
                    $doc->exportCaption($this->no);
                    $doc->exportCaption($this->driver_name);
                    $doc->exportCaption($this->dor);
                    $doc->exportCaption($this->km_hour);
                    $doc->exportCaption($this->chassis_no);
                    $doc->exportCaption($this->engine_no);
                    $doc->exportCaption($this->load_average);
                    $doc->exportCaption($this->unload_average);
                    $doc->exportCaption($this->load_expenses);
                    $doc->exportCaption($this->unload_expenses);
                    $doc->exportCaption($this->insurance);
                    $doc->exportCaption($this->state_tax);
                    $doc->exportCaption($this->national_permit);
                    $doc->exportCaption($this->pollution);
                    $doc->exportCaption($this->fitness);
                    $doc->exportCaption($this->other_due);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->running_status);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->vehicle_owner);
                    $doc->exportCaption($this->no);
                    $doc->exportCaption($this->driver_name);
                    $doc->exportCaption($this->dor);
                    $doc->exportCaption($this->km_hour);
                    $doc->exportCaption($this->chassis_no);
                    $doc->exportCaption($this->engine_no);
                    $doc->exportCaption($this->load_average);
                    $doc->exportCaption($this->unload_average);
                    $doc->exportCaption($this->load_expenses);
                    $doc->exportCaption($this->unload_expenses);
                    $doc->exportCaption($this->insurance);
                    $doc->exportCaption($this->state_tax);
                    $doc->exportCaption($this->national_permit);
                    $doc->exportCaption($this->pollution);
                    $doc->exportCaption($this->fitness);
                    $doc->exportCaption($this->other_due);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->running_status);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->type);
                        $doc->exportField($this->vehicle_owner);
                        $doc->exportField($this->no);
                        $doc->exportField($this->driver_name);
                        $doc->exportField($this->dor);
                        $doc->exportField($this->km_hour);
                        $doc->exportField($this->chassis_no);
                        $doc->exportField($this->engine_no);
                        $doc->exportField($this->load_average);
                        $doc->exportField($this->unload_average);
                        $doc->exportField($this->load_expenses);
                        $doc->exportField($this->unload_expenses);
                        $doc->exportField($this->insurance);
                        $doc->exportField($this->state_tax);
                        $doc->exportField($this->national_permit);
                        $doc->exportField($this->pollution);
                        $doc->exportField($this->fitness);
                        $doc->exportField($this->other_due);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->running_status);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->type);
                        $doc->exportField($this->vehicle_owner);
                        $doc->exportField($this->no);
                        $doc->exportField($this->driver_name);
                        $doc->exportField($this->dor);
                        $doc->exportField($this->km_hour);
                        $doc->exportField($this->chassis_no);
                        $doc->exportField($this->engine_no);
                        $doc->exportField($this->load_average);
                        $doc->exportField($this->unload_average);
                        $doc->exportField($this->load_expenses);
                        $doc->exportField($this->unload_expenses);
                        $doc->exportField($this->insurance);
                        $doc->exportField($this->state_tax);
                        $doc->exportField($this->national_permit);
                        $doc->exportField($this->pollution);
                        $doc->exportField($this->fitness);
                        $doc->exportField($this->other_due);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->running_status);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
