<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class UserSearch extends User
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "UserSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "usersearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->mobile->setVisibility();
        $this->user_name->setVisibility();
        $this->_password->setVisibility();
        $this->name->setVisibility();
        $this->_email->setVisibility();
        $this->gst_number->setVisibility();
        $this->category->setVisibility();
        $this->last_login->setVisibility();
        $this->reg_date->setVisibility();
        $this->reg_device->setVisibility();
        $this->app_version->setVisibility();
        $this->device_id->setVisibility();
        $this->device_token_id->setVisibility();
        $this->cart_number->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->id->setVisibility();
        $this->max_discount->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'user';
        $this->TableName = 'user';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (user)
        if (!isset($GLOBALS["user"]) || $GLOBALS["user"]::class == PROJECT_NAMESPACE . "user") {
            $GLOBALS["user"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'user');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "userview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->mobile);
        $this->setupLookupOptions($this->name);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "userlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->mobile); // mobile
        $this->buildSearchUrl($srchUrl, $this->user_name); // user_name
        $this->buildSearchUrl($srchUrl, $this->_password); // password
        $this->buildSearchUrl($srchUrl, $this->name); // name
        $this->buildSearchUrl($srchUrl, $this->_email); // email
        $this->buildSearchUrl($srchUrl, $this->gst_number); // gst_number
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->last_login); // last_login
        $this->buildSearchUrl($srchUrl, $this->reg_date); // reg_date
        $this->buildSearchUrl($srchUrl, $this->reg_device); // reg_device
        $this->buildSearchUrl($srchUrl, $this->app_version); // app_version
        $this->buildSearchUrl($srchUrl, $this->device_id); // device_id
        $this->buildSearchUrl($srchUrl, $this->device_token_id); // device_token_id
        $this->buildSearchUrl($srchUrl, $this->cart_number); // cart_number
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->max_discount); // max_discount
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // user_name
        if ($this->user_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // password
        if ($this->_password->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // name
        if ($this->name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // email
        if ($this->_email->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gst_number
        if ($this->gst_number->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->category->AdvancedSearch->SearchValue)) {
            $this->category->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->category->AdvancedSearch->SearchValue);
        }
        if (is_array($this->category->AdvancedSearch->SearchValue2)) {
            $this->category->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->category->AdvancedSearch->SearchValue2);
        }

        // last_login
        if ($this->last_login->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reg_date
        if ($this->reg_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reg_device
        if ($this->reg_device->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // app_version
        if ($this->app_version->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // device_id
        if ($this->device_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // device_token_id
        if ($this->device_token_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cart_number
        if ($this->cart_number->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // max_discount
        if ($this->max_discount->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // mobile
        $this->mobile->RowCssClass = "row";

        // user_name
        $this->user_name->RowCssClass = "row";

        // password
        $this->_password->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // gst_number
        $this->gst_number->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // last_login
        $this->last_login->RowCssClass = "row";

        // reg_date
        $this->reg_date->RowCssClass = "row";

        // reg_device
        $this->reg_device->RowCssClass = "row";

        // app_version
        $this->app_version->RowCssClass = "row";

        // device_id
        $this->device_id->RowCssClass = "row";

        // device_token_id
        $this->device_token_id->RowCssClass = "row";

        // cart_number
        $this->cart_number->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // id
        $this->id->RowCssClass = "row";

        // max_discount
        $this->max_discount->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;
            $arwrk = [];
            $arwrk["lf"] = $this->mobile->CurrentValue;
            $arwrk["df"] = $this->mobile->CurrentValue;
            $arwrk["df2"] = $this->name->CurrentValue;
            $arwrk = $this->mobile->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->mobile->displayValue($arwrk);
            if ($dispVal != "") {
                $this->mobile->ViewValue = $dispVal;
            }

            // user_name
            $this->user_name->ViewValue = $this->user_name->CurrentValue;

            // password
            $this->_password->ViewValue = $this->_password->CurrentValue;

            // name
            $this->name->ViewValue = $this->name->CurrentValue;
            $arwrk = [];
            $arwrk["lf"] = $this->name->CurrentValue;
            $arwrk["df"] = $this->name->CurrentValue;
            $arwrk["df2"] = $this->mobile->CurrentValue;
            $arwrk = $this->name->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->name->displayValue($arwrk);
            if ($dispVal != "") {
                $this->name->ViewValue = $dispVal;
            }

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // gst_number
            $this->gst_number->ViewValue = $this->gst_number->CurrentValue;

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->category->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->category->Lookup->renderViewRow($row);
                            $this->category->ViewValue->add($this->category->displayValue($arwrk));
                        }
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // last_login
            $this->last_login->ViewValue = $this->last_login->CurrentValue;
            $this->last_login->ViewValue = FormatDateTime($this->last_login->ViewValue, $this->last_login->formatPattern());

            // reg_date
            $this->reg_date->ViewValue = $this->reg_date->CurrentValue;
            $this->reg_date->ViewValue = FormatDateTime($this->reg_date->ViewValue, $this->reg_date->formatPattern());

            // reg_device
            $this->reg_device->ViewValue = $this->reg_device->CurrentValue;
            $this->reg_device->ViewValue = FormatNumber($this->reg_device->ViewValue, $this->reg_device->formatPattern());

            // app_version
            $this->app_version->ViewValue = $this->app_version->CurrentValue;
            $this->app_version->ViewValue = FormatNumber($this->app_version->ViewValue, $this->app_version->formatPattern());

            // device_id
            $this->device_id->ViewValue = $this->device_id->CurrentValue;

            // device_token_id
            $this->device_token_id->ViewValue = $this->device_token_id->CurrentValue;

            // cart_number
            $this->cart_number->ViewValue = $this->cart_number->CurrentValue;
            $this->cart_number->ViewValue = FormatNumber($this->cart_number->ViewValue, $this->cart_number->formatPattern());

            // status
            if (ConvertToBool($this->status->CurrentValue)) {
                $this->status->ViewValue = $this->status->tagCaption(1) != "" ? $this->status->tagCaption(1) : "Active";
            } else {
                $this->status->ViewValue = $this->status->tagCaption(2) != "" ? $this->status->tagCaption(2) : "Freezed";
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // max_discount
            $this->max_discount->ViewValue = $this->max_discount->CurrentValue;
            $this->max_discount->ViewValue = FormatNumber($this->max_discount->ViewValue, $this->max_discount->formatPattern());

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // user_name
            $this->user_name->HrefValue = "";
            $this->user_name->TooltipValue = "";

            // password
            $this->_password->HrefValue = "";
            $this->_password->TooltipValue = "";

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";

            // email
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";

            // gst_number
            $this->gst_number->HrefValue = "";
            $this->gst_number->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // last_login
            $this->last_login->HrefValue = "";
            $this->last_login->TooltipValue = "";

            // reg_date
            $this->reg_date->HrefValue = "";
            $this->reg_date->TooltipValue = "";

            // reg_device
            $this->reg_device->HrefValue = "";
            $this->reg_device->TooltipValue = "";

            // app_version
            $this->app_version->HrefValue = "";
            $this->app_version->TooltipValue = "";

            // device_id
            $this->device_id->HrefValue = "";
            $this->device_id->TooltipValue = "";

            // device_token_id
            $this->device_token_id->HrefValue = "";
            $this->device_token_id->TooltipValue = "";

            // cart_number
            $this->cart_number->HrefValue = "";
            $this->cart_number->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // max_discount
            $this->max_discount->HrefValue = "";
            $this->max_discount->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->mobile->CurrentValue;
            $arwrk["df"] = $this->mobile->CurrentValue;
            $arwrk["df2"] = $this->name->CurrentValue;
            $arwrk = $this->mobile->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->mobile->displayValue($arwrk);
            if ($dispVal != "") {
                $this->mobile->EditValue = $dispVal;
            }
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // user_name
            $this->user_name->setupEditAttributes();
            if (!$this->user_name->Raw) {
                $this->user_name->AdvancedSearch->SearchValue = HtmlDecode($this->user_name->AdvancedSearch->SearchValue);
            }
            $this->user_name->EditValue = HtmlEncode($this->user_name->AdvancedSearch->SearchValue);
            $this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

            // password
            $this->_password->setupEditAttributes();
            if (!$this->_password->Raw) {
                $this->_password->AdvancedSearch->SearchValue = HtmlDecode($this->_password->AdvancedSearch->SearchValue);
            }
            $this->_password->EditValue = HtmlEncode($this->_password->AdvancedSearch->SearchValue);
            $this->_password->PlaceHolder = RemoveHtml($this->_password->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
            $arwrk = [];
            $arwrk["lf"] = $this->name->CurrentValue;
            $arwrk["df"] = $this->name->CurrentValue;
            $arwrk["df2"] = $this->mobile->CurrentValue;
            $arwrk = $this->name->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->name->displayValue($arwrk);
            if ($dispVal != "") {
                $this->name->EditValue = $dispVal;
            }
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // gst_number
            $this->gst_number->setupEditAttributes();
            if (!$this->gst_number->Raw) {
                $this->gst_number->AdvancedSearch->SearchValue = HtmlDecode($this->gst_number->AdvancedSearch->SearchValue);
            }
            $this->gst_number->EditValue = HtmlEncode($this->gst_number->AdvancedSearch->SearchValue);
            $this->gst_number->PlaceHolder = RemoveHtml($this->gst_number->caption());

            // category
            $curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // last_login
            $this->last_login->setupEditAttributes();
            $this->last_login->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->last_login->AdvancedSearch->SearchValue, $this->last_login->formatPattern()), $this->last_login->formatPattern()));
            $this->last_login->PlaceHolder = RemoveHtml($this->last_login->caption());

            // reg_date
            $this->reg_date->setupEditAttributes();
            $this->reg_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->reg_date->AdvancedSearch->SearchValue, $this->reg_date->formatPattern()), $this->reg_date->formatPattern()));
            $this->reg_date->PlaceHolder = RemoveHtml($this->reg_date->caption());

            // reg_device
            $this->reg_device->setupEditAttributes();
            $this->reg_device->EditValue = $this->reg_device->AdvancedSearch->SearchValue;
            $this->reg_device->PlaceHolder = RemoveHtml($this->reg_device->caption());

            // app_version
            $this->app_version->setupEditAttributes();
            $this->app_version->EditValue = $this->app_version->AdvancedSearch->SearchValue;
            $this->app_version->PlaceHolder = RemoveHtml($this->app_version->caption());

            // device_id
            $this->device_id->setupEditAttributes();
            if (!$this->device_id->Raw) {
                $this->device_id->AdvancedSearch->SearchValue = HtmlDecode($this->device_id->AdvancedSearch->SearchValue);
            }
            $this->device_id->EditValue = HtmlEncode($this->device_id->AdvancedSearch->SearchValue);
            $this->device_id->PlaceHolder = RemoveHtml($this->device_id->caption());

            // device_token_id
            $this->device_token_id->setupEditAttributes();
            if (!$this->device_token_id->Raw) {
                $this->device_token_id->AdvancedSearch->SearchValue = HtmlDecode($this->device_token_id->AdvancedSearch->SearchValue);
            }
            $this->device_token_id->EditValue = HtmlEncode($this->device_token_id->AdvancedSearch->SearchValue);
            $this->device_token_id->PlaceHolder = RemoveHtml($this->device_token_id->caption());

            // cart_number
            $this->cart_number->setupEditAttributes();
            $this->cart_number->EditValue = $this->cart_number->AdvancedSearch->SearchValue;
            $this->cart_number->PlaceHolder = RemoveHtml($this->cart_number->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $curVal = strval($this->operator->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->operator->EditValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->EditValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->EditValue = HtmlEncode(FormatNumber($this->operator->AdvancedSearch->SearchValue, $this->operator->formatPattern()));
                    }
                }
            } else {
                $this->operator->EditValue = null;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // max_discount
            $this->max_discount->setupEditAttributes();
            $this->max_discount->EditValue = $this->max_discount->AdvancedSearch->SearchValue;
            $this->max_discount->PlaceHolder = RemoveHtml($this->max_discount->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckDate($this->last_login->AdvancedSearch->SearchValue, $this->last_login->formatPattern())) {
            $this->last_login->addErrorMessage($this->last_login->getErrorMessage(false));
        }
        if (!CheckDate($this->reg_date->AdvancedSearch->SearchValue, $this->reg_date->formatPattern())) {
            $this->reg_date->addErrorMessage($this->reg_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->reg_device->AdvancedSearch->SearchValue)) {
            $this->reg_device->addErrorMessage($this->reg_device->getErrorMessage(false));
        }
        if (!CheckInteger($this->app_version->AdvancedSearch->SearchValue)) {
            $this->app_version->addErrorMessage($this->app_version->getErrorMessage(false));
        }
        if (!CheckInteger($this->cart_number->AdvancedSearch->SearchValue)) {
            $this->cart_number->addErrorMessage($this->cart_number->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->max_discount->AdvancedSearch->SearchValue)) {
            $this->max_discount->addErrorMessage($this->max_discount->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->mobile->AdvancedSearch->load();
        $this->user_name->AdvancedSearch->load();
        $this->_password->AdvancedSearch->load();
        $this->name->AdvancedSearch->load();
        $this->_email->AdvancedSearch->load();
        $this->gst_number->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->last_login->AdvancedSearch->load();
        $this->reg_date->AdvancedSearch->load();
        $this->reg_device->AdvancedSearch->load();
        $this->app_version->AdvancedSearch->load();
        $this->device_id->AdvancedSearch->load();
        $this->device_token_id->AdvancedSearch->load();
        $this->cart_number->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->id->AdvancedSearch->load();
        $this->max_discount->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("userlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_mobile":
                    break;
                case "x_name":
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'user');	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
