<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TestReportHeadAdd extends TestReportHead
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TestReportHeadAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "testreportheadadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->d_01->setVisibility();
        $this->d_02->setVisibility();
        $this->d_03->setVisibility();
        $this->d_04->setVisibility();
        $this->d_05->setVisibility();
        $this->d_06->setVisibility();
        $this->d_07->setVisibility();
        $this->d_08->setVisibility();
        $this->d_09->setVisibility();
        $this->d_10->setVisibility();
        $this->d_11->setVisibility();
        $this->d_12->setVisibility();
        $this->d_13->setVisibility();
        $this->d_14->setVisibility();
        $this->d_15->setVisibility();
        $this->d_16->setVisibility();
        $this->d_17->setVisibility();
        $this->d_18->setVisibility();
        $this->d_19->setVisibility();
        $this->d_20->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'test_report_head';
        $this->TableName = 'test_report_head';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (test_report_head)
        if (!isset($GLOBALS["test_report_head"]) || $GLOBALS["test_report_head"]::class == PROJECT_NAMESPACE . "test_report_head") {
            $GLOBALS["test_report_head"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'test_report_head');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "testreportheadview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("testreportheadlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "testreportheadlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "testreportheadview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "testreportheadlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "testreportheadlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'd_01' first before field var 'x_d_01'
        $val = $CurrentForm->hasValue("d_01") ? $CurrentForm->getValue("d_01") : $CurrentForm->getValue("x_d_01");
        if (!$this->d_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_01->Visible = false; // Disable update for API request
            } else {
                $this->d_01->setFormValue($val);
            }
        }

        // Check field name 'd_02' first before field var 'x_d_02'
        $val = $CurrentForm->hasValue("d_02") ? $CurrentForm->getValue("d_02") : $CurrentForm->getValue("x_d_02");
        if (!$this->d_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_02->Visible = false; // Disable update for API request
            } else {
                $this->d_02->setFormValue($val);
            }
        }

        // Check field name 'd_03' first before field var 'x_d_03'
        $val = $CurrentForm->hasValue("d_03") ? $CurrentForm->getValue("d_03") : $CurrentForm->getValue("x_d_03");
        if (!$this->d_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_03->Visible = false; // Disable update for API request
            } else {
                $this->d_03->setFormValue($val);
            }
        }

        // Check field name 'd_04' first before field var 'x_d_04'
        $val = $CurrentForm->hasValue("d_04") ? $CurrentForm->getValue("d_04") : $CurrentForm->getValue("x_d_04");
        if (!$this->d_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_04->Visible = false; // Disable update for API request
            } else {
                $this->d_04->setFormValue($val);
            }
        }

        // Check field name 'd_05' first before field var 'x_d_05'
        $val = $CurrentForm->hasValue("d_05") ? $CurrentForm->getValue("d_05") : $CurrentForm->getValue("x_d_05");
        if (!$this->d_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_05->Visible = false; // Disable update for API request
            } else {
                $this->d_05->setFormValue($val);
            }
        }

        // Check field name 'd_06' first before field var 'x_d_06'
        $val = $CurrentForm->hasValue("d_06") ? $CurrentForm->getValue("d_06") : $CurrentForm->getValue("x_d_06");
        if (!$this->d_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_06->Visible = false; // Disable update for API request
            } else {
                $this->d_06->setFormValue($val);
            }
        }

        // Check field name 'd_07' first before field var 'x_d_07'
        $val = $CurrentForm->hasValue("d_07") ? $CurrentForm->getValue("d_07") : $CurrentForm->getValue("x_d_07");
        if (!$this->d_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_07->Visible = false; // Disable update for API request
            } else {
                $this->d_07->setFormValue($val);
            }
        }

        // Check field name 'd_08' first before field var 'x_d_08'
        $val = $CurrentForm->hasValue("d_08") ? $CurrentForm->getValue("d_08") : $CurrentForm->getValue("x_d_08");
        if (!$this->d_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_08->Visible = false; // Disable update for API request
            } else {
                $this->d_08->setFormValue($val);
            }
        }

        // Check field name 'd_09' first before field var 'x_d_09'
        $val = $CurrentForm->hasValue("d_09") ? $CurrentForm->getValue("d_09") : $CurrentForm->getValue("x_d_09");
        if (!$this->d_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_09->Visible = false; // Disable update for API request
            } else {
                $this->d_09->setFormValue($val);
            }
        }

        // Check field name 'd_10' first before field var 'x_d_10'
        $val = $CurrentForm->hasValue("d_10") ? $CurrentForm->getValue("d_10") : $CurrentForm->getValue("x_d_10");
        if (!$this->d_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_10->Visible = false; // Disable update for API request
            } else {
                $this->d_10->setFormValue($val);
            }
        }

        // Check field name 'd_11' first before field var 'x_d_11'
        $val = $CurrentForm->hasValue("d_11") ? $CurrentForm->getValue("d_11") : $CurrentForm->getValue("x_d_11");
        if (!$this->d_11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_11->Visible = false; // Disable update for API request
            } else {
                $this->d_11->setFormValue($val);
            }
        }

        // Check field name 'd_12' first before field var 'x_d_12'
        $val = $CurrentForm->hasValue("d_12") ? $CurrentForm->getValue("d_12") : $CurrentForm->getValue("x_d_12");
        if (!$this->d_12->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_12->Visible = false; // Disable update for API request
            } else {
                $this->d_12->setFormValue($val);
            }
        }

        // Check field name 'd_13' first before field var 'x_d_13'
        $val = $CurrentForm->hasValue("d_13") ? $CurrentForm->getValue("d_13") : $CurrentForm->getValue("x_d_13");
        if (!$this->d_13->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_13->Visible = false; // Disable update for API request
            } else {
                $this->d_13->setFormValue($val);
            }
        }

        // Check field name 'd_14' first before field var 'x_d_14'
        $val = $CurrentForm->hasValue("d_14") ? $CurrentForm->getValue("d_14") : $CurrentForm->getValue("x_d_14");
        if (!$this->d_14->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_14->Visible = false; // Disable update for API request
            } else {
                $this->d_14->setFormValue($val);
            }
        }

        // Check field name 'd_15' first before field var 'x_d_15'
        $val = $CurrentForm->hasValue("d_15") ? $CurrentForm->getValue("d_15") : $CurrentForm->getValue("x_d_15");
        if (!$this->d_15->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_15->Visible = false; // Disable update for API request
            } else {
                $this->d_15->setFormValue($val);
            }
        }

        // Check field name 'd_16' first before field var 'x_d_16'
        $val = $CurrentForm->hasValue("d_16") ? $CurrentForm->getValue("d_16") : $CurrentForm->getValue("x_d_16");
        if (!$this->d_16->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_16->Visible = false; // Disable update for API request
            } else {
                $this->d_16->setFormValue($val);
            }
        }

        // Check field name 'd_17' first before field var 'x_d_17'
        $val = $CurrentForm->hasValue("d_17") ? $CurrentForm->getValue("d_17") : $CurrentForm->getValue("x_d_17");
        if (!$this->d_17->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_17->Visible = false; // Disable update for API request
            } else {
                $this->d_17->setFormValue($val);
            }
        }

        // Check field name 'd_18' first before field var 'x_d_18'
        $val = $CurrentForm->hasValue("d_18") ? $CurrentForm->getValue("d_18") : $CurrentForm->getValue("x_d_18");
        if (!$this->d_18->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_18->Visible = false; // Disable update for API request
            } else {
                $this->d_18->setFormValue($val);
            }
        }

        // Check field name 'd_19' first before field var 'x_d_19'
        $val = $CurrentForm->hasValue("d_19") ? $CurrentForm->getValue("d_19") : $CurrentForm->getValue("x_d_19");
        if (!$this->d_19->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_19->Visible = false; // Disable update for API request
            } else {
                $this->d_19->setFormValue($val);
            }
        }

        // Check field name 'd_20' first before field var 'x_d_20'
        $val = $CurrentForm->hasValue("d_20") ? $CurrentForm->getValue("d_20") : $CurrentForm->getValue("x_d_20");
        if (!$this->d_20->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_20->Visible = false; // Disable update for API request
            } else {
                $this->d_20->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->d_01->CurrentValue = $this->d_01->FormValue;
        $this->d_02->CurrentValue = $this->d_02->FormValue;
        $this->d_03->CurrentValue = $this->d_03->FormValue;
        $this->d_04->CurrentValue = $this->d_04->FormValue;
        $this->d_05->CurrentValue = $this->d_05->FormValue;
        $this->d_06->CurrentValue = $this->d_06->FormValue;
        $this->d_07->CurrentValue = $this->d_07->FormValue;
        $this->d_08->CurrentValue = $this->d_08->FormValue;
        $this->d_09->CurrentValue = $this->d_09->FormValue;
        $this->d_10->CurrentValue = $this->d_10->FormValue;
        $this->d_11->CurrentValue = $this->d_11->FormValue;
        $this->d_12->CurrentValue = $this->d_12->FormValue;
        $this->d_13->CurrentValue = $this->d_13->FormValue;
        $this->d_14->CurrentValue = $this->d_14->FormValue;
        $this->d_15->CurrentValue = $this->d_15->FormValue;
        $this->d_16->CurrentValue = $this->d_16->FormValue;
        $this->d_17->CurrentValue = $this->d_17->FormValue;
        $this->d_18->CurrentValue = $this->d_18->FormValue;
        $this->d_19->CurrentValue = $this->d_19->FormValue;
        $this->d_20->CurrentValue = $this->d_20->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->d_01->setDbValue($row['d_01']);
        $this->d_02->setDbValue($row['d_02']);
        $this->d_03->setDbValue($row['d_03']);
        $this->d_04->setDbValue($row['d_04']);
        $this->d_05->setDbValue($row['d_05']);
        $this->d_06->setDbValue($row['d_06']);
        $this->d_07->setDbValue($row['d_07']);
        $this->d_08->setDbValue($row['d_08']);
        $this->d_09->setDbValue($row['d_09']);
        $this->d_10->setDbValue($row['d_10']);
        $this->d_11->setDbValue($row['d_11']);
        $this->d_12->setDbValue($row['d_12']);
        $this->d_13->setDbValue($row['d_13']);
        $this->d_14->setDbValue($row['d_14']);
        $this->d_15->setDbValue($row['d_15']);
        $this->d_16->setDbValue($row['d_16']);
        $this->d_17->setDbValue($row['d_17']);
        $this->d_18->setDbValue($row['d_18']);
        $this->d_19->setDbValue($row['d_19']);
        $this->d_20->setDbValue($row['d_20']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['d_01'] = $this->d_01->DefaultValue;
        $row['d_02'] = $this->d_02->DefaultValue;
        $row['d_03'] = $this->d_03->DefaultValue;
        $row['d_04'] = $this->d_04->DefaultValue;
        $row['d_05'] = $this->d_05->DefaultValue;
        $row['d_06'] = $this->d_06->DefaultValue;
        $row['d_07'] = $this->d_07->DefaultValue;
        $row['d_08'] = $this->d_08->DefaultValue;
        $row['d_09'] = $this->d_09->DefaultValue;
        $row['d_10'] = $this->d_10->DefaultValue;
        $row['d_11'] = $this->d_11->DefaultValue;
        $row['d_12'] = $this->d_12->DefaultValue;
        $row['d_13'] = $this->d_13->DefaultValue;
        $row['d_14'] = $this->d_14->DefaultValue;
        $row['d_15'] = $this->d_15->DefaultValue;
        $row['d_16'] = $this->d_16->DefaultValue;
        $row['d_17'] = $this->d_17->DefaultValue;
        $row['d_18'] = $this->d_18->DefaultValue;
        $row['d_19'] = $this->d_19->DefaultValue;
        $row['d_20'] = $this->d_20->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // d_01
        $this->d_01->RowCssClass = "row";

        // d_02
        $this->d_02->RowCssClass = "row";

        // d_03
        $this->d_03->RowCssClass = "row";

        // d_04
        $this->d_04->RowCssClass = "row";

        // d_05
        $this->d_05->RowCssClass = "row";

        // d_06
        $this->d_06->RowCssClass = "row";

        // d_07
        $this->d_07->RowCssClass = "row";

        // d_08
        $this->d_08->RowCssClass = "row";

        // d_09
        $this->d_09->RowCssClass = "row";

        // d_10
        $this->d_10->RowCssClass = "row";

        // d_11
        $this->d_11->RowCssClass = "row";

        // d_12
        $this->d_12->RowCssClass = "row";

        // d_13
        $this->d_13->RowCssClass = "row";

        // d_14
        $this->d_14->RowCssClass = "row";

        // d_15
        $this->d_15->RowCssClass = "row";

        // d_16
        $this->d_16->RowCssClass = "row";

        // d_17
        $this->d_17->RowCssClass = "row";

        // d_18
        $this->d_18->RowCssClass = "row";

        // d_19
        $this->d_19->RowCssClass = "row";

        // d_20
        $this->d_20->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // d_01
            $this->d_01->ViewValue = $this->d_01->CurrentValue;

            // d_02
            $this->d_02->ViewValue = $this->d_02->CurrentValue;

            // d_03
            $this->d_03->ViewValue = $this->d_03->CurrentValue;

            // d_04
            $this->d_04->ViewValue = $this->d_04->CurrentValue;

            // d_05
            $this->d_05->ViewValue = $this->d_05->CurrentValue;

            // d_06
            $this->d_06->ViewValue = $this->d_06->CurrentValue;

            // d_07
            $this->d_07->ViewValue = $this->d_07->CurrentValue;

            // d_08
            $this->d_08->ViewValue = $this->d_08->CurrentValue;

            // d_09
            $this->d_09->ViewValue = $this->d_09->CurrentValue;

            // d_10
            $this->d_10->ViewValue = $this->d_10->CurrentValue;

            // d_11
            $this->d_11->ViewValue = $this->d_11->CurrentValue;

            // d_12
            $this->d_12->ViewValue = $this->d_12->CurrentValue;

            // d_13
            $this->d_13->ViewValue = $this->d_13->CurrentValue;

            // d_14
            $this->d_14->ViewValue = $this->d_14->CurrentValue;

            // d_15
            $this->d_15->ViewValue = $this->d_15->CurrentValue;

            // d_16
            $this->d_16->ViewValue = $this->d_16->CurrentValue;

            // d_17
            $this->d_17->ViewValue = $this->d_17->CurrentValue;

            // d_18
            $this->d_18->ViewValue = $this->d_18->CurrentValue;

            // d_19
            $this->d_19->ViewValue = $this->d_19->CurrentValue;

            // d_20
            $this->d_20->ViewValue = $this->d_20->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // d_01
            $this->d_01->HrefValue = "";

            // d_02
            $this->d_02->HrefValue = "";

            // d_03
            $this->d_03->HrefValue = "";

            // d_04
            $this->d_04->HrefValue = "";

            // d_05
            $this->d_05->HrefValue = "";

            // d_06
            $this->d_06->HrefValue = "";

            // d_07
            $this->d_07->HrefValue = "";

            // d_08
            $this->d_08->HrefValue = "";

            // d_09
            $this->d_09->HrefValue = "";

            // d_10
            $this->d_10->HrefValue = "";

            // d_11
            $this->d_11->HrefValue = "";

            // d_12
            $this->d_12->HrefValue = "";

            // d_13
            $this->d_13->HrefValue = "";

            // d_14
            $this->d_14->HrefValue = "";

            // d_15
            $this->d_15->HrefValue = "";

            // d_16
            $this->d_16->HrefValue = "";

            // d_17
            $this->d_17->HrefValue = "";

            // d_18
            $this->d_18->HrefValue = "";

            // d_19
            $this->d_19->HrefValue = "";

            // d_20
            $this->d_20->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // d_01
            $this->d_01->setupEditAttributes();
            if (!$this->d_01->Raw) {
                $this->d_01->CurrentValue = HtmlDecode($this->d_01->CurrentValue);
            }
            $this->d_01->EditValue = HtmlEncode($this->d_01->CurrentValue);
            $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

            // d_02
            $this->d_02->setupEditAttributes();
            if (!$this->d_02->Raw) {
                $this->d_02->CurrentValue = HtmlDecode($this->d_02->CurrentValue);
            }
            $this->d_02->EditValue = HtmlEncode($this->d_02->CurrentValue);
            $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

            // d_03
            $this->d_03->setupEditAttributes();
            if (!$this->d_03->Raw) {
                $this->d_03->CurrentValue = HtmlDecode($this->d_03->CurrentValue);
            }
            $this->d_03->EditValue = HtmlEncode($this->d_03->CurrentValue);
            $this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());

            // d_04
            $this->d_04->setupEditAttributes();
            if (!$this->d_04->Raw) {
                $this->d_04->CurrentValue = HtmlDecode($this->d_04->CurrentValue);
            }
            $this->d_04->EditValue = HtmlEncode($this->d_04->CurrentValue);
            $this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());

            // d_05
            $this->d_05->setupEditAttributes();
            if (!$this->d_05->Raw) {
                $this->d_05->CurrentValue = HtmlDecode($this->d_05->CurrentValue);
            }
            $this->d_05->EditValue = HtmlEncode($this->d_05->CurrentValue);
            $this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());

            // d_06
            $this->d_06->setupEditAttributes();
            if (!$this->d_06->Raw) {
                $this->d_06->CurrentValue = HtmlDecode($this->d_06->CurrentValue);
            }
            $this->d_06->EditValue = HtmlEncode($this->d_06->CurrentValue);
            $this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());

            // d_07
            $this->d_07->setupEditAttributes();
            if (!$this->d_07->Raw) {
                $this->d_07->CurrentValue = HtmlDecode($this->d_07->CurrentValue);
            }
            $this->d_07->EditValue = HtmlEncode($this->d_07->CurrentValue);
            $this->d_07->PlaceHolder = RemoveHtml($this->d_07->caption());

            // d_08
            $this->d_08->setupEditAttributes();
            if (!$this->d_08->Raw) {
                $this->d_08->CurrentValue = HtmlDecode($this->d_08->CurrentValue);
            }
            $this->d_08->EditValue = HtmlEncode($this->d_08->CurrentValue);
            $this->d_08->PlaceHolder = RemoveHtml($this->d_08->caption());

            // d_09
            $this->d_09->setupEditAttributes();
            if (!$this->d_09->Raw) {
                $this->d_09->CurrentValue = HtmlDecode($this->d_09->CurrentValue);
            }
            $this->d_09->EditValue = HtmlEncode($this->d_09->CurrentValue);
            $this->d_09->PlaceHolder = RemoveHtml($this->d_09->caption());

            // d_10
            $this->d_10->setupEditAttributes();
            if (!$this->d_10->Raw) {
                $this->d_10->CurrentValue = HtmlDecode($this->d_10->CurrentValue);
            }
            $this->d_10->EditValue = HtmlEncode($this->d_10->CurrentValue);
            $this->d_10->PlaceHolder = RemoveHtml($this->d_10->caption());

            // d_11
            $this->d_11->setupEditAttributes();
            if (!$this->d_11->Raw) {
                $this->d_11->CurrentValue = HtmlDecode($this->d_11->CurrentValue);
            }
            $this->d_11->EditValue = HtmlEncode($this->d_11->CurrentValue);
            $this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());

            // d_12
            $this->d_12->setupEditAttributes();
            if (!$this->d_12->Raw) {
                $this->d_12->CurrentValue = HtmlDecode($this->d_12->CurrentValue);
            }
            $this->d_12->EditValue = HtmlEncode($this->d_12->CurrentValue);
            $this->d_12->PlaceHolder = RemoveHtml($this->d_12->caption());

            // d_13
            $this->d_13->setupEditAttributes();
            if (!$this->d_13->Raw) {
                $this->d_13->CurrentValue = HtmlDecode($this->d_13->CurrentValue);
            }
            $this->d_13->EditValue = HtmlEncode($this->d_13->CurrentValue);
            $this->d_13->PlaceHolder = RemoveHtml($this->d_13->caption());

            // d_14
            $this->d_14->setupEditAttributes();
            if (!$this->d_14->Raw) {
                $this->d_14->CurrentValue = HtmlDecode($this->d_14->CurrentValue);
            }
            $this->d_14->EditValue = HtmlEncode($this->d_14->CurrentValue);
            $this->d_14->PlaceHolder = RemoveHtml($this->d_14->caption());

            // d_15
            $this->d_15->setupEditAttributes();
            if (!$this->d_15->Raw) {
                $this->d_15->CurrentValue = HtmlDecode($this->d_15->CurrentValue);
            }
            $this->d_15->EditValue = HtmlEncode($this->d_15->CurrentValue);
            $this->d_15->PlaceHolder = RemoveHtml($this->d_15->caption());

            // d_16
            $this->d_16->setupEditAttributes();
            if (!$this->d_16->Raw) {
                $this->d_16->CurrentValue = HtmlDecode($this->d_16->CurrentValue);
            }
            $this->d_16->EditValue = HtmlEncode($this->d_16->CurrentValue);
            $this->d_16->PlaceHolder = RemoveHtml($this->d_16->caption());

            // d_17
            $this->d_17->setupEditAttributes();
            if (!$this->d_17->Raw) {
                $this->d_17->CurrentValue = HtmlDecode($this->d_17->CurrentValue);
            }
            $this->d_17->EditValue = HtmlEncode($this->d_17->CurrentValue);
            $this->d_17->PlaceHolder = RemoveHtml($this->d_17->caption());

            // d_18
            $this->d_18->setupEditAttributes();
            if (!$this->d_18->Raw) {
                $this->d_18->CurrentValue = HtmlDecode($this->d_18->CurrentValue);
            }
            $this->d_18->EditValue = HtmlEncode($this->d_18->CurrentValue);
            $this->d_18->PlaceHolder = RemoveHtml($this->d_18->caption());

            // d_19
            $this->d_19->setupEditAttributes();
            if (!$this->d_19->Raw) {
                $this->d_19->CurrentValue = HtmlDecode($this->d_19->CurrentValue);
            }
            $this->d_19->EditValue = HtmlEncode($this->d_19->CurrentValue);
            $this->d_19->PlaceHolder = RemoveHtml($this->d_19->caption());

            // d_20
            $this->d_20->setupEditAttributes();
            if (!$this->d_20->Raw) {
                $this->d_20->CurrentValue = HtmlDecode($this->d_20->CurrentValue);
            }
            $this->d_20->EditValue = HtmlEncode($this->d_20->CurrentValue);
            $this->d_20->PlaceHolder = RemoveHtml($this->d_20->caption());

            // operator

            // datetime

            // Add refer script

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // d_01
            $this->d_01->HrefValue = "";

            // d_02
            $this->d_02->HrefValue = "";

            // d_03
            $this->d_03->HrefValue = "";

            // d_04
            $this->d_04->HrefValue = "";

            // d_05
            $this->d_05->HrefValue = "";

            // d_06
            $this->d_06->HrefValue = "";

            // d_07
            $this->d_07->HrefValue = "";

            // d_08
            $this->d_08->HrefValue = "";

            // d_09
            $this->d_09->HrefValue = "";

            // d_10
            $this->d_10->HrefValue = "";

            // d_11
            $this->d_11->HrefValue = "";

            // d_12
            $this->d_12->HrefValue = "";

            // d_13
            $this->d_13->HrefValue = "";

            // d_14
            $this->d_14->HrefValue = "";

            // d_15
            $this->d_15->HrefValue = "";

            // d_16
            $this->d_16->HrefValue = "";

            // d_17
            $this->d_17->HrefValue = "";

            // d_18
            $this->d_18->HrefValue = "";

            // d_19
            $this->d_19->HrefValue = "";

            // d_20
            $this->d_20->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->d_01->Visible && $this->d_01->Required) {
                if (!$this->d_01->IsDetailKey && EmptyValue($this->d_01->FormValue)) {
                    $this->d_01->addErrorMessage(str_replace("%s", $this->d_01->caption(), $this->d_01->RequiredErrorMessage));
                }
            }
            if ($this->d_02->Visible && $this->d_02->Required) {
                if (!$this->d_02->IsDetailKey && EmptyValue($this->d_02->FormValue)) {
                    $this->d_02->addErrorMessage(str_replace("%s", $this->d_02->caption(), $this->d_02->RequiredErrorMessage));
                }
            }
            if ($this->d_03->Visible && $this->d_03->Required) {
                if (!$this->d_03->IsDetailKey && EmptyValue($this->d_03->FormValue)) {
                    $this->d_03->addErrorMessage(str_replace("%s", $this->d_03->caption(), $this->d_03->RequiredErrorMessage));
                }
            }
            if ($this->d_04->Visible && $this->d_04->Required) {
                if (!$this->d_04->IsDetailKey && EmptyValue($this->d_04->FormValue)) {
                    $this->d_04->addErrorMessage(str_replace("%s", $this->d_04->caption(), $this->d_04->RequiredErrorMessage));
                }
            }
            if ($this->d_05->Visible && $this->d_05->Required) {
                if (!$this->d_05->IsDetailKey && EmptyValue($this->d_05->FormValue)) {
                    $this->d_05->addErrorMessage(str_replace("%s", $this->d_05->caption(), $this->d_05->RequiredErrorMessage));
                }
            }
            if ($this->d_06->Visible && $this->d_06->Required) {
                if (!$this->d_06->IsDetailKey && EmptyValue($this->d_06->FormValue)) {
                    $this->d_06->addErrorMessage(str_replace("%s", $this->d_06->caption(), $this->d_06->RequiredErrorMessage));
                }
            }
            if ($this->d_07->Visible && $this->d_07->Required) {
                if (!$this->d_07->IsDetailKey && EmptyValue($this->d_07->FormValue)) {
                    $this->d_07->addErrorMessage(str_replace("%s", $this->d_07->caption(), $this->d_07->RequiredErrorMessage));
                }
            }
            if ($this->d_08->Visible && $this->d_08->Required) {
                if (!$this->d_08->IsDetailKey && EmptyValue($this->d_08->FormValue)) {
                    $this->d_08->addErrorMessage(str_replace("%s", $this->d_08->caption(), $this->d_08->RequiredErrorMessage));
                }
            }
            if ($this->d_09->Visible && $this->d_09->Required) {
                if (!$this->d_09->IsDetailKey && EmptyValue($this->d_09->FormValue)) {
                    $this->d_09->addErrorMessage(str_replace("%s", $this->d_09->caption(), $this->d_09->RequiredErrorMessage));
                }
            }
            if ($this->d_10->Visible && $this->d_10->Required) {
                if (!$this->d_10->IsDetailKey && EmptyValue($this->d_10->FormValue)) {
                    $this->d_10->addErrorMessage(str_replace("%s", $this->d_10->caption(), $this->d_10->RequiredErrorMessage));
                }
            }
            if ($this->d_11->Visible && $this->d_11->Required) {
                if (!$this->d_11->IsDetailKey && EmptyValue($this->d_11->FormValue)) {
                    $this->d_11->addErrorMessage(str_replace("%s", $this->d_11->caption(), $this->d_11->RequiredErrorMessage));
                }
            }
            if ($this->d_12->Visible && $this->d_12->Required) {
                if (!$this->d_12->IsDetailKey && EmptyValue($this->d_12->FormValue)) {
                    $this->d_12->addErrorMessage(str_replace("%s", $this->d_12->caption(), $this->d_12->RequiredErrorMessage));
                }
            }
            if ($this->d_13->Visible && $this->d_13->Required) {
                if (!$this->d_13->IsDetailKey && EmptyValue($this->d_13->FormValue)) {
                    $this->d_13->addErrorMessage(str_replace("%s", $this->d_13->caption(), $this->d_13->RequiredErrorMessage));
                }
            }
            if ($this->d_14->Visible && $this->d_14->Required) {
                if (!$this->d_14->IsDetailKey && EmptyValue($this->d_14->FormValue)) {
                    $this->d_14->addErrorMessage(str_replace("%s", $this->d_14->caption(), $this->d_14->RequiredErrorMessage));
                }
            }
            if ($this->d_15->Visible && $this->d_15->Required) {
                if (!$this->d_15->IsDetailKey && EmptyValue($this->d_15->FormValue)) {
                    $this->d_15->addErrorMessage(str_replace("%s", $this->d_15->caption(), $this->d_15->RequiredErrorMessage));
                }
            }
            if ($this->d_16->Visible && $this->d_16->Required) {
                if (!$this->d_16->IsDetailKey && EmptyValue($this->d_16->FormValue)) {
                    $this->d_16->addErrorMessage(str_replace("%s", $this->d_16->caption(), $this->d_16->RequiredErrorMessage));
                }
            }
            if ($this->d_17->Visible && $this->d_17->Required) {
                if (!$this->d_17->IsDetailKey && EmptyValue($this->d_17->FormValue)) {
                    $this->d_17->addErrorMessage(str_replace("%s", $this->d_17->caption(), $this->d_17->RequiredErrorMessage));
                }
            }
            if ($this->d_18->Visible && $this->d_18->Required) {
                if (!$this->d_18->IsDetailKey && EmptyValue($this->d_18->FormValue)) {
                    $this->d_18->addErrorMessage(str_replace("%s", $this->d_18->caption(), $this->d_18->RequiredErrorMessage));
                }
            }
            if ($this->d_19->Visible && $this->d_19->Required) {
                if (!$this->d_19->IsDetailKey && EmptyValue($this->d_19->FormValue)) {
                    $this->d_19->addErrorMessage(str_replace("%s", $this->d_19->caption(), $this->d_19->RequiredErrorMessage));
                }
            }
            if ($this->d_20->Visible && $this->d_20->Required) {
                if (!$this->d_20->IsDetailKey && EmptyValue($this->d_20->FormValue)) {
                    $this->d_20->addErrorMessage(str_replace("%s", $this->d_20->caption(), $this->d_20->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // d_01
        $this->d_01->setDbValueDef($rsnew, $this->d_01->CurrentValue, false);

        // d_02
        $this->d_02->setDbValueDef($rsnew, $this->d_02->CurrentValue, false);

        // d_03
        $this->d_03->setDbValueDef($rsnew, $this->d_03->CurrentValue, false);

        // d_04
        $this->d_04->setDbValueDef($rsnew, $this->d_04->CurrentValue, false);

        // d_05
        $this->d_05->setDbValueDef($rsnew, $this->d_05->CurrentValue, false);

        // d_06
        $this->d_06->setDbValueDef($rsnew, $this->d_06->CurrentValue, false);

        // d_07
        $this->d_07->setDbValueDef($rsnew, $this->d_07->CurrentValue, false);

        // d_08
        $this->d_08->setDbValueDef($rsnew, $this->d_08->CurrentValue, false);

        // d_09
        $this->d_09->setDbValueDef($rsnew, $this->d_09->CurrentValue, false);

        // d_10
        $this->d_10->setDbValueDef($rsnew, $this->d_10->CurrentValue, false);

        // d_11
        $this->d_11->setDbValueDef($rsnew, $this->d_11->CurrentValue, false);

        // d_12
        $this->d_12->setDbValueDef($rsnew, $this->d_12->CurrentValue, false);

        // d_13
        $this->d_13->setDbValueDef($rsnew, $this->d_13->CurrentValue, false);

        // d_14
        $this->d_14->setDbValueDef($rsnew, $this->d_14->CurrentValue, false);

        // d_15
        $this->d_15->setDbValueDef($rsnew, $this->d_15->CurrentValue, false);

        // d_16
        $this->d_16->setDbValueDef($rsnew, $this->d_16->CurrentValue, false);

        // d_17
        $this->d_17->setDbValueDef($rsnew, $this->d_17->CurrentValue, false);

        // d_18
        $this->d_18->setDbValueDef($rsnew, $this->d_18->CurrentValue, false);

        // d_19
        $this->d_19->setDbValueDef($rsnew, $this->d_19->CurrentValue, false);

        // d_20
        $this->d_20->setDbValueDef($rsnew, $this->d_20->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['d_01'])) { // d_01
            $this->d_01->setFormValue($row['d_01']);
        }
        if (isset($row['d_02'])) { // d_02
            $this->d_02->setFormValue($row['d_02']);
        }
        if (isset($row['d_03'])) { // d_03
            $this->d_03->setFormValue($row['d_03']);
        }
        if (isset($row['d_04'])) { // d_04
            $this->d_04->setFormValue($row['d_04']);
        }
        if (isset($row['d_05'])) { // d_05
            $this->d_05->setFormValue($row['d_05']);
        }
        if (isset($row['d_06'])) { // d_06
            $this->d_06->setFormValue($row['d_06']);
        }
        if (isset($row['d_07'])) { // d_07
            $this->d_07->setFormValue($row['d_07']);
        }
        if (isset($row['d_08'])) { // d_08
            $this->d_08->setFormValue($row['d_08']);
        }
        if (isset($row['d_09'])) { // d_09
            $this->d_09->setFormValue($row['d_09']);
        }
        if (isset($row['d_10'])) { // d_10
            $this->d_10->setFormValue($row['d_10']);
        }
        if (isset($row['d_11'])) { // d_11
            $this->d_11->setFormValue($row['d_11']);
        }
        if (isset($row['d_12'])) { // d_12
            $this->d_12->setFormValue($row['d_12']);
        }
        if (isset($row['d_13'])) { // d_13
            $this->d_13->setFormValue($row['d_13']);
        }
        if (isset($row['d_14'])) { // d_14
            $this->d_14->setFormValue($row['d_14']);
        }
        if (isset($row['d_15'])) { // d_15
            $this->d_15->setFormValue($row['d_15']);
        }
        if (isset($row['d_16'])) { // d_16
            $this->d_16->setFormValue($row['d_16']);
        }
        if (isset($row['d_17'])) { // d_17
            $this->d_17->setFormValue($row['d_17']);
        }
        if (isset($row['d_18'])) { // d_18
            $this->d_18->setFormValue($row['d_18']);
        }
        if (isset($row['d_19'])) { // d_19
            $this->d_19->setFormValue($row['d_19']);
        }
        if (isset($row['d_20'])) { // d_20
            $this->d_20->setFormValue($row['d_20']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("testreportheadlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    break;
                case "x_s_grp":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
