<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TestReportGSearch extends TestReportG
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TestReportGSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "testreportgsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->ref->setVisibility();
        $this->lot_no->setVisibility();
        $this->dated->setVisibility();
        $this->d_01->setVisibility();
        $this->d_02->setVisibility();
        $this->d_03->setVisibility();
        $this->d_04->setVisibility();
        $this->d_05->setVisibility();
        $this->d_06->setVisibility();
        $this->d_07->setVisibility();
        $this->d_08->setVisibility();
        $this->d_09->setVisibility();
        $this->d_10->setVisibility();
        $this->d_11->setVisibility();
        $this->d_12->setVisibility();
        $this->d_13->setVisibility();
        $this->d_14->setVisibility();
        $this->d_15->setVisibility();
        $this->d_16->setVisibility();
        $this->d_17->setVisibility();
        $this->d_18->setVisibility();
        $this->d_19->setVisibility();
        $this->d_20->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'test_report_g';
        $this->TableName = 'test_report_g';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (test_report_g)
        if (!isset($GLOBALS["test_report_g"]) || $GLOBALS["test_report_g"]::class == PROJECT_NAMESPACE . "test_report_g") {
            $GLOBALS["test_report_g"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'test_report_g');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "testreportgview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "testreportglist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
        $this->buildSearchUrl($srchUrl, $this->product); // product
        $this->buildSearchUrl($srchUrl, $this->ref); // ref
        $this->buildSearchUrl($srchUrl, $this->lot_no); // lot_no
        $this->buildSearchUrl($srchUrl, $this->dated); // dated
        $this->buildSearchUrl($srchUrl, $this->d_01); // d_01
        $this->buildSearchUrl($srchUrl, $this->d_02); // d_02
        $this->buildSearchUrl($srchUrl, $this->d_03); // d_03
        $this->buildSearchUrl($srchUrl, $this->d_04); // d_04
        $this->buildSearchUrl($srchUrl, $this->d_05); // d_05
        $this->buildSearchUrl($srchUrl, $this->d_06); // d_06
        $this->buildSearchUrl($srchUrl, $this->d_07); // d_07
        $this->buildSearchUrl($srchUrl, $this->d_08); // d_08
        $this->buildSearchUrl($srchUrl, $this->d_09); // d_09
        $this->buildSearchUrl($srchUrl, $this->d_10); // d_10
        $this->buildSearchUrl($srchUrl, $this->d_11); // d_11
        $this->buildSearchUrl($srchUrl, $this->d_12); // d_12
        $this->buildSearchUrl($srchUrl, $this->d_13); // d_13
        $this->buildSearchUrl($srchUrl, $this->d_14); // d_14
        $this->buildSearchUrl($srchUrl, $this->d_15); // d_15
        $this->buildSearchUrl($srchUrl, $this->d_16); // d_16
        $this->buildSearchUrl($srchUrl, $this->d_17); // d_17
        $this->buildSearchUrl($srchUrl, $this->d_18); // d_18
        $this->buildSearchUrl($srchUrl, $this->d_19); // d_19
        $this->buildSearchUrl($srchUrl, $this->d_20); // d_20
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ref
        if ($this->ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lot_no
        if ($this->lot_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dated
        if ($this->dated->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_01
        if ($this->d_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_02
        if ($this->d_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_03
        if ($this->d_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_04
        if ($this->d_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_05
        if ($this->d_05->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_06
        if ($this->d_06->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_07
        if ($this->d_07->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_08
        if ($this->d_08->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_09
        if ($this->d_09->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_10
        if ($this->d_10->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_11
        if ($this->d_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_12
        if ($this->d_12->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_13
        if ($this->d_13->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_14
        if ($this->d_14->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_15
        if ($this->d_15->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_16
        if ($this->d_16->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_17
        if ($this->d_17->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_18
        if ($this->d_18->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_19
        if ($this->d_19->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_20
        if ($this->d_20->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // ref
        $this->ref->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // d_01
        $this->d_01->RowCssClass = "row";

        // d_02
        $this->d_02->RowCssClass = "row";

        // d_03
        $this->d_03->RowCssClass = "row";

        // d_04
        $this->d_04->RowCssClass = "row";

        // d_05
        $this->d_05->RowCssClass = "row";

        // d_06
        $this->d_06->RowCssClass = "row";

        // d_07
        $this->d_07->RowCssClass = "row";

        // d_08
        $this->d_08->RowCssClass = "row";

        // d_09
        $this->d_09->RowCssClass = "row";

        // d_10
        $this->d_10->RowCssClass = "row";

        // d_11
        $this->d_11->RowCssClass = "row";

        // d_12
        $this->d_12->RowCssClass = "row";

        // d_13
        $this->d_13->RowCssClass = "row";

        // d_14
        $this->d_14->RowCssClass = "row";

        // d_15
        $this->d_15->RowCssClass = "row";

        // d_16
        $this->d_16->RowCssClass = "row";

        // d_17
        $this->d_17->RowCssClass = "row";

        // d_18
        $this->d_18->RowCssClass = "row";

        // d_19
        $this->d_19->RowCssClass = "row";

        // d_20
        $this->d_20->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }
            $this->product->CssClass = "fst-italic";

            // ref
            $this->ref->ViewValue = $this->ref->CurrentValue;
            $this->ref->ViewValue = FormatNumber($this->ref->ViewValue, $this->ref->formatPattern());

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // d_01
            $this->d_01->ViewValue = $this->d_01->CurrentValue;
            $this->d_01->ViewValue = FormatNumber($this->d_01->ViewValue, $this->d_01->formatPattern());

            // d_02
            $this->d_02->ViewValue = $this->d_02->CurrentValue;
            $this->d_02->ViewValue = FormatNumber($this->d_02->ViewValue, $this->d_02->formatPattern());

            // d_03
            $this->d_03->ViewValue = $this->d_03->CurrentValue;
            $this->d_03->ViewValue = FormatNumber($this->d_03->ViewValue, $this->d_03->formatPattern());

            // d_04
            $this->d_04->ViewValue = $this->d_04->CurrentValue;
            $this->d_04->ViewValue = FormatNumber($this->d_04->ViewValue, $this->d_04->formatPattern());

            // d_05
            $this->d_05->ViewValue = $this->d_05->CurrentValue;
            $this->d_05->ViewValue = FormatNumber($this->d_05->ViewValue, $this->d_05->formatPattern());

            // d_06
            $this->d_06->ViewValue = $this->d_06->CurrentValue;
            $this->d_06->ViewValue = FormatNumber($this->d_06->ViewValue, $this->d_06->formatPattern());

            // d_07
            $this->d_07->ViewValue = $this->d_07->CurrentValue;
            $this->d_07->ViewValue = FormatNumber($this->d_07->ViewValue, $this->d_07->formatPattern());

            // d_08
            $this->d_08->ViewValue = $this->d_08->CurrentValue;
            $this->d_08->ViewValue = FormatNumber($this->d_08->ViewValue, $this->d_08->formatPattern());

            // d_09
            $this->d_09->ViewValue = $this->d_09->CurrentValue;
            $this->d_09->ViewValue = FormatNumber($this->d_09->ViewValue, $this->d_09->formatPattern());

            // d_10
            $this->d_10->ViewValue = $this->d_10->CurrentValue;
            $this->d_10->ViewValue = FormatNumber($this->d_10->ViewValue, $this->d_10->formatPattern());

            // d_11
            $this->d_11->ViewValue = $this->d_11->CurrentValue;
            $this->d_11->ViewValue = FormatNumber($this->d_11->ViewValue, $this->d_11->formatPattern());

            // d_12
            $this->d_12->ViewValue = $this->d_12->CurrentValue;
            $this->d_12->ViewValue = FormatNumber($this->d_12->ViewValue, $this->d_12->formatPattern());

            // d_13
            $this->d_13->ViewValue = $this->d_13->CurrentValue;
            $this->d_13->ViewValue = FormatNumber($this->d_13->ViewValue, $this->d_13->formatPattern());

            // d_14
            $this->d_14->ViewValue = $this->d_14->CurrentValue;
            $this->d_14->ViewValue = FormatNumber($this->d_14->ViewValue, $this->d_14->formatPattern());

            // d_15
            $this->d_15->ViewValue = $this->d_15->CurrentValue;
            $this->d_15->ViewValue = FormatNumber($this->d_15->ViewValue, $this->d_15->formatPattern());

            // d_16
            $this->d_16->ViewValue = $this->d_16->CurrentValue;
            $this->d_16->ViewValue = FormatNumber($this->d_16->ViewValue, $this->d_16->formatPattern());

            // d_17
            $this->d_17->ViewValue = $this->d_17->CurrentValue;
            $this->d_17->ViewValue = FormatNumber($this->d_17->ViewValue, $this->d_17->formatPattern());

            // d_18
            $this->d_18->ViewValue = $this->d_18->CurrentValue;
            $this->d_18->ViewValue = FormatNumber($this->d_18->ViewValue, $this->d_18->formatPattern());

            // d_19
            $this->d_19->ViewValue = $this->d_19->CurrentValue;
            $this->d_19->ViewValue = FormatNumber($this->d_19->ViewValue, $this->d_19->formatPattern());

            // d_20
            $this->d_20->ViewValue = $this->d_20->CurrentValue;
            $this->d_20->ViewValue = FormatNumber($this->d_20->ViewValue, $this->d_20->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // ref
            $this->ref->HrefValue = "";
            $this->ref->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // d_01
            $this->d_01->HrefValue = "";
            $this->d_01->TooltipValue = "";

            // d_02
            $this->d_02->HrefValue = "";
            $this->d_02->TooltipValue = "";

            // d_03
            $this->d_03->HrefValue = "";
            $this->d_03->TooltipValue = "";

            // d_04
            $this->d_04->HrefValue = "";
            $this->d_04->TooltipValue = "";

            // d_05
            $this->d_05->HrefValue = "";
            $this->d_05->TooltipValue = "";

            // d_06
            $this->d_06->HrefValue = "";
            $this->d_06->TooltipValue = "";

            // d_07
            $this->d_07->HrefValue = "";
            $this->d_07->TooltipValue = "";

            // d_08
            $this->d_08->HrefValue = "";
            $this->d_08->TooltipValue = "";

            // d_09
            $this->d_09->HrefValue = "";
            $this->d_09->TooltipValue = "";

            // d_10
            $this->d_10->HrefValue = "";
            $this->d_10->TooltipValue = "";

            // d_11
            $this->d_11->HrefValue = "";
            $this->d_11->TooltipValue = "";

            // d_12
            $this->d_12->HrefValue = "";
            $this->d_12->TooltipValue = "";

            // d_13
            $this->d_13->HrefValue = "";
            $this->d_13->TooltipValue = "";

            // d_14
            $this->d_14->HrefValue = "";
            $this->d_14->TooltipValue = "";

            // d_15
            $this->d_15->HrefValue = "";
            $this->d_15->TooltipValue = "";

            // d_16
            $this->d_16->HrefValue = "";
            $this->d_16->TooltipValue = "";

            // d_17
            $this->d_17->HrefValue = "";
            $this->d_17->TooltipValue = "";

            // d_18
            $this->d_18->HrefValue = "";
            $this->d_18->TooltipValue = "";

            // d_19
            $this->d_19->HrefValue = "";
            $this->d_19->TooltipValue = "";

            // d_20
            $this->d_20->HrefValue = "";
            $this->d_20->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->AdvancedSearch->SearchValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->AdvancedSearch->SearchValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // ref
            $this->ref->setupEditAttributes();
            $this->ref->EditValue = $this->ref->AdvancedSearch->SearchValue;
            $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

            // lot_no
            $this->lot_no->setupEditAttributes();
            if (!$this->lot_no->Raw) {
                $this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern()), $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // d_01
            $this->d_01->setupEditAttributes();
            $this->d_01->EditValue = $this->d_01->AdvancedSearch->SearchValue;
            $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

            // d_02
            $this->d_02->setupEditAttributes();
            $this->d_02->EditValue = $this->d_02->AdvancedSearch->SearchValue;
            $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

            // d_03
            $this->d_03->setupEditAttributes();
            $this->d_03->EditValue = $this->d_03->AdvancedSearch->SearchValue;
            $this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());

            // d_04
            $this->d_04->setupEditAttributes();
            $this->d_04->EditValue = $this->d_04->AdvancedSearch->SearchValue;
            $this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());

            // d_05
            $this->d_05->setupEditAttributes();
            $this->d_05->EditValue = $this->d_05->AdvancedSearch->SearchValue;
            $this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());

            // d_06
            $this->d_06->setupEditAttributes();
            $this->d_06->EditValue = $this->d_06->AdvancedSearch->SearchValue;
            $this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());

            // d_07
            $this->d_07->setupEditAttributes();
            $this->d_07->EditValue = $this->d_07->AdvancedSearch->SearchValue;
            $this->d_07->PlaceHolder = RemoveHtml($this->d_07->caption());

            // d_08
            $this->d_08->setupEditAttributes();
            $this->d_08->EditValue = $this->d_08->AdvancedSearch->SearchValue;
            $this->d_08->PlaceHolder = RemoveHtml($this->d_08->caption());

            // d_09
            $this->d_09->setupEditAttributes();
            $this->d_09->EditValue = $this->d_09->AdvancedSearch->SearchValue;
            $this->d_09->PlaceHolder = RemoveHtml($this->d_09->caption());

            // d_10
            $this->d_10->setupEditAttributes();
            $this->d_10->EditValue = $this->d_10->AdvancedSearch->SearchValue;
            $this->d_10->PlaceHolder = RemoveHtml($this->d_10->caption());

            // d_11
            $this->d_11->setupEditAttributes();
            $this->d_11->EditValue = $this->d_11->AdvancedSearch->SearchValue;
            $this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());

            // d_12
            $this->d_12->setupEditAttributes();
            $this->d_12->EditValue = $this->d_12->AdvancedSearch->SearchValue;
            $this->d_12->PlaceHolder = RemoveHtml($this->d_12->caption());

            // d_13
            $this->d_13->setupEditAttributes();
            $this->d_13->EditValue = $this->d_13->AdvancedSearch->SearchValue;
            $this->d_13->PlaceHolder = RemoveHtml($this->d_13->caption());

            // d_14
            $this->d_14->setupEditAttributes();
            $this->d_14->EditValue = $this->d_14->AdvancedSearch->SearchValue;
            $this->d_14->PlaceHolder = RemoveHtml($this->d_14->caption());

            // d_15
            $this->d_15->setupEditAttributes();
            $this->d_15->EditValue = $this->d_15->AdvancedSearch->SearchValue;
            $this->d_15->PlaceHolder = RemoveHtml($this->d_15->caption());

            // d_16
            $this->d_16->setupEditAttributes();
            $this->d_16->EditValue = $this->d_16->AdvancedSearch->SearchValue;
            $this->d_16->PlaceHolder = RemoveHtml($this->d_16->caption());

            // d_17
            $this->d_17->setupEditAttributes();
            $this->d_17->EditValue = $this->d_17->AdvancedSearch->SearchValue;
            $this->d_17->PlaceHolder = RemoveHtml($this->d_17->caption());

            // d_18
            $this->d_18->setupEditAttributes();
            $this->d_18->EditValue = $this->d_18->AdvancedSearch->SearchValue;
            $this->d_18->PlaceHolder = RemoveHtml($this->d_18->caption());

            // d_19
            $this->d_19->setupEditAttributes();
            $this->d_19->EditValue = $this->d_19->AdvancedSearch->SearchValue;
            $this->d_19->PlaceHolder = RemoveHtml($this->d_19->caption());

            // d_20
            $this->d_20->setupEditAttributes();
            $this->d_20->EditValue = $this->d_20->AdvancedSearch->SearchValue;
            $this->d_20->PlaceHolder = RemoveHtml($this->d_20->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->ref->AdvancedSearch->SearchValue)) {
            $this->ref->addErrorMessage($this->ref->getErrorMessage(false));
        }
        if (!CheckDate($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern())) {
            $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->ref->AdvancedSearch->load();
        $this->lot_no->AdvancedSearch->load();
        $this->dated->AdvancedSearch->load();
        $this->d_01->AdvancedSearch->load();
        $this->d_02->AdvancedSearch->load();
        $this->d_03->AdvancedSearch->load();
        $this->d_04->AdvancedSearch->load();
        $this->d_05->AdvancedSearch->load();
        $this->d_06->AdvancedSearch->load();
        $this->d_07->AdvancedSearch->load();
        $this->d_08->AdvancedSearch->load();
        $this->d_09->AdvancedSearch->load();
        $this->d_10->AdvancedSearch->load();
        $this->d_11->AdvancedSearch->load();
        $this->d_12->AdvancedSearch->load();
        $this->d_13->AdvancedSearch->load();
        $this->d_14->AdvancedSearch->load();
        $this->d_15->AdvancedSearch->load();
        $this->d_16->AdvancedSearch->load();
        $this->d_17->AdvancedSearch->load();
        $this->d_18->AdvancedSearch->load();
        $this->d_19->AdvancedSearch->load();
        $this->d_20->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("testreportglist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
