<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for test_report_g
 */
class TestReportG extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $grp;
    public $s_grp;
    public $product;
    public $ref;
    public $lot_no;
    public $dated;
    public $d_01;
    public $d_02;
    public $d_03;
    public $d_04;
    public $d_05;
    public $d_06;
    public $d_07;
    public $d_08;
    public $d_09;
    public $d_10;
    public $d_11;
    public $d_12;
    public $d_13;
    public $d_14;
    public $d_15;
    public $d_16;
    public $d_17;
    public $d_18;
    public $d_19;
    public $d_20;
    public $operator;
    public $datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "test_report_g";
        $this->TableName = 'test_report_g';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "test_report_g";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`id`>100");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`id`>100");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Nullable = false; // NOT NULL field
        $this->s_grp->Required = true; // Required field
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Nullable = false; // NOT NULL field
        $this->product->Required = true; // Required field
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product', false, 'id', ["product","","",""], '', '', ["x_s_grp"], ["x_ref"], ["s_grp"], ["x_s_grp[]"], [], [], false, '`product` ASC', '', "`product`");
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product'] = &$this->product;

        // ref
        $this->ref = new DbField(
            $this, // Table
            'x_ref', // Variable name
            'ref', // Name
            '`ref`', // Expression
            '`ref`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ref->InputTextType = "text";
        $this->ref->Raw = true;
        $this->ref->Nullable = false; // NOT NULL field
        $this->ref->Required = true; // Required field
        $this->ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ref'] = &$this->ref;

        // lot_no
        $this->lot_no = new DbField(
            $this, // Table
            'x_lot_no', // Variable name
            'lot_no', // Name
            '`lot_no`', // Expression
            '`lot_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lot_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lot_no->InputTextType = "text";
        $this->lot_no->Nullable = false; // NOT NULL field
        $this->lot_no->Required = true; // Required field
        $this->lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['lot_no'] = &$this->lot_no;

        // dated
        $this->dated = new DbField(
            $this, // Table
            'x_dated', // Variable name
            'dated', // Name
            '`dated`', // Expression
            CastDateFieldForLike("`dated`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`dated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dated->InputTextType = "text";
        $this->dated->Raw = true;
        $this->dated->Nullable = false; // NOT NULL field
        $this->dated->Required = true; // Required field
        $this->dated->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->dated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['dated'] = &$this->dated;

        // d_01
        $this->d_01 = new DbField(
            $this, // Table
            'x_d_01', // Variable name
            'd_01', // Name
            '`d_01`', // Expression
            '`d_01`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_01->InputTextType = "text";
        $this->d_01->Raw = true;
        $this->d_01->Nullable = false; // NOT NULL field
        $this->d_01->Required = true; // Required field
        $this->d_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_01'] = &$this->d_01;

        // d_02
        $this->d_02 = new DbField(
            $this, // Table
            'x_d_02', // Variable name
            'd_02', // Name
            '`d_02`', // Expression
            '`d_02`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_02->InputTextType = "text";
        $this->d_02->Raw = true;
        $this->d_02->Nullable = false; // NOT NULL field
        $this->d_02->Required = true; // Required field
        $this->d_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_02'] = &$this->d_02;

        // d_03
        $this->d_03 = new DbField(
            $this, // Table
            'x_d_03', // Variable name
            'd_03', // Name
            '`d_03`', // Expression
            '`d_03`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_03->InputTextType = "text";
        $this->d_03->Raw = true;
        $this->d_03->Nullable = false; // NOT NULL field
        $this->d_03->Required = true; // Required field
        $this->d_03->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_03'] = &$this->d_03;

        // d_04
        $this->d_04 = new DbField(
            $this, // Table
            'x_d_04', // Variable name
            'd_04', // Name
            '`d_04`', // Expression
            '`d_04`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_04->InputTextType = "text";
        $this->d_04->Raw = true;
        $this->d_04->Nullable = false; // NOT NULL field
        $this->d_04->Required = true; // Required field
        $this->d_04->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_04'] = &$this->d_04;

        // d_05
        $this->d_05 = new DbField(
            $this, // Table
            'x_d_05', // Variable name
            'd_05', // Name
            '`d_05`', // Expression
            '`d_05`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_05->InputTextType = "text";
        $this->d_05->Raw = true;
        $this->d_05->Nullable = false; // NOT NULL field
        $this->d_05->Required = true; // Required field
        $this->d_05->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_05'] = &$this->d_05;

        // d_06
        $this->d_06 = new DbField(
            $this, // Table
            'x_d_06', // Variable name
            'd_06', // Name
            '`d_06`', // Expression
            '`d_06`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_06->InputTextType = "text";
        $this->d_06->Raw = true;
        $this->d_06->Nullable = false; // NOT NULL field
        $this->d_06->Required = true; // Required field
        $this->d_06->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_06'] = &$this->d_06;

        // d_07
        $this->d_07 = new DbField(
            $this, // Table
            'x_d_07', // Variable name
            'd_07', // Name
            '`d_07`', // Expression
            '`d_07`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_07`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_07->InputTextType = "text";
        $this->d_07->Raw = true;
        $this->d_07->Nullable = false; // NOT NULL field
        $this->d_07->Required = true; // Required field
        $this->d_07->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_07'] = &$this->d_07;

        // d_08
        $this->d_08 = new DbField(
            $this, // Table
            'x_d_08', // Variable name
            'd_08', // Name
            '`d_08`', // Expression
            '`d_08`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_08`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_08->InputTextType = "text";
        $this->d_08->Raw = true;
        $this->d_08->Nullable = false; // NOT NULL field
        $this->d_08->Required = true; // Required field
        $this->d_08->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_08'] = &$this->d_08;

        // d_09
        $this->d_09 = new DbField(
            $this, // Table
            'x_d_09', // Variable name
            'd_09', // Name
            '`d_09`', // Expression
            '`d_09`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_09`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_09->InputTextType = "text";
        $this->d_09->Raw = true;
        $this->d_09->Nullable = false; // NOT NULL field
        $this->d_09->Required = true; // Required field
        $this->d_09->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_09'] = &$this->d_09;

        // d_10
        $this->d_10 = new DbField(
            $this, // Table
            'x_d_10', // Variable name
            'd_10', // Name
            '`d_10`', // Expression
            '`d_10`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_10->InputTextType = "text";
        $this->d_10->Raw = true;
        $this->d_10->Nullable = false; // NOT NULL field
        $this->d_10->Required = true; // Required field
        $this->d_10->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_10'] = &$this->d_10;

        // d_11
        $this->d_11 = new DbField(
            $this, // Table
            'x_d_11', // Variable name
            'd_11', // Name
            '`d_11`', // Expression
            '`d_11`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_11`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_11->InputTextType = "text";
        $this->d_11->Raw = true;
        $this->d_11->Nullable = false; // NOT NULL field
        $this->d_11->Required = true; // Required field
        $this->d_11->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_11'] = &$this->d_11;

        // d_12
        $this->d_12 = new DbField(
            $this, // Table
            'x_d_12', // Variable name
            'd_12', // Name
            '`d_12`', // Expression
            '`d_12`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_12`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_12->InputTextType = "text";
        $this->d_12->Raw = true;
        $this->d_12->Nullable = false; // NOT NULL field
        $this->d_12->Required = true; // Required field
        $this->d_12->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_12'] = &$this->d_12;

        // d_13
        $this->d_13 = new DbField(
            $this, // Table
            'x_d_13', // Variable name
            'd_13', // Name
            '`d_13`', // Expression
            '`d_13`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_13`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_13->InputTextType = "text";
        $this->d_13->Raw = true;
        $this->d_13->Nullable = false; // NOT NULL field
        $this->d_13->Required = true; // Required field
        $this->d_13->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_13'] = &$this->d_13;

        // d_14
        $this->d_14 = new DbField(
            $this, // Table
            'x_d_14', // Variable name
            'd_14', // Name
            '`d_14`', // Expression
            '`d_14`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_14`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_14->InputTextType = "text";
        $this->d_14->Raw = true;
        $this->d_14->Nullable = false; // NOT NULL field
        $this->d_14->Required = true; // Required field
        $this->d_14->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_14'] = &$this->d_14;

        // d_15
        $this->d_15 = new DbField(
            $this, // Table
            'x_d_15', // Variable name
            'd_15', // Name
            '`d_15`', // Expression
            '`d_15`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_15`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_15->InputTextType = "text";
        $this->d_15->Raw = true;
        $this->d_15->Nullable = false; // NOT NULL field
        $this->d_15->Required = true; // Required field
        $this->d_15->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_15'] = &$this->d_15;

        // d_16
        $this->d_16 = new DbField(
            $this, // Table
            'x_d_16', // Variable name
            'd_16', // Name
            '`d_16`', // Expression
            '`d_16`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_16`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_16->InputTextType = "text";
        $this->d_16->Raw = true;
        $this->d_16->Nullable = false; // NOT NULL field
        $this->d_16->Required = true; // Required field
        $this->d_16->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_16'] = &$this->d_16;

        // d_17
        $this->d_17 = new DbField(
            $this, // Table
            'x_d_17', // Variable name
            'd_17', // Name
            '`d_17`', // Expression
            '`d_17`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_17`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_17->InputTextType = "text";
        $this->d_17->Raw = true;
        $this->d_17->Nullable = false; // NOT NULL field
        $this->d_17->Required = true; // Required field
        $this->d_17->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_17'] = &$this->d_17;

        // d_18
        $this->d_18 = new DbField(
            $this, // Table
            'x_d_18', // Variable name
            'd_18', // Name
            '`d_18`', // Expression
            '`d_18`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_18`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_18->InputTextType = "text";
        $this->d_18->Raw = true;
        $this->d_18->Nullable = false; // NOT NULL field
        $this->d_18->Required = true; // Required field
        $this->d_18->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_18'] = &$this->d_18;

        // d_19
        $this->d_19 = new DbField(
            $this, // Table
            'x_d_19', // Variable name
            'd_19', // Name
            '`d_19`', // Expression
            '`d_19`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_19`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_19->InputTextType = "text";
        $this->d_19->Raw = true;
        $this->d_19->Nullable = false; // NOT NULL field
        $this->d_19->Required = true; // Required field
        $this->d_19->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_19'] = &$this->d_19;

        // d_20
        $this->d_20 = new DbField(
            $this, // Table
            'x_d_20', // Variable name
            'd_20', // Name
            '`d_20`', // Expression
            '`d_20`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_20`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_20->InputTextType = "text";
        $this->d_20->Raw = true;
        $this->d_20->Nullable = false; // NOT NULL field
        $this->d_20->Required = true; // Required field
        $this->d_20->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['d_20'] = &$this->d_20;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "test_report_g";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->ref->DbValue = $row['ref'];
        $this->lot_no->DbValue = $row['lot_no'];
        $this->dated->DbValue = $row['dated'];
        $this->d_01->DbValue = $row['d_01'];
        $this->d_02->DbValue = $row['d_02'];
        $this->d_03->DbValue = $row['d_03'];
        $this->d_04->DbValue = $row['d_04'];
        $this->d_05->DbValue = $row['d_05'];
        $this->d_06->DbValue = $row['d_06'];
        $this->d_07->DbValue = $row['d_07'];
        $this->d_08->DbValue = $row['d_08'];
        $this->d_09->DbValue = $row['d_09'];
        $this->d_10->DbValue = $row['d_10'];
        $this->d_11->DbValue = $row['d_11'];
        $this->d_12->DbValue = $row['d_12'];
        $this->d_13->DbValue = $row['d_13'];
        $this->d_14->DbValue = $row['d_14'];
        $this->d_15->DbValue = $row['d_15'];
        $this->d_16->DbValue = $row['d_16'];
        $this->d_17->DbValue = $row['d_17'];
        $this->d_18->DbValue = $row['d_18'];
        $this->d_19->DbValue = $row['d_19'];
        $this->d_20->DbValue = $row['d_20'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("testreportglist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "testreportgview" => $Language->phrase("View"),
            "testreportgedit" => $Language->phrase("Edit"),
            "testreportgadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "testreportglist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "TestReportGView",
            Config("API_ADD_ACTION") => "TestReportGAdd",
            Config("API_EDIT_ACTION") => "TestReportGEdit",
            Config("API_DELETE_ACTION") => "TestReportGDelete",
            Config("API_LIST_ACTION") => "TestReportGList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "testreportglist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("testreportgview", $parm);
        } else {
            $url = $this->keyUrl("testreportgview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "testreportgadd?" . $parm;
        } else {
            $url = "testreportgadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("testreportgedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("testreportglist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("testreportgadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("testreportglist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("testreportgdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->ref->setDbValue($row['ref']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->dated->setDbValue($row['dated']);
        $this->d_01->setDbValue($row['d_01']);
        $this->d_02->setDbValue($row['d_02']);
        $this->d_03->setDbValue($row['d_03']);
        $this->d_04->setDbValue($row['d_04']);
        $this->d_05->setDbValue($row['d_05']);
        $this->d_06->setDbValue($row['d_06']);
        $this->d_07->setDbValue($row['d_07']);
        $this->d_08->setDbValue($row['d_08']);
        $this->d_09->setDbValue($row['d_09']);
        $this->d_10->setDbValue($row['d_10']);
        $this->d_11->setDbValue($row['d_11']);
        $this->d_12->setDbValue($row['d_12']);
        $this->d_13->setDbValue($row['d_13']);
        $this->d_14->setDbValue($row['d_14']);
        $this->d_15->setDbValue($row['d_15']);
        $this->d_16->setDbValue($row['d_16']);
        $this->d_17->setDbValue($row['d_17']);
        $this->d_18->setDbValue($row['d_18']);
        $this->d_19->setDbValue($row['d_19']);
        $this->d_20->setDbValue($row['d_20']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "TestReportGList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // grp

        // s_grp

        // product

        // ref

        // lot_no

        // dated

        // d_01

        // d_02

        // d_03

        // d_04

        // d_05

        // d_06

        // d_07

        // d_08

        // d_09

        // d_10

        // d_11

        // d_12

        // d_13

        // d_14

        // d_15

        // d_16

        // d_17

        // d_18

        // d_19

        // d_20

        // operator

        // datetime

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                }
            }
        } else {
            $this->product->ViewValue = null;
        }
        $this->product->CssClass = "fst-italic";

        // ref
        $this->ref->ViewValue = $this->ref->CurrentValue;
        $this->ref->ViewValue = FormatNumber($this->ref->ViewValue, $this->ref->formatPattern());

        // lot_no
        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

        // dated
        $this->dated->ViewValue = $this->dated->CurrentValue;
        $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

        // d_01
        $this->d_01->ViewValue = $this->d_01->CurrentValue;
        $this->d_01->ViewValue = FormatNumber($this->d_01->ViewValue, $this->d_01->formatPattern());

        // d_02
        $this->d_02->ViewValue = $this->d_02->CurrentValue;
        $this->d_02->ViewValue = FormatNumber($this->d_02->ViewValue, $this->d_02->formatPattern());

        // d_03
        $this->d_03->ViewValue = $this->d_03->CurrentValue;
        $this->d_03->ViewValue = FormatNumber($this->d_03->ViewValue, $this->d_03->formatPattern());

        // d_04
        $this->d_04->ViewValue = $this->d_04->CurrentValue;
        $this->d_04->ViewValue = FormatNumber($this->d_04->ViewValue, $this->d_04->formatPattern());

        // d_05
        $this->d_05->ViewValue = $this->d_05->CurrentValue;
        $this->d_05->ViewValue = FormatNumber($this->d_05->ViewValue, $this->d_05->formatPattern());

        // d_06
        $this->d_06->ViewValue = $this->d_06->CurrentValue;
        $this->d_06->ViewValue = FormatNumber($this->d_06->ViewValue, $this->d_06->formatPattern());

        // d_07
        $this->d_07->ViewValue = $this->d_07->CurrentValue;
        $this->d_07->ViewValue = FormatNumber($this->d_07->ViewValue, $this->d_07->formatPattern());

        // d_08
        $this->d_08->ViewValue = $this->d_08->CurrentValue;
        $this->d_08->ViewValue = FormatNumber($this->d_08->ViewValue, $this->d_08->formatPattern());

        // d_09
        $this->d_09->ViewValue = $this->d_09->CurrentValue;
        $this->d_09->ViewValue = FormatNumber($this->d_09->ViewValue, $this->d_09->formatPattern());

        // d_10
        $this->d_10->ViewValue = $this->d_10->CurrentValue;
        $this->d_10->ViewValue = FormatNumber($this->d_10->ViewValue, $this->d_10->formatPattern());

        // d_11
        $this->d_11->ViewValue = $this->d_11->CurrentValue;
        $this->d_11->ViewValue = FormatNumber($this->d_11->ViewValue, $this->d_11->formatPattern());

        // d_12
        $this->d_12->ViewValue = $this->d_12->CurrentValue;
        $this->d_12->ViewValue = FormatNumber($this->d_12->ViewValue, $this->d_12->formatPattern());

        // d_13
        $this->d_13->ViewValue = $this->d_13->CurrentValue;
        $this->d_13->ViewValue = FormatNumber($this->d_13->ViewValue, $this->d_13->formatPattern());

        // d_14
        $this->d_14->ViewValue = $this->d_14->CurrentValue;
        $this->d_14->ViewValue = FormatNumber($this->d_14->ViewValue, $this->d_14->formatPattern());

        // d_15
        $this->d_15->ViewValue = $this->d_15->CurrentValue;
        $this->d_15->ViewValue = FormatNumber($this->d_15->ViewValue, $this->d_15->formatPattern());

        // d_16
        $this->d_16->ViewValue = $this->d_16->CurrentValue;
        $this->d_16->ViewValue = FormatNumber($this->d_16->ViewValue, $this->d_16->formatPattern());

        // d_17
        $this->d_17->ViewValue = $this->d_17->CurrentValue;
        $this->d_17->ViewValue = FormatNumber($this->d_17->ViewValue, $this->d_17->formatPattern());

        // d_18
        $this->d_18->ViewValue = $this->d_18->CurrentValue;
        $this->d_18->ViewValue = FormatNumber($this->d_18->ViewValue, $this->d_18->formatPattern());

        // d_19
        $this->d_19->ViewValue = $this->d_19->CurrentValue;
        $this->d_19->ViewValue = FormatNumber($this->d_19->ViewValue, $this->d_19->formatPattern());

        // d_20
        $this->d_20->ViewValue = $this->d_20->CurrentValue;
        $this->d_20->ViewValue = FormatNumber($this->d_20->ViewValue, $this->d_20->formatPattern());

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        $this->s_grp->HrefValue = "";
        $this->s_grp->TooltipValue = "";

        // product
        $this->product->HrefValue = "";
        $this->product->TooltipValue = "";

        // ref
        $this->ref->HrefValue = "";
        $this->ref->TooltipValue = "";

        // lot_no
        $this->lot_no->HrefValue = "";
        $this->lot_no->TooltipValue = "";

        // dated
        $this->dated->HrefValue = "";
        $this->dated->TooltipValue = "";

        // d_01
        $this->d_01->HrefValue = "";
        $this->d_01->TooltipValue = "";

        // d_02
        $this->d_02->HrefValue = "";
        $this->d_02->TooltipValue = "";

        // d_03
        $this->d_03->HrefValue = "";
        $this->d_03->TooltipValue = "";

        // d_04
        $this->d_04->HrefValue = "";
        $this->d_04->TooltipValue = "";

        // d_05
        $this->d_05->HrefValue = "";
        $this->d_05->TooltipValue = "";

        // d_06
        $this->d_06->HrefValue = "";
        $this->d_06->TooltipValue = "";

        // d_07
        $this->d_07->HrefValue = "";
        $this->d_07->TooltipValue = "";

        // d_08
        $this->d_08->HrefValue = "";
        $this->d_08->TooltipValue = "";

        // d_09
        $this->d_09->HrefValue = "";
        $this->d_09->TooltipValue = "";

        // d_10
        $this->d_10->HrefValue = "";
        $this->d_10->TooltipValue = "";

        // d_11
        $this->d_11->HrefValue = "";
        $this->d_11->TooltipValue = "";

        // d_12
        $this->d_12->HrefValue = "";
        $this->d_12->TooltipValue = "";

        // d_13
        $this->d_13->HrefValue = "";
        $this->d_13->TooltipValue = "";

        // d_14
        $this->d_14->HrefValue = "";
        $this->d_14->TooltipValue = "";

        // d_15
        $this->d_15->HrefValue = "";
        $this->d_15->TooltipValue = "";

        // d_16
        $this->d_16->HrefValue = "";
        $this->d_16->TooltipValue = "";

        // d_17
        $this->d_17->HrefValue = "";
        $this->d_17->TooltipValue = "";

        // d_18
        $this->d_18->HrefValue = "";
        $this->d_18->TooltipValue = "";

        // d_19
        $this->d_19->HrefValue = "";
        $this->d_19->TooltipValue = "";

        // d_20
        $this->d_20->HrefValue = "";
        $this->d_20->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->EditValue = FormatNumber($this->id->EditValue, $this->id->formatPattern());

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // product
        $this->product->setupEditAttributes();
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());

        // ref
        $this->ref->setupEditAttributes();
        $this->ref->EditValue = $this->ref->CurrentValue;
        $this->ref->PlaceHolder = RemoveHtml($this->ref->caption());
        if (strval($this->ref->EditValue) != "" && is_numeric($this->ref->EditValue)) {
            $this->ref->EditValue = FormatNumber($this->ref->EditValue, null);
        }

        // lot_no
        $this->lot_no->setupEditAttributes();
        if (!$this->lot_no->Raw) {
            $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
        }
        $this->lot_no->EditValue = $this->lot_no->CurrentValue;
        $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

        // dated
        $this->dated->setupEditAttributes();
        $this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

        // d_01
        $this->d_01->setupEditAttributes();
        $this->d_01->EditValue = $this->d_01->CurrentValue;
        $this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());
        if (strval($this->d_01->EditValue) != "" && is_numeric($this->d_01->EditValue)) {
            $this->d_01->EditValue = FormatNumber($this->d_01->EditValue, null);
        }

        // d_02
        $this->d_02->setupEditAttributes();
        $this->d_02->EditValue = $this->d_02->CurrentValue;
        $this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());
        if (strval($this->d_02->EditValue) != "" && is_numeric($this->d_02->EditValue)) {
            $this->d_02->EditValue = FormatNumber($this->d_02->EditValue, null);
        }

        // d_03
        $this->d_03->setupEditAttributes();
        $this->d_03->EditValue = $this->d_03->CurrentValue;
        $this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());
        if (strval($this->d_03->EditValue) != "" && is_numeric($this->d_03->EditValue)) {
            $this->d_03->EditValue = FormatNumber($this->d_03->EditValue, null);
        }

        // d_04
        $this->d_04->setupEditAttributes();
        $this->d_04->EditValue = $this->d_04->CurrentValue;
        $this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());
        if (strval($this->d_04->EditValue) != "" && is_numeric($this->d_04->EditValue)) {
            $this->d_04->EditValue = FormatNumber($this->d_04->EditValue, null);
        }

        // d_05
        $this->d_05->setupEditAttributes();
        $this->d_05->EditValue = $this->d_05->CurrentValue;
        $this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());
        if (strval($this->d_05->EditValue) != "" && is_numeric($this->d_05->EditValue)) {
            $this->d_05->EditValue = FormatNumber($this->d_05->EditValue, null);
        }

        // d_06
        $this->d_06->setupEditAttributes();
        $this->d_06->EditValue = $this->d_06->CurrentValue;
        $this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());
        if (strval($this->d_06->EditValue) != "" && is_numeric($this->d_06->EditValue)) {
            $this->d_06->EditValue = FormatNumber($this->d_06->EditValue, null);
        }

        // d_07
        $this->d_07->setupEditAttributes();
        $this->d_07->EditValue = $this->d_07->CurrentValue;
        $this->d_07->PlaceHolder = RemoveHtml($this->d_07->caption());
        if (strval($this->d_07->EditValue) != "" && is_numeric($this->d_07->EditValue)) {
            $this->d_07->EditValue = FormatNumber($this->d_07->EditValue, null);
        }

        // d_08
        $this->d_08->setupEditAttributes();
        $this->d_08->EditValue = $this->d_08->CurrentValue;
        $this->d_08->PlaceHolder = RemoveHtml($this->d_08->caption());
        if (strval($this->d_08->EditValue) != "" && is_numeric($this->d_08->EditValue)) {
            $this->d_08->EditValue = FormatNumber($this->d_08->EditValue, null);
        }

        // d_09
        $this->d_09->setupEditAttributes();
        $this->d_09->EditValue = $this->d_09->CurrentValue;
        $this->d_09->PlaceHolder = RemoveHtml($this->d_09->caption());
        if (strval($this->d_09->EditValue) != "" && is_numeric($this->d_09->EditValue)) {
            $this->d_09->EditValue = FormatNumber($this->d_09->EditValue, null);
        }

        // d_10
        $this->d_10->setupEditAttributes();
        $this->d_10->EditValue = $this->d_10->CurrentValue;
        $this->d_10->PlaceHolder = RemoveHtml($this->d_10->caption());
        if (strval($this->d_10->EditValue) != "" && is_numeric($this->d_10->EditValue)) {
            $this->d_10->EditValue = FormatNumber($this->d_10->EditValue, null);
        }

        // d_11
        $this->d_11->setupEditAttributes();
        $this->d_11->EditValue = $this->d_11->CurrentValue;
        $this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());
        if (strval($this->d_11->EditValue) != "" && is_numeric($this->d_11->EditValue)) {
            $this->d_11->EditValue = FormatNumber($this->d_11->EditValue, null);
        }

        // d_12
        $this->d_12->setupEditAttributes();
        $this->d_12->EditValue = $this->d_12->CurrentValue;
        $this->d_12->PlaceHolder = RemoveHtml($this->d_12->caption());
        if (strval($this->d_12->EditValue) != "" && is_numeric($this->d_12->EditValue)) {
            $this->d_12->EditValue = FormatNumber($this->d_12->EditValue, null);
        }

        // d_13
        $this->d_13->setupEditAttributes();
        $this->d_13->EditValue = $this->d_13->CurrentValue;
        $this->d_13->PlaceHolder = RemoveHtml($this->d_13->caption());
        if (strval($this->d_13->EditValue) != "" && is_numeric($this->d_13->EditValue)) {
            $this->d_13->EditValue = FormatNumber($this->d_13->EditValue, null);
        }

        // d_14
        $this->d_14->setupEditAttributes();
        $this->d_14->EditValue = $this->d_14->CurrentValue;
        $this->d_14->PlaceHolder = RemoveHtml($this->d_14->caption());
        if (strval($this->d_14->EditValue) != "" && is_numeric($this->d_14->EditValue)) {
            $this->d_14->EditValue = FormatNumber($this->d_14->EditValue, null);
        }

        // d_15
        $this->d_15->setupEditAttributes();
        $this->d_15->EditValue = $this->d_15->CurrentValue;
        $this->d_15->PlaceHolder = RemoveHtml($this->d_15->caption());
        if (strval($this->d_15->EditValue) != "" && is_numeric($this->d_15->EditValue)) {
            $this->d_15->EditValue = FormatNumber($this->d_15->EditValue, null);
        }

        // d_16
        $this->d_16->setupEditAttributes();
        $this->d_16->EditValue = $this->d_16->CurrentValue;
        $this->d_16->PlaceHolder = RemoveHtml($this->d_16->caption());
        if (strval($this->d_16->EditValue) != "" && is_numeric($this->d_16->EditValue)) {
            $this->d_16->EditValue = FormatNumber($this->d_16->EditValue, null);
        }

        // d_17
        $this->d_17->setupEditAttributes();
        $this->d_17->EditValue = $this->d_17->CurrentValue;
        $this->d_17->PlaceHolder = RemoveHtml($this->d_17->caption());
        if (strval($this->d_17->EditValue) != "" && is_numeric($this->d_17->EditValue)) {
            $this->d_17->EditValue = FormatNumber($this->d_17->EditValue, null);
        }

        // d_18
        $this->d_18->setupEditAttributes();
        $this->d_18->EditValue = $this->d_18->CurrentValue;
        $this->d_18->PlaceHolder = RemoveHtml($this->d_18->caption());
        if (strval($this->d_18->EditValue) != "" && is_numeric($this->d_18->EditValue)) {
            $this->d_18->EditValue = FormatNumber($this->d_18->EditValue, null);
        }

        // d_19
        $this->d_19->setupEditAttributes();
        $this->d_19->EditValue = $this->d_19->CurrentValue;
        $this->d_19->PlaceHolder = RemoveHtml($this->d_19->caption());
        if (strval($this->d_19->EditValue) != "" && is_numeric($this->d_19->EditValue)) {
            $this->d_19->EditValue = FormatNumber($this->d_19->EditValue, null);
        }

        // d_20
        $this->d_20->setupEditAttributes();
        $this->d_20->EditValue = $this->d_20->CurrentValue;
        $this->d_20->PlaceHolder = RemoveHtml($this->d_20->caption());
        if (strval($this->d_20->EditValue) != "" && is_numeric($this->d_20->EditValue)) {
            $this->d_20->EditValue = FormatNumber($this->d_20->EditValue, null);
        }

        // operator

        // datetime

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->dated);
                    $doc->exportCaption($this->d_01);
                    $doc->exportCaption($this->d_02);
                    $doc->exportCaption($this->d_03);
                    $doc->exportCaption($this->d_04);
                    $doc->exportCaption($this->d_05);
                    $doc->exportCaption($this->d_06);
                    $doc->exportCaption($this->d_07);
                    $doc->exportCaption($this->d_08);
                    $doc->exportCaption($this->d_09);
                    $doc->exportCaption($this->d_10);
                    $doc->exportCaption($this->d_11);
                    $doc->exportCaption($this->d_12);
                    $doc->exportCaption($this->d_13);
                    $doc->exportCaption($this->d_14);
                    $doc->exportCaption($this->d_15);
                    $doc->exportCaption($this->d_16);
                    $doc->exportCaption($this->d_17);
                    $doc->exportCaption($this->d_18);
                    $doc->exportCaption($this->d_19);
                    $doc->exportCaption($this->d_20);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->ref);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->dated);
                    $doc->exportCaption($this->d_01);
                    $doc->exportCaption($this->d_02);
                    $doc->exportCaption($this->d_03);
                    $doc->exportCaption($this->d_04);
                    $doc->exportCaption($this->d_05);
                    $doc->exportCaption($this->d_06);
                    $doc->exportCaption($this->d_07);
                    $doc->exportCaption($this->d_08);
                    $doc->exportCaption($this->d_09);
                    $doc->exportCaption($this->d_10);
                    $doc->exportCaption($this->d_11);
                    $doc->exportCaption($this->d_12);
                    $doc->exportCaption($this->d_13);
                    $doc->exportCaption($this->d_14);
                    $doc->exportCaption($this->d_15);
                    $doc->exportCaption($this->d_16);
                    $doc->exportCaption($this->d_17);
                    $doc->exportCaption($this->d_18);
                    $doc->exportCaption($this->d_19);
                    $doc->exportCaption($this->d_20);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->dated);
                        $doc->exportField($this->d_01);
                        $doc->exportField($this->d_02);
                        $doc->exportField($this->d_03);
                        $doc->exportField($this->d_04);
                        $doc->exportField($this->d_05);
                        $doc->exportField($this->d_06);
                        $doc->exportField($this->d_07);
                        $doc->exportField($this->d_08);
                        $doc->exportField($this->d_09);
                        $doc->exportField($this->d_10);
                        $doc->exportField($this->d_11);
                        $doc->exportField($this->d_12);
                        $doc->exportField($this->d_13);
                        $doc->exportField($this->d_14);
                        $doc->exportField($this->d_15);
                        $doc->exportField($this->d_16);
                        $doc->exportField($this->d_17);
                        $doc->exportField($this->d_18);
                        $doc->exportField($this->d_19);
                        $doc->exportField($this->d_20);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->ref);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->dated);
                        $doc->exportField($this->d_01);
                        $doc->exportField($this->d_02);
                        $doc->exportField($this->d_03);
                        $doc->exportField($this->d_04);
                        $doc->exportField($this->d_05);
                        $doc->exportField($this->d_06);
                        $doc->exportField($this->d_07);
                        $doc->exportField($this->d_08);
                        $doc->exportField($this->d_09);
                        $doc->exportField($this->d_10);
                        $doc->exportField($this->d_11);
                        $doc->exportField($this->d_12);
                        $doc->exportField($this->d_13);
                        $doc->exportField($this->d_14);
                        $doc->exportField($this->d_15);
                        $doc->exportField($this->d_16);
                        $doc->exportField($this->d_17);
                        $doc->exportField($this->d_18);
                        $doc->exportField($this->d_19);
                        $doc->exportField($this->d_20);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
