<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TTyreInfoSearch extends TTyreInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TTyreInfoSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "ttyreinfosearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->vehicle_no->setVisibility();
        $this->head->setVisibility();
        $this->sub_head->setVisibility();
        $this->s_no->setVisibility();
        $this->km->setVisibility();
        $this->life_km->setVisibility();
        $this->recycle_after_km->setVisibility();
        $this->next_km->setVisibility();
        $this->recycle_next_km->setVisibility();
        $this->puncture->setVisibility();
        $this->current_km->setVisibility();
        $this->remaining_km->setVisibility();
        $this->remarks->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 't_tyre_info';
        $this->TableName = 't_tyre_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (t_tyre_info)
        if (!isset($GLOBALS["t_tyre_info"]) || $GLOBALS["t_tyre_info"]::class == PROJECT_NAMESPACE . "t_tyre_info") {
            $GLOBALS["t_tyre_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 't_tyre_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "ttyreinfoview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->vehicle_no);
        $this->setupLookupOptions($this->head);
        $this->setupLookupOptions($this->sub_head);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "ttyreinfolist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->vehicle_no); // vehicle_no
        $this->buildSearchUrl($srchUrl, $this->head); // head
        $this->buildSearchUrl($srchUrl, $this->sub_head); // sub_head
        $this->buildSearchUrl($srchUrl, $this->s_no); // s_no
        $this->buildSearchUrl($srchUrl, $this->km); // km
        $this->buildSearchUrl($srchUrl, $this->life_km); // life_km
        $this->buildSearchUrl($srchUrl, $this->recycle_after_km); // recycle_after_km
        $this->buildSearchUrl($srchUrl, $this->next_km); // next_km
        $this->buildSearchUrl($srchUrl, $this->recycle_next_km); // recycle_next_km
        $this->buildSearchUrl($srchUrl, $this->puncture); // puncture
        $this->buildSearchUrl($srchUrl, $this->current_km); // current_km
        $this->buildSearchUrl($srchUrl, $this->remaining_km); // remaining_km
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_no
        if ($this->vehicle_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // head
        if ($this->head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sub_head
        if ($this->sub_head->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_no
        if ($this->s_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // km
        if ($this->km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // life_km
        if ($this->life_km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // recycle_after_km
        if ($this->recycle_after_km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // next_km
        if ($this->next_km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // recycle_next_km
        if ($this->recycle_next_km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // puncture
        if ($this->puncture->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // current_km
        if ($this->current_km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remaining_km
        if ($this->remaining_km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // vehicle_no
        $this->vehicle_no->RowCssClass = "row";

        // head
        $this->head->RowCssClass = "row";

        // sub_head
        $this->sub_head->RowCssClass = "row";

        // s_no
        $this->s_no->RowCssClass = "row";

        // km
        $this->km->RowCssClass = "row";

        // life_km
        $this->life_km->RowCssClass = "row";

        // recycle_after_km
        $this->recycle_after_km->RowCssClass = "row";

        // next_km
        $this->next_km->RowCssClass = "row";

        // recycle_next_km
        $this->recycle_next_km->RowCssClass = "row";

        // puncture
        $this->puncture->RowCssClass = "row";

        // current_km
        $this->current_km->RowCssClass = "row";

        // remaining_km
        $this->remaining_km->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // vehicle_no
            $curVal = strval($this->vehicle_no->CurrentValue);
            if ($curVal != "") {
                $this->vehicle_no->ViewValue = $this->vehicle_no->lookupCacheOption($curVal);
                if ($this->vehicle_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle_no->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle_no->ViewValue = $this->vehicle_no->displayValue($arwrk);
                    } else {
                        $this->vehicle_no->ViewValue = FormatNumber($this->vehicle_no->CurrentValue, $this->vehicle_no->formatPattern());
                    }
                }
            } else {
                $this->vehicle_no->ViewValue = null;
            }

            // head
            $curVal = strval($this->head->CurrentValue);
            if ($curVal != "") {
                $this->head->ViewValue = $this->head->lookupCacheOption($curVal);
                if ($this->head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->head->getSelectFilter($this); // PHP
                    $sqlWrk = $this->head->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->head->Lookup->renderViewRow($rswrk[0]);
                        $this->head->ViewValue = $this->head->displayValue($arwrk);
                    } else {
                        $this->head->ViewValue = FormatNumber($this->head->CurrentValue, $this->head->formatPattern());
                    }
                }
            } else {
                $this->head->ViewValue = null;
            }

            // sub_head
            $curVal = strval($this->sub_head->CurrentValue);
            if ($curVal != "") {
                $this->sub_head->ViewValue = $this->sub_head->lookupCacheOption($curVal);
                if ($this->sub_head->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->sub_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->sub_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->sub_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sub_head->Lookup->renderViewRow($rswrk[0]);
                        $this->sub_head->ViewValue = $this->sub_head->displayValue($arwrk);
                    } else {
                        $this->sub_head->ViewValue = FormatNumber($this->sub_head->CurrentValue, $this->sub_head->formatPattern());
                    }
                }
            } else {
                $this->sub_head->ViewValue = null;
            }

            // s_no
            $this->s_no->ViewValue = $this->s_no->CurrentValue;

            // km
            $this->km->ViewValue = $this->km->CurrentValue;
            $this->km->ViewValue = FormatNumber($this->km->ViewValue, $this->km->formatPattern());

            // life_km
            $this->life_km->ViewValue = $this->life_km->CurrentValue;
            $this->life_km->ViewValue = FormatNumber($this->life_km->ViewValue, $this->life_km->formatPattern());

            // recycle_after_km
            $this->recycle_after_km->ViewValue = $this->recycle_after_km->CurrentValue;
            $this->recycle_after_km->ViewValue = FormatNumber($this->recycle_after_km->ViewValue, $this->recycle_after_km->formatPattern());

            // next_km
            $this->next_km->ViewValue = $this->next_km->CurrentValue;
            $this->next_km->ViewValue = FormatNumber($this->next_km->ViewValue, $this->next_km->formatPattern());

            // recycle_next_km
            $this->recycle_next_km->ViewValue = $this->recycle_next_km->CurrentValue;
            $this->recycle_next_km->ViewValue = FormatNumber($this->recycle_next_km->ViewValue, $this->recycle_next_km->formatPattern());

            // puncture
            $this->puncture->ViewValue = $this->puncture->CurrentValue;
            $this->puncture->ViewValue = FormatNumber($this->puncture->ViewValue, $this->puncture->formatPattern());

            // current_km
            $this->current_km->ViewValue = $this->current_km->CurrentValue;
            $this->current_km->ViewValue = FormatNumber($this->current_km->ViewValue, $this->current_km->formatPattern());

            // remaining_km
            $this->remaining_km->ViewValue = $this->remaining_km->CurrentValue;
            $this->remaining_km->ViewValue = FormatNumber($this->remaining_km->ViewValue, $this->remaining_km->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // vehicle_no
            $this->vehicle_no->HrefValue = "";
            $this->vehicle_no->TooltipValue = "";

            // head
            $this->head->HrefValue = "";
            $this->head->TooltipValue = "";

            // sub_head
            $this->sub_head->HrefValue = "";
            $this->sub_head->TooltipValue = "";

            // s_no
            $this->s_no->HrefValue = "";
            $this->s_no->TooltipValue = "";

            // km
            $this->km->HrefValue = "";
            $this->km->TooltipValue = "";

            // life_km
            $this->life_km->HrefValue = "";
            $this->life_km->TooltipValue = "";

            // recycle_after_km
            $this->recycle_after_km->HrefValue = "";
            $this->recycle_after_km->TooltipValue = "";

            // next_km
            $this->next_km->HrefValue = "";
            $this->next_km->TooltipValue = "";

            // recycle_next_km
            $this->recycle_next_km->HrefValue = "";
            $this->recycle_next_km->TooltipValue = "";

            // puncture
            $this->puncture->HrefValue = "";
            $this->puncture->TooltipValue = "";

            // current_km
            $this->current_km->HrefValue = "";
            $this->current_km->TooltipValue = "";

            // remaining_km
            $this->remaining_km->HrefValue = "";
            $this->remaining_km->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // vehicle_no
            $this->vehicle_no->setupEditAttributes();
            $curVal = trim(strval($this->vehicle_no->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->vehicle_no->AdvancedSearch->ViewValue = $this->vehicle_no->lookupCacheOption($curVal);
            } else {
                $this->vehicle_no->AdvancedSearch->ViewValue = $this->vehicle_no->Lookup !== null && is_array($this->vehicle_no->lookupOptions()) && count($this->vehicle_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->vehicle_no->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->vehicle_no->EditValue = array_values($this->vehicle_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->vehicle_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->vehicle_no->AdvancedSearch->SearchValue, $this->vehicle_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->vehicle_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->vehicle_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->vehicle_no->EditValue = $arwrk;
            }
            $this->vehicle_no->PlaceHolder = RemoveHtml($this->vehicle_no->caption());

            // head
            $this->head->setupEditAttributes();
            $curVal = trim(strval($this->head->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->head->AdvancedSearch->ViewValue = $this->head->lookupCacheOption($curVal);
            } else {
                $this->head->AdvancedSearch->ViewValue = $this->head->Lookup !== null && is_array($this->head->lookupOptions()) && count($this->head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->head->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->head->EditValue = array_values($this->head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->head->AdvancedSearch->SearchValue, $this->head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->head->getSelectFilter($this); // PHP
                $sqlWrk = $this->head->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->head->EditValue = $arwrk;
            }
            $this->head->PlaceHolder = RemoveHtml($this->head->caption());

            // sub_head
            $this->sub_head->setupEditAttributes();
            $curVal = trim(strval($this->sub_head->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->sub_head->AdvancedSearch->ViewValue = $this->sub_head->lookupCacheOption($curVal);
            } else {
                $this->sub_head->AdvancedSearch->ViewValue = $this->sub_head->Lookup !== null && is_array($this->sub_head->lookupOptions()) && count($this->sub_head->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sub_head->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->sub_head->EditValue = array_values($this->sub_head->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->sub_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->sub_head->AdvancedSearch->SearchValue, $this->sub_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->sub_head->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->sub_head->EditValue = $arwrk;
            }
            $this->sub_head->PlaceHolder = RemoveHtml($this->sub_head->caption());

            // s_no
            $this->s_no->setupEditAttributes();
            if (!$this->s_no->Raw) {
                $this->s_no->AdvancedSearch->SearchValue = HtmlDecode($this->s_no->AdvancedSearch->SearchValue);
            }
            $this->s_no->EditValue = HtmlEncode($this->s_no->AdvancedSearch->SearchValue);
            $this->s_no->PlaceHolder = RemoveHtml($this->s_no->caption());

            // km
            $this->km->setupEditAttributes();
            $this->km->EditValue = $this->km->AdvancedSearch->SearchValue;
            $this->km->PlaceHolder = RemoveHtml($this->km->caption());

            // life_km
            $this->life_km->setupEditAttributes();
            $this->life_km->EditValue = $this->life_km->AdvancedSearch->SearchValue;
            $this->life_km->PlaceHolder = RemoveHtml($this->life_km->caption());

            // recycle_after_km
            $this->recycle_after_km->setupEditAttributes();
            $this->recycle_after_km->EditValue = $this->recycle_after_km->AdvancedSearch->SearchValue;
            $this->recycle_after_km->PlaceHolder = RemoveHtml($this->recycle_after_km->caption());

            // next_km
            $this->next_km->setupEditAttributes();
            $this->next_km->EditValue = $this->next_km->AdvancedSearch->SearchValue;
            $this->next_km->PlaceHolder = RemoveHtml($this->next_km->caption());

            // recycle_next_km
            $this->recycle_next_km->setupEditAttributes();
            $this->recycle_next_km->EditValue = $this->recycle_next_km->AdvancedSearch->SearchValue;
            $this->recycle_next_km->PlaceHolder = RemoveHtml($this->recycle_next_km->caption());

            // puncture
            $this->puncture->setupEditAttributes();
            $this->puncture->EditValue = $this->puncture->AdvancedSearch->SearchValue;
            $this->puncture->PlaceHolder = RemoveHtml($this->puncture->caption());

            // current_km
            $this->current_km->setupEditAttributes();
            $this->current_km->EditValue = $this->current_km->AdvancedSearch->SearchValue;
            $this->current_km->PlaceHolder = RemoveHtml($this->current_km->caption());

            // remaining_km
            $this->remaining_km->setupEditAttributes();
            $this->remaining_km->EditValue = $this->remaining_km->AdvancedSearch->SearchValue;
            $this->remaining_km->PlaceHolder = RemoveHtml($this->remaining_km->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->km->AdvancedSearch->SearchValue)) {
            $this->km->addErrorMessage($this->km->getErrorMessage(false));
        }
        if (!CheckInteger($this->life_km->AdvancedSearch->SearchValue)) {
            $this->life_km->addErrorMessage($this->life_km->getErrorMessage(false));
        }
        if (!CheckInteger($this->recycle_after_km->AdvancedSearch->SearchValue)) {
            $this->recycle_after_km->addErrorMessage($this->recycle_after_km->getErrorMessage(false));
        }
        if (!CheckInteger($this->next_km->AdvancedSearch->SearchValue)) {
            $this->next_km->addErrorMessage($this->next_km->getErrorMessage(false));
        }
        if (!CheckInteger($this->recycle_next_km->AdvancedSearch->SearchValue)) {
            $this->recycle_next_km->addErrorMessage($this->recycle_next_km->getErrorMessage(false));
        }
        if (!CheckInteger($this->puncture->AdvancedSearch->SearchValue)) {
            $this->puncture->addErrorMessage($this->puncture->getErrorMessage(false));
        }
        if (!CheckInteger($this->current_km->AdvancedSearch->SearchValue)) {
            $this->current_km->addErrorMessage($this->current_km->getErrorMessage(false));
        }
        if (!CheckInteger($this->remaining_km->AdvancedSearch->SearchValue)) {
            $this->remaining_km->addErrorMessage($this->remaining_km->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->vehicle_no->AdvancedSearch->load();
        $this->head->AdvancedSearch->load();
        $this->sub_head->AdvancedSearch->load();
        $this->s_no->AdvancedSearch->load();
        $this->km->AdvancedSearch->load();
        $this->life_km->AdvancedSearch->load();
        $this->recycle_after_km->AdvancedSearch->load();
        $this->next_km->AdvancedSearch->load();
        $this->recycle_next_km->AdvancedSearch->load();
        $this->puncture->AdvancedSearch->load();
        $this->current_km->AdvancedSearch->load();
        $this->remaining_km->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ttyreinfolist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_vehicle_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_head":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_sub_head":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
