<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for t_tyre_info
 */
class TTyreInfo extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $vehicle_no;
    public $head;
    public $sub_head;
    public $s_no;
    public $km;
    public $life_km;
    public $recycle_after_km;
    public $next_km;
    public $recycle_next_km;
    public $puncture;
    public $current_km;
    public $remaining_km;
    public $remarks;
    public $status;
    public $operator;
    public $datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "t_tyre_info";
        $this->TableName = 't_tyre_info';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "t_tyre_info";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // vehicle_no
        $this->vehicle_no = new DbField(
            $this, // Table
            'x_vehicle_no', // Variable name
            'vehicle_no', // Name
            '`vehicle_no`', // Expression
            '`vehicle_no`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->vehicle_no->addMethod("getSelectFilter", fn() => "`status`=1 and `type` =1");
        $this->vehicle_no->InputTextType = "text";
        $this->vehicle_no->Raw = true;
        $this->vehicle_no->Nullable = false; // NOT NULL field
        $this->vehicle_no->Required = true; // Required field
        $this->vehicle_no->setSelectMultiple(false); // Select one
        $this->vehicle_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->vehicle_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->vehicle_no->Lookup = new Lookup($this->vehicle_no, 'vehicle_info', false, 'id', ["no","","",""], '', '', [], [], [], [], [], [], false, '`no` ASC', '', "`no`");
        $this->vehicle_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->vehicle_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_no'] = &$this->vehicle_no;

        // head
        $this->head = new DbField(
            $this, // Table
            'x_head', // Variable name
            'head', // Name
            '`head`', // Expression
            '`head`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->head->addMethod("getSelectFilter", fn() => "`grp`=1 and status=1 and type =1 and id > 1");
        $this->head->InputTextType = "text";
        $this->head->Raw = true;
        $this->head->Nullable = false; // NOT NULL field
        $this->head->Required = true; // Required field
        $this->head->setSelectMultiple(false); // Select one
        $this->head->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->head->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->head->Lookup = new Lookup($this->head, 't_maintenance_info', false, 'id', ["item","","",""], '', '', [], ["x_sub_head"], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->head->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['head'] = &$this->head;

        // sub_head
        $this->sub_head = new DbField(
            $this, // Table
            'x_sub_head', // Variable name
            'sub_head', // Name
            '`sub_head`', // Expression
            '`sub_head`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sub_head`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->sub_head->InputTextType = "text";
        $this->sub_head->Raw = true;
        $this->sub_head->setSelectMultiple(false); // Select one
        $this->sub_head->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->sub_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->sub_head->Lookup = new Lookup($this->sub_head, 't_maintenance_info', false, 'id', ["item","","",""], '', '', ["x_head"], [], ["grp"], ["x_grp"], [], [], false, '`item` ASC', '', "`item`");
        $this->sub_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sub_head->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sub_head'] = &$this->sub_head;

        // s_no
        $this->s_no = new DbField(
            $this, // Table
            'x_s_no', // Variable name
            's_no', // Name
            '`s_no`', // Expression
            '`s_no`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->s_no->InputTextType = "text";
        $this->s_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_no'] = &$this->s_no;

        // km
        $this->km = new DbField(
            $this, // Table
            'x_km', // Variable name
            'km', // Name
            '`km`', // Expression
            '`km`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->km->InputTextType = "text";
        $this->km->Raw = true;
        $this->km->Nullable = false; // NOT NULL field
        $this->km->Required = true; // Required field
        $this->km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['km'] = &$this->km;

        // life_km
        $this->life_km = new DbField(
            $this, // Table
            'x_life_km', // Variable name
            'life_km', // Name
            '`life_km`', // Expression
            '`life_km`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`life_km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->life_km->InputTextType = "text";
        $this->life_km->Raw = true;
        $this->life_km->Nullable = false; // NOT NULL field
        $this->life_km->Required = true; // Required field
        $this->life_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->life_km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['life_km'] = &$this->life_km;

        // recycle_after_km
        $this->recycle_after_km = new DbField(
            $this, // Table
            'x_recycle_after_km', // Variable name
            'recycle_after_km', // Name
            '`recycle_after_km`', // Expression
            '`recycle_after_km`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`recycle_after_km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->recycle_after_km->addMethod("getDefault", fn() => 0);
        $this->recycle_after_km->InputTextType = "text";
        $this->recycle_after_km->Raw = true;
        $this->recycle_after_km->Nullable = false; // NOT NULL field
        $this->recycle_after_km->Required = true; // Required field
        $this->recycle_after_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->recycle_after_km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['recycle_after_km'] = &$this->recycle_after_km;

        // next_km
        $this->next_km = new DbField(
            $this, // Table
            'x_next_km', // Variable name
            'next_km', // Name
            '`next_km`', // Expression
            '`next_km`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`next_km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->next_km->InputTextType = "text";
        $this->next_km->Raw = true;
        $this->next_km->Nullable = false; // NOT NULL field
        $this->next_km->Required = true; // Required field
        $this->next_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->next_km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['next_km'] = &$this->next_km;

        // recycle_next_km
        $this->recycle_next_km = new DbField(
            $this, // Table
            'x_recycle_next_km', // Variable name
            'recycle_next_km', // Name
            '`recycle_next_km`', // Expression
            '`recycle_next_km`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`recycle_next_km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->recycle_next_km->addMethod("getDefault", fn() => 0);
        $this->recycle_next_km->InputTextType = "text";
        $this->recycle_next_km->Raw = true;
        $this->recycle_next_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->recycle_next_km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['recycle_next_km'] = &$this->recycle_next_km;

        // puncture
        $this->puncture = new DbField(
            $this, // Table
            'x_puncture', // Variable name
            'puncture', // Name
            '`puncture`', // Expression
            '`puncture`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`puncture`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->puncture->addMethod("getDefault", fn() => 0);
        $this->puncture->InputTextType = "text";
        $this->puncture->Raw = true;
        $this->puncture->Nullable = false; // NOT NULL field
        $this->puncture->Required = true; // Required field
        $this->puncture->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->puncture->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['puncture'] = &$this->puncture;

        // current_km
        $this->current_km = new DbField(
            $this, // Table
            'x_current_km', // Variable name
            'current_km', // Name
            '`current_km`', // Expression
            '`current_km`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`current_km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->current_km->InputTextType = "text";
        $this->current_km->Raw = true;
        $this->current_km->Nullable = false; // NOT NULL field
        $this->current_km->Required = true; // Required field
        $this->current_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->current_km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['current_km'] = &$this->current_km;

        // remaining_km
        $this->remaining_km = new DbField(
            $this, // Table
            'x_remaining_km', // Variable name
            'remaining_km', // Name
            '`remaining_km`', // Expression
            '`remaining_km`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remaining_km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remaining_km->InputTextType = "text";
        $this->remaining_km->Raw = true;
        $this->remaining_km->Nullable = false; // NOT NULL field
        $this->remaining_km->Required = true; // Required field
        $this->remaining_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->remaining_km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['remaining_km'] = &$this->remaining_km;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 't_tyre_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 3;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "t_tyre_info";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->vehicle_no->DbValue = $row['vehicle_no'];
        $this->head->DbValue = $row['head'];
        $this->sub_head->DbValue = $row['sub_head'];
        $this->s_no->DbValue = $row['s_no'];
        $this->km->DbValue = $row['km'];
        $this->life_km->DbValue = $row['life_km'];
        $this->recycle_after_km->DbValue = $row['recycle_after_km'];
        $this->next_km->DbValue = $row['next_km'];
        $this->recycle_next_km->DbValue = $row['recycle_next_km'];
        $this->puncture->DbValue = $row['puncture'];
        $this->current_km->DbValue = $row['current_km'];
        $this->remaining_km->DbValue = $row['remaining_km'];
        $this->remarks->DbValue = $row['remarks'];
        $this->status->DbValue = $row['status'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("ttyreinfolist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "ttyreinfoview" => $Language->phrase("View"),
            "ttyreinfoedit" => $Language->phrase("Edit"),
            "ttyreinfoadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "ttyreinfolist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "TTyreInfoView",
            Config("API_ADD_ACTION") => "TTyreInfoAdd",
            Config("API_EDIT_ACTION") => "TTyreInfoEdit",
            Config("API_DELETE_ACTION") => "TTyreInfoDelete",
            Config("API_LIST_ACTION") => "TTyreInfoList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "ttyreinfolist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ttyreinfoview", $parm);
        } else {
            $url = $this->keyUrl("ttyreinfoview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "ttyreinfoadd?" . $parm;
        } else {
            $url = "ttyreinfoadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("ttyreinfoedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("ttyreinfolist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("ttyreinfoadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("ttyreinfolist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("ttyreinfodelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->vehicle_no->setDbValue($row['vehicle_no']);
        $this->head->setDbValue($row['head']);
        $this->sub_head->setDbValue($row['sub_head']);
        $this->s_no->setDbValue($row['s_no']);
        $this->km->setDbValue($row['km']);
        $this->life_km->setDbValue($row['life_km']);
        $this->recycle_after_km->setDbValue($row['recycle_after_km']);
        $this->next_km->setDbValue($row['next_km']);
        $this->recycle_next_km->setDbValue($row['recycle_next_km']);
        $this->puncture->setDbValue($row['puncture']);
        $this->current_km->setDbValue($row['current_km']);
        $this->remaining_km->setDbValue($row['remaining_km']);
        $this->remarks->setDbValue($row['remarks']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "TTyreInfoList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // vehicle_no

        // head

        // sub_head

        // s_no

        // km

        // life_km

        // recycle_after_km

        // next_km

        // recycle_next_km

        // puncture

        // current_km

        // remaining_km

        // remarks

        // status

        // operator

        // datetime

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // vehicle_no
        $curVal = strval($this->vehicle_no->CurrentValue);
        if ($curVal != "") {
            $this->vehicle_no->ViewValue = $this->vehicle_no->lookupCacheOption($curVal);
            if ($this->vehicle_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->vehicle_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->vehicle_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->vehicle_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->vehicle_no->Lookup->renderViewRow($rswrk[0]);
                    $this->vehicle_no->ViewValue = $this->vehicle_no->displayValue($arwrk);
                } else {
                    $this->vehicle_no->ViewValue = FormatNumber($this->vehicle_no->CurrentValue, $this->vehicle_no->formatPattern());
                }
            }
        } else {
            $this->vehicle_no->ViewValue = null;
        }

        // head
        $curVal = strval($this->head->CurrentValue);
        if ($curVal != "") {
            $this->head->ViewValue = $this->head->lookupCacheOption($curVal);
            if ($this->head->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->head->getSelectFilter($this); // PHP
                $sqlWrk = $this->head->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->head->Lookup->renderViewRow($rswrk[0]);
                    $this->head->ViewValue = $this->head->displayValue($arwrk);
                } else {
                    $this->head->ViewValue = FormatNumber($this->head->CurrentValue, $this->head->formatPattern());
                }
            }
        } else {
            $this->head->ViewValue = null;
        }

        // sub_head
        $curVal = strval($this->sub_head->CurrentValue);
        if ($curVal != "") {
            $this->sub_head->ViewValue = $this->sub_head->lookupCacheOption($curVal);
            if ($this->sub_head->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->sub_head->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->sub_head->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->sub_head->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sub_head->Lookup->renderViewRow($rswrk[0]);
                    $this->sub_head->ViewValue = $this->sub_head->displayValue($arwrk);
                } else {
                    $this->sub_head->ViewValue = FormatNumber($this->sub_head->CurrentValue, $this->sub_head->formatPattern());
                }
            }
        } else {
            $this->sub_head->ViewValue = null;
        }

        // s_no
        $this->s_no->ViewValue = $this->s_no->CurrentValue;

        // km
        $this->km->ViewValue = $this->km->CurrentValue;
        $this->km->ViewValue = FormatNumber($this->km->ViewValue, $this->km->formatPattern());

        // life_km
        $this->life_km->ViewValue = $this->life_km->CurrentValue;
        $this->life_km->ViewValue = FormatNumber($this->life_km->ViewValue, $this->life_km->formatPattern());

        // recycle_after_km
        $this->recycle_after_km->ViewValue = $this->recycle_after_km->CurrentValue;
        $this->recycle_after_km->ViewValue = FormatNumber($this->recycle_after_km->ViewValue, $this->recycle_after_km->formatPattern());

        // next_km
        $this->next_km->ViewValue = $this->next_km->CurrentValue;
        $this->next_km->ViewValue = FormatNumber($this->next_km->ViewValue, $this->next_km->formatPattern());

        // recycle_next_km
        $this->recycle_next_km->ViewValue = $this->recycle_next_km->CurrentValue;
        $this->recycle_next_km->ViewValue = FormatNumber($this->recycle_next_km->ViewValue, $this->recycle_next_km->formatPattern());

        // puncture
        $this->puncture->ViewValue = $this->puncture->CurrentValue;
        $this->puncture->ViewValue = FormatNumber($this->puncture->ViewValue, $this->puncture->formatPattern());

        // current_km
        $this->current_km->ViewValue = $this->current_km->CurrentValue;
        $this->current_km->ViewValue = FormatNumber($this->current_km->ViewValue, $this->current_km->formatPattern());

        // remaining_km
        $this->remaining_km->ViewValue = $this->remaining_km->CurrentValue;
        $this->remaining_km->ViewValue = FormatNumber($this->remaining_km->ViewValue, $this->remaining_km->formatPattern());

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // vehicle_no
        $this->vehicle_no->HrefValue = "";
        $this->vehicle_no->TooltipValue = "";

        // head
        $this->head->HrefValue = "";
        $this->head->TooltipValue = "";

        // sub_head
        $this->sub_head->HrefValue = "";
        $this->sub_head->TooltipValue = "";

        // s_no
        $this->s_no->HrefValue = "";
        $this->s_no->TooltipValue = "";

        // km
        $this->km->HrefValue = "";
        $this->km->TooltipValue = "";

        // life_km
        $this->life_km->HrefValue = "";
        $this->life_km->TooltipValue = "";

        // recycle_after_km
        $this->recycle_after_km->HrefValue = "";
        $this->recycle_after_km->TooltipValue = "";

        // next_km
        $this->next_km->HrefValue = "";
        $this->next_km->TooltipValue = "";

        // recycle_next_km
        $this->recycle_next_km->HrefValue = "";
        $this->recycle_next_km->TooltipValue = "";

        // puncture
        $this->puncture->HrefValue = "";
        $this->puncture->TooltipValue = "";

        // current_km
        $this->current_km->HrefValue = "";
        $this->current_km->TooltipValue = "";

        // remaining_km
        $this->remaining_km->HrefValue = "";
        $this->remaining_km->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->EditValue = FormatNumber($this->id->EditValue, $this->id->formatPattern());

        // vehicle_no
        $this->vehicle_no->setupEditAttributes();
        $this->vehicle_no->PlaceHolder = RemoveHtml($this->vehicle_no->caption());

        // head
        $this->head->setupEditAttributes();
        $this->head->PlaceHolder = RemoveHtml($this->head->caption());

        // sub_head
        $this->sub_head->setupEditAttributes();
        $this->sub_head->PlaceHolder = RemoveHtml($this->sub_head->caption());

        // s_no
        $this->s_no->setupEditAttributes();
        if (!$this->s_no->Raw) {
            $this->s_no->CurrentValue = HtmlDecode($this->s_no->CurrentValue);
        }
        $this->s_no->EditValue = $this->s_no->CurrentValue;
        $this->s_no->PlaceHolder = RemoveHtml($this->s_no->caption());

        // km
        $this->km->setupEditAttributes();
        $this->km->EditValue = $this->km->CurrentValue;
        $this->km->PlaceHolder = RemoveHtml($this->km->caption());
        if (strval($this->km->EditValue) != "" && is_numeric($this->km->EditValue)) {
            $this->km->EditValue = FormatNumber($this->km->EditValue, null);
        }

        // life_km
        $this->life_km->setupEditAttributes();
        $this->life_km->EditValue = $this->life_km->CurrentValue;
        $this->life_km->PlaceHolder = RemoveHtml($this->life_km->caption());
        if (strval($this->life_km->EditValue) != "" && is_numeric($this->life_km->EditValue)) {
            $this->life_km->EditValue = FormatNumber($this->life_km->EditValue, null);
        }

        // recycle_after_km
        $this->recycle_after_km->setupEditAttributes();
        $this->recycle_after_km->EditValue = $this->recycle_after_km->CurrentValue;
        $this->recycle_after_km->PlaceHolder = RemoveHtml($this->recycle_after_km->caption());
        if (strval($this->recycle_after_km->EditValue) != "" && is_numeric($this->recycle_after_km->EditValue)) {
            $this->recycle_after_km->EditValue = FormatNumber($this->recycle_after_km->EditValue, null);
        }

        // next_km
        $this->next_km->setupEditAttributes();
        $this->next_km->EditValue = $this->next_km->CurrentValue;
        $this->next_km->EditValue = FormatNumber($this->next_km->EditValue, $this->next_km->formatPattern());

        // recycle_next_km
        $this->recycle_next_km->setupEditAttributes();
        $this->recycle_next_km->EditValue = $this->recycle_next_km->CurrentValue;
        $this->recycle_next_km->EditValue = FormatNumber($this->recycle_next_km->EditValue, $this->recycle_next_km->formatPattern());

        // puncture
        $this->puncture->setupEditAttributes();
        $this->puncture->EditValue = $this->puncture->CurrentValue;
        $this->puncture->EditValue = FormatNumber($this->puncture->EditValue, $this->puncture->formatPattern());

        // current_km
        $this->current_km->setupEditAttributes();
        $this->current_km->EditValue = $this->current_km->CurrentValue;
        $this->current_km->PlaceHolder = RemoveHtml($this->current_km->caption());
        if (strval($this->current_km->EditValue) != "" && is_numeric($this->current_km->EditValue)) {
            $this->current_km->EditValue = FormatNumber($this->current_km->EditValue, null);
        }

        // remaining_km
        $this->remaining_km->setupEditAttributes();
        $this->remaining_km->EditValue = $this->remaining_km->CurrentValue;
        $this->remaining_km->PlaceHolder = RemoveHtml($this->remaining_km->caption());
        if (strval($this->remaining_km->EditValue) != "" && is_numeric($this->remaining_km->EditValue)) {
            $this->remaining_km->EditValue = FormatNumber($this->remaining_km->EditValue, null);
        }

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // operator

        // datetime

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->vehicle_no);
                    $doc->exportCaption($this->head);
                    $doc->exportCaption($this->sub_head);
                    $doc->exportCaption($this->s_no);
                    $doc->exportCaption($this->km);
                    $doc->exportCaption($this->life_km);
                    $doc->exportCaption($this->recycle_after_km);
                    $doc->exportCaption($this->next_km);
                    $doc->exportCaption($this->recycle_next_km);
                    $doc->exportCaption($this->puncture);
                    $doc->exportCaption($this->current_km);
                    $doc->exportCaption($this->remaining_km);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->vehicle_no);
                    $doc->exportCaption($this->head);
                    $doc->exportCaption($this->sub_head);
                    $doc->exportCaption($this->s_no);
                    $doc->exportCaption($this->km);
                    $doc->exportCaption($this->life_km);
                    $doc->exportCaption($this->recycle_after_km);
                    $doc->exportCaption($this->next_km);
                    $doc->exportCaption($this->recycle_next_km);
                    $doc->exportCaption($this->puncture);
                    $doc->exportCaption($this->current_km);
                    $doc->exportCaption($this->remaining_km);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->vehicle_no);
                        $doc->exportField($this->head);
                        $doc->exportField($this->sub_head);
                        $doc->exportField($this->s_no);
                        $doc->exportField($this->km);
                        $doc->exportField($this->life_km);
                        $doc->exportField($this->recycle_after_km);
                        $doc->exportField($this->next_km);
                        $doc->exportField($this->recycle_next_km);
                        $doc->exportField($this->puncture);
                        $doc->exportField($this->current_km);
                        $doc->exportField($this->remaining_km);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->vehicle_no);
                        $doc->exportField($this->head);
                        $doc->exportField($this->sub_head);
                        $doc->exportField($this->s_no);
                        $doc->exportField($this->km);
                        $doc->exportField($this->life_km);
                        $doc->exportField($this->recycle_after_km);
                        $doc->exportField($this->next_km);
                        $doc->exportField($this->recycle_next_km);
                        $doc->exportField($this->puncture);
                        $doc->exportField($this->current_km);
                        $doc->exportField($this->remaining_km);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
