<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TTripStartSearch extends TTripStart
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TTripStartSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "ttripstartsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->vehicle_type->setVisibility();
        $this->vehicle->setVisibility();
        $this->_route->setVisibility();
        $this->reports_to->setVisibility();
        $this->vehicle_freight_type->setVisibility();
        $this->vehicle_freight_amount->setVisibility();
        $this->material->setVisibility();
        $this->_40->setVisibility();
        $this->buyer->setVisibility();
        $this->agent->setVisibility();
        $this->comm->setVisibility();
        $this->load_date->setVisibility();
        $this->load_weight->setVisibility();
        $this->load_km->setVisibility();
        $this->gst_percent->setVisibility();
        $this->driver->setVisibility();
        $this->remarks->setVisibility();
        $this->vehicle_freight_comm->setVisibility();
        $this->freight_type->setVisibility();
        $this->freight->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 't_trip_start';
        $this->TableName = 't_trip_start';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (t_trip_start)
        if (!isset($GLOBALS["t_trip_start"]) || $GLOBALS["t_trip_start"]::class == PROJECT_NAMESPACE . "t_trip_start") {
            $GLOBALS["t_trip_start"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_start');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "ttripstartview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->vehicle_type);
        $this->setupLookupOptions($this->vehicle);
        $this->setupLookupOptions($this->_route);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->vehicle_freight_type);
        $this->setupLookupOptions($this->buyer);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->freight_type);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "ttripstartlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->vehicle_type); // vehicle_type
        $this->buildSearchUrl($srchUrl, $this->vehicle); // vehicle
        $this->buildSearchUrl($srchUrl, $this->_route); // route
        $this->buildSearchUrl($srchUrl, $this->reports_to); // reports_to
        $this->buildSearchUrl($srchUrl, $this->vehicle_freight_type); // vehicle_freight_type
        $this->buildSearchUrl($srchUrl, $this->vehicle_freight_amount); // vehicle_freight_amount
        $this->buildSearchUrl($srchUrl, $this->material); // material
        $this->buildSearchUrl($srchUrl, $this->_40); // @
        $this->buildSearchUrl($srchUrl, $this->buyer); // buyer
        $this->buildSearchUrl($srchUrl, $this->agent); // agent
        $this->buildSearchUrl($srchUrl, $this->comm); // comm
        $this->buildSearchUrl($srchUrl, $this->load_date); // load_date
        $this->buildSearchUrl($srchUrl, $this->load_weight); // load_weight
        $this->buildSearchUrl($srchUrl, $this->load_km); // load_km
        $this->buildSearchUrl($srchUrl, $this->gst_percent); // gst_percent
        $this->buildSearchUrl($srchUrl, $this->driver); // driver
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->vehicle_freight_comm); // vehicle_freight_comm
        $this->buildSearchUrl($srchUrl, $this->freight_type); // freight_type
        $this->buildSearchUrl($srchUrl, $this->freight); // freight
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_type
        if ($this->vehicle_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle
        if ($this->vehicle->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // route
        if ($this->_route->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reports_to
        if ($this->reports_to->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_freight_type
        if ($this->vehicle_freight_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_freight_amount
        if ($this->vehicle_freight_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // material
        if ($this->material->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // @
        if ($this->_40->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer
        if ($this->buyer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // agent
        if ($this->agent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // comm
        if ($this->comm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // load_date
        if ($this->load_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // load_weight
        if ($this->load_weight->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // load_km
        if ($this->load_km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gst_percent
        if ($this->gst_percent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // driver
        if ($this->driver->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_freight_comm
        if ($this->vehicle_freight_comm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // freight_type
        if ($this->freight_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // freight
        if ($this->freight->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // vehicle_type
        $this->vehicle_type->RowCssClass = "row";

        // vehicle
        $this->vehicle->RowCssClass = "row";

        // route
        $this->_route->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // vehicle_freight_type
        $this->vehicle_freight_type->RowCssClass = "row";

        // vehicle_freight_amount
        $this->vehicle_freight_amount->RowCssClass = "row";

        // material
        $this->material->RowCssClass = "row";

        // @
        $this->_40->RowCssClass = "row";

        // buyer
        $this->buyer->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // comm
        $this->comm->RowCssClass = "row";

        // load_date
        $this->load_date->RowCssClass = "row";

        // load_weight
        $this->load_weight->RowCssClass = "row";

        // load_km
        $this->load_km->RowCssClass = "row";

        // gst_percent
        $this->gst_percent->RowCssClass = "row";

        // driver
        $this->driver->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // vehicle_freight_comm
        $this->vehicle_freight_comm->RowCssClass = "row";

        // freight_type
        $this->freight_type->RowCssClass = "row";

        // freight
        $this->freight->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // vehicle_type
            if (strval($this->vehicle_type->CurrentValue) != "") {
                $this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
            } else {
                $this->vehicle_type->ViewValue = null;
            }

            // vehicle
            $this->vehicle->ViewValue = $this->vehicle->CurrentValue;
            $curVal = strval($this->vehicle->CurrentValue);
            if ($curVal != "") {
                $this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
                if ($this->vehicle->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
                    } else {
                        $this->vehicle->ViewValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                    }
                }
            } else {
                $this->vehicle->ViewValue = null;
            }

            // route
            $this->_route->ViewValue = $this->_route->CurrentValue;
            $curVal = strval($this->_route->CurrentValue);
            if ($curVal != "") {
                $this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
                if ($this->_route->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                        $this->_route->ViewValue = $this->_route->displayValue($arwrk);
                    } else {
                        $this->_route->ViewValue = FormatNumber($this->_route->CurrentValue, $this->_route->formatPattern());
                    }
                }
            } else {
                $this->_route->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // vehicle_freight_type
            if (strval($this->vehicle_freight_type->CurrentValue) != "") {
                $this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
            } else {
                $this->vehicle_freight_type->ViewValue = null;
            }

            // vehicle_freight_amount
            $this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
            $this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, $this->vehicle_freight_amount->formatPattern());

            // material
            $this->material->ViewValue = $this->material->CurrentValue;

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;
            $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

            // buyer
            $this->buyer->ViewValue = $this->buyer->CurrentValue;
            $curVal = strval($this->buyer->CurrentValue);
            if ($curVal != "") {
                $this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->ViewValue = FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern());
                    }
                }
            } else {
                $this->buyer->ViewValue = null;
            }

            // agent
            $this->agent->ViewValue = $this->agent->CurrentValue;
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern());
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // comm
            $this->comm->ViewValue = $this->comm->CurrentValue;
            $this->comm->ViewValue = FormatNumber($this->comm->ViewValue, $this->comm->formatPattern());

            // load_date
            $this->load_date->ViewValue = $this->load_date->CurrentValue;
            $this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, $this->load_date->formatPattern());

            // load_weight
            $this->load_weight->ViewValue = $this->load_weight->CurrentValue;
            $this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, $this->load_weight->formatPattern());

            // load_km
            $this->load_km->ViewValue = $this->load_km->CurrentValue;
            $this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, $this->load_km->formatPattern());

            // gst_percent
            $this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
            $this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, $this->gst_percent->formatPattern());

            // driver
            $this->driver->ViewValue = $this->driver->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // vehicle_freight_comm
            $this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
            $this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, $this->vehicle_freight_comm->formatPattern());

            // freight_type
            if (strval($this->freight_type->CurrentValue) != "") {
                $this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
            } else {
                $this->freight_type->ViewValue = null;
            }

            // freight
            $this->freight->ViewValue = $this->freight->CurrentValue;
            $this->freight->ViewValue = FormatNumber($this->freight->ViewValue, $this->freight->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // vehicle_type
            $this->vehicle_type->HrefValue = "";
            $this->vehicle_type->TooltipValue = "";

            // vehicle
            $this->vehicle->HrefValue = "";
            $this->vehicle->TooltipValue = "";

            // route
            $this->_route->HrefValue = "";
            $this->_route->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // vehicle_freight_type
            $this->vehicle_freight_type->HrefValue = "";
            $this->vehicle_freight_type->TooltipValue = "";

            // vehicle_freight_amount
            $this->vehicle_freight_amount->HrefValue = "";
            $this->vehicle_freight_amount->TooltipValue = "";

            // material
            $this->material->HrefValue = "";
            $this->material->TooltipValue = "";

            // @
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // buyer
            $this->buyer->HrefValue = "";
            $this->buyer->TooltipValue = "";

            // agent
            $this->agent->HrefValue = "";
            $this->agent->TooltipValue = "";

            // comm
            $this->comm->HrefValue = "";
            $this->comm->TooltipValue = "";

            // load_date
            $this->load_date->HrefValue = "";
            $this->load_date->TooltipValue = "";

            // load_weight
            $this->load_weight->HrefValue = "";
            $this->load_weight->TooltipValue = "";

            // load_km
            $this->load_km->HrefValue = "";
            $this->load_km->TooltipValue = "";

            // gst_percent
            $this->gst_percent->HrefValue = "";
            $this->gst_percent->TooltipValue = "";

            // driver
            $this->driver->HrefValue = "";
            $this->driver->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // vehicle_freight_comm
            $this->vehicle_freight_comm->HrefValue = "";
            $this->vehicle_freight_comm->TooltipValue = "";

            // freight_type
            $this->freight_type->HrefValue = "";
            $this->freight_type->TooltipValue = "";

            // freight
            $this->freight->HrefValue = "";
            $this->freight->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // vehicle_type
            $this->vehicle_type->setupEditAttributes();
            $this->vehicle_type->EditValue = $this->vehicle_type->options(true);
            $this->vehicle_type->PlaceHolder = RemoveHtml($this->vehicle_type->caption());

            // vehicle
            $this->vehicle->setupEditAttributes();
            $this->vehicle->EditValue = $this->vehicle->AdvancedSearch->SearchValue;
            $curVal = strval($this->vehicle->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
                if ($this->vehicle->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
                    } else {
                        $this->vehicle->EditValue = HtmlEncode(FormatNumber($this->vehicle->AdvancedSearch->SearchValue, $this->vehicle->formatPattern()));
                    }
                }
            } else {
                $this->vehicle->EditValue = null;
            }
            $this->vehicle->PlaceHolder = RemoveHtml($this->vehicle->caption());

            // route
            $this->_route->setupEditAttributes();
            $this->_route->EditValue = $this->_route->AdvancedSearch->SearchValue;
            $curVal = strval($this->_route->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->_route->EditValue = $this->_route->lookupCacheOption($curVal);
                if ($this->_route->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                        $this->_route->EditValue = $this->_route->displayValue($arwrk);
                    } else {
                        $this->_route->EditValue = HtmlEncode(FormatNumber($this->_route->AdvancedSearch->SearchValue, $this->_route->formatPattern()));
                    }
                }
            } else {
                $this->_route->EditValue = null;
            }
            $this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->AdvancedSearch->SearchValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // vehicle_freight_type
            $this->vehicle_freight_type->setupEditAttributes();
            $this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(true);
            $this->vehicle_freight_type->PlaceHolder = RemoveHtml($this->vehicle_freight_type->caption());

            // vehicle_freight_amount
            $this->vehicle_freight_amount->setupEditAttributes();
            $this->vehicle_freight_amount->EditValue = $this->vehicle_freight_amount->AdvancedSearch->SearchValue;
            $this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());

            // material
            $this->material->setupEditAttributes();
            if (!$this->material->Raw) {
                $this->material->AdvancedSearch->SearchValue = HtmlDecode($this->material->AdvancedSearch->SearchValue);
            }
            $this->material->EditValue = HtmlEncode($this->material->AdvancedSearch->SearchValue);
            $this->material->PlaceHolder = RemoveHtml($this->material->caption());

            // @
            $this->_40->setupEditAttributes();
            $this->_40->EditValue = $this->_40->AdvancedSearch->SearchValue;
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

            // buyer
            $this->buyer->setupEditAttributes();
            $this->buyer->EditValue = $this->buyer->AdvancedSearch->SearchValue;
            $curVal = strval($this->buyer->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->EditValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->EditValue = HtmlEncode(FormatNumber($this->buyer->AdvancedSearch->SearchValue, $this->buyer->formatPattern()));
                    }
                }
            } else {
                $this->buyer->EditValue = null;
            }
            $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

            // agent
            $this->agent->setupEditAttributes();
            $this->agent->EditValue = $this->agent->AdvancedSearch->SearchValue;
            $curVal = strval($this->agent->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->agent->EditValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->EditValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->EditValue = HtmlEncode(FormatNumber($this->agent->AdvancedSearch->SearchValue, $this->agent->formatPattern()));
                    }
                }
            } else {
                $this->agent->EditValue = null;
            }
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // comm
            $this->comm->setupEditAttributes();
            $this->comm->EditValue = $this->comm->AdvancedSearch->SearchValue;
            $this->comm->PlaceHolder = RemoveHtml($this->comm->caption());

            // load_date
            $this->load_date->setupEditAttributes();
            $this->load_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->load_date->AdvancedSearch->SearchValue, $this->load_date->formatPattern()), $this->load_date->formatPattern()));
            $this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

            // load_weight
            $this->load_weight->setupEditAttributes();
            $this->load_weight->EditValue = $this->load_weight->AdvancedSearch->SearchValue;
            $this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());

            // load_km
            $this->load_km->setupEditAttributes();
            $this->load_km->EditValue = $this->load_km->AdvancedSearch->SearchValue;
            $this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());

            // gst_percent
            $this->gst_percent->setupEditAttributes();
            $this->gst_percent->EditValue = $this->gst_percent->AdvancedSearch->SearchValue;
            $this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());

            // driver
            $this->driver->setupEditAttributes();
            $this->driver->EditCustomAttributes = $this->driver->getEditCustomAttributes(); // PHP
            $this->driver->EditValue = $this->driver->AdvancedSearch->SearchValue;
            $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // vehicle_freight_comm
            $this->vehicle_freight_comm->setupEditAttributes();
            $this->vehicle_freight_comm->EditValue = $this->vehicle_freight_comm->AdvancedSearch->SearchValue;
            $this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());

            // freight_type
            $this->freight_type->setupEditAttributes();
            $this->freight_type->EditValue = $this->freight_type->options(true);
            $this->freight_type->PlaceHolder = RemoveHtml($this->freight_type->caption());

            // freight
            $this->freight->setupEditAttributes();
            $this->freight->EditValue = $this->freight->AdvancedSearch->SearchValue;
            $this->freight->PlaceHolder = RemoveHtml($this->freight->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->vehicle->AdvancedSearch->SearchValue)) {
            $this->vehicle->addErrorMessage($this->vehicle->getErrorMessage(false));
        }
        if (!CheckInteger($this->_route->AdvancedSearch->SearchValue)) {
            $this->_route->addErrorMessage($this->_route->getErrorMessage(false));
        }
        if (!CheckNumber($this->vehicle_freight_amount->AdvancedSearch->SearchValue)) {
            $this->vehicle_freight_amount->addErrorMessage($this->vehicle_freight_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->_40->AdvancedSearch->SearchValue)) {
            $this->_40->addErrorMessage($this->_40->getErrorMessage(false));
        }
        if (!CheckInteger($this->buyer->AdvancedSearch->SearchValue)) {
            $this->buyer->addErrorMessage($this->buyer->getErrorMessage(false));
        }
        if (!CheckInteger($this->agent->AdvancedSearch->SearchValue)) {
            $this->agent->addErrorMessage($this->agent->getErrorMessage(false));
        }
        if (!CheckNumber($this->comm->AdvancedSearch->SearchValue)) {
            $this->comm->addErrorMessage($this->comm->getErrorMessage(false));
        }
        if (!CheckDate($this->load_date->AdvancedSearch->SearchValue, $this->load_date->formatPattern())) {
            $this->load_date->addErrorMessage($this->load_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->load_weight->AdvancedSearch->SearchValue)) {
            $this->load_weight->addErrorMessage($this->load_weight->getErrorMessage(false));
        }
        if (!CheckInteger($this->load_km->AdvancedSearch->SearchValue)) {
            $this->load_km->addErrorMessage($this->load_km->getErrorMessage(false));
        }
        if (!CheckNumber($this->gst_percent->AdvancedSearch->SearchValue)) {
            $this->gst_percent->addErrorMessage($this->gst_percent->getErrorMessage(false));
        }
        if (!CheckNumber($this->vehicle_freight_comm->AdvancedSearch->SearchValue)) {
            $this->vehicle_freight_comm->addErrorMessage($this->vehicle_freight_comm->getErrorMessage(false));
        }
        if (!CheckNumber($this->freight->AdvancedSearch->SearchValue)) {
            $this->freight->addErrorMessage($this->freight->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->vehicle_type->AdvancedSearch->load();
        $this->vehicle->AdvancedSearch->load();
        $this->_route->AdvancedSearch->load();
        $this->reports_to->AdvancedSearch->load();
        $this->vehicle_freight_type->AdvancedSearch->load();
        $this->vehicle_freight_amount->AdvancedSearch->load();
        $this->material->AdvancedSearch->load();
        $this->_40->AdvancedSearch->load();
        $this->buyer->AdvancedSearch->load();
        $this->agent->AdvancedSearch->load();
        $this->comm->AdvancedSearch->load();
        $this->load_date->AdvancedSearch->load();
        $this->load_weight->AdvancedSearch->load();
        $this->load_km->AdvancedSearch->load();
        $this->gst_percent->AdvancedSearch->load();
        $this->driver->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->vehicle_freight_comm->AdvancedSearch->load();
        $this->freight_type->AdvancedSearch->load();
        $this->freight->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ttripstartlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_vehicle_type":
                    break;
                case "x_vehicle":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__route":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_vehicle_freight_type":
                    break;
                case "x_buyer":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_freight_type":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
