<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TTripStartEdit extends TTripStart
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TTripStartEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "ttripstartedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->vehicle_type->setVisibility();
        $this->vehicle->setVisibility();
        $this->_route->setVisibility();
        $this->reports_to->setVisibility();
        $this->vehicle_freight_type->setVisibility();
        $this->vehicle_freight_amount->setVisibility();
        $this->material->setVisibility();
        $this->_40->setVisibility();
        $this->buyer->setVisibility();
        $this->agent->setVisibility();
        $this->comm->setVisibility();
        $this->load_date->setVisibility();
        $this->load_weight->setVisibility();
        $this->load_km->setVisibility();
        $this->gst_percent->setVisibility();
        $this->driver->setVisibility();
        $this->remarks->setVisibility();
        $this->vehicle_freight_comm->setVisibility();
        $this->freight_type->setVisibility();
        $this->freight->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 't_trip_start';
        $this->TableName = 't_trip_start';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (t_trip_start)
        if (!isset($GLOBALS["t_trip_start"]) || $GLOBALS["t_trip_start"]::class == PROJECT_NAMESPACE . "t_trip_start") {
            $GLOBALS["t_trip_start"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_start');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "ttripstartview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->vehicle->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->vehicle_type);
        $this->setupLookupOptions($this->vehicle);
        $this->setupLookupOptions($this->_route);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->vehicle_freight_type);
        $this->setupLookupOptions($this->buyer);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->freight_type);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("ttripstartlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "ttripstartlist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "ttripstartlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "ttripstartlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'vehicle_type' first before field var 'x_vehicle_type'
        $val = $CurrentForm->hasValue("vehicle_type") ? $CurrentForm->getValue("vehicle_type") : $CurrentForm->getValue("x_vehicle_type");
        if (!$this->vehicle_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_type->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_type->setFormValue($val);
            }
        }

        // Check field name 'vehicle' first before field var 'x_vehicle'
        $val = $CurrentForm->hasValue("vehicle") ? $CurrentForm->getValue("vehicle") : $CurrentForm->getValue("x_vehicle");
        if (!$this->vehicle->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle->Visible = false; // Disable update for API request
            } else {
                $this->vehicle->setFormValue($val);
            }
        }

        // Check field name 'route' first before field var 'x__route'
        $val = $CurrentForm->hasValue("route") ? $CurrentForm->getValue("route") : $CurrentForm->getValue("x__route");
        if (!$this->_route->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_route->Visible = false; // Disable update for API request
            } else {
                $this->_route->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'reports_to' first before field var 'x_reports_to'
        $val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
        if (!$this->reports_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reports_to->Visible = false; // Disable update for API request
            } else {
                $this->reports_to->setFormValue($val);
            }
        }

        // Check field name 'vehicle_freight_type' first before field var 'x_vehicle_freight_type'
        $val = $CurrentForm->hasValue("vehicle_freight_type") ? $CurrentForm->getValue("vehicle_freight_type") : $CurrentForm->getValue("x_vehicle_freight_type");
        if (!$this->vehicle_freight_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_freight_type->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_freight_type->setFormValue($val);
            }
        }

        // Check field name 'vehicle_freight_amount' first before field var 'x_vehicle_freight_amount'
        $val = $CurrentForm->hasValue("vehicle_freight_amount") ? $CurrentForm->getValue("vehicle_freight_amount") : $CurrentForm->getValue("x_vehicle_freight_amount");
        if (!$this->vehicle_freight_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_freight_amount->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_freight_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'material' first before field var 'x_material'
        $val = $CurrentForm->hasValue("material") ? $CurrentForm->getValue("material") : $CurrentForm->getValue("x_material");
        if (!$this->material->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->material->Visible = false; // Disable update for API request
            } else {
                $this->material->setFormValue($val);
            }
        }

        // Check field name '@' first before field var 'x__40'
        $val = $CurrentForm->hasValue("@") ? $CurrentForm->getValue("@") : $CurrentForm->getValue("x__40");
        if (!$this->_40->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_40->Visible = false; // Disable update for API request
            } else {
                $this->_40->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'buyer' first before field var 'x_buyer'
        $val = $CurrentForm->hasValue("buyer") ? $CurrentForm->getValue("buyer") : $CurrentForm->getValue("x_buyer");
        if (!$this->buyer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer->Visible = false; // Disable update for API request
            } else {
                $this->buyer->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'agent' first before field var 'x_agent'
        $val = $CurrentForm->hasValue("agent") ? $CurrentForm->getValue("agent") : $CurrentForm->getValue("x_agent");
        if (!$this->agent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->agent->Visible = false; // Disable update for API request
            } else {
                $this->agent->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'comm' first before field var 'x_comm'
        $val = $CurrentForm->hasValue("comm") ? $CurrentForm->getValue("comm") : $CurrentForm->getValue("x_comm");
        if (!$this->comm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->comm->Visible = false; // Disable update for API request
            } else {
                $this->comm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'load_date' first before field var 'x_load_date'
        $val = $CurrentForm->hasValue("load_date") ? $CurrentForm->getValue("load_date") : $CurrentForm->getValue("x_load_date");
        if (!$this->load_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_date->Visible = false; // Disable update for API request
            } else {
                $this->load_date->setFormValue($val, true, $validate);
            }
            $this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern());
        }

        // Check field name 'load_weight' first before field var 'x_load_weight'
        $val = $CurrentForm->hasValue("load_weight") ? $CurrentForm->getValue("load_weight") : $CurrentForm->getValue("x_load_weight");
        if (!$this->load_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_weight->Visible = false; // Disable update for API request
            } else {
                $this->load_weight->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'load_km' first before field var 'x_load_km'
        $val = $CurrentForm->hasValue("load_km") ? $CurrentForm->getValue("load_km") : $CurrentForm->getValue("x_load_km");
        if (!$this->load_km->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_km->Visible = false; // Disable update for API request
            } else {
                $this->load_km->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'gst_percent' first before field var 'x_gst_percent'
        $val = $CurrentForm->hasValue("gst_percent") ? $CurrentForm->getValue("gst_percent") : $CurrentForm->getValue("x_gst_percent");
        if (!$this->gst_percent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gst_percent->Visible = false; // Disable update for API request
            } else {
                $this->gst_percent->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'driver' first before field var 'x_driver'
        $val = $CurrentForm->hasValue("driver") ? $CurrentForm->getValue("driver") : $CurrentForm->getValue("x_driver");
        if (!$this->driver->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->driver->Visible = false; // Disable update for API request
            } else {
                $this->driver->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'vehicle_freight_comm' first before field var 'x_vehicle_freight_comm'
        $val = $CurrentForm->hasValue("vehicle_freight_comm") ? $CurrentForm->getValue("vehicle_freight_comm") : $CurrentForm->getValue("x_vehicle_freight_comm");
        if (!$this->vehicle_freight_comm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_freight_comm->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_freight_comm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'freight_type' first before field var 'x_freight_type'
        $val = $CurrentForm->hasValue("freight_type") ? $CurrentForm->getValue("freight_type") : $CurrentForm->getValue("x_freight_type");
        if (!$this->freight_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->freight_type->Visible = false; // Disable update for API request
            } else {
                $this->freight_type->setFormValue($val);
            }
        }

        // Check field name 'freight' first before field var 'x_freight'
        $val = $CurrentForm->hasValue("freight") ? $CurrentForm->getValue("freight") : $CurrentForm->getValue("x_freight");
        if (!$this->freight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->freight->Visible = false; // Disable update for API request
            } else {
                $this->freight->setFormValue($val, true, $validate);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->vehicle_type->CurrentValue = $this->vehicle_type->FormValue;
        $this->vehicle->CurrentValue = $this->vehicle->FormValue;
        $this->_route->CurrentValue = $this->_route->FormValue;
        $this->reports_to->CurrentValue = $this->reports_to->FormValue;
        $this->vehicle_freight_type->CurrentValue = $this->vehicle_freight_type->FormValue;
        $this->vehicle_freight_amount->CurrentValue = $this->vehicle_freight_amount->FormValue;
        $this->material->CurrentValue = $this->material->FormValue;
        $this->_40->CurrentValue = $this->_40->FormValue;
        $this->buyer->CurrentValue = $this->buyer->FormValue;
        $this->agent->CurrentValue = $this->agent->FormValue;
        $this->comm->CurrentValue = $this->comm->FormValue;
        $this->load_date->CurrentValue = $this->load_date->FormValue;
        $this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern());
        $this->load_weight->CurrentValue = $this->load_weight->FormValue;
        $this->load_km->CurrentValue = $this->load_km->FormValue;
        $this->gst_percent->CurrentValue = $this->gst_percent->FormValue;
        $this->driver->CurrentValue = $this->driver->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->vehicle_freight_comm->CurrentValue = $this->vehicle_freight_comm->FormValue;
        $this->freight_type->CurrentValue = $this->freight_type->FormValue;
        $this->freight->CurrentValue = $this->freight->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->vehicle_type->setDbValue($row['vehicle_type']);
        $this->vehicle->setDbValue($row['vehicle']);
        $this->_route->setDbValue($row['route']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->vehicle_freight_type->setDbValue($row['vehicle_freight_type']);
        $this->vehicle_freight_amount->setDbValue($row['vehicle_freight_amount']);
        $this->material->setDbValue($row['material']);
        $this->_40->setDbValue($row['@']);
        $this->buyer->setDbValue($row['buyer']);
        $this->agent->setDbValue($row['agent']);
        $this->comm->setDbValue($row['comm']);
        $this->load_date->setDbValue($row['load_date']);
        $this->load_weight->setDbValue($row['load_weight']);
        $this->load_km->setDbValue($row['load_km']);
        $this->gst_percent->setDbValue($row['gst_percent']);
        $this->driver->setDbValue($row['driver']);
        $this->remarks->setDbValue($row['remarks']);
        $this->vehicle_freight_comm->setDbValue($row['vehicle_freight_comm']);
        $this->freight_type->setDbValue($row['freight_type']);
        $this->freight->setDbValue($row['freight']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['vehicle_type'] = $this->vehicle_type->DefaultValue;
        $row['vehicle'] = $this->vehicle->DefaultValue;
        $row['route'] = $this->_route->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['vehicle_freight_type'] = $this->vehicle_freight_type->DefaultValue;
        $row['vehicle_freight_amount'] = $this->vehicle_freight_amount->DefaultValue;
        $row['material'] = $this->material->DefaultValue;
        $row['@'] = $this->_40->DefaultValue;
        $row['buyer'] = $this->buyer->DefaultValue;
        $row['agent'] = $this->agent->DefaultValue;
        $row['comm'] = $this->comm->DefaultValue;
        $row['load_date'] = $this->load_date->DefaultValue;
        $row['load_weight'] = $this->load_weight->DefaultValue;
        $row['load_km'] = $this->load_km->DefaultValue;
        $row['gst_percent'] = $this->gst_percent->DefaultValue;
        $row['driver'] = $this->driver->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['vehicle_freight_comm'] = $this->vehicle_freight_comm->DefaultValue;
        $row['freight_type'] = $this->freight_type->DefaultValue;
        $row['freight'] = $this->freight->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // vehicle_type
        $this->vehicle_type->RowCssClass = "row";

        // vehicle
        $this->vehicle->RowCssClass = "row";

        // route
        $this->_route->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // vehicle_freight_type
        $this->vehicle_freight_type->RowCssClass = "row";

        // vehicle_freight_amount
        $this->vehicle_freight_amount->RowCssClass = "row";

        // material
        $this->material->RowCssClass = "row";

        // @
        $this->_40->RowCssClass = "row";

        // buyer
        $this->buyer->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // comm
        $this->comm->RowCssClass = "row";

        // load_date
        $this->load_date->RowCssClass = "row";

        // load_weight
        $this->load_weight->RowCssClass = "row";

        // load_km
        $this->load_km->RowCssClass = "row";

        // gst_percent
        $this->gst_percent->RowCssClass = "row";

        // driver
        $this->driver->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // vehicle_freight_comm
        $this->vehicle_freight_comm->RowCssClass = "row";

        // freight_type
        $this->freight_type->RowCssClass = "row";

        // freight
        $this->freight->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // vehicle_type
            if (strval($this->vehicle_type->CurrentValue) != "") {
                $this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
            } else {
                $this->vehicle_type->ViewValue = null;
            }

            // vehicle
            $this->vehicle->ViewValue = $this->vehicle->CurrentValue;
            $curVal = strval($this->vehicle->CurrentValue);
            if ($curVal != "") {
                $this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
                if ($this->vehicle->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
                    } else {
                        $this->vehicle->ViewValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                    }
                }
            } else {
                $this->vehicle->ViewValue = null;
            }

            // route
            $this->_route->ViewValue = $this->_route->CurrentValue;
            $curVal = strval($this->_route->CurrentValue);
            if ($curVal != "") {
                $this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
                if ($this->_route->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                        $this->_route->ViewValue = $this->_route->displayValue($arwrk);
                    } else {
                        $this->_route->ViewValue = FormatNumber($this->_route->CurrentValue, $this->_route->formatPattern());
                    }
                }
            } else {
                $this->_route->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // vehicle_freight_type
            if (strval($this->vehicle_freight_type->CurrentValue) != "") {
                $this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
            } else {
                $this->vehicle_freight_type->ViewValue = null;
            }

            // vehicle_freight_amount
            $this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
            $this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, $this->vehicle_freight_amount->formatPattern());

            // material
            $this->material->ViewValue = $this->material->CurrentValue;

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;
            $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

            // buyer
            $this->buyer->ViewValue = $this->buyer->CurrentValue;
            $curVal = strval($this->buyer->CurrentValue);
            if ($curVal != "") {
                $this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->ViewValue = FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern());
                    }
                }
            } else {
                $this->buyer->ViewValue = null;
            }

            // agent
            $this->agent->ViewValue = $this->agent->CurrentValue;
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern());
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // comm
            $this->comm->ViewValue = $this->comm->CurrentValue;
            $this->comm->ViewValue = FormatNumber($this->comm->ViewValue, $this->comm->formatPattern());

            // load_date
            $this->load_date->ViewValue = $this->load_date->CurrentValue;
            $this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, $this->load_date->formatPattern());

            // load_weight
            $this->load_weight->ViewValue = $this->load_weight->CurrentValue;
            $this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, $this->load_weight->formatPattern());

            // load_km
            $this->load_km->ViewValue = $this->load_km->CurrentValue;
            $this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, $this->load_km->formatPattern());

            // gst_percent
            $this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
            $this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, $this->gst_percent->formatPattern());

            // driver
            $this->driver->ViewValue = $this->driver->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // vehicle_freight_comm
            $this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
            $this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, $this->vehicle_freight_comm->formatPattern());

            // freight_type
            if (strval($this->freight_type->CurrentValue) != "") {
                $this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
            } else {
                $this->freight_type->ViewValue = null;
            }

            // freight
            $this->freight->ViewValue = $this->freight->CurrentValue;
            $this->freight->ViewValue = FormatNumber($this->freight->ViewValue, $this->freight->formatPattern());

            // id
            $this->id->HrefValue = "";

            // vehicle_type
            $this->vehicle_type->HrefValue = "";

            // vehicle
            $this->vehicle->HrefValue = "";
            $this->vehicle->TooltipValue = "";

            // route
            $this->_route->HrefValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // vehicle_freight_type
            $this->vehicle_freight_type->HrefValue = "";

            // vehicle_freight_amount
            $this->vehicle_freight_amount->HrefValue = "";

            // material
            $this->material->HrefValue = "";

            // @
            $this->_40->HrefValue = "";

            // buyer
            $this->buyer->HrefValue = "";

            // agent
            $this->agent->HrefValue = "";

            // comm
            $this->comm->HrefValue = "";

            // load_date
            $this->load_date->HrefValue = "";

            // load_weight
            $this->load_weight->HrefValue = "";

            // load_km
            $this->load_km->HrefValue = "";

            // gst_percent
            $this->gst_percent->HrefValue = "";

            // driver
            $this->driver->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // vehicle_freight_comm
            $this->vehicle_freight_comm->HrefValue = "";

            // freight_type
            $this->freight_type->HrefValue = "";

            // freight
            $this->freight->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // vehicle_type
            $this->vehicle_type->setupEditAttributes();
            $this->vehicle_type->EditValue = $this->vehicle_type->options(true);
            $this->vehicle_type->PlaceHolder = RemoveHtml($this->vehicle_type->caption());

            // vehicle
            $this->vehicle->setupEditAttributes();
            $this->vehicle->EditValue = $this->vehicle->CurrentValue;
            $curVal = strval($this->vehicle->CurrentValue);
            if ($curVal != "") {
                $this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
                if ($this->vehicle->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
                    } else {
                        $this->vehicle->EditValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                    }
                }
            } else {
                $this->vehicle->EditValue = null;
            }

            // route
            $this->_route->setupEditAttributes();
            $this->_route->EditValue = $this->_route->CurrentValue;
            $curVal = strval($this->_route->CurrentValue);
            if ($curVal != "") {
                $this->_route->EditValue = $this->_route->lookupCacheOption($curVal);
                if ($this->_route->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                        $this->_route->EditValue = $this->_route->displayValue($arwrk);
                    } else {
                        $this->_route->EditValue = HtmlEncode(FormatNumber($this->_route->CurrentValue, $this->_route->formatPattern()));
                    }
                }
            } else {
                $this->_route->EditValue = null;
            }
            $this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->CurrentValue));
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->CurrentValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // vehicle_freight_type
            $this->vehicle_freight_type->setupEditAttributes();
            $this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(true);
            $this->vehicle_freight_type->PlaceHolder = RemoveHtml($this->vehicle_freight_type->caption());

            // vehicle_freight_amount
            $this->vehicle_freight_amount->setupEditAttributes();
            $this->vehicle_freight_amount->EditValue = $this->vehicle_freight_amount->CurrentValue;
            $this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());
            if (strval($this->vehicle_freight_amount->EditValue) != "" && is_numeric($this->vehicle_freight_amount->EditValue)) {
                $this->vehicle_freight_amount->EditValue = FormatNumber($this->vehicle_freight_amount->EditValue, null);
            }

            // material
            $this->material->setupEditAttributes();
            if (!$this->material->Raw) {
                $this->material->CurrentValue = HtmlDecode($this->material->CurrentValue);
            }
            $this->material->EditValue = HtmlEncode($this->material->CurrentValue);
            $this->material->PlaceHolder = RemoveHtml($this->material->caption());

            // @
            $this->_40->setupEditAttributes();
            $this->_40->EditValue = $this->_40->CurrentValue;
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
            if (strval($this->_40->EditValue) != "" && is_numeric($this->_40->EditValue)) {
                $this->_40->EditValue = FormatNumber($this->_40->EditValue, null);
            }

            // buyer
            $this->buyer->setupEditAttributes();
            $this->buyer->EditValue = $this->buyer->CurrentValue;
            $curVal = strval($this->buyer->CurrentValue);
            if ($curVal != "") {
                $this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->EditValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->EditValue = HtmlEncode(FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern()));
                    }
                }
            } else {
                $this->buyer->EditValue = null;
            }
            $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

            // agent
            $this->agent->setupEditAttributes();
            $this->agent->EditValue = $this->agent->CurrentValue;
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->EditValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->EditValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->EditValue = HtmlEncode(FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern()));
                    }
                }
            } else {
                $this->agent->EditValue = null;
            }
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // comm
            $this->comm->setupEditAttributes();
            $this->comm->EditValue = $this->comm->CurrentValue;
            $this->comm->PlaceHolder = RemoveHtml($this->comm->caption());
            if (strval($this->comm->EditValue) != "" && is_numeric($this->comm->EditValue)) {
                $this->comm->EditValue = FormatNumber($this->comm->EditValue, null);
            }

            // load_date
            $this->load_date->setupEditAttributes();
            $this->load_date->EditValue = HtmlEncode(FormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern()));
            $this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

            // load_weight
            $this->load_weight->setupEditAttributes();
            $this->load_weight->EditValue = $this->load_weight->CurrentValue;
            $this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());
            if (strval($this->load_weight->EditValue) != "" && is_numeric($this->load_weight->EditValue)) {
                $this->load_weight->EditValue = FormatNumber($this->load_weight->EditValue, null);
            }

            // load_km
            $this->load_km->setupEditAttributes();
            $this->load_km->EditValue = $this->load_km->CurrentValue;
            $this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());
            if (strval($this->load_km->EditValue) != "" && is_numeric($this->load_km->EditValue)) {
                $this->load_km->EditValue = FormatNumber($this->load_km->EditValue, null);
            }

            // gst_percent
            $this->gst_percent->setupEditAttributes();
            $this->gst_percent->EditValue = $this->gst_percent->CurrentValue;
            $this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());
            if (strval($this->gst_percent->EditValue) != "" && is_numeric($this->gst_percent->EditValue)) {
                $this->gst_percent->EditValue = FormatNumber($this->gst_percent->EditValue, null);
            }

            // driver
            $this->driver->setupEditAttributes();
            $this->driver->EditCustomAttributes = $this->driver->getEditCustomAttributes(); // PHP
            $this->driver->EditValue = $this->driver->CurrentValue;
            $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());
            if (strval($this->driver->EditValue) != "" && is_numeric($this->driver->EditValue)) {
                $this->driver->EditValue = $this->driver->EditValue;
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // vehicle_freight_comm
            $this->vehicle_freight_comm->setupEditAttributes();
            $this->vehicle_freight_comm->EditValue = $this->vehicle_freight_comm->CurrentValue;
            $this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());
            if (strval($this->vehicle_freight_comm->EditValue) != "" && is_numeric($this->vehicle_freight_comm->EditValue)) {
                $this->vehicle_freight_comm->EditValue = FormatNumber($this->vehicle_freight_comm->EditValue, null);
            }

            // freight_type
            $this->freight_type->setupEditAttributes();
            $this->freight_type->EditValue = $this->freight_type->options(true);
            $this->freight_type->PlaceHolder = RemoveHtml($this->freight_type->caption());

            // freight
            $this->freight->setupEditAttributes();
            $this->freight->EditValue = $this->freight->CurrentValue;
            $this->freight->PlaceHolder = RemoveHtml($this->freight->caption());
            if (strval($this->freight->EditValue) != "" && is_numeric($this->freight->EditValue)) {
                $this->freight->EditValue = FormatNumber($this->freight->EditValue, null);
            }

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // vehicle_type
            $this->vehicle_type->HrefValue = "";

            // vehicle
            $this->vehicle->HrefValue = "";
            $this->vehicle->TooltipValue = "";

            // route
            $this->_route->HrefValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // vehicle_freight_type
            $this->vehicle_freight_type->HrefValue = "";

            // vehicle_freight_amount
            $this->vehicle_freight_amount->HrefValue = "";

            // material
            $this->material->HrefValue = "";

            // @
            $this->_40->HrefValue = "";

            // buyer
            $this->buyer->HrefValue = "";

            // agent
            $this->agent->HrefValue = "";

            // comm
            $this->comm->HrefValue = "";

            // load_date
            $this->load_date->HrefValue = "";

            // load_weight
            $this->load_weight->HrefValue = "";

            // load_km
            $this->load_km->HrefValue = "";

            // gst_percent
            $this->gst_percent->HrefValue = "";

            // driver
            $this->driver->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // vehicle_freight_comm
            $this->vehicle_freight_comm->HrefValue = "";

            // freight_type
            $this->freight_type->HrefValue = "";

            // freight
            $this->freight->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->vehicle_type->Visible && $this->vehicle_type->Required) {
                if (!$this->vehicle_type->IsDetailKey && EmptyValue($this->vehicle_type->FormValue)) {
                    $this->vehicle_type->addErrorMessage(str_replace("%s", $this->vehicle_type->caption(), $this->vehicle_type->RequiredErrorMessage));
                }
            }
            if ($this->vehicle->Visible && $this->vehicle->Required) {
                if (!$this->vehicle->IsDetailKey && EmptyValue($this->vehicle->FormValue)) {
                    $this->vehicle->addErrorMessage(str_replace("%s", $this->vehicle->caption(), $this->vehicle->RequiredErrorMessage));
                }
            }
            if ($this->_route->Visible && $this->_route->Required) {
                if (!$this->_route->IsDetailKey && EmptyValue($this->_route->FormValue)) {
                    $this->_route->addErrorMessage(str_replace("%s", $this->_route->caption(), $this->_route->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->_route->FormValue)) {
                $this->_route->addErrorMessage($this->_route->getErrorMessage(false));
            }
            if ($this->reports_to->Visible && $this->reports_to->Required) {
                if (!$this->reports_to->IsDetailKey && EmptyValue($this->reports_to->FormValue)) {
                    $this->reports_to->addErrorMessage(str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
                }
            }
            if ($this->vehicle_freight_type->Visible && $this->vehicle_freight_type->Required) {
                if (!$this->vehicle_freight_type->IsDetailKey && EmptyValue($this->vehicle_freight_type->FormValue)) {
                    $this->vehicle_freight_type->addErrorMessage(str_replace("%s", $this->vehicle_freight_type->caption(), $this->vehicle_freight_type->RequiredErrorMessage));
                }
            }
            if ($this->vehicle_freight_amount->Visible && $this->vehicle_freight_amount->Required) {
                if (!$this->vehicle_freight_amount->IsDetailKey && EmptyValue($this->vehicle_freight_amount->FormValue)) {
                    $this->vehicle_freight_amount->addErrorMessage(str_replace("%s", $this->vehicle_freight_amount->caption(), $this->vehicle_freight_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->vehicle_freight_amount->FormValue)) {
                $this->vehicle_freight_amount->addErrorMessage($this->vehicle_freight_amount->getErrorMessage(false));
            }
            if ($this->material->Visible && $this->material->Required) {
                if (!$this->material->IsDetailKey && EmptyValue($this->material->FormValue)) {
                    $this->material->addErrorMessage(str_replace("%s", $this->material->caption(), $this->material->RequiredErrorMessage));
                }
            }
            if ($this->_40->Visible && $this->_40->Required) {
                if (!$this->_40->IsDetailKey && EmptyValue($this->_40->FormValue)) {
                    $this->_40->addErrorMessage(str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_40->FormValue)) {
                $this->_40->addErrorMessage($this->_40->getErrorMessage(false));
            }
            if ($this->buyer->Visible && $this->buyer->Required) {
                if (!$this->buyer->IsDetailKey && EmptyValue($this->buyer->FormValue)) {
                    $this->buyer->addErrorMessage(str_replace("%s", $this->buyer->caption(), $this->buyer->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->buyer->FormValue)) {
                $this->buyer->addErrorMessage($this->buyer->getErrorMessage(false));
            }
            if ($this->agent->Visible && $this->agent->Required) {
                if (!$this->agent->IsDetailKey && EmptyValue($this->agent->FormValue)) {
                    $this->agent->addErrorMessage(str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->agent->FormValue)) {
                $this->agent->addErrorMessage($this->agent->getErrorMessage(false));
            }
            if ($this->comm->Visible && $this->comm->Required) {
                if (!$this->comm->IsDetailKey && EmptyValue($this->comm->FormValue)) {
                    $this->comm->addErrorMessage(str_replace("%s", $this->comm->caption(), $this->comm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->comm->FormValue)) {
                $this->comm->addErrorMessage($this->comm->getErrorMessage(false));
            }
            if ($this->load_date->Visible && $this->load_date->Required) {
                if (!$this->load_date->IsDetailKey && EmptyValue($this->load_date->FormValue)) {
                    $this->load_date->addErrorMessage(str_replace("%s", $this->load_date->caption(), $this->load_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->load_date->FormValue, $this->load_date->formatPattern())) {
                $this->load_date->addErrorMessage($this->load_date->getErrorMessage(false));
            }
            if ($this->load_weight->Visible && $this->load_weight->Required) {
                if (!$this->load_weight->IsDetailKey && EmptyValue($this->load_weight->FormValue)) {
                    $this->load_weight->addErrorMessage(str_replace("%s", $this->load_weight->caption(), $this->load_weight->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->load_weight->FormValue)) {
                $this->load_weight->addErrorMessage($this->load_weight->getErrorMessage(false));
            }
            if ($this->load_km->Visible && $this->load_km->Required) {
                if (!$this->load_km->IsDetailKey && EmptyValue($this->load_km->FormValue)) {
                    $this->load_km->addErrorMessage(str_replace("%s", $this->load_km->caption(), $this->load_km->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->load_km->FormValue)) {
                $this->load_km->addErrorMessage($this->load_km->getErrorMessage(false));
            }
            if ($this->gst_percent->Visible && $this->gst_percent->Required) {
                if (!$this->gst_percent->IsDetailKey && EmptyValue($this->gst_percent->FormValue)) {
                    $this->gst_percent->addErrorMessage(str_replace("%s", $this->gst_percent->caption(), $this->gst_percent->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->gst_percent->FormValue)) {
                $this->gst_percent->addErrorMessage($this->gst_percent->getErrorMessage(false));
            }
            if ($this->driver->Visible && $this->driver->Required) {
                if (!$this->driver->IsDetailKey && EmptyValue($this->driver->FormValue)) {
                    $this->driver->addErrorMessage(str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->vehicle_freight_comm->Visible && $this->vehicle_freight_comm->Required) {
                if (!$this->vehicle_freight_comm->IsDetailKey && EmptyValue($this->vehicle_freight_comm->FormValue)) {
                    $this->vehicle_freight_comm->addErrorMessage(str_replace("%s", $this->vehicle_freight_comm->caption(), $this->vehicle_freight_comm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->vehicle_freight_comm->FormValue)) {
                $this->vehicle_freight_comm->addErrorMessage($this->vehicle_freight_comm->getErrorMessage(false));
            }
            if ($this->freight_type->Visible && $this->freight_type->Required) {
                if (!$this->freight_type->IsDetailKey && EmptyValue($this->freight_type->FormValue)) {
                    $this->freight_type->addErrorMessage(str_replace("%s", $this->freight_type->caption(), $this->freight_type->RequiredErrorMessage));
                }
            }
            if ($this->freight->Visible && $this->freight->Required) {
                if (!$this->freight->IsDetailKey && EmptyValue($this->freight->FormValue)) {
                    $this->freight->addErrorMessage(str_replace("%s", $this->freight->caption(), $this->freight->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->freight->FormValue)) {
                $this->freight->addErrorMessage($this->freight->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // vehicle_type
        $this->vehicle_type->setDbValueDef($rsnew, $this->vehicle_type->CurrentValue, $this->vehicle_type->ReadOnly);

        // route
        $this->_route->setDbValueDef($rsnew, $this->_route->CurrentValue, $this->_route->ReadOnly);

        // reports_to
        $this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, $this->reports_to->ReadOnly);

        // vehicle_freight_type
        $this->vehicle_freight_type->setDbValueDef($rsnew, $this->vehicle_freight_type->CurrentValue, $this->vehicle_freight_type->ReadOnly);

        // vehicle_freight_amount
        $this->vehicle_freight_amount->setDbValueDef($rsnew, $this->vehicle_freight_amount->CurrentValue, $this->vehicle_freight_amount->ReadOnly);

        // material
        $this->material->setDbValueDef($rsnew, $this->material->CurrentValue, $this->material->ReadOnly);

        // @
        $this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, $this->_40->ReadOnly);

        // buyer
        $this->buyer->setDbValueDef($rsnew, $this->buyer->CurrentValue, $this->buyer->ReadOnly);

        // agent
        $this->agent->setDbValueDef($rsnew, $this->agent->CurrentValue, $this->agent->ReadOnly);

        // comm
        $this->comm->setDbValueDef($rsnew, $this->comm->CurrentValue, $this->comm->ReadOnly);

        // load_date
        $this->load_date->setDbValueDef($rsnew, UnFormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern()), $this->load_date->ReadOnly);

        // load_weight
        $this->load_weight->setDbValueDef($rsnew, $this->load_weight->CurrentValue, $this->load_weight->ReadOnly);

        // load_km
        $this->load_km->setDbValueDef($rsnew, $this->load_km->CurrentValue, $this->load_km->ReadOnly);

        // gst_percent
        $this->gst_percent->setDbValueDef($rsnew, $this->gst_percent->CurrentValue, $this->gst_percent->ReadOnly);

        // driver
        $this->driver->setDbValueDef($rsnew, $this->driver->CurrentValue, $this->driver->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // vehicle_freight_comm
        $this->vehicle_freight_comm->setDbValueDef($rsnew, $this->vehicle_freight_comm->CurrentValue, $this->vehicle_freight_comm->ReadOnly);

        // freight_type
        $this->freight_type->setDbValueDef($rsnew, $this->freight_type->CurrentValue, $this->freight_type->ReadOnly);

        // freight
        $this->freight->setDbValueDef($rsnew, $this->freight->CurrentValue, $this->freight->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['vehicle_type'])) { // vehicle_type
            $this->vehicle_type->CurrentValue = $row['vehicle_type'];
        }
        if (isset($row['route'])) { // route
            $this->_route->CurrentValue = $row['route'];
        }
        if (isset($row['reports_to'])) { // reports_to
            $this->reports_to->CurrentValue = $row['reports_to'];
        }
        if (isset($row['vehicle_freight_type'])) { // vehicle_freight_type
            $this->vehicle_freight_type->CurrentValue = $row['vehicle_freight_type'];
        }
        if (isset($row['vehicle_freight_amount'])) { // vehicle_freight_amount
            $this->vehicle_freight_amount->CurrentValue = $row['vehicle_freight_amount'];
        }
        if (isset($row['material'])) { // material
            $this->material->CurrentValue = $row['material'];
        }
        if (isset($row['@'])) { // @
            $this->_40->CurrentValue = $row['@'];
        }
        if (isset($row['buyer'])) { // buyer
            $this->buyer->CurrentValue = $row['buyer'];
        }
        if (isset($row['agent'])) { // agent
            $this->agent->CurrentValue = $row['agent'];
        }
        if (isset($row['comm'])) { // comm
            $this->comm->CurrentValue = $row['comm'];
        }
        if (isset($row['load_date'])) { // load_date
            $this->load_date->CurrentValue = $row['load_date'];
        }
        if (isset($row['load_weight'])) { // load_weight
            $this->load_weight->CurrentValue = $row['load_weight'];
        }
        if (isset($row['load_km'])) { // load_km
            $this->load_km->CurrentValue = $row['load_km'];
        }
        if (isset($row['gst_percent'])) { // gst_percent
            $this->gst_percent->CurrentValue = $row['gst_percent'];
        }
        if (isset($row['driver'])) { // driver
            $this->driver->CurrentValue = $row['driver'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['vehicle_freight_comm'])) { // vehicle_freight_comm
            $this->vehicle_freight_comm->CurrentValue = $row['vehicle_freight_comm'];
        }
        if (isset($row['freight_type'])) { // freight_type
            $this->freight_type->CurrentValue = $row['freight_type'];
        }
        if (isset($row['freight'])) { // freight
            $this->freight->CurrentValue = $row['freight'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ttripstartlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_vehicle_type":
                    break;
                case "x_vehicle":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__route":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_vehicle_freight_type":
                    break;
                case "x_buyer":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_freight_type":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
