<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for t_trip_start
 */
class TTripStart extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $vehicle_type;
    public $vehicle;
    public $_route;
    public $reports_to;
    public $vehicle_freight_type;
    public $vehicle_freight_amount;
    public $material;
    public $_40;
    public $buyer;
    public $agent;
    public $comm;
    public $load_date;
    public $load_weight;
    public $load_km;
    public $gst_percent;
    public $driver;
    public $remarks;
    public $vehicle_freight_comm;
    public $freight_type;
    public $freight;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "t_trip_start";
        $this->TableName = 't_trip_start';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "t_trip_start";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // vehicle_type
        $this->vehicle_type = new DbField(
            $this, // Table
            'x_vehicle_type', // Variable name
            'vehicle_type', // Name
            '`vehicle_type`', // Expression
            '`vehicle_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->vehicle_type->addMethod("getDefault", fn() => 1);
        $this->vehicle_type->InputTextType = "text";
        $this->vehicle_type->Raw = true;
        $this->vehicle_type->Nullable = false; // NOT NULL field
        $this->vehicle_type->setSelectMultiple(false); // Select one
        $this->vehicle_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->vehicle_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->vehicle_type->Lookup = new Lookup($this->vehicle_type, 't_trip_start', false, '', ["","","",""], '', '', [], ["x_vehicle"], [], [], [], [], false, '', '', "");
        $this->vehicle_type->OptionCount = 2;
        $this->vehicle_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->vehicle_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_type'] = &$this->vehicle_type;

        // vehicle
        $this->vehicle = new DbField(
            $this, // Table
            'x_vehicle', // Variable name
            'vehicle', // Name
            '`vehicle`', // Expression
            '`vehicle`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->vehicle->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "");
        $this->vehicle->InputTextType = "text";
        $this->vehicle->Raw = true;
        $this->vehicle->Nullable = false; // NOT NULL field
        $this->vehicle->Required = true; // Required field
        $this->vehicle->Lookup = new Lookup($this->vehicle, 'vehicle_info', false, 'id', ["no","","",""], '', '', ["x_vehicle_type"], [], ["type"], ["x_type"], ["driver_name"], ["x_driver"], false, '`no` ASC', '', "`no`");
        $this->vehicle->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->vehicle->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle'] = &$this->vehicle;

        // route
        $this->_route = new DbField(
            $this, // Table
            'x__route', // Variable name
            'route', // Name
            '`route`', // Expression
            '`route`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`route`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_route->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->_route->InputTextType = "text";
        $this->_route->Raw = true;
        $this->_route->Nullable = false; // NOT NULL field
        $this->_route->Required = true; // Required field
        $this->_route->Lookup = new Lookup($this->_route, 't_route_info', false, 'id', ["route_name","","",""], '', '', [], [], [], [], [], [], false, '`route_name` ASC', '', "`route_name`");
        $this->_route->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_route->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['route'] = &$this->_route;

        // reports_to
        $this->reports_to = new DbField(
            $this, // Table
            'x_reports_to', // Variable name
            'reports_to', // Name
            '`reports_to`', // Expression
            '`reports_to`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`reports_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->reports_to->addMethod("getSelectFilter", fn() => "`activated`=1 and `userlevel`=1003");
        $this->reports_to->addMethod("getDefault", fn() => 0);
        $this->reports_to->InputTextType = "text";
        $this->reports_to->Raw = true;
        $this->reports_to->setSelectMultiple(false); // Select one
        $this->reports_to->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->reports_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->reports_to->Lookup = new Lookup($this->reports_to, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->reports_to->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['reports_to'] = &$this->reports_to;

        // vehicle_freight_type
        $this->vehicle_freight_type = new DbField(
            $this, // Table
            'x_vehicle_freight_type', // Variable name
            'vehicle_freight_type', // Name
            '`vehicle_freight_type`', // Expression
            '`vehicle_freight_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_freight_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->vehicle_freight_type->addMethod("getDefault", fn() => 0);
        $this->vehicle_freight_type->InputTextType = "text";
        $this->vehicle_freight_type->Raw = true;
        $this->vehicle_freight_type->Nullable = false; // NOT NULL field
        $this->vehicle_freight_type->setSelectMultiple(false); // Select one
        $this->vehicle_freight_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->vehicle_freight_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->vehicle_freight_type->Lookup = new Lookup($this->vehicle_freight_type, 't_trip_start', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->vehicle_freight_type->OptionCount = 2;
        $this->vehicle_freight_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->vehicle_freight_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_freight_type'] = &$this->vehicle_freight_type;

        // vehicle_freight_amount
        $this->vehicle_freight_amount = new DbField(
            $this, // Table
            'x_vehicle_freight_amount', // Variable name
            'vehicle_freight_amount', // Name
            '`vehicle_freight_amount`', // Expression
            '`vehicle_freight_amount`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_freight_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->vehicle_freight_amount->InputTextType = "text";
        $this->vehicle_freight_amount->Raw = true;
        $this->vehicle_freight_amount->Nullable = false; // NOT NULL field
        $this->vehicle_freight_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->vehicle_freight_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_freight_amount'] = &$this->vehicle_freight_amount;

        // material
        $this->material = new DbField(
            $this, // Table
            'x_material', // Variable name
            'material', // Name
            '`material`', // Expression
            '`material`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`material`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->material->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->material->InputTextType = "text";
        $this->material->Nullable = false; // NOT NULL field
        $this->material->Required = true; // Required field
        $this->material->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['material'] = &$this->material;

        // @
        $this->_40 = new DbField(
            $this, // Table
            'x__40', // Variable name
            '@', // Name
            '`@`', // Expression
            '`@`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`@`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_40->InputTextType = "text";
        $this->_40->Raw = true;
        $this->_40->Nullable = false; // NOT NULL field
        $this->_40->Required = true; // Required field
        $this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_40->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['@'] = &$this->_40;

        // buyer
        $this->buyer = new DbField(
            $this, // Table
            'x_buyer', // Variable name
            'buyer', // Name
            '`buyer`', // Expression
            '`buyer`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer->addMethod("getSelectFilter", fn() => "`category` = 902 and `status` = 1");
        $this->buyer->InputTextType = "text";
        $this->buyer->Raw = true;
        $this->buyer->Nullable = false; // NOT NULL field
        $this->buyer->Required = true; // Required field
        $this->buyer->Lookup = new Lookup($this->buyer, 'buyer', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`name`");
        $this->buyer->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['buyer'] = &$this->buyer;

        // agent
        $this->agent = new DbField(
            $this, // Table
            'x_agent', // Variable name
            'agent', // Name
            '`agent`', // Expression
            '`agent`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`agent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->agent->addMethod("getSelectFilter", fn() => "`category` = 902 and `status` = 1");
        $this->agent->InputTextType = "text";
        $this->agent->Raw = true;
        $this->agent->Lookup = new Lookup($this->agent, 'buyer', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->agent->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->agent->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['agent'] = &$this->agent;

        // comm
        $this->comm = new DbField(
            $this, // Table
            'x_comm', // Variable name
            'comm', // Name
            '`comm`', // Expression
            '`comm`', // Basic search expression
            131, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`comm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->comm->addMethod("getDefault", fn() => 0.00);
        $this->comm->InputTextType = "text";
        $this->comm->Raw = true;
        $this->comm->Nullable = false; // NOT NULL field
        $this->comm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->comm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['comm'] = &$this->comm;

        // load_date
        $this->load_date = new DbField(
            $this, // Table
            'x_load_date', // Variable name
            'load_date', // Name
            '`load_date`', // Expression
            CastDateFieldForLike("`load_date`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`load_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->load_date->InputTextType = "text";
        $this->load_date->Raw = true;
        $this->load_date->Nullable = false; // NOT NULL field
        $this->load_date->Required = true; // Required field
        $this->load_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->load_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['load_date'] = &$this->load_date;

        // load_weight
        $this->load_weight = new DbField(
            $this, // Table
            'x_load_weight', // Variable name
            'load_weight', // Name
            '`load_weight`', // Expression
            '`load_weight`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`load_weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->load_weight->InputTextType = "text";
        $this->load_weight->Raw = true;
        $this->load_weight->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->load_weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['load_weight'] = &$this->load_weight;

        // load_km
        $this->load_km = new DbField(
            $this, // Table
            'x_load_km', // Variable name
            'load_km', // Name
            '`load_km`', // Expression
            '`load_km`', // Basic search expression
            3, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`load_km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->load_km->InputTextType = "text";
        $this->load_km->Raw = true;
        $this->load_km->Nullable = false; // NOT NULL field
        $this->load_km->Required = true; // Required field
        $this->load_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->load_km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['load_km'] = &$this->load_km;

        // gst_percent
        $this->gst_percent = new DbField(
            $this, // Table
            'x_gst_percent', // Variable name
            'gst_percent', // Name
            '`gst_percent`', // Expression
            '`gst_percent`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gst_percent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gst_percent->addMethod("getDefault", fn() => 0.00);
        $this->gst_percent->InputTextType = "text";
        $this->gst_percent->Raw = true;
        $this->gst_percent->Nullable = false; // NOT NULL field
        $this->gst_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->gst_percent->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['gst_percent'] = &$this->gst_percent;

        // driver
        $this->driver = new DbField(
            $this, // Table
            'x_driver', // Variable name
            'driver', // Name
            '`driver`', // Expression
            '`driver`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`driver`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->driver->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->driver->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->driver->InputTextType = "text";
        $this->driver->Raw = true;
        $this->driver->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['driver'] = &$this->driver;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->Sortable = false; // Allow sort
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // vehicle_freight_comm
        $this->vehicle_freight_comm = new DbField(
            $this, // Table
            'x_vehicle_freight_comm', // Variable name
            'vehicle_freight_comm', // Name
            '`vehicle_freight_comm`', // Expression
            '`vehicle_freight_comm`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_freight_comm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->vehicle_freight_comm->addMethod("getDefault", fn() => 0.00);
        $this->vehicle_freight_comm->InputTextType = "text";
        $this->vehicle_freight_comm->Raw = true;
        $this->vehicle_freight_comm->Nullable = false; // NOT NULL field
        $this->vehicle_freight_comm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->vehicle_freight_comm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_freight_comm'] = &$this->vehicle_freight_comm;

        // freight_type
        $this->freight_type = new DbField(
            $this, // Table
            'x_freight_type', // Variable name
            'freight_type', // Name
            '`freight_type`', // Expression
            '`freight_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`freight_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->freight_type->addMethod("getDefault", fn() => 0);
        $this->freight_type->InputTextType = "text";
        $this->freight_type->Raw = true;
        $this->freight_type->Nullable = false; // NOT NULL field
        $this->freight_type->setSelectMultiple(false); // Select one
        $this->freight_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->freight_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->freight_type->Lookup = new Lookup($this->freight_type, 't_trip_start', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->freight_type->OptionCount = 2;
        $this->freight_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->freight_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['freight_type'] = &$this->freight_type;

        // freight
        $this->freight = new DbField(
            $this, // Table
            'x_freight', // Variable name
            'freight', // Name
            '`freight`', // Expression
            '`freight`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`freight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->freight->InputTextType = "text";
        $this->freight->Raw = true;
        $this->freight->Nullable = false; // NOT NULL field
        $this->freight->Required = true; // Required field
        $this->freight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->freight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['freight'] = &$this->freight;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "t_trip_start";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->vehicle_type->DbValue = $row['vehicle_type'];
        $this->vehicle->DbValue = $row['vehicle'];
        $this->_route->DbValue = $row['route'];
        $this->reports_to->DbValue = $row['reports_to'];
        $this->vehicle_freight_type->DbValue = $row['vehicle_freight_type'];
        $this->vehicle_freight_amount->DbValue = $row['vehicle_freight_amount'];
        $this->material->DbValue = $row['material'];
        $this->_40->DbValue = $row['@'];
        $this->buyer->DbValue = $row['buyer'];
        $this->agent->DbValue = $row['agent'];
        $this->comm->DbValue = $row['comm'];
        $this->load_date->DbValue = $row['load_date'];
        $this->load_weight->DbValue = $row['load_weight'];
        $this->load_km->DbValue = $row['load_km'];
        $this->gst_percent->DbValue = $row['gst_percent'];
        $this->driver->DbValue = $row['driver'];
        $this->remarks->DbValue = $row['remarks'];
        $this->vehicle_freight_comm->DbValue = $row['vehicle_freight_comm'];
        $this->freight_type->DbValue = $row['freight_type'];
        $this->freight->DbValue = $row['freight'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("ttripstartlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "ttripstartview" => $Language->phrase("View"),
            "ttripstartedit" => $Language->phrase("Edit"),
            "ttripstartadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "ttripstartlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "TTripStartView",
            Config("API_ADD_ACTION") => "TTripStartAdd",
            Config("API_EDIT_ACTION") => "TTripStartEdit",
            Config("API_DELETE_ACTION") => "TTripStartDelete",
            Config("API_LIST_ACTION") => "TTripStartList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "ttripstartlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ttripstartview", $parm);
        } else {
            $url = $this->keyUrl("ttripstartview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "ttripstartadd?" . $parm;
        } else {
            $url = "ttripstartadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("ttripstartedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("ttripstartlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("ttripstartadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("ttripstartlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("ttripstartdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->vehicle_type->setDbValue($row['vehicle_type']);
        $this->vehicle->setDbValue($row['vehicle']);
        $this->_route->setDbValue($row['route']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->vehicle_freight_type->setDbValue($row['vehicle_freight_type']);
        $this->vehicle_freight_amount->setDbValue($row['vehicle_freight_amount']);
        $this->material->setDbValue($row['material']);
        $this->_40->setDbValue($row['@']);
        $this->buyer->setDbValue($row['buyer']);
        $this->agent->setDbValue($row['agent']);
        $this->comm->setDbValue($row['comm']);
        $this->load_date->setDbValue($row['load_date']);
        $this->load_weight->setDbValue($row['load_weight']);
        $this->load_km->setDbValue($row['load_km']);
        $this->gst_percent->setDbValue($row['gst_percent']);
        $this->driver->setDbValue($row['driver']);
        $this->remarks->setDbValue($row['remarks']);
        $this->vehicle_freight_comm->setDbValue($row['vehicle_freight_comm']);
        $this->freight_type->setDbValue($row['freight_type']);
        $this->freight->setDbValue($row['freight']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "TTripStartList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // vehicle_type

        // vehicle

        // route

        // reports_to

        // vehicle_freight_type

        // vehicle_freight_amount

        // material

        // @

        // buyer

        // agent

        // comm

        // load_date

        // load_weight

        // load_km

        // gst_percent

        // driver

        // remarks

        // vehicle_freight_comm

        // freight_type

        // freight

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // vehicle_type
        if (strval($this->vehicle_type->CurrentValue) != "") {
            $this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
        } else {
            $this->vehicle_type->ViewValue = null;
        }

        // vehicle
        $this->vehicle->ViewValue = $this->vehicle->CurrentValue;
        $curVal = strval($this->vehicle->CurrentValue);
        if ($curVal != "") {
            $this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
            if ($this->vehicle->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                    $this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
                } else {
                    $this->vehicle->ViewValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                }
            }
        } else {
            $this->vehicle->ViewValue = null;
        }

        // route
        $this->_route->ViewValue = $this->_route->CurrentValue;
        $curVal = strval($this->_route->CurrentValue);
        if ($curVal != "") {
            $this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
            if ($this->_route->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                    $this->_route->ViewValue = $this->_route->displayValue($arwrk);
                } else {
                    $this->_route->ViewValue = FormatNumber($this->_route->CurrentValue, $this->_route->formatPattern());
                }
            }
        } else {
            $this->_route->ViewValue = null;
        }

        // reports_to
        $curVal = strval($this->reports_to->CurrentValue);
        if ($curVal != "") {
            $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            if ($this->reports_to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                    $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                } else {
                    $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                }
            }
        } else {
            $this->reports_to->ViewValue = null;
        }

        // vehicle_freight_type
        if (strval($this->vehicle_freight_type->CurrentValue) != "") {
            $this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
        } else {
            $this->vehicle_freight_type->ViewValue = null;
        }

        // vehicle_freight_amount
        $this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
        $this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, $this->vehicle_freight_amount->formatPattern());

        // material
        $this->material->ViewValue = $this->material->CurrentValue;

        // @
        $this->_40->ViewValue = $this->_40->CurrentValue;
        $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

        // buyer
        $this->buyer->ViewValue = $this->buyer->CurrentValue;
        $curVal = strval($this->buyer->CurrentValue);
        if ($curVal != "") {
            $this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
            if ($this->buyer->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
                } else {
                    $this->buyer->ViewValue = FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern());
                }
            }
        } else {
            $this->buyer->ViewValue = null;
        }

        // agent
        $this->agent->ViewValue = $this->agent->CurrentValue;
        $curVal = strval($this->agent->CurrentValue);
        if ($curVal != "") {
            $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
            if ($this->agent->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                    $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                } else {
                    $this->agent->ViewValue = FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern());
                }
            }
        } else {
            $this->agent->ViewValue = null;
        }

        // comm
        $this->comm->ViewValue = $this->comm->CurrentValue;
        $this->comm->ViewValue = FormatNumber($this->comm->ViewValue, $this->comm->formatPattern());

        // load_date
        $this->load_date->ViewValue = $this->load_date->CurrentValue;
        $this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, $this->load_date->formatPattern());

        // load_weight
        $this->load_weight->ViewValue = $this->load_weight->CurrentValue;
        $this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, $this->load_weight->formatPattern());

        // load_km
        $this->load_km->ViewValue = $this->load_km->CurrentValue;
        $this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, $this->load_km->formatPattern());

        // gst_percent
        $this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
        $this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, $this->gst_percent->formatPattern());

        // driver
        $this->driver->ViewValue = $this->driver->CurrentValue;

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // vehicle_freight_comm
        $this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
        $this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, $this->vehicle_freight_comm->formatPattern());

        // freight_type
        if (strval($this->freight_type->CurrentValue) != "") {
            $this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
        } else {
            $this->freight_type->ViewValue = null;
        }

        // freight
        $this->freight->ViewValue = $this->freight->CurrentValue;
        $this->freight->ViewValue = FormatNumber($this->freight->ViewValue, $this->freight->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // vehicle_type
        $this->vehicle_type->HrefValue = "";
        $this->vehicle_type->TooltipValue = "";

        // vehicle
        $this->vehicle->HrefValue = "";
        $this->vehicle->TooltipValue = "";

        // route
        $this->_route->HrefValue = "";
        $this->_route->TooltipValue = "";

        // reports_to
        $this->reports_to->HrefValue = "";
        $this->reports_to->TooltipValue = "";

        // vehicle_freight_type
        $this->vehicle_freight_type->HrefValue = "";
        $this->vehicle_freight_type->TooltipValue = "";

        // vehicle_freight_amount
        $this->vehicle_freight_amount->HrefValue = "";
        $this->vehicle_freight_amount->TooltipValue = "";

        // material
        $this->material->HrefValue = "";
        $this->material->TooltipValue = "";

        // @
        $this->_40->HrefValue = "";
        $this->_40->TooltipValue = "";

        // buyer
        $this->buyer->HrefValue = "";
        $this->buyer->TooltipValue = "";

        // agent
        $this->agent->HrefValue = "";
        $this->agent->TooltipValue = "";

        // comm
        $this->comm->HrefValue = "";
        $this->comm->TooltipValue = "";

        // load_date
        $this->load_date->HrefValue = "";
        $this->load_date->TooltipValue = "";

        // load_weight
        $this->load_weight->HrefValue = "";
        $this->load_weight->TooltipValue = "";

        // load_km
        $this->load_km->HrefValue = "";
        $this->load_km->TooltipValue = "";

        // gst_percent
        $this->gst_percent->HrefValue = "";
        $this->gst_percent->TooltipValue = "";

        // driver
        $this->driver->HrefValue = "";
        $this->driver->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // vehicle_freight_comm
        $this->vehicle_freight_comm->HrefValue = "";
        $this->vehicle_freight_comm->TooltipValue = "";

        // freight_type
        $this->freight_type->HrefValue = "";
        $this->freight_type->TooltipValue = "";

        // freight
        $this->freight->HrefValue = "";
        $this->freight->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // vehicle_type
        $this->vehicle_type->setupEditAttributes();
        $this->vehicle_type->EditValue = $this->vehicle_type->options(true);
        $this->vehicle_type->PlaceHolder = RemoveHtml($this->vehicle_type->caption());

        // vehicle
        $this->vehicle->setupEditAttributes();
        $this->vehicle->EditValue = $this->vehicle->CurrentValue;
        $curVal = strval($this->vehicle->CurrentValue);
        if ($curVal != "") {
            $this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
            if ($this->vehicle->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                    $this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
                } else {
                    $this->vehicle->EditValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                }
            }
        } else {
            $this->vehicle->EditValue = null;
        }

        // route
        $this->_route->setupEditAttributes();
        $this->_route->EditValue = $this->_route->CurrentValue;
        $this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

        // reports_to
        $this->reports_to->setupEditAttributes();
        $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

        // vehicle_freight_type
        $this->vehicle_freight_type->setupEditAttributes();
        $this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(true);
        $this->vehicle_freight_type->PlaceHolder = RemoveHtml($this->vehicle_freight_type->caption());

        // vehicle_freight_amount
        $this->vehicle_freight_amount->setupEditAttributes();
        $this->vehicle_freight_amount->EditValue = $this->vehicle_freight_amount->CurrentValue;
        $this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());
        if (strval($this->vehicle_freight_amount->EditValue) != "" && is_numeric($this->vehicle_freight_amount->EditValue)) {
            $this->vehicle_freight_amount->EditValue = FormatNumber($this->vehicle_freight_amount->EditValue, null);
        }

        // material
        $this->material->setupEditAttributes();
        if (!$this->material->Raw) {
            $this->material->CurrentValue = HtmlDecode($this->material->CurrentValue);
        }
        $this->material->EditValue = $this->material->CurrentValue;
        $this->material->PlaceHolder = RemoveHtml($this->material->caption());

        // @
        $this->_40->setupEditAttributes();
        $this->_40->EditValue = $this->_40->CurrentValue;
        $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
        if (strval($this->_40->EditValue) != "" && is_numeric($this->_40->EditValue)) {
            $this->_40->EditValue = FormatNumber($this->_40->EditValue, null);
        }

        // buyer
        $this->buyer->setupEditAttributes();
        $this->buyer->EditValue = $this->buyer->CurrentValue;
        $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

        // agent
        $this->agent->setupEditAttributes();
        $this->agent->EditValue = $this->agent->CurrentValue;
        $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

        // comm
        $this->comm->setupEditAttributes();
        $this->comm->EditValue = $this->comm->CurrentValue;
        $this->comm->PlaceHolder = RemoveHtml($this->comm->caption());
        if (strval($this->comm->EditValue) != "" && is_numeric($this->comm->EditValue)) {
            $this->comm->EditValue = FormatNumber($this->comm->EditValue, null);
        }

        // load_date
        $this->load_date->setupEditAttributes();
        $this->load_date->EditValue = FormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern());
        $this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

        // load_weight
        $this->load_weight->setupEditAttributes();
        $this->load_weight->EditValue = $this->load_weight->CurrentValue;
        $this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());
        if (strval($this->load_weight->EditValue) != "" && is_numeric($this->load_weight->EditValue)) {
            $this->load_weight->EditValue = FormatNumber($this->load_weight->EditValue, null);
        }

        // load_km
        $this->load_km->setupEditAttributes();
        $this->load_km->EditValue = $this->load_km->CurrentValue;
        $this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());
        if (strval($this->load_km->EditValue) != "" && is_numeric($this->load_km->EditValue)) {
            $this->load_km->EditValue = FormatNumber($this->load_km->EditValue, null);
        }

        // gst_percent
        $this->gst_percent->setupEditAttributes();
        $this->gst_percent->EditValue = $this->gst_percent->CurrentValue;
        $this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());
        if (strval($this->gst_percent->EditValue) != "" && is_numeric($this->gst_percent->EditValue)) {
            $this->gst_percent->EditValue = FormatNumber($this->gst_percent->EditValue, null);
        }

        // driver
        $this->driver->setupEditAttributes();
        $this->driver->EditCustomAttributes = $this->driver->getEditCustomAttributes(); // PHP
        $this->driver->EditValue = $this->driver->CurrentValue;
        $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());
        if (strval($this->driver->EditValue) != "" && is_numeric($this->driver->EditValue)) {
            $this->driver->EditValue = $this->driver->EditValue;
        }

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // vehicle_freight_comm
        $this->vehicle_freight_comm->setupEditAttributes();
        $this->vehicle_freight_comm->EditValue = $this->vehicle_freight_comm->CurrentValue;
        $this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());
        if (strval($this->vehicle_freight_comm->EditValue) != "" && is_numeric($this->vehicle_freight_comm->EditValue)) {
            $this->vehicle_freight_comm->EditValue = FormatNumber($this->vehicle_freight_comm->EditValue, null);
        }

        // freight_type
        $this->freight_type->setupEditAttributes();
        $this->freight_type->EditValue = $this->freight_type->options(true);
        $this->freight_type->PlaceHolder = RemoveHtml($this->freight_type->caption());

        // freight
        $this->freight->setupEditAttributes();
        $this->freight->EditValue = $this->freight->CurrentValue;
        $this->freight->PlaceHolder = RemoveHtml($this->freight->caption());
        if (strval($this->freight->EditValue) != "" && is_numeric($this->freight->EditValue)) {
            $this->freight->EditValue = FormatNumber($this->freight->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->vehicle_type);
                    $doc->exportCaption($this->vehicle);
                    $doc->exportCaption($this->_route);
                    $doc->exportCaption($this->reports_to);
                    $doc->exportCaption($this->vehicle_freight_type);
                    $doc->exportCaption($this->vehicle_freight_amount);
                    $doc->exportCaption($this->material);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->buyer);
                    $doc->exportCaption($this->agent);
                    $doc->exportCaption($this->comm);
                    $doc->exportCaption($this->load_date);
                    $doc->exportCaption($this->load_weight);
                    $doc->exportCaption($this->load_km);
                    $doc->exportCaption($this->gst_percent);
                    $doc->exportCaption($this->driver);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->vehicle_freight_comm);
                    $doc->exportCaption($this->freight_type);
                    $doc->exportCaption($this->freight);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->vehicle_type);
                    $doc->exportCaption($this->vehicle);
                    $doc->exportCaption($this->_route);
                    $doc->exportCaption($this->reports_to);
                    $doc->exportCaption($this->vehicle_freight_type);
                    $doc->exportCaption($this->vehicle_freight_amount);
                    $doc->exportCaption($this->material);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->buyer);
                    $doc->exportCaption($this->agent);
                    $doc->exportCaption($this->comm);
                    $doc->exportCaption($this->load_date);
                    $doc->exportCaption($this->load_weight);
                    $doc->exportCaption($this->load_km);
                    $doc->exportCaption($this->gst_percent);
                    $doc->exportCaption($this->driver);
                    $doc->exportCaption($this->vehicle_freight_comm);
                    $doc->exportCaption($this->freight_type);
                    $doc->exportCaption($this->freight);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->vehicle_type);
                        $doc->exportField($this->vehicle);
                        $doc->exportField($this->_route);
                        $doc->exportField($this->reports_to);
                        $doc->exportField($this->vehicle_freight_type);
                        $doc->exportField($this->vehicle_freight_amount);
                        $doc->exportField($this->material);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->buyer);
                        $doc->exportField($this->agent);
                        $doc->exportField($this->comm);
                        $doc->exportField($this->load_date);
                        $doc->exportField($this->load_weight);
                        $doc->exportField($this->load_km);
                        $doc->exportField($this->gst_percent);
                        $doc->exportField($this->driver);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->vehicle_freight_comm);
                        $doc->exportField($this->freight_type);
                        $doc->exportField($this->freight);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->vehicle_type);
                        $doc->exportField($this->vehicle);
                        $doc->exportField($this->_route);
                        $doc->exportField($this->reports_to);
                        $doc->exportField($this->vehicle_freight_type);
                        $doc->exportField($this->vehicle_freight_amount);
                        $doc->exportField($this->material);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->buyer);
                        $doc->exportField($this->agent);
                        $doc->exportField($this->comm);
                        $doc->exportField($this->load_date);
                        $doc->exportField($this->load_weight);
                        $doc->exportField($this->load_km);
                        $doc->exportField($this->gst_percent);
                        $doc->exportField($this->driver);
                        $doc->exportField($this->vehicle_freight_comm);
                        $doc->exportField($this->freight_type);
                        $doc->exportField($this->freight);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
