<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TTripLoadslipAdd extends TTripLoadslip
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TTripLoadslipAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "ttriploadslipadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->vehicle_type->setVisibility();
        $this->vehicle->setVisibility();
        $this->_route->setVisibility();
        $this->route_name->Visible = false;
        $this->driver->setVisibility();
        $this->driver_name->setVisibility();
        $this->reports_to->setVisibility();
        $this->buyer->setVisibility();
        $this->b_consignor->setVisibility();
        $this->b_consignee->setVisibility();
        $this->agent->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 't_trip_loadslip';
        $this->TableName = 't_trip_loadslip';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (t_trip_loadslip)
        if (!isset($GLOBALS["t_trip_loadslip"]) || $GLOBALS["t_trip_loadslip"]::class == PROJECT_NAMESPACE . "t_trip_loadslip") {
            $GLOBALS["t_trip_loadslip"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_loadslip');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "ttriploadslipview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->vehicle_type);
        $this->setupLookupOptions($this->vehicle);
        $this->setupLookupOptions($this->_route);
        $this->setupLookupOptions($this->driver);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->buyer);
        $this->setupLookupOptions($this->b_consignor);
        $this->setupLookupOptions($this->b_consignee);
        $this->setupLookupOptions($this->agent);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("ttriploadsliplist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "ttriploadsliplist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "ttriploadslipview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "ttriploadsliplist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "ttriploadsliplist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->vehicle_type->DefaultValue = $this->vehicle_type->getDefault(); // PHP
        $this->vehicle_type->OldValue = $this->vehicle_type->DefaultValue;
        $this->reports_to->DefaultValue = $this->reports_to->getDefault(); // PHP
        $this->reports_to->OldValue = $this->reports_to->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'vehicle_type' first before field var 'x_vehicle_type'
        $val = $CurrentForm->hasValue("vehicle_type") ? $CurrentForm->getValue("vehicle_type") : $CurrentForm->getValue("x_vehicle_type");
        if (!$this->vehicle_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_type->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_type->setFormValue($val);
            }
        }

        // Check field name 'vehicle' first before field var 'x_vehicle'
        $val = $CurrentForm->hasValue("vehicle") ? $CurrentForm->getValue("vehicle") : $CurrentForm->getValue("x_vehicle");
        if (!$this->vehicle->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle->Visible = false; // Disable update for API request
            } else {
                $this->vehicle->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'route' first before field var 'x__route'
        $val = $CurrentForm->hasValue("route") ? $CurrentForm->getValue("route") : $CurrentForm->getValue("x__route");
        if (!$this->_route->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_route->Visible = false; // Disable update for API request
            } else {
                $this->_route->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'driver' first before field var 'x_driver'
        $val = $CurrentForm->hasValue("driver") ? $CurrentForm->getValue("driver") : $CurrentForm->getValue("x_driver");
        if (!$this->driver->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->driver->Visible = false; // Disable update for API request
            } else {
                $this->driver->setFormValue($val);
            }
        }

        // Check field name 'driver_name' first before field var 'x_driver_name'
        $val = $CurrentForm->hasValue("driver_name") ? $CurrentForm->getValue("driver_name") : $CurrentForm->getValue("x_driver_name");
        if (!$this->driver_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->driver_name->Visible = false; // Disable update for API request
            } else {
                $this->driver_name->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'reports_to' first before field var 'x_reports_to'
        $val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
        if (!$this->reports_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reports_to->Visible = false; // Disable update for API request
            } else {
                $this->reports_to->setFormValue($val);
            }
        }

        // Check field name 'buyer' first before field var 'x_buyer'
        $val = $CurrentForm->hasValue("buyer") ? $CurrentForm->getValue("buyer") : $CurrentForm->getValue("x_buyer");
        if (!$this->buyer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer->Visible = false; // Disable update for API request
            } else {
                $this->buyer->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'b_consignor' first before field var 'x_b_consignor'
        $val = $CurrentForm->hasValue("b_consignor") ? $CurrentForm->getValue("b_consignor") : $CurrentForm->getValue("x_b_consignor");
        if (!$this->b_consignor->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_consignor->Visible = false; // Disable update for API request
            } else {
                $this->b_consignor->setFormValue($val);
            }
        }

        // Check field name 'b_consignee' first before field var 'x_b_consignee'
        $val = $CurrentForm->hasValue("b_consignee") ? $CurrentForm->getValue("b_consignee") : $CurrentForm->getValue("x_b_consignee");
        if (!$this->b_consignee->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_consignee->Visible = false; // Disable update for API request
            } else {
                $this->b_consignee->setFormValue($val);
            }
        }

        // Check field name 'agent' first before field var 'x_agent'
        $val = $CurrentForm->hasValue("agent") ? $CurrentForm->getValue("agent") : $CurrentForm->getValue("x_agent");
        if (!$this->agent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->agent->Visible = false; // Disable update for API request
            } else {
                $this->agent->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->vehicle_type->CurrentValue = $this->vehicle_type->FormValue;
        $this->vehicle->CurrentValue = $this->vehicle->FormValue;
        $this->_route->CurrentValue = $this->_route->FormValue;
        $this->driver->CurrentValue = $this->driver->FormValue;
        $this->driver_name->CurrentValue = $this->driver_name->FormValue;
        $this->reports_to->CurrentValue = $this->reports_to->FormValue;
        $this->buyer->CurrentValue = $this->buyer->FormValue;
        $this->b_consignor->CurrentValue = $this->b_consignor->FormValue;
        $this->b_consignee->CurrentValue = $this->b_consignee->FormValue;
        $this->agent->CurrentValue = $this->agent->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->vehicle_type->setDbValue($row['vehicle_type']);
        $this->vehicle->setDbValue($row['vehicle']);
        $this->_route->setDbValue($row['route']);
        $this->route_name->setDbValue($row['route_name']);
        $this->driver->setDbValue($row['driver']);
        $this->driver_name->setDbValue($row['driver_name']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->buyer->setDbValue($row['buyer']);
        $this->b_consignor->setDbValue($row['b_consignor']);
        $this->b_consignee->setDbValue($row['b_consignee']);
        $this->agent->setDbValue($row['agent']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['vehicle_type'] = $this->vehicle_type->DefaultValue;
        $row['vehicle'] = $this->vehicle->DefaultValue;
        $row['route'] = $this->_route->DefaultValue;
        $row['route_name'] = $this->route_name->DefaultValue;
        $row['driver'] = $this->driver->DefaultValue;
        $row['driver_name'] = $this->driver_name->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['buyer'] = $this->buyer->DefaultValue;
        $row['b_consignor'] = $this->b_consignor->DefaultValue;
        $row['b_consignee'] = $this->b_consignee->DefaultValue;
        $row['agent'] = $this->agent->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // vehicle_type
        $this->vehicle_type->RowCssClass = "row";

        // vehicle
        $this->vehicle->RowCssClass = "row";

        // route
        $this->_route->RowCssClass = "row";

        // route_name
        $this->route_name->RowCssClass = "row";

        // driver
        $this->driver->RowCssClass = "row";

        // driver_name
        $this->driver_name->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // buyer
        $this->buyer->RowCssClass = "row";

        // b_consignor
        $this->b_consignor->RowCssClass = "row";

        // b_consignee
        $this->b_consignee->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // vehicle_type
            if (strval($this->vehicle_type->CurrentValue) != "") {
                $this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
            } else {
                $this->vehicle_type->ViewValue = null;
            }

            // vehicle
            $this->vehicle->ViewValue = $this->vehicle->CurrentValue;
            $curVal = strval($this->vehicle->CurrentValue);
            if ($curVal != "") {
                $this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
                if ($this->vehicle->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
                    } else {
                        $this->vehicle->ViewValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                    }
                }
            } else {
                $this->vehicle->ViewValue = null;
            }

            // route
            $this->_route->ViewValue = $this->_route->CurrentValue;
            $curVal = strval($this->_route->CurrentValue);
            if ($curVal != "") {
                $this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
                if ($this->_route->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                        $this->_route->ViewValue = $this->_route->displayValue($arwrk);
                    } else {
                        $this->_route->ViewValue = FormatNumber($this->_route->CurrentValue, $this->_route->formatPattern());
                    }
                }
            } else {
                $this->_route->ViewValue = null;
            }

            // route_name
            $this->route_name->ViewValue = $this->route_name->CurrentValue;

            // driver
            $this->driver->ViewValue = $this->driver->CurrentValue;
            $curVal = strval($this->driver->CurrentValue);
            if ($curVal != "") {
                $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
                if ($this->driver->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                    $sqlWrk = $this->driver->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->driver->Lookup->renderViewRow($rswrk[0]);
                        $this->driver->ViewValue = $this->driver->displayValue($arwrk);
                    } else {
                        $this->driver->ViewValue = $this->driver->CurrentValue;
                    }
                }
            } else {
                $this->driver->ViewValue = null;
            }

            // driver_name
            $this->driver_name->ViewValue = $this->driver_name->CurrentValue;

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // buyer
            $this->buyer->ViewValue = $this->buyer->CurrentValue;
            $curVal = strval($this->buyer->CurrentValue);
            if ($curVal != "") {
                $this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->ViewValue = FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern());
                    }
                }
            } else {
                $this->buyer->ViewValue = null;
            }

            // b_consignor
            $curVal = strval($this->b_consignor->CurrentValue);
            if ($curVal != "") {
                $this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
                if ($this->b_consignor->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignor->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
                    } else {
                        $this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
                    }
                }
            } else {
                $this->b_consignor->ViewValue = null;
            }

            // b_consignee
            $curVal = strval($this->b_consignee->CurrentValue);
            if ($curVal != "") {
                $this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
                if ($this->b_consignee->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
                    } else {
                        $this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
                    }
                }
            } else {
                $this->b_consignee->ViewValue = null;
            }

            // agent
            $this->agent->ViewValue = $this->agent->CurrentValue;
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern());
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // vehicle_type
            $this->vehicle_type->HrefValue = "";

            // vehicle
            $this->vehicle->HrefValue = "";

            // route
            $this->_route->HrefValue = "";

            // driver
            $this->driver->HrefValue = "";

            // driver_name
            $this->driver_name->HrefValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // buyer
            $this->buyer->HrefValue = "";

            // b_consignor
            $this->b_consignor->HrefValue = "";

            // b_consignee
            $this->b_consignee->HrefValue = "";

            // agent
            $this->agent->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // vehicle_type
            $this->vehicle_type->setupEditAttributes();
            $this->vehicle_type->EditValue = $this->vehicle_type->options(true);
            $this->vehicle_type->PlaceHolder = RemoveHtml($this->vehicle_type->caption());

            // vehicle
            $this->vehicle->setupEditAttributes();
            $this->vehicle->EditValue = $this->vehicle->CurrentValue;
            $curVal = strval($this->vehicle->CurrentValue);
            if ($curVal != "") {
                $this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
                if ($this->vehicle->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
                    } else {
                        $this->vehicle->EditValue = HtmlEncode(FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern()));
                    }
                }
            } else {
                $this->vehicle->EditValue = null;
            }
            $this->vehicle->PlaceHolder = RemoveHtml($this->vehicle->caption());

            // route
            $this->_route->setupEditAttributes();
            $this->_route->EditValue = $this->_route->CurrentValue;
            $curVal = strval($this->_route->CurrentValue);
            if ($curVal != "") {
                $this->_route->EditValue = $this->_route->lookupCacheOption($curVal);
                if ($this->_route->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                        $this->_route->EditValue = $this->_route->displayValue($arwrk);
                    } else {
                        $this->_route->EditValue = HtmlEncode(FormatNumber($this->_route->CurrentValue, $this->_route->formatPattern()));
                    }
                }
            } else {
                $this->_route->EditValue = null;
            }
            $this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

            // driver
            $this->driver->setupEditAttributes();
            $this->driver->EditCustomAttributes = $this->driver->getEditCustomAttributes(); // PHP
            $this->driver->EditValue = $this->driver->CurrentValue;
            $curVal = strval($this->driver->CurrentValue);
            if ($curVal != "") {
                $this->driver->EditValue = $this->driver->lookupCacheOption($curVal);
                if ($this->driver->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                    $sqlWrk = $this->driver->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->driver->Lookup->renderViewRow($rswrk[0]);
                        $this->driver->EditValue = $this->driver->displayValue($arwrk);
                    } else {
                        $this->driver->EditValue = HtmlEncode($this->driver->CurrentValue);
                    }
                }
            } else {
                $this->driver->EditValue = null;
            }
            $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

            // driver_name
            $this->driver_name->setupEditAttributes();
            if (!$this->driver_name->Raw) {
                $this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
            }
            $this->driver_name->EditValue = HtmlEncode($this->driver_name->CurrentValue);
            $this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->CurrentValue));
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->CurrentValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // buyer
            $this->buyer->setupEditAttributes();
            $this->buyer->EditValue = $this->buyer->CurrentValue;
            $curVal = strval($this->buyer->CurrentValue);
            if ($curVal != "") {
                $this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->EditValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->EditValue = HtmlEncode(FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern()));
                    }
                }
            } else {
                $this->buyer->EditValue = null;
            }
            $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

            // b_consignor
            $curVal = trim(strval($this->b_consignor->CurrentValue));
            if ($curVal != "") {
                $this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
            } else {
                $this->b_consignor->ViewValue = $this->b_consignor->Lookup !== null && is_array($this->b_consignor->lookupOptions()) && count($this->b_consignor->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_consignor->ViewValue !== null) { // Load from cache
                $this->b_consignor->EditValue = array_values($this->b_consignor->lookupOptions());
                if ($this->b_consignor->ViewValue == "") {
                    $this->b_consignor->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->b_consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->b_consignor->CurrentValue, $this->b_consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->b_consignor->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_consignor->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->b_consignor->Lookup->renderViewRow($rswrk[0]);
                    $this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
                } else {
                    $this->b_consignor->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->b_consignor->EditValue = $arwrk;
            }
            $this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());

            // b_consignee
            $curVal = trim(strval($this->b_consignee->CurrentValue));
            if ($curVal != "") {
                $this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
            } else {
                $this->b_consignee->ViewValue = $this->b_consignee->Lookup !== null && is_array($this->b_consignee->lookupOptions()) && count($this->b_consignee->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_consignee->ViewValue !== null) { // Load from cache
                $this->b_consignee->EditValue = array_values($this->b_consignee->lookupOptions());
                if ($this->b_consignee->ViewValue == "") {
                    $this->b_consignee->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->b_consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->b_consignee->CurrentValue, $this->b_consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->b_consignee->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_consignee->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->b_consignee->Lookup->renderViewRow($rswrk[0]);
                    $this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
                } else {
                    $this->b_consignee->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->b_consignee->EditValue = $arwrk;
            }
            $this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());

            // agent
            $this->agent->setupEditAttributes();
            $this->agent->EditValue = $this->agent->CurrentValue;
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->EditValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->EditValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->EditValue = HtmlEncode(FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern()));
                    }
                }
            } else {
                $this->agent->EditValue = null;
            }
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // operator

            // datetime

            // Add refer script

            // vehicle_type
            $this->vehicle_type->HrefValue = "";

            // vehicle
            $this->vehicle->HrefValue = "";

            // route
            $this->_route->HrefValue = "";

            // driver
            $this->driver->HrefValue = "";

            // driver_name
            $this->driver_name->HrefValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // buyer
            $this->buyer->HrefValue = "";

            // b_consignor
            $this->b_consignor->HrefValue = "";

            // b_consignee
            $this->b_consignee->HrefValue = "";

            // agent
            $this->agent->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->vehicle_type->Visible && $this->vehicle_type->Required) {
                if (!$this->vehicle_type->IsDetailKey && EmptyValue($this->vehicle_type->FormValue)) {
                    $this->vehicle_type->addErrorMessage(str_replace("%s", $this->vehicle_type->caption(), $this->vehicle_type->RequiredErrorMessage));
                }
            }
            if ($this->vehicle->Visible && $this->vehicle->Required) {
                if (!$this->vehicle->IsDetailKey && EmptyValue($this->vehicle->FormValue)) {
                    $this->vehicle->addErrorMessage(str_replace("%s", $this->vehicle->caption(), $this->vehicle->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->vehicle->FormValue)) {
                $this->vehicle->addErrorMessage($this->vehicle->getErrorMessage(false));
            }
            if ($this->_route->Visible && $this->_route->Required) {
                if (!$this->_route->IsDetailKey && EmptyValue($this->_route->FormValue)) {
                    $this->_route->addErrorMessage(str_replace("%s", $this->_route->caption(), $this->_route->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->_route->FormValue)) {
                $this->_route->addErrorMessage($this->_route->getErrorMessage(false));
            }
            if ($this->driver->Visible && $this->driver->Required) {
                if (!$this->driver->IsDetailKey && EmptyValue($this->driver->FormValue)) {
                    $this->driver->addErrorMessage(str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
                }
            }
            if ($this->driver_name->Visible && $this->driver_name->Required) {
                if (!$this->driver_name->IsDetailKey && EmptyValue($this->driver_name->FormValue)) {
                    $this->driver_name->addErrorMessage(str_replace("%s", $this->driver_name->caption(), $this->driver_name->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->driver_name->FormValue)) {
                $this->driver_name->addErrorMessage($this->driver_name->getErrorMessage(false));
            }
            if ($this->reports_to->Visible && $this->reports_to->Required) {
                if (!$this->reports_to->IsDetailKey && EmptyValue($this->reports_to->FormValue)) {
                    $this->reports_to->addErrorMessage(str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
                }
            }
            if ($this->buyer->Visible && $this->buyer->Required) {
                if (!$this->buyer->IsDetailKey && EmptyValue($this->buyer->FormValue)) {
                    $this->buyer->addErrorMessage(str_replace("%s", $this->buyer->caption(), $this->buyer->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->buyer->FormValue)) {
                $this->buyer->addErrorMessage($this->buyer->getErrorMessage(false));
            }
            if ($this->b_consignor->Visible && $this->b_consignor->Required) {
                if (!$this->b_consignor->IsDetailKey && EmptyValue($this->b_consignor->FormValue)) {
                    $this->b_consignor->addErrorMessage(str_replace("%s", $this->b_consignor->caption(), $this->b_consignor->RequiredErrorMessage));
                }
            }
            if ($this->b_consignee->Visible && $this->b_consignee->Required) {
                if (!$this->b_consignee->IsDetailKey && EmptyValue($this->b_consignee->FormValue)) {
                    $this->b_consignee->addErrorMessage(str_replace("%s", $this->b_consignee->caption(), $this->b_consignee->RequiredErrorMessage));
                }
            }
            if ($this->agent->Visible && $this->agent->Required) {
                if (!$this->agent->IsDetailKey && EmptyValue($this->agent->FormValue)) {
                    $this->agent->addErrorMessage(str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->agent->FormValue)) {
                $this->agent->addErrorMessage($this->agent->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // vehicle_type
        $this->vehicle_type->setDbValueDef($rsnew, $this->vehicle_type->CurrentValue, strval($this->vehicle_type->CurrentValue) == "");

        // vehicle
        $this->vehicle->setDbValueDef($rsnew, $this->vehicle->CurrentValue, false);

        // route
        $this->_route->setDbValueDef($rsnew, $this->_route->CurrentValue, false);

        // driver
        $this->driver->setDbValueDef($rsnew, $this->driver->CurrentValue, false);

        // driver_name
        $this->driver_name->setDbValueDef($rsnew, $this->driver_name->CurrentValue, false);

        // reports_to
        $this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, strval($this->reports_to->CurrentValue) == "");

        // buyer
        $this->buyer->setDbValueDef($rsnew, $this->buyer->CurrentValue, false);

        // b_consignor
        $this->b_consignor->setDbValueDef($rsnew, $this->b_consignor->CurrentValue, false);

        // b_consignee
        $this->b_consignee->setDbValueDef($rsnew, $this->b_consignee->CurrentValue, false);

        // agent
        $this->agent->setDbValueDef($rsnew, $this->agent->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['vehicle_type'])) { // vehicle_type
            $this->vehicle_type->setFormValue($row['vehicle_type']);
        }
        if (isset($row['vehicle'])) { // vehicle
            $this->vehicle->setFormValue($row['vehicle']);
        }
        if (isset($row['route'])) { // route
            $this->_route->setFormValue($row['route']);
        }
        if (isset($row['driver'])) { // driver
            $this->driver->setFormValue($row['driver']);
        }
        if (isset($row['driver_name'])) { // driver_name
            $this->driver_name->setFormValue($row['driver_name']);
        }
        if (isset($row['reports_to'])) { // reports_to
            $this->reports_to->setFormValue($row['reports_to']);
        }
        if (isset($row['buyer'])) { // buyer
            $this->buyer->setFormValue($row['buyer']);
        }
        if (isset($row['b_consignor'])) { // b_consignor
            $this->b_consignor->setFormValue($row['b_consignor']);
        }
        if (isset($row['b_consignee'])) { // b_consignee
            $this->b_consignee->setFormValue($row['b_consignee']);
        }
        if (isset($row['agent'])) { // agent
            $this->agent->setFormValue($row['agent']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ttriploadsliplist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_vehicle_type":
                    break;
                case "x_vehicle":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__route":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_driver":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_consignor":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_consignee":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
