<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TTripInfoSearch extends TTripInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TTripInfoSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "ttripinfosearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->vehicle_type->setVisibility();
        $this->vehicle->setVisibility();
        $this->_route->setVisibility();
        $this->route_name->setVisibility();
        $this->reports_to->setVisibility();
        $this->buyer->setVisibility();
        $this->b_consignor->setVisibility();
        $this->b_consignee->setVisibility();
        $this->load_date->setVisibility();
        $this->load_weight->setVisibility();
        $this->unload_date->setVisibility();
        $this->unload_weight->setVisibility();
        $this->invoice_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->amount->setVisibility();
        $this->delivery_pod->setVisibility();
        $this->status->setVisibility();
        $this->days->setVisibility();
        $this->driver->setVisibility();
        $this->driver_name->setVisibility();
        $this->agent->setVisibility();
        $this->comm->setVisibility();
        $this->material->setVisibility();
        $this->packing_type->setVisibility();
        $this->m_hsn->setVisibility();
        $this->_40->setVisibility();
        $this->lr_no->setVisibility();
        $this->km->setVisibility();
        $this->freight_type->setVisibility();
        $this->freight->setVisibility();
        $this->ded_det->setVisibility();
        $this->ded_det_remarks->setVisibility();
        $this->gst_percent->setVisibility();
        $this->gst_amount->setVisibility();
        $this->final_amount->setVisibility();
        $this->load_km->setVisibility();
        $this->unload_km->setVisibility();
        $this->delivery_receipt->setVisibility();
        $this->delivery_docket->setVisibility();
        $this->diesal_op_b->setVisibility();
        $this->diesal_required->setVisibility();
        $this->diesal_fill->setVisibility();
        $this->diesal_amount->setVisibility();
        $this->diesal_cl_balance->setVisibility();
        $this->vehicle_average->setVisibility();
        $this->cash_required->setVisibility();
        $this->cash_op_b->setVisibility();
        $this->cash_paid->setVisibility();
        $this->cash_expenses->setVisibility();
        $this->cash_cl_balance->setVisibility();
        $this->fasttag_op_b->setVisibility();
        $this->fasttag_recharge->setVisibility();
        $this->fasttag_expenses->setVisibility();
        $this->toll_expenses_cash->setVisibility();
        $this->fasttag_cl_balance->setVisibility();
        $this->remarks->setVisibility();
        $this->uploads->setVisibility();
        $this->consignor->setVisibility();
        $this->vehicle_freight_comm->setVisibility();
        $this->vehicle_freight_type->setVisibility();
        $this->vehicle_freight_amount->setVisibility();
        $this->vehicle_freight_final->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->expenses_id->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 't_trip_info';
        $this->TableName = 't_trip_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (t_trip_info)
        if (!isset($GLOBALS["t_trip_info"]) || $GLOBALS["t_trip_info"]::class == PROJECT_NAMESPACE . "t_trip_info") {
            $GLOBALS["t_trip_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "ttripinfoview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->delivery_receipt->OldUploadPath = $this->delivery_receipt->getUploadPath(); // PHP
                $this->delivery_receipt->UploadPath = $this->delivery_receipt->OldUploadPath;
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->vehicle_type);
        $this->setupLookupOptions($this->vehicle);
        $this->setupLookupOptions($this->_route);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->buyer);
        $this->setupLookupOptions($this->b_consignor);
        $this->setupLookupOptions($this->b_consignee);
        $this->setupLookupOptions($this->delivery_pod);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->driver);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->freight_type);
        $this->setupLookupOptions($this->consignor);
        $this->setupLookupOptions($this->vehicle_freight_type);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "ttripinfolist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->vehicle_type); // vehicle_type
        $this->buildSearchUrl($srchUrl, $this->vehicle); // vehicle
        $this->buildSearchUrl($srchUrl, $this->_route); // route
        $this->buildSearchUrl($srchUrl, $this->route_name); // route_name
        $this->buildSearchUrl($srchUrl, $this->reports_to); // reports_to
        $this->buildSearchUrl($srchUrl, $this->buyer); // buyer
        $this->buildSearchUrl($srchUrl, $this->b_consignor); // b_consignor
        $this->buildSearchUrl($srchUrl, $this->b_consignee); // b_consignee
        $this->buildSearchUrl($srchUrl, $this->load_date); // load_date
        $this->buildSearchUrl($srchUrl, $this->load_weight); // load_weight
        $this->buildSearchUrl($srchUrl, $this->unload_date); // unload_date
        $this->buildSearchUrl($srchUrl, $this->unload_weight); // unload_weight
        $this->buildSearchUrl($srchUrl, $this->invoice_no); // invoice_no
        $this->buildSearchUrl($srchUrl, $this->invoice_date); // invoice_date
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->delivery_pod); // delivery_pod
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->days); // days
        $this->buildSearchUrl($srchUrl, $this->driver); // driver
        $this->buildSearchUrl($srchUrl, $this->driver_name); // driver_name
        $this->buildSearchUrl($srchUrl, $this->agent); // agent
        $this->buildSearchUrl($srchUrl, $this->comm); // comm
        $this->buildSearchUrl($srchUrl, $this->material); // material
        $this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
        $this->buildSearchUrl($srchUrl, $this->m_hsn); // m_hsn
        $this->buildSearchUrl($srchUrl, $this->_40); // @
        $this->buildSearchUrl($srchUrl, $this->lr_no); // lr_no
        $this->buildSearchUrl($srchUrl, $this->km); // km
        $this->buildSearchUrl($srchUrl, $this->freight_type); // freight_type
        $this->buildSearchUrl($srchUrl, $this->freight); // freight
        $this->buildSearchUrl($srchUrl, $this->ded_det); // ded_det
        $this->buildSearchUrl($srchUrl, $this->ded_det_remarks); // ded_det_remarks
        $this->buildSearchUrl($srchUrl, $this->gst_percent); // gst_percent
        $this->buildSearchUrl($srchUrl, $this->gst_amount); // gst_amount
        $this->buildSearchUrl($srchUrl, $this->final_amount); // final_amount
        $this->buildSearchUrl($srchUrl, $this->load_km); // load_km
        $this->buildSearchUrl($srchUrl, $this->unload_km); // unload_km
        $this->buildSearchUrl($srchUrl, $this->delivery_receipt); // delivery_receipt
        $this->buildSearchUrl($srchUrl, $this->delivery_docket); // delivery_docket
        $this->buildSearchUrl($srchUrl, $this->diesal_op_b); // diesal_op_b
        $this->buildSearchUrl($srchUrl, $this->diesal_required); // diesal_required
        $this->buildSearchUrl($srchUrl, $this->diesal_fill); // diesal_fill
        $this->buildSearchUrl($srchUrl, $this->diesal_amount); // diesal_amount
        $this->buildSearchUrl($srchUrl, $this->diesal_cl_balance); // diesal_cl_balance
        $this->buildSearchUrl($srchUrl, $this->vehicle_average); // vehicle_average
        $this->buildSearchUrl($srchUrl, $this->cash_required); // cash_required
        $this->buildSearchUrl($srchUrl, $this->cash_op_b); // cash_op_b
        $this->buildSearchUrl($srchUrl, $this->cash_paid); // cash_paid
        $this->buildSearchUrl($srchUrl, $this->cash_expenses); // cash_expenses
        $this->buildSearchUrl($srchUrl, $this->cash_cl_balance); // cash_cl_balance
        $this->buildSearchUrl($srchUrl, $this->fasttag_op_b); // fasttag_op_b
        $this->buildSearchUrl($srchUrl, $this->fasttag_recharge); // fasttag_recharge
        $this->buildSearchUrl($srchUrl, $this->fasttag_expenses); // fasttag_expenses
        $this->buildSearchUrl($srchUrl, $this->toll_expenses_cash); // toll_expenses_cash
        $this->buildSearchUrl($srchUrl, $this->fasttag_cl_balance); // fasttag_cl_balance
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->uploads); // uploads
        $this->buildSearchUrl($srchUrl, $this->consignor); // consignor
        $this->buildSearchUrl($srchUrl, $this->vehicle_freight_comm); // vehicle_freight_comm
        $this->buildSearchUrl($srchUrl, $this->vehicle_freight_type); // vehicle_freight_type
        $this->buildSearchUrl($srchUrl, $this->vehicle_freight_amount); // vehicle_freight_amount
        $this->buildSearchUrl($srchUrl, $this->vehicle_freight_final); // vehicle_freight_final
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_type
        if ($this->vehicle_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle
        if ($this->vehicle->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // route
        if ($this->_route->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // route_name
        if ($this->route_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reports_to
        if ($this->reports_to->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer
        if ($this->buyer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_consignor
        if ($this->b_consignor->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_consignee
        if ($this->b_consignee->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // load_date
        if ($this->load_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // load_weight
        if ($this->load_weight->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // unload_date
        if ($this->unload_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // unload_weight
        if ($this->unload_weight->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice_no
        if ($this->invoice_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice_date
        if ($this->invoice_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // delivery_pod
        if ($this->delivery_pod->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // days
        if ($this->days->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // driver
        if ($this->driver->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // driver_name
        if ($this->driver_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // agent
        if ($this->agent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // comm
        if ($this->comm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // material
        if ($this->material->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_hsn
        if ($this->m_hsn->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // @
        if ($this->_40->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lr_no
        if ($this->lr_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // km
        if ($this->km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // freight_type
        if ($this->freight_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // freight
        if ($this->freight->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ded_det
        if ($this->ded_det->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ded_det_remarks
        if ($this->ded_det_remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gst_percent
        if ($this->gst_percent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gst_amount
        if ($this->gst_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // final_amount
        if ($this->final_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // load_km
        if ($this->load_km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // unload_km
        if ($this->unload_km->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // delivery_receipt
        if ($this->delivery_receipt->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // delivery_docket
        if ($this->delivery_docket->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // diesal_op_b
        if ($this->diesal_op_b->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // diesal_required
        if ($this->diesal_required->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // diesal_fill
        if ($this->diesal_fill->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // diesal_amount
        if ($this->diesal_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // diesal_cl_balance
        if ($this->diesal_cl_balance->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_average
        if ($this->vehicle_average->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cash_required
        if ($this->cash_required->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cash_op_b
        if ($this->cash_op_b->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cash_paid
        if ($this->cash_paid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cash_expenses
        if ($this->cash_expenses->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cash_cl_balance
        if ($this->cash_cl_balance->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // fasttag_op_b
        if ($this->fasttag_op_b->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // fasttag_recharge
        if ($this->fasttag_recharge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // fasttag_expenses
        if ($this->fasttag_expenses->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // toll_expenses_cash
        if ($this->toll_expenses_cash->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // fasttag_cl_balance
        if ($this->fasttag_cl_balance->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // uploads
        if ($this->uploads->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // consignor
        if ($this->consignor->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_freight_comm
        if ($this->vehicle_freight_comm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_freight_type
        if ($this->vehicle_freight_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_freight_amount
        if ($this->vehicle_freight_amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // vehicle_freight_final
        if ($this->vehicle_freight_final->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // vehicle_type
        $this->vehicle_type->RowCssClass = "row";

        // vehicle
        $this->vehicle->RowCssClass = "row";

        // route
        $this->_route->RowCssClass = "row";

        // route_name
        $this->route_name->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // buyer
        $this->buyer->RowCssClass = "row";

        // b_consignor
        $this->b_consignor->RowCssClass = "row";

        // b_consignee
        $this->b_consignee->RowCssClass = "row";

        // load_date
        $this->load_date->RowCssClass = "row";

        // load_weight
        $this->load_weight->RowCssClass = "row";

        // unload_date
        $this->unload_date->RowCssClass = "row";

        // unload_weight
        $this->unload_weight->RowCssClass = "row";

        // invoice_no
        $this->invoice_no->RowCssClass = "row";

        // invoice_date
        $this->invoice_date->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // delivery_pod
        $this->delivery_pod->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // days
        $this->days->RowCssClass = "row";

        // driver
        $this->driver->RowCssClass = "row";

        // driver_name
        $this->driver_name->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // comm
        $this->comm->RowCssClass = "row";

        // material
        $this->material->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // m_hsn
        $this->m_hsn->RowCssClass = "row";

        // @
        $this->_40->RowCssClass = "row";

        // lr_no
        $this->lr_no->RowCssClass = "row";

        // km
        $this->km->RowCssClass = "row";

        // freight_type
        $this->freight_type->RowCssClass = "row";

        // freight
        $this->freight->RowCssClass = "row";

        // ded_det
        $this->ded_det->RowCssClass = "row";

        // ded_det_remarks
        $this->ded_det_remarks->RowCssClass = "row";

        // gst_percent
        $this->gst_percent->RowCssClass = "row";

        // gst_amount
        $this->gst_amount->RowCssClass = "row";

        // final_amount
        $this->final_amount->RowCssClass = "row";

        // load_km
        $this->load_km->RowCssClass = "row";

        // unload_km
        $this->unload_km->RowCssClass = "row";

        // delivery_receipt
        $this->delivery_receipt->RowCssClass = "row";

        // delivery_docket
        $this->delivery_docket->RowCssClass = "row";

        // diesal_op_b
        $this->diesal_op_b->RowCssClass = "row";

        // diesal_required
        $this->diesal_required->RowCssClass = "row";

        // diesal_fill
        $this->diesal_fill->RowCssClass = "row";

        // diesal_amount
        $this->diesal_amount->RowCssClass = "row";

        // diesal_cl_balance
        $this->diesal_cl_balance->RowCssClass = "row";

        // vehicle_average
        $this->vehicle_average->RowCssClass = "row";

        // cash_required
        $this->cash_required->RowCssClass = "row";

        // cash_op_b
        $this->cash_op_b->RowCssClass = "row";

        // cash_paid
        $this->cash_paid->RowCssClass = "row";

        // cash_expenses
        $this->cash_expenses->RowCssClass = "row";

        // cash_cl_balance
        $this->cash_cl_balance->RowCssClass = "row";

        // fasttag_op_b
        $this->fasttag_op_b->RowCssClass = "row";

        // fasttag_recharge
        $this->fasttag_recharge->RowCssClass = "row";

        // fasttag_expenses
        $this->fasttag_expenses->RowCssClass = "row";

        // toll_expenses_cash
        $this->toll_expenses_cash->RowCssClass = "row";

        // fasttag_cl_balance
        $this->fasttag_cl_balance->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // consignor
        $this->consignor->RowCssClass = "row";

        // vehicle_freight_comm
        $this->vehicle_freight_comm->RowCssClass = "row";

        // vehicle_freight_type
        $this->vehicle_freight_type->RowCssClass = "row";

        // vehicle_freight_amount
        $this->vehicle_freight_amount->RowCssClass = "row";

        // vehicle_freight_final
        $this->vehicle_freight_final->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // expenses_id
        $this->expenses_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // vehicle_type
            if (strval($this->vehicle_type->CurrentValue) != "") {
                $this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
            } else {
                $this->vehicle_type->ViewValue = null;
            }

            // vehicle
            $this->vehicle->ViewValue = $this->vehicle->CurrentValue;
            $curVal = strval($this->vehicle->CurrentValue);
            if ($curVal != "") {
                $this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
                if ($this->vehicle->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
                    } else {
                        $this->vehicle->ViewValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                    }
                }
            } else {
                $this->vehicle->ViewValue = null;
            }

            // route
            $this->_route->ViewValue = $this->_route->CurrentValue;
            $curVal = strval($this->_route->CurrentValue);
            if ($curVal != "") {
                $this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
                if ($this->_route->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                        $this->_route->ViewValue = $this->_route->displayValue($arwrk);
                    } else {
                        $this->_route->ViewValue = FormatNumber($this->_route->CurrentValue, $this->_route->formatPattern());
                    }
                }
            } else {
                $this->_route->ViewValue = null;
            }

            // route_name
            $this->route_name->ViewValue = $this->route_name->CurrentValue;

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // buyer
            $this->buyer->ViewValue = $this->buyer->CurrentValue;
            $curVal = strval($this->buyer->CurrentValue);
            if ($curVal != "") {
                $this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->ViewValue = FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern());
                    }
                }
            } else {
                $this->buyer->ViewValue = null;
            }

            // b_consignor
            $this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
            $curVal = strval($this->b_consignor->CurrentValue);
            if ($curVal != "") {
                $this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
                if ($this->b_consignor->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignor->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
                    } else {
                        $this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
                    }
                }
            } else {
                $this->b_consignor->ViewValue = null;
            }

            // b_consignee
            $this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
            $curVal = strval($this->b_consignee->CurrentValue);
            if ($curVal != "") {
                $this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
                if ($this->b_consignee->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
                    } else {
                        $this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
                    }
                }
            } else {
                $this->b_consignee->ViewValue = null;
            }

            // load_date
            $this->load_date->ViewValue = $this->load_date->CurrentValue;
            $this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, $this->load_date->formatPattern());

            // load_weight
            $this->load_weight->ViewValue = $this->load_weight->CurrentValue;
            $this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, $this->load_weight->formatPattern());

            // unload_date
            $this->unload_date->ViewValue = $this->unload_date->CurrentValue;
            $this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, $this->unload_date->formatPattern());

            // unload_weight
            $this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
            $this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, $this->unload_weight->formatPattern());

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
            $this->invoice_no->ViewValue = FormatNumber($this->invoice_no->ViewValue, $this->invoice_no->formatPattern());

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // delivery_pod
            if (strval($this->delivery_pod->CurrentValue) != "") {
                $this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
            } else {
                $this->delivery_pod->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // days
            $this->days->ViewValue = $this->days->CurrentValue;
            $this->days->ViewValue = FormatNumber($this->days->ViewValue, $this->days->formatPattern());

            // driver
            $curVal = strval($this->driver->CurrentValue);
            if ($curVal != "") {
                $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
                if ($this->driver->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                    $sqlWrk = $this->driver->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->driver->Lookup->renderViewRow($rswrk[0]);
                        $this->driver->ViewValue = $this->driver->displayValue($arwrk);
                    } else {
                        $this->driver->ViewValue = $this->driver->CurrentValue;
                    }
                }
            } else {
                $this->driver->ViewValue = null;
            }

            // driver_name
            $this->driver_name->ViewValue = $this->driver_name->CurrentValue;

            // agent
            $this->agent->ViewValue = $this->agent->CurrentValue;
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern());
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // comm
            $this->comm->ViewValue = $this->comm->CurrentValue;
            $this->comm->ViewValue = FormatNumber($this->comm->ViewValue, $this->comm->formatPattern());

            // material
            $this->material->ViewValue = $this->material->CurrentValue;

            // packing_type
            $this->packing_type->ViewValue = $this->packing_type->CurrentValue;

            // m_hsn
            $this->m_hsn->ViewValue = $this->m_hsn->CurrentValue;

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;
            $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

            // lr_no
            $this->lr_no->ViewValue = $this->lr_no->CurrentValue;

            // km
            $this->km->ViewValue = $this->km->CurrentValue;
            $this->km->ViewValue = FormatNumber($this->km->ViewValue, $this->km->formatPattern());

            // freight_type
            if (strval($this->freight_type->CurrentValue) != "") {
                $this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
            } else {
                $this->freight_type->ViewValue = null;
            }

            // freight
            $this->freight->ViewValue = $this->freight->CurrentValue;
            $this->freight->ViewValue = FormatNumber($this->freight->ViewValue, $this->freight->formatPattern());

            // ded_det
            $this->ded_det->ViewValue = $this->ded_det->CurrentValue;
            $this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, $this->ded_det->formatPattern());

            // ded_det_remarks
            $this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;

            // gst_percent
            $this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
            $this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, $this->gst_percent->formatPattern());

            // gst_amount
            $this->gst_amount->ViewValue = $this->gst_amount->CurrentValue;
            $this->gst_amount->ViewValue = FormatNumber($this->gst_amount->ViewValue, $this->gst_amount->formatPattern());

            // final_amount
            $this->final_amount->ViewValue = $this->final_amount->CurrentValue;
            $this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, $this->final_amount->formatPattern());

            // load_km
            $this->load_km->ViewValue = $this->load_km->CurrentValue;
            $this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, $this->load_km->formatPattern());

            // unload_km
            $this->unload_km->ViewValue = $this->unload_km->CurrentValue;
            $this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, $this->unload_km->formatPattern());

            // delivery_receipt
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
            if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
                $this->delivery_receipt->ImageWidth = 0;
                $this->delivery_receipt->ImageHeight = 50;
                $this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
                $this->delivery_receipt->ImageCssClass = "ew-image";
                $this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
            } else {
                $this->delivery_receipt->ViewValue = "";
            }

            // delivery_docket
            $this->delivery_docket->ViewValue = $this->delivery_docket->CurrentValue;

            // diesal_op_b
            $this->diesal_op_b->ViewValue = $this->diesal_op_b->CurrentValue;
            $this->diesal_op_b->ViewValue = FormatNumber($this->diesal_op_b->ViewValue, $this->diesal_op_b->formatPattern());

            // diesal_required
            $this->diesal_required->ViewValue = $this->diesal_required->CurrentValue;
            $this->diesal_required->ViewValue = FormatNumber($this->diesal_required->ViewValue, $this->diesal_required->formatPattern());

            // diesal_fill
            $this->diesal_fill->ViewValue = $this->diesal_fill->CurrentValue;
            $this->diesal_fill->ViewValue = FormatNumber($this->diesal_fill->ViewValue, $this->diesal_fill->formatPattern());

            // diesal_amount
            $this->diesal_amount->ViewValue = $this->diesal_amount->CurrentValue;
            $this->diesal_amount->ViewValue = FormatNumber($this->diesal_amount->ViewValue, $this->diesal_amount->formatPattern());

            // diesal_cl_balance
            $this->diesal_cl_balance->ViewValue = $this->diesal_cl_balance->CurrentValue;
            $this->diesal_cl_balance->ViewValue = FormatNumber($this->diesal_cl_balance->ViewValue, $this->diesal_cl_balance->formatPattern());

            // vehicle_average
            $this->vehicle_average->ViewValue = $this->vehicle_average->CurrentValue;
            $this->vehicle_average->ViewValue = FormatNumber($this->vehicle_average->ViewValue, $this->vehicle_average->formatPattern());

            // cash_required
            $this->cash_required->ViewValue = $this->cash_required->CurrentValue;
            $this->cash_required->ViewValue = FormatNumber($this->cash_required->ViewValue, $this->cash_required->formatPattern());

            // cash_op_b
            $this->cash_op_b->ViewValue = $this->cash_op_b->CurrentValue;
            $this->cash_op_b->ViewValue = FormatNumber($this->cash_op_b->ViewValue, $this->cash_op_b->formatPattern());

            // cash_paid
            $this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
            $this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, $this->cash_paid->formatPattern());

            // cash_expenses
            $this->cash_expenses->ViewValue = $this->cash_expenses->CurrentValue;
            $this->cash_expenses->ViewValue = FormatNumber($this->cash_expenses->ViewValue, $this->cash_expenses->formatPattern());

            // cash_cl_balance
            $this->cash_cl_balance->ViewValue = $this->cash_cl_balance->CurrentValue;
            $this->cash_cl_balance->ViewValue = FormatNumber($this->cash_cl_balance->ViewValue, $this->cash_cl_balance->formatPattern());

            // fasttag_op_b
            $this->fasttag_op_b->ViewValue = $this->fasttag_op_b->CurrentValue;
            $this->fasttag_op_b->ViewValue = FormatNumber($this->fasttag_op_b->ViewValue, $this->fasttag_op_b->formatPattern());

            // fasttag_recharge
            $this->fasttag_recharge->ViewValue = $this->fasttag_recharge->CurrentValue;
            $this->fasttag_recharge->ViewValue = FormatNumber($this->fasttag_recharge->ViewValue, $this->fasttag_recharge->formatPattern());

            // fasttag_expenses
            $this->fasttag_expenses->ViewValue = $this->fasttag_expenses->CurrentValue;
            $this->fasttag_expenses->ViewValue = FormatNumber($this->fasttag_expenses->ViewValue, $this->fasttag_expenses->formatPattern());

            // toll_expenses_cash
            $this->toll_expenses_cash->ViewValue = $this->toll_expenses_cash->CurrentValue;
            $this->toll_expenses_cash->ViewValue = FormatNumber($this->toll_expenses_cash->ViewValue, $this->toll_expenses_cash->formatPattern());

            // fasttag_cl_balance
            $this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
            $this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, $this->fasttag_cl_balance->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // consignor
            $this->consignor->ViewValue = $this->consignor->CurrentValue;
            $curVal = strval($this->consignor->CurrentValue);
            if ($curVal != "") {
                $this->consignor->ViewValue = $this->consignor->lookupCacheOption($curVal);
                if ($this->consignor->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignor->Lookup->renderViewRow($rswrk[0]);
                        $this->consignor->ViewValue = $this->consignor->displayValue($arwrk);
                    } else {
                        $this->consignor->ViewValue = FormatNumber($this->consignor->CurrentValue, $this->consignor->formatPattern());
                    }
                }
            } else {
                $this->consignor->ViewValue = null;
            }

            // vehicle_freight_comm
            $this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
            $this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, $this->vehicle_freight_comm->formatPattern());

            // vehicle_freight_type
            if (strval($this->vehicle_freight_type->CurrentValue) != "") {
                $this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
            } else {
                $this->vehicle_freight_type->ViewValue = null;
            }

            // vehicle_freight_amount
            $this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
            $this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, $this->vehicle_freight_amount->formatPattern());

            // vehicle_freight_final
            $this->vehicle_freight_final->ViewValue = $this->vehicle_freight_final->CurrentValue;
            $this->vehicle_freight_final->ViewValue = FormatNumber($this->vehicle_freight_final->ViewValue, $this->vehicle_freight_final->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // vehicle_type
            $this->vehicle_type->HrefValue = "";
            $this->vehicle_type->TooltipValue = "";

            // vehicle
            $this->vehicle->HrefValue = "";
            $this->vehicle->TooltipValue = "";

            // route
            $this->_route->HrefValue = "";
            $this->_route->TooltipValue = "";

            // route_name
            $this->route_name->HrefValue = "";
            $this->route_name->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // buyer
            $this->buyer->HrefValue = "";
            $this->buyer->TooltipValue = "";

            // b_consignor
            $this->b_consignor->HrefValue = "";
            $this->b_consignor->TooltipValue = "";

            // b_consignee
            $this->b_consignee->HrefValue = "";
            $this->b_consignee->TooltipValue = "";

            // load_date
            $this->load_date->HrefValue = "";
            $this->load_date->TooltipValue = "";

            // load_weight
            $this->load_weight->HrefValue = "";
            $this->load_weight->TooltipValue = "";

            // unload_date
            $this->unload_date->HrefValue = "";
            $this->unload_date->TooltipValue = "";

            // unload_weight
            $this->unload_weight->HrefValue = "";
            $this->unload_weight->TooltipValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";
            $this->invoice_no->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // delivery_pod
            $this->delivery_pod->HrefValue = "";
            $this->delivery_pod->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // days
            $this->days->HrefValue = "";
            $this->days->TooltipValue = "";

            // driver
            $this->driver->HrefValue = "";
            $this->driver->TooltipValue = "";

            // driver_name
            $this->driver_name->HrefValue = "";
            $this->driver_name->TooltipValue = "";

            // agent
            $this->agent->HrefValue = "";
            $this->agent->TooltipValue = "";

            // comm
            $this->comm->HrefValue = "";
            $this->comm->TooltipValue = "";

            // material
            $this->material->HrefValue = "";
            $this->material->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // m_hsn
            $this->m_hsn->HrefValue = "";
            $this->m_hsn->TooltipValue = "";

            // @
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // lr_no
            $this->lr_no->HrefValue = "";
            $this->lr_no->TooltipValue = "";

            // km
            $this->km->HrefValue = "";
            $this->km->TooltipValue = "";

            // freight_type
            $this->freight_type->HrefValue = "";
            $this->freight_type->TooltipValue = "";

            // freight
            $this->freight->HrefValue = "";
            $this->freight->TooltipValue = "";

            // ded_det
            $this->ded_det->HrefValue = "";
            $this->ded_det->TooltipValue = "";

            // ded_det_remarks
            $this->ded_det_remarks->HrefValue = "";
            $this->ded_det_remarks->TooltipValue = "";

            // gst_percent
            $this->gst_percent->HrefValue = "";
            $this->gst_percent->TooltipValue = "";

            // gst_amount
            $this->gst_amount->HrefValue = "";
            $this->gst_amount->TooltipValue = "";

            // final_amount
            $this->final_amount->HrefValue = "";
            $this->final_amount->TooltipValue = "";

            // load_km
            $this->load_km->HrefValue = "";
            $this->load_km->TooltipValue = "";

            // unload_km
            $this->unload_km->HrefValue = "";
            $this->unload_km->TooltipValue = "";

            // delivery_receipt
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
            if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
                $this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
                $this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
                }
            } else {
                $this->delivery_receipt->HrefValue = "";
            }
            $this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;
            $this->delivery_receipt->TooltipValue = "";
            if ($this->delivery_receipt->UseColorbox) {
                if (EmptyValue($this->delivery_receipt->TooltipValue)) {
                    $this->delivery_receipt->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->delivery_receipt->LinkAttrs["data-rel"] = "t_trip_info_x_delivery_receipt";
                $this->delivery_receipt->LinkAttrs->appendClass("ew-lightbox");
            }

            // delivery_docket
            $this->delivery_docket->HrefValue = "";
            $this->delivery_docket->TooltipValue = "";

            // diesal_op_b
            $this->diesal_op_b->HrefValue = "";
            $this->diesal_op_b->TooltipValue = "";

            // diesal_required
            $this->diesal_required->HrefValue = "";
            $this->diesal_required->TooltipValue = "";

            // diesal_fill
            $this->diesal_fill->HrefValue = "";
            $this->diesal_fill->TooltipValue = "";

            // diesal_amount
            $this->diesal_amount->HrefValue = "";
            $this->diesal_amount->TooltipValue = "";

            // diesal_cl_balance
            $this->diesal_cl_balance->HrefValue = "";
            $this->diesal_cl_balance->TooltipValue = "";

            // vehicle_average
            $this->vehicle_average->HrefValue = "";
            $this->vehicle_average->TooltipValue = "";

            // cash_required
            $this->cash_required->HrefValue = "";
            $this->cash_required->TooltipValue = "";

            // cash_op_b
            $this->cash_op_b->HrefValue = "";
            $this->cash_op_b->TooltipValue = "";

            // cash_paid
            $this->cash_paid->HrefValue = "";
            $this->cash_paid->TooltipValue = "";

            // cash_expenses
            $this->cash_expenses->HrefValue = "";
            $this->cash_expenses->TooltipValue = "";

            // cash_cl_balance
            $this->cash_cl_balance->HrefValue = "";
            $this->cash_cl_balance->TooltipValue = "";

            // fasttag_op_b
            $this->fasttag_op_b->HrefValue = "";
            $this->fasttag_op_b->TooltipValue = "";

            // fasttag_recharge
            $this->fasttag_recharge->HrefValue = "";
            $this->fasttag_recharge->TooltipValue = "";

            // fasttag_expenses
            $this->fasttag_expenses->HrefValue = "";
            $this->fasttag_expenses->TooltipValue = "";

            // toll_expenses_cash
            $this->toll_expenses_cash->HrefValue = "";
            $this->toll_expenses_cash->TooltipValue = "";

            // fasttag_cl_balance
            $this->fasttag_cl_balance->HrefValue = "";
            $this->fasttag_cl_balance->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->htmlDecode($this->uploads->Upload->DbValue)); // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
            $this->uploads->TooltipValue = "";
            if ($this->uploads->UseColorbox) {
                if (EmptyValue($this->uploads->TooltipValue)) {
                    $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->uploads->LinkAttrs["data-rel"] = "t_trip_info_x_uploads";
                $this->uploads->LinkAttrs->appendClass("ew-lightbox");
            }

            // consignor
            $this->consignor->HrefValue = "";
            $this->consignor->TooltipValue = "";

            // vehicle_freight_comm
            $this->vehicle_freight_comm->HrefValue = "";
            $this->vehicle_freight_comm->TooltipValue = "";

            // vehicle_freight_type
            $this->vehicle_freight_type->HrefValue = "";
            $this->vehicle_freight_type->TooltipValue = "";

            // vehicle_freight_amount
            $this->vehicle_freight_amount->HrefValue = "";
            $this->vehicle_freight_amount->TooltipValue = "";

            // vehicle_freight_final
            $this->vehicle_freight_final->HrefValue = "";
            $this->vehicle_freight_final->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // vehicle_type
            $this->vehicle_type->setupEditAttributes();
            $this->vehicle_type->EditValue = $this->vehicle_type->options(true);
            $this->vehicle_type->PlaceHolder = RemoveHtml($this->vehicle_type->caption());

            // vehicle
            $this->vehicle->setupEditAttributes();
            $this->vehicle->EditValue = $this->vehicle->AdvancedSearch->SearchValue;
            $curVal = strval($this->vehicle->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
                if ($this->vehicle->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
                    } else {
                        $this->vehicle->EditValue = HtmlEncode(FormatNumber($this->vehicle->AdvancedSearch->SearchValue, $this->vehicle->formatPattern()));
                    }
                }
            } else {
                $this->vehicle->EditValue = null;
            }
            $this->vehicle->PlaceHolder = RemoveHtml($this->vehicle->caption());

            // route
            $this->_route->setupEditAttributes();
            $this->_route->EditValue = $this->_route->AdvancedSearch->SearchValue;
            $curVal = strval($this->_route->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->_route->EditValue = $this->_route->lookupCacheOption($curVal);
                if ($this->_route->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                        $this->_route->EditValue = $this->_route->displayValue($arwrk);
                    } else {
                        $this->_route->EditValue = HtmlEncode(FormatNumber($this->_route->AdvancedSearch->SearchValue, $this->_route->formatPattern()));
                    }
                }
            } else {
                $this->_route->EditValue = null;
            }
            $this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

            // route_name
            $this->route_name->setupEditAttributes();
            if (!$this->route_name->Raw) {
                $this->route_name->AdvancedSearch->SearchValue = HtmlDecode($this->route_name->AdvancedSearch->SearchValue);
            }
            $this->route_name->EditValue = HtmlEncode($this->route_name->AdvancedSearch->SearchValue);
            $this->route_name->PlaceHolder = RemoveHtml($this->route_name->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->AdvancedSearch->SearchValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // buyer
            $this->buyer->setupEditAttributes();
            $this->buyer->EditValue = $this->buyer->AdvancedSearch->SearchValue;
            $curVal = strval($this->buyer->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->EditValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->EditValue = HtmlEncode(FormatNumber($this->buyer->AdvancedSearch->SearchValue, $this->buyer->formatPattern()));
                    }
                }
            } else {
                $this->buyer->EditValue = null;
            }
            $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

            // b_consignor
            $this->b_consignor->setupEditAttributes();
            $this->b_consignor->EditValue = $this->b_consignor->AdvancedSearch->SearchValue;
            $curVal = strval($this->b_consignor->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->b_consignor->EditValue = $this->b_consignor->lookupCacheOption($curVal);
                if ($this->b_consignor->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignor->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignor->EditValue = $this->b_consignor->displayValue($arwrk);
                    } else {
                        $this->b_consignor->EditValue = HtmlEncode($this->b_consignor->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->b_consignor->EditValue = null;
            }
            $this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());
            $this->b_consignor->setupEditAttributes();
            $this->b_consignor->EditValue2 = $this->b_consignor->AdvancedSearch->SearchValue2;
            $curVal = strval($this->b_consignor->AdvancedSearch->SearchValue2);
            if ($curVal != "") {
                $this->b_consignor->EditValue2 = $this->b_consignor->lookupCacheOption($curVal);
                if ($this->b_consignor->EditValue2 === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignor->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignor->EditValue2 = $this->b_consignor->displayValue($arwrk);
                    } else {
                        $this->b_consignor->EditValue2 = HtmlEncode($this->b_consignor->AdvancedSearch->SearchValue2);
                    }
                }
            } else {
                $this->b_consignor->EditValue2 = null;
            }
            $this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());

            // b_consignee
            $this->b_consignee->setupEditAttributes();
            $this->b_consignee->EditValue = $this->b_consignee->AdvancedSearch->SearchValue;
            $curVal = strval($this->b_consignee->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->b_consignee->EditValue = $this->b_consignee->lookupCacheOption($curVal);
                if ($this->b_consignee->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignee->EditValue = $this->b_consignee->displayValue($arwrk);
                    } else {
                        $this->b_consignee->EditValue = HtmlEncode($this->b_consignee->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->b_consignee->EditValue = null;
            }
            $this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());
            $this->b_consignee->setupEditAttributes();
            $this->b_consignee->EditValue2 = $this->b_consignee->AdvancedSearch->SearchValue2;
            $curVal = strval($this->b_consignee->AdvancedSearch->SearchValue2);
            if ($curVal != "") {
                $this->b_consignee->EditValue2 = $this->b_consignee->lookupCacheOption($curVal);
                if ($this->b_consignee->EditValue2 === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignee->EditValue2 = $this->b_consignee->displayValue($arwrk);
                    } else {
                        $this->b_consignee->EditValue2 = HtmlEncode($this->b_consignee->AdvancedSearch->SearchValue2);
                    }
                }
            } else {
                $this->b_consignee->EditValue2 = null;
            }
            $this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());

            // load_date
            $this->load_date->setupEditAttributes();
            $this->load_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->load_date->AdvancedSearch->SearchValue, $this->load_date->formatPattern()), $this->load_date->formatPattern()));
            $this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

            // load_weight
            $this->load_weight->setupEditAttributes();
            $this->load_weight->EditValue = $this->load_weight->AdvancedSearch->SearchValue;
            $this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());

            // unload_date
            $this->unload_date->setupEditAttributes();
            $this->unload_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->unload_date->AdvancedSearch->SearchValue, $this->unload_date->formatPattern()), $this->unload_date->formatPattern()));
            $this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

            // unload_weight
            $this->unload_weight->setupEditAttributes();
            $this->unload_weight->EditValue = $this->unload_weight->AdvancedSearch->SearchValue;
            $this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());

            // invoice_no
            $this->invoice_no->setupEditAttributes();
            $this->invoice_no->EditValue = $this->invoice_no->AdvancedSearch->SearchValue;
            $this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

            // invoice_date
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue, $this->invoice_date->formatPattern()), $this->invoice_date->formatPattern()));
            $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue2, $this->invoice_date->formatPattern()), $this->invoice_date->formatPattern()));
            $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->AdvancedSearch->SearchValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // delivery_pod
            $this->delivery_pod->EditValue = $this->delivery_pod->options(false);
            $this->delivery_pod->PlaceHolder = RemoveHtml($this->delivery_pod->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // days
            $this->days->setupEditAttributes();
            $this->days->EditValue = $this->days->AdvancedSearch->SearchValue;
            $this->days->PlaceHolder = RemoveHtml($this->days->caption());

            // driver
            $this->driver->setupEditAttributes();
            $curVal = trim(strval($this->driver->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->driver->AdvancedSearch->ViewValue = $this->driver->lookupCacheOption($curVal);
            } else {
                $this->driver->AdvancedSearch->ViewValue = $this->driver->Lookup !== null && is_array($this->driver->lookupOptions()) && count($this->driver->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->driver->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->driver->EditValue = array_values($this->driver->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->driver->AdvancedSearch->SearchValue, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                $sqlWrk = $this->driver->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->driver->EditValue = $arwrk;
            }
            $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

            // driver_name
            $this->driver_name->setupEditAttributes();
            if (!$this->driver_name->Raw) {
                $this->driver_name->AdvancedSearch->SearchValue = HtmlDecode($this->driver_name->AdvancedSearch->SearchValue);
            }
            $this->driver_name->EditValue = HtmlEncode($this->driver_name->AdvancedSearch->SearchValue);
            $this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

            // agent
            $this->agent->setupEditAttributes();
            $this->agent->EditValue = $this->agent->AdvancedSearch->SearchValue;
            $curVal = strval($this->agent->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->agent->EditValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->EditValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->EditValue = HtmlEncode(FormatNumber($this->agent->AdvancedSearch->SearchValue, $this->agent->formatPattern()));
                    }
                }
            } else {
                $this->agent->EditValue = null;
            }
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // comm
            $this->comm->setupEditAttributes();
            $this->comm->EditValue = $this->comm->AdvancedSearch->SearchValue;
            $this->comm->PlaceHolder = RemoveHtml($this->comm->caption());

            // material
            $this->material->setupEditAttributes();
            if (!$this->material->Raw) {
                $this->material->AdvancedSearch->SearchValue = HtmlDecode($this->material->AdvancedSearch->SearchValue);
            }
            $this->material->EditValue = HtmlEncode($this->material->AdvancedSearch->SearchValue);
            $this->material->PlaceHolder = RemoveHtml($this->material->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            if (!$this->packing_type->Raw) {
                $this->packing_type->AdvancedSearch->SearchValue = HtmlDecode($this->packing_type->AdvancedSearch->SearchValue);
            }
            $this->packing_type->EditValue = HtmlEncode($this->packing_type->AdvancedSearch->SearchValue);
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // m_hsn
            $this->m_hsn->setupEditAttributes();
            if (!$this->m_hsn->Raw) {
                $this->m_hsn->AdvancedSearch->SearchValue = HtmlDecode($this->m_hsn->AdvancedSearch->SearchValue);
            }
            $this->m_hsn->EditValue = HtmlEncode($this->m_hsn->AdvancedSearch->SearchValue);
            $this->m_hsn->PlaceHolder = RemoveHtml($this->m_hsn->caption());

            // @
            $this->_40->setupEditAttributes();
            $this->_40->EditValue = $this->_40->AdvancedSearch->SearchValue;
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

            // lr_no
            $this->lr_no->setupEditAttributes();
            if (!$this->lr_no->Raw) {
                $this->lr_no->AdvancedSearch->SearchValue = HtmlDecode($this->lr_no->AdvancedSearch->SearchValue);
            }
            $this->lr_no->EditValue = HtmlEncode($this->lr_no->AdvancedSearch->SearchValue);
            $this->lr_no->PlaceHolder = RemoveHtml($this->lr_no->caption());

            // km
            $this->km->setupEditAttributes();
            $this->km->EditValue = $this->km->AdvancedSearch->SearchValue;
            $this->km->PlaceHolder = RemoveHtml($this->km->caption());

            // freight_type
            $this->freight_type->setupEditAttributes();
            $this->freight_type->EditValue = $this->freight_type->options(true);
            $this->freight_type->PlaceHolder = RemoveHtml($this->freight_type->caption());

            // freight
            $this->freight->setupEditAttributes();
            $this->freight->EditValue = $this->freight->AdvancedSearch->SearchValue;
            $this->freight->PlaceHolder = RemoveHtml($this->freight->caption());

            // ded_det
            $this->ded_det->setupEditAttributes();
            $this->ded_det->EditValue = $this->ded_det->AdvancedSearch->SearchValue;
            $this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());

            // ded_det_remarks
            $this->ded_det_remarks->setupEditAttributes();
            if (!$this->ded_det_remarks->Raw) {
                $this->ded_det_remarks->AdvancedSearch->SearchValue = HtmlDecode($this->ded_det_remarks->AdvancedSearch->SearchValue);
            }
            $this->ded_det_remarks->EditValue = HtmlEncode($this->ded_det_remarks->AdvancedSearch->SearchValue);
            $this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

            // gst_percent
            $this->gst_percent->setupEditAttributes();
            $this->gst_percent->EditValue = $this->gst_percent->AdvancedSearch->SearchValue;
            $this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());

            // gst_amount
            $this->gst_amount->setupEditAttributes();
            $this->gst_amount->EditValue = $this->gst_amount->AdvancedSearch->SearchValue;
            $this->gst_amount->PlaceHolder = RemoveHtml($this->gst_amount->caption());

            // final_amount
            $this->final_amount->setupEditAttributes();
            $this->final_amount->EditValue = $this->final_amount->AdvancedSearch->SearchValue;
            $this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());

            // load_km
            $this->load_km->setupEditAttributes();
            $this->load_km->EditValue = $this->load_km->AdvancedSearch->SearchValue;
            $this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());

            // unload_km
            $this->unload_km->setupEditAttributes();
            $this->unload_km->EditValue = $this->unload_km->AdvancedSearch->SearchValue;
            $this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());

            // delivery_receipt
            $this->delivery_receipt->setupEditAttributes();
            if (!$this->delivery_receipt->Raw) {
                $this->delivery_receipt->AdvancedSearch->SearchValue = HtmlDecode($this->delivery_receipt->AdvancedSearch->SearchValue);
            }
            $this->delivery_receipt->EditValue = HtmlEncode($this->delivery_receipt->AdvancedSearch->SearchValue);
            $this->delivery_receipt->PlaceHolder = RemoveHtml($this->delivery_receipt->caption());

            // delivery_docket
            $this->delivery_docket->setupEditAttributes();
            if (!$this->delivery_docket->Raw) {
                $this->delivery_docket->AdvancedSearch->SearchValue = HtmlDecode($this->delivery_docket->AdvancedSearch->SearchValue);
            }
            $this->delivery_docket->EditValue = HtmlEncode($this->delivery_docket->AdvancedSearch->SearchValue);
            $this->delivery_docket->PlaceHolder = RemoveHtml($this->delivery_docket->caption());

            // diesal_op_b
            $this->diesal_op_b->setupEditAttributes();
            $this->diesal_op_b->EditValue = $this->diesal_op_b->AdvancedSearch->SearchValue;
            $this->diesal_op_b->PlaceHolder = RemoveHtml($this->diesal_op_b->caption());

            // diesal_required
            $this->diesal_required->setupEditAttributes();
            $this->diesal_required->EditValue = $this->diesal_required->AdvancedSearch->SearchValue;
            $this->diesal_required->PlaceHolder = RemoveHtml($this->diesal_required->caption());

            // diesal_fill
            $this->diesal_fill->setupEditAttributes();
            $this->diesal_fill->EditValue = $this->diesal_fill->AdvancedSearch->SearchValue;
            $this->diesal_fill->PlaceHolder = RemoveHtml($this->diesal_fill->caption());

            // diesal_amount
            $this->diesal_amount->setupEditAttributes();
            $this->diesal_amount->EditValue = $this->diesal_amount->AdvancedSearch->SearchValue;
            $this->diesal_amount->PlaceHolder = RemoveHtml($this->diesal_amount->caption());

            // diesal_cl_balance
            $this->diesal_cl_balance->setupEditAttributes();
            $this->diesal_cl_balance->EditValue = $this->diesal_cl_balance->AdvancedSearch->SearchValue;
            $this->diesal_cl_balance->PlaceHolder = RemoveHtml($this->diesal_cl_balance->caption());

            // vehicle_average
            $this->vehicle_average->setupEditAttributes();
            $this->vehicle_average->EditValue = $this->vehicle_average->AdvancedSearch->SearchValue;
            $this->vehicle_average->PlaceHolder = RemoveHtml($this->vehicle_average->caption());

            // cash_required
            $this->cash_required->setupEditAttributes();
            $this->cash_required->EditValue = $this->cash_required->AdvancedSearch->SearchValue;
            $this->cash_required->PlaceHolder = RemoveHtml($this->cash_required->caption());

            // cash_op_b
            $this->cash_op_b->setupEditAttributes();
            $this->cash_op_b->EditValue = $this->cash_op_b->AdvancedSearch->SearchValue;
            $this->cash_op_b->PlaceHolder = RemoveHtml($this->cash_op_b->caption());

            // cash_paid
            $this->cash_paid->setupEditAttributes();
            $this->cash_paid->EditValue = $this->cash_paid->AdvancedSearch->SearchValue;
            $this->cash_paid->PlaceHolder = RemoveHtml($this->cash_paid->caption());

            // cash_expenses
            $this->cash_expenses->setupEditAttributes();
            $this->cash_expenses->EditValue = $this->cash_expenses->AdvancedSearch->SearchValue;
            $this->cash_expenses->PlaceHolder = RemoveHtml($this->cash_expenses->caption());

            // cash_cl_balance
            $this->cash_cl_balance->setupEditAttributes();
            $this->cash_cl_balance->EditValue = $this->cash_cl_balance->AdvancedSearch->SearchValue;
            $this->cash_cl_balance->PlaceHolder = RemoveHtml($this->cash_cl_balance->caption());

            // fasttag_op_b
            $this->fasttag_op_b->setupEditAttributes();
            $this->fasttag_op_b->EditValue = $this->fasttag_op_b->AdvancedSearch->SearchValue;
            $this->fasttag_op_b->PlaceHolder = RemoveHtml($this->fasttag_op_b->caption());

            // fasttag_recharge
            $this->fasttag_recharge->setupEditAttributes();
            $this->fasttag_recharge->EditValue = $this->fasttag_recharge->AdvancedSearch->SearchValue;
            $this->fasttag_recharge->PlaceHolder = RemoveHtml($this->fasttag_recharge->caption());

            // fasttag_expenses
            $this->fasttag_expenses->setupEditAttributes();
            $this->fasttag_expenses->EditValue = $this->fasttag_expenses->AdvancedSearch->SearchValue;
            $this->fasttag_expenses->PlaceHolder = RemoveHtml($this->fasttag_expenses->caption());

            // toll_expenses_cash
            $this->toll_expenses_cash->setupEditAttributes();
            $this->toll_expenses_cash->EditValue = $this->toll_expenses_cash->AdvancedSearch->SearchValue;
            $this->toll_expenses_cash->PlaceHolder = RemoveHtml($this->toll_expenses_cash->caption());

            // fasttag_cl_balance
            $this->fasttag_cl_balance->setupEditAttributes();
            $this->fasttag_cl_balance->EditValue = $this->fasttag_cl_balance->AdvancedSearch->SearchValue;
            $this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            if (!$this->uploads->Raw) {
                $this->uploads->AdvancedSearch->SearchValue = HtmlDecode($this->uploads->AdvancedSearch->SearchValue);
            }
            $this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
            $this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

            // consignor
            $this->consignor->setupEditAttributes();
            $this->consignor->EditCustomAttributes = $this->consignor->getEditCustomAttributes(); // PHP
            $this->consignor->EditValue = $this->consignor->AdvancedSearch->SearchValue;
            $curVal = strval($this->consignor->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->consignor->EditValue = $this->consignor->lookupCacheOption($curVal);
                if ($this->consignor->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignor->Lookup->renderViewRow($rswrk[0]);
                        $this->consignor->EditValue = $this->consignor->displayValue($arwrk);
                    } else {
                        $this->consignor->EditValue = HtmlEncode(FormatNumber($this->consignor->AdvancedSearch->SearchValue, $this->consignor->formatPattern()));
                    }
                }
            } else {
                $this->consignor->EditValue = null;
            }
            $this->consignor->PlaceHolder = RemoveHtml($this->consignor->caption());

            // vehicle_freight_comm
            $this->vehicle_freight_comm->setupEditAttributes();
            $this->vehicle_freight_comm->EditValue = $this->vehicle_freight_comm->AdvancedSearch->SearchValue;
            $this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());

            // vehicle_freight_type
            $this->vehicle_freight_type->setupEditAttributes();
            $this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(true);
            $this->vehicle_freight_type->PlaceHolder = RemoveHtml($this->vehicle_freight_type->caption());

            // vehicle_freight_amount
            $this->vehicle_freight_amount->setupEditAttributes();
            $this->vehicle_freight_amount->EditValue = $this->vehicle_freight_amount->AdvancedSearch->SearchValue;
            $this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());

            // vehicle_freight_final
            $this->vehicle_freight_final->setupEditAttributes();
            $this->vehicle_freight_final->EditValue = $this->vehicle_freight_final->AdvancedSearch->SearchValue;
            $this->vehicle_freight_final->PlaceHolder = RemoveHtml($this->vehicle_freight_final->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->vehicle->AdvancedSearch->SearchValue)) {
            $this->vehicle->addErrorMessage($this->vehicle->getErrorMessage(false));
        }
        if (!CheckInteger($this->_route->AdvancedSearch->SearchValue)) {
            $this->_route->addErrorMessage($this->_route->getErrorMessage(false));
        }
        if (!CheckInteger($this->buyer->AdvancedSearch->SearchValue)) {
            $this->buyer->addErrorMessage($this->buyer->getErrorMessage(false));
        }
        if (!CheckDate($this->load_date->AdvancedSearch->SearchValue, $this->load_date->formatPattern())) {
            $this->load_date->addErrorMessage($this->load_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->load_weight->AdvancedSearch->SearchValue)) {
            $this->load_weight->addErrorMessage($this->load_weight->getErrorMessage(false));
        }
        if (!CheckDate($this->unload_date->AdvancedSearch->SearchValue, $this->unload_date->formatPattern())) {
            $this->unload_date->addErrorMessage($this->unload_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->unload_weight->AdvancedSearch->SearchValue)) {
            $this->unload_weight->addErrorMessage($this->unload_weight->getErrorMessage(false));
        }
        if (!CheckInteger($this->invoice_no->AdvancedSearch->SearchValue)) {
            $this->invoice_no->addErrorMessage($this->invoice_no->getErrorMessage(false));
        }
        if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue, $this->invoice_date->formatPattern())) {
            $this->invoice_date->addErrorMessage($this->invoice_date->getErrorMessage(false));
        }
        if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue2, $this->invoice_date->formatPattern())) {
            $this->invoice_date->addErrorMessage($this->invoice_date->getErrorMessage(false));
        }
        if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
            $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->days->AdvancedSearch->SearchValue)) {
            $this->days->addErrorMessage($this->days->getErrorMessage(false));
        }
        if (!CheckInteger($this->agent->AdvancedSearch->SearchValue)) {
            $this->agent->addErrorMessage($this->agent->getErrorMessage(false));
        }
        if (!CheckNumber($this->comm->AdvancedSearch->SearchValue)) {
            $this->comm->addErrorMessage($this->comm->getErrorMessage(false));
        }
        if (!CheckNumber($this->_40->AdvancedSearch->SearchValue)) {
            $this->_40->addErrorMessage($this->_40->getErrorMessage(false));
        }
        if (!CheckNumber($this->km->AdvancedSearch->SearchValue)) {
            $this->km->addErrorMessage($this->km->getErrorMessage(false));
        }
        if (!CheckNumber($this->freight->AdvancedSearch->SearchValue)) {
            $this->freight->addErrorMessage($this->freight->getErrorMessage(false));
        }
        if (!CheckNumber($this->ded_det->AdvancedSearch->SearchValue)) {
            $this->ded_det->addErrorMessage($this->ded_det->getErrorMessage(false));
        }
        if (!CheckNumber($this->gst_percent->AdvancedSearch->SearchValue)) {
            $this->gst_percent->addErrorMessage($this->gst_percent->getErrorMessage(false));
        }
        if (!CheckNumber($this->gst_amount->AdvancedSearch->SearchValue)) {
            $this->gst_amount->addErrorMessage($this->gst_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->final_amount->AdvancedSearch->SearchValue)) {
            $this->final_amount->addErrorMessage($this->final_amount->getErrorMessage(false));
        }
        if (!CheckInteger($this->load_km->AdvancedSearch->SearchValue)) {
            $this->load_km->addErrorMessage($this->load_km->getErrorMessage(false));
        }
        if (!CheckInteger($this->unload_km->AdvancedSearch->SearchValue)) {
            $this->unload_km->addErrorMessage($this->unload_km->getErrorMessage(false));
        }
        if (!CheckNumber($this->diesal_op_b->AdvancedSearch->SearchValue)) {
            $this->diesal_op_b->addErrorMessage($this->diesal_op_b->getErrorMessage(false));
        }
        if (!CheckNumber($this->diesal_required->AdvancedSearch->SearchValue)) {
            $this->diesal_required->addErrorMessage($this->diesal_required->getErrorMessage(false));
        }
        if (!CheckNumber($this->diesal_fill->AdvancedSearch->SearchValue)) {
            $this->diesal_fill->addErrorMessage($this->diesal_fill->getErrorMessage(false));
        }
        if (!CheckNumber($this->diesal_amount->AdvancedSearch->SearchValue)) {
            $this->diesal_amount->addErrorMessage($this->diesal_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->diesal_cl_balance->AdvancedSearch->SearchValue)) {
            $this->diesal_cl_balance->addErrorMessage($this->diesal_cl_balance->getErrorMessage(false));
        }
        if (!CheckNumber($this->vehicle_average->AdvancedSearch->SearchValue)) {
            $this->vehicle_average->addErrorMessage($this->vehicle_average->getErrorMessage(false));
        }
        if (!CheckNumber($this->cash_required->AdvancedSearch->SearchValue)) {
            $this->cash_required->addErrorMessage($this->cash_required->getErrorMessage(false));
        }
        if (!CheckNumber($this->cash_op_b->AdvancedSearch->SearchValue)) {
            $this->cash_op_b->addErrorMessage($this->cash_op_b->getErrorMessage(false));
        }
        if (!CheckNumber($this->cash_paid->AdvancedSearch->SearchValue)) {
            $this->cash_paid->addErrorMessage($this->cash_paid->getErrorMessage(false));
        }
        if (!CheckNumber($this->cash_expenses->AdvancedSearch->SearchValue)) {
            $this->cash_expenses->addErrorMessage($this->cash_expenses->getErrorMessage(false));
        }
        if (!CheckNumber($this->cash_cl_balance->AdvancedSearch->SearchValue)) {
            $this->cash_cl_balance->addErrorMessage($this->cash_cl_balance->getErrorMessage(false));
        }
        if (!CheckNumber($this->fasttag_op_b->AdvancedSearch->SearchValue)) {
            $this->fasttag_op_b->addErrorMessage($this->fasttag_op_b->getErrorMessage(false));
        }
        if (!CheckNumber($this->fasttag_recharge->AdvancedSearch->SearchValue)) {
            $this->fasttag_recharge->addErrorMessage($this->fasttag_recharge->getErrorMessage(false));
        }
        if (!CheckNumber($this->fasttag_expenses->AdvancedSearch->SearchValue)) {
            $this->fasttag_expenses->addErrorMessage($this->fasttag_expenses->getErrorMessage(false));
        }
        if (!CheckNumber($this->toll_expenses_cash->AdvancedSearch->SearchValue)) {
            $this->toll_expenses_cash->addErrorMessage($this->toll_expenses_cash->getErrorMessage(false));
        }
        if (!CheckNumber($this->fasttag_cl_balance->AdvancedSearch->SearchValue)) {
            $this->fasttag_cl_balance->addErrorMessage($this->fasttag_cl_balance->getErrorMessage(false));
        }
        if (!CheckInteger($this->consignor->AdvancedSearch->SearchValue)) {
            $this->consignor->addErrorMessage($this->consignor->getErrorMessage(false));
        }
        if (!CheckNumber($this->vehicle_freight_comm->AdvancedSearch->SearchValue)) {
            $this->vehicle_freight_comm->addErrorMessage($this->vehicle_freight_comm->getErrorMessage(false));
        }
        if (!CheckNumber($this->vehicle_freight_amount->AdvancedSearch->SearchValue)) {
            $this->vehicle_freight_amount->addErrorMessage($this->vehicle_freight_amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->vehicle_freight_final->AdvancedSearch->SearchValue)) {
            $this->vehicle_freight_final->addErrorMessage($this->vehicle_freight_final->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->vehicle_type->AdvancedSearch->load();
        $this->vehicle->AdvancedSearch->load();
        $this->_route->AdvancedSearch->load();
        $this->route_name->AdvancedSearch->load();
        $this->reports_to->AdvancedSearch->load();
        $this->buyer->AdvancedSearch->load();
        $this->b_consignor->AdvancedSearch->load();
        $this->b_consignee->AdvancedSearch->load();
        $this->load_date->AdvancedSearch->load();
        $this->load_weight->AdvancedSearch->load();
        $this->unload_date->AdvancedSearch->load();
        $this->unload_weight->AdvancedSearch->load();
        $this->invoice_no->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->delivery_pod->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->days->AdvancedSearch->load();
        $this->driver->AdvancedSearch->load();
        $this->driver_name->AdvancedSearch->load();
        $this->agent->AdvancedSearch->load();
        $this->comm->AdvancedSearch->load();
        $this->material->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->m_hsn->AdvancedSearch->load();
        $this->_40->AdvancedSearch->load();
        $this->lr_no->AdvancedSearch->load();
        $this->km->AdvancedSearch->load();
        $this->freight_type->AdvancedSearch->load();
        $this->freight->AdvancedSearch->load();
        $this->ded_det->AdvancedSearch->load();
        $this->ded_det_remarks->AdvancedSearch->load();
        $this->gst_percent->AdvancedSearch->load();
        $this->gst_amount->AdvancedSearch->load();
        $this->final_amount->AdvancedSearch->load();
        $this->load_km->AdvancedSearch->load();
        $this->unload_km->AdvancedSearch->load();
        $this->delivery_receipt->AdvancedSearch->load();
        $this->delivery_docket->AdvancedSearch->load();
        $this->diesal_op_b->AdvancedSearch->load();
        $this->diesal_required->AdvancedSearch->load();
        $this->diesal_fill->AdvancedSearch->load();
        $this->diesal_amount->AdvancedSearch->load();
        $this->diesal_cl_balance->AdvancedSearch->load();
        $this->vehicle_average->AdvancedSearch->load();
        $this->cash_required->AdvancedSearch->load();
        $this->cash_op_b->AdvancedSearch->load();
        $this->cash_paid->AdvancedSearch->load();
        $this->cash_expenses->AdvancedSearch->load();
        $this->cash_cl_balance->AdvancedSearch->load();
        $this->fasttag_op_b->AdvancedSearch->load();
        $this->fasttag_recharge->AdvancedSearch->load();
        $this->fasttag_expenses->AdvancedSearch->load();
        $this->toll_expenses_cash->AdvancedSearch->load();
        $this->fasttag_cl_balance->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->uploads->AdvancedSearch->load();
        $this->consignor->AdvancedSearch->load();
        $this->vehicle_freight_comm->AdvancedSearch->load();
        $this->vehicle_freight_type->AdvancedSearch->load();
        $this->vehicle_freight_amount->AdvancedSearch->load();
        $this->vehicle_freight_final->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ttripinfolist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_vehicle_type":
                    break;
                case "x_vehicle":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__route":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_consignor":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_consignee":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_delivery_pod":
                    break;
                case "x_status":
                    break;
                case "x_driver":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_freight_type":
                    break;
                case "x_consignor":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_vehicle_freight_type":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'t_trip_info');	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
