<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TTripInfoEdit extends TTripInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TTripInfoEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "ttripinfoedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->vehicle_type->setVisibility();
        $this->vehicle->setVisibility();
        $this->_route->setVisibility();
        $this->route_name->setVisibility();
        $this->reports_to->setVisibility();
        $this->buyer->setVisibility();
        $this->b_consignor->setVisibility();
        $this->b_consignee->setVisibility();
        $this->load_date->setVisibility();
        $this->load_weight->setVisibility();
        $this->unload_date->setVisibility();
        $this->unload_weight->setVisibility();
        $this->invoice_no->setVisibility();
        $this->invoice_date->setVisibility();
        $this->amount->setVisibility();
        $this->delivery_pod->setVisibility();
        $this->status->setVisibility();
        $this->days->setVisibility();
        $this->driver->setVisibility();
        $this->driver_name->setVisibility();
        $this->agent->setVisibility();
        $this->comm->setVisibility();
        $this->material->setVisibility();
        $this->packing_type->setVisibility();
        $this->m_hsn->setVisibility();
        $this->_40->setVisibility();
        $this->lr_no->setVisibility();
        $this->km->setVisibility();
        $this->freight_type->setVisibility();
        $this->freight->setVisibility();
        $this->ded_det->setVisibility();
        $this->ded_det_remarks->setVisibility();
        $this->gst_percent->setVisibility();
        $this->gst_amount->setVisibility();
        $this->final_amount->setVisibility();
        $this->load_km->setVisibility();
        $this->unload_km->setVisibility();
        $this->delivery_receipt->setVisibility();
        $this->delivery_docket->setVisibility();
        $this->diesal_op_b->setVisibility();
        $this->diesal_required->setVisibility();
        $this->diesal_fill->setVisibility();
        $this->diesal_amount->setVisibility();
        $this->diesal_cl_balance->setVisibility();
        $this->vehicle_average->setVisibility();
        $this->cash_required->setVisibility();
        $this->cash_op_b->setVisibility();
        $this->cash_paid->setVisibility();
        $this->cash_expenses->setVisibility();
        $this->cash_cl_balance->setVisibility();
        $this->fasttag_op_b->setVisibility();
        $this->fasttag_recharge->setVisibility();
        $this->fasttag_expenses->setVisibility();
        $this->toll_expenses_cash->setVisibility();
        $this->fasttag_cl_balance->setVisibility();
        $this->remarks->setVisibility();
        $this->uploads->setVisibility();
        $this->consignor->setVisibility();
        $this->vehicle_freight_comm->setVisibility();
        $this->vehicle_freight_type->setVisibility();
        $this->vehicle_freight_amount->setVisibility();
        $this->vehicle_freight_final->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->expenses_id->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 't_trip_info';
        $this->TableName = 't_trip_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (t_trip_info)
        if (!isset($GLOBALS["t_trip_info"]) || $GLOBALS["t_trip_info"]::class == PROJECT_NAMESPACE . "t_trip_info") {
            $GLOBALS["t_trip_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "ttripinfoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->delivery_receipt->OldUploadPath = $this->delivery_receipt->getUploadPath(); // PHP
                $this->delivery_receipt->UploadPath = $this->delivery_receipt->OldUploadPath;
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->vehicle->Required = false;
        $this->status->Required = false;
        $this->days->Required = false;
        $this->diesal_op_b->Required = false;
        $this->diesal_required->Required = false;
        $this->diesal_fill->Required = false;
        $this->vehicle_average->Required = false;
        $this->cash_required->Required = false;
        $this->cash_op_b->Required = false;
        $this->cash_paid->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->vehicle_type);
        $this->setupLookupOptions($this->vehicle);
        $this->setupLookupOptions($this->_route);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->buyer);
        $this->setupLookupOptions($this->b_consignor);
        $this->setupLookupOptions($this->b_consignee);
        $this->setupLookupOptions($this->delivery_pod);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->driver);
        $this->setupLookupOptions($this->agent);
        $this->setupLookupOptions($this->freight_type);
        $this->setupLookupOptions($this->consignor);
        $this->setupLookupOptions($this->vehicle_freight_type);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values

            // Set up detail parameters
            $this->setupDetailParms();
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("ttripinfolist"); // No matching record, return to list
                        return;
                    }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "update": // Update
                if ($this->getCurrentDetailTable() != "") { // Master/detail edit
                    $returnUrl = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
                } else {
                    $returnUrl = $this->getReturnUrl();
                }
                if (GetPageName($returnUrl) == "ttripinfolist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "ttripinfolist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "ttripinfolist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->delivery_receipt->Upload->Index = $CurrentForm->Index;
        $this->delivery_receipt->Upload->uploadFile();
        $this->delivery_receipt->CurrentValue = $this->delivery_receipt->Upload->FileName;
        $this->uploads->Upload->Index = $CurrentForm->Index;
        $this->uploads->Upload->uploadFile();
        $this->uploads->CurrentValue = $this->uploads->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'vehicle_type' first before field var 'x_vehicle_type'
        $val = $CurrentForm->hasValue("vehicle_type") ? $CurrentForm->getValue("vehicle_type") : $CurrentForm->getValue("x_vehicle_type");
        if (!$this->vehicle_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_type->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_type->setFormValue($val);
            }
        }

        // Check field name 'vehicle' first before field var 'x_vehicle'
        $val = $CurrentForm->hasValue("vehicle") ? $CurrentForm->getValue("vehicle") : $CurrentForm->getValue("x_vehicle");
        if (!$this->vehicle->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle->Visible = false; // Disable update for API request
            } else {
                $this->vehicle->setFormValue($val);
            }
        }

        // Check field name 'route' first before field var 'x__route'
        $val = $CurrentForm->hasValue("route") ? $CurrentForm->getValue("route") : $CurrentForm->getValue("x__route");
        if (!$this->_route->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_route->Visible = false; // Disable update for API request
            } else {
                $this->_route->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'route_name' first before field var 'x_route_name'
        $val = $CurrentForm->hasValue("route_name") ? $CurrentForm->getValue("route_name") : $CurrentForm->getValue("x_route_name");
        if (!$this->route_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->route_name->Visible = false; // Disable update for API request
            } else {
                $this->route_name->setFormValue($val);
            }
        }

        // Check field name 'reports_to' first before field var 'x_reports_to'
        $val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
        if (!$this->reports_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reports_to->Visible = false; // Disable update for API request
            } else {
                $this->reports_to->setFormValue($val);
            }
        }

        // Check field name 'buyer' first before field var 'x_buyer'
        $val = $CurrentForm->hasValue("buyer") ? $CurrentForm->getValue("buyer") : $CurrentForm->getValue("x_buyer");
        if (!$this->buyer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer->Visible = false; // Disable update for API request
            } else {
                $this->buyer->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'b_consignor' first before field var 'x_b_consignor'
        $val = $CurrentForm->hasValue("b_consignor") ? $CurrentForm->getValue("b_consignor") : $CurrentForm->getValue("x_b_consignor");
        if (!$this->b_consignor->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_consignor->Visible = false; // Disable update for API request
            } else {
                $this->b_consignor->setFormValue($val);
            }
        }

        // Check field name 'b_consignee' first before field var 'x_b_consignee'
        $val = $CurrentForm->hasValue("b_consignee") ? $CurrentForm->getValue("b_consignee") : $CurrentForm->getValue("x_b_consignee");
        if (!$this->b_consignee->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_consignee->Visible = false; // Disable update for API request
            } else {
                $this->b_consignee->setFormValue($val);
            }
        }

        // Check field name 'load_date' first before field var 'x_load_date'
        $val = $CurrentForm->hasValue("load_date") ? $CurrentForm->getValue("load_date") : $CurrentForm->getValue("x_load_date");
        if (!$this->load_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_date->Visible = false; // Disable update for API request
            } else {
                $this->load_date->setFormValue($val, true, $validate);
            }
            $this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern());
        }

        // Check field name 'load_weight' first before field var 'x_load_weight'
        $val = $CurrentForm->hasValue("load_weight") ? $CurrentForm->getValue("load_weight") : $CurrentForm->getValue("x_load_weight");
        if (!$this->load_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_weight->Visible = false; // Disable update for API request
            } else {
                $this->load_weight->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'unload_date' first before field var 'x_unload_date'
        $val = $CurrentForm->hasValue("unload_date") ? $CurrentForm->getValue("unload_date") : $CurrentForm->getValue("x_unload_date");
        if (!$this->unload_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unload_date->Visible = false; // Disable update for API request
            } else {
                $this->unload_date->setFormValue($val, true, $validate);
            }
            $this->unload_date->CurrentValue = UnFormatDateTime($this->unload_date->CurrentValue, $this->unload_date->formatPattern());
        }

        // Check field name 'unload_weight' first before field var 'x_unload_weight'
        $val = $CurrentForm->hasValue("unload_weight") ? $CurrentForm->getValue("unload_weight") : $CurrentForm->getValue("x_unload_weight");
        if (!$this->unload_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unload_weight->Visible = false; // Disable update for API request
            } else {
                $this->unload_weight->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'invoice_no' first before field var 'x_invoice_no'
        $val = $CurrentForm->hasValue("invoice_no") ? $CurrentForm->getValue("invoice_no") : $CurrentForm->getValue("x_invoice_no");
        if (!$this->invoice_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_no->Visible = false; // Disable update for API request
            } else {
                $this->invoice_no->setFormValue($val);
            }
        }

        // Check field name 'invoice_date' first before field var 'x_invoice_date'
        $val = $CurrentForm->hasValue("invoice_date") ? $CurrentForm->getValue("invoice_date") : $CurrentForm->getValue("x_invoice_date");
        if (!$this->invoice_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_date->Visible = false; // Disable update for API request
            } else {
                $this->invoice_date->setFormValue($val);
            }
            $this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val);
            }
        }

        // Check field name 'delivery_pod' first before field var 'x_delivery_pod'
        $val = $CurrentForm->hasValue("delivery_pod") ? $CurrentForm->getValue("delivery_pod") : $CurrentForm->getValue("x_delivery_pod");
        if (!$this->delivery_pod->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delivery_pod->Visible = false; // Disable update for API request
            } else {
                $this->delivery_pod->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'days' first before field var 'x_days'
        $val = $CurrentForm->hasValue("days") ? $CurrentForm->getValue("days") : $CurrentForm->getValue("x_days");
        if (!$this->days->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->days->Visible = false; // Disable update for API request
            } else {
                $this->days->setFormValue($val);
            }
        }

        // Check field name 'driver' first before field var 'x_driver'
        $val = $CurrentForm->hasValue("driver") ? $CurrentForm->getValue("driver") : $CurrentForm->getValue("x_driver");
        if (!$this->driver->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->driver->Visible = false; // Disable update for API request
            } else {
                $this->driver->setFormValue($val);
            }
        }

        // Check field name 'driver_name' first before field var 'x_driver_name'
        $val = $CurrentForm->hasValue("driver_name") ? $CurrentForm->getValue("driver_name") : $CurrentForm->getValue("x_driver_name");
        if (!$this->driver_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->driver_name->Visible = false; // Disable update for API request
            } else {
                $this->driver_name->setFormValue($val);
            }
        }

        // Check field name 'agent' first before field var 'x_agent'
        $val = $CurrentForm->hasValue("agent") ? $CurrentForm->getValue("agent") : $CurrentForm->getValue("x_agent");
        if (!$this->agent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->agent->Visible = false; // Disable update for API request
            } else {
                $this->agent->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'comm' first before field var 'x_comm'
        $val = $CurrentForm->hasValue("comm") ? $CurrentForm->getValue("comm") : $CurrentForm->getValue("x_comm");
        if (!$this->comm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->comm->Visible = false; // Disable update for API request
            } else {
                $this->comm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'material' first before field var 'x_material'
        $val = $CurrentForm->hasValue("material") ? $CurrentForm->getValue("material") : $CurrentForm->getValue("x_material");
        if (!$this->material->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->material->Visible = false; // Disable update for API request
            } else {
                $this->material->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'm_hsn' first before field var 'x_m_hsn'
        $val = $CurrentForm->hasValue("m_hsn") ? $CurrentForm->getValue("m_hsn") : $CurrentForm->getValue("x_m_hsn");
        if (!$this->m_hsn->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_hsn->Visible = false; // Disable update for API request
            } else {
                $this->m_hsn->setFormValue($val);
            }
        }

        // Check field name '@' first before field var 'x__40'
        $val = $CurrentForm->hasValue("@") ? $CurrentForm->getValue("@") : $CurrentForm->getValue("x__40");
        if (!$this->_40->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_40->Visible = false; // Disable update for API request
            } else {
                $this->_40->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'lr_no' first before field var 'x_lr_no'
        $val = $CurrentForm->hasValue("lr_no") ? $CurrentForm->getValue("lr_no") : $CurrentForm->getValue("x_lr_no");
        if (!$this->lr_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lr_no->Visible = false; // Disable update for API request
            } else {
                $this->lr_no->setFormValue($val);
            }
        }

        // Check field name 'km' first before field var 'x_km'
        $val = $CurrentForm->hasValue("km") ? $CurrentForm->getValue("km") : $CurrentForm->getValue("x_km");
        if (!$this->km->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->km->Visible = false; // Disable update for API request
            } else {
                $this->km->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'freight_type' first before field var 'x_freight_type'
        $val = $CurrentForm->hasValue("freight_type") ? $CurrentForm->getValue("freight_type") : $CurrentForm->getValue("x_freight_type");
        if (!$this->freight_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->freight_type->Visible = false; // Disable update for API request
            } else {
                $this->freight_type->setFormValue($val);
            }
        }

        // Check field name 'freight' first before field var 'x_freight'
        $val = $CurrentForm->hasValue("freight") ? $CurrentForm->getValue("freight") : $CurrentForm->getValue("x_freight");
        if (!$this->freight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->freight->Visible = false; // Disable update for API request
            } else {
                $this->freight->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ded_det' first before field var 'x_ded_det'
        $val = $CurrentForm->hasValue("ded_det") ? $CurrentForm->getValue("ded_det") : $CurrentForm->getValue("x_ded_det");
        if (!$this->ded_det->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ded_det->Visible = false; // Disable update for API request
            } else {
                $this->ded_det->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ded_det_remarks' first before field var 'x_ded_det_remarks'
        $val = $CurrentForm->hasValue("ded_det_remarks") ? $CurrentForm->getValue("ded_det_remarks") : $CurrentForm->getValue("x_ded_det_remarks");
        if (!$this->ded_det_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ded_det_remarks->Visible = false; // Disable update for API request
            } else {
                $this->ded_det_remarks->setFormValue($val);
            }
        }

        // Check field name 'gst_percent' first before field var 'x_gst_percent'
        $val = $CurrentForm->hasValue("gst_percent") ? $CurrentForm->getValue("gst_percent") : $CurrentForm->getValue("x_gst_percent");
        if (!$this->gst_percent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gst_percent->Visible = false; // Disable update for API request
            } else {
                $this->gst_percent->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'gst_amount' first before field var 'x_gst_amount'
        $val = $CurrentForm->hasValue("gst_amount") ? $CurrentForm->getValue("gst_amount") : $CurrentForm->getValue("x_gst_amount");
        if (!$this->gst_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gst_amount->Visible = false; // Disable update for API request
            } else {
                $this->gst_amount->setFormValue($val);
            }
        }

        // Check field name 'final_amount' first before field var 'x_final_amount'
        $val = $CurrentForm->hasValue("final_amount") ? $CurrentForm->getValue("final_amount") : $CurrentForm->getValue("x_final_amount");
        if (!$this->final_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->final_amount->Visible = false; // Disable update for API request
            } else {
                $this->final_amount->setFormValue($val);
            }
        }

        // Check field name 'load_km' first before field var 'x_load_km'
        $val = $CurrentForm->hasValue("load_km") ? $CurrentForm->getValue("load_km") : $CurrentForm->getValue("x_load_km");
        if (!$this->load_km->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_km->Visible = false; // Disable update for API request
            } else {
                $this->load_km->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'unload_km' first before field var 'x_unload_km'
        $val = $CurrentForm->hasValue("unload_km") ? $CurrentForm->getValue("unload_km") : $CurrentForm->getValue("x_unload_km");
        if (!$this->unload_km->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unload_km->Visible = false; // Disable update for API request
            } else {
                $this->unload_km->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'delivery_docket' first before field var 'x_delivery_docket'
        $val = $CurrentForm->hasValue("delivery_docket") ? $CurrentForm->getValue("delivery_docket") : $CurrentForm->getValue("x_delivery_docket");
        if (!$this->delivery_docket->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delivery_docket->Visible = false; // Disable update for API request
            } else {
                $this->delivery_docket->setFormValue($val);
            }
        }

        // Check field name 'diesal_op_b' first before field var 'x_diesal_op_b'
        $val = $CurrentForm->hasValue("diesal_op_b") ? $CurrentForm->getValue("diesal_op_b") : $CurrentForm->getValue("x_diesal_op_b");
        if (!$this->diesal_op_b->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diesal_op_b->Visible = false; // Disable update for API request
            } else {
                $this->diesal_op_b->setFormValue($val);
            }
        }

        // Check field name 'diesal_required' first before field var 'x_diesal_required'
        $val = $CurrentForm->hasValue("diesal_required") ? $CurrentForm->getValue("diesal_required") : $CurrentForm->getValue("x_diesal_required");
        if (!$this->diesal_required->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diesal_required->Visible = false; // Disable update for API request
            } else {
                $this->diesal_required->setFormValue($val);
            }
        }

        // Check field name 'diesal_fill' first before field var 'x_diesal_fill'
        $val = $CurrentForm->hasValue("diesal_fill") ? $CurrentForm->getValue("diesal_fill") : $CurrentForm->getValue("x_diesal_fill");
        if (!$this->diesal_fill->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diesal_fill->Visible = false; // Disable update for API request
            } else {
                $this->diesal_fill->setFormValue($val);
            }
        }

        // Check field name 'diesal_amount' first before field var 'x_diesal_amount'
        $val = $CurrentForm->hasValue("diesal_amount") ? $CurrentForm->getValue("diesal_amount") : $CurrentForm->getValue("x_diesal_amount");
        if (!$this->diesal_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diesal_amount->Visible = false; // Disable update for API request
            } else {
                $this->diesal_amount->setFormValue($val);
            }
        }

        // Check field name 'diesal_cl_balance' first before field var 'x_diesal_cl_balance'
        $val = $CurrentForm->hasValue("diesal_cl_balance") ? $CurrentForm->getValue("diesal_cl_balance") : $CurrentForm->getValue("x_diesal_cl_balance");
        if (!$this->diesal_cl_balance->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diesal_cl_balance->Visible = false; // Disable update for API request
            } else {
                $this->diesal_cl_balance->setFormValue($val);
            }
        }

        // Check field name 'vehicle_average' first before field var 'x_vehicle_average'
        $val = $CurrentForm->hasValue("vehicle_average") ? $CurrentForm->getValue("vehicle_average") : $CurrentForm->getValue("x_vehicle_average");
        if (!$this->vehicle_average->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_average->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_average->setFormValue($val);
            }
        }

        // Check field name 'cash_required' first before field var 'x_cash_required'
        $val = $CurrentForm->hasValue("cash_required") ? $CurrentForm->getValue("cash_required") : $CurrentForm->getValue("x_cash_required");
        if (!$this->cash_required->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cash_required->Visible = false; // Disable update for API request
            } else {
                $this->cash_required->setFormValue($val);
            }
        }

        // Check field name 'cash_op_b' first before field var 'x_cash_op_b'
        $val = $CurrentForm->hasValue("cash_op_b") ? $CurrentForm->getValue("cash_op_b") : $CurrentForm->getValue("x_cash_op_b");
        if (!$this->cash_op_b->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cash_op_b->Visible = false; // Disable update for API request
            } else {
                $this->cash_op_b->setFormValue($val);
            }
        }

        // Check field name 'cash_paid' first before field var 'x_cash_paid'
        $val = $CurrentForm->hasValue("cash_paid") ? $CurrentForm->getValue("cash_paid") : $CurrentForm->getValue("x_cash_paid");
        if (!$this->cash_paid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cash_paid->Visible = false; // Disable update for API request
            } else {
                $this->cash_paid->setFormValue($val);
            }
        }

        // Check field name 'cash_expenses' first before field var 'x_cash_expenses'
        $val = $CurrentForm->hasValue("cash_expenses") ? $CurrentForm->getValue("cash_expenses") : $CurrentForm->getValue("x_cash_expenses");
        if (!$this->cash_expenses->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cash_expenses->Visible = false; // Disable update for API request
            } else {
                $this->cash_expenses->setFormValue($val);
            }
        }

        // Check field name 'cash_cl_balance' first before field var 'x_cash_cl_balance'
        $val = $CurrentForm->hasValue("cash_cl_balance") ? $CurrentForm->getValue("cash_cl_balance") : $CurrentForm->getValue("x_cash_cl_balance");
        if (!$this->cash_cl_balance->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cash_cl_balance->Visible = false; // Disable update for API request
            } else {
                $this->cash_cl_balance->setFormValue($val);
            }
        }

        // Check field name 'fasttag_op_b' first before field var 'x_fasttag_op_b'
        $val = $CurrentForm->hasValue("fasttag_op_b") ? $CurrentForm->getValue("fasttag_op_b") : $CurrentForm->getValue("x_fasttag_op_b");
        if (!$this->fasttag_op_b->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fasttag_op_b->Visible = false; // Disable update for API request
            } else {
                $this->fasttag_op_b->setFormValue($val);
            }
        }

        // Check field name 'fasttag_recharge' first before field var 'x_fasttag_recharge'
        $val = $CurrentForm->hasValue("fasttag_recharge") ? $CurrentForm->getValue("fasttag_recharge") : $CurrentForm->getValue("x_fasttag_recharge");
        if (!$this->fasttag_recharge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fasttag_recharge->Visible = false; // Disable update for API request
            } else {
                $this->fasttag_recharge->setFormValue($val);
            }
        }

        // Check field name 'fasttag_expenses' first before field var 'x_fasttag_expenses'
        $val = $CurrentForm->hasValue("fasttag_expenses") ? $CurrentForm->getValue("fasttag_expenses") : $CurrentForm->getValue("x_fasttag_expenses");
        if (!$this->fasttag_expenses->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fasttag_expenses->Visible = false; // Disable update for API request
            } else {
                $this->fasttag_expenses->setFormValue($val);
            }
        }

        // Check field name 'toll_expenses_cash' first before field var 'x_toll_expenses_cash'
        $val = $CurrentForm->hasValue("toll_expenses_cash") ? $CurrentForm->getValue("toll_expenses_cash") : $CurrentForm->getValue("x_toll_expenses_cash");
        if (!$this->toll_expenses_cash->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->toll_expenses_cash->Visible = false; // Disable update for API request
            } else {
                $this->toll_expenses_cash->setFormValue($val);
            }
        }

        // Check field name 'fasttag_cl_balance' first before field var 'x_fasttag_cl_balance'
        $val = $CurrentForm->hasValue("fasttag_cl_balance") ? $CurrentForm->getValue("fasttag_cl_balance") : $CurrentForm->getValue("x_fasttag_cl_balance");
        if (!$this->fasttag_cl_balance->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fasttag_cl_balance->Visible = false; // Disable update for API request
            } else {
                $this->fasttag_cl_balance->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'consignor' first before field var 'x_consignor'
        $val = $CurrentForm->hasValue("consignor") ? $CurrentForm->getValue("consignor") : $CurrentForm->getValue("x_consignor");
        if (!$this->consignor->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->consignor->Visible = false; // Disable update for API request
            } else {
                $this->consignor->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'vehicle_freight_comm' first before field var 'x_vehicle_freight_comm'
        $val = $CurrentForm->hasValue("vehicle_freight_comm") ? $CurrentForm->getValue("vehicle_freight_comm") : $CurrentForm->getValue("x_vehicle_freight_comm");
        if (!$this->vehicle_freight_comm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_freight_comm->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_freight_comm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'vehicle_freight_type' first before field var 'x_vehicle_freight_type'
        $val = $CurrentForm->hasValue("vehicle_freight_type") ? $CurrentForm->getValue("vehicle_freight_type") : $CurrentForm->getValue("x_vehicle_freight_type");
        if (!$this->vehicle_freight_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_freight_type->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_freight_type->setFormValue($val);
            }
        }

        // Check field name 'vehicle_freight_amount' first before field var 'x_vehicle_freight_amount'
        $val = $CurrentForm->hasValue("vehicle_freight_amount") ? $CurrentForm->getValue("vehicle_freight_amount") : $CurrentForm->getValue("x_vehicle_freight_amount");
        if (!$this->vehicle_freight_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_freight_amount->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_freight_amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'vehicle_freight_final' first before field var 'x_vehicle_freight_final'
        $val = $CurrentForm->hasValue("vehicle_freight_final") ? $CurrentForm->getValue("vehicle_freight_final") : $CurrentForm->getValue("x_vehicle_freight_final");
        if (!$this->vehicle_freight_final->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->vehicle_freight_final->Visible = false; // Disable update for API request
            } else {
                $this->vehicle_freight_final->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
		$this->delivery_receipt->OldUploadPath = $this->delivery_receipt->getUploadPath(); // PHP
		$this->delivery_receipt->UploadPath = $this->delivery_receipt->OldUploadPath;
		$this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
		$this->uploads->UploadPath = $this->uploads->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->vehicle_type->CurrentValue = $this->vehicle_type->FormValue;
        $this->vehicle->CurrentValue = $this->vehicle->FormValue;
        $this->_route->CurrentValue = $this->_route->FormValue;
        $this->route_name->CurrentValue = $this->route_name->FormValue;
        $this->reports_to->CurrentValue = $this->reports_to->FormValue;
        $this->buyer->CurrentValue = $this->buyer->FormValue;
        $this->b_consignor->CurrentValue = $this->b_consignor->FormValue;
        $this->b_consignee->CurrentValue = $this->b_consignee->FormValue;
        $this->load_date->CurrentValue = $this->load_date->FormValue;
        $this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern());
        $this->load_weight->CurrentValue = $this->load_weight->FormValue;
        $this->unload_date->CurrentValue = $this->unload_date->FormValue;
        $this->unload_date->CurrentValue = UnFormatDateTime($this->unload_date->CurrentValue, $this->unload_date->formatPattern());
        $this->unload_weight->CurrentValue = $this->unload_weight->FormValue;
        $this->invoice_no->CurrentValue = $this->invoice_no->FormValue;
        $this->invoice_date->CurrentValue = $this->invoice_date->FormValue;
        $this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->delivery_pod->CurrentValue = $this->delivery_pod->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->days->CurrentValue = $this->days->FormValue;
        $this->driver->CurrentValue = $this->driver->FormValue;
        $this->driver_name->CurrentValue = $this->driver_name->FormValue;
        $this->agent->CurrentValue = $this->agent->FormValue;
        $this->comm->CurrentValue = $this->comm->FormValue;
        $this->material->CurrentValue = $this->material->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->m_hsn->CurrentValue = $this->m_hsn->FormValue;
        $this->_40->CurrentValue = $this->_40->FormValue;
        $this->lr_no->CurrentValue = $this->lr_no->FormValue;
        $this->km->CurrentValue = $this->km->FormValue;
        $this->freight_type->CurrentValue = $this->freight_type->FormValue;
        $this->freight->CurrentValue = $this->freight->FormValue;
        $this->ded_det->CurrentValue = $this->ded_det->FormValue;
        $this->ded_det_remarks->CurrentValue = $this->ded_det_remarks->FormValue;
        $this->gst_percent->CurrentValue = $this->gst_percent->FormValue;
        $this->gst_amount->CurrentValue = $this->gst_amount->FormValue;
        $this->final_amount->CurrentValue = $this->final_amount->FormValue;
        $this->load_km->CurrentValue = $this->load_km->FormValue;
        $this->unload_km->CurrentValue = $this->unload_km->FormValue;
        $this->delivery_docket->CurrentValue = $this->delivery_docket->FormValue;
        $this->diesal_op_b->CurrentValue = $this->diesal_op_b->FormValue;
        $this->diesal_required->CurrentValue = $this->diesal_required->FormValue;
        $this->diesal_fill->CurrentValue = $this->diesal_fill->FormValue;
        $this->diesal_amount->CurrentValue = $this->diesal_amount->FormValue;
        $this->diesal_cl_balance->CurrentValue = $this->diesal_cl_balance->FormValue;
        $this->vehicle_average->CurrentValue = $this->vehicle_average->FormValue;
        $this->cash_required->CurrentValue = $this->cash_required->FormValue;
        $this->cash_op_b->CurrentValue = $this->cash_op_b->FormValue;
        $this->cash_paid->CurrentValue = $this->cash_paid->FormValue;
        $this->cash_expenses->CurrentValue = $this->cash_expenses->FormValue;
        $this->cash_cl_balance->CurrentValue = $this->cash_cl_balance->FormValue;
        $this->fasttag_op_b->CurrentValue = $this->fasttag_op_b->FormValue;
        $this->fasttag_recharge->CurrentValue = $this->fasttag_recharge->FormValue;
        $this->fasttag_expenses->CurrentValue = $this->fasttag_expenses->FormValue;
        $this->toll_expenses_cash->CurrentValue = $this->toll_expenses_cash->FormValue;
        $this->fasttag_cl_balance->CurrentValue = $this->fasttag_cl_balance->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->consignor->CurrentValue = $this->consignor->FormValue;
        $this->vehicle_freight_comm->CurrentValue = $this->vehicle_freight_comm->FormValue;
        $this->vehicle_freight_type->CurrentValue = $this->vehicle_freight_type->FormValue;
        $this->vehicle_freight_amount->CurrentValue = $this->vehicle_freight_amount->FormValue;
        $this->vehicle_freight_final->CurrentValue = $this->vehicle_freight_final->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->vehicle_type->setDbValue($row['vehicle_type']);
        $this->vehicle->setDbValue($row['vehicle']);
        $this->_route->setDbValue($row['route']);
        $this->route_name->setDbValue($row['route_name']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->buyer->setDbValue($row['buyer']);
        $this->b_consignor->setDbValue($row['b_consignor']);
        $this->b_consignee->setDbValue($row['b_consignee']);
        $this->load_date->setDbValue($row['load_date']);
        $this->load_weight->setDbValue($row['load_weight']);
        $this->unload_date->setDbValue($row['unload_date']);
        $this->unload_weight->setDbValue($row['unload_weight']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->amount->setDbValue($row['amount']);
        $this->delivery_pod->setDbValue($row['delivery_pod']);
        $this->status->setDbValue($row['status']);
        $this->days->setDbValue($row['days']);
        $this->driver->setDbValue($row['driver']);
        $this->driver_name->setDbValue($row['driver_name']);
        $this->agent->setDbValue($row['agent']);
        $this->comm->setDbValue($row['comm']);
        $this->material->setDbValue($row['material']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->m_hsn->setDbValue($row['m_hsn']);
        $this->_40->setDbValue($row['@']);
        $this->lr_no->setDbValue($row['lr_no']);
        $this->km->setDbValue($row['km']);
        $this->freight_type->setDbValue($row['freight_type']);
        $this->freight->setDbValue($row['freight']);
        $this->ded_det->setDbValue($row['ded_det']);
        $this->ded_det_remarks->setDbValue($row['ded_det_remarks']);
        $this->gst_percent->setDbValue($row['gst_percent']);
        $this->gst_amount->setDbValue($row['gst_amount']);
        $this->final_amount->setDbValue($row['final_amount']);
        $this->load_km->setDbValue($row['load_km']);
        $this->unload_km->setDbValue($row['unload_km']);
        $this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
        $this->delivery_receipt->setDbValue($this->delivery_receipt->Upload->DbValue);
        $this->delivery_docket->setDbValue($row['delivery_docket']);
        $this->diesal_op_b->setDbValue($row['diesal_op_b']);
        $this->diesal_required->setDbValue($row['diesal_required']);
        $this->diesal_fill->setDbValue($row['diesal_fill']);
        $this->diesal_amount->setDbValue($row['diesal_amount']);
        $this->diesal_cl_balance->setDbValue($row['diesal_cl_balance']);
        $this->vehicle_average->setDbValue($row['vehicle_average']);
        $this->cash_required->setDbValue($row['cash_required']);
        $this->cash_op_b->setDbValue($row['cash_op_b']);
        $this->cash_paid->setDbValue($row['cash_paid']);
        $this->cash_expenses->setDbValue($row['cash_expenses']);
        $this->cash_cl_balance->setDbValue($row['cash_cl_balance']);
        $this->fasttag_op_b->setDbValue($row['fasttag_op_b']);
        $this->fasttag_recharge->setDbValue($row['fasttag_recharge']);
        $this->fasttag_expenses->setDbValue($row['fasttag_expenses']);
        $this->toll_expenses_cash->setDbValue($row['toll_expenses_cash']);
        $this->fasttag_cl_balance->setDbValue($row['fasttag_cl_balance']);
        $this->remarks->setDbValue($row['remarks']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->consignor->setDbValue($row['consignor']);
        $this->vehicle_freight_comm->setDbValue($row['vehicle_freight_comm']);
        $this->vehicle_freight_type->setDbValue($row['vehicle_freight_type']);
        $this->vehicle_freight_amount->setDbValue($row['vehicle_freight_amount']);
        $this->vehicle_freight_final->setDbValue($row['vehicle_freight_final']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->expenses_id->setDbValue($row['expenses_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['vehicle_type'] = $this->vehicle_type->DefaultValue;
        $row['vehicle'] = $this->vehicle->DefaultValue;
        $row['route'] = $this->_route->DefaultValue;
        $row['route_name'] = $this->route_name->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['buyer'] = $this->buyer->DefaultValue;
        $row['b_consignor'] = $this->b_consignor->DefaultValue;
        $row['b_consignee'] = $this->b_consignee->DefaultValue;
        $row['load_date'] = $this->load_date->DefaultValue;
        $row['load_weight'] = $this->load_weight->DefaultValue;
        $row['unload_date'] = $this->unload_date->DefaultValue;
        $row['unload_weight'] = $this->unload_weight->DefaultValue;
        $row['invoice_no'] = $this->invoice_no->DefaultValue;
        $row['invoice_date'] = $this->invoice_date->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['delivery_pod'] = $this->delivery_pod->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['days'] = $this->days->DefaultValue;
        $row['driver'] = $this->driver->DefaultValue;
        $row['driver_name'] = $this->driver_name->DefaultValue;
        $row['agent'] = $this->agent->DefaultValue;
        $row['comm'] = $this->comm->DefaultValue;
        $row['material'] = $this->material->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['m_hsn'] = $this->m_hsn->DefaultValue;
        $row['@'] = $this->_40->DefaultValue;
        $row['lr_no'] = $this->lr_no->DefaultValue;
        $row['km'] = $this->km->DefaultValue;
        $row['freight_type'] = $this->freight_type->DefaultValue;
        $row['freight'] = $this->freight->DefaultValue;
        $row['ded_det'] = $this->ded_det->DefaultValue;
        $row['ded_det_remarks'] = $this->ded_det_remarks->DefaultValue;
        $row['gst_percent'] = $this->gst_percent->DefaultValue;
        $row['gst_amount'] = $this->gst_amount->DefaultValue;
        $row['final_amount'] = $this->final_amount->DefaultValue;
        $row['load_km'] = $this->load_km->DefaultValue;
        $row['unload_km'] = $this->unload_km->DefaultValue;
        $row['delivery_receipt'] = $this->delivery_receipt->DefaultValue;
        $row['delivery_docket'] = $this->delivery_docket->DefaultValue;
        $row['diesal_op_b'] = $this->diesal_op_b->DefaultValue;
        $row['diesal_required'] = $this->diesal_required->DefaultValue;
        $row['diesal_fill'] = $this->diesal_fill->DefaultValue;
        $row['diesal_amount'] = $this->diesal_amount->DefaultValue;
        $row['diesal_cl_balance'] = $this->diesal_cl_balance->DefaultValue;
        $row['vehicle_average'] = $this->vehicle_average->DefaultValue;
        $row['cash_required'] = $this->cash_required->DefaultValue;
        $row['cash_op_b'] = $this->cash_op_b->DefaultValue;
        $row['cash_paid'] = $this->cash_paid->DefaultValue;
        $row['cash_expenses'] = $this->cash_expenses->DefaultValue;
        $row['cash_cl_balance'] = $this->cash_cl_balance->DefaultValue;
        $row['fasttag_op_b'] = $this->fasttag_op_b->DefaultValue;
        $row['fasttag_recharge'] = $this->fasttag_recharge->DefaultValue;
        $row['fasttag_expenses'] = $this->fasttag_expenses->DefaultValue;
        $row['toll_expenses_cash'] = $this->toll_expenses_cash->DefaultValue;
        $row['fasttag_cl_balance'] = $this->fasttag_cl_balance->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['consignor'] = $this->consignor->DefaultValue;
        $row['vehicle_freight_comm'] = $this->vehicle_freight_comm->DefaultValue;
        $row['vehicle_freight_type'] = $this->vehicle_freight_type->DefaultValue;
        $row['vehicle_freight_amount'] = $this->vehicle_freight_amount->DefaultValue;
        $row['vehicle_freight_final'] = $this->vehicle_freight_final->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['expenses_id'] = $this->expenses_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // vehicle_type
        $this->vehicle_type->RowCssClass = "row";

        // vehicle
        $this->vehicle->RowCssClass = "row";

        // route
        $this->_route->RowCssClass = "row";

        // route_name
        $this->route_name->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // buyer
        $this->buyer->RowCssClass = "row";

        // b_consignor
        $this->b_consignor->RowCssClass = "row";

        // b_consignee
        $this->b_consignee->RowCssClass = "row";

        // load_date
        $this->load_date->RowCssClass = "row";

        // load_weight
        $this->load_weight->RowCssClass = "row";

        // unload_date
        $this->unload_date->RowCssClass = "row";

        // unload_weight
        $this->unload_weight->RowCssClass = "row";

        // invoice_no
        $this->invoice_no->RowCssClass = "row";

        // invoice_date
        $this->invoice_date->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // delivery_pod
        $this->delivery_pod->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // days
        $this->days->RowCssClass = "row";

        // driver
        $this->driver->RowCssClass = "row";

        // driver_name
        $this->driver_name->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // comm
        $this->comm->RowCssClass = "row";

        // material
        $this->material->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // m_hsn
        $this->m_hsn->RowCssClass = "row";

        // @
        $this->_40->RowCssClass = "row";

        // lr_no
        $this->lr_no->RowCssClass = "row";

        // km
        $this->km->RowCssClass = "row";

        // freight_type
        $this->freight_type->RowCssClass = "row";

        // freight
        $this->freight->RowCssClass = "row";

        // ded_det
        $this->ded_det->RowCssClass = "row";

        // ded_det_remarks
        $this->ded_det_remarks->RowCssClass = "row";

        // gst_percent
        $this->gst_percent->RowCssClass = "row";

        // gst_amount
        $this->gst_amount->RowCssClass = "row";

        // final_amount
        $this->final_amount->RowCssClass = "row";

        // load_km
        $this->load_km->RowCssClass = "row";

        // unload_km
        $this->unload_km->RowCssClass = "row";

        // delivery_receipt
        $this->delivery_receipt->RowCssClass = "row";

        // delivery_docket
        $this->delivery_docket->RowCssClass = "row";

        // diesal_op_b
        $this->diesal_op_b->RowCssClass = "row";

        // diesal_required
        $this->diesal_required->RowCssClass = "row";

        // diesal_fill
        $this->diesal_fill->RowCssClass = "row";

        // diesal_amount
        $this->diesal_amount->RowCssClass = "row";

        // diesal_cl_balance
        $this->diesal_cl_balance->RowCssClass = "row";

        // vehicle_average
        $this->vehicle_average->RowCssClass = "row";

        // cash_required
        $this->cash_required->RowCssClass = "row";

        // cash_op_b
        $this->cash_op_b->RowCssClass = "row";

        // cash_paid
        $this->cash_paid->RowCssClass = "row";

        // cash_expenses
        $this->cash_expenses->RowCssClass = "row";

        // cash_cl_balance
        $this->cash_cl_balance->RowCssClass = "row";

        // fasttag_op_b
        $this->fasttag_op_b->RowCssClass = "row";

        // fasttag_recharge
        $this->fasttag_recharge->RowCssClass = "row";

        // fasttag_expenses
        $this->fasttag_expenses->RowCssClass = "row";

        // toll_expenses_cash
        $this->toll_expenses_cash->RowCssClass = "row";

        // fasttag_cl_balance
        $this->fasttag_cl_balance->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // consignor
        $this->consignor->RowCssClass = "row";

        // vehicle_freight_comm
        $this->vehicle_freight_comm->RowCssClass = "row";

        // vehicle_freight_type
        $this->vehicle_freight_type->RowCssClass = "row";

        // vehicle_freight_amount
        $this->vehicle_freight_amount->RowCssClass = "row";

        // vehicle_freight_final
        $this->vehicle_freight_final->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // expenses_id
        $this->expenses_id->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // vehicle_type
            if (strval($this->vehicle_type->CurrentValue) != "") {
                $this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
            } else {
                $this->vehicle_type->ViewValue = null;
            }

            // vehicle
            $this->vehicle->ViewValue = $this->vehicle->CurrentValue;
            $curVal = strval($this->vehicle->CurrentValue);
            if ($curVal != "") {
                $this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
                if ($this->vehicle->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
                    } else {
                        $this->vehicle->ViewValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                    }
                }
            } else {
                $this->vehicle->ViewValue = null;
            }

            // route
            $this->_route->ViewValue = $this->_route->CurrentValue;
            $curVal = strval($this->_route->CurrentValue);
            if ($curVal != "") {
                $this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
                if ($this->_route->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                        $this->_route->ViewValue = $this->_route->displayValue($arwrk);
                    } else {
                        $this->_route->ViewValue = FormatNumber($this->_route->CurrentValue, $this->_route->formatPattern());
                    }
                }
            } else {
                $this->_route->ViewValue = null;
            }

            // route_name
            $this->route_name->ViewValue = $this->route_name->CurrentValue;

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // buyer
            $this->buyer->ViewValue = $this->buyer->CurrentValue;
            $curVal = strval($this->buyer->CurrentValue);
            if ($curVal != "") {
                $this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->ViewValue = FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern());
                    }
                }
            } else {
                $this->buyer->ViewValue = null;
            }

            // b_consignor
            $this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
            $curVal = strval($this->b_consignor->CurrentValue);
            if ($curVal != "") {
                $this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
                if ($this->b_consignor->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignor->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
                    } else {
                        $this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
                    }
                }
            } else {
                $this->b_consignor->ViewValue = null;
            }

            // b_consignee
            $this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
            $curVal = strval($this->b_consignee->CurrentValue);
            if ($curVal != "") {
                $this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
                if ($this->b_consignee->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
                    } else {
                        $this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
                    }
                }
            } else {
                $this->b_consignee->ViewValue = null;
            }

            // load_date
            $this->load_date->ViewValue = $this->load_date->CurrentValue;
            $this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, $this->load_date->formatPattern());

            // load_weight
            $this->load_weight->ViewValue = $this->load_weight->CurrentValue;
            $this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, $this->load_weight->formatPattern());

            // unload_date
            $this->unload_date->ViewValue = $this->unload_date->CurrentValue;
            $this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, $this->unload_date->formatPattern());

            // unload_weight
            $this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
            $this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, $this->unload_weight->formatPattern());

            // invoice_no
            $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
            $this->invoice_no->ViewValue = FormatNumber($this->invoice_no->ViewValue, $this->invoice_no->formatPattern());

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // delivery_pod
            if (strval($this->delivery_pod->CurrentValue) != "") {
                $this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
            } else {
                $this->delivery_pod->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // days
            $this->days->ViewValue = $this->days->CurrentValue;
            $this->days->ViewValue = FormatNumber($this->days->ViewValue, $this->days->formatPattern());

            // driver
            $curVal = strval($this->driver->CurrentValue);
            if ($curVal != "") {
                $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
                if ($this->driver->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                    $sqlWrk = $this->driver->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->driver->Lookup->renderViewRow($rswrk[0]);
                        $this->driver->ViewValue = $this->driver->displayValue($arwrk);
                    } else {
                        $this->driver->ViewValue = $this->driver->CurrentValue;
                    }
                }
            } else {
                $this->driver->ViewValue = null;
            }

            // driver_name
            $this->driver_name->ViewValue = $this->driver_name->CurrentValue;

            // agent
            $this->agent->ViewValue = $this->agent->CurrentValue;
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->ViewValue = FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern());
                    }
                }
            } else {
                $this->agent->ViewValue = null;
            }

            // comm
            $this->comm->ViewValue = $this->comm->CurrentValue;
            $this->comm->ViewValue = FormatNumber($this->comm->ViewValue, $this->comm->formatPattern());

            // material
            $this->material->ViewValue = $this->material->CurrentValue;

            // packing_type
            $this->packing_type->ViewValue = $this->packing_type->CurrentValue;

            // m_hsn
            $this->m_hsn->ViewValue = $this->m_hsn->CurrentValue;

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;
            $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

            // lr_no
            $this->lr_no->ViewValue = $this->lr_no->CurrentValue;

            // km
            $this->km->ViewValue = $this->km->CurrentValue;
            $this->km->ViewValue = FormatNumber($this->km->ViewValue, $this->km->formatPattern());

            // freight_type
            if (strval($this->freight_type->CurrentValue) != "") {
                $this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
            } else {
                $this->freight_type->ViewValue = null;
            }

            // freight
            $this->freight->ViewValue = $this->freight->CurrentValue;
            $this->freight->ViewValue = FormatNumber($this->freight->ViewValue, $this->freight->formatPattern());

            // ded_det
            $this->ded_det->ViewValue = $this->ded_det->CurrentValue;
            $this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, $this->ded_det->formatPattern());

            // ded_det_remarks
            $this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;

            // gst_percent
            $this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
            $this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, $this->gst_percent->formatPattern());

            // gst_amount
            $this->gst_amount->ViewValue = $this->gst_amount->CurrentValue;
            $this->gst_amount->ViewValue = FormatNumber($this->gst_amount->ViewValue, $this->gst_amount->formatPattern());

            // final_amount
            $this->final_amount->ViewValue = $this->final_amount->CurrentValue;
            $this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, $this->final_amount->formatPattern());

            // load_km
            $this->load_km->ViewValue = $this->load_km->CurrentValue;
            $this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, $this->load_km->formatPattern());

            // unload_km
            $this->unload_km->ViewValue = $this->unload_km->CurrentValue;
            $this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, $this->unload_km->formatPattern());

            // delivery_receipt
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
            if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
                $this->delivery_receipt->ImageWidth = 0;
                $this->delivery_receipt->ImageHeight = 50;
                $this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
                $this->delivery_receipt->ImageCssClass = "ew-image";
                $this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
            } else {
                $this->delivery_receipt->ViewValue = "";
            }

            // delivery_docket
            $this->delivery_docket->ViewValue = $this->delivery_docket->CurrentValue;

            // diesal_op_b
            $this->diesal_op_b->ViewValue = $this->diesal_op_b->CurrentValue;
            $this->diesal_op_b->ViewValue = FormatNumber($this->diesal_op_b->ViewValue, $this->diesal_op_b->formatPattern());

            // diesal_required
            $this->diesal_required->ViewValue = $this->diesal_required->CurrentValue;
            $this->diesal_required->ViewValue = FormatNumber($this->diesal_required->ViewValue, $this->diesal_required->formatPattern());

            // diesal_fill
            $this->diesal_fill->ViewValue = $this->diesal_fill->CurrentValue;
            $this->diesal_fill->ViewValue = FormatNumber($this->diesal_fill->ViewValue, $this->diesal_fill->formatPattern());

            // diesal_amount
            $this->diesal_amount->ViewValue = $this->diesal_amount->CurrentValue;
            $this->diesal_amount->ViewValue = FormatNumber($this->diesal_amount->ViewValue, $this->diesal_amount->formatPattern());

            // diesal_cl_balance
            $this->diesal_cl_balance->ViewValue = $this->diesal_cl_balance->CurrentValue;
            $this->diesal_cl_balance->ViewValue = FormatNumber($this->diesal_cl_balance->ViewValue, $this->diesal_cl_balance->formatPattern());

            // vehicle_average
            $this->vehicle_average->ViewValue = $this->vehicle_average->CurrentValue;
            $this->vehicle_average->ViewValue = FormatNumber($this->vehicle_average->ViewValue, $this->vehicle_average->formatPattern());

            // cash_required
            $this->cash_required->ViewValue = $this->cash_required->CurrentValue;
            $this->cash_required->ViewValue = FormatNumber($this->cash_required->ViewValue, $this->cash_required->formatPattern());

            // cash_op_b
            $this->cash_op_b->ViewValue = $this->cash_op_b->CurrentValue;
            $this->cash_op_b->ViewValue = FormatNumber($this->cash_op_b->ViewValue, $this->cash_op_b->formatPattern());

            // cash_paid
            $this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
            $this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, $this->cash_paid->formatPattern());

            // cash_expenses
            $this->cash_expenses->ViewValue = $this->cash_expenses->CurrentValue;
            $this->cash_expenses->ViewValue = FormatNumber($this->cash_expenses->ViewValue, $this->cash_expenses->formatPattern());

            // cash_cl_balance
            $this->cash_cl_balance->ViewValue = $this->cash_cl_balance->CurrentValue;
            $this->cash_cl_balance->ViewValue = FormatNumber($this->cash_cl_balance->ViewValue, $this->cash_cl_balance->formatPattern());

            // fasttag_op_b
            $this->fasttag_op_b->ViewValue = $this->fasttag_op_b->CurrentValue;
            $this->fasttag_op_b->ViewValue = FormatNumber($this->fasttag_op_b->ViewValue, $this->fasttag_op_b->formatPattern());

            // fasttag_recharge
            $this->fasttag_recharge->ViewValue = $this->fasttag_recharge->CurrentValue;
            $this->fasttag_recharge->ViewValue = FormatNumber($this->fasttag_recharge->ViewValue, $this->fasttag_recharge->formatPattern());

            // fasttag_expenses
            $this->fasttag_expenses->ViewValue = $this->fasttag_expenses->CurrentValue;
            $this->fasttag_expenses->ViewValue = FormatNumber($this->fasttag_expenses->ViewValue, $this->fasttag_expenses->formatPattern());

            // toll_expenses_cash
            $this->toll_expenses_cash->ViewValue = $this->toll_expenses_cash->CurrentValue;
            $this->toll_expenses_cash->ViewValue = FormatNumber($this->toll_expenses_cash->ViewValue, $this->toll_expenses_cash->formatPattern());

            // fasttag_cl_balance
            $this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
            $this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, $this->fasttag_cl_balance->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // consignor
            $this->consignor->ViewValue = $this->consignor->CurrentValue;
            $curVal = strval($this->consignor->CurrentValue);
            if ($curVal != "") {
                $this->consignor->ViewValue = $this->consignor->lookupCacheOption($curVal);
                if ($this->consignor->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignor->Lookup->renderViewRow($rswrk[0]);
                        $this->consignor->ViewValue = $this->consignor->displayValue($arwrk);
                    } else {
                        $this->consignor->ViewValue = FormatNumber($this->consignor->CurrentValue, $this->consignor->formatPattern());
                    }
                }
            } else {
                $this->consignor->ViewValue = null;
            }

            // vehicle_freight_comm
            $this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
            $this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, $this->vehicle_freight_comm->formatPattern());

            // vehicle_freight_type
            if (strval($this->vehicle_freight_type->CurrentValue) != "") {
                $this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
            } else {
                $this->vehicle_freight_type->ViewValue = null;
            }

            // vehicle_freight_amount
            $this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
            $this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, $this->vehicle_freight_amount->formatPattern());

            // vehicle_freight_final
            $this->vehicle_freight_final->ViewValue = $this->vehicle_freight_final->CurrentValue;
            $this->vehicle_freight_final->ViewValue = FormatNumber($this->vehicle_freight_final->ViewValue, $this->vehicle_freight_final->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // vehicle_type
            $this->vehicle_type->HrefValue = "";

            // vehicle
            $this->vehicle->HrefValue = "";
            $this->vehicle->TooltipValue = "";

            // route
            $this->_route->HrefValue = "";

            // route_name
            $this->route_name->HrefValue = "";
            $this->route_name->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // buyer
            $this->buyer->HrefValue = "";

            // b_consignor
            $this->b_consignor->HrefValue = "";

            // b_consignee
            $this->b_consignee->HrefValue = "";

            // load_date
            $this->load_date->HrefValue = "";

            // load_weight
            $this->load_weight->HrefValue = "";

            // unload_date
            $this->unload_date->HrefValue = "";

            // unload_weight
            $this->unload_weight->HrefValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";
            $this->invoice_no->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // delivery_pod
            $this->delivery_pod->HrefValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // days
            $this->days->HrefValue = "";
            $this->days->TooltipValue = "";

            // driver
            $this->driver->HrefValue = "";

            // driver_name
            $this->driver_name->HrefValue = "";

            // agent
            $this->agent->HrefValue = "";

            // comm
            $this->comm->HrefValue = "";

            // material
            $this->material->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // m_hsn
            $this->m_hsn->HrefValue = "";

            // @
            $this->_40->HrefValue = "";

            // lr_no
            $this->lr_no->HrefValue = "";

            // km
            $this->km->HrefValue = "";

            // freight_type
            $this->freight_type->HrefValue = "";

            // freight
            $this->freight->HrefValue = "";

            // ded_det
            $this->ded_det->HrefValue = "";

            // ded_det_remarks
            $this->ded_det_remarks->HrefValue = "";

            // gst_percent
            $this->gst_percent->HrefValue = "";

            // gst_amount
            $this->gst_amount->HrefValue = "";
            $this->gst_amount->TooltipValue = "";

            // final_amount
            $this->final_amount->HrefValue = "";
            $this->final_amount->TooltipValue = "";

            // load_km
            $this->load_km->HrefValue = "";

            // unload_km
            $this->unload_km->HrefValue = "";

            // delivery_receipt
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
            if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
                $this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
                $this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
                }
            } else {
                $this->delivery_receipt->HrefValue = "";
            }
            $this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;

            // delivery_docket
            $this->delivery_docket->HrefValue = "";

            // diesal_op_b
            $this->diesal_op_b->HrefValue = "";
            $this->diesal_op_b->TooltipValue = "";

            // diesal_required
            $this->diesal_required->HrefValue = "";
            $this->diesal_required->TooltipValue = "";

            // diesal_fill
            $this->diesal_fill->HrefValue = "";
            $this->diesal_fill->TooltipValue = "";

            // diesal_amount
            $this->diesal_amount->HrefValue = "";
            $this->diesal_amount->TooltipValue = "";

            // diesal_cl_balance
            $this->diesal_cl_balance->HrefValue = "";
            $this->diesal_cl_balance->TooltipValue = "";

            // vehicle_average
            $this->vehicle_average->HrefValue = "";
            $this->vehicle_average->TooltipValue = "";

            // cash_required
            $this->cash_required->HrefValue = "";
            $this->cash_required->TooltipValue = "";

            // cash_op_b
            $this->cash_op_b->HrefValue = "";
            $this->cash_op_b->TooltipValue = "";

            // cash_paid
            $this->cash_paid->HrefValue = "";
            $this->cash_paid->TooltipValue = "";

            // cash_expenses
            $this->cash_expenses->HrefValue = "";
            $this->cash_expenses->TooltipValue = "";

            // cash_cl_balance
            $this->cash_cl_balance->HrefValue = "";
            $this->cash_cl_balance->TooltipValue = "";

            // fasttag_op_b
            $this->fasttag_op_b->HrefValue = "";
            $this->fasttag_op_b->TooltipValue = "";

            // fasttag_recharge
            $this->fasttag_recharge->HrefValue = "";
            $this->fasttag_recharge->TooltipValue = "";

            // fasttag_expenses
            $this->fasttag_expenses->HrefValue = "";
            $this->fasttag_expenses->TooltipValue = "";

            // toll_expenses_cash
            $this->toll_expenses_cash->HrefValue = "";
            $this->toll_expenses_cash->TooltipValue = "";

            // fasttag_cl_balance
            $this->fasttag_cl_balance->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->htmlDecode($this->uploads->Upload->DbValue)); // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // consignor
            $this->consignor->HrefValue = "";

            // vehicle_freight_comm
            $this->vehicle_freight_comm->HrefValue = "";

            // vehicle_freight_type
            $this->vehicle_freight_type->HrefValue = "";

            // vehicle_freight_amount
            $this->vehicle_freight_amount->HrefValue = "";

            // vehicle_freight_final
            $this->vehicle_freight_final->HrefValue = "";
            $this->vehicle_freight_final->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // vehicle_type
            $this->vehicle_type->setupEditAttributes();
            $this->vehicle_type->EditValue = $this->vehicle_type->options(true);
            $this->vehicle_type->PlaceHolder = RemoveHtml($this->vehicle_type->caption());

            // vehicle
            $this->vehicle->setupEditAttributes();
            $this->vehicle->EditValue = $this->vehicle->CurrentValue;
            $curVal = strval($this->vehicle->CurrentValue);
            if ($curVal != "") {
                $this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
                if ($this->vehicle->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                    $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                        $this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
                    } else {
                        $this->vehicle->EditValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                    }
                }
            } else {
                $this->vehicle->EditValue = null;
            }

            // route
            $this->_route->setupEditAttributes();
            $this->_route->EditValue = $this->_route->CurrentValue;
            $curVal = strval($this->_route->CurrentValue);
            if ($curVal != "") {
                $this->_route->EditValue = $this->_route->lookupCacheOption($curVal);
                if ($this->_route->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                        $this->_route->EditValue = $this->_route->displayValue($arwrk);
                    } else {
                        $this->_route->EditValue = HtmlEncode(FormatNumber($this->_route->CurrentValue, $this->_route->formatPattern()));
                    }
                }
            } else {
                $this->_route->EditValue = null;
            }
            $this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

            // route_name
            $this->route_name->setupEditAttributes();
            $this->route_name->EditValue = $this->route_name->CurrentValue;

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->CurrentValue));
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->CurrentValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // buyer
            $this->buyer->setupEditAttributes();
            $this->buyer->EditValue = $this->buyer->CurrentValue;
            $curVal = strval($this->buyer->CurrentValue);
            if ($curVal != "") {
                $this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->EditValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->EditValue = HtmlEncode(FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern()));
                    }
                }
            } else {
                $this->buyer->EditValue = null;
            }
            $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

            // b_consignor
            $this->b_consignor->setupEditAttributes();
            $this->b_consignor->EditValue = $this->b_consignor->CurrentValue;
            $curVal = strval($this->b_consignor->CurrentValue);
            if ($curVal != "") {
                $this->b_consignor->EditValue = $this->b_consignor->lookupCacheOption($curVal);
                if ($this->b_consignor->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignor->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignor->EditValue = $this->b_consignor->displayValue($arwrk);
                    } else {
                        $this->b_consignor->EditValue = HtmlEncode($this->b_consignor->CurrentValue);
                    }
                }
            } else {
                $this->b_consignor->EditValue = null;
            }
            $this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());

            // b_consignee
            $this->b_consignee->setupEditAttributes();
            $this->b_consignee->EditValue = $this->b_consignee->CurrentValue;
            $curVal = strval($this->b_consignee->CurrentValue);
            if ($curVal != "") {
                $this->b_consignee->EditValue = $this->b_consignee->lookupCacheOption($curVal);
                if ($this->b_consignee->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->b_consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->b_consignee->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->b_consignee->Lookup->renderViewRow($rswrk[0]);
                        $this->b_consignee->EditValue = $this->b_consignee->displayValue($arwrk);
                    } else {
                        $this->b_consignee->EditValue = HtmlEncode($this->b_consignee->CurrentValue);
                    }
                }
            } else {
                $this->b_consignee->EditValue = null;
            }
            $this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());

            // load_date
            $this->load_date->setupEditAttributes();
            $this->load_date->EditValue = HtmlEncode(FormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern()));
            $this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

            // load_weight
            $this->load_weight->setupEditAttributes();
            $this->load_weight->EditValue = $this->load_weight->CurrentValue;
            $this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());
            if (strval($this->load_weight->EditValue) != "" && is_numeric($this->load_weight->EditValue)) {
                $this->load_weight->EditValue = FormatNumber($this->load_weight->EditValue, null);
            }

            // unload_date
            $this->unload_date->setupEditAttributes();
            $this->unload_date->EditValue = HtmlEncode(FormatDateTime($this->unload_date->CurrentValue, $this->unload_date->formatPattern()));
            $this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

            // unload_weight
            $this->unload_weight->setupEditAttributes();
            $this->unload_weight->EditValue = $this->unload_weight->CurrentValue;
            $this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());
            if (strval($this->unload_weight->EditValue) != "" && is_numeric($this->unload_weight->EditValue)) {
                $this->unload_weight->EditValue = FormatNumber($this->unload_weight->EditValue, null);
            }

            // invoice_no
            $this->invoice_no->setupEditAttributes();
            $this->invoice_no->EditValue = $this->invoice_no->CurrentValue;
            $this->invoice_no->EditValue = FormatNumber($this->invoice_no->EditValue, $this->invoice_no->formatPattern());

            // invoice_date
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->EditValue = FormatDateTime($this->invoice_date->EditValue, $this->invoice_date->formatPattern());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, $this->amount->formatPattern());

            // delivery_pod
            $this->delivery_pod->EditValue = $this->delivery_pod->options(false);
            $this->delivery_pod->PlaceHolder = RemoveHtml($this->delivery_pod->caption());

            // status
            $this->status->setupEditAttributes();
            if (strval($this->status->CurrentValue) != "") {
                $this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->EditValue = null;
            }

            // days
            $this->days->setupEditAttributes();
            $this->days->EditValue = $this->days->CurrentValue;
            $this->days->EditValue = FormatNumber($this->days->EditValue, $this->days->formatPattern());

            // driver
            $this->driver->setupEditAttributes();
            $curVal = trim(strval($this->driver->CurrentValue));
            if ($curVal != "") {
                $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
            } else {
                $this->driver->ViewValue = $this->driver->Lookup !== null && is_array($this->driver->lookupOptions()) && count($this->driver->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->driver->ViewValue !== null) { // Load from cache
                $this->driver->EditValue = array_values($this->driver->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->driver->CurrentValue, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                $sqlWrk = $this->driver->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->driver->EditValue = $arwrk;
            }
            $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

            // driver_name
            $this->driver_name->setupEditAttributes();
            if (!$this->driver_name->Raw) {
                $this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
            }
            $this->driver_name->EditValue = HtmlEncode($this->driver_name->CurrentValue);
            $this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

            // agent
            $this->agent->setupEditAttributes();
            $this->agent->EditValue = $this->agent->CurrentValue;
            $curVal = strval($this->agent->CurrentValue);
            if ($curVal != "") {
                $this->agent->EditValue = $this->agent->lookupCacheOption($curVal);
                if ($this->agent->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                        $this->agent->EditValue = $this->agent->displayValue($arwrk);
                    } else {
                        $this->agent->EditValue = HtmlEncode(FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern()));
                    }
                }
            } else {
                $this->agent->EditValue = null;
            }
            $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

            // comm
            $this->comm->setupEditAttributes();
            $this->comm->EditValue = $this->comm->CurrentValue;
            $this->comm->PlaceHolder = RemoveHtml($this->comm->caption());
            if (strval($this->comm->EditValue) != "" && is_numeric($this->comm->EditValue)) {
                $this->comm->EditValue = FormatNumber($this->comm->EditValue, null);
            }

            // material
            $this->material->setupEditAttributes();
            if (!$this->material->Raw) {
                $this->material->CurrentValue = HtmlDecode($this->material->CurrentValue);
            }
            $this->material->EditValue = HtmlEncode($this->material->CurrentValue);
            $this->material->PlaceHolder = RemoveHtml($this->material->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            if (!$this->packing_type->Raw) {
                $this->packing_type->CurrentValue = HtmlDecode($this->packing_type->CurrentValue);
            }
            $this->packing_type->EditValue = HtmlEncode($this->packing_type->CurrentValue);
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // m_hsn
            $this->m_hsn->setupEditAttributes();
            if (!$this->m_hsn->Raw) {
                $this->m_hsn->CurrentValue = HtmlDecode($this->m_hsn->CurrentValue);
            }
            $this->m_hsn->EditValue = HtmlEncode($this->m_hsn->CurrentValue);
            $this->m_hsn->PlaceHolder = RemoveHtml($this->m_hsn->caption());

            // @
            $this->_40->setupEditAttributes();
            $this->_40->EditValue = $this->_40->CurrentValue;
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
            if (strval($this->_40->EditValue) != "" && is_numeric($this->_40->EditValue)) {
                $this->_40->EditValue = FormatNumber($this->_40->EditValue, null);
            }

            // lr_no
            $this->lr_no->setupEditAttributes();
            if (!$this->lr_no->Raw) {
                $this->lr_no->CurrentValue = HtmlDecode($this->lr_no->CurrentValue);
            }
            $this->lr_no->EditValue = HtmlEncode($this->lr_no->CurrentValue);
            $this->lr_no->PlaceHolder = RemoveHtml($this->lr_no->caption());

            // km
            $this->km->setupEditAttributes();
            $this->km->EditValue = $this->km->CurrentValue;
            $this->km->PlaceHolder = RemoveHtml($this->km->caption());
            if (strval($this->km->EditValue) != "" && is_numeric($this->km->EditValue)) {
                $this->km->EditValue = FormatNumber($this->km->EditValue, null);
            }

            // freight_type
            $this->freight_type->setupEditAttributes();
            $this->freight_type->EditValue = $this->freight_type->options(true);
            $this->freight_type->PlaceHolder = RemoveHtml($this->freight_type->caption());

            // freight
            $this->freight->setupEditAttributes();
            $this->freight->EditValue = $this->freight->CurrentValue;
            $this->freight->PlaceHolder = RemoveHtml($this->freight->caption());
            if (strval($this->freight->EditValue) != "" && is_numeric($this->freight->EditValue)) {
                $this->freight->EditValue = FormatNumber($this->freight->EditValue, null);
            }

            // ded_det
            $this->ded_det->setupEditAttributes();
            $this->ded_det->EditValue = $this->ded_det->CurrentValue;
            $this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());
            if (strval($this->ded_det->EditValue) != "" && is_numeric($this->ded_det->EditValue)) {
                $this->ded_det->EditValue = FormatNumber($this->ded_det->EditValue, null);
            }

            // ded_det_remarks
            $this->ded_det_remarks->setupEditAttributes();
            if (!$this->ded_det_remarks->Raw) {
                $this->ded_det_remarks->CurrentValue = HtmlDecode($this->ded_det_remarks->CurrentValue);
            }
            $this->ded_det_remarks->EditValue = HtmlEncode($this->ded_det_remarks->CurrentValue);
            $this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

            // gst_percent
            $this->gst_percent->setupEditAttributes();
            $this->gst_percent->EditValue = $this->gst_percent->CurrentValue;
            $this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());
            if (strval($this->gst_percent->EditValue) != "" && is_numeric($this->gst_percent->EditValue)) {
                $this->gst_percent->EditValue = FormatNumber($this->gst_percent->EditValue, null);
            }

            // gst_amount
            $this->gst_amount->setupEditAttributes();
            $this->gst_amount->EditValue = $this->gst_amount->CurrentValue;
            $this->gst_amount->EditValue = FormatNumber($this->gst_amount->EditValue, $this->gst_amount->formatPattern());

            // final_amount
            $this->final_amount->setupEditAttributes();
            $this->final_amount->EditValue = $this->final_amount->CurrentValue;
            $this->final_amount->EditValue = FormatNumber($this->final_amount->EditValue, $this->final_amount->formatPattern());

            // load_km
            $this->load_km->setupEditAttributes();
            $this->load_km->EditValue = $this->load_km->CurrentValue;
            $this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());
            if (strval($this->load_km->EditValue) != "" && is_numeric($this->load_km->EditValue)) {
                $this->load_km->EditValue = FormatNumber($this->load_km->EditValue, null);
            }

            // unload_km
            $this->unload_km->setupEditAttributes();
            $this->unload_km->EditValue = $this->unload_km->CurrentValue;
            $this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());
            if (strval($this->unload_km->EditValue) != "" && is_numeric($this->unload_km->EditValue)) {
                $this->unload_km->EditValue = FormatNumber($this->unload_km->EditValue, null);
            }

            // delivery_receipt
            $this->delivery_receipt->setupEditAttributes();
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
            if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
                $this->delivery_receipt->ImageWidth = 0;
                $this->delivery_receipt->ImageHeight = 50;
                $this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
                $this->delivery_receipt->ImageCssClass = "ew-image";
                $this->delivery_receipt->EditValue = $this->delivery_receipt->Upload->DbValue;
            } else {
                $this->delivery_receipt->EditValue = "";
            }
            if (!EmptyValue($this->delivery_receipt->CurrentValue)) {
                $this->delivery_receipt->Upload->FileName = $this->delivery_receipt->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->delivery_receipt);
            }

            // delivery_docket
            $this->delivery_docket->setupEditAttributes();
            if (!$this->delivery_docket->Raw) {
                $this->delivery_docket->CurrentValue = HtmlDecode($this->delivery_docket->CurrentValue);
            }
            $this->delivery_docket->EditValue = HtmlEncode($this->delivery_docket->CurrentValue);
            $this->delivery_docket->PlaceHolder = RemoveHtml($this->delivery_docket->caption());

            // diesal_op_b
            $this->diesal_op_b->setupEditAttributes();
            $this->diesal_op_b->EditValue = $this->diesal_op_b->CurrentValue;
            $this->diesal_op_b->EditValue = FormatNumber($this->diesal_op_b->EditValue, $this->diesal_op_b->formatPattern());

            // diesal_required
            $this->diesal_required->setupEditAttributes();
            $this->diesal_required->EditValue = $this->diesal_required->CurrentValue;
            $this->diesal_required->EditValue = FormatNumber($this->diesal_required->EditValue, $this->diesal_required->formatPattern());

            // diesal_fill
            $this->diesal_fill->setupEditAttributes();
            $this->diesal_fill->EditValue = $this->diesal_fill->CurrentValue;
            $this->diesal_fill->EditValue = FormatNumber($this->diesal_fill->EditValue, $this->diesal_fill->formatPattern());

            // diesal_amount
            $this->diesal_amount->setupEditAttributes();
            $this->diesal_amount->EditValue = $this->diesal_amount->CurrentValue;
            $this->diesal_amount->EditValue = FormatNumber($this->diesal_amount->EditValue, $this->diesal_amount->formatPattern());

            // diesal_cl_balance
            $this->diesal_cl_balance->setupEditAttributes();
            $this->diesal_cl_balance->EditValue = $this->diesal_cl_balance->CurrentValue;
            $this->diesal_cl_balance->EditValue = FormatNumber($this->diesal_cl_balance->EditValue, $this->diesal_cl_balance->formatPattern());

            // vehicle_average
            $this->vehicle_average->setupEditAttributes();
            $this->vehicle_average->EditValue = $this->vehicle_average->CurrentValue;
            $this->vehicle_average->EditValue = FormatNumber($this->vehicle_average->EditValue, $this->vehicle_average->formatPattern());

            // cash_required
            $this->cash_required->setupEditAttributes();
            $this->cash_required->EditValue = $this->cash_required->CurrentValue;
            $this->cash_required->EditValue = FormatNumber($this->cash_required->EditValue, $this->cash_required->formatPattern());

            // cash_op_b
            $this->cash_op_b->setupEditAttributes();
            $this->cash_op_b->EditValue = $this->cash_op_b->CurrentValue;
            $this->cash_op_b->EditValue = FormatNumber($this->cash_op_b->EditValue, $this->cash_op_b->formatPattern());

            // cash_paid
            $this->cash_paid->setupEditAttributes();
            $this->cash_paid->EditValue = $this->cash_paid->CurrentValue;
            $this->cash_paid->EditValue = FormatNumber($this->cash_paid->EditValue, $this->cash_paid->formatPattern());

            // cash_expenses
            $this->cash_expenses->setupEditAttributes();
            $this->cash_expenses->EditValue = $this->cash_expenses->CurrentValue;
            $this->cash_expenses->EditValue = FormatNumber($this->cash_expenses->EditValue, $this->cash_expenses->formatPattern());

            // cash_cl_balance
            $this->cash_cl_balance->setupEditAttributes();
            $this->cash_cl_balance->EditValue = $this->cash_cl_balance->CurrentValue;
            $this->cash_cl_balance->EditValue = FormatNumber($this->cash_cl_balance->EditValue, $this->cash_cl_balance->formatPattern());

            // fasttag_op_b
            $this->fasttag_op_b->setupEditAttributes();
            $this->fasttag_op_b->EditValue = $this->fasttag_op_b->CurrentValue;
            $this->fasttag_op_b->EditValue = FormatNumber($this->fasttag_op_b->EditValue, $this->fasttag_op_b->formatPattern());

            // fasttag_recharge
            $this->fasttag_recharge->setupEditAttributes();
            $this->fasttag_recharge->EditValue = $this->fasttag_recharge->CurrentValue;
            $this->fasttag_recharge->EditValue = FormatNumber($this->fasttag_recharge->EditValue, $this->fasttag_recharge->formatPattern());

            // fasttag_expenses
            $this->fasttag_expenses->setupEditAttributes();
            $this->fasttag_expenses->EditValue = $this->fasttag_expenses->CurrentValue;
            $this->fasttag_expenses->EditValue = FormatNumber($this->fasttag_expenses->EditValue, $this->fasttag_expenses->formatPattern());

            // toll_expenses_cash
            $this->toll_expenses_cash->setupEditAttributes();
            $this->toll_expenses_cash->EditValue = $this->toll_expenses_cash->CurrentValue;
            $this->toll_expenses_cash->EditValue = FormatNumber($this->toll_expenses_cash->EditValue, $this->toll_expenses_cash->formatPattern());

            // fasttag_cl_balance
            $this->fasttag_cl_balance->setupEditAttributes();
            $this->fasttag_cl_balance->EditValue = $this->fasttag_cl_balance->CurrentValue;
            $this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());
            if (strval($this->fasttag_cl_balance->EditValue) != "" && is_numeric($this->fasttag_cl_balance->EditValue)) {
                $this->fasttag_cl_balance->EditValue = FormatNumber($this->fasttag_cl_balance->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->uploads);
            }

            // consignor
            $this->consignor->setupEditAttributes();
            $this->consignor->EditCustomAttributes = $this->consignor->getEditCustomAttributes(); // PHP
            $this->consignor->EditValue = $this->consignor->CurrentValue;
            $curVal = strval($this->consignor->CurrentValue);
            if ($curVal != "") {
                $this->consignor->EditValue = $this->consignor->lookupCacheOption($curVal);
                if ($this->consignor->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->consignor->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->consignor->Lookup->renderViewRow($rswrk[0]);
                        $this->consignor->EditValue = $this->consignor->displayValue($arwrk);
                    } else {
                        $this->consignor->EditValue = HtmlEncode(FormatNumber($this->consignor->CurrentValue, $this->consignor->formatPattern()));
                    }
                }
            } else {
                $this->consignor->EditValue = null;
            }
            $this->consignor->PlaceHolder = RemoveHtml($this->consignor->caption());

            // vehicle_freight_comm
            $this->vehicle_freight_comm->setupEditAttributes();
            $this->vehicle_freight_comm->EditValue = $this->vehicle_freight_comm->CurrentValue;
            $this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());
            if (strval($this->vehicle_freight_comm->EditValue) != "" && is_numeric($this->vehicle_freight_comm->EditValue)) {
                $this->vehicle_freight_comm->EditValue = FormatNumber($this->vehicle_freight_comm->EditValue, null);
            }

            // vehicle_freight_type
            $this->vehicle_freight_type->setupEditAttributes();
            $this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(true);
            $this->vehicle_freight_type->PlaceHolder = RemoveHtml($this->vehicle_freight_type->caption());

            // vehicle_freight_amount
            $this->vehicle_freight_amount->setupEditAttributes();
            $this->vehicle_freight_amount->EditValue = $this->vehicle_freight_amount->CurrentValue;
            $this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());
            if (strval($this->vehicle_freight_amount->EditValue) != "" && is_numeric($this->vehicle_freight_amount->EditValue)) {
                $this->vehicle_freight_amount->EditValue = FormatNumber($this->vehicle_freight_amount->EditValue, null);
            }

            // vehicle_freight_final
            $this->vehicle_freight_final->setupEditAttributes();
            $this->vehicle_freight_final->EditValue = $this->vehicle_freight_final->CurrentValue;
            $this->vehicle_freight_final->EditValue = FormatNumber($this->vehicle_freight_final->EditValue, $this->vehicle_freight_final->formatPattern());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // vehicle_type
            $this->vehicle_type->HrefValue = "";

            // vehicle
            $this->vehicle->HrefValue = "";
            $this->vehicle->TooltipValue = "";

            // route
            $this->_route->HrefValue = "";

            // route_name
            $this->route_name->HrefValue = "";
            $this->route_name->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";

            // buyer
            $this->buyer->HrefValue = "";

            // b_consignor
            $this->b_consignor->HrefValue = "";

            // b_consignee
            $this->b_consignee->HrefValue = "";

            // load_date
            $this->load_date->HrefValue = "";

            // load_weight
            $this->load_weight->HrefValue = "";

            // unload_date
            $this->unload_date->HrefValue = "";

            // unload_weight
            $this->unload_weight->HrefValue = "";

            // invoice_no
            $this->invoice_no->HrefValue = "";
            $this->invoice_no->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // delivery_pod
            $this->delivery_pod->HrefValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // days
            $this->days->HrefValue = "";
            $this->days->TooltipValue = "";

            // driver
            $this->driver->HrefValue = "";

            // driver_name
            $this->driver_name->HrefValue = "";

            // agent
            $this->agent->HrefValue = "";

            // comm
            $this->comm->HrefValue = "";

            // material
            $this->material->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // m_hsn
            $this->m_hsn->HrefValue = "";

            // @
            $this->_40->HrefValue = "";

            // lr_no
            $this->lr_no->HrefValue = "";

            // km
            $this->km->HrefValue = "";

            // freight_type
            $this->freight_type->HrefValue = "";

            // freight
            $this->freight->HrefValue = "";

            // ded_det
            $this->ded_det->HrefValue = "";

            // ded_det_remarks
            $this->ded_det_remarks->HrefValue = "";

            // gst_percent
            $this->gst_percent->HrefValue = "";

            // gst_amount
            $this->gst_amount->HrefValue = "";
            $this->gst_amount->TooltipValue = "";

            // final_amount
            $this->final_amount->HrefValue = "";
            $this->final_amount->TooltipValue = "";

            // load_km
            $this->load_km->HrefValue = "";

            // unload_km
            $this->unload_km->HrefValue = "";

            // delivery_receipt
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
            if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
                $this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
                $this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
                }
            } else {
                $this->delivery_receipt->HrefValue = "";
            }
            $this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;

            // delivery_docket
            $this->delivery_docket->HrefValue = "";

            // diesal_op_b
            $this->diesal_op_b->HrefValue = "";
            $this->diesal_op_b->TooltipValue = "";

            // diesal_required
            $this->diesal_required->HrefValue = "";
            $this->diesal_required->TooltipValue = "";

            // diesal_fill
            $this->diesal_fill->HrefValue = "";
            $this->diesal_fill->TooltipValue = "";

            // diesal_amount
            $this->diesal_amount->HrefValue = "";
            $this->diesal_amount->TooltipValue = "";

            // diesal_cl_balance
            $this->diesal_cl_balance->HrefValue = "";
            $this->diesal_cl_balance->TooltipValue = "";

            // vehicle_average
            $this->vehicle_average->HrefValue = "";
            $this->vehicle_average->TooltipValue = "";

            // cash_required
            $this->cash_required->HrefValue = "";
            $this->cash_required->TooltipValue = "";

            // cash_op_b
            $this->cash_op_b->HrefValue = "";
            $this->cash_op_b->TooltipValue = "";

            // cash_paid
            $this->cash_paid->HrefValue = "";
            $this->cash_paid->TooltipValue = "";

            // cash_expenses
            $this->cash_expenses->HrefValue = "";
            $this->cash_expenses->TooltipValue = "";

            // cash_cl_balance
            $this->cash_cl_balance->HrefValue = "";
            $this->cash_cl_balance->TooltipValue = "";

            // fasttag_op_b
            $this->fasttag_op_b->HrefValue = "";
            $this->fasttag_op_b->TooltipValue = "";

            // fasttag_recharge
            $this->fasttag_recharge->HrefValue = "";
            $this->fasttag_recharge->TooltipValue = "";

            // fasttag_expenses
            $this->fasttag_expenses->HrefValue = "";
            $this->fasttag_expenses->TooltipValue = "";

            // toll_expenses_cash
            $this->toll_expenses_cash->HrefValue = "";
            $this->toll_expenses_cash->TooltipValue = "";

            // fasttag_cl_balance
            $this->fasttag_cl_balance->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->htmlDecode($this->uploads->Upload->DbValue)); // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // consignor
            $this->consignor->HrefValue = "";

            // vehicle_freight_comm
            $this->vehicle_freight_comm->HrefValue = "";

            // vehicle_freight_type
            $this->vehicle_freight_type->HrefValue = "";

            // vehicle_freight_amount
            $this->vehicle_freight_amount->HrefValue = "";

            // vehicle_freight_final
            $this->vehicle_freight_final->HrefValue = "";
            $this->vehicle_freight_final->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->vehicle_type->Visible && $this->vehicle_type->Required) {
                if (!$this->vehicle_type->IsDetailKey && EmptyValue($this->vehicle_type->FormValue)) {
                    $this->vehicle_type->addErrorMessage(str_replace("%s", $this->vehicle_type->caption(), $this->vehicle_type->RequiredErrorMessage));
                }
            }
            if ($this->vehicle->Visible && $this->vehicle->Required) {
                if (!$this->vehicle->IsDetailKey && EmptyValue($this->vehicle->FormValue)) {
                    $this->vehicle->addErrorMessage(str_replace("%s", $this->vehicle->caption(), $this->vehicle->RequiredErrorMessage));
                }
            }
            if ($this->_route->Visible && $this->_route->Required) {
                if (!$this->_route->IsDetailKey && EmptyValue($this->_route->FormValue)) {
                    $this->_route->addErrorMessage(str_replace("%s", $this->_route->caption(), $this->_route->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->_route->FormValue)) {
                $this->_route->addErrorMessage($this->_route->getErrorMessage(false));
            }
            if ($this->route_name->Visible && $this->route_name->Required) {
                if (!$this->route_name->IsDetailKey && EmptyValue($this->route_name->FormValue)) {
                    $this->route_name->addErrorMessage(str_replace("%s", $this->route_name->caption(), $this->route_name->RequiredErrorMessage));
                }
            }
            if ($this->reports_to->Visible && $this->reports_to->Required) {
                if (!$this->reports_to->IsDetailKey && EmptyValue($this->reports_to->FormValue)) {
                    $this->reports_to->addErrorMessage(str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
                }
            }
            if ($this->buyer->Visible && $this->buyer->Required) {
                if (!$this->buyer->IsDetailKey && EmptyValue($this->buyer->FormValue)) {
                    $this->buyer->addErrorMessage(str_replace("%s", $this->buyer->caption(), $this->buyer->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->buyer->FormValue)) {
                $this->buyer->addErrorMessage($this->buyer->getErrorMessage(false));
            }
            if ($this->b_consignor->Visible && $this->b_consignor->Required) {
                if (!$this->b_consignor->IsDetailKey && EmptyValue($this->b_consignor->FormValue)) {
                    $this->b_consignor->addErrorMessage(str_replace("%s", $this->b_consignor->caption(), $this->b_consignor->RequiredErrorMessage));
                }
            }
            if ($this->b_consignee->Visible && $this->b_consignee->Required) {
                if (!$this->b_consignee->IsDetailKey && EmptyValue($this->b_consignee->FormValue)) {
                    $this->b_consignee->addErrorMessage(str_replace("%s", $this->b_consignee->caption(), $this->b_consignee->RequiredErrorMessage));
                }
            }
            if ($this->load_date->Visible && $this->load_date->Required) {
                if (!$this->load_date->IsDetailKey && EmptyValue($this->load_date->FormValue)) {
                    $this->load_date->addErrorMessage(str_replace("%s", $this->load_date->caption(), $this->load_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->load_date->FormValue, $this->load_date->formatPattern())) {
                $this->load_date->addErrorMessage($this->load_date->getErrorMessage(false));
            }
            if ($this->load_weight->Visible && $this->load_weight->Required) {
                if (!$this->load_weight->IsDetailKey && EmptyValue($this->load_weight->FormValue)) {
                    $this->load_weight->addErrorMessage(str_replace("%s", $this->load_weight->caption(), $this->load_weight->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->load_weight->FormValue)) {
                $this->load_weight->addErrorMessage($this->load_weight->getErrorMessage(false));
            }
            if ($this->unload_date->Visible && $this->unload_date->Required) {
                if (!$this->unload_date->IsDetailKey && EmptyValue($this->unload_date->FormValue)) {
                    $this->unload_date->addErrorMessage(str_replace("%s", $this->unload_date->caption(), $this->unload_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->unload_date->FormValue, $this->unload_date->formatPattern())) {
                $this->unload_date->addErrorMessage($this->unload_date->getErrorMessage(false));
            }
            if ($this->unload_weight->Visible && $this->unload_weight->Required) {
                if (!$this->unload_weight->IsDetailKey && EmptyValue($this->unload_weight->FormValue)) {
                    $this->unload_weight->addErrorMessage(str_replace("%s", $this->unload_weight->caption(), $this->unload_weight->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->unload_weight->FormValue)) {
                $this->unload_weight->addErrorMessage($this->unload_weight->getErrorMessage(false));
            }
            if ($this->invoice_no->Visible && $this->invoice_no->Required) {
                if (!$this->invoice_no->IsDetailKey && EmptyValue($this->invoice_no->FormValue)) {
                    $this->invoice_no->addErrorMessage(str_replace("%s", $this->invoice_no->caption(), $this->invoice_no->RequiredErrorMessage));
                }
            }
            if ($this->invoice_date->Visible && $this->invoice_date->Required) {
                if (!$this->invoice_date->IsDetailKey && EmptyValue($this->invoice_date->FormValue)) {
                    $this->invoice_date->addErrorMessage(str_replace("%s", $this->invoice_date->caption(), $this->invoice_date->RequiredErrorMessage));
                }
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if ($this->delivery_pod->Visible && $this->delivery_pod->Required) {
                if ($this->delivery_pod->FormValue == "") {
                    $this->delivery_pod->addErrorMessage(str_replace("%s", $this->delivery_pod->caption(), $this->delivery_pod->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->days->Visible && $this->days->Required) {
                if (!$this->days->IsDetailKey && EmptyValue($this->days->FormValue)) {
                    $this->days->addErrorMessage(str_replace("%s", $this->days->caption(), $this->days->RequiredErrorMessage));
                }
            }
            if ($this->driver->Visible && $this->driver->Required) {
                if (!$this->driver->IsDetailKey && EmptyValue($this->driver->FormValue)) {
                    $this->driver->addErrorMessage(str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
                }
            }
            if ($this->driver_name->Visible && $this->driver_name->Required) {
                if (!$this->driver_name->IsDetailKey && EmptyValue($this->driver_name->FormValue)) {
                    $this->driver_name->addErrorMessage(str_replace("%s", $this->driver_name->caption(), $this->driver_name->RequiredErrorMessage));
                }
            }
            if ($this->agent->Visible && $this->agent->Required) {
                if (!$this->agent->IsDetailKey && EmptyValue($this->agent->FormValue)) {
                    $this->agent->addErrorMessage(str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->agent->FormValue)) {
                $this->agent->addErrorMessage($this->agent->getErrorMessage(false));
            }
            if ($this->comm->Visible && $this->comm->Required) {
                if (!$this->comm->IsDetailKey && EmptyValue($this->comm->FormValue)) {
                    $this->comm->addErrorMessage(str_replace("%s", $this->comm->caption(), $this->comm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->comm->FormValue)) {
                $this->comm->addErrorMessage($this->comm->getErrorMessage(false));
            }
            if ($this->material->Visible && $this->material->Required) {
                if (!$this->material->IsDetailKey && EmptyValue($this->material->FormValue)) {
                    $this->material->addErrorMessage(str_replace("%s", $this->material->caption(), $this->material->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->m_hsn->Visible && $this->m_hsn->Required) {
                if (!$this->m_hsn->IsDetailKey && EmptyValue($this->m_hsn->FormValue)) {
                    $this->m_hsn->addErrorMessage(str_replace("%s", $this->m_hsn->caption(), $this->m_hsn->RequiredErrorMessage));
                }
            }
            if ($this->_40->Visible && $this->_40->Required) {
                if (!$this->_40->IsDetailKey && EmptyValue($this->_40->FormValue)) {
                    $this->_40->addErrorMessage(str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_40->FormValue)) {
                $this->_40->addErrorMessage($this->_40->getErrorMessage(false));
            }
            if ($this->lr_no->Visible && $this->lr_no->Required) {
                if (!$this->lr_no->IsDetailKey && EmptyValue($this->lr_no->FormValue)) {
                    $this->lr_no->addErrorMessage(str_replace("%s", $this->lr_no->caption(), $this->lr_no->RequiredErrorMessage));
                }
            }
            if ($this->km->Visible && $this->km->Required) {
                if (!$this->km->IsDetailKey && EmptyValue($this->km->FormValue)) {
                    $this->km->addErrorMessage(str_replace("%s", $this->km->caption(), $this->km->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->km->FormValue)) {
                $this->km->addErrorMessage($this->km->getErrorMessage(false));
            }
            if ($this->freight_type->Visible && $this->freight_type->Required) {
                if (!$this->freight_type->IsDetailKey && EmptyValue($this->freight_type->FormValue)) {
                    $this->freight_type->addErrorMessage(str_replace("%s", $this->freight_type->caption(), $this->freight_type->RequiredErrorMessage));
                }
            }
            if ($this->freight->Visible && $this->freight->Required) {
                if (!$this->freight->IsDetailKey && EmptyValue($this->freight->FormValue)) {
                    $this->freight->addErrorMessage(str_replace("%s", $this->freight->caption(), $this->freight->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->freight->FormValue)) {
                $this->freight->addErrorMessage($this->freight->getErrorMessage(false));
            }
            if ($this->ded_det->Visible && $this->ded_det->Required) {
                if (!$this->ded_det->IsDetailKey && EmptyValue($this->ded_det->FormValue)) {
                    $this->ded_det->addErrorMessage(str_replace("%s", $this->ded_det->caption(), $this->ded_det->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->ded_det->FormValue)) {
                $this->ded_det->addErrorMessage($this->ded_det->getErrorMessage(false));
            }
            if ($this->ded_det_remarks->Visible && $this->ded_det_remarks->Required) {
                if (!$this->ded_det_remarks->IsDetailKey && EmptyValue($this->ded_det_remarks->FormValue)) {
                    $this->ded_det_remarks->addErrorMessage(str_replace("%s", $this->ded_det_remarks->caption(), $this->ded_det_remarks->RequiredErrorMessage));
                }
            }
            if ($this->gst_percent->Visible && $this->gst_percent->Required) {
                if (!$this->gst_percent->IsDetailKey && EmptyValue($this->gst_percent->FormValue)) {
                    $this->gst_percent->addErrorMessage(str_replace("%s", $this->gst_percent->caption(), $this->gst_percent->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->gst_percent->FormValue)) {
                $this->gst_percent->addErrorMessage($this->gst_percent->getErrorMessage(false));
            }
            if ($this->gst_amount->Visible && $this->gst_amount->Required) {
                if (!$this->gst_amount->IsDetailKey && EmptyValue($this->gst_amount->FormValue)) {
                    $this->gst_amount->addErrorMessage(str_replace("%s", $this->gst_amount->caption(), $this->gst_amount->RequiredErrorMessage));
                }
            }
            if ($this->final_amount->Visible && $this->final_amount->Required) {
                if (!$this->final_amount->IsDetailKey && EmptyValue($this->final_amount->FormValue)) {
                    $this->final_amount->addErrorMessage(str_replace("%s", $this->final_amount->caption(), $this->final_amount->RequiredErrorMessage));
                }
            }
            if ($this->load_km->Visible && $this->load_km->Required) {
                if (!$this->load_km->IsDetailKey && EmptyValue($this->load_km->FormValue)) {
                    $this->load_km->addErrorMessage(str_replace("%s", $this->load_km->caption(), $this->load_km->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->load_km->FormValue)) {
                $this->load_km->addErrorMessage($this->load_km->getErrorMessage(false));
            }
            if ($this->unload_km->Visible && $this->unload_km->Required) {
                if (!$this->unload_km->IsDetailKey && EmptyValue($this->unload_km->FormValue)) {
                    $this->unload_km->addErrorMessage(str_replace("%s", $this->unload_km->caption(), $this->unload_km->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->unload_km->FormValue)) {
                $this->unload_km->addErrorMessage($this->unload_km->getErrorMessage(false));
            }
            if ($this->delivery_receipt->Visible && $this->delivery_receipt->Required) {
                if ($this->delivery_receipt->Upload->FileName == "" && !$this->delivery_receipt->Upload->KeepFile) {
                    $this->delivery_receipt->addErrorMessage(str_replace("%s", $this->delivery_receipt->caption(), $this->delivery_receipt->RequiredErrorMessage));
                }
            }
            if ($this->delivery_docket->Visible && $this->delivery_docket->Required) {
                if (!$this->delivery_docket->IsDetailKey && EmptyValue($this->delivery_docket->FormValue)) {
                    $this->delivery_docket->addErrorMessage(str_replace("%s", $this->delivery_docket->caption(), $this->delivery_docket->RequiredErrorMessage));
                }
            }
            if ($this->diesal_op_b->Visible && $this->diesal_op_b->Required) {
                if (!$this->diesal_op_b->IsDetailKey && EmptyValue($this->diesal_op_b->FormValue)) {
                    $this->diesal_op_b->addErrorMessage(str_replace("%s", $this->diesal_op_b->caption(), $this->diesal_op_b->RequiredErrorMessage));
                }
            }
            if ($this->diesal_required->Visible && $this->diesal_required->Required) {
                if (!$this->diesal_required->IsDetailKey && EmptyValue($this->diesal_required->FormValue)) {
                    $this->diesal_required->addErrorMessage(str_replace("%s", $this->diesal_required->caption(), $this->diesal_required->RequiredErrorMessage));
                }
            }
            if ($this->diesal_fill->Visible && $this->diesal_fill->Required) {
                if (!$this->diesal_fill->IsDetailKey && EmptyValue($this->diesal_fill->FormValue)) {
                    $this->diesal_fill->addErrorMessage(str_replace("%s", $this->diesal_fill->caption(), $this->diesal_fill->RequiredErrorMessage));
                }
            }
            if ($this->diesal_amount->Visible && $this->diesal_amount->Required) {
                if (!$this->diesal_amount->IsDetailKey && EmptyValue($this->diesal_amount->FormValue)) {
                    $this->diesal_amount->addErrorMessage(str_replace("%s", $this->diesal_amount->caption(), $this->diesal_amount->RequiredErrorMessage));
                }
            }
            if ($this->diesal_cl_balance->Visible && $this->diesal_cl_balance->Required) {
                if (!$this->diesal_cl_balance->IsDetailKey && EmptyValue($this->diesal_cl_balance->FormValue)) {
                    $this->diesal_cl_balance->addErrorMessage(str_replace("%s", $this->diesal_cl_balance->caption(), $this->diesal_cl_balance->RequiredErrorMessage));
                }
            }
            if ($this->vehicle_average->Visible && $this->vehicle_average->Required) {
                if (!$this->vehicle_average->IsDetailKey && EmptyValue($this->vehicle_average->FormValue)) {
                    $this->vehicle_average->addErrorMessage(str_replace("%s", $this->vehicle_average->caption(), $this->vehicle_average->RequiredErrorMessage));
                }
            }
            if ($this->cash_required->Visible && $this->cash_required->Required) {
                if (!$this->cash_required->IsDetailKey && EmptyValue($this->cash_required->FormValue)) {
                    $this->cash_required->addErrorMessage(str_replace("%s", $this->cash_required->caption(), $this->cash_required->RequiredErrorMessage));
                }
            }
            if ($this->cash_op_b->Visible && $this->cash_op_b->Required) {
                if (!$this->cash_op_b->IsDetailKey && EmptyValue($this->cash_op_b->FormValue)) {
                    $this->cash_op_b->addErrorMessage(str_replace("%s", $this->cash_op_b->caption(), $this->cash_op_b->RequiredErrorMessage));
                }
            }
            if ($this->cash_paid->Visible && $this->cash_paid->Required) {
                if (!$this->cash_paid->IsDetailKey && EmptyValue($this->cash_paid->FormValue)) {
                    $this->cash_paid->addErrorMessage(str_replace("%s", $this->cash_paid->caption(), $this->cash_paid->RequiredErrorMessage));
                }
            }
            if ($this->cash_expenses->Visible && $this->cash_expenses->Required) {
                if (!$this->cash_expenses->IsDetailKey && EmptyValue($this->cash_expenses->FormValue)) {
                    $this->cash_expenses->addErrorMessage(str_replace("%s", $this->cash_expenses->caption(), $this->cash_expenses->RequiredErrorMessage));
                }
            }
            if ($this->cash_cl_balance->Visible && $this->cash_cl_balance->Required) {
                if (!$this->cash_cl_balance->IsDetailKey && EmptyValue($this->cash_cl_balance->FormValue)) {
                    $this->cash_cl_balance->addErrorMessage(str_replace("%s", $this->cash_cl_balance->caption(), $this->cash_cl_balance->RequiredErrorMessage));
                }
            }
            if ($this->fasttag_op_b->Visible && $this->fasttag_op_b->Required) {
                if (!$this->fasttag_op_b->IsDetailKey && EmptyValue($this->fasttag_op_b->FormValue)) {
                    $this->fasttag_op_b->addErrorMessage(str_replace("%s", $this->fasttag_op_b->caption(), $this->fasttag_op_b->RequiredErrorMessage));
                }
            }
            if ($this->fasttag_recharge->Visible && $this->fasttag_recharge->Required) {
                if (!$this->fasttag_recharge->IsDetailKey && EmptyValue($this->fasttag_recharge->FormValue)) {
                    $this->fasttag_recharge->addErrorMessage(str_replace("%s", $this->fasttag_recharge->caption(), $this->fasttag_recharge->RequiredErrorMessage));
                }
            }
            if ($this->fasttag_expenses->Visible && $this->fasttag_expenses->Required) {
                if (!$this->fasttag_expenses->IsDetailKey && EmptyValue($this->fasttag_expenses->FormValue)) {
                    $this->fasttag_expenses->addErrorMessage(str_replace("%s", $this->fasttag_expenses->caption(), $this->fasttag_expenses->RequiredErrorMessage));
                }
            }
            if ($this->toll_expenses_cash->Visible && $this->toll_expenses_cash->Required) {
                if (!$this->toll_expenses_cash->IsDetailKey && EmptyValue($this->toll_expenses_cash->FormValue)) {
                    $this->toll_expenses_cash->addErrorMessage(str_replace("%s", $this->toll_expenses_cash->caption(), $this->toll_expenses_cash->RequiredErrorMessage));
                }
            }
            if ($this->fasttag_cl_balance->Visible && $this->fasttag_cl_balance->Required) {
                if (!$this->fasttag_cl_balance->IsDetailKey && EmptyValue($this->fasttag_cl_balance->FormValue)) {
                    $this->fasttag_cl_balance->addErrorMessage(str_replace("%s", $this->fasttag_cl_balance->caption(), $this->fasttag_cl_balance->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->fasttag_cl_balance->FormValue)) {
                $this->fasttag_cl_balance->addErrorMessage($this->fasttag_cl_balance->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->uploads->Visible && $this->uploads->Required) {
                if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->addErrorMessage(str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
                }
            }
            if ($this->consignor->Visible && $this->consignor->Required) {
                if (!$this->consignor->IsDetailKey && EmptyValue($this->consignor->FormValue)) {
                    $this->consignor->addErrorMessage(str_replace("%s", $this->consignor->caption(), $this->consignor->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->consignor->FormValue)) {
                $this->consignor->addErrorMessage($this->consignor->getErrorMessage(false));
            }
            if ($this->vehicle_freight_comm->Visible && $this->vehicle_freight_comm->Required) {
                if (!$this->vehicle_freight_comm->IsDetailKey && EmptyValue($this->vehicle_freight_comm->FormValue)) {
                    $this->vehicle_freight_comm->addErrorMessage(str_replace("%s", $this->vehicle_freight_comm->caption(), $this->vehicle_freight_comm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->vehicle_freight_comm->FormValue)) {
                $this->vehicle_freight_comm->addErrorMessage($this->vehicle_freight_comm->getErrorMessage(false));
            }
            if ($this->vehicle_freight_type->Visible && $this->vehicle_freight_type->Required) {
                if (!$this->vehicle_freight_type->IsDetailKey && EmptyValue($this->vehicle_freight_type->FormValue)) {
                    $this->vehicle_freight_type->addErrorMessage(str_replace("%s", $this->vehicle_freight_type->caption(), $this->vehicle_freight_type->RequiredErrorMessage));
                }
            }
            if ($this->vehicle_freight_amount->Visible && $this->vehicle_freight_amount->Required) {
                if (!$this->vehicle_freight_amount->IsDetailKey && EmptyValue($this->vehicle_freight_amount->FormValue)) {
                    $this->vehicle_freight_amount->addErrorMessage(str_replace("%s", $this->vehicle_freight_amount->caption(), $this->vehicle_freight_amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->vehicle_freight_amount->FormValue)) {
                $this->vehicle_freight_amount->addErrorMessage($this->vehicle_freight_amount->getErrorMessage(false));
            }
            if ($this->vehicle_freight_final->Visible && $this->vehicle_freight_final->Required) {
                if (!$this->vehicle_freight_final->IsDetailKey && EmptyValue($this->vehicle_freight_final->FormValue)) {
                    $this->vehicle_freight_final->addErrorMessage(str_replace("%s", $this->vehicle_freight_final->caption(), $this->vehicle_freight_final->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("TExpensesOGrid");
        if (in_array("t_expenses_o", $detailTblVar) && $detailPage->DetailEdit) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("TReceiptDGrid");
        if (in_array("t_receipt_d", $detailTblVar) && $detailPage->DetailEdit) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("TDiesalExpensesGrid");
        if (in_array("t_diesal_expenses", $detailTblVar) && $detailPage->DetailEdit) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("TRouteInfoGrid");
        if (in_array("t_route_info", $detailTblVar) && $detailPage->DetailEdit) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->delivery_receipt->Visible && !$this->delivery_receipt->Upload->KeepFile) {
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath();
            if (!EmptyValue($this->delivery_receipt->Upload->FileName)) {
                FixUploadFileNames($this->delivery_receipt);
                $this->delivery_receipt->setDbValueDef($rsnew, $this->delivery_receipt->Upload->FileName, $this->delivery_receipt->ReadOnly);
            }
        }
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            $this->uploads->UploadPath = $this->uploads->getUploadPath();
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, $this->uploads->ReadOnly);
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->delivery_receipt->Visible && !$this->delivery_receipt->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->delivery_receipt, $rsnew['delivery_receipt'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }

            // Update detail records
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("TExpensesOGrid");
            if (in_array("t_expenses_o", $detailTblVar) && $detailPage->DetailEdit && $editRow) {
                $Security->loadCurrentUserLevel($this->ProjectID . "t_expenses_o"); // Load user level of detail table
                $editRow = $detailPage->gridUpdate();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
            }
            $detailPage = Container("TReceiptDGrid");
            if (in_array("t_receipt_d", $detailTblVar) && $detailPage->DetailEdit && $editRow) {
                $Security->loadCurrentUserLevel($this->ProjectID . "t_receipt_d"); // Load user level of detail table
                $editRow = $detailPage->gridUpdate();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
            }
            $detailPage = Container("TDiesalExpensesGrid");
            if (in_array("t_diesal_expenses", $detailTblVar) && $detailPage->DetailEdit && $editRow) {
                $Security->loadCurrentUserLevel($this->ProjectID . "t_diesal_expenses"); // Load user level of detail table
                $editRow = $detailPage->gridUpdate();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
            }
            $detailPage = Container("TRouteInfoGrid");
            if (in_array("t_route_info", $detailTblVar) && $detailPage->DetailEdit && $editRow) {
                $Security->loadCurrentUserLevel($this->ProjectID . "t_route_info"); // Load user level of detail table
                $editRow = $detailPage->gridUpdate();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
            }

            // Commit/Rollback transaction
            if ($this->getCurrentDetailTable() != "") {
                if ($editRow) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->delivery_receipt->OldUploadPath = $this->delivery_receipt->getUploadPath(); // PHP
        $this->delivery_receipt->UploadPath = $this->delivery_receipt->OldUploadPath;
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $this->uploads->UploadPath = $this->uploads->OldUploadPath;
        $rsnew = [];

        // vehicle_type
        $this->vehicle_type->setDbValueDef($rsnew, $this->vehicle_type->CurrentValue, $this->vehicle_type->ReadOnly);

        // route
        $this->_route->setDbValueDef($rsnew, $this->_route->CurrentValue, $this->_route->ReadOnly);

        // reports_to
        $this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, $this->reports_to->ReadOnly);

        // buyer
        $this->buyer->setDbValueDef($rsnew, $this->buyer->CurrentValue, $this->buyer->ReadOnly);

        // b_consignor
        $this->b_consignor->setDbValueDef($rsnew, $this->b_consignor->CurrentValue, $this->b_consignor->ReadOnly);

        // b_consignee
        $this->b_consignee->setDbValueDef($rsnew, $this->b_consignee->CurrentValue, $this->b_consignee->ReadOnly);

        // load_date
        $this->load_date->setDbValueDef($rsnew, UnFormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern()), $this->load_date->ReadOnly);

        // load_weight
        $this->load_weight->setDbValueDef($rsnew, $this->load_weight->CurrentValue, $this->load_weight->ReadOnly);

        // unload_date
        $this->unload_date->setDbValueDef($rsnew, UnFormatDateTime($this->unload_date->CurrentValue, $this->unload_date->formatPattern()), $this->unload_date->ReadOnly);

        // unload_weight
        $this->unload_weight->setDbValueDef($rsnew, $this->unload_weight->CurrentValue, $this->unload_weight->ReadOnly);

        // delivery_pod
        $this->delivery_pod->setDbValueDef($rsnew, $this->delivery_pod->CurrentValue, $this->delivery_pod->ReadOnly);

        // driver
        $this->driver->setDbValueDef($rsnew, $this->driver->CurrentValue, $this->driver->ReadOnly);

        // driver_name
        $this->driver_name->setDbValueDef($rsnew, $this->driver_name->CurrentValue, $this->driver_name->ReadOnly);

        // agent
        $this->agent->setDbValueDef($rsnew, $this->agent->CurrentValue, $this->agent->ReadOnly);

        // comm
        $this->comm->setDbValueDef($rsnew, $this->comm->CurrentValue, $this->comm->ReadOnly);

        // material
        $this->material->setDbValueDef($rsnew, $this->material->CurrentValue, $this->material->ReadOnly);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, $this->packing_type->ReadOnly);

        // m_hsn
        $this->m_hsn->setDbValueDef($rsnew, $this->m_hsn->CurrentValue, $this->m_hsn->ReadOnly);

        // @
        $this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, $this->_40->ReadOnly);

        // lr_no
        $this->lr_no->setDbValueDef($rsnew, $this->lr_no->CurrentValue, $this->lr_no->ReadOnly);

        // km
        $this->km->setDbValueDef($rsnew, $this->km->CurrentValue, $this->km->ReadOnly);

        // freight_type
        $this->freight_type->setDbValueDef($rsnew, $this->freight_type->CurrentValue, $this->freight_type->ReadOnly);

        // freight
        $this->freight->setDbValueDef($rsnew, $this->freight->CurrentValue, $this->freight->ReadOnly);

        // ded_det
        $this->ded_det->setDbValueDef($rsnew, $this->ded_det->CurrentValue, $this->ded_det->ReadOnly);

        // ded_det_remarks
        $this->ded_det_remarks->setDbValueDef($rsnew, $this->ded_det_remarks->CurrentValue, $this->ded_det_remarks->ReadOnly);

        // gst_percent
        $this->gst_percent->setDbValueDef($rsnew, $this->gst_percent->CurrentValue, $this->gst_percent->ReadOnly);

        // load_km
        $this->load_km->setDbValueDef($rsnew, $this->load_km->CurrentValue, $this->load_km->ReadOnly);

        // unload_km
        $this->unload_km->setDbValueDef($rsnew, $this->unload_km->CurrentValue, $this->unload_km->ReadOnly);

        // delivery_receipt
        if ($this->delivery_receipt->Visible && !$this->delivery_receipt->ReadOnly && !$this->delivery_receipt->Upload->KeepFile) {
            if ($this->delivery_receipt->Upload->FileName == "") {
                $rsnew['delivery_receipt'] = null;
            } else {
                FixUploadTempFileNames($this->delivery_receipt);
                $rsnew['delivery_receipt'] = $this->delivery_receipt->Upload->FileName;
            }
            $this->delivery_receipt->ImageWidth = 0; // Resize width
            $this->delivery_receipt->ImageHeight = 640; // Resize height
        }

        // delivery_docket
        $this->delivery_docket->setDbValueDef($rsnew, $this->delivery_docket->CurrentValue, $this->delivery_docket->ReadOnly);

        // fasttag_cl_balance
        $this->fasttag_cl_balance->setDbValueDef($rsnew, $this->fasttag_cl_balance->CurrentValue, $this->fasttag_cl_balance->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // uploads
        if ($this->uploads->Visible && !$this->uploads->ReadOnly && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 0; // Resize width
            $this->uploads->ImageHeight = 640; // Resize height
        }

        // consignor
        $this->consignor->setDbValueDef($rsnew, $this->consignor->CurrentValue, $this->consignor->ReadOnly);

        // vehicle_freight_comm
        $this->vehicle_freight_comm->setDbValueDef($rsnew, $this->vehicle_freight_comm->CurrentValue, $this->vehicle_freight_comm->ReadOnly);

        // vehicle_freight_type
        $this->vehicle_freight_type->setDbValueDef($rsnew, $this->vehicle_freight_type->CurrentValue, $this->vehicle_freight_type->ReadOnly);

        // vehicle_freight_amount
        $this->vehicle_freight_amount->setDbValueDef($rsnew, $this->vehicle_freight_amount->CurrentValue, $this->vehicle_freight_amount->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['vehicle_type'])) { // vehicle_type
            $this->vehicle_type->CurrentValue = $row['vehicle_type'];
        }
        if (isset($row['route'])) { // route
            $this->_route->CurrentValue = $row['route'];
        }
        if (isset($row['reports_to'])) { // reports_to
            $this->reports_to->CurrentValue = $row['reports_to'];
        }
        if (isset($row['buyer'])) { // buyer
            $this->buyer->CurrentValue = $row['buyer'];
        }
        if (isset($row['b_consignor'])) { // b_consignor
            $this->b_consignor->CurrentValue = $row['b_consignor'];
        }
        if (isset($row['b_consignee'])) { // b_consignee
            $this->b_consignee->CurrentValue = $row['b_consignee'];
        }
        if (isset($row['load_date'])) { // load_date
            $this->load_date->CurrentValue = $row['load_date'];
        }
        if (isset($row['load_weight'])) { // load_weight
            $this->load_weight->CurrentValue = $row['load_weight'];
        }
        if (isset($row['unload_date'])) { // unload_date
            $this->unload_date->CurrentValue = $row['unload_date'];
        }
        if (isset($row['unload_weight'])) { // unload_weight
            $this->unload_weight->CurrentValue = $row['unload_weight'];
        }
        if (isset($row['delivery_pod'])) { // delivery_pod
            $this->delivery_pod->CurrentValue = $row['delivery_pod'];
        }
        if (isset($row['driver'])) { // driver
            $this->driver->CurrentValue = $row['driver'];
        }
        if (isset($row['driver_name'])) { // driver_name
            $this->driver_name->CurrentValue = $row['driver_name'];
        }
        if (isset($row['agent'])) { // agent
            $this->agent->CurrentValue = $row['agent'];
        }
        if (isset($row['comm'])) { // comm
            $this->comm->CurrentValue = $row['comm'];
        }
        if (isset($row['material'])) { // material
            $this->material->CurrentValue = $row['material'];
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->CurrentValue = $row['packing_type'];
        }
        if (isset($row['m_hsn'])) { // m_hsn
            $this->m_hsn->CurrentValue = $row['m_hsn'];
        }
        if (isset($row['@'])) { // @
            $this->_40->CurrentValue = $row['@'];
        }
        if (isset($row['lr_no'])) { // lr_no
            $this->lr_no->CurrentValue = $row['lr_no'];
        }
        if (isset($row['km'])) { // km
            $this->km->CurrentValue = $row['km'];
        }
        if (isset($row['freight_type'])) { // freight_type
            $this->freight_type->CurrentValue = $row['freight_type'];
        }
        if (isset($row['freight'])) { // freight
            $this->freight->CurrentValue = $row['freight'];
        }
        if (isset($row['ded_det'])) { // ded_det
            $this->ded_det->CurrentValue = $row['ded_det'];
        }
        if (isset($row['ded_det_remarks'])) { // ded_det_remarks
            $this->ded_det_remarks->CurrentValue = $row['ded_det_remarks'];
        }
        if (isset($row['gst_percent'])) { // gst_percent
            $this->gst_percent->CurrentValue = $row['gst_percent'];
        }
        if (isset($row['load_km'])) { // load_km
            $this->load_km->CurrentValue = $row['load_km'];
        }
        if (isset($row['unload_km'])) { // unload_km
            $this->unload_km->CurrentValue = $row['unload_km'];
        }
        if (isset($row['delivery_receipt'])) { // delivery_receipt
            $this->delivery_receipt->CurrentValue = $row['delivery_receipt'];
        }
        if (isset($row['delivery_docket'])) { // delivery_docket
            $this->delivery_docket->CurrentValue = $row['delivery_docket'];
        }
        if (isset($row['fasttag_cl_balance'])) { // fasttag_cl_balance
            $this->fasttag_cl_balance->CurrentValue = $row['fasttag_cl_balance'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->CurrentValue = $row['uploads'];
        }
        if (isset($row['consignor'])) { // consignor
            $this->consignor->CurrentValue = $row['consignor'];
        }
        if (isset($row['vehicle_freight_comm'])) { // vehicle_freight_comm
            $this->vehicle_freight_comm->CurrentValue = $row['vehicle_freight_comm'];
        }
        if (isset($row['vehicle_freight_type'])) { // vehicle_freight_type
            $this->vehicle_freight_type->CurrentValue = $row['vehicle_freight_type'];
        }
        if (isset($row['vehicle_freight_amount'])) { // vehicle_freight_amount
            $this->vehicle_freight_amount->CurrentValue = $row['vehicle_freight_amount'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("t_expenses_o", $detailTblVar)) {
                $detailPageObj = Container("TExpensesOGrid");
                if ($detailPageObj->DetailEdit) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "edit";
                    $detailPageObj->CurrentAction = "gridedit";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->trip->IsDetailKey = true;
                    $detailPageObj->trip->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->trip->setSessionValue($detailPageObj->trip->CurrentValue);
                }
            }
            if (in_array("t_receipt_d", $detailTblVar)) {
                $detailPageObj = Container("TReceiptDGrid");
                if ($detailPageObj->DetailEdit) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "edit";
                    $detailPageObj->CurrentAction = "gridedit";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->trip->IsDetailKey = true;
                    $detailPageObj->trip->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->trip->setSessionValue($detailPageObj->trip->CurrentValue);
                }
            }
            if (in_array("t_diesal_expenses", $detailTblVar)) {
                $detailPageObj = Container("TDiesalExpensesGrid");
                if ($detailPageObj->DetailEdit) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "edit";
                    $detailPageObj->CurrentAction = "gridedit";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->trip->IsDetailKey = true;
                    $detailPageObj->trip->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->trip->setSessionValue($detailPageObj->trip->CurrentValue);
                }
            }
            if (in_array("t_route_info", $detailTblVar)) {
                $detailPageObj = Container("TRouteInfoGrid");
                if ($detailPageObj->DetailEdit) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "edit";
                    $detailPageObj->CurrentAction = "gridedit";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->id->IsDetailKey = true;
                    $detailPageObj->id->CurrentValue = $this->_route->CurrentValue;
                    $detailPageObj->id->setSessionValue($detailPageObj->id->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ttripinfolist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_vehicle_type":
                    break;
                case "x_vehicle":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__route":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_buyer":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_consignor":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_consignee":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_delivery_pod":
                    break;
                case "x_status":
                    break;
                case "x_driver":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_freight_type":
                    break;
                case "x_consignor":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_vehicle_freight_type":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'t_trip_info');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
