<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TTripInfoDUnloadEdit extends TTripInfoDUnload
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TTripInfoDUnloadEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "ttripinfodunloadedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->load_date->setVisibility();
        $this->trip_info->setVisibility();
        $this->driver->setVisibility();
        $this->unload_km->setVisibility();
        $this->load_weight->setVisibility();
        $this->unload_weight->setVisibility();
        $this->unload_date->setVisibility();
        $this->ded_det->setVisibility();
        $this->ded_det_remarks->setVisibility();
        $this->fasttag_cl_balance->setVisibility();
        $this->delivery_receipt->setVisibility();
        $this->delivery_pod->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 't_trip_info_d_unload';
        $this->TableName = 't_trip_info_d_unload';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (t_trip_info_d_unload)
        if (!isset($GLOBALS["t_trip_info_d_unload"]) || $GLOBALS["t_trip_info_d_unload"]::class == PROJECT_NAMESPACE . "t_trip_info_d_unload") {
            $GLOBALS["t_trip_info_d_unload"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_info_d_unload');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "ttripinfodunloadview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->delivery_receipt->OldUploadPath = $this->delivery_receipt->getUploadPath(); // PHP
                $this->delivery_receipt->UploadPath = $this->delivery_receipt->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->trip_info->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->trip_info);
        $this->setupLookupOptions($this->driver);
        $this->setupLookupOptions($this->delivery_pod);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("ttripinfodunloadlist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = 'autoprogramme?apcid=c5866e93cab1776890fe343c9e7063fb&ti=' . $this->id->CurrentValue . '';
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "ttripinfodunloadlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "ttripinfodunloadlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->delivery_receipt->Upload->Index = $CurrentForm->Index;
        $this->delivery_receipt->Upload->uploadFile();
        $this->delivery_receipt->CurrentValue = $this->delivery_receipt->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'load_date' first before field var 'x_load_date'
        $val = $CurrentForm->hasValue("load_date") ? $CurrentForm->getValue("load_date") : $CurrentForm->getValue("x_load_date");
        if (!$this->load_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_date->Visible = false; // Disable update for API request
            } else {
                $this->load_date->setFormValue($val, true, $validate);
            }
            $this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern());
        }

        // Check field name 'trip_info' first before field var 'x_trip_info'
        $val = $CurrentForm->hasValue("trip_info") ? $CurrentForm->getValue("trip_info") : $CurrentForm->getValue("x_trip_info");
        if (!$this->trip_info->IsDetailKey) {
            $this->trip_info->setFormValue($val);
        }

        // Check field name 'driver' first before field var 'x_driver'
        $val = $CurrentForm->hasValue("driver") ? $CurrentForm->getValue("driver") : $CurrentForm->getValue("x_driver");
        if (!$this->driver->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->driver->Visible = false; // Disable update for API request
            } else {
                $this->driver->setFormValue($val);
            }
        }

        // Check field name 'unload_km' first before field var 'x_unload_km'
        $val = $CurrentForm->hasValue("unload_km") ? $CurrentForm->getValue("unload_km") : $CurrentForm->getValue("x_unload_km");
        if (!$this->unload_km->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unload_km->Visible = false; // Disable update for API request
            } else {
                $this->unload_km->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'load_weight' first before field var 'x_load_weight'
        $val = $CurrentForm->hasValue("load_weight") ? $CurrentForm->getValue("load_weight") : $CurrentForm->getValue("x_load_weight");
        if (!$this->load_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_weight->Visible = false; // Disable update for API request
            } else {
                $this->load_weight->setFormValue($val);
            }
        }

        // Check field name 'unload_weight' first before field var 'x_unload_weight'
        $val = $CurrentForm->hasValue("unload_weight") ? $CurrentForm->getValue("unload_weight") : $CurrentForm->getValue("x_unload_weight");
        if (!$this->unload_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unload_weight->Visible = false; // Disable update for API request
            } else {
                $this->unload_weight->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'unload_date' first before field var 'x_unload_date'
        $val = $CurrentForm->hasValue("unload_date") ? $CurrentForm->getValue("unload_date") : $CurrentForm->getValue("x_unload_date");
        if (!$this->unload_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unload_date->Visible = false; // Disable update for API request
            } else {
                $this->unload_date->setFormValue($val, true, $validate);
            }
            $this->unload_date->CurrentValue = UnFormatDateTime($this->unload_date->CurrentValue, $this->unload_date->formatPattern());
        }

        // Check field name 'ded_det' first before field var 'x_ded_det'
        $val = $CurrentForm->hasValue("ded_det") ? $CurrentForm->getValue("ded_det") : $CurrentForm->getValue("x_ded_det");
        if (!$this->ded_det->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ded_det->Visible = false; // Disable update for API request
            } else {
                $this->ded_det->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ded_det_remarks' first before field var 'x_ded_det_remarks'
        $val = $CurrentForm->hasValue("ded_det_remarks") ? $CurrentForm->getValue("ded_det_remarks") : $CurrentForm->getValue("x_ded_det_remarks");
        if (!$this->ded_det_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ded_det_remarks->Visible = false; // Disable update for API request
            } else {
                $this->ded_det_remarks->setFormValue($val);
            }
        }

        // Check field name 'fasttag_cl_balance' first before field var 'x_fasttag_cl_balance'
        $val = $CurrentForm->hasValue("fasttag_cl_balance") ? $CurrentForm->getValue("fasttag_cl_balance") : $CurrentForm->getValue("x_fasttag_cl_balance");
        if (!$this->fasttag_cl_balance->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fasttag_cl_balance->Visible = false; // Disable update for API request
            } else {
                $this->fasttag_cl_balance->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'delivery_pod' first before field var 'x_delivery_pod'
        $val = $CurrentForm->hasValue("delivery_pod") ? $CurrentForm->getValue("delivery_pod") : $CurrentForm->getValue("x_delivery_pod");
        if (!$this->delivery_pod->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delivery_pod->Visible = false; // Disable update for API request
            } else {
                $this->delivery_pod->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
		$this->delivery_receipt->OldUploadPath = $this->delivery_receipt->getUploadPath(); // PHP
		$this->delivery_receipt->UploadPath = $this->delivery_receipt->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->load_date->CurrentValue = $this->load_date->FormValue;
        $this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern());
        $this->trip_info->CurrentValue = $this->trip_info->FormValue;
        $this->driver->CurrentValue = $this->driver->FormValue;
        $this->unload_km->CurrentValue = $this->unload_km->FormValue;
        $this->load_weight->CurrentValue = $this->load_weight->FormValue;
        $this->unload_weight->CurrentValue = $this->unload_weight->FormValue;
        $this->unload_date->CurrentValue = $this->unload_date->FormValue;
        $this->unload_date->CurrentValue = UnFormatDateTime($this->unload_date->CurrentValue, $this->unload_date->formatPattern());
        $this->ded_det->CurrentValue = $this->ded_det->FormValue;
        $this->ded_det_remarks->CurrentValue = $this->ded_det_remarks->FormValue;
        $this->fasttag_cl_balance->CurrentValue = $this->fasttag_cl_balance->FormValue;
        $this->delivery_pod->CurrentValue = $this->delivery_pod->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->load_date->setDbValue($row['load_date']);
        $this->trip_info->setDbValue($row['trip_info']);
        $this->driver->setDbValue($row['driver']);
        $this->unload_km->setDbValue($row['unload_km']);
        $this->load_weight->setDbValue($row['load_weight']);
        $this->unload_weight->setDbValue($row['unload_weight']);
        $this->unload_date->setDbValue($row['unload_date']);
        $this->ded_det->setDbValue($row['ded_det']);
        $this->ded_det_remarks->setDbValue($row['ded_det_remarks']);
        $this->fasttag_cl_balance->setDbValue($row['fasttag_cl_balance']);
        $this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
        $this->delivery_receipt->setDbValue($this->delivery_receipt->Upload->DbValue);
        $this->delivery_pod->setDbValue($row['delivery_pod']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['load_date'] = $this->load_date->DefaultValue;
        $row['trip_info'] = $this->trip_info->DefaultValue;
        $row['driver'] = $this->driver->DefaultValue;
        $row['unload_km'] = $this->unload_km->DefaultValue;
        $row['load_weight'] = $this->load_weight->DefaultValue;
        $row['unload_weight'] = $this->unload_weight->DefaultValue;
        $row['unload_date'] = $this->unload_date->DefaultValue;
        $row['ded_det'] = $this->ded_det->DefaultValue;
        $row['ded_det_remarks'] = $this->ded_det_remarks->DefaultValue;
        $row['fasttag_cl_balance'] = $this->fasttag_cl_balance->DefaultValue;
        $row['delivery_receipt'] = $this->delivery_receipt->DefaultValue;
        $row['delivery_pod'] = $this->delivery_pod->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // load_date
        $this->load_date->RowCssClass = "row";

        // trip_info
        $this->trip_info->RowCssClass = "row";

        // driver
        $this->driver->RowCssClass = "row";

        // unload_km
        $this->unload_km->RowCssClass = "row";

        // load_weight
        $this->load_weight->RowCssClass = "row";

        // unload_weight
        $this->unload_weight->RowCssClass = "row";

        // unload_date
        $this->unload_date->RowCssClass = "row";

        // ded_det
        $this->ded_det->RowCssClass = "row";

        // ded_det_remarks
        $this->ded_det_remarks->RowCssClass = "row";

        // fasttag_cl_balance
        $this->fasttag_cl_balance->RowCssClass = "row";

        // delivery_receipt
        $this->delivery_receipt->RowCssClass = "row";

        // delivery_pod
        $this->delivery_pod->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // load_date
            $this->load_date->ViewValue = $this->load_date->CurrentValue;
            $this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, $this->load_date->formatPattern());

            // trip_info
            $curVal = strval($this->trip_info->CurrentValue);
            if ($curVal != "") {
                $this->trip_info->ViewValue = $this->trip_info->lookupCacheOption($curVal);
                if ($this->trip_info->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->trip_info->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->trip_info->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->trip_info->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->trip_info->Lookup->renderViewRow($rswrk[0]);
                        $this->trip_info->ViewValue = $this->trip_info->displayValue($arwrk);
                    } else {
                        $this->trip_info->ViewValue = $this->trip_info->CurrentValue;
                    }
                }
            } else {
                $this->trip_info->ViewValue = null;
            }

            // driver
            $curVal = strval($this->driver->CurrentValue);
            if ($curVal != "") {
                $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
                if ($this->driver->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->driver->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->driver->Lookup->renderViewRow($rswrk[0]);
                        $this->driver->ViewValue = $this->driver->displayValue($arwrk);
                    } else {
                        $this->driver->ViewValue = FormatNumber($this->driver->CurrentValue, $this->driver->formatPattern());
                    }
                }
            } else {
                $this->driver->ViewValue = null;
            }

            // unload_km
            $this->unload_km->ViewValue = $this->unload_km->CurrentValue;
            $this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, $this->unload_km->formatPattern());

            // load_weight
            $this->load_weight->ViewValue = $this->load_weight->CurrentValue;
            $this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, $this->load_weight->formatPattern());

            // unload_weight
            $this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
            $this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, $this->unload_weight->formatPattern());

            // unload_date
            $this->unload_date->ViewValue = $this->unload_date->CurrentValue;
            $this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, $this->unload_date->formatPattern());

            // ded_det
            $this->ded_det->ViewValue = $this->ded_det->CurrentValue;
            $this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, $this->ded_det->formatPattern());

            // ded_det_remarks
            $this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;

            // fasttag_cl_balance
            $this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
            $this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, $this->fasttag_cl_balance->formatPattern());

            // delivery_receipt
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
            if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
                $this->delivery_receipt->ImageWidth = 0;
                $this->delivery_receipt->ImageHeight = 50;
                $this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
                $this->delivery_receipt->ImageCssClass = "ew-image";
                $this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
            } else {
                $this->delivery_receipt->ViewValue = "";
            }

            // delivery_pod
            if (strval($this->delivery_pod->CurrentValue) != "") {
                $this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
            } else {
                $this->delivery_pod->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // load_date
            $this->load_date->HrefValue = "";

            // trip_info
            $this->trip_info->HrefValue = "";
            $this->trip_info->TooltipValue = "";

            // driver
            $this->driver->HrefValue = "";

            // unload_km
            $this->unload_km->HrefValue = "";

            // load_weight
            $this->load_weight->HrefValue = "";
            $this->load_weight->TooltipValue = "";

            // unload_weight
            $this->unload_weight->HrefValue = "";

            // unload_date
            $this->unload_date->HrefValue = "";

            // ded_det
            $this->ded_det->HrefValue = "";

            // ded_det_remarks
            $this->ded_det_remarks->HrefValue = "";

            // fasttag_cl_balance
            $this->fasttag_cl_balance->HrefValue = "";

            // delivery_receipt
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
            if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
                $this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
                $this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
                }
            } else {
                $this->delivery_receipt->HrefValue = "";
            }
            $this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;

            // delivery_pod
            $this->delivery_pod->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // load_date
            $this->load_date->setupEditAttributes();
            $this->load_date->EditValue = HtmlEncode(FormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern()));
            $this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

            // trip_info
            $this->trip_info->setupEditAttributes();
            $curVal = strval($this->trip_info->CurrentValue);
            if ($curVal != "") {
                $this->trip_info->EditValue = $this->trip_info->lookupCacheOption($curVal);
                if ($this->trip_info->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->trip_info->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->trip_info->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->trip_info->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->trip_info->Lookup->renderViewRow($rswrk[0]);
                        $this->trip_info->EditValue = $this->trip_info->displayValue($arwrk);
                    } else {
                        $this->trip_info->EditValue = $this->trip_info->CurrentValue;
                    }
                }
            } else {
                $this->trip_info->EditValue = null;
            }

            // driver
            $this->driver->setupEditAttributes();
            $curVal = trim(strval($this->driver->CurrentValue));
            if ($curVal != "") {
                $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
            } else {
                $this->driver->ViewValue = $this->driver->Lookup !== null && is_array($this->driver->lookupOptions()) && count($this->driver->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->driver->ViewValue !== null) { // Load from cache
                $this->driver->EditValue = array_values($this->driver->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->driver->CurrentValue, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->driver->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->driver->EditValue = $arwrk;
            }
            $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

            // unload_km
            $this->unload_km->setupEditAttributes();
            $this->unload_km->EditValue = $this->unload_km->CurrentValue;
            $this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());
            if (strval($this->unload_km->EditValue) != "" && is_numeric($this->unload_km->EditValue)) {
                $this->unload_km->EditValue = FormatNumber($this->unload_km->EditValue, null);
            }

            // load_weight
            $this->load_weight->setupEditAttributes();
            $this->load_weight->EditValue = $this->load_weight->CurrentValue;
            $this->load_weight->EditValue = FormatNumber($this->load_weight->EditValue, $this->load_weight->formatPattern());

            // unload_weight
            $this->unload_weight->setupEditAttributes();
            $this->unload_weight->EditValue = $this->unload_weight->CurrentValue;
            $this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());
            if (strval($this->unload_weight->EditValue) != "" && is_numeric($this->unload_weight->EditValue)) {
                $this->unload_weight->EditValue = FormatNumber($this->unload_weight->EditValue, null);
            }

            // unload_date
            $this->unload_date->setupEditAttributes();
            $this->unload_date->EditValue = HtmlEncode(FormatDateTime($this->unload_date->CurrentValue, $this->unload_date->formatPattern()));
            $this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

            // ded_det
            $this->ded_det->setupEditAttributes();
            $this->ded_det->EditValue = $this->ded_det->CurrentValue;
            $this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());
            if (strval($this->ded_det->EditValue) != "" && is_numeric($this->ded_det->EditValue)) {
                $this->ded_det->EditValue = FormatNumber($this->ded_det->EditValue, null);
            }

            // ded_det_remarks
            $this->ded_det_remarks->setupEditAttributes();
            if (!$this->ded_det_remarks->Raw) {
                $this->ded_det_remarks->CurrentValue = HtmlDecode($this->ded_det_remarks->CurrentValue);
            }
            $this->ded_det_remarks->EditValue = HtmlEncode($this->ded_det_remarks->CurrentValue);
            $this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

            // fasttag_cl_balance
            $this->fasttag_cl_balance->setupEditAttributes();
            $this->fasttag_cl_balance->EditValue = $this->fasttag_cl_balance->CurrentValue;
            $this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());
            if (strval($this->fasttag_cl_balance->EditValue) != "" && is_numeric($this->fasttag_cl_balance->EditValue)) {
                $this->fasttag_cl_balance->EditValue = FormatNumber($this->fasttag_cl_balance->EditValue, null);
            }

            // delivery_receipt
            $this->delivery_receipt->setupEditAttributes();
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
            if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
                $this->delivery_receipt->ImageWidth = 0;
                $this->delivery_receipt->ImageHeight = 50;
                $this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
                $this->delivery_receipt->ImageCssClass = "ew-image";
                $this->delivery_receipt->EditValue = $this->delivery_receipt->Upload->DbValue;
            } else {
                $this->delivery_receipt->EditValue = "";
            }
            if (!EmptyValue($this->delivery_receipt->CurrentValue)) {
                $this->delivery_receipt->Upload->FileName = $this->delivery_receipt->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->delivery_receipt);
            }

            // delivery_pod
            $this->delivery_pod->EditValue = $this->delivery_pod->options(false);
            $this->delivery_pod->PlaceHolder = RemoveHtml($this->delivery_pod->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // load_date
            $this->load_date->HrefValue = "";

            // trip_info
            $this->trip_info->HrefValue = "";
            $this->trip_info->TooltipValue = "";

            // driver
            $this->driver->HrefValue = "";

            // unload_km
            $this->unload_km->HrefValue = "";

            // load_weight
            $this->load_weight->HrefValue = "";
            $this->load_weight->TooltipValue = "";

            // unload_weight
            $this->unload_weight->HrefValue = "";

            // unload_date
            $this->unload_date->HrefValue = "";

            // ded_det
            $this->ded_det->HrefValue = "";

            // ded_det_remarks
            $this->ded_det_remarks->HrefValue = "";

            // fasttag_cl_balance
            $this->fasttag_cl_balance->HrefValue = "";

            // delivery_receipt
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
            if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
                $this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
                $this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
                }
            } else {
                $this->delivery_receipt->HrefValue = "";
            }
            $this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;

            // delivery_pod
            $this->delivery_pod->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->load_date->Visible && $this->load_date->Required) {
                if (!$this->load_date->IsDetailKey && EmptyValue($this->load_date->FormValue)) {
                    $this->load_date->addErrorMessage(str_replace("%s", $this->load_date->caption(), $this->load_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->load_date->FormValue, $this->load_date->formatPattern())) {
                $this->load_date->addErrorMessage($this->load_date->getErrorMessage(false));
            }
            if ($this->trip_info->Visible && $this->trip_info->Required) {
                if (!$this->trip_info->IsDetailKey && EmptyValue($this->trip_info->FormValue)) {
                    $this->trip_info->addErrorMessage(str_replace("%s", $this->trip_info->caption(), $this->trip_info->RequiredErrorMessage));
                }
            }
            if ($this->driver->Visible && $this->driver->Required) {
                if (!$this->driver->IsDetailKey && EmptyValue($this->driver->FormValue)) {
                    $this->driver->addErrorMessage(str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
                }
            }
            if ($this->unload_km->Visible && $this->unload_km->Required) {
                if (!$this->unload_km->IsDetailKey && EmptyValue($this->unload_km->FormValue)) {
                    $this->unload_km->addErrorMessage(str_replace("%s", $this->unload_km->caption(), $this->unload_km->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->unload_km->FormValue)) {
                $this->unload_km->addErrorMessage($this->unload_km->getErrorMessage(false));
            }
            if ($this->load_weight->Visible && $this->load_weight->Required) {
                if (!$this->load_weight->IsDetailKey && EmptyValue($this->load_weight->FormValue)) {
                    $this->load_weight->addErrorMessage(str_replace("%s", $this->load_weight->caption(), $this->load_weight->RequiredErrorMessage));
                }
            }
            if ($this->unload_weight->Visible && $this->unload_weight->Required) {
                if (!$this->unload_weight->IsDetailKey && EmptyValue($this->unload_weight->FormValue)) {
                    $this->unload_weight->addErrorMessage(str_replace("%s", $this->unload_weight->caption(), $this->unload_weight->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->unload_weight->FormValue)) {
                $this->unload_weight->addErrorMessage($this->unload_weight->getErrorMessage(false));
            }
            if ($this->unload_date->Visible && $this->unload_date->Required) {
                if (!$this->unload_date->IsDetailKey && EmptyValue($this->unload_date->FormValue)) {
                    $this->unload_date->addErrorMessage(str_replace("%s", $this->unload_date->caption(), $this->unload_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->unload_date->FormValue, $this->unload_date->formatPattern())) {
                $this->unload_date->addErrorMessage($this->unload_date->getErrorMessage(false));
            }
            if ($this->ded_det->Visible && $this->ded_det->Required) {
                if (!$this->ded_det->IsDetailKey && EmptyValue($this->ded_det->FormValue)) {
                    $this->ded_det->addErrorMessage(str_replace("%s", $this->ded_det->caption(), $this->ded_det->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->ded_det->FormValue)) {
                $this->ded_det->addErrorMessage($this->ded_det->getErrorMessage(false));
            }
            if ($this->ded_det_remarks->Visible && $this->ded_det_remarks->Required) {
                if (!$this->ded_det_remarks->IsDetailKey && EmptyValue($this->ded_det_remarks->FormValue)) {
                    $this->ded_det_remarks->addErrorMessage(str_replace("%s", $this->ded_det_remarks->caption(), $this->ded_det_remarks->RequiredErrorMessage));
                }
            }
            if ($this->fasttag_cl_balance->Visible && $this->fasttag_cl_balance->Required) {
                if (!$this->fasttag_cl_balance->IsDetailKey && EmptyValue($this->fasttag_cl_balance->FormValue)) {
                    $this->fasttag_cl_balance->addErrorMessage(str_replace("%s", $this->fasttag_cl_balance->caption(), $this->fasttag_cl_balance->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->fasttag_cl_balance->FormValue)) {
                $this->fasttag_cl_balance->addErrorMessage($this->fasttag_cl_balance->getErrorMessage(false));
            }
            if ($this->delivery_receipt->Visible && $this->delivery_receipt->Required) {
                if ($this->delivery_receipt->Upload->FileName == "" && !$this->delivery_receipt->Upload->KeepFile) {
                    $this->delivery_receipt->addErrorMessage(str_replace("%s", $this->delivery_receipt->caption(), $this->delivery_receipt->RequiredErrorMessage));
                }
            }
            if ($this->delivery_pod->Visible && $this->delivery_pod->Required) {
                if ($this->delivery_pod->FormValue == "") {
                    $this->delivery_pod->addErrorMessage(str_replace("%s", $this->delivery_pod->caption(), $this->delivery_pod->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->delivery_receipt->Visible && !$this->delivery_receipt->Upload->KeepFile) {
            $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath();
            if (!EmptyValue($this->delivery_receipt->Upload->FileName)) {
                FixUploadFileNames($this->delivery_receipt);
                $this->delivery_receipt->setDbValueDef($rsnew, $this->delivery_receipt->Upload->FileName, $this->delivery_receipt->ReadOnly);
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->delivery_receipt->Visible && !$this->delivery_receipt->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->delivery_receipt, $rsnew['delivery_receipt'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->delivery_receipt->OldUploadPath = $this->delivery_receipt->getUploadPath(); // PHP
        $this->delivery_receipt->UploadPath = $this->delivery_receipt->OldUploadPath;
        $rsnew = [];

        // load_date
        $this->load_date->setDbValueDef($rsnew, UnFormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern()), $this->load_date->ReadOnly);

        // driver
        $this->driver->setDbValueDef($rsnew, $this->driver->CurrentValue, $this->driver->ReadOnly);

        // unload_km
        $this->unload_km->setDbValueDef($rsnew, $this->unload_km->CurrentValue, $this->unload_km->ReadOnly);

        // unload_weight
        $this->unload_weight->setDbValueDef($rsnew, $this->unload_weight->CurrentValue, $this->unload_weight->ReadOnly);

        // unload_date
        $this->unload_date->setDbValueDef($rsnew, UnFormatDateTime($this->unload_date->CurrentValue, $this->unload_date->formatPattern()), $this->unload_date->ReadOnly);

        // ded_det
        $this->ded_det->setDbValueDef($rsnew, $this->ded_det->CurrentValue, $this->ded_det->ReadOnly);

        // ded_det_remarks
        $this->ded_det_remarks->setDbValueDef($rsnew, $this->ded_det_remarks->CurrentValue, $this->ded_det_remarks->ReadOnly);

        // fasttag_cl_balance
        $this->fasttag_cl_balance->setDbValueDef($rsnew, $this->fasttag_cl_balance->CurrentValue, $this->fasttag_cl_balance->ReadOnly);

        // delivery_receipt
        if ($this->delivery_receipt->Visible && !$this->delivery_receipt->ReadOnly && !$this->delivery_receipt->Upload->KeepFile) {
            if ($this->delivery_receipt->Upload->FileName == "") {
                $rsnew['delivery_receipt'] = null;
            } else {
                FixUploadTempFileNames($this->delivery_receipt);
                $rsnew['delivery_receipt'] = $this->delivery_receipt->Upload->FileName;
            }
            $this->delivery_receipt->ImageWidth = 0; // Resize width
            $this->delivery_receipt->ImageHeight = 640; // Resize height
        }

        // delivery_pod
        $this->delivery_pod->setDbValueDef($rsnew, $this->delivery_pod->CurrentValue, $this->delivery_pod->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['load_date'])) { // load_date
            $this->load_date->CurrentValue = $row['load_date'];
        }
        if (isset($row['driver'])) { // driver
            $this->driver->CurrentValue = $row['driver'];
        }
        if (isset($row['unload_km'])) { // unload_km
            $this->unload_km->CurrentValue = $row['unload_km'];
        }
        if (isset($row['unload_weight'])) { // unload_weight
            $this->unload_weight->CurrentValue = $row['unload_weight'];
        }
        if (isset($row['unload_date'])) { // unload_date
            $this->unload_date->CurrentValue = $row['unload_date'];
        }
        if (isset($row['ded_det'])) { // ded_det
            $this->ded_det->CurrentValue = $row['ded_det'];
        }
        if (isset($row['ded_det_remarks'])) { // ded_det_remarks
            $this->ded_det_remarks->CurrentValue = $row['ded_det_remarks'];
        }
        if (isset($row['fasttag_cl_balance'])) { // fasttag_cl_balance
            $this->fasttag_cl_balance->CurrentValue = $row['fasttag_cl_balance'];
        }
        if (isset($row['delivery_receipt'])) { // delivery_receipt
            $this->delivery_receipt->CurrentValue = $row['delivery_receipt'];
        }
        if (isset($row['delivery_pod'])) { // delivery_pod
            $this->delivery_pod->CurrentValue = $row['delivery_pod'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ttripinfodunloadlist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_trip_info":
                    break;
                case "x_driver":
                    break;
                case "x_delivery_pod":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
