<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for t_trip_info_d_unload
 */
class TTripInfoDUnload extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $load_date;
    public $trip_info;
    public $driver;
    public $unload_km;
    public $load_weight;
    public $unload_weight;
    public $unload_date;
    public $ded_det;
    public $ded_det_remarks;
    public $fasttag_cl_balance;
    public $delivery_receipt;
    public $delivery_pod;
    public $operator;
    public $datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "t_trip_info_d_unload";
        $this->TableName = 't_trip_info_d_unload';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "t_trip_info_d_unload";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // load_date
        $this->load_date = new DbField(
            $this, // Table
            'x_load_date', // Variable name
            'load_date', // Name
            '`load_date`', // Expression
            CastDateFieldForLike("`load_date`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`load_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->load_date->InputTextType = "text";
        $this->load_date->Raw = true;
        $this->load_date->Nullable = false; // NOT NULL field
        $this->load_date->Required = true; // Required field
        $this->load_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->load_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['load_date'] = &$this->load_date;

        // trip_info
        $this->trip_info = new DbField(
            $this, // Table
            'x_trip_info', // Variable name
            'trip_info', // Name
            '`trip_info`', // Expression
            '`trip_info`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`trip_info`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->trip_info->InputTextType = "text";
        $this->trip_info->Raw = true;
        $this->trip_info->IsAutoIncrement = true; // Autoincrement field
        $this->trip_info->Nullable = false; // NOT NULL field
        $this->trip_info->setSelectMultiple(false); // Select one
        $this->trip_info->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->trip_info->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->trip_info->Lookup = new Lookup($this->trip_info, 't_trip_info', false, 'id', ["route_name","","",""], '', '', [], [], [], [], [], [], false, '`route_name` ASC', '', "`route_name`");
        $this->trip_info->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->trip_info->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['trip_info'] = &$this->trip_info;

        // driver
        $this->driver = new DbField(
            $this, // Table
            'x_driver', // Variable name
            'driver', // Name
            '`driver`', // Expression
            '`driver`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`driver`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->driver->addMethod("getDefault", fn() => 0);
        $this->driver->InputTextType = "text";
        $this->driver->Raw = true;
        $this->driver->setSelectMultiple(false); // Select one
        $this->driver->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->driver->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->driver->Lookup = new Lookup($this->driver, 't_driver_info', false, 'id', ["name","mobile","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->driver) . "',COALESCE(`mobile`,''))");
        $this->driver->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->driver->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['driver'] = &$this->driver;

        // unload_km
        $this->unload_km = new DbField(
            $this, // Table
            'x_unload_km', // Variable name
            'unload_km', // Name
            '`unload_km`', // Expression
            '`unload_km`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unload_km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->unload_km->InputTextType = "text";
        $this->unload_km->Raw = true;
        $this->unload_km->Nullable = false; // NOT NULL field
        $this->unload_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->unload_km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['unload_km'] = &$this->unload_km;

        // load_weight
        $this->load_weight = new DbField(
            $this, // Table
            'x_load_weight', // Variable name
            'load_weight', // Name
            '`load_weight`', // Expression
            '`load_weight`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`load_weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->load_weight->addMethod("getDefault", fn() => 0);
        $this->load_weight->InputTextType = "text";
        $this->load_weight->Raw = true;
        $this->load_weight->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->load_weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['load_weight'] = &$this->load_weight;

        // unload_weight
        $this->unload_weight = new DbField(
            $this, // Table
            'x_unload_weight', // Variable name
            'unload_weight', // Name
            '`unload_weight`', // Expression
            '`unload_weight`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unload_weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->unload_weight->addMethod("getDefault", fn() => 0);
        $this->unload_weight->InputTextType = "text";
        $this->unload_weight->Raw = true;
        $this->unload_weight->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->unload_weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unload_weight'] = &$this->unload_weight;

        // unload_date
        $this->unload_date = new DbField(
            $this, // Table
            'x_unload_date', // Variable name
            'unload_date', // Name
            '`unload_date`', // Expression
            CastDateFieldForLike("`unload_date`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`unload_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->unload_date->InputTextType = "text";
        $this->unload_date->Raw = true;
        $this->unload_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->unload_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unload_date'] = &$this->unload_date;

        // ded_det
        $this->ded_det = new DbField(
            $this, // Table
            'x_ded_det', // Variable name
            'ded_det', // Name
            '`ded_det`', // Expression
            '`ded_det`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ded_det`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ded_det->addMethod("getDefault", fn() => 0.00);
        $this->ded_det->InputTextType = "text";
        $this->ded_det->Raw = true;
        $this->ded_det->Nullable = false; // NOT NULL field
        $this->ded_det->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ded_det->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ded_det'] = &$this->ded_det;

        // ded_det_remarks
        $this->ded_det_remarks = new DbField(
            $this, // Table
            'x_ded_det_remarks', // Variable name
            'ded_det_remarks', // Name
            '`ded_det_remarks`', // Expression
            '`ded_det_remarks`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ded_det_remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ded_det_remarks->InputTextType = "text";
        $this->ded_det_remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ded_det_remarks'] = &$this->ded_det_remarks;

        // fasttag_cl_balance
        $this->fasttag_cl_balance = new DbField(
            $this, // Table
            'x_fasttag_cl_balance', // Variable name
            'fasttag_cl_balance', // Name
            '`fasttag_cl_balance`', // Expression
            '`fasttag_cl_balance`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fasttag_cl_balance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fasttag_cl_balance->InputTextType = "text";
        $this->fasttag_cl_balance->Raw = true;
        $this->fasttag_cl_balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->fasttag_cl_balance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['fasttag_cl_balance'] = &$this->fasttag_cl_balance;

        // delivery_receipt
        $this->delivery_receipt = new DbField(
            $this, // Table
            'x_delivery_receipt', // Variable name
            'delivery_receipt', // Name
            '`delivery_receipt`', // Expression
            '`delivery_receipt`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`delivery_receipt`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->delivery_receipt->addMethod("getUploadPath", fn() => '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/');
        $this->delivery_receipt->InputTextType = "text";
        $this->delivery_receipt->UploadMultiple = true;
        $this->delivery_receipt->Upload->UploadMultiple = true;
        $this->delivery_receipt->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['delivery_receipt'] = &$this->delivery_receipt;

        // delivery_pod
        $this->delivery_pod = new DbField(
            $this, // Table
            'x_delivery_pod', // Variable name
            'delivery_pod', // Name
            '`delivery_pod`', // Expression
            '`delivery_pod`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`delivery_pod`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->delivery_pod->InputTextType = "text";
        $this->delivery_pod->Required = true; // Required field
        $this->delivery_pod->Lookup = new Lookup($this->delivery_pod, 't_trip_info_d_unload', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->delivery_pod->OptionCount = 3;
        $this->delivery_pod->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['delivery_pod'] = &$this->delivery_pod;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "t_trip_info_d_unload";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "`id`>0";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            $this->trip_info->setDbValue($conn->lastInsertId());
            $rs['trip_info'] = $this->trip_info->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['trip_info']) && !EmptyValue($this->trip_info->CurrentValue)) {
                $rs['trip_info'] = $this->trip_info->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->load_date->DbValue = $row['load_date'];
        $this->trip_info->DbValue = $row['trip_info'];
        $this->driver->DbValue = $row['driver'];
        $this->unload_km->DbValue = $row['unload_km'];
        $this->load_weight->DbValue = $row['load_weight'];
        $this->unload_weight->DbValue = $row['unload_weight'];
        $this->unload_date->DbValue = $row['unload_date'];
        $this->ded_det->DbValue = $row['ded_det'];
        $this->ded_det_remarks->DbValue = $row['ded_det_remarks'];
        $this->fasttag_cl_balance->DbValue = $row['fasttag_cl_balance'];
        $this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
        $this->delivery_pod->DbValue = $row['delivery_pod'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->delivery_receipt->OldUploadPath = $this->delivery_receipt->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['delivery_receipt']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['delivery_receipt']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->delivery_receipt->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->delivery_receipt->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("ttripinfodunloadlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "ttripinfodunloadview" => $Language->phrase("View"),
            "ttripinfodunloadedit" => $Language->phrase("Edit"),
            "ttripinfodunloadadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "ttripinfodunloadlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "TTripInfoDUnloadView",
            Config("API_ADD_ACTION") => "TTripInfoDUnloadAdd",
            Config("API_EDIT_ACTION") => "TTripInfoDUnloadEdit",
            Config("API_DELETE_ACTION") => "TTripInfoDUnloadDelete",
            Config("API_LIST_ACTION") => "TTripInfoDUnloadList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "ttripinfodunloadlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ttripinfodunloadview", $parm);
        } else {
            $url = $this->keyUrl("ttripinfodunloadview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "ttripinfodunloadadd?" . $parm;
        } else {
            $url = "ttripinfodunloadadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("ttripinfodunloadedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("ttripinfodunloadlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("ttripinfodunloadadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("ttripinfodunloadlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("ttripinfodunloaddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->load_date->setDbValue($row['load_date']);
        $this->trip_info->setDbValue($row['trip_info']);
        $this->driver->setDbValue($row['driver']);
        $this->unload_km->setDbValue($row['unload_km']);
        $this->load_weight->setDbValue($row['load_weight']);
        $this->unload_weight->setDbValue($row['unload_weight']);
        $this->unload_date->setDbValue($row['unload_date']);
        $this->ded_det->setDbValue($row['ded_det']);
        $this->ded_det_remarks->setDbValue($row['ded_det_remarks']);
        $this->fasttag_cl_balance->setDbValue($row['fasttag_cl_balance']);
        $this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
        $this->delivery_pod->setDbValue($row['delivery_pod']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "TTripInfoDUnloadList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // load_date

        // trip_info

        // driver

        // unload_km

        // load_weight

        // unload_weight

        // unload_date

        // ded_det

        // ded_det_remarks

        // fasttag_cl_balance

        // delivery_receipt

        // delivery_pod

        // operator

        // datetime

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // load_date
        $this->load_date->ViewValue = $this->load_date->CurrentValue;
        $this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, $this->load_date->formatPattern());

        // trip_info
        $curVal = strval($this->trip_info->CurrentValue);
        if ($curVal != "") {
            $this->trip_info->ViewValue = $this->trip_info->lookupCacheOption($curVal);
            if ($this->trip_info->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->trip_info->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->trip_info->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->trip_info->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->trip_info->Lookup->renderViewRow($rswrk[0]);
                    $this->trip_info->ViewValue = $this->trip_info->displayValue($arwrk);
                } else {
                    $this->trip_info->ViewValue = $this->trip_info->CurrentValue;
                }
            }
        } else {
            $this->trip_info->ViewValue = null;
        }

        // driver
        $curVal = strval($this->driver->CurrentValue);
        if ($curVal != "") {
            $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
            if ($this->driver->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->driver->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->driver->Lookup->renderViewRow($rswrk[0]);
                    $this->driver->ViewValue = $this->driver->displayValue($arwrk);
                } else {
                    $this->driver->ViewValue = FormatNumber($this->driver->CurrentValue, $this->driver->formatPattern());
                }
            }
        } else {
            $this->driver->ViewValue = null;
        }

        // unload_km
        $this->unload_km->ViewValue = $this->unload_km->CurrentValue;
        $this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, $this->unload_km->formatPattern());

        // load_weight
        $this->load_weight->ViewValue = $this->load_weight->CurrentValue;
        $this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, $this->load_weight->formatPattern());

        // unload_weight
        $this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
        $this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, $this->unload_weight->formatPattern());

        // unload_date
        $this->unload_date->ViewValue = $this->unload_date->CurrentValue;
        $this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, $this->unload_date->formatPattern());

        // ded_det
        $this->ded_det->ViewValue = $this->ded_det->CurrentValue;
        $this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, $this->ded_det->formatPattern());

        // ded_det_remarks
        $this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;

        // fasttag_cl_balance
        $this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
        $this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, $this->fasttag_cl_balance->formatPattern());

        // delivery_receipt
        $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
        if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
            $this->delivery_receipt->ImageWidth = 0;
            $this->delivery_receipt->ImageHeight = 50;
            $this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
            $this->delivery_receipt->ImageCssClass = "ew-image";
            $this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
        } else {
            $this->delivery_receipt->ViewValue = "";
        }

        // delivery_pod
        if (strval($this->delivery_pod->CurrentValue) != "") {
            $this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
        } else {
            $this->delivery_pod->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // load_date
        $this->load_date->HrefValue = "";
        $this->load_date->TooltipValue = "";

        // trip_info
        $this->trip_info->HrefValue = "";
        $this->trip_info->TooltipValue = "";

        // driver
        $this->driver->HrefValue = "";
        $this->driver->TooltipValue = "";

        // unload_km
        $this->unload_km->HrefValue = "";
        $this->unload_km->TooltipValue = "";

        // load_weight
        $this->load_weight->HrefValue = "";
        $this->load_weight->TooltipValue = "";

        // unload_weight
        $this->unload_weight->HrefValue = "";
        $this->unload_weight->TooltipValue = "";

        // unload_date
        $this->unload_date->HrefValue = "";
        $this->unload_date->TooltipValue = "";

        // ded_det
        $this->ded_det->HrefValue = "";
        $this->ded_det->TooltipValue = "";

        // ded_det_remarks
        $this->ded_det_remarks->HrefValue = "";
        $this->ded_det_remarks->TooltipValue = "";

        // fasttag_cl_balance
        $this->fasttag_cl_balance->HrefValue = "";
        $this->fasttag_cl_balance->TooltipValue = "";

        // delivery_receipt
        $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
        if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
            $this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
            $this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
            }
        } else {
            $this->delivery_receipt->HrefValue = "";
        }
        $this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;
        $this->delivery_receipt->TooltipValue = "";
        if ($this->delivery_receipt->UseColorbox) {
            if (EmptyValue($this->delivery_receipt->TooltipValue)) {
                $this->delivery_receipt->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->delivery_receipt->LinkAttrs["data-rel"] = "t_trip_info_d_unload_x_delivery_receipt";
            $this->delivery_receipt->LinkAttrs->appendClass("ew-lightbox");
        }

        // delivery_pod
        $this->delivery_pod->HrefValue = "";
        $this->delivery_pod->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // load_date
        $this->load_date->setupEditAttributes();
        $this->load_date->EditValue = FormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern());
        $this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

        // trip_info
        $this->trip_info->setupEditAttributes();
        $curVal = strval($this->trip_info->CurrentValue);
        if ($curVal != "") {
            $this->trip_info->EditValue = $this->trip_info->lookupCacheOption($curVal);
            if ($this->trip_info->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->trip_info->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->trip_info->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->trip_info->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->trip_info->Lookup->renderViewRow($rswrk[0]);
                    $this->trip_info->EditValue = $this->trip_info->displayValue($arwrk);
                } else {
                    $this->trip_info->EditValue = $this->trip_info->CurrentValue;
                }
            }
        } else {
            $this->trip_info->EditValue = null;
        }

        // driver
        $this->driver->setupEditAttributes();
        $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

        // unload_km
        $this->unload_km->setupEditAttributes();
        $this->unload_km->EditValue = $this->unload_km->CurrentValue;
        $this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());
        if (strval($this->unload_km->EditValue) != "" && is_numeric($this->unload_km->EditValue)) {
            $this->unload_km->EditValue = FormatNumber($this->unload_km->EditValue, null);
        }

        // load_weight
        $this->load_weight->setupEditAttributes();
        $this->load_weight->EditValue = $this->load_weight->CurrentValue;
        $this->load_weight->EditValue = FormatNumber($this->load_weight->EditValue, $this->load_weight->formatPattern());

        // unload_weight
        $this->unload_weight->setupEditAttributes();
        $this->unload_weight->EditValue = $this->unload_weight->CurrentValue;
        $this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());
        if (strval($this->unload_weight->EditValue) != "" && is_numeric($this->unload_weight->EditValue)) {
            $this->unload_weight->EditValue = FormatNumber($this->unload_weight->EditValue, null);
        }

        // unload_date
        $this->unload_date->setupEditAttributes();
        $this->unload_date->EditValue = FormatDateTime($this->unload_date->CurrentValue, $this->unload_date->formatPattern());
        $this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

        // ded_det
        $this->ded_det->setupEditAttributes();
        $this->ded_det->EditValue = $this->ded_det->CurrentValue;
        $this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());
        if (strval($this->ded_det->EditValue) != "" && is_numeric($this->ded_det->EditValue)) {
            $this->ded_det->EditValue = FormatNumber($this->ded_det->EditValue, null);
        }

        // ded_det_remarks
        $this->ded_det_remarks->setupEditAttributes();
        if (!$this->ded_det_remarks->Raw) {
            $this->ded_det_remarks->CurrentValue = HtmlDecode($this->ded_det_remarks->CurrentValue);
        }
        $this->ded_det_remarks->EditValue = $this->ded_det_remarks->CurrentValue;
        $this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

        // fasttag_cl_balance
        $this->fasttag_cl_balance->setupEditAttributes();
        $this->fasttag_cl_balance->EditValue = $this->fasttag_cl_balance->CurrentValue;
        $this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());
        if (strval($this->fasttag_cl_balance->EditValue) != "" && is_numeric($this->fasttag_cl_balance->EditValue)) {
            $this->fasttag_cl_balance->EditValue = FormatNumber($this->fasttag_cl_balance->EditValue, null);
        }

        // delivery_receipt
        $this->delivery_receipt->setupEditAttributes();
        $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
        if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
            $this->delivery_receipt->ImageWidth = 0;
            $this->delivery_receipt->ImageHeight = 50;
            $this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
            $this->delivery_receipt->ImageCssClass = "ew-image";
            $this->delivery_receipt->EditValue = $this->delivery_receipt->Upload->DbValue;
        } else {
            $this->delivery_receipt->EditValue = "";
        }
        if (!EmptyValue($this->delivery_receipt->CurrentValue)) {
            $this->delivery_receipt->Upload->FileName = $this->delivery_receipt->CurrentValue;
        }

        // delivery_pod
        $this->delivery_pod->EditValue = $this->delivery_pod->options(false);
        $this->delivery_pod->PlaceHolder = RemoveHtml($this->delivery_pod->caption());

        // operator

        // datetime

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->load_date);
                    $doc->exportCaption($this->trip_info);
                    $doc->exportCaption($this->driver);
                    $doc->exportCaption($this->unload_km);
                    $doc->exportCaption($this->load_weight);
                    $doc->exportCaption($this->unload_weight);
                    $doc->exportCaption($this->unload_date);
                    $doc->exportCaption($this->ded_det);
                    $doc->exportCaption($this->ded_det_remarks);
                    $doc->exportCaption($this->fasttag_cl_balance);
                    $doc->exportCaption($this->delivery_receipt);
                    $doc->exportCaption($this->delivery_pod);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->load_date);
                    $doc->exportCaption($this->trip_info);
                    $doc->exportCaption($this->driver);
                    $doc->exportCaption($this->unload_km);
                    $doc->exportCaption($this->load_weight);
                    $doc->exportCaption($this->unload_weight);
                    $doc->exportCaption($this->unload_date);
                    $doc->exportCaption($this->ded_det);
                    $doc->exportCaption($this->ded_det_remarks);
                    $doc->exportCaption($this->fasttag_cl_balance);
                    $doc->exportCaption($this->delivery_receipt);
                    $doc->exportCaption($this->delivery_pod);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->load_date);
                        $doc->exportField($this->trip_info);
                        $doc->exportField($this->driver);
                        $doc->exportField($this->unload_km);
                        $doc->exportField($this->load_weight);
                        $doc->exportField($this->unload_weight);
                        $doc->exportField($this->unload_date);
                        $doc->exportField($this->ded_det);
                        $doc->exportField($this->ded_det_remarks);
                        $doc->exportField($this->fasttag_cl_balance);
                        $doc->exportField($this->delivery_receipt);
                        $doc->exportField($this->delivery_pod);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->load_date);
                        $doc->exportField($this->trip_info);
                        $doc->exportField($this->driver);
                        $doc->exportField($this->unload_km);
                        $doc->exportField($this->load_weight);
                        $doc->exportField($this->unload_weight);
                        $doc->exportField($this->unload_date);
                        $doc->exportField($this->ded_det);
                        $doc->exportField($this->ded_det_remarks);
                        $doc->exportField($this->fasttag_cl_balance);
                        $doc->exportField($this->delivery_receipt);
                        $doc->exportField($this->delivery_pod);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'delivery_receipt') {
            $fldName = "delivery_receipt";
            $fileNameFld = "delivery_receipt";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
