<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for t_trip_info
 */
class TTripInfo extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $vehicle_type;
    public $vehicle;
    public $_route;
    public $route_name;
    public $reports_to;
    public $buyer;
    public $b_consignor;
    public $b_consignee;
    public $load_date;
    public $load_weight;
    public $unload_date;
    public $unload_weight;
    public $invoice_no;
    public $invoice_date;
    public $amount;
    public $delivery_pod;
    public $status;
    public $days;
    public $driver;
    public $driver_name;
    public $agent;
    public $comm;
    public $material;
    public $packing_type;
    public $m_hsn;
    public $_40;
    public $lr_no;
    public $km;
    public $freight_type;
    public $freight;
    public $ded_det;
    public $ded_det_remarks;
    public $gst_percent;
    public $gst_amount;
    public $final_amount;
    public $load_km;
    public $unload_km;
    public $delivery_receipt;
    public $delivery_docket;
    public $diesal_op_b;
    public $diesal_required;
    public $diesal_fill;
    public $diesal_amount;
    public $diesal_cl_balance;
    public $vehicle_average;
    public $cash_required;
    public $cash_op_b;
    public $cash_paid;
    public $cash_expenses;
    public $cash_cl_balance;
    public $fasttag_op_b;
    public $fasttag_recharge;
    public $fasttag_expenses;
    public $toll_expenses_cash;
    public $fasttag_cl_balance;
    public $remarks;
    public $uploads;
    public $consignor;
    public $vehicle_freight_comm;
    public $vehicle_freight_type;
    public $vehicle_freight_amount;
    public $vehicle_freight_final;
    public $operator;
    public $datetime;
    public $expenses_id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "t_trip_info";
        $this->TableName = 't_trip_info';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "t_trip_info";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->IsForeignKey = true; // Foreign key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // vehicle_type
        $this->vehicle_type = new DbField(
            $this, // Table
            'x_vehicle_type', // Variable name
            'vehicle_type', // Name
            '`vehicle_type`', // Expression
            '`vehicle_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->vehicle_type->addMethod("getDefault", fn() => 1);
        $this->vehicle_type->InputTextType = "text";
        $this->vehicle_type->Raw = true;
        $this->vehicle_type->Nullable = false; // NOT NULL field
        $this->vehicle_type->setSelectMultiple(false); // Select one
        $this->vehicle_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->vehicle_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->vehicle_type->Lookup = new Lookup($this->vehicle_type, 't_trip_info', false, '', ["","","",""], '', '', [], ["x_vehicle"], [], [], [], [], false, '', '', "");
        $this->vehicle_type->OptionCount = 2;
        $this->vehicle_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->vehicle_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_type'] = &$this->vehicle_type;

        // vehicle
        $this->vehicle = new DbField(
            $this, // Table
            'x_vehicle', // Variable name
            'vehicle', // Name
            '`vehicle`', // Expression
            '`vehicle`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->vehicle->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "");
        $this->vehicle->InputTextType = "text";
        $this->vehicle->Raw = true;
        $this->vehicle->Nullable = false; // NOT NULL field
        $this->vehicle->Required = true; // Required field
        $this->vehicle->Lookup = new Lookup($this->vehicle, 'vehicle_info', false, 'id', ["no","","",""], '', '', ["x_vehicle_type"], [], ["type"], ["x_type"], ["driver_name","vehicle_owner"], ["x_driver","x_consignor"], false, '`no` ASC', '', "`no`");
        $this->vehicle->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->vehicle->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle'] = &$this->vehicle;

        // route
        $this->_route = new DbField(
            $this, // Table
            'x__route', // Variable name
            'route', // Name
            '`route`', // Expression
            '`route`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`route`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_route->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->_route->InputTextType = "text";
        $this->_route->Raw = true;
        $this->_route->IsForeignKey = true; // Foreign key field
        $this->_route->Nullable = false; // NOT NULL field
        $this->_route->Required = true; // Required field
        $this->_route->Lookup = new Lookup($this->_route, 't_route_info', false, 'id', ["route_name","","",""], '', '', [], [], [], [], [], [], false, '`route_name` ASC', '', "`route_name`");
        $this->_route->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_route->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['route'] = &$this->_route;

        // route_name
        $this->route_name = new DbField(
            $this, // Table
            'x_route_name', // Variable name
            'route_name', // Name
            '`route_name`', // Expression
            '`route_name`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`route_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->route_name->InputTextType = "text";
        $this->route_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['route_name'] = &$this->route_name;

        // reports_to
        $this->reports_to = new DbField(
            $this, // Table
            'x_reports_to', // Variable name
            'reports_to', // Name
            '`reports_to`', // Expression
            '`reports_to`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`reports_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->reports_to->addMethod("getSelectFilter", fn() => "`activated`=1 and `userlevel`=1003");
        $this->reports_to->addMethod("getDefault", fn() => 0);
        $this->reports_to->InputTextType = "text";
        $this->reports_to->Raw = true;
        $this->reports_to->setSelectMultiple(false); // Select one
        $this->reports_to->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->reports_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->reports_to->Lookup = new Lookup($this->reports_to, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->reports_to->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['reports_to'] = &$this->reports_to;

        // buyer
        $this->buyer = new DbField(
            $this, // Table
            'x_buyer', // Variable name
            'buyer', // Name
            '`buyer`', // Expression
            '`buyer`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer->addMethod("getSelectFilter", fn() => "`category` = 902 and `status` = 1");
        $this->buyer->InputTextType = "text";
        $this->buyer->Raw = true;
        $this->buyer->Nullable = false; // NOT NULL field
        $this->buyer->Required = true; // Required field
        $this->buyer->Lookup = new Lookup($this->buyer, 'buyer', false, 'id', ["name","","",""], '', '', [], [], [], [], ["id","id"], ["x_b_consignor","x_b_consignee"], false, '`name` ASC', '', "`name`");
        $this->buyer->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['buyer'] = &$this->buyer;

        // b_consignor
        $this->b_consignor = new DbField(
            $this, // Table
            'x_b_consignor', // Variable name
            'b_consignor', // Name
            '`b_consignor`', // Expression
            '`b_consignor`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_consignor`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_consignor->addMethod("getSelectFilter", fn() => "`category` = 902 and `status` = 1");
        $this->b_consignor->InputTextType = "text";
        $this->b_consignor->Raw = true;
        $this->b_consignor->Required = true; // Required field
        $this->b_consignor->Lookup = new Lookup($this->b_consignor, 'buyer', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], true, '`name` ASC', '', "`name`");
        $this->b_consignor->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_consignor'] = &$this->b_consignor;

        // b_consignee
        $this->b_consignee = new DbField(
            $this, // Table
            'x_b_consignee', // Variable name
            'b_consignee', // Name
            '`b_consignee`', // Expression
            '`b_consignee`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_consignee`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_consignee->addMethod("getSelectFilter", fn() => "`category` = 902 and `status` = 1");
        $this->b_consignee->InputTextType = "text";
        $this->b_consignee->Raw = true;
        $this->b_consignee->Required = true; // Required field
        $this->b_consignee->Lookup = new Lookup($this->b_consignee, 'buyer', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], true, '`name` ASC', '', "`name`");
        $this->b_consignee->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_consignee'] = &$this->b_consignee;

        // load_date
        $this->load_date = new DbField(
            $this, // Table
            'x_load_date', // Variable name
            'load_date', // Name
            '`load_date`', // Expression
            CastDateFieldForLike("`load_date`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`load_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->load_date->InputTextType = "text";
        $this->load_date->Raw = true;
        $this->load_date->Nullable = false; // NOT NULL field
        $this->load_date->Required = true; // Required field
        $this->load_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->load_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['load_date'] = &$this->load_date;

        // load_weight
        $this->load_weight = new DbField(
            $this, // Table
            'x_load_weight', // Variable name
            'load_weight', // Name
            '`load_weight`', // Expression
            '`load_weight`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`load_weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->load_weight->InputTextType = "text";
        $this->load_weight->Raw = true;
        $this->load_weight->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->load_weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['load_weight'] = &$this->load_weight;

        // unload_date
        $this->unload_date = new DbField(
            $this, // Table
            'x_unload_date', // Variable name
            'unload_date', // Name
            '`unload_date`', // Expression
            CastDateFieldForLike("`unload_date`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`unload_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->unload_date->InputTextType = "text";
        $this->unload_date->Raw = true;
        $this->unload_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->unload_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unload_date'] = &$this->unload_date;

        // unload_weight
        $this->unload_weight = new DbField(
            $this, // Table
            'x_unload_weight', // Variable name
            'unload_weight', // Name
            '`unload_weight`', // Expression
            '`unload_weight`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unload_weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->unload_weight->addMethod("getDefault", fn() => 0);
        $this->unload_weight->InputTextType = "text";
        $this->unload_weight->Raw = true;
        $this->unload_weight->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->unload_weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['unload_weight'] = &$this->unload_weight;

        // invoice_no
        $this->invoice_no = new DbField(
            $this, // Table
            'x_invoice_no', // Variable name
            'invoice_no', // Name
            '`invoice_no`', // Expression
            '`invoice_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`invoice_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->invoice_no->addMethod("getDefault", fn() => 0);
        $this->invoice_no->InputTextType = "text";
        $this->invoice_no->Raw = true;
        $this->invoice_no->Nullable = false; // NOT NULL field
        $this->invoice_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->invoice_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['invoice_no'] = &$this->invoice_no;

        // invoice_date
        $this->invoice_date = new DbField(
            $this, // Table
            'x_invoice_date', // Variable name
            'invoice_date', // Name
            '`invoice_date`', // Expression
            CastDateFieldForLike("`invoice_date`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`invoice_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->invoice_date->InputTextType = "text";
        $this->invoice_date->Raw = true;
        $this->invoice_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->invoice_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['invoice_date'] = &$this->invoice_date;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->addMethod("getDefault", fn() => 0.00);
        $this->amount->InputTextType = "text";
        $this->amount->Raw = true;
        $this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['amount'] = &$this->amount;

        // delivery_pod
        $this->delivery_pod = new DbField(
            $this, // Table
            'x_delivery_pod', // Variable name
            'delivery_pod', // Name
            '`delivery_pod`', // Expression
            '`delivery_pod`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`delivery_pod`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->delivery_pod->addMethod("getDefault", fn() => 0);
        $this->delivery_pod->InputTextType = "text";
        $this->delivery_pod->Lookup = new Lookup($this->delivery_pod, 't_trip_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->delivery_pod->OptionCount = 3;
        $this->delivery_pod->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['delivery_pod'] = &$this->delivery_pod;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 0);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->Required = true; // Required field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 't_trip_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 4;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // days
        $this->days = new DbField(
            $this, // Table
            'x_days', // Variable name
            'days', // Name
            '`days`', // Expression
            '`days`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`days`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->days->InputTextType = "text";
        $this->days->Raw = true;
        $this->days->Nullable = false; // NOT NULL field
        $this->days->Required = true; // Required field
        $this->days->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->days->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['days'] = &$this->days;

        // driver
        $this->driver = new DbField(
            $this, // Table
            'x_driver', // Variable name
            'driver', // Name
            '`driver`', // Expression
            '`driver`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`driver`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->driver->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->driver->InputTextType = "text";
        $this->driver->Raw = true;
        $this->driver->setSelectMultiple(false); // Select one
        $this->driver->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->driver->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->driver->Lookup = new Lookup($this->driver, 't_driver_info', false, 'id', ["name","id","",""], '', '', [], [], [], [], [], [], true, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->driver) . "',COALESCE(`id`,''))");
        $this->driver->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['driver'] = &$this->driver;

        // driver_name
        $this->driver_name = new DbField(
            $this, // Table
            'x_driver_name', // Variable name
            'driver_name', // Name
            '`driver_name`', // Expression
            '`driver_name`', // Basic search expression
            200, // Type
            92, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`driver_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->driver_name->InputTextType = "text";
        $this->driver_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['driver_name'] = &$this->driver_name;

        // agent
        $this->agent = new DbField(
            $this, // Table
            'x_agent', // Variable name
            'agent', // Name
            '`agent`', // Expression
            '`agent`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`agent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->agent->addMethod("getSelectFilter", fn() => "`category` = 902 and `status` = 1");
        $this->agent->InputTextType = "text";
        $this->agent->Raw = true;
        $this->agent->Lookup = new Lookup($this->agent, 'buyer', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->agent->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->agent->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['agent'] = &$this->agent;

        // comm
        $this->comm = new DbField(
            $this, // Table
            'x_comm', // Variable name
            'comm', // Name
            '`comm`', // Expression
            '`comm`', // Basic search expression
            131, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`comm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->comm->addMethod("getDefault", fn() => 0.00);
        $this->comm->InputTextType = "text";
        $this->comm->Raw = true;
        $this->comm->Nullable = false; // NOT NULL field
        $this->comm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->comm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['comm'] = &$this->comm;

        // material
        $this->material = new DbField(
            $this, // Table
            'x_material', // Variable name
            'material', // Name
            '`material`', // Expression
            '`material`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`material`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->material->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->material->InputTextType = "text";
        $this->material->Nullable = false; // NOT NULL field
        $this->material->Required = true; // Required field
        $this->material->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['material'] = &$this->material;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Nullable = false; // NOT NULL field
        $this->packing_type->Required = true; // Required field
        $this->packing_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // m_hsn
        $this->m_hsn = new DbField(
            $this, // Table
            'x_m_hsn', // Variable name
            'm_hsn', // Name
            '`m_hsn`', // Expression
            '`m_hsn`', // Basic search expression
            200, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`m_hsn`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->m_hsn->InputTextType = "text";
        $this->m_hsn->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['m_hsn'] = &$this->m_hsn;

        // @
        $this->_40 = new DbField(
            $this, // Table
            'x__40', // Variable name
            '@', // Name
            '`@`', // Expression
            '`@`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`@`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_40->InputTextType = "text";
        $this->_40->Raw = true;
        $this->_40->Nullable = false; // NOT NULL field
        $this->_40->Required = true; // Required field
        $this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_40->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['@'] = &$this->_40;

        // lr_no
        $this->lr_no = new DbField(
            $this, // Table
            'x_lr_no', // Variable name
            'lr_no', // Name
            '`lr_no`', // Expression
            '`lr_no`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lr_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lr_no->InputTextType = "text";
        $this->lr_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['lr_no'] = &$this->lr_no;

        // km
        $this->km = new DbField(
            $this, // Table
            'x_km', // Variable name
            'km', // Name
            '`km`', // Expression
            '`km`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->km->InputTextType = "text";
        $this->km->Raw = true;
        $this->km->Required = true; // Required field
        $this->km->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['km'] = &$this->km;

        // freight_type
        $this->freight_type = new DbField(
            $this, // Table
            'x_freight_type', // Variable name
            'freight_type', // Name
            '`freight_type`', // Expression
            '`freight_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`freight_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->freight_type->addMethod("getDefault", fn() => 0);
        $this->freight_type->InputTextType = "text";
        $this->freight_type->Raw = true;
        $this->freight_type->Nullable = false; // NOT NULL field
        $this->freight_type->setSelectMultiple(false); // Select one
        $this->freight_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->freight_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->freight_type->Lookup = new Lookup($this->freight_type, 't_trip_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->freight_type->OptionCount = 2;
        $this->freight_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->freight_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['freight_type'] = &$this->freight_type;

        // freight
        $this->freight = new DbField(
            $this, // Table
            'x_freight', // Variable name
            'freight', // Name
            '`freight`', // Expression
            '`freight`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`freight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->freight->InputTextType = "text";
        $this->freight->Raw = true;
        $this->freight->Nullable = false; // NOT NULL field
        $this->freight->Required = true; // Required field
        $this->freight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->freight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['freight'] = &$this->freight;

        // ded_det
        $this->ded_det = new DbField(
            $this, // Table
            'x_ded_det', // Variable name
            'ded_det', // Name
            '`ded_det`', // Expression
            '`ded_det`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ded_det`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ded_det->addMethod("getDefault", fn() => 0.00);
        $this->ded_det->InputTextType = "text";
        $this->ded_det->Raw = true;
        $this->ded_det->Nullable = false; // NOT NULL field
        $this->ded_det->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ded_det->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ded_det'] = &$this->ded_det;

        // ded_det_remarks
        $this->ded_det_remarks = new DbField(
            $this, // Table
            'x_ded_det_remarks', // Variable name
            'ded_det_remarks', // Name
            '`ded_det_remarks`', // Expression
            '`ded_det_remarks`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ded_det_remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ded_det_remarks->InputTextType = "text";
        $this->ded_det_remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ded_det_remarks'] = &$this->ded_det_remarks;

        // gst_percent
        $this->gst_percent = new DbField(
            $this, // Table
            'x_gst_percent', // Variable name
            'gst_percent', // Name
            '`gst_percent`', // Expression
            '`gst_percent`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gst_percent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gst_percent->addMethod("getDefault", fn() => 0.00);
        $this->gst_percent->InputTextType = "text";
        $this->gst_percent->Raw = true;
        $this->gst_percent->Nullable = false; // NOT NULL field
        $this->gst_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->gst_percent->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['gst_percent'] = &$this->gst_percent;

        // gst_amount
        $this->gst_amount = new DbField(
            $this, // Table
            'x_gst_amount', // Variable name
            'gst_amount', // Name
            '`gst_amount`', // Expression
            '`gst_amount`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gst_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gst_amount->addMethod("getDefault", fn() => 0.00);
        $this->gst_amount->InputTextType = "text";
        $this->gst_amount->Raw = true;
        $this->gst_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->gst_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['gst_amount'] = &$this->gst_amount;

        // final_amount
        $this->final_amount = new DbField(
            $this, // Table
            'x_final_amount', // Variable name
            'final_amount', // Name
            '`final_amount`', // Expression
            '`final_amount`', // Basic search expression
            131, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`final_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->final_amount->addMethod("getDefault", fn() => 0.00);
        $this->final_amount->InputTextType = "text";
        $this->final_amount->Raw = true;
        $this->final_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->final_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['final_amount'] = &$this->final_amount;

        // load_km
        $this->load_km = new DbField(
            $this, // Table
            'x_load_km', // Variable name
            'load_km', // Name
            '`load_km`', // Expression
            '`load_km`', // Basic search expression
            3, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`load_km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->load_km->InputTextType = "text";
        $this->load_km->Raw = true;
        $this->load_km->Nullable = false; // NOT NULL field
        $this->load_km->Required = true; // Required field
        $this->load_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->load_km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['load_km'] = &$this->load_km;

        // unload_km
        $this->unload_km = new DbField(
            $this, // Table
            'x_unload_km', // Variable name
            'unload_km', // Name
            '`unload_km`', // Expression
            '`unload_km`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unload_km`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->unload_km->InputTextType = "text";
        $this->unload_km->Raw = true;
        $this->unload_km->Nullable = false; // NOT NULL field
        $this->unload_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->unload_km->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['unload_km'] = &$this->unload_km;

        // delivery_receipt
        $this->delivery_receipt = new DbField(
            $this, // Table
            'x_delivery_receipt', // Variable name
            'delivery_receipt', // Name
            '`delivery_receipt`', // Expression
            '`delivery_receipt`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`delivery_receipt`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->delivery_receipt->addMethod("getUploadPath", fn() => '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/');
        $this->delivery_receipt->InputTextType = "text";
        $this->delivery_receipt->UploadMultiple = true;
        $this->delivery_receipt->Upload->UploadMultiple = true;
        $this->delivery_receipt->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['delivery_receipt'] = &$this->delivery_receipt;

        // delivery_docket
        $this->delivery_docket = new DbField(
            $this, // Table
            'x_delivery_docket', // Variable name
            'delivery_docket', // Name
            '`delivery_docket`', // Expression
            '`delivery_docket`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`delivery_docket`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->delivery_docket->InputTextType = "text";
        $this->delivery_docket->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['delivery_docket'] = &$this->delivery_docket;

        // diesal_op_b
        $this->diesal_op_b = new DbField(
            $this, // Table
            'x_diesal_op_b', // Variable name
            'diesal_op_b', // Name
            '`diesal_op_b`', // Expression
            '`diesal_op_b`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`diesal_op_b`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->diesal_op_b->InputTextType = "text";
        $this->diesal_op_b->Raw = true;
        $this->diesal_op_b->Nullable = false; // NOT NULL field
        $this->diesal_op_b->Required = true; // Required field
        $this->diesal_op_b->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->diesal_op_b->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['diesal_op_b'] = &$this->diesal_op_b;

        // diesal_required
        $this->diesal_required = new DbField(
            $this, // Table
            'x_diesal_required', // Variable name
            'diesal_required', // Name
            '`diesal_required`', // Expression
            '`diesal_required`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`diesal_required`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->diesal_required->InputTextType = "text";
        $this->diesal_required->Raw = true;
        $this->diesal_required->Required = true; // Required field
        $this->diesal_required->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->diesal_required->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['diesal_required'] = &$this->diesal_required;

        // diesal_fill
        $this->diesal_fill = new DbField(
            $this, // Table
            'x_diesal_fill', // Variable name
            'diesal_fill', // Name
            '`diesal_fill`', // Expression
            '`diesal_fill`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`diesal_fill`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->diesal_fill->InputTextType = "text";
        $this->diesal_fill->Raw = true;
        $this->diesal_fill->Nullable = false; // NOT NULL field
        $this->diesal_fill->Required = true; // Required field
        $this->diesal_fill->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->diesal_fill->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['diesal_fill'] = &$this->diesal_fill;

        // diesal_amount
        $this->diesal_amount = new DbField(
            $this, // Table
            'x_diesal_amount', // Variable name
            'diesal_amount', // Name
            '`diesal_amount`', // Expression
            '`diesal_amount`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`diesal_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->diesal_amount->addMethod("getDefault", fn() => 0.00);
        $this->diesal_amount->InputTextType = "text";
        $this->diesal_amount->Raw = true;
        $this->diesal_amount->Nullable = false; // NOT NULL field
        $this->diesal_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->diesal_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['diesal_amount'] = &$this->diesal_amount;

        // diesal_cl_balance
        $this->diesal_cl_balance = new DbField(
            $this, // Table
            'x_diesal_cl_balance', // Variable name
            'diesal_cl_balance', // Name
            '`diesal_cl_balance`', // Expression
            '`diesal_cl_balance`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`diesal_cl_balance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->diesal_cl_balance->addMethod("getDefault", fn() => 0.00);
        $this->diesal_cl_balance->InputTextType = "text";
        $this->diesal_cl_balance->Raw = true;
        $this->diesal_cl_balance->Nullable = false; // NOT NULL field
        $this->diesal_cl_balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->diesal_cl_balance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['diesal_cl_balance'] = &$this->diesal_cl_balance;

        // vehicle_average
        $this->vehicle_average = new DbField(
            $this, // Table
            'x_vehicle_average', // Variable name
            'vehicle_average', // Name
            '`vehicle_average`', // Expression
            '`vehicle_average`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_average`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->vehicle_average->InputTextType = "text";
        $this->vehicle_average->Raw = true;
        $this->vehicle_average->Nullable = false; // NOT NULL field
        $this->vehicle_average->Required = true; // Required field
        $this->vehicle_average->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->vehicle_average->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_average'] = &$this->vehicle_average;

        // cash_required
        $this->cash_required = new DbField(
            $this, // Table
            'x_cash_required', // Variable name
            'cash_required', // Name
            '`cash_required`', // Expression
            '`cash_required`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cash_required`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cash_required->InputTextType = "text";
        $this->cash_required->Raw = true;
        $this->cash_required->Required = true; // Required field
        $this->cash_required->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cash_required->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cash_required'] = &$this->cash_required;

        // cash_op_b
        $this->cash_op_b = new DbField(
            $this, // Table
            'x_cash_op_b', // Variable name
            'cash_op_b', // Name
            '`cash_op_b`', // Expression
            '`cash_op_b`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cash_op_b`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cash_op_b->InputTextType = "text";
        $this->cash_op_b->Raw = true;
        $this->cash_op_b->Nullable = false; // NOT NULL field
        $this->cash_op_b->Required = true; // Required field
        $this->cash_op_b->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cash_op_b->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cash_op_b'] = &$this->cash_op_b;

        // cash_paid
        $this->cash_paid = new DbField(
            $this, // Table
            'x_cash_paid', // Variable name
            'cash_paid', // Name
            '`cash_paid`', // Expression
            '`cash_paid`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cash_paid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cash_paid->InputTextType = "text";
        $this->cash_paid->Raw = true;
        $this->cash_paid->Nullable = false; // NOT NULL field
        $this->cash_paid->Required = true; // Required field
        $this->cash_paid->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cash_paid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cash_paid'] = &$this->cash_paid;

        // cash_expenses
        $this->cash_expenses = new DbField(
            $this, // Table
            'x_cash_expenses', // Variable name
            'cash_expenses', // Name
            '`cash_expenses`', // Expression
            '`cash_expenses`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cash_expenses`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cash_expenses->addMethod("getDefault", fn() => 0.00);
        $this->cash_expenses->InputTextType = "text";
        $this->cash_expenses->Raw = true;
        $this->cash_expenses->Nullable = false; // NOT NULL field
        $this->cash_expenses->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cash_expenses->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cash_expenses'] = &$this->cash_expenses;

        // cash_cl_balance
        $this->cash_cl_balance = new DbField(
            $this, // Table
            'x_cash_cl_balance', // Variable name
            'cash_cl_balance', // Name
            '`cash_cl_balance`', // Expression
            '`cash_cl_balance`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cash_cl_balance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cash_cl_balance->addMethod("getDefault", fn() => 0.00);
        $this->cash_cl_balance->InputTextType = "text";
        $this->cash_cl_balance->Raw = true;
        $this->cash_cl_balance->Nullable = false; // NOT NULL field
        $this->cash_cl_balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cash_cl_balance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cash_cl_balance'] = &$this->cash_cl_balance;

        // fasttag_op_b
        $this->fasttag_op_b = new DbField(
            $this, // Table
            'x_fasttag_op_b', // Variable name
            'fasttag_op_b', // Name
            '`fasttag_op_b`', // Expression
            '`fasttag_op_b`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fasttag_op_b`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fasttag_op_b->addMethod("getDefault", fn() => 0.00);
        $this->fasttag_op_b->InputTextType = "text";
        $this->fasttag_op_b->Raw = true;
        $this->fasttag_op_b->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->fasttag_op_b->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['fasttag_op_b'] = &$this->fasttag_op_b;

        // fasttag_recharge
        $this->fasttag_recharge = new DbField(
            $this, // Table
            'x_fasttag_recharge', // Variable name
            'fasttag_recharge', // Name
            '`fasttag_recharge`', // Expression
            '`fasttag_recharge`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fasttag_recharge`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fasttag_recharge->addMethod("getDefault", fn() => 0.00);
        $this->fasttag_recharge->InputTextType = "text";
        $this->fasttag_recharge->Raw = true;
        $this->fasttag_recharge->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->fasttag_recharge->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['fasttag_recharge'] = &$this->fasttag_recharge;

        // fasttag_expenses
        $this->fasttag_expenses = new DbField(
            $this, // Table
            'x_fasttag_expenses', // Variable name
            'fasttag_expenses', // Name
            '`fasttag_expenses`', // Expression
            '`fasttag_expenses`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fasttag_expenses`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fasttag_expenses->addMethod("getDefault", fn() => 0.00);
        $this->fasttag_expenses->InputTextType = "text";
        $this->fasttag_expenses->Raw = true;
        $this->fasttag_expenses->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->fasttag_expenses->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['fasttag_expenses'] = &$this->fasttag_expenses;

        // toll_expenses_cash
        $this->toll_expenses_cash = new DbField(
            $this, // Table
            'x_toll_expenses_cash', // Variable name
            'toll_expenses_cash', // Name
            '`toll_expenses_cash`', // Expression
            '`toll_expenses_cash`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`toll_expenses_cash`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->toll_expenses_cash->addMethod("getDefault", fn() => 0.00);
        $this->toll_expenses_cash->InputTextType = "text";
        $this->toll_expenses_cash->Raw = true;
        $this->toll_expenses_cash->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->toll_expenses_cash->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['toll_expenses_cash'] = &$this->toll_expenses_cash;

        // fasttag_cl_balance
        $this->fasttag_cl_balance = new DbField(
            $this, // Table
            'x_fasttag_cl_balance', // Variable name
            'fasttag_cl_balance', // Name
            '`fasttag_cl_balance`', // Expression
            '`fasttag_cl_balance`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fasttag_cl_balance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fasttag_cl_balance->InputTextType = "text";
        $this->fasttag_cl_balance->Raw = true;
        $this->fasttag_cl_balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->fasttag_cl_balance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['fasttag_cl_balance'] = &$this->fasttag_cl_balance;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->Sortable = false; // Allow sort
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // uploads
        $this->uploads = new DbField(
            $this, // Table
            'x_uploads', // Variable name
            'uploads', // Name
            '`uploads`', // Expression
            '`uploads`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`uploads`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->uploads->addMethod("getUploadPath", fn() => '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/');
        $this->uploads->InputTextType = "text";
        $this->uploads->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uploads'] = &$this->uploads;

        // consignor
        $this->consignor = new DbField(
            $this, // Table
            'x_consignor', // Variable name
            'consignor', // Name
            '`consignor`', // Expression
            '`consignor`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`consignor`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->consignor->addMethod("getSelectFilter", fn() => "`category` = 902");
        $this->consignor->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->consignor->InputTextType = "text";
        $this->consignor->Raw = true;
        $this->consignor->Nullable = false; // NOT NULL field
        $this->consignor->Required = true; // Required field
        $this->consignor->Lookup = new Lookup($this->consignor, 'production_partner', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], true, '`name` ASC', '', "`name`");
        $this->consignor->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->consignor->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['consignor'] = &$this->consignor;

        // vehicle_freight_comm
        $this->vehicle_freight_comm = new DbField(
            $this, // Table
            'x_vehicle_freight_comm', // Variable name
            'vehicle_freight_comm', // Name
            '`vehicle_freight_comm`', // Expression
            '`vehicle_freight_comm`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_freight_comm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->vehicle_freight_comm->addMethod("getDefault", fn() => 0.00);
        $this->vehicle_freight_comm->InputTextType = "text";
        $this->vehicle_freight_comm->Raw = true;
        $this->vehicle_freight_comm->Nullable = false; // NOT NULL field
        $this->vehicle_freight_comm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->vehicle_freight_comm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_freight_comm'] = &$this->vehicle_freight_comm;

        // vehicle_freight_type
        $this->vehicle_freight_type = new DbField(
            $this, // Table
            'x_vehicle_freight_type', // Variable name
            'vehicle_freight_type', // Name
            '`vehicle_freight_type`', // Expression
            '`vehicle_freight_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_freight_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->vehicle_freight_type->addMethod("getDefault", fn() => 0);
        $this->vehicle_freight_type->InputTextType = "text";
        $this->vehicle_freight_type->Raw = true;
        $this->vehicle_freight_type->Nullable = false; // NOT NULL field
        $this->vehicle_freight_type->setSelectMultiple(false); // Select one
        $this->vehicle_freight_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->vehicle_freight_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->vehicle_freight_type->Lookup = new Lookup($this->vehicle_freight_type, 't_trip_info', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->vehicle_freight_type->OptionCount = 2;
        $this->vehicle_freight_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->vehicle_freight_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_freight_type'] = &$this->vehicle_freight_type;

        // vehicle_freight_amount
        $this->vehicle_freight_amount = new DbField(
            $this, // Table
            'x_vehicle_freight_amount', // Variable name
            'vehicle_freight_amount', // Name
            '`vehicle_freight_amount`', // Expression
            '`vehicle_freight_amount`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_freight_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->vehicle_freight_amount->InputTextType = "text";
        $this->vehicle_freight_amount->Raw = true;
        $this->vehicle_freight_amount->Nullable = false; // NOT NULL field
        $this->vehicle_freight_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->vehicle_freight_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_freight_amount'] = &$this->vehicle_freight_amount;

        // vehicle_freight_final
        $this->vehicle_freight_final = new DbField(
            $this, // Table
            'x_vehicle_freight_final', // Variable name
            'vehicle_freight_final', // Name
            '`vehicle_freight_final`', // Expression
            '`vehicle_freight_final`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`vehicle_freight_final`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->vehicle_freight_final->addMethod("getDefault", fn() => 0.00);
        $this->vehicle_freight_final->InputTextType = "text";
        $this->vehicle_freight_final->Raw = true;
        $this->vehicle_freight_final->Nullable = false; // NOT NULL field
        $this->vehicle_freight_final->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->vehicle_freight_final->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['vehicle_freight_final'] = &$this->vehicle_freight_final;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // expenses_id
        $this->expenses_id = new DbField(
            $this, // Table
            'x_expenses_id', // Variable name
            'expenses_id', // Name
            '`expenses_id`', // Expression
            '`expenses_id`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`expenses_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->expenses_id->addMethod("getDefault", fn() => 0);
        $this->expenses_id->InputTextType = "text";
        $this->expenses_id->Raw = true;
        $this->expenses_id->Nullable = false; // NOT NULL field
        $this->expenses_id->Sortable = false; // Allow sort
        $this->expenses_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->expenses_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['expenses_id'] = &$this->expenses_id;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")) ?? "";
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "t_expenses_o") {
            $detailUrl = Container("t_expenses_o")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "t_receipt_d") {
            $detailUrl = Container("t_receipt_d")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "t_diesal_expenses") {
            $detailUrl = Container("t_diesal_expenses")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "t_route_info") {
            $detailUrl = Container("t_route_info")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk__route", $this->_route->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "ttripinfolist";
        }
        return $detailUrl;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "t_trip_info";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "`id` > 0";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->vehicle_type->DbValue = $row['vehicle_type'];
        $this->vehicle->DbValue = $row['vehicle'];
        $this->_route->DbValue = $row['route'];
        $this->route_name->DbValue = $row['route_name'];
        $this->reports_to->DbValue = $row['reports_to'];
        $this->buyer->DbValue = $row['buyer'];
        $this->b_consignor->DbValue = $row['b_consignor'];
        $this->b_consignee->DbValue = $row['b_consignee'];
        $this->load_date->DbValue = $row['load_date'];
        $this->load_weight->DbValue = $row['load_weight'];
        $this->unload_date->DbValue = $row['unload_date'];
        $this->unload_weight->DbValue = $row['unload_weight'];
        $this->invoice_no->DbValue = $row['invoice_no'];
        $this->invoice_date->DbValue = $row['invoice_date'];
        $this->amount->DbValue = $row['amount'];
        $this->delivery_pod->DbValue = $row['delivery_pod'];
        $this->status->DbValue = $row['status'];
        $this->days->DbValue = $row['days'];
        $this->driver->DbValue = $row['driver'];
        $this->driver_name->DbValue = $row['driver_name'];
        $this->agent->DbValue = $row['agent'];
        $this->comm->DbValue = $row['comm'];
        $this->material->DbValue = $row['material'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->m_hsn->DbValue = $row['m_hsn'];
        $this->_40->DbValue = $row['@'];
        $this->lr_no->DbValue = $row['lr_no'];
        $this->km->DbValue = $row['km'];
        $this->freight_type->DbValue = $row['freight_type'];
        $this->freight->DbValue = $row['freight'];
        $this->ded_det->DbValue = $row['ded_det'];
        $this->ded_det_remarks->DbValue = $row['ded_det_remarks'];
        $this->gst_percent->DbValue = $row['gst_percent'];
        $this->gst_amount->DbValue = $row['gst_amount'];
        $this->final_amount->DbValue = $row['final_amount'];
        $this->load_km->DbValue = $row['load_km'];
        $this->unload_km->DbValue = $row['unload_km'];
        $this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
        $this->delivery_docket->DbValue = $row['delivery_docket'];
        $this->diesal_op_b->DbValue = $row['diesal_op_b'];
        $this->diesal_required->DbValue = $row['diesal_required'];
        $this->diesal_fill->DbValue = $row['diesal_fill'];
        $this->diesal_amount->DbValue = $row['diesal_amount'];
        $this->diesal_cl_balance->DbValue = $row['diesal_cl_balance'];
        $this->vehicle_average->DbValue = $row['vehicle_average'];
        $this->cash_required->DbValue = $row['cash_required'];
        $this->cash_op_b->DbValue = $row['cash_op_b'];
        $this->cash_paid->DbValue = $row['cash_paid'];
        $this->cash_expenses->DbValue = $row['cash_expenses'];
        $this->cash_cl_balance->DbValue = $row['cash_cl_balance'];
        $this->fasttag_op_b->DbValue = $row['fasttag_op_b'];
        $this->fasttag_recharge->DbValue = $row['fasttag_recharge'];
        $this->fasttag_expenses->DbValue = $row['fasttag_expenses'];
        $this->toll_expenses_cash->DbValue = $row['toll_expenses_cash'];
        $this->fasttag_cl_balance->DbValue = $row['fasttag_cl_balance'];
        $this->remarks->DbValue = $row['remarks'];
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->consignor->DbValue = $row['consignor'];
        $this->vehicle_freight_comm->DbValue = $row['vehicle_freight_comm'];
        $this->vehicle_freight_type->DbValue = $row['vehicle_freight_type'];
        $this->vehicle_freight_amount->DbValue = $row['vehicle_freight_amount'];
        $this->vehicle_freight_final->DbValue = $row['vehicle_freight_final'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->expenses_id->DbValue = $row['expenses_id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->delivery_receipt->OldUploadPath = $this->delivery_receipt->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['delivery_receipt']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['delivery_receipt']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->delivery_receipt->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->delivery_receipt->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['uploads']) ? [] : [$row['uploads']];
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("ttripinfolist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "ttripinfoview" => $Language->phrase("View"),
            "ttripinfoedit" => $Language->phrase("Edit"),
            "ttripinfoadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "ttripinfolist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "TTripInfoView",
            Config("API_ADD_ACTION") => "TTripInfoAdd",
            Config("API_EDIT_ACTION") => "TTripInfoEdit",
            Config("API_DELETE_ACTION") => "TTripInfoDelete",
            Config("API_LIST_ACTION") => "TTripInfoList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "ttripinfolist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ttripinfoview", $parm);
        } else {
            $url = $this->keyUrl("ttripinfoview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "ttripinfoadd?" . $parm;
        } else {
            $url = "ttripinfoadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ttripinfoedit", $parm);
        } else {
            $url = $this->keyUrl("ttripinfoedit", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("ttripinfolist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ttripinfoadd", $parm);
        } else {
            $url = $this->keyUrl("ttripinfoadd", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("ttripinfolist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("ttripinfodelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->vehicle_type->setDbValue($row['vehicle_type']);
        $this->vehicle->setDbValue($row['vehicle']);
        $this->_route->setDbValue($row['route']);
        $this->route_name->setDbValue($row['route_name']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->buyer->setDbValue($row['buyer']);
        $this->b_consignor->setDbValue($row['b_consignor']);
        $this->b_consignee->setDbValue($row['b_consignee']);
        $this->load_date->setDbValue($row['load_date']);
        $this->load_weight->setDbValue($row['load_weight']);
        $this->unload_date->setDbValue($row['unload_date']);
        $this->unload_weight->setDbValue($row['unload_weight']);
        $this->invoice_no->setDbValue($row['invoice_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->amount->setDbValue($row['amount']);
        $this->delivery_pod->setDbValue($row['delivery_pod']);
        $this->status->setDbValue($row['status']);
        $this->days->setDbValue($row['days']);
        $this->driver->setDbValue($row['driver']);
        $this->driver_name->setDbValue($row['driver_name']);
        $this->agent->setDbValue($row['agent']);
        $this->comm->setDbValue($row['comm']);
        $this->material->setDbValue($row['material']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->m_hsn->setDbValue($row['m_hsn']);
        $this->_40->setDbValue($row['@']);
        $this->lr_no->setDbValue($row['lr_no']);
        $this->km->setDbValue($row['km']);
        $this->freight_type->setDbValue($row['freight_type']);
        $this->freight->setDbValue($row['freight']);
        $this->ded_det->setDbValue($row['ded_det']);
        $this->ded_det_remarks->setDbValue($row['ded_det_remarks']);
        $this->gst_percent->setDbValue($row['gst_percent']);
        $this->gst_amount->setDbValue($row['gst_amount']);
        $this->final_amount->setDbValue($row['final_amount']);
        $this->load_km->setDbValue($row['load_km']);
        $this->unload_km->setDbValue($row['unload_km']);
        $this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
        $this->delivery_docket->setDbValue($row['delivery_docket']);
        $this->diesal_op_b->setDbValue($row['diesal_op_b']);
        $this->diesal_required->setDbValue($row['diesal_required']);
        $this->diesal_fill->setDbValue($row['diesal_fill']);
        $this->diesal_amount->setDbValue($row['diesal_amount']);
        $this->diesal_cl_balance->setDbValue($row['diesal_cl_balance']);
        $this->vehicle_average->setDbValue($row['vehicle_average']);
        $this->cash_required->setDbValue($row['cash_required']);
        $this->cash_op_b->setDbValue($row['cash_op_b']);
        $this->cash_paid->setDbValue($row['cash_paid']);
        $this->cash_expenses->setDbValue($row['cash_expenses']);
        $this->cash_cl_balance->setDbValue($row['cash_cl_balance']);
        $this->fasttag_op_b->setDbValue($row['fasttag_op_b']);
        $this->fasttag_recharge->setDbValue($row['fasttag_recharge']);
        $this->fasttag_expenses->setDbValue($row['fasttag_expenses']);
        $this->toll_expenses_cash->setDbValue($row['toll_expenses_cash']);
        $this->fasttag_cl_balance->setDbValue($row['fasttag_cl_balance']);
        $this->remarks->setDbValue($row['remarks']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->consignor->setDbValue($row['consignor']);
        $this->vehicle_freight_comm->setDbValue($row['vehicle_freight_comm']);
        $this->vehicle_freight_type->setDbValue($row['vehicle_freight_type']);
        $this->vehicle_freight_amount->setDbValue($row['vehicle_freight_amount']);
        $this->vehicle_freight_final->setDbValue($row['vehicle_freight_final']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->expenses_id->setDbValue($row['expenses_id']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "TTripInfoList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // vehicle_type

        // vehicle

        // route

        // route_name

        // reports_to

        // buyer

        // b_consignor

        // b_consignee

        // load_date

        // load_weight

        // unload_date

        // unload_weight

        // invoice_no

        // invoice_date

        // amount

        // delivery_pod

        // status

        // days

        // driver

        // driver_name

        // agent

        // comm

        // material

        // packing_type

        // m_hsn

        // @

        // lr_no

        // km

        // freight_type

        // freight

        // ded_det

        // ded_det_remarks

        // gst_percent

        // gst_amount

        // final_amount

        // load_km

        // unload_km

        // delivery_receipt

        // delivery_docket

        // diesal_op_b

        // diesal_required

        // diesal_fill

        // diesal_amount

        // diesal_cl_balance

        // vehicle_average

        // cash_required

        // cash_op_b

        // cash_paid

        // cash_expenses

        // cash_cl_balance

        // fasttag_op_b

        // fasttag_recharge

        // fasttag_expenses

        // toll_expenses_cash

        // fasttag_cl_balance

        // remarks

        // uploads

        // consignor

        // vehicle_freight_comm

        // vehicle_freight_type

        // vehicle_freight_amount

        // vehicle_freight_final

        // operator

        // datetime

        // expenses_id
        $this->expenses_id->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // vehicle_type
        if (strval($this->vehicle_type->CurrentValue) != "") {
            $this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
        } else {
            $this->vehicle_type->ViewValue = null;
        }

        // vehicle
        $this->vehicle->ViewValue = $this->vehicle->CurrentValue;
        $curVal = strval($this->vehicle->CurrentValue);
        if ($curVal != "") {
            $this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
            if ($this->vehicle->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                    $this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
                } else {
                    $this->vehicle->ViewValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                }
            }
        } else {
            $this->vehicle->ViewValue = null;
        }

        // route
        $this->_route->ViewValue = $this->_route->CurrentValue;
        $curVal = strval($this->_route->CurrentValue);
        if ($curVal != "") {
            $this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
            if ($this->_route->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->_route->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_route->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->_route->getSelectFilter($this); // PHP
                $sqlWrk = $this->_route->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->_route->Lookup->renderViewRow($rswrk[0]);
                    $this->_route->ViewValue = $this->_route->displayValue($arwrk);
                } else {
                    $this->_route->ViewValue = FormatNumber($this->_route->CurrentValue, $this->_route->formatPattern());
                }
            }
        } else {
            $this->_route->ViewValue = null;
        }

        // route_name
        $this->route_name->ViewValue = $this->route_name->CurrentValue;

        // reports_to
        $curVal = strval($this->reports_to->CurrentValue);
        if ($curVal != "") {
            $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            if ($this->reports_to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                    $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                } else {
                    $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                }
            }
        } else {
            $this->reports_to->ViewValue = null;
        }

        // buyer
        $this->buyer->ViewValue = $this->buyer->CurrentValue;
        $curVal = strval($this->buyer->CurrentValue);
        if ($curVal != "") {
            $this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
            if ($this->buyer->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
                } else {
                    $this->buyer->ViewValue = FormatNumber($this->buyer->CurrentValue, $this->buyer->formatPattern());
                }
            }
        } else {
            $this->buyer->ViewValue = null;
        }

        // b_consignor
        $this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
        $curVal = strval($this->b_consignor->CurrentValue);
        if ($curVal != "") {
            $this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
            if ($this->b_consignor->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->b_consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->b_consignor->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->b_consignor->Lookup->renderViewRow($rswrk[0]);
                    $this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
                } else {
                    $this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
                }
            }
        } else {
            $this->b_consignor->ViewValue = null;
        }

        // b_consignee
        $this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
        $curVal = strval($this->b_consignee->CurrentValue);
        if ($curVal != "") {
            $this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
            if ($this->b_consignee->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->b_consignee->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->b_consignee->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->b_consignee->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_consignee->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->b_consignee->Lookup->renderViewRow($rswrk[0]);
                    $this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
                } else {
                    $this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
                }
            }
        } else {
            $this->b_consignee->ViewValue = null;
        }

        // load_date
        $this->load_date->ViewValue = $this->load_date->CurrentValue;
        $this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, $this->load_date->formatPattern());

        // load_weight
        $this->load_weight->ViewValue = $this->load_weight->CurrentValue;
        $this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, $this->load_weight->formatPattern());

        // unload_date
        $this->unload_date->ViewValue = $this->unload_date->CurrentValue;
        $this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, $this->unload_date->formatPattern());

        // unload_weight
        $this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
        $this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, $this->unload_weight->formatPattern());

        // invoice_no
        $this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
        $this->invoice_no->ViewValue = FormatNumber($this->invoice_no->ViewValue, $this->invoice_no->formatPattern());

        // invoice_date
        $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
        $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;
        $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

        // delivery_pod
        if (strval($this->delivery_pod->CurrentValue) != "") {
            $this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
        } else {
            $this->delivery_pod->ViewValue = null;
        }

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // days
        $this->days->ViewValue = $this->days->CurrentValue;
        $this->days->ViewValue = FormatNumber($this->days->ViewValue, $this->days->formatPattern());

        // driver
        $curVal = strval($this->driver->CurrentValue);
        if ($curVal != "") {
            $this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
            if ($this->driver->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->driver->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->driver->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->driver->getSelectFilter($this); // PHP
                $sqlWrk = $this->driver->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->driver->Lookup->renderViewRow($rswrk[0]);
                    $this->driver->ViewValue = $this->driver->displayValue($arwrk);
                } else {
                    $this->driver->ViewValue = $this->driver->CurrentValue;
                }
            }
        } else {
            $this->driver->ViewValue = null;
        }

        // driver_name
        $this->driver_name->ViewValue = $this->driver_name->CurrentValue;

        // agent
        $this->agent->ViewValue = $this->agent->CurrentValue;
        $curVal = strval($this->agent->CurrentValue);
        if ($curVal != "") {
            $this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
            if ($this->agent->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->agent->Lookup->renderViewRow($rswrk[0]);
                    $this->agent->ViewValue = $this->agent->displayValue($arwrk);
                } else {
                    $this->agent->ViewValue = FormatNumber($this->agent->CurrentValue, $this->agent->formatPattern());
                }
            }
        } else {
            $this->agent->ViewValue = null;
        }

        // comm
        $this->comm->ViewValue = $this->comm->CurrentValue;
        $this->comm->ViewValue = FormatNumber($this->comm->ViewValue, $this->comm->formatPattern());

        // material
        $this->material->ViewValue = $this->material->CurrentValue;

        // packing_type
        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;

        // m_hsn
        $this->m_hsn->ViewValue = $this->m_hsn->CurrentValue;

        // @
        $this->_40->ViewValue = $this->_40->CurrentValue;
        $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

        // lr_no
        $this->lr_no->ViewValue = $this->lr_no->CurrentValue;

        // km
        $this->km->ViewValue = $this->km->CurrentValue;
        $this->km->ViewValue = FormatNumber($this->km->ViewValue, $this->km->formatPattern());

        // freight_type
        if (strval($this->freight_type->CurrentValue) != "") {
            $this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
        } else {
            $this->freight_type->ViewValue = null;
        }

        // freight
        $this->freight->ViewValue = $this->freight->CurrentValue;
        $this->freight->ViewValue = FormatNumber($this->freight->ViewValue, $this->freight->formatPattern());

        // ded_det
        $this->ded_det->ViewValue = $this->ded_det->CurrentValue;
        $this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, $this->ded_det->formatPattern());

        // ded_det_remarks
        $this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;

        // gst_percent
        $this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
        $this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, $this->gst_percent->formatPattern());

        // gst_amount
        $this->gst_amount->ViewValue = $this->gst_amount->CurrentValue;
        $this->gst_amount->ViewValue = FormatNumber($this->gst_amount->ViewValue, $this->gst_amount->formatPattern());

        // final_amount
        $this->final_amount->ViewValue = $this->final_amount->CurrentValue;
        $this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, $this->final_amount->formatPattern());

        // load_km
        $this->load_km->ViewValue = $this->load_km->CurrentValue;
        $this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, $this->load_km->formatPattern());

        // unload_km
        $this->unload_km->ViewValue = $this->unload_km->CurrentValue;
        $this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, $this->unload_km->formatPattern());

        // delivery_receipt
        $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
        if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
            $this->delivery_receipt->ImageWidth = 0;
            $this->delivery_receipt->ImageHeight = 50;
            $this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
            $this->delivery_receipt->ImageCssClass = "ew-image";
            $this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
        } else {
            $this->delivery_receipt->ViewValue = "";
        }

        // delivery_docket
        $this->delivery_docket->ViewValue = $this->delivery_docket->CurrentValue;

        // diesal_op_b
        $this->diesal_op_b->ViewValue = $this->diesal_op_b->CurrentValue;
        $this->diesal_op_b->ViewValue = FormatNumber($this->diesal_op_b->ViewValue, $this->diesal_op_b->formatPattern());

        // diesal_required
        $this->diesal_required->ViewValue = $this->diesal_required->CurrentValue;
        $this->diesal_required->ViewValue = FormatNumber($this->diesal_required->ViewValue, $this->diesal_required->formatPattern());

        // diesal_fill
        $this->diesal_fill->ViewValue = $this->diesal_fill->CurrentValue;
        $this->diesal_fill->ViewValue = FormatNumber($this->diesal_fill->ViewValue, $this->diesal_fill->formatPattern());

        // diesal_amount
        $this->diesal_amount->ViewValue = $this->diesal_amount->CurrentValue;
        $this->diesal_amount->ViewValue = FormatNumber($this->diesal_amount->ViewValue, $this->diesal_amount->formatPattern());

        // diesal_cl_balance
        $this->diesal_cl_balance->ViewValue = $this->diesal_cl_balance->CurrentValue;
        $this->diesal_cl_balance->ViewValue = FormatNumber($this->diesal_cl_balance->ViewValue, $this->diesal_cl_balance->formatPattern());

        // vehicle_average
        $this->vehicle_average->ViewValue = $this->vehicle_average->CurrentValue;
        $this->vehicle_average->ViewValue = FormatNumber($this->vehicle_average->ViewValue, $this->vehicle_average->formatPattern());

        // cash_required
        $this->cash_required->ViewValue = $this->cash_required->CurrentValue;
        $this->cash_required->ViewValue = FormatNumber($this->cash_required->ViewValue, $this->cash_required->formatPattern());

        // cash_op_b
        $this->cash_op_b->ViewValue = $this->cash_op_b->CurrentValue;
        $this->cash_op_b->ViewValue = FormatNumber($this->cash_op_b->ViewValue, $this->cash_op_b->formatPattern());

        // cash_paid
        $this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
        $this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, $this->cash_paid->formatPattern());

        // cash_expenses
        $this->cash_expenses->ViewValue = $this->cash_expenses->CurrentValue;
        $this->cash_expenses->ViewValue = FormatNumber($this->cash_expenses->ViewValue, $this->cash_expenses->formatPattern());

        // cash_cl_balance
        $this->cash_cl_balance->ViewValue = $this->cash_cl_balance->CurrentValue;
        $this->cash_cl_balance->ViewValue = FormatNumber($this->cash_cl_balance->ViewValue, $this->cash_cl_balance->formatPattern());

        // fasttag_op_b
        $this->fasttag_op_b->ViewValue = $this->fasttag_op_b->CurrentValue;
        $this->fasttag_op_b->ViewValue = FormatNumber($this->fasttag_op_b->ViewValue, $this->fasttag_op_b->formatPattern());

        // fasttag_recharge
        $this->fasttag_recharge->ViewValue = $this->fasttag_recharge->CurrentValue;
        $this->fasttag_recharge->ViewValue = FormatNumber($this->fasttag_recharge->ViewValue, $this->fasttag_recharge->formatPattern());

        // fasttag_expenses
        $this->fasttag_expenses->ViewValue = $this->fasttag_expenses->CurrentValue;
        $this->fasttag_expenses->ViewValue = FormatNumber($this->fasttag_expenses->ViewValue, $this->fasttag_expenses->formatPattern());

        // toll_expenses_cash
        $this->toll_expenses_cash->ViewValue = $this->toll_expenses_cash->CurrentValue;
        $this->toll_expenses_cash->ViewValue = FormatNumber($this->toll_expenses_cash->ViewValue, $this->toll_expenses_cash->formatPattern());

        // fasttag_cl_balance
        $this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
        $this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, $this->fasttag_cl_balance->formatPattern());

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // uploads
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->ViewValue = "";
        }

        // consignor
        $this->consignor->ViewValue = $this->consignor->CurrentValue;
        $curVal = strval($this->consignor->CurrentValue);
        if ($curVal != "") {
            $this->consignor->ViewValue = $this->consignor->lookupCacheOption($curVal);
            if ($this->consignor->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->consignor->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->consignor->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->consignor->getSelectFilter($this); // PHP
                $sqlWrk = $this->consignor->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->consignor->Lookup->renderViewRow($rswrk[0]);
                    $this->consignor->ViewValue = $this->consignor->displayValue($arwrk);
                } else {
                    $this->consignor->ViewValue = FormatNumber($this->consignor->CurrentValue, $this->consignor->formatPattern());
                }
            }
        } else {
            $this->consignor->ViewValue = null;
        }

        // vehicle_freight_comm
        $this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
        $this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, $this->vehicle_freight_comm->formatPattern());

        // vehicle_freight_type
        if (strval($this->vehicle_freight_type->CurrentValue) != "") {
            $this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
        } else {
            $this->vehicle_freight_type->ViewValue = null;
        }

        // vehicle_freight_amount
        $this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
        $this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, $this->vehicle_freight_amount->formatPattern());

        // vehicle_freight_final
        $this->vehicle_freight_final->ViewValue = $this->vehicle_freight_final->CurrentValue;
        $this->vehicle_freight_final->ViewValue = FormatNumber($this->vehicle_freight_final->ViewValue, $this->vehicle_freight_final->formatPattern());

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // expenses_id
        $this->expenses_id->ViewValue = $this->expenses_id->CurrentValue;
        $this->expenses_id->ViewValue = FormatNumber($this->expenses_id->ViewValue, $this->expenses_id->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // vehicle_type
        $this->vehicle_type->HrefValue = "";
        $this->vehicle_type->TooltipValue = "";

        // vehicle
        $this->vehicle->HrefValue = "";
        $this->vehicle->TooltipValue = "";

        // route
        $this->_route->HrefValue = "";
        $this->_route->TooltipValue = "";

        // route_name
        $this->route_name->HrefValue = "";
        $this->route_name->TooltipValue = "";

        // reports_to
        $this->reports_to->HrefValue = "";
        $this->reports_to->TooltipValue = "";

        // buyer
        $this->buyer->HrefValue = "";
        $this->buyer->TooltipValue = "";

        // b_consignor
        $this->b_consignor->HrefValue = "";
        $this->b_consignor->TooltipValue = "";

        // b_consignee
        $this->b_consignee->HrefValue = "";
        $this->b_consignee->TooltipValue = "";

        // load_date
        $this->load_date->HrefValue = "";
        $this->load_date->TooltipValue = "";

        // load_weight
        $this->load_weight->HrefValue = "";
        $this->load_weight->TooltipValue = "";

        // unload_date
        $this->unload_date->HrefValue = "";
        $this->unload_date->TooltipValue = "";

        // unload_weight
        $this->unload_weight->HrefValue = "";
        $this->unload_weight->TooltipValue = "";

        // invoice_no
        $this->invoice_no->HrefValue = "";
        $this->invoice_no->TooltipValue = "";

        // invoice_date
        $this->invoice_date->HrefValue = "";
        $this->invoice_date->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // delivery_pod
        $this->delivery_pod->HrefValue = "";
        $this->delivery_pod->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // days
        $this->days->HrefValue = "";
        $this->days->TooltipValue = "";

        // driver
        $this->driver->HrefValue = "";
        $this->driver->TooltipValue = "";

        // driver_name
        $this->driver_name->HrefValue = "";
        $this->driver_name->TooltipValue = "";

        // agent
        $this->agent->HrefValue = "";
        $this->agent->TooltipValue = "";

        // comm
        $this->comm->HrefValue = "";
        $this->comm->TooltipValue = "";

        // material
        $this->material->HrefValue = "";
        $this->material->TooltipValue = "";

        // packing_type
        $this->packing_type->HrefValue = "";
        $this->packing_type->TooltipValue = "";

        // m_hsn
        $this->m_hsn->HrefValue = "";
        $this->m_hsn->TooltipValue = "";

        // @
        $this->_40->HrefValue = "";
        $this->_40->TooltipValue = "";

        // lr_no
        $this->lr_no->HrefValue = "";
        $this->lr_no->TooltipValue = "";

        // km
        $this->km->HrefValue = "";
        $this->km->TooltipValue = "";

        // freight_type
        $this->freight_type->HrefValue = "";
        $this->freight_type->TooltipValue = "";

        // freight
        $this->freight->HrefValue = "";
        $this->freight->TooltipValue = "";

        // ded_det
        $this->ded_det->HrefValue = "";
        $this->ded_det->TooltipValue = "";

        // ded_det_remarks
        $this->ded_det_remarks->HrefValue = "";
        $this->ded_det_remarks->TooltipValue = "";

        // gst_percent
        $this->gst_percent->HrefValue = "";
        $this->gst_percent->TooltipValue = "";

        // gst_amount
        $this->gst_amount->HrefValue = "";
        $this->gst_amount->TooltipValue = "";

        // final_amount
        $this->final_amount->HrefValue = "";
        $this->final_amount->TooltipValue = "";

        // load_km
        $this->load_km->HrefValue = "";
        $this->load_km->TooltipValue = "";

        // unload_km
        $this->unload_km->HrefValue = "";
        $this->unload_km->TooltipValue = "";

        // delivery_receipt
        $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
        if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
            $this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
            $this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
            }
        } else {
            $this->delivery_receipt->HrefValue = "";
        }
        $this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;
        $this->delivery_receipt->TooltipValue = "";
        if ($this->delivery_receipt->UseColorbox) {
            if (EmptyValue($this->delivery_receipt->TooltipValue)) {
                $this->delivery_receipt->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->delivery_receipt->LinkAttrs["data-rel"] = "t_trip_info_x_delivery_receipt";
            $this->delivery_receipt->LinkAttrs->appendClass("ew-lightbox");
        }

        // delivery_docket
        $this->delivery_docket->HrefValue = "";
        $this->delivery_docket->TooltipValue = "";

        // diesal_op_b
        $this->diesal_op_b->HrefValue = "";
        $this->diesal_op_b->TooltipValue = "";

        // diesal_required
        $this->diesal_required->HrefValue = "";
        $this->diesal_required->TooltipValue = "";

        // diesal_fill
        $this->diesal_fill->HrefValue = "";
        $this->diesal_fill->TooltipValue = "";

        // diesal_amount
        $this->diesal_amount->HrefValue = "";
        $this->diesal_amount->TooltipValue = "";

        // diesal_cl_balance
        $this->diesal_cl_balance->HrefValue = "";
        $this->diesal_cl_balance->TooltipValue = "";

        // vehicle_average
        $this->vehicle_average->HrefValue = "";
        $this->vehicle_average->TooltipValue = "";

        // cash_required
        $this->cash_required->HrefValue = "";
        $this->cash_required->TooltipValue = "";

        // cash_op_b
        $this->cash_op_b->HrefValue = "";
        $this->cash_op_b->TooltipValue = "";

        // cash_paid
        $this->cash_paid->HrefValue = "";
        $this->cash_paid->TooltipValue = "";

        // cash_expenses
        $this->cash_expenses->HrefValue = "";
        $this->cash_expenses->TooltipValue = "";

        // cash_cl_balance
        $this->cash_cl_balance->HrefValue = "";
        $this->cash_cl_balance->TooltipValue = "";

        // fasttag_op_b
        $this->fasttag_op_b->HrefValue = "";
        $this->fasttag_op_b->TooltipValue = "";

        // fasttag_recharge
        $this->fasttag_recharge->HrefValue = "";
        $this->fasttag_recharge->TooltipValue = "";

        // fasttag_expenses
        $this->fasttag_expenses->HrefValue = "";
        $this->fasttag_expenses->TooltipValue = "";

        // toll_expenses_cash
        $this->toll_expenses_cash->HrefValue = "";
        $this->toll_expenses_cash->TooltipValue = "";

        // fasttag_cl_balance
        $this->fasttag_cl_balance->HrefValue = "";
        $this->fasttag_cl_balance->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // uploads
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->htmlDecode($this->uploads->Upload->DbValue)); // Add prefix/suffix
            $this->uploads->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
            }
        } else {
            $this->uploads->HrefValue = "";
        }
        $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
        $this->uploads->TooltipValue = "";
        if ($this->uploads->UseColorbox) {
            if (EmptyValue($this->uploads->TooltipValue)) {
                $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->uploads->LinkAttrs["data-rel"] = "t_trip_info_x_uploads";
            $this->uploads->LinkAttrs->appendClass("ew-lightbox");
        }

        // consignor
        $this->consignor->HrefValue = "";
        $this->consignor->TooltipValue = "";

        // vehicle_freight_comm
        $this->vehicle_freight_comm->HrefValue = "";
        $this->vehicle_freight_comm->TooltipValue = "";

        // vehicle_freight_type
        $this->vehicle_freight_type->HrefValue = "";
        $this->vehicle_freight_type->TooltipValue = "";

        // vehicle_freight_amount
        $this->vehicle_freight_amount->HrefValue = "";
        $this->vehicle_freight_amount->TooltipValue = "";

        // vehicle_freight_final
        $this->vehicle_freight_final->HrefValue = "";
        $this->vehicle_freight_final->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // expenses_id
        $this->expenses_id->HrefValue = "";
        $this->expenses_id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // vehicle_type
        $this->vehicle_type->setupEditAttributes();
        $this->vehicle_type->EditValue = $this->vehicle_type->options(true);
        $this->vehicle_type->PlaceHolder = RemoveHtml($this->vehicle_type->caption());

        // vehicle
        $this->vehicle->setupEditAttributes();
        $this->vehicle->EditValue = $this->vehicle->CurrentValue;
        $curVal = strval($this->vehicle->CurrentValue);
        if ($curVal != "") {
            $this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
            if ($this->vehicle->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->vehicle->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->vehicle->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->vehicle->getSelectFilter($this); // PHP
                $sqlWrk = $this->vehicle->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->vehicle->Lookup->renderViewRow($rswrk[0]);
                    $this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
                } else {
                    $this->vehicle->EditValue = FormatNumber($this->vehicle->CurrentValue, $this->vehicle->formatPattern());
                }
            }
        } else {
            $this->vehicle->EditValue = null;
        }

        // route
        $this->_route->setupEditAttributes();
        $this->_route->EditValue = $this->_route->CurrentValue;
        $this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

        // route_name
        $this->route_name->setupEditAttributes();
        $this->route_name->EditValue = $this->route_name->CurrentValue;

        // reports_to
        $this->reports_to->setupEditAttributes();
        $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

        // buyer
        $this->buyer->setupEditAttributes();
        $this->buyer->EditValue = $this->buyer->CurrentValue;
        $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

        // b_consignor
        $this->b_consignor->setupEditAttributes();
        $this->b_consignor->EditValue = $this->b_consignor->CurrentValue;
        $this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());

        // b_consignee
        $this->b_consignee->setupEditAttributes();
        $this->b_consignee->EditValue = $this->b_consignee->CurrentValue;
        $this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());

        // load_date
        $this->load_date->setupEditAttributes();
        $this->load_date->EditValue = FormatDateTime($this->load_date->CurrentValue, $this->load_date->formatPattern());
        $this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

        // load_weight
        $this->load_weight->setupEditAttributes();
        $this->load_weight->EditValue = $this->load_weight->CurrentValue;
        $this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());
        if (strval($this->load_weight->EditValue) != "" && is_numeric($this->load_weight->EditValue)) {
            $this->load_weight->EditValue = FormatNumber($this->load_weight->EditValue, null);
        }

        // unload_date
        $this->unload_date->setupEditAttributes();
        $this->unload_date->EditValue = FormatDateTime($this->unload_date->CurrentValue, $this->unload_date->formatPattern());
        $this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

        // unload_weight
        $this->unload_weight->setupEditAttributes();
        $this->unload_weight->EditValue = $this->unload_weight->CurrentValue;
        $this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());
        if (strval($this->unload_weight->EditValue) != "" && is_numeric($this->unload_weight->EditValue)) {
            $this->unload_weight->EditValue = FormatNumber($this->unload_weight->EditValue, null);
        }

        // invoice_no
        $this->invoice_no->setupEditAttributes();
        $this->invoice_no->EditValue = $this->invoice_no->CurrentValue;
        $this->invoice_no->EditValue = FormatNumber($this->invoice_no->EditValue, $this->invoice_no->formatPattern());

        // invoice_date
        $this->invoice_date->setupEditAttributes();
        $this->invoice_date->EditValue = $this->invoice_date->CurrentValue;
        $this->invoice_date->EditValue = FormatDateTime($this->invoice_date->EditValue, $this->invoice_date->formatPattern());

        // amount
        $this->amount->setupEditAttributes();
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->EditValue = FormatNumber($this->amount->EditValue, $this->amount->formatPattern());

        // delivery_pod
        $this->delivery_pod->EditValue = $this->delivery_pod->options(false);
        $this->delivery_pod->PlaceHolder = RemoveHtml($this->delivery_pod->caption());

        // status
        $this->status->setupEditAttributes();
        if (strval($this->status->CurrentValue) != "") {
            $this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->EditValue = null;
        }

        // days
        $this->days->setupEditAttributes();
        $this->days->EditValue = $this->days->CurrentValue;
        $this->days->EditValue = FormatNumber($this->days->EditValue, $this->days->formatPattern());

        // driver
        $this->driver->setupEditAttributes();
        $this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

        // driver_name
        $this->driver_name->setupEditAttributes();
        if (!$this->driver_name->Raw) {
            $this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
        }
        $this->driver_name->EditValue = $this->driver_name->CurrentValue;
        $this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

        // agent
        $this->agent->setupEditAttributes();
        $this->agent->EditValue = $this->agent->CurrentValue;
        $this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

        // comm
        $this->comm->setupEditAttributes();
        $this->comm->EditValue = $this->comm->CurrentValue;
        $this->comm->PlaceHolder = RemoveHtml($this->comm->caption());
        if (strval($this->comm->EditValue) != "" && is_numeric($this->comm->EditValue)) {
            $this->comm->EditValue = FormatNumber($this->comm->EditValue, null);
        }

        // material
        $this->material->setupEditAttributes();
        if (!$this->material->Raw) {
            $this->material->CurrentValue = HtmlDecode($this->material->CurrentValue);
        }
        $this->material->EditValue = $this->material->CurrentValue;
        $this->material->PlaceHolder = RemoveHtml($this->material->caption());

        // packing_type
        $this->packing_type->setupEditAttributes();
        if (!$this->packing_type->Raw) {
            $this->packing_type->CurrentValue = HtmlDecode($this->packing_type->CurrentValue);
        }
        $this->packing_type->EditValue = $this->packing_type->CurrentValue;
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

        // m_hsn
        $this->m_hsn->setupEditAttributes();
        if (!$this->m_hsn->Raw) {
            $this->m_hsn->CurrentValue = HtmlDecode($this->m_hsn->CurrentValue);
        }
        $this->m_hsn->EditValue = $this->m_hsn->CurrentValue;
        $this->m_hsn->PlaceHolder = RemoveHtml($this->m_hsn->caption());

        // @
        $this->_40->setupEditAttributes();
        $this->_40->EditValue = $this->_40->CurrentValue;
        $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
        if (strval($this->_40->EditValue) != "" && is_numeric($this->_40->EditValue)) {
            $this->_40->EditValue = FormatNumber($this->_40->EditValue, null);
        }

        // lr_no
        $this->lr_no->setupEditAttributes();
        if (!$this->lr_no->Raw) {
            $this->lr_no->CurrentValue = HtmlDecode($this->lr_no->CurrentValue);
        }
        $this->lr_no->EditValue = $this->lr_no->CurrentValue;
        $this->lr_no->PlaceHolder = RemoveHtml($this->lr_no->caption());

        // km
        $this->km->setupEditAttributes();
        $this->km->EditValue = $this->km->CurrentValue;
        $this->km->PlaceHolder = RemoveHtml($this->km->caption());
        if (strval($this->km->EditValue) != "" && is_numeric($this->km->EditValue)) {
            $this->km->EditValue = FormatNumber($this->km->EditValue, null);
        }

        // freight_type
        $this->freight_type->setupEditAttributes();
        $this->freight_type->EditValue = $this->freight_type->options(true);
        $this->freight_type->PlaceHolder = RemoveHtml($this->freight_type->caption());

        // freight
        $this->freight->setupEditAttributes();
        $this->freight->EditValue = $this->freight->CurrentValue;
        $this->freight->PlaceHolder = RemoveHtml($this->freight->caption());
        if (strval($this->freight->EditValue) != "" && is_numeric($this->freight->EditValue)) {
            $this->freight->EditValue = FormatNumber($this->freight->EditValue, null);
        }

        // ded_det
        $this->ded_det->setupEditAttributes();
        $this->ded_det->EditValue = $this->ded_det->CurrentValue;
        $this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());
        if (strval($this->ded_det->EditValue) != "" && is_numeric($this->ded_det->EditValue)) {
            $this->ded_det->EditValue = FormatNumber($this->ded_det->EditValue, null);
        }

        // ded_det_remarks
        $this->ded_det_remarks->setupEditAttributes();
        if (!$this->ded_det_remarks->Raw) {
            $this->ded_det_remarks->CurrentValue = HtmlDecode($this->ded_det_remarks->CurrentValue);
        }
        $this->ded_det_remarks->EditValue = $this->ded_det_remarks->CurrentValue;
        $this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

        // gst_percent
        $this->gst_percent->setupEditAttributes();
        $this->gst_percent->EditValue = $this->gst_percent->CurrentValue;
        $this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());
        if (strval($this->gst_percent->EditValue) != "" && is_numeric($this->gst_percent->EditValue)) {
            $this->gst_percent->EditValue = FormatNumber($this->gst_percent->EditValue, null);
        }

        // gst_amount
        $this->gst_amount->setupEditAttributes();
        $this->gst_amount->EditValue = $this->gst_amount->CurrentValue;
        $this->gst_amount->EditValue = FormatNumber($this->gst_amount->EditValue, $this->gst_amount->formatPattern());

        // final_amount
        $this->final_amount->setupEditAttributes();
        $this->final_amount->EditValue = $this->final_amount->CurrentValue;
        $this->final_amount->EditValue = FormatNumber($this->final_amount->EditValue, $this->final_amount->formatPattern());

        // load_km
        $this->load_km->setupEditAttributes();
        $this->load_km->EditValue = $this->load_km->CurrentValue;
        $this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());
        if (strval($this->load_km->EditValue) != "" && is_numeric($this->load_km->EditValue)) {
            $this->load_km->EditValue = FormatNumber($this->load_km->EditValue, null);
        }

        // unload_km
        $this->unload_km->setupEditAttributes();
        $this->unload_km->EditValue = $this->unload_km->CurrentValue;
        $this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());
        if (strval($this->unload_km->EditValue) != "" && is_numeric($this->unload_km->EditValue)) {
            $this->unload_km->EditValue = FormatNumber($this->unload_km->EditValue, null);
        }

        // delivery_receipt
        $this->delivery_receipt->setupEditAttributes();
        $this->delivery_receipt->UploadPath = $this->delivery_receipt->getUploadPath(); // PHP
        if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
            $this->delivery_receipt->ImageWidth = 0;
            $this->delivery_receipt->ImageHeight = 50;
            $this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
            $this->delivery_receipt->ImageCssClass = "ew-image";
            $this->delivery_receipt->EditValue = $this->delivery_receipt->Upload->DbValue;
        } else {
            $this->delivery_receipt->EditValue = "";
        }
        if (!EmptyValue($this->delivery_receipt->CurrentValue)) {
            $this->delivery_receipt->Upload->FileName = $this->delivery_receipt->CurrentValue;
        }

        // delivery_docket
        $this->delivery_docket->setupEditAttributes();
        if (!$this->delivery_docket->Raw) {
            $this->delivery_docket->CurrentValue = HtmlDecode($this->delivery_docket->CurrentValue);
        }
        $this->delivery_docket->EditValue = $this->delivery_docket->CurrentValue;
        $this->delivery_docket->PlaceHolder = RemoveHtml($this->delivery_docket->caption());

        // diesal_op_b
        $this->diesal_op_b->setupEditAttributes();
        $this->diesal_op_b->EditValue = $this->diesal_op_b->CurrentValue;
        $this->diesal_op_b->EditValue = FormatNumber($this->diesal_op_b->EditValue, $this->diesal_op_b->formatPattern());

        // diesal_required
        $this->diesal_required->setupEditAttributes();
        $this->diesal_required->EditValue = $this->diesal_required->CurrentValue;
        $this->diesal_required->EditValue = FormatNumber($this->diesal_required->EditValue, $this->diesal_required->formatPattern());

        // diesal_fill
        $this->diesal_fill->setupEditAttributes();
        $this->diesal_fill->EditValue = $this->diesal_fill->CurrentValue;
        $this->diesal_fill->EditValue = FormatNumber($this->diesal_fill->EditValue, $this->diesal_fill->formatPattern());

        // diesal_amount
        $this->diesal_amount->setupEditAttributes();
        $this->diesal_amount->EditValue = $this->diesal_amount->CurrentValue;
        $this->diesal_amount->EditValue = FormatNumber($this->diesal_amount->EditValue, $this->diesal_amount->formatPattern());

        // diesal_cl_balance
        $this->diesal_cl_balance->setupEditAttributes();
        $this->diesal_cl_balance->EditValue = $this->diesal_cl_balance->CurrentValue;
        $this->diesal_cl_balance->EditValue = FormatNumber($this->diesal_cl_balance->EditValue, $this->diesal_cl_balance->formatPattern());

        // vehicle_average
        $this->vehicle_average->setupEditAttributes();
        $this->vehicle_average->EditValue = $this->vehicle_average->CurrentValue;
        $this->vehicle_average->EditValue = FormatNumber($this->vehicle_average->EditValue, $this->vehicle_average->formatPattern());

        // cash_required
        $this->cash_required->setupEditAttributes();
        $this->cash_required->EditValue = $this->cash_required->CurrentValue;
        $this->cash_required->EditValue = FormatNumber($this->cash_required->EditValue, $this->cash_required->formatPattern());

        // cash_op_b
        $this->cash_op_b->setupEditAttributes();
        $this->cash_op_b->EditValue = $this->cash_op_b->CurrentValue;
        $this->cash_op_b->EditValue = FormatNumber($this->cash_op_b->EditValue, $this->cash_op_b->formatPattern());

        // cash_paid
        $this->cash_paid->setupEditAttributes();
        $this->cash_paid->EditValue = $this->cash_paid->CurrentValue;
        $this->cash_paid->EditValue = FormatNumber($this->cash_paid->EditValue, $this->cash_paid->formatPattern());

        // cash_expenses
        $this->cash_expenses->setupEditAttributes();
        $this->cash_expenses->EditValue = $this->cash_expenses->CurrentValue;
        $this->cash_expenses->EditValue = FormatNumber($this->cash_expenses->EditValue, $this->cash_expenses->formatPattern());

        // cash_cl_balance
        $this->cash_cl_balance->setupEditAttributes();
        $this->cash_cl_balance->EditValue = $this->cash_cl_balance->CurrentValue;
        $this->cash_cl_balance->EditValue = FormatNumber($this->cash_cl_balance->EditValue, $this->cash_cl_balance->formatPattern());

        // fasttag_op_b
        $this->fasttag_op_b->setupEditAttributes();
        $this->fasttag_op_b->EditValue = $this->fasttag_op_b->CurrentValue;
        $this->fasttag_op_b->EditValue = FormatNumber($this->fasttag_op_b->EditValue, $this->fasttag_op_b->formatPattern());

        // fasttag_recharge
        $this->fasttag_recharge->setupEditAttributes();
        $this->fasttag_recharge->EditValue = $this->fasttag_recharge->CurrentValue;
        $this->fasttag_recharge->EditValue = FormatNumber($this->fasttag_recharge->EditValue, $this->fasttag_recharge->formatPattern());

        // fasttag_expenses
        $this->fasttag_expenses->setupEditAttributes();
        $this->fasttag_expenses->EditValue = $this->fasttag_expenses->CurrentValue;
        $this->fasttag_expenses->EditValue = FormatNumber($this->fasttag_expenses->EditValue, $this->fasttag_expenses->formatPattern());

        // toll_expenses_cash
        $this->toll_expenses_cash->setupEditAttributes();
        $this->toll_expenses_cash->EditValue = $this->toll_expenses_cash->CurrentValue;
        $this->toll_expenses_cash->EditValue = FormatNumber($this->toll_expenses_cash->EditValue, $this->toll_expenses_cash->formatPattern());

        // fasttag_cl_balance
        $this->fasttag_cl_balance->setupEditAttributes();
        $this->fasttag_cl_balance->EditValue = $this->fasttag_cl_balance->CurrentValue;
        $this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());
        if (strval($this->fasttag_cl_balance->EditValue) != "" && is_numeric($this->fasttag_cl_balance->EditValue)) {
            $this->fasttag_cl_balance->EditValue = FormatNumber($this->fasttag_cl_balance->EditValue, null);
        }

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // uploads
        $this->uploads->setupEditAttributes();
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->EditValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->EditValue = "";
        }
        if (!EmptyValue($this->uploads->CurrentValue)) {
            $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
        }

        // consignor
        $this->consignor->setupEditAttributes();
        $this->consignor->EditCustomAttributes = $this->consignor->getEditCustomAttributes(); // PHP
        $this->consignor->EditValue = $this->consignor->CurrentValue;
        $this->consignor->PlaceHolder = RemoveHtml($this->consignor->caption());

        // vehicle_freight_comm
        $this->vehicle_freight_comm->setupEditAttributes();
        $this->vehicle_freight_comm->EditValue = $this->vehicle_freight_comm->CurrentValue;
        $this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());
        if (strval($this->vehicle_freight_comm->EditValue) != "" && is_numeric($this->vehicle_freight_comm->EditValue)) {
            $this->vehicle_freight_comm->EditValue = FormatNumber($this->vehicle_freight_comm->EditValue, null);
        }

        // vehicle_freight_type
        $this->vehicle_freight_type->setupEditAttributes();
        $this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(true);
        $this->vehicle_freight_type->PlaceHolder = RemoveHtml($this->vehicle_freight_type->caption());

        // vehicle_freight_amount
        $this->vehicle_freight_amount->setupEditAttributes();
        $this->vehicle_freight_amount->EditValue = $this->vehicle_freight_amount->CurrentValue;
        $this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());
        if (strval($this->vehicle_freight_amount->EditValue) != "" && is_numeric($this->vehicle_freight_amount->EditValue)) {
            $this->vehicle_freight_amount->EditValue = FormatNumber($this->vehicle_freight_amount->EditValue, null);
        }

        // vehicle_freight_final
        $this->vehicle_freight_final->setupEditAttributes();
        $this->vehicle_freight_final->EditValue = $this->vehicle_freight_final->CurrentValue;
        $this->vehicle_freight_final->EditValue = FormatNumber($this->vehicle_freight_final->EditValue, $this->vehicle_freight_final->formatPattern());

        // operator

        // datetime

        // expenses_id
        $this->expenses_id->setupEditAttributes();
        $this->expenses_id->EditValue = $this->expenses_id->CurrentValue;
        $this->expenses_id->PlaceHolder = RemoveHtml($this->expenses_id->caption());
        if (strval($this->expenses_id->EditValue) != "" && is_numeric($this->expenses_id->EditValue)) {
            $this->expenses_id->EditValue = FormatNumber($this->expenses_id->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->vehicle_type);
                    $doc->exportCaption($this->vehicle);
                    $doc->exportCaption($this->_route);
                    $doc->exportCaption($this->route_name);
                    $doc->exportCaption($this->reports_to);
                    $doc->exportCaption($this->buyer);
                    $doc->exportCaption($this->b_consignor);
                    $doc->exportCaption($this->b_consignee);
                    $doc->exportCaption($this->load_date);
                    $doc->exportCaption($this->load_weight);
                    $doc->exportCaption($this->unload_date);
                    $doc->exportCaption($this->unload_weight);
                    $doc->exportCaption($this->invoice_no);
                    $doc->exportCaption($this->invoice_date);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->delivery_pod);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->days);
                    $doc->exportCaption($this->driver);
                    $doc->exportCaption($this->driver_name);
                    $doc->exportCaption($this->agent);
                    $doc->exportCaption($this->comm);
                    $doc->exportCaption($this->material);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->m_hsn);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->lr_no);
                    $doc->exportCaption($this->km);
                    $doc->exportCaption($this->freight_type);
                    $doc->exportCaption($this->freight);
                    $doc->exportCaption($this->ded_det);
                    $doc->exportCaption($this->ded_det_remarks);
                    $doc->exportCaption($this->gst_percent);
                    $doc->exportCaption($this->gst_amount);
                    $doc->exportCaption($this->final_amount);
                    $doc->exportCaption($this->load_km);
                    $doc->exportCaption($this->unload_km);
                    $doc->exportCaption($this->delivery_receipt);
                    $doc->exportCaption($this->delivery_docket);
                    $doc->exportCaption($this->diesal_op_b);
                    $doc->exportCaption($this->diesal_required);
                    $doc->exportCaption($this->diesal_fill);
                    $doc->exportCaption($this->diesal_amount);
                    $doc->exportCaption($this->diesal_cl_balance);
                    $doc->exportCaption($this->vehicle_average);
                    $doc->exportCaption($this->cash_required);
                    $doc->exportCaption($this->cash_op_b);
                    $doc->exportCaption($this->cash_paid);
                    $doc->exportCaption($this->cash_expenses);
                    $doc->exportCaption($this->cash_cl_balance);
                    $doc->exportCaption($this->fasttag_op_b);
                    $doc->exportCaption($this->fasttag_recharge);
                    $doc->exportCaption($this->fasttag_expenses);
                    $doc->exportCaption($this->toll_expenses_cash);
                    $doc->exportCaption($this->fasttag_cl_balance);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->uploads);
                    $doc->exportCaption($this->consignor);
                    $doc->exportCaption($this->vehicle_freight_comm);
                    $doc->exportCaption($this->vehicle_freight_type);
                    $doc->exportCaption($this->vehicle_freight_amount);
                    $doc->exportCaption($this->vehicle_freight_final);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->vehicle_type);
                    $doc->exportCaption($this->vehicle);
                    $doc->exportCaption($this->_route);
                    $doc->exportCaption($this->route_name);
                    $doc->exportCaption($this->reports_to);
                    $doc->exportCaption($this->buyer);
                    $doc->exportCaption($this->b_consignor);
                    $doc->exportCaption($this->b_consignee);
                    $doc->exportCaption($this->load_date);
                    $doc->exportCaption($this->load_weight);
                    $doc->exportCaption($this->unload_date);
                    $doc->exportCaption($this->unload_weight);
                    $doc->exportCaption($this->invoice_no);
                    $doc->exportCaption($this->invoice_date);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->delivery_pod);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->days);
                    $doc->exportCaption($this->driver);
                    $doc->exportCaption($this->driver_name);
                    $doc->exportCaption($this->agent);
                    $doc->exportCaption($this->comm);
                    $doc->exportCaption($this->material);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->m_hsn);
                    $doc->exportCaption($this->_40);
                    $doc->exportCaption($this->lr_no);
                    $doc->exportCaption($this->km);
                    $doc->exportCaption($this->freight_type);
                    $doc->exportCaption($this->freight);
                    $doc->exportCaption($this->ded_det);
                    $doc->exportCaption($this->ded_det_remarks);
                    $doc->exportCaption($this->gst_percent);
                    $doc->exportCaption($this->gst_amount);
                    $doc->exportCaption($this->final_amount);
                    $doc->exportCaption($this->load_km);
                    $doc->exportCaption($this->unload_km);
                    $doc->exportCaption($this->delivery_receipt);
                    $doc->exportCaption($this->delivery_docket);
                    $doc->exportCaption($this->diesal_op_b);
                    $doc->exportCaption($this->diesal_required);
                    $doc->exportCaption($this->diesal_fill);
                    $doc->exportCaption($this->diesal_amount);
                    $doc->exportCaption($this->diesal_cl_balance);
                    $doc->exportCaption($this->vehicle_average);
                    $doc->exportCaption($this->cash_required);
                    $doc->exportCaption($this->cash_op_b);
                    $doc->exportCaption($this->cash_paid);
                    $doc->exportCaption($this->cash_expenses);
                    $doc->exportCaption($this->cash_cl_balance);
                    $doc->exportCaption($this->fasttag_op_b);
                    $doc->exportCaption($this->fasttag_recharge);
                    $doc->exportCaption($this->fasttag_expenses);
                    $doc->exportCaption($this->toll_expenses_cash);
                    $doc->exportCaption($this->fasttag_cl_balance);
                    $doc->exportCaption($this->consignor);
                    $doc->exportCaption($this->vehicle_freight_comm);
                    $doc->exportCaption($this->vehicle_freight_type);
                    $doc->exportCaption($this->vehicle_freight_amount);
                    $doc->exportCaption($this->vehicle_freight_final);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->vehicle_type);
                        $doc->exportField($this->vehicle);
                        $doc->exportField($this->_route);
                        $doc->exportField($this->route_name);
                        $doc->exportField($this->reports_to);
                        $doc->exportField($this->buyer);
                        $doc->exportField($this->b_consignor);
                        $doc->exportField($this->b_consignee);
                        $doc->exportField($this->load_date);
                        $doc->exportField($this->load_weight);
                        $doc->exportField($this->unload_date);
                        $doc->exportField($this->unload_weight);
                        $doc->exportField($this->invoice_no);
                        $doc->exportField($this->invoice_date);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->delivery_pod);
                        $doc->exportField($this->status);
                        $doc->exportField($this->days);
                        $doc->exportField($this->driver);
                        $doc->exportField($this->driver_name);
                        $doc->exportField($this->agent);
                        $doc->exportField($this->comm);
                        $doc->exportField($this->material);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->m_hsn);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->lr_no);
                        $doc->exportField($this->km);
                        $doc->exportField($this->freight_type);
                        $doc->exportField($this->freight);
                        $doc->exportField($this->ded_det);
                        $doc->exportField($this->ded_det_remarks);
                        $doc->exportField($this->gst_percent);
                        $doc->exportField($this->gst_amount);
                        $doc->exportField($this->final_amount);
                        $doc->exportField($this->load_km);
                        $doc->exportField($this->unload_km);
                        $doc->exportField($this->delivery_receipt);
                        $doc->exportField($this->delivery_docket);
                        $doc->exportField($this->diesal_op_b);
                        $doc->exportField($this->diesal_required);
                        $doc->exportField($this->diesal_fill);
                        $doc->exportField($this->diesal_amount);
                        $doc->exportField($this->diesal_cl_balance);
                        $doc->exportField($this->vehicle_average);
                        $doc->exportField($this->cash_required);
                        $doc->exportField($this->cash_op_b);
                        $doc->exportField($this->cash_paid);
                        $doc->exportField($this->cash_expenses);
                        $doc->exportField($this->cash_cl_balance);
                        $doc->exportField($this->fasttag_op_b);
                        $doc->exportField($this->fasttag_recharge);
                        $doc->exportField($this->fasttag_expenses);
                        $doc->exportField($this->toll_expenses_cash);
                        $doc->exportField($this->fasttag_cl_balance);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->uploads);
                        $doc->exportField($this->consignor);
                        $doc->exportField($this->vehicle_freight_comm);
                        $doc->exportField($this->vehicle_freight_type);
                        $doc->exportField($this->vehicle_freight_amount);
                        $doc->exportField($this->vehicle_freight_final);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->vehicle_type);
                        $doc->exportField($this->vehicle);
                        $doc->exportField($this->_route);
                        $doc->exportField($this->route_name);
                        $doc->exportField($this->reports_to);
                        $doc->exportField($this->buyer);
                        $doc->exportField($this->b_consignor);
                        $doc->exportField($this->b_consignee);
                        $doc->exportField($this->load_date);
                        $doc->exportField($this->load_weight);
                        $doc->exportField($this->unload_date);
                        $doc->exportField($this->unload_weight);
                        $doc->exportField($this->invoice_no);
                        $doc->exportField($this->invoice_date);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->delivery_pod);
                        $doc->exportField($this->status);
                        $doc->exportField($this->days);
                        $doc->exportField($this->driver);
                        $doc->exportField($this->driver_name);
                        $doc->exportField($this->agent);
                        $doc->exportField($this->comm);
                        $doc->exportField($this->material);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->m_hsn);
                        $doc->exportField($this->_40);
                        $doc->exportField($this->lr_no);
                        $doc->exportField($this->km);
                        $doc->exportField($this->freight_type);
                        $doc->exportField($this->freight);
                        $doc->exportField($this->ded_det);
                        $doc->exportField($this->ded_det_remarks);
                        $doc->exportField($this->gst_percent);
                        $doc->exportField($this->gst_amount);
                        $doc->exportField($this->final_amount);
                        $doc->exportField($this->load_km);
                        $doc->exportField($this->unload_km);
                        $doc->exportField($this->delivery_receipt);
                        $doc->exportField($this->delivery_docket);
                        $doc->exportField($this->diesal_op_b);
                        $doc->exportField($this->diesal_required);
                        $doc->exportField($this->diesal_fill);
                        $doc->exportField($this->diesal_amount);
                        $doc->exportField($this->diesal_cl_balance);
                        $doc->exportField($this->vehicle_average);
                        $doc->exportField($this->cash_required);
                        $doc->exportField($this->cash_op_b);
                        $doc->exportField($this->cash_paid);
                        $doc->exportField($this->cash_expenses);
                        $doc->exportField($this->cash_cl_balance);
                        $doc->exportField($this->fasttag_op_b);
                        $doc->exportField($this->fasttag_recharge);
                        $doc->exportField($this->fasttag_expenses);
                        $doc->exportField($this->toll_expenses_cash);
                        $doc->exportField($this->fasttag_cl_balance);
                        $doc->exportField($this->consignor);
                        $doc->exportField($this->vehicle_freight_comm);
                        $doc->exportField($this->vehicle_freight_type);
                        $doc->exportField($this->vehicle_freight_amount);
                        $doc->exportField($this->vehicle_freight_final);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'delivery_receipt') {
            $fldName = "delivery_receipt";
            $fileNameFld = "delivery_receipt";
        } elseif ($fldparm == 'uploads') {
            $fldName = "uploads";
            $fileNameFld = "uploads";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
