<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TRouteInfoAdd extends TRouteInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TRouteInfoAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "trouteinfoadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->route_name->Visible = false;
        $this->r_from->setVisibility();
        $this->r_to->setVisibility();
        $this->km->setVisibility();
        $this->days->setVisibility();
        $this->load_expenses->setVisibility();
        $this->unload_expenses->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 't_route_info';
        $this->TableName = 't_route_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (t_route_info)
        if (!isset($GLOBALS["t_route_info"]) || $GLOBALS["t_route_info"]::class == PROJECT_NAMESPACE . "t_route_info") {
            $GLOBALS["t_route_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 't_route_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "trouteinfoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: Must be after loadOldRecord to prevent master key values being overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("trouteinfolist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "trouteinfolist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "trouteinfoview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions && !$this->getCurrentMasterTable()) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "trouteinfolist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "trouteinfolist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'r_from' first before field var 'x_r_from'
        $val = $CurrentForm->hasValue("r_from") ? $CurrentForm->getValue("r_from") : $CurrentForm->getValue("x_r_from");
        if (!$this->r_from->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_from->Visible = false; // Disable update for API request
            } else {
                $this->r_from->setFormValue($val);
            }
        }

        // Check field name 'r_to' first before field var 'x_r_to'
        $val = $CurrentForm->hasValue("r_to") ? $CurrentForm->getValue("r_to") : $CurrentForm->getValue("x_r_to");
        if (!$this->r_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_to->Visible = false; // Disable update for API request
            } else {
                $this->r_to->setFormValue($val);
            }
        }

        // Check field name 'km' first before field var 'x_km'
        $val = $CurrentForm->hasValue("km") ? $CurrentForm->getValue("km") : $CurrentForm->getValue("x_km");
        if (!$this->km->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->km->Visible = false; // Disable update for API request
            } else {
                $this->km->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'days' first before field var 'x_days'
        $val = $CurrentForm->hasValue("days") ? $CurrentForm->getValue("days") : $CurrentForm->getValue("x_days");
        if (!$this->days->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->days->Visible = false; // Disable update for API request
            } else {
                $this->days->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'load_expenses' first before field var 'x_load_expenses'
        $val = $CurrentForm->hasValue("load_expenses") ? $CurrentForm->getValue("load_expenses") : $CurrentForm->getValue("x_load_expenses");
        if (!$this->load_expenses->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->load_expenses->Visible = false; // Disable update for API request
            } else {
                $this->load_expenses->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'unload_expenses' first before field var 'x_unload_expenses'
        $val = $CurrentForm->hasValue("unload_expenses") ? $CurrentForm->getValue("unload_expenses") : $CurrentForm->getValue("x_unload_expenses");
        if (!$this->unload_expenses->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unload_expenses->Visible = false; // Disable update for API request
            } else {
                $this->unload_expenses->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->r_from->CurrentValue = $this->r_from->FormValue;
        $this->r_to->CurrentValue = $this->r_to->FormValue;
        $this->km->CurrentValue = $this->km->FormValue;
        $this->days->CurrentValue = $this->days->FormValue;
        $this->load_expenses->CurrentValue = $this->load_expenses->FormValue;
        $this->unload_expenses->CurrentValue = $this->unload_expenses->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->route_name->setDbValue($row['route_name']);
        $this->r_from->setDbValue($row['r_from']);
        $this->r_to->setDbValue($row['r_to']);
        $this->km->setDbValue($row['km']);
        $this->days->setDbValue($row['days']);
        $this->load_expenses->setDbValue($row['load_expenses']);
        $this->unload_expenses->setDbValue($row['unload_expenses']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['route_name'] = $this->route_name->DefaultValue;
        $row['r_from'] = $this->r_from->DefaultValue;
        $row['r_to'] = $this->r_to->DefaultValue;
        $row['km'] = $this->km->DefaultValue;
        $row['days'] = $this->days->DefaultValue;
        $row['load_expenses'] = $this->load_expenses->DefaultValue;
        $row['unload_expenses'] = $this->unload_expenses->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // route_name
        $this->route_name->RowCssClass = "row";

        // r_from
        $this->r_from->RowCssClass = "row";

        // r_to
        $this->r_to->RowCssClass = "row";

        // km
        $this->km->RowCssClass = "row";

        // days
        $this->days->RowCssClass = "row";

        // load_expenses
        $this->load_expenses->RowCssClass = "row";

        // unload_expenses
        $this->unload_expenses->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // route_name
            $this->route_name->ViewValue = $this->route_name->CurrentValue;

            // r_from
            $this->r_from->ViewValue = $this->r_from->CurrentValue;

            // r_to
            $this->r_to->ViewValue = $this->r_to->CurrentValue;

            // km
            $this->km->ViewValue = $this->km->CurrentValue;
            $this->km->ViewValue = FormatNumber($this->km->ViewValue, $this->km->formatPattern());

            // days
            $this->days->ViewValue = $this->days->CurrentValue;
            $this->days->ViewValue = FormatNumber($this->days->ViewValue, $this->days->formatPattern());

            // load_expenses
            $this->load_expenses->ViewValue = $this->load_expenses->CurrentValue;
            $this->load_expenses->ViewValue = FormatNumber($this->load_expenses->ViewValue, $this->load_expenses->formatPattern());

            // unload_expenses
            $this->unload_expenses->ViewValue = $this->unload_expenses->CurrentValue;
            $this->unload_expenses->ViewValue = FormatNumber($this->unload_expenses->ViewValue, $this->unload_expenses->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // r_from
            $this->r_from->HrefValue = "";

            // r_to
            $this->r_to->HrefValue = "";

            // km
            $this->km->HrefValue = "";

            // days
            $this->days->HrefValue = "";

            // load_expenses
            $this->load_expenses->HrefValue = "";

            // unload_expenses
            $this->unload_expenses->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // r_from
            $this->r_from->setupEditAttributes();
            if (!$this->r_from->Raw) {
                $this->r_from->CurrentValue = HtmlDecode($this->r_from->CurrentValue);
            }
            $this->r_from->EditValue = HtmlEncode($this->r_from->CurrentValue);
            $this->r_from->PlaceHolder = RemoveHtml($this->r_from->caption());

            // r_to
            $this->r_to->setupEditAttributes();
            if (!$this->r_to->Raw) {
                $this->r_to->CurrentValue = HtmlDecode($this->r_to->CurrentValue);
            }
            $this->r_to->EditValue = HtmlEncode($this->r_to->CurrentValue);
            $this->r_to->PlaceHolder = RemoveHtml($this->r_to->caption());

            // km
            $this->km->setupEditAttributes();
            $this->km->EditValue = $this->km->CurrentValue;
            $this->km->PlaceHolder = RemoveHtml($this->km->caption());
            if (strval($this->km->EditValue) != "" && is_numeric($this->km->EditValue)) {
                $this->km->EditValue = FormatNumber($this->km->EditValue, null);
            }

            // days
            $this->days->setupEditAttributes();
            $this->days->EditValue = $this->days->CurrentValue;
            $this->days->PlaceHolder = RemoveHtml($this->days->caption());
            if (strval($this->days->EditValue) != "" && is_numeric($this->days->EditValue)) {
                $this->days->EditValue = FormatNumber($this->days->EditValue, null);
            }

            // load_expenses
            $this->load_expenses->setupEditAttributes();
            $this->load_expenses->EditValue = $this->load_expenses->CurrentValue;
            $this->load_expenses->PlaceHolder = RemoveHtml($this->load_expenses->caption());
            if (strval($this->load_expenses->EditValue) != "" && is_numeric($this->load_expenses->EditValue)) {
                $this->load_expenses->EditValue = FormatNumber($this->load_expenses->EditValue, null);
            }

            // unload_expenses
            $this->unload_expenses->setupEditAttributes();
            $this->unload_expenses->EditValue = $this->unload_expenses->CurrentValue;
            $this->unload_expenses->PlaceHolder = RemoveHtml($this->unload_expenses->caption());
            if (strval($this->unload_expenses->EditValue) != "" && is_numeric($this->unload_expenses->EditValue)) {
                $this->unload_expenses->EditValue = FormatNumber($this->unload_expenses->EditValue, null);
            }

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // Add refer script

            // r_from
            $this->r_from->HrefValue = "";

            // r_to
            $this->r_to->HrefValue = "";

            // km
            $this->km->HrefValue = "";

            // days
            $this->days->HrefValue = "";

            // load_expenses
            $this->load_expenses->HrefValue = "";

            // unload_expenses
            $this->unload_expenses->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Render add option
    public function renderAddOpt($row)
    {
        global $Security, $Language, $CurrentLanguage;

        // Set up CurrentValue
        $this->r_from->CurrentValue = $row["r_from"] ?? null;
        $this->r_to->CurrentValue = $row["r_to"] ?? null;
        $this->km->CurrentValue = $row["km"] ?? null;
        $this->days->CurrentValue = $row["days"] ?? null;
        $this->load_expenses->CurrentValue = $row["load_expenses"] ?? null;
        $this->unload_expenses->CurrentValue = $row["unload_expenses"] ?? null;
        $this->status->CurrentValue = $row["status"] ?? null;
        $this->operator->CurrentValue = $row["operator"] ?? null;
        $this->datetime->CurrentValue = $row["datetime"] ?? null;

        // r_from
        $this->r_from->ViewValue = $this->r_from->CurrentValue;

        // r_to
        $this->r_to->ViewValue = $this->r_to->CurrentValue;

        // km
        $this->km->ViewValue = $this->km->CurrentValue;
        $this->km->ViewValue = FormatNumber($this->km->ViewValue, $this->km->formatPattern());

        // days
        $this->days->ViewValue = $this->days->CurrentValue;
        $this->days->ViewValue = FormatNumber($this->days->ViewValue, $this->days->formatPattern());

        // load_expenses
        $this->load_expenses->ViewValue = $this->load_expenses->CurrentValue;
        $this->load_expenses->ViewValue = FormatNumber($this->load_expenses->ViewValue, $this->load_expenses->formatPattern());

        // unload_expenses
        $this->unload_expenses->ViewValue = $this->unload_expenses->CurrentValue;
        $this->unload_expenses->ViewValue = FormatNumber($this->unload_expenses->ViewValue, $this->unload_expenses->formatPattern());

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // Set up $row
        $row["r_from"] = $this->r_from->ViewValue;
        $row["r_to"] = $this->r_to->ViewValue;
        $row["km"] = $this->km->ViewValue;
        $row["days"] = $this->days->ViewValue;
        $row["load_expenses"] = $this->load_expenses->ViewValue;
        $row["unload_expenses"] = $this->unload_expenses->ViewValue;
        $row["status"] = $this->status->ViewValue;
        $row["operator"] = $this->operator->ViewValue;
        $row["datetime"] = $this->datetime->ViewValue;
        return $row;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->r_from->Visible && $this->r_from->Required) {
                if (!$this->r_from->IsDetailKey && EmptyValue($this->r_from->FormValue)) {
                    $this->r_from->addErrorMessage(str_replace("%s", $this->r_from->caption(), $this->r_from->RequiredErrorMessage));
                }
            }
            if ($this->r_to->Visible && $this->r_to->Required) {
                if (!$this->r_to->IsDetailKey && EmptyValue($this->r_to->FormValue)) {
                    $this->r_to->addErrorMessage(str_replace("%s", $this->r_to->caption(), $this->r_to->RequiredErrorMessage));
                }
            }
            if ($this->km->Visible && $this->km->Required) {
                if (!$this->km->IsDetailKey && EmptyValue($this->km->FormValue)) {
                    $this->km->addErrorMessage(str_replace("%s", $this->km->caption(), $this->km->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->km->FormValue)) {
                $this->km->addErrorMessage($this->km->getErrorMessage(false));
            }
            if ($this->days->Visible && $this->days->Required) {
                if (!$this->days->IsDetailKey && EmptyValue($this->days->FormValue)) {
                    $this->days->addErrorMessage(str_replace("%s", $this->days->caption(), $this->days->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->days->FormValue)) {
                $this->days->addErrorMessage($this->days->getErrorMessage(false));
            }
            if ($this->load_expenses->Visible && $this->load_expenses->Required) {
                if (!$this->load_expenses->IsDetailKey && EmptyValue($this->load_expenses->FormValue)) {
                    $this->load_expenses->addErrorMessage(str_replace("%s", $this->load_expenses->caption(), $this->load_expenses->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->load_expenses->FormValue)) {
                $this->load_expenses->addErrorMessage($this->load_expenses->getErrorMessage(false));
            }
            if ($this->unload_expenses->Visible && $this->unload_expenses->Required) {
                if (!$this->unload_expenses->IsDetailKey && EmptyValue($this->unload_expenses->FormValue)) {
                    $this->unload_expenses->addErrorMessage(str_replace("%s", $this->unload_expenses->caption(), $this->unload_expenses->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->unload_expenses->FormValue)) {
                $this->unload_expenses->addErrorMessage($this->unload_expenses->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            if (Post("addopt") == "1") { // Render for add option response
                $row = $this->renderAddOpt($row);
            }
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // r_from
        $this->r_from->setDbValueDef($rsnew, $this->r_from->CurrentValue, false);

        // r_to
        $this->r_to->setDbValueDef($rsnew, $this->r_to->CurrentValue, false);

        // km
        $this->km->setDbValueDef($rsnew, $this->km->CurrentValue, false);

        // days
        $this->days->setDbValueDef($rsnew, $this->days->CurrentValue, false);

        // load_expenses
        $this->load_expenses->setDbValueDef($rsnew, $this->load_expenses->CurrentValue, false);

        // unload_expenses
        $this->unload_expenses->setDbValueDef($rsnew, $this->unload_expenses->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // id
        if ($this->id->getSessionValue() != "") {
            $rsnew['id'] = $this->id->getSessionValue();
        }
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['r_from'])) { // r_from
            $this->r_from->setFormValue($row['r_from']);
        }
        if (isset($row['r_to'])) { // r_to
            $this->r_to->setFormValue($row['r_to']);
        }
        if (isset($row['km'])) { // km
            $this->km->setFormValue($row['km']);
        }
        if (isset($row['days'])) { // days
            $this->days->setFormValue($row['days']);
        }
        if (isset($row['load_expenses'])) { // load_expenses
            $this->load_expenses->setFormValue($row['load_expenses']);
        }
        if (isset($row['unload_expenses'])) { // unload_expenses
            $this->unload_expenses->setFormValue($row['unload_expenses']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['id'])) { // id
            $this->id->setFormValue($row['id']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "t_trip_info") {
                $validMaster = true;
                $masterTbl = Container("t_trip_info");
                if (($parm = Get("fk__route", Get("id"))) !== null) {
                    $masterTbl->_route->setQueryStringValue($parm);
                    $this->id->QueryStringValue = $masterTbl->_route->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->id->setSessionValue($this->id->QueryStringValue);
                    $foreignKeys["id"] = $this->id->QueryStringValue;
                    if (!is_numeric($masterTbl->_route->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "t_trip_info") {
                $validMaster = true;
                $masterTbl = Container("t_trip_info");
                if (($parm = Post("fk__route", Post("id"))) !== null) {
                    $masterTbl->_route->setFormValue($parm);
                    $this->id->FormValue = $masterTbl->_route->FormValue;
                    $this->id->setSessionValue($this->id->FormValue);
                    $foreignKeys["id"] = $this->id->FormValue;
                    if (!is_numeric($masterTbl->_route->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "t_trip_info") {
                if (!array_key_exists("id", $foreignKeys)) { // Not current foreign key
                    $this->id->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("trouteinfolist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_status":
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
