<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TExpensesGrid extends TExpenses
{
    use MessagesTrait;

    // Page ID
    public $PageID = "grid";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TExpensesGrid";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "ft_expensesgrid";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "texpensesgrid";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->trip->setVisibility();
        $this->diesal->setVisibility();
        $this->border->setVisibility();
        $this->rto->setVisibility();
        $this->da->setVisibility();
        $this->repairing->setVisibility();
        $this->toll->setVisibility();
        $this->other->setVisibility();
        $this->cash_paid->setVisibility();
        $this->total->setVisibility();
        $this->remarks->setVisibility();
        $this->dated->setVisibility();
        $this->uploads->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->diesal_lt->setVisibility();
        $this->def->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 't_expenses';
        $this->TableName = 't_expenses';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $this->FormActionName .= "_" . $this->FormName;
        $this->OldKeyName .= "_" . $this->FormName;
        $this->FormBlankRowName .= "_" . $this->FormName;
        $this->FormKeyCountName .= "_" . $this->FormName;
        $GLOBALS["Grid"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (t_expenses)
        if (!isset($GLOBALS["t_expenses"]) || $GLOBALS["t_expenses"]::class == PROJECT_NAMESPACE . "t_expenses") {
            $GLOBALS["t_expenses"] = &$this;
        }
        $this->AddUrl = "texpensesadd";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 't_expenses');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;
        unset($GLOBALS["Grid"]);
        if ($url === "") {
            return;
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $ShowOtherOptions = false;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        if (Param("export") !== null) {
            $this->Export = Param("export");
        }

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up master detail parameters
        $this->setupMasterParms();

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->trip);

        // Load default values for add
        $this->loadDefaultValues();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "ft_expensesgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Show grid delete link for grid add / grid edit
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $item = $this->ListOptions["griddelete"];
                if ($item) {
                    $item->Visible = false;
                }
            }
        }

        // Set up sorting order
        $this->setupSortOrder();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }

        // Restore master/detail filter from session
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Restore master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Restore detail filter from session
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "t_trip_expenses_report") {
            $masterTbl = Container("t_trip_expenses_report");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("ttripexpensesreportlist"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->TotalRecords = $this->listRecordCount();
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->TotalRecords;
                $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
            } else {
                $this->CurrentFilter = "0=1";
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->GridAddRowCount;
            }
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->TotalRecords; // Display all records
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->diesal->FormValue = ""; // Clear form value
        $this->border->FormValue = ""; // Clear form value
        $this->rto->FormValue = ""; // Clear form value
        $this->da->FormValue = ""; // Clear form value
        $this->repairing->FormValue = ""; // Clear form value
        $this->toll->FormValue = ""; // Clear form value
        $this->other->FormValue = ""; // Clear form value
        $this->total->FormValue = ""; // Clear form value
        $this->diesal_lt->FormValue = ""; // Clear form value
        $this->def->FormValue = ""; // Clear form value
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to grid add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Switch to grid edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old result set
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAllAssociative();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();
        $wrkfilter = "";
        $key = "";

        // Update row index and get row key
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $this->setKey($CurrentForm->getValue($this->OldKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete" && $rowaction != "hide") { // Skip insert then deleted rows / hidden rows for grid edit
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->OldKey != ""; // Key must not be empty
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($this->OldKey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                        if ($gridUpdate) { // Get inserted or updated filter
                            AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                        }
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $this->OldKey;
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($gridUpdate) {
            $this->FilterForModalActions = $wrkfilter;

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Perform grid add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        $key = "";

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $rsold = null;
            if ($rowaction == "insert") {
                $this->OldKey = strval($CurrentForm->getValue($this->OldKeyName));
                $rsold = $this->loadOldRecord(); // Load old record
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success
                $gridInsert = $this->addRow($rsold); // Insert row (already validated by validateGridForm())
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->id->CurrentValue;

                    // Add filter for this record
                    AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->clearInlineMode(); // Clear grid add mode and return
            return true;
        }
        if ($gridInsert) {
            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $this->FilterForModalActions = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if (
            $CurrentForm->hasValue("x_trip") &&
            $CurrentForm->hasValue("o_trip") &&
            $this->trip->CurrentValue != $this->trip->DefaultValue &&
            !($this->trip->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->trip->CurrentValue == $this->trip->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_diesal") &&
            $CurrentForm->hasValue("o_diesal") &&
            $this->diesal->CurrentValue != $this->diesal->DefaultValue &&
            !($this->diesal->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->diesal->CurrentValue == $this->diesal->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_border") &&
            $CurrentForm->hasValue("o_border") &&
            $this->border->CurrentValue != $this->border->DefaultValue &&
            !($this->border->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->border->CurrentValue == $this->border->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_rto") &&
            $CurrentForm->hasValue("o_rto") &&
            $this->rto->CurrentValue != $this->rto->DefaultValue &&
            !($this->rto->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->rto->CurrentValue == $this->rto->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_da") &&
            $CurrentForm->hasValue("o_da") &&
            $this->da->CurrentValue != $this->da->DefaultValue &&
            !($this->da->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->da->CurrentValue == $this->da->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_repairing") &&
            $CurrentForm->hasValue("o_repairing") &&
            $this->repairing->CurrentValue != $this->repairing->DefaultValue &&
            !($this->repairing->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->repairing->CurrentValue == $this->repairing->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_toll") &&
            $CurrentForm->hasValue("o_toll") &&
            $this->toll->CurrentValue != $this->toll->DefaultValue &&
            !($this->toll->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->toll->CurrentValue == $this->toll->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_other") &&
            $CurrentForm->hasValue("o_other") &&
            $this->other->CurrentValue != $this->other->DefaultValue &&
            !($this->other->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->other->CurrentValue == $this->other->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_cash_paid") &&
            $CurrentForm->hasValue("o_cash_paid") &&
            $this->cash_paid->CurrentValue != $this->cash_paid->DefaultValue &&
            !($this->cash_paid->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->cash_paid->CurrentValue == $this->cash_paid->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_total") &&
            $CurrentForm->hasValue("o_total") &&
            $this->total->CurrentValue != $this->total->DefaultValue &&
            !($this->total->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->total->CurrentValue == $this->total->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_remarks") &&
            $CurrentForm->hasValue("o_remarks") &&
            $this->remarks->CurrentValue != $this->remarks->DefaultValue &&
            !($this->remarks->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->remarks->CurrentValue == $this->remarks->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_dated") &&
            $CurrentForm->hasValue("o_dated") &&
            $this->dated->CurrentValue != $this->dated->DefaultValue &&
            !($this->dated->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->dated->CurrentValue == $this->dated->getSessionValue())
        ) {
            return false;
        }
        if (!EmptyValue($this->uploads->Upload->Value)) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_diesal_lt") &&
            $CurrentForm->hasValue("o_diesal_lt") &&
            $this->diesal_lt->CurrentValue != $this->diesal_lt->DefaultValue &&
            !($this->diesal_lt->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->diesal_lt->CurrentValue == $this->diesal_lt->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_def") &&
            $CurrentForm->hasValue("o_def") &&
            $this->def->CurrentValue != $this->def->DefaultValue &&
            !($this->def->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->def->CurrentValue == $this->def->getSessionValue())
        ) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Load default values for emptyRow checking
        $this->loadDefaultValues();

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete" && $rowaction != "hide") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    $this->ValidationErrors[$rowindex] = $this->getValidationErrors();
                    $this->EventCancelled = true;
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        foreach ($this->Fields as $field) {
            $field->clearErrorMessage();
        }
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset master/detail keys
            if ($this->Command == "resetall") {
                $this->setCurrentMasterTable(""); // Clear master table
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
                        $this->trip->setSessionValue("");
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = true;
            $item->Visible = false; // Default hidden
        }

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->OldKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            $oldKey = $this->getKey(false); // Get from OldValue
            if ($oldKeyName != "" && $oldKey != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($oldKey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-ew-action=\"delete-grid-row\" data-rowindex=\"" . $this->RowIndex . "\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"t_expenses\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"t_expenses\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"t_expenses\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $option = $this->OtherOptions["addedit"];
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Add
        if ($this->CurrentMode == "view") { // Check view mode
            $item = &$option->add("add");
            $addcaption = HtmlTitle($Language->phrase("AddLink"));
            $this->AddUrl = $this->getAddUrl();
            if ($this->ModalAdd && !IsMobile()) {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"t_expenses\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
            } else {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
            }
            $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        }
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
            if (in_array($this->CurrentMode, ["add", "copy", "edit"]) && !$this->isConfirm()) { // Check add/copy/edit mode
                if ($this->AllowAddDeleteRow) {
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-ew-action=\"add-grid-row\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = $Security->canAdd();
                    $this->ShowOtherOptions = $item->Visible;
                }
            }
            if ($this->CurrentMode == "view") { // Check view mode
                $option = $options["addedit"];
                $item = $option["add"];
                $this->ShowOtherOptions = $item?->Visible ?? false;
            }
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        $this->StartRecord = 1;
        $this->StopRecord = $this->TotalRecords; // Show all records

        // Restore number of post back records
        if ($CurrentForm && ($this->isConfirm() || $this->EventCancelled)) {
            $CurrentForm->resetIndex();
            if ($CurrentForm->hasValue($this->FormKeyCountName) && ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm())) {
                $this->KeyCount = $CurrentForm->getValue($this->FormKeyCountName);
                $this->StopRecord = $this->StartRecord + $this->KeyCount - 1;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_t_expenses", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }
        if ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm() || $this->isMultiEdit()) {
            $this->RowIndex++;
            $CurrentForm->Index = $this->RowIndex;
            if ($CurrentForm->hasValue($this->FormActionName) && ($this->isConfirm() || $this->EventCancelled)) {
                $this->RowAction = strval($CurrentForm->getValue($this->FormActionName));
            } elseif ($this->isGridAdd()) {
                $this->RowAction = "insert";
            } else {
                $this->RowAction = "";
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->loadRowValues($this->CurrentRow); // Load row values
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
            } else {
                $this->loadRowValues(); // Load default values
                $this->OldKey = "";
            }
        } else {
            $this->loadRowValues($this->CurrentRow); // Load row values
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
        }
        $this->setKey($this->OldKey);
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }
        if ($this->isGridAdd() && $this->EventCancelled && !$CurrentForm->hasValue($this->FormBlankRowName)) { // Insert failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isGridEdit()) { // Grid edit
            if ($this->EventCancelled) {
                $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
            }
            if ($this->RowAction == "insert") {
                $this->RowType = RowType::ADD; // Render add
            } else {
                $this->RowType = RowType::EDIT; // Render edit
            }
        }
        if ($this->isGridEdit() && ($this->RowType == RowType::EDIT || $this->RowType == RowType::ADD) && $this->EventCancelled) { // Update failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isConfirm()) { // Confirm row
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_t_expenses",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->uploads->Upload->Index = $CurrentForm->Index;
        $this->uploads->Upload->uploadFile();
        $this->uploads->CurrentValue = $this->uploads->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->diesal->DefaultValue = $this->diesal->getDefault(); // PHP
        $this->diesal->OldValue = $this->diesal->DefaultValue;
        $this->border->DefaultValue = $this->border->getDefault(); // PHP
        $this->border->OldValue = $this->border->DefaultValue;
        $this->rto->DefaultValue = $this->rto->getDefault(); // PHP
        $this->rto->OldValue = $this->rto->DefaultValue;
        $this->da->DefaultValue = $this->da->getDefault(); // PHP
        $this->da->OldValue = $this->da->DefaultValue;
        $this->repairing->DefaultValue = $this->repairing->getDefault(); // PHP
        $this->repairing->OldValue = $this->repairing->DefaultValue;
        $this->toll->DefaultValue = $this->toll->getDefault(); // PHP
        $this->toll->OldValue = $this->toll->DefaultValue;
        $this->other->DefaultValue = $this->other->getDefault(); // PHP
        $this->other->OldValue = $this->other->DefaultValue;
        $this->total->DefaultValue = $this->total->getDefault(); // PHP
        $this->total->OldValue = $this->total->DefaultValue;
        $this->dated->DefaultValue = $this->dated->getDefault(); // PHP
        $this->dated->OldValue = $this->dated->DefaultValue;
        $this->uploads->Upload->Index = $this->RowIndex;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->diesal_lt->DefaultValue = $this->diesal_lt->getDefault(); // PHP
        $this->diesal_lt->OldValue = $this->diesal_lt->DefaultValue;
        $this->def->DefaultValue = $this->def->getDefault(); // PHP
        $this->def->OldValue = $this->def->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $CurrentForm->FormName = $this->FormName;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->id->setFormValue($val);
        }

        // Check field name 'trip' first before field var 'x_trip'
        $val = $CurrentForm->hasValue("trip") ? $CurrentForm->getValue("trip") : $CurrentForm->getValue("x_trip");
        if (!$this->trip->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->trip->Visible = false; // Disable update for API request
            } else {
                $this->trip->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_trip")) {
            $this->trip->setOldValue($CurrentForm->getValue("o_trip"));
        }

        // Check field name 'diesal' first before field var 'x_diesal'
        $val = $CurrentForm->hasValue("diesal") ? $CurrentForm->getValue("diesal") : $CurrentForm->getValue("x_diesal");
        if (!$this->diesal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diesal->Visible = false; // Disable update for API request
            } else {
                $this->diesal->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_diesal")) {
            $this->diesal->setOldValue($CurrentForm->getValue("o_diesal"));
        }

        // Check field name 'border' first before field var 'x_border'
        $val = $CurrentForm->hasValue("border") ? $CurrentForm->getValue("border") : $CurrentForm->getValue("x_border");
        if (!$this->border->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->border->Visible = false; // Disable update for API request
            } else {
                $this->border->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_border")) {
            $this->border->setOldValue($CurrentForm->getValue("o_border"));
        }

        // Check field name 'rto' first before field var 'x_rto'
        $val = $CurrentForm->hasValue("rto") ? $CurrentForm->getValue("rto") : $CurrentForm->getValue("x_rto");
        if (!$this->rto->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rto->Visible = false; // Disable update for API request
            } else {
                $this->rto->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_rto")) {
            $this->rto->setOldValue($CurrentForm->getValue("o_rto"));
        }

        // Check field name 'da' first before field var 'x_da'
        $val = $CurrentForm->hasValue("da") ? $CurrentForm->getValue("da") : $CurrentForm->getValue("x_da");
        if (!$this->da->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->da->Visible = false; // Disable update for API request
            } else {
                $this->da->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_da")) {
            $this->da->setOldValue($CurrentForm->getValue("o_da"));
        }

        // Check field name 'repairing' first before field var 'x_repairing'
        $val = $CurrentForm->hasValue("repairing") ? $CurrentForm->getValue("repairing") : $CurrentForm->getValue("x_repairing");
        if (!$this->repairing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->repairing->Visible = false; // Disable update for API request
            } else {
                $this->repairing->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_repairing")) {
            $this->repairing->setOldValue($CurrentForm->getValue("o_repairing"));
        }

        // Check field name 'toll' first before field var 'x_toll'
        $val = $CurrentForm->hasValue("toll") ? $CurrentForm->getValue("toll") : $CurrentForm->getValue("x_toll");
        if (!$this->toll->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->toll->Visible = false; // Disable update for API request
            } else {
                $this->toll->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_toll")) {
            $this->toll->setOldValue($CurrentForm->getValue("o_toll"));
        }

        // Check field name 'other' first before field var 'x_other'
        $val = $CurrentForm->hasValue("other") ? $CurrentForm->getValue("other") : $CurrentForm->getValue("x_other");
        if (!$this->other->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other->Visible = false; // Disable update for API request
            } else {
                $this->other->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_other")) {
            $this->other->setOldValue($CurrentForm->getValue("o_other"));
        }

        // Check field name 'cash_paid' first before field var 'x_cash_paid'
        $val = $CurrentForm->hasValue("cash_paid") ? $CurrentForm->getValue("cash_paid") : $CurrentForm->getValue("x_cash_paid");
        if (!$this->cash_paid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cash_paid->Visible = false; // Disable update for API request
            } else {
                $this->cash_paid->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_cash_paid")) {
            $this->cash_paid->setOldValue($CurrentForm->getValue("o_cash_paid"));
        }

        // Check field name 'total' first before field var 'x_total'
        $val = $CurrentForm->hasValue("total") ? $CurrentForm->getValue("total") : $CurrentForm->getValue("x_total");
        if (!$this->total->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->total->Visible = false; // Disable update for API request
            } else {
                $this->total->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_total")) {
            $this->total->setOldValue($CurrentForm->getValue("o_total"));
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_remarks")) {
            $this->remarks->setOldValue($CurrentForm->getValue("o_remarks"));
        }

        // Check field name 'dated' first before field var 'x_dated'
        $val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
        if (!$this->dated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dated->Visible = false; // Disable update for API request
            } else {
                $this->dated->setFormValue($val, true, $validate);
            }
            $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        }
        if ($CurrentForm->hasValue("o_dated")) {
            $this->dated->setOldValue($CurrentForm->getValue("o_dated"));
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_operator")) {
            $this->operator->setOldValue($CurrentForm->getValue("o_operator"));
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
        if ($CurrentForm->hasValue("o_datetime")) {
            $this->datetime->setOldValue($CurrentForm->getValue("o_datetime"));
        }

        // Check field name 'diesal_lt' first before field var 'x_diesal_lt'
        $val = $CurrentForm->hasValue("diesal_lt") ? $CurrentForm->getValue("diesal_lt") : $CurrentForm->getValue("x_diesal_lt");
        if (!$this->diesal_lt->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diesal_lt->Visible = false; // Disable update for API request
            } else {
                $this->diesal_lt->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_diesal_lt")) {
            $this->diesal_lt->setOldValue($CurrentForm->getValue("o_diesal_lt"));
        }

        // Check field name 'def' first before field var 'x_def'
        $val = $CurrentForm->hasValue("def") ? $CurrentForm->getValue("def") : $CurrentForm->getValue("x_def");
        if (!$this->def->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->def->Visible = false; // Disable update for API request
            } else {
                $this->def->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_def")) {
            $this->def->setOldValue($CurrentForm->getValue("o_def"));
        }
		$this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
		$this->uploads->UploadPath = $this->uploads->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->id->CurrentValue = $this->id->FormValue;
        }
        $this->trip->CurrentValue = $this->trip->FormValue;
        $this->diesal->CurrentValue = $this->diesal->FormValue;
        $this->border->CurrentValue = $this->border->FormValue;
        $this->rto->CurrentValue = $this->rto->FormValue;
        $this->da->CurrentValue = $this->da->FormValue;
        $this->repairing->CurrentValue = $this->repairing->FormValue;
        $this->toll->CurrentValue = $this->toll->FormValue;
        $this->other->CurrentValue = $this->other->FormValue;
        $this->cash_paid->CurrentValue = $this->cash_paid->FormValue;
        $this->total->CurrentValue = $this->total->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->dated->CurrentValue = $this->dated->FormValue;
        $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->diesal_lt->CurrentValue = $this->diesal_lt->FormValue;
        $this->def->CurrentValue = $this->def->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->trip->setDbValue($row['trip']);
        $this->diesal->setDbValue($row['diesal']);
        $this->border->setDbValue($row['border']);
        $this->rto->setDbValue($row['rto']);
        $this->da->setDbValue($row['da']);
        $this->repairing->setDbValue($row['repairing']);
        $this->toll->setDbValue($row['toll']);
        $this->other->setDbValue($row['other']);
        $this->cash_paid->setDbValue($row['cash_paid']);
        $this->total->setDbValue($row['total']);
        $this->remarks->setDbValue($row['remarks']);
        $this->dated->setDbValue($row['dated']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->uploads->Upload->Index = $this->RowIndex;
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->diesal_lt->setDbValue($row['diesal_lt']);
        $this->def->setDbValue($row['def']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['trip'] = $this->trip->DefaultValue;
        $row['diesal'] = $this->diesal->DefaultValue;
        $row['border'] = $this->border->DefaultValue;
        $row['rto'] = $this->rto->DefaultValue;
        $row['da'] = $this->da->DefaultValue;
        $row['repairing'] = $this->repairing->DefaultValue;
        $row['toll'] = $this->toll->DefaultValue;
        $row['other'] = $this->other->DefaultValue;
        $row['cash_paid'] = $this->cash_paid->DefaultValue;
        $row['total'] = $this->total->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['diesal_lt'] = $this->diesal_lt->DefaultValue;
        $row['def'] = $this->def->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // trip

        // diesal

        // border

        // rto

        // da

        // repairing

        // toll

        // other

        // cash_paid

        // total

        // remarks

        // dated

        // uploads

        // operator

        // datetime

        // diesal_lt

        // def

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // trip
            $curVal = strval($this->trip->CurrentValue);
            if ($curVal != "") {
                $this->trip->ViewValue = $this->trip->lookupCacheOption($curVal);
                if ($this->trip->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->trip->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->trip->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->trip->getSelectFilter($this); // PHP
                    $sqlWrk = $this->trip->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->trip->Lookup->renderViewRow($rswrk[0]);
                        $this->trip->ViewValue = $this->trip->displayValue($arwrk);
                    } else {
                        $this->trip->ViewValue = FormatNumber($this->trip->CurrentValue, $this->trip->formatPattern());
                    }
                }
            } else {
                $this->trip->ViewValue = null;
            }

            // diesal
            $this->diesal->ViewValue = $this->diesal->CurrentValue;
            $this->diesal->ViewValue = FormatNumber($this->diesal->ViewValue, $this->diesal->formatPattern());

            // border
            $this->border->ViewValue = $this->border->CurrentValue;
            $this->border->ViewValue = FormatNumber($this->border->ViewValue, $this->border->formatPattern());

            // rto
            $this->rto->ViewValue = $this->rto->CurrentValue;
            $this->rto->ViewValue = FormatNumber($this->rto->ViewValue, $this->rto->formatPattern());

            // da
            $this->da->ViewValue = $this->da->CurrentValue;
            $this->da->ViewValue = FormatNumber($this->da->ViewValue, $this->da->formatPattern());

            // repairing
            $this->repairing->ViewValue = $this->repairing->CurrentValue;
            $this->repairing->ViewValue = FormatNumber($this->repairing->ViewValue, $this->repairing->formatPattern());

            // toll
            $this->toll->ViewValue = $this->toll->CurrentValue;
            $this->toll->ViewValue = FormatNumber($this->toll->ViewValue, $this->toll->formatPattern());

            // other
            $this->other->ViewValue = $this->other->CurrentValue;
            $this->other->ViewValue = FormatNumber($this->other->ViewValue, $this->other->formatPattern());

            // cash_paid
            $this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
            $this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, $this->cash_paid->formatPattern());

            // total
            $this->total->ViewValue = $this->total->CurrentValue;
            $this->total->ViewValue = FormatNumber($this->total->ViewValue, $this->total->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // diesal_lt
            $this->diesal_lt->ViewValue = $this->diesal_lt->CurrentValue;
            $this->diesal_lt->ViewValue = FormatNumber($this->diesal_lt->ViewValue, $this->diesal_lt->formatPattern());

            // def
            $this->def->ViewValue = $this->def->CurrentValue;
            $this->def->ViewValue = FormatNumber($this->def->ViewValue, $this->def->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // trip
            $this->trip->HrefValue = "";
            $this->trip->TooltipValue = "";

            // diesal
            $this->diesal->HrefValue = "";
            $this->diesal->TooltipValue = "";

            // border
            $this->border->HrefValue = "";
            $this->border->TooltipValue = "";

            // rto
            $this->rto->HrefValue = "";
            $this->rto->TooltipValue = "";

            // da
            $this->da->HrefValue = "";
            $this->da->TooltipValue = "";

            // repairing
            $this->repairing->HrefValue = "";
            $this->repairing->TooltipValue = "";

            // toll
            $this->toll->HrefValue = "";
            $this->toll->TooltipValue = "";

            // other
            $this->other->HrefValue = "";
            $this->other->TooltipValue = "";

            // cash_paid
            $this->cash_paid->HrefValue = "";
            $this->cash_paid->TooltipValue = "";

            // total
            $this->total->HrefValue = "";
            $this->total->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
            $this->uploads->TooltipValue = "";
            if ($this->uploads->UseColorbox) {
                if (EmptyValue($this->uploads->TooltipValue)) {
                    $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->uploads->LinkAttrs["data-rel"] = "t_expenses_x" . $this->RowCount . "_uploads";
                $this->uploads->LinkAttrs->appendClass("ew-lightbox");
            }

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // diesal_lt
            $this->diesal_lt->HrefValue = "";
            $this->diesal_lt->TooltipValue = "";

            // def
            $this->def->HrefValue = "";
            $this->def->TooltipValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // id

            // trip
            $this->trip->setupEditAttributes();
            if ($this->trip->getSessionValue() != "") {
                $this->trip->CurrentValue = GetForeignKeyValue($this->trip->getSessionValue());
                $this->trip->OldValue = $this->trip->CurrentValue;
                $curVal = strval($this->trip->CurrentValue);
                if ($curVal != "") {
                    $this->trip->ViewValue = $this->trip->lookupCacheOption($curVal);
                    if ($this->trip->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->trip->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->trip->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $lookupFilter = $this->trip->getSelectFilter($this); // PHP
                        $sqlWrk = $this->trip->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->trip->Lookup->renderViewRow($rswrk[0]);
                            $this->trip->ViewValue = $this->trip->displayValue($arwrk);
                        } else {
                            $this->trip->ViewValue = FormatNumber($this->trip->CurrentValue, $this->trip->formatPattern());
                        }
                    }
                } else {
                    $this->trip->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->trip->CurrentValue));
                if ($curVal != "") {
                    $this->trip->ViewValue = $this->trip->lookupCacheOption($curVal);
                } else {
                    $this->trip->ViewValue = $this->trip->Lookup !== null && is_array($this->trip->lookupOptions()) && count($this->trip->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->trip->ViewValue !== null) { // Load from cache
                    $this->trip->EditValue = array_values($this->trip->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->trip->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->trip->CurrentValue, $this->trip->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->trip->getSelectFilter($this); // PHP
                    $sqlWrk = $this->trip->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->trip->EditValue = $arwrk;
                }
                $this->trip->PlaceHolder = RemoveHtml($this->trip->caption());
            }

            // diesal
            $this->diesal->setupEditAttributes();
            $this->diesal->EditValue = $this->diesal->CurrentValue;
            $this->diesal->PlaceHolder = RemoveHtml($this->diesal->caption());
            if (strval($this->diesal->EditValue) != "" && is_numeric($this->diesal->EditValue)) {
                $this->diesal->EditValue = FormatNumber($this->diesal->EditValue, null);
            }

            // border
            $this->border->setupEditAttributes();
            $this->border->EditValue = $this->border->CurrentValue;
            $this->border->PlaceHolder = RemoveHtml($this->border->caption());
            if (strval($this->border->EditValue) != "" && is_numeric($this->border->EditValue)) {
                $this->border->EditValue = FormatNumber($this->border->EditValue, null);
            }

            // rto
            $this->rto->setupEditAttributes();
            $this->rto->EditValue = $this->rto->CurrentValue;
            $this->rto->PlaceHolder = RemoveHtml($this->rto->caption());
            if (strval($this->rto->EditValue) != "" && is_numeric($this->rto->EditValue)) {
                $this->rto->EditValue = FormatNumber($this->rto->EditValue, null);
            }

            // da
            $this->da->setupEditAttributes();
            $this->da->EditValue = $this->da->CurrentValue;
            $this->da->PlaceHolder = RemoveHtml($this->da->caption());
            if (strval($this->da->EditValue) != "" && is_numeric($this->da->EditValue)) {
                $this->da->EditValue = FormatNumber($this->da->EditValue, null);
            }

            // repairing
            $this->repairing->setupEditAttributes();
            $this->repairing->EditValue = $this->repairing->CurrentValue;
            $this->repairing->PlaceHolder = RemoveHtml($this->repairing->caption());
            if (strval($this->repairing->EditValue) != "" && is_numeric($this->repairing->EditValue)) {
                $this->repairing->EditValue = FormatNumber($this->repairing->EditValue, null);
            }

            // toll
            $this->toll->setupEditAttributes();
            $this->toll->EditValue = $this->toll->CurrentValue;
            $this->toll->PlaceHolder = RemoveHtml($this->toll->caption());
            if (strval($this->toll->EditValue) != "" && is_numeric($this->toll->EditValue)) {
                $this->toll->EditValue = FormatNumber($this->toll->EditValue, null);
            }

            // other
            $this->other->setupEditAttributes();
            $this->other->EditValue = $this->other->CurrentValue;
            $this->other->PlaceHolder = RemoveHtml($this->other->caption());
            if (strval($this->other->EditValue) != "" && is_numeric($this->other->EditValue)) {
                $this->other->EditValue = FormatNumber($this->other->EditValue, null);
            }

            // cash_paid
            $this->cash_paid->setupEditAttributes();
            $this->cash_paid->EditCustomAttributes = $this->cash_paid->getEditCustomAttributes(); // PHP
            $this->cash_paid->EditValue = $this->cash_paid->CurrentValue;
            $this->cash_paid->PlaceHolder = RemoveHtml($this->cash_paid->caption());
            if (strval($this->cash_paid->EditValue) != "" && is_numeric($this->cash_paid->EditValue)) {
                $this->cash_paid->EditValue = FormatNumber($this->cash_paid->EditValue, null);
            }

            // total
            $this->total->setupEditAttributes();
            $this->total->EditCustomAttributes = $this->total->getEditCustomAttributes(); // PHP
            $this->total->EditValue = $this->total->CurrentValue;
            $this->total->PlaceHolder = RemoveHtml($this->total->caption());
            if (strval($this->total->EditValue) != "" && is_numeric($this->total->EditValue)) {
                $this->total->EditValue = FormatNumber($this->total->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                if ($this->RowIndex == '$rowindex$') {
                    $this->uploads->Upload->FileName = "";
                } else {
                    $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
                }
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->uploads->Upload->DbValue = null;
            }
            if (is_numeric($this->RowIndex)) {
                RenderUploadField($this->uploads, $this->RowIndex);
            }

            // operator

            // datetime

            // diesal_lt
            $this->diesal_lt->setupEditAttributes();
            $this->diesal_lt->EditValue = $this->diesal_lt->CurrentValue;
            $this->diesal_lt->PlaceHolder = RemoveHtml($this->diesal_lt->caption());
            if (strval($this->diesal_lt->EditValue) != "" && is_numeric($this->diesal_lt->EditValue)) {
                $this->diesal_lt->EditValue = FormatNumber($this->diesal_lt->EditValue, null);
            }

            // def
            $this->def->setupEditAttributes();
            $this->def->EditValue = $this->def->CurrentValue;
            $this->def->PlaceHolder = RemoveHtml($this->def->caption());
            if (strval($this->def->EditValue) != "" && is_numeric($this->def->EditValue)) {
                $this->def->EditValue = FormatNumber($this->def->EditValue, null);
            }

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // trip
            $this->trip->HrefValue = "";

            // diesal
            $this->diesal->HrefValue = "";

            // border
            $this->border->HrefValue = "";

            // rto
            $this->rto->HrefValue = "";

            // da
            $this->da->HrefValue = "";

            // repairing
            $this->repairing->HrefValue = "";

            // toll
            $this->toll->HrefValue = "";

            // other
            $this->other->HrefValue = "";

            // cash_paid
            $this->cash_paid->HrefValue = "";

            // total
            $this->total->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // diesal_lt
            $this->diesal_lt->HrefValue = "";

            // def
            $this->def->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // trip
            $this->trip->setupEditAttributes();
            $curVal = strval($this->trip->CurrentValue);
            if ($curVal != "") {
                $this->trip->EditValue = $this->trip->lookupCacheOption($curVal);
                if ($this->trip->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->trip->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->trip->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->trip->getSelectFilter($this); // PHP
                    $sqlWrk = $this->trip->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->trip->Lookup->renderViewRow($rswrk[0]);
                        $this->trip->EditValue = $this->trip->displayValue($arwrk);
                    } else {
                        $this->trip->EditValue = FormatNumber($this->trip->CurrentValue, $this->trip->formatPattern());
                    }
                }
            } else {
                $this->trip->EditValue = null;
            }

            // diesal
            $this->diesal->setupEditAttributes();
            $this->diesal->EditValue = $this->diesal->CurrentValue;
            $this->diesal->PlaceHolder = RemoveHtml($this->diesal->caption());
            if (strval($this->diesal->EditValue) != "" && is_numeric($this->diesal->EditValue)) {
                $this->diesal->EditValue = FormatNumber($this->diesal->EditValue, null);
            }

            // border
            $this->border->setupEditAttributes();
            $this->border->EditValue = $this->border->CurrentValue;
            $this->border->PlaceHolder = RemoveHtml($this->border->caption());
            if (strval($this->border->EditValue) != "" && is_numeric($this->border->EditValue)) {
                $this->border->EditValue = FormatNumber($this->border->EditValue, null);
            }

            // rto
            $this->rto->setupEditAttributes();
            $this->rto->EditValue = $this->rto->CurrentValue;
            $this->rto->PlaceHolder = RemoveHtml($this->rto->caption());
            if (strval($this->rto->EditValue) != "" && is_numeric($this->rto->EditValue)) {
                $this->rto->EditValue = FormatNumber($this->rto->EditValue, null);
            }

            // da
            $this->da->setupEditAttributes();
            $this->da->EditValue = $this->da->CurrentValue;
            $this->da->PlaceHolder = RemoveHtml($this->da->caption());
            if (strval($this->da->EditValue) != "" && is_numeric($this->da->EditValue)) {
                $this->da->EditValue = FormatNumber($this->da->EditValue, null);
            }

            // repairing
            $this->repairing->setupEditAttributes();
            $this->repairing->EditValue = $this->repairing->CurrentValue;
            $this->repairing->PlaceHolder = RemoveHtml($this->repairing->caption());
            if (strval($this->repairing->EditValue) != "" && is_numeric($this->repairing->EditValue)) {
                $this->repairing->EditValue = FormatNumber($this->repairing->EditValue, null);
            }

            // toll
            $this->toll->setupEditAttributes();
            $this->toll->EditValue = $this->toll->CurrentValue;
            $this->toll->PlaceHolder = RemoveHtml($this->toll->caption());
            if (strval($this->toll->EditValue) != "" && is_numeric($this->toll->EditValue)) {
                $this->toll->EditValue = FormatNumber($this->toll->EditValue, null);
            }

            // other
            $this->other->setupEditAttributes();
            $this->other->EditValue = $this->other->CurrentValue;
            $this->other->PlaceHolder = RemoveHtml($this->other->caption());
            if (strval($this->other->EditValue) != "" && is_numeric($this->other->EditValue)) {
                $this->other->EditValue = FormatNumber($this->other->EditValue, null);
            }

            // cash_paid
            $this->cash_paid->setupEditAttributes();
            $this->cash_paid->EditCustomAttributes = $this->cash_paid->getEditCustomAttributes(); // PHP
            $this->cash_paid->EditValue = $this->cash_paid->CurrentValue;
            $this->cash_paid->PlaceHolder = RemoveHtml($this->cash_paid->caption());
            if (strval($this->cash_paid->EditValue) != "" && is_numeric($this->cash_paid->EditValue)) {
                $this->cash_paid->EditValue = FormatNumber($this->cash_paid->EditValue, null);
            }

            // total
            $this->total->setupEditAttributes();
            $this->total->EditCustomAttributes = $this->total->getEditCustomAttributes(); // PHP
            $this->total->EditValue = $this->total->CurrentValue;
            $this->total->PlaceHolder = RemoveHtml($this->total->caption());
            if (strval($this->total->EditValue) != "" && is_numeric($this->total->EditValue)) {
                $this->total->EditValue = FormatNumber($this->total->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                if ($this->RowIndex == '$rowindex$') {
                    $this->uploads->Upload->FileName = "";
                } else {
                    $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
                }
            }
            if (is_numeric($this->RowIndex)) {
                RenderUploadField($this->uploads, $this->RowIndex);
            }

            // operator

            // datetime

            // diesal_lt
            $this->diesal_lt->setupEditAttributes();
            $this->diesal_lt->EditValue = $this->diesal_lt->CurrentValue;
            $this->diesal_lt->PlaceHolder = RemoveHtml($this->diesal_lt->caption());
            if (strval($this->diesal_lt->EditValue) != "" && is_numeric($this->diesal_lt->EditValue)) {
                $this->diesal_lt->EditValue = FormatNumber($this->diesal_lt->EditValue, null);
            }

            // def
            $this->def->setupEditAttributes();
            $this->def->EditValue = $this->def->CurrentValue;
            $this->def->PlaceHolder = RemoveHtml($this->def->caption());
            if (strval($this->def->EditValue) != "" && is_numeric($this->def->EditValue)) {
                $this->def->EditValue = FormatNumber($this->def->EditValue, null);
            }

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // trip
            $this->trip->HrefValue = "";
            $this->trip->TooltipValue = "";

            // diesal
            $this->diesal->HrefValue = "";

            // border
            $this->border->HrefValue = "";

            // rto
            $this->rto->HrefValue = "";

            // da
            $this->da->HrefValue = "";

            // repairing
            $this->repairing->HrefValue = "";

            // toll
            $this->toll->HrefValue = "";

            // other
            $this->other->HrefValue = "";

            // cash_paid
            $this->cash_paid->HrefValue = "";

            // total
            $this->total->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // diesal_lt
            $this->diesal_lt->HrefValue = "";

            // def
            $this->def->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->trip->Visible && $this->trip->Required) {
                if (!$this->trip->IsDetailKey && EmptyValue($this->trip->FormValue)) {
                    $this->trip->addErrorMessage(str_replace("%s", $this->trip->caption(), $this->trip->RequiredErrorMessage));
                }
            }
            if ($this->diesal->Visible && $this->diesal->Required) {
                if (!$this->diesal->IsDetailKey && EmptyValue($this->diesal->FormValue)) {
                    $this->diesal->addErrorMessage(str_replace("%s", $this->diesal->caption(), $this->diesal->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->diesal->FormValue)) {
                $this->diesal->addErrorMessage($this->diesal->getErrorMessage(false));
            }
            if ($this->border->Visible && $this->border->Required) {
                if (!$this->border->IsDetailKey && EmptyValue($this->border->FormValue)) {
                    $this->border->addErrorMessage(str_replace("%s", $this->border->caption(), $this->border->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->border->FormValue)) {
                $this->border->addErrorMessage($this->border->getErrorMessage(false));
            }
            if ($this->rto->Visible && $this->rto->Required) {
                if (!$this->rto->IsDetailKey && EmptyValue($this->rto->FormValue)) {
                    $this->rto->addErrorMessage(str_replace("%s", $this->rto->caption(), $this->rto->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->rto->FormValue)) {
                $this->rto->addErrorMessage($this->rto->getErrorMessage(false));
            }
            if ($this->da->Visible && $this->da->Required) {
                if (!$this->da->IsDetailKey && EmptyValue($this->da->FormValue)) {
                    $this->da->addErrorMessage(str_replace("%s", $this->da->caption(), $this->da->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->da->FormValue)) {
                $this->da->addErrorMessage($this->da->getErrorMessage(false));
            }
            if ($this->repairing->Visible && $this->repairing->Required) {
                if (!$this->repairing->IsDetailKey && EmptyValue($this->repairing->FormValue)) {
                    $this->repairing->addErrorMessage(str_replace("%s", $this->repairing->caption(), $this->repairing->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->repairing->FormValue)) {
                $this->repairing->addErrorMessage($this->repairing->getErrorMessage(false));
            }
            if ($this->toll->Visible && $this->toll->Required) {
                if (!$this->toll->IsDetailKey && EmptyValue($this->toll->FormValue)) {
                    $this->toll->addErrorMessage(str_replace("%s", $this->toll->caption(), $this->toll->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->toll->FormValue)) {
                $this->toll->addErrorMessage($this->toll->getErrorMessage(false));
            }
            if ($this->other->Visible && $this->other->Required) {
                if (!$this->other->IsDetailKey && EmptyValue($this->other->FormValue)) {
                    $this->other->addErrorMessage(str_replace("%s", $this->other->caption(), $this->other->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->other->FormValue)) {
                $this->other->addErrorMessage($this->other->getErrorMessage(false));
            }
            if ($this->cash_paid->Visible && $this->cash_paid->Required) {
                if (!$this->cash_paid->IsDetailKey && EmptyValue($this->cash_paid->FormValue)) {
                    $this->cash_paid->addErrorMessage(str_replace("%s", $this->cash_paid->caption(), $this->cash_paid->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->cash_paid->FormValue)) {
                $this->cash_paid->addErrorMessage($this->cash_paid->getErrorMessage(false));
            }
            if ($this->total->Visible && $this->total->Required) {
                if (!$this->total->IsDetailKey && EmptyValue($this->total->FormValue)) {
                    $this->total->addErrorMessage(str_replace("%s", $this->total->caption(), $this->total->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->total->FormValue)) {
                $this->total->addErrorMessage($this->total->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->dated->Visible && $this->dated->Required) {
                if (!$this->dated->IsDetailKey && EmptyValue($this->dated->FormValue)) {
                    $this->dated->addErrorMessage(str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dated->FormValue, $this->dated->formatPattern())) {
                $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
            }
            if ($this->uploads->Visible && $this->uploads->Required) {
                if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->addErrorMessage(str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->diesal_lt->Visible && $this->diesal_lt->Required) {
                if (!$this->diesal_lt->IsDetailKey && EmptyValue($this->diesal_lt->FormValue)) {
                    $this->diesal_lt->addErrorMessage(str_replace("%s", $this->diesal_lt->caption(), $this->diesal_lt->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->diesal_lt->FormValue)) {
                $this->diesal_lt->addErrorMessage($this->diesal_lt->getErrorMessage(false));
            }
            if ($this->def->Visible && $this->def->Required) {
                if (!$this->def->IsDetailKey && EmptyValue($this->def->FormValue)) {
                    $this->def->addErrorMessage(str_replace("%s", $this->def->caption(), $this->def->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->def->FormValue)) {
                $this->def->addErrorMessage($this->def->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (trip)
        if ($this->trip->CurrentValue != "") {
            $filterChk = "(`trip` = " . AdjustSql($this->trip->CurrentValue, $this->Dbid) . ")";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->trip->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->trip->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            $this->uploads->UploadPath = $this->uploads->getUploadPath();
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, $this->uploads->ReadOnly);
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $this->uploads->UploadPath = $this->uploads->OldUploadPath;
        $rsnew = [];

        // diesal
        $this->diesal->setDbValueDef($rsnew, $this->diesal->CurrentValue, $this->diesal->ReadOnly);

        // border
        $this->border->setDbValueDef($rsnew, $this->border->CurrentValue, $this->border->ReadOnly);

        // rto
        $this->rto->setDbValueDef($rsnew, $this->rto->CurrentValue, $this->rto->ReadOnly);

        // da
        $this->da->setDbValueDef($rsnew, $this->da->CurrentValue, $this->da->ReadOnly);

        // repairing
        $this->repairing->setDbValueDef($rsnew, $this->repairing->CurrentValue, $this->repairing->ReadOnly);

        // toll
        $this->toll->setDbValueDef($rsnew, $this->toll->CurrentValue, $this->toll->ReadOnly);

        // other
        $this->other->setDbValueDef($rsnew, $this->other->CurrentValue, $this->other->ReadOnly);

        // cash_paid
        $this->cash_paid->setDbValueDef($rsnew, $this->cash_paid->CurrentValue, $this->cash_paid->ReadOnly);

        // total
        $this->total->setDbValueDef($rsnew, $this->total->CurrentValue, $this->total->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // dated
        $this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()), $this->dated->ReadOnly);

        // uploads
        if ($this->uploads->Visible && !$this->uploads->ReadOnly && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 0; // Resize width
            $this->uploads->ImageHeight = 640; // Resize height
        }

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // diesal_lt
        $this->diesal_lt->setDbValueDef($rsnew, $this->diesal_lt->CurrentValue, $this->diesal_lt->ReadOnly);

        // def
        $this->def->setDbValueDef($rsnew, $this->def->CurrentValue, $this->def->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['diesal'])) { // diesal
            $this->diesal->CurrentValue = $row['diesal'];
        }
        if (isset($row['border'])) { // border
            $this->border->CurrentValue = $row['border'];
        }
        if (isset($row['rto'])) { // rto
            $this->rto->CurrentValue = $row['rto'];
        }
        if (isset($row['da'])) { // da
            $this->da->CurrentValue = $row['da'];
        }
        if (isset($row['repairing'])) { // repairing
            $this->repairing->CurrentValue = $row['repairing'];
        }
        if (isset($row['toll'])) { // toll
            $this->toll->CurrentValue = $row['toll'];
        }
        if (isset($row['other'])) { // other
            $this->other->CurrentValue = $row['other'];
        }
        if (isset($row['cash_paid'])) { // cash_paid
            $this->cash_paid->CurrentValue = $row['cash_paid'];
        }
        if (isset($row['total'])) { // total
            $this->total->CurrentValue = $row['total'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['dated'])) { // dated
            $this->dated->CurrentValue = $row['dated'];
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->CurrentValue = $row['uploads'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['diesal_lt'])) { // diesal_lt
            $this->diesal_lt->CurrentValue = $row['diesal_lt'];
        }
        if (isset($row['def'])) { // def
            $this->def->CurrentValue = $row['def'];
        }
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set up foreign key field value from Session
        if ($this->getCurrentMasterTable() == "t_trip_expenses_report") {
            $this->trip->Visible = true; // Need to insert foreign key
            $this->trip->CurrentValue = $this->trip->getSessionValue();
        }

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            $this->uploads->UploadPath = $this->uploads->getUploadPath();
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                $this->uploads->Upload->DbValue = null;
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->trip->CurrentValue != "") { // Check field with unique index
            $filter = "(`trip` = " . AdjustSql($this->trip->CurrentValue, $this->Dbid) . ")";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->trip->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->trip->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $this->uploads->UploadPath = $this->uploads->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // trip
        $this->trip->setDbValueDef($rsnew, $this->trip->CurrentValue, false);

        // diesal
        $this->diesal->setDbValueDef($rsnew, $this->diesal->CurrentValue, strval($this->diesal->CurrentValue) == "");

        // border
        $this->border->setDbValueDef($rsnew, $this->border->CurrentValue, strval($this->border->CurrentValue) == "");

        // rto
        $this->rto->setDbValueDef($rsnew, $this->rto->CurrentValue, strval($this->rto->CurrentValue) == "");

        // da
        $this->da->setDbValueDef($rsnew, $this->da->CurrentValue, strval($this->da->CurrentValue) == "");

        // repairing
        $this->repairing->setDbValueDef($rsnew, $this->repairing->CurrentValue, strval($this->repairing->CurrentValue) == "");

        // toll
        $this->toll->setDbValueDef($rsnew, $this->toll->CurrentValue, strval($this->toll->CurrentValue) == "");

        // other
        $this->other->setDbValueDef($rsnew, $this->other->CurrentValue, strval($this->other->CurrentValue) == "");

        // cash_paid
        $this->cash_paid->setDbValueDef($rsnew, $this->cash_paid->CurrentValue, false);

        // total
        $this->total->setDbValueDef($rsnew, $this->total->CurrentValue, strval($this->total->CurrentValue) == "");

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // dated
        $this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()), false);

        // uploads
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 0; // Resize width
            $this->uploads->ImageHeight = 640; // Resize height
        }

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // diesal_lt
        $this->diesal_lt->setDbValueDef($rsnew, $this->diesal_lt->CurrentValue, strval($this->diesal_lt->CurrentValue) == "");

        // def
        $this->def->setDbValueDef($rsnew, $this->def->CurrentValue, strval($this->def->CurrentValue) == "");
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['trip'])) { // trip
            $this->trip->setFormValue($row['trip']);
        }
        if (isset($row['diesal'])) { // diesal
            $this->diesal->setFormValue($row['diesal']);
        }
        if (isset($row['border'])) { // border
            $this->border->setFormValue($row['border']);
        }
        if (isset($row['rto'])) { // rto
            $this->rto->setFormValue($row['rto']);
        }
        if (isset($row['da'])) { // da
            $this->da->setFormValue($row['da']);
        }
        if (isset($row['repairing'])) { // repairing
            $this->repairing->setFormValue($row['repairing']);
        }
        if (isset($row['toll'])) { // toll
            $this->toll->setFormValue($row['toll']);
        }
        if (isset($row['other'])) { // other
            $this->other->setFormValue($row['other']);
        }
        if (isset($row['cash_paid'])) { // cash_paid
            $this->cash_paid->setFormValue($row['cash_paid']);
        }
        if (isset($row['total'])) { // total
            $this->total->setFormValue($row['total']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['dated'])) { // dated
            $this->dated->setFormValue($row['dated']);
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->setFormValue($row['uploads']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['diesal_lt'])) { // diesal_lt
            $this->diesal_lt->setFormValue($row['diesal_lt']);
        }
        if (isset($row['def'])) { // def
            $this->def->setFormValue($row['def']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        // Hide foreign keys
        $masterTblVar = $this->getCurrentMasterTable();
        if ($masterTblVar == "t_trip_expenses_report") {
            $masterTbl = Container("t_trip_expenses_report");
            $this->trip->Visible = false;
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_trip":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }
}
