<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class TExpensesAdd extends TExpenses
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TExpensesAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "texpensesadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->trip->setVisibility();
        $this->diesal->setVisibility();
        $this->border->setVisibility();
        $this->rto->setVisibility();
        $this->da->setVisibility();
        $this->repairing->setVisibility();
        $this->toll->setVisibility();
        $this->other->setVisibility();
        $this->cash_paid->setVisibility();
        $this->total->setVisibility();
        $this->remarks->setVisibility();
        $this->dated->setVisibility();
        $this->uploads->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->diesal_lt->setVisibility();
        $this->def->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 't_expenses';
        $this->TableName = 't_expenses';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (t_expenses)
        if (!isset($GLOBALS["t_expenses"]) || $GLOBALS["t_expenses"]::class == PROJECT_NAMESPACE . "t_expenses") {
            $GLOBALS["t_expenses"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 't_expenses');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "texpensesview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->trip);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: Must be after loadOldRecord to prevent master key values being overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("texpenseslist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "texpenseslist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "texpensesview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions && !$this->getCurrentMasterTable()) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "texpenseslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "texpenseslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->uploads->Upload->Index = $CurrentForm->Index;
        $this->uploads->Upload->uploadFile();
        $this->uploads->CurrentValue = $this->uploads->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->diesal->DefaultValue = $this->diesal->getDefault(); // PHP
        $this->diesal->OldValue = $this->diesal->DefaultValue;
        $this->border->DefaultValue = $this->border->getDefault(); // PHP
        $this->border->OldValue = $this->border->DefaultValue;
        $this->rto->DefaultValue = $this->rto->getDefault(); // PHP
        $this->rto->OldValue = $this->rto->DefaultValue;
        $this->da->DefaultValue = $this->da->getDefault(); // PHP
        $this->da->OldValue = $this->da->DefaultValue;
        $this->repairing->DefaultValue = $this->repairing->getDefault(); // PHP
        $this->repairing->OldValue = $this->repairing->DefaultValue;
        $this->toll->DefaultValue = $this->toll->getDefault(); // PHP
        $this->toll->OldValue = $this->toll->DefaultValue;
        $this->other->DefaultValue = $this->other->getDefault(); // PHP
        $this->other->OldValue = $this->other->DefaultValue;
        $this->total->DefaultValue = $this->total->getDefault(); // PHP
        $this->total->OldValue = $this->total->DefaultValue;
        $this->dated->DefaultValue = $this->dated->getDefault(); // PHP
        $this->dated->OldValue = $this->dated->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->diesal_lt->DefaultValue = $this->diesal_lt->getDefault(); // PHP
        $this->diesal_lt->OldValue = $this->diesal_lt->DefaultValue;
        $this->def->DefaultValue = $this->def->getDefault(); // PHP
        $this->def->OldValue = $this->def->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'trip' first before field var 'x_trip'
        $val = $CurrentForm->hasValue("trip") ? $CurrentForm->getValue("trip") : $CurrentForm->getValue("x_trip");
        if (!$this->trip->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->trip->Visible = false; // Disable update for API request
            } else {
                $this->trip->setFormValue($val);
            }
        }

        // Check field name 'diesal' first before field var 'x_diesal'
        $val = $CurrentForm->hasValue("diesal") ? $CurrentForm->getValue("diesal") : $CurrentForm->getValue("x_diesal");
        if (!$this->diesal->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diesal->Visible = false; // Disable update for API request
            } else {
                $this->diesal->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'border' first before field var 'x_border'
        $val = $CurrentForm->hasValue("border") ? $CurrentForm->getValue("border") : $CurrentForm->getValue("x_border");
        if (!$this->border->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->border->Visible = false; // Disable update for API request
            } else {
                $this->border->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'rto' first before field var 'x_rto'
        $val = $CurrentForm->hasValue("rto") ? $CurrentForm->getValue("rto") : $CurrentForm->getValue("x_rto");
        if (!$this->rto->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rto->Visible = false; // Disable update for API request
            } else {
                $this->rto->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'da' first before field var 'x_da'
        $val = $CurrentForm->hasValue("da") ? $CurrentForm->getValue("da") : $CurrentForm->getValue("x_da");
        if (!$this->da->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->da->Visible = false; // Disable update for API request
            } else {
                $this->da->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'repairing' first before field var 'x_repairing'
        $val = $CurrentForm->hasValue("repairing") ? $CurrentForm->getValue("repairing") : $CurrentForm->getValue("x_repairing");
        if (!$this->repairing->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->repairing->Visible = false; // Disable update for API request
            } else {
                $this->repairing->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'toll' first before field var 'x_toll'
        $val = $CurrentForm->hasValue("toll") ? $CurrentForm->getValue("toll") : $CurrentForm->getValue("x_toll");
        if (!$this->toll->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->toll->Visible = false; // Disable update for API request
            } else {
                $this->toll->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'other' first before field var 'x_other'
        $val = $CurrentForm->hasValue("other") ? $CurrentForm->getValue("other") : $CurrentForm->getValue("x_other");
        if (!$this->other->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->other->Visible = false; // Disable update for API request
            } else {
                $this->other->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'cash_paid' first before field var 'x_cash_paid'
        $val = $CurrentForm->hasValue("cash_paid") ? $CurrentForm->getValue("cash_paid") : $CurrentForm->getValue("x_cash_paid");
        if (!$this->cash_paid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cash_paid->Visible = false; // Disable update for API request
            } else {
                $this->cash_paid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'total' first before field var 'x_total'
        $val = $CurrentForm->hasValue("total") ? $CurrentForm->getValue("total") : $CurrentForm->getValue("x_total");
        if (!$this->total->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->total->Visible = false; // Disable update for API request
            } else {
                $this->total->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'dated' first before field var 'x_dated'
        $val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
        if (!$this->dated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dated->Visible = false; // Disable update for API request
            } else {
                $this->dated->setFormValue($val, true, $validate);
            }
            $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'diesal_lt' first before field var 'x_diesal_lt'
        $val = $CurrentForm->hasValue("diesal_lt") ? $CurrentForm->getValue("diesal_lt") : $CurrentForm->getValue("x_diesal_lt");
        if (!$this->diesal_lt->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->diesal_lt->Visible = false; // Disable update for API request
            } else {
                $this->diesal_lt->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'def' first before field var 'x_def'
        $val = $CurrentForm->hasValue("def") ? $CurrentForm->getValue("def") : $CurrentForm->getValue("x_def");
        if (!$this->def->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->def->Visible = false; // Disable update for API request
            } else {
                $this->def->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
		$this->uploads->UploadPath = $this->uploads->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->trip->CurrentValue = $this->trip->FormValue;
        $this->diesal->CurrentValue = $this->diesal->FormValue;
        $this->border->CurrentValue = $this->border->FormValue;
        $this->rto->CurrentValue = $this->rto->FormValue;
        $this->da->CurrentValue = $this->da->FormValue;
        $this->repairing->CurrentValue = $this->repairing->FormValue;
        $this->toll->CurrentValue = $this->toll->FormValue;
        $this->other->CurrentValue = $this->other->FormValue;
        $this->cash_paid->CurrentValue = $this->cash_paid->FormValue;
        $this->total->CurrentValue = $this->total->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->dated->CurrentValue = $this->dated->FormValue;
        $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->diesal_lt->CurrentValue = $this->diesal_lt->FormValue;
        $this->def->CurrentValue = $this->def->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->trip->setDbValue($row['trip']);
        $this->diesal->setDbValue($row['diesal']);
        $this->border->setDbValue($row['border']);
        $this->rto->setDbValue($row['rto']);
        $this->da->setDbValue($row['da']);
        $this->repairing->setDbValue($row['repairing']);
        $this->toll->setDbValue($row['toll']);
        $this->other->setDbValue($row['other']);
        $this->cash_paid->setDbValue($row['cash_paid']);
        $this->total->setDbValue($row['total']);
        $this->remarks->setDbValue($row['remarks']);
        $this->dated->setDbValue($row['dated']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->diesal_lt->setDbValue($row['diesal_lt']);
        $this->def->setDbValue($row['def']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['trip'] = $this->trip->DefaultValue;
        $row['diesal'] = $this->diesal->DefaultValue;
        $row['border'] = $this->border->DefaultValue;
        $row['rto'] = $this->rto->DefaultValue;
        $row['da'] = $this->da->DefaultValue;
        $row['repairing'] = $this->repairing->DefaultValue;
        $row['toll'] = $this->toll->DefaultValue;
        $row['other'] = $this->other->DefaultValue;
        $row['cash_paid'] = $this->cash_paid->DefaultValue;
        $row['total'] = $this->total->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['diesal_lt'] = $this->diesal_lt->DefaultValue;
        $row['def'] = $this->def->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // trip
        $this->trip->RowCssClass = "row";

        // diesal
        $this->diesal->RowCssClass = "row";

        // border
        $this->border->RowCssClass = "row";

        // rto
        $this->rto->RowCssClass = "row";

        // da
        $this->da->RowCssClass = "row";

        // repairing
        $this->repairing->RowCssClass = "row";

        // toll
        $this->toll->RowCssClass = "row";

        // other
        $this->other->RowCssClass = "row";

        // cash_paid
        $this->cash_paid->RowCssClass = "row";

        // total
        $this->total->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // diesal_lt
        $this->diesal_lt->RowCssClass = "row";

        // def
        $this->def->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // trip
            $curVal = strval($this->trip->CurrentValue);
            if ($curVal != "") {
                $this->trip->ViewValue = $this->trip->lookupCacheOption($curVal);
                if ($this->trip->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->trip->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->trip->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->trip->getSelectFilter($this); // PHP
                    $sqlWrk = $this->trip->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->trip->Lookup->renderViewRow($rswrk[0]);
                        $this->trip->ViewValue = $this->trip->displayValue($arwrk);
                    } else {
                        $this->trip->ViewValue = FormatNumber($this->trip->CurrentValue, $this->trip->formatPattern());
                    }
                }
            } else {
                $this->trip->ViewValue = null;
            }

            // diesal
            $this->diesal->ViewValue = $this->diesal->CurrentValue;
            $this->diesal->ViewValue = FormatNumber($this->diesal->ViewValue, $this->diesal->formatPattern());

            // border
            $this->border->ViewValue = $this->border->CurrentValue;
            $this->border->ViewValue = FormatNumber($this->border->ViewValue, $this->border->formatPattern());

            // rto
            $this->rto->ViewValue = $this->rto->CurrentValue;
            $this->rto->ViewValue = FormatNumber($this->rto->ViewValue, $this->rto->formatPattern());

            // da
            $this->da->ViewValue = $this->da->CurrentValue;
            $this->da->ViewValue = FormatNumber($this->da->ViewValue, $this->da->formatPattern());

            // repairing
            $this->repairing->ViewValue = $this->repairing->CurrentValue;
            $this->repairing->ViewValue = FormatNumber($this->repairing->ViewValue, $this->repairing->formatPattern());

            // toll
            $this->toll->ViewValue = $this->toll->CurrentValue;
            $this->toll->ViewValue = FormatNumber($this->toll->ViewValue, $this->toll->formatPattern());

            // other
            $this->other->ViewValue = $this->other->CurrentValue;
            $this->other->ViewValue = FormatNumber($this->other->ViewValue, $this->other->formatPattern());

            // cash_paid
            $this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
            $this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, $this->cash_paid->formatPattern());

            // total
            $this->total->ViewValue = $this->total->CurrentValue;
            $this->total->ViewValue = FormatNumber($this->total->ViewValue, $this->total->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // diesal_lt
            $this->diesal_lt->ViewValue = $this->diesal_lt->CurrentValue;
            $this->diesal_lt->ViewValue = FormatNumber($this->diesal_lt->ViewValue, $this->diesal_lt->formatPattern());

            // def
            $this->def->ViewValue = $this->def->CurrentValue;
            $this->def->ViewValue = FormatNumber($this->def->ViewValue, $this->def->formatPattern());

            // trip
            $this->trip->HrefValue = "";
            $this->trip->TooltipValue = "";

            // diesal
            $this->diesal->HrefValue = "";

            // border
            $this->border->HrefValue = "";

            // rto
            $this->rto->HrefValue = "";

            // da
            $this->da->HrefValue = "";

            // repairing
            $this->repairing->HrefValue = "";

            // toll
            $this->toll->HrefValue = "";

            // other
            $this->other->HrefValue = "";

            // cash_paid
            $this->cash_paid->HrefValue = "";

            // total
            $this->total->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // diesal_lt
            $this->diesal_lt->HrefValue = "";

            // def
            $this->def->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // trip
            $this->trip->setupEditAttributes();
            if ($this->trip->getSessionValue() != "") {
                $this->trip->CurrentValue = GetForeignKeyValue($this->trip->getSessionValue());
                $curVal = strval($this->trip->CurrentValue);
                if ($curVal != "") {
                    $this->trip->ViewValue = $this->trip->lookupCacheOption($curVal);
                    if ($this->trip->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->trip->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->trip->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $lookupFilter = $this->trip->getSelectFilter($this); // PHP
                        $sqlWrk = $this->trip->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->trip->Lookup->renderViewRow($rswrk[0]);
                            $this->trip->ViewValue = $this->trip->displayValue($arwrk);
                        } else {
                            $this->trip->ViewValue = FormatNumber($this->trip->CurrentValue, $this->trip->formatPattern());
                        }
                    }
                } else {
                    $this->trip->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->trip->CurrentValue));
                if ($curVal != "") {
                    $this->trip->ViewValue = $this->trip->lookupCacheOption($curVal);
                } else {
                    $this->trip->ViewValue = $this->trip->Lookup !== null && is_array($this->trip->lookupOptions()) && count($this->trip->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->trip->ViewValue !== null) { // Load from cache
                    $this->trip->EditValue = array_values($this->trip->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->trip->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->trip->CurrentValue, $this->trip->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->trip->getSelectFilter($this); // PHP
                    $sqlWrk = $this->trip->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->trip->EditValue = $arwrk;
                }
                $this->trip->PlaceHolder = RemoveHtml($this->trip->caption());
            }

            // diesal
            $this->diesal->setupEditAttributes();
            $this->diesal->EditValue = $this->diesal->CurrentValue;
            $this->diesal->PlaceHolder = RemoveHtml($this->diesal->caption());
            if (strval($this->diesal->EditValue) != "" && is_numeric($this->diesal->EditValue)) {
                $this->diesal->EditValue = FormatNumber($this->diesal->EditValue, null);
            }

            // border
            $this->border->setupEditAttributes();
            $this->border->EditValue = $this->border->CurrentValue;
            $this->border->PlaceHolder = RemoveHtml($this->border->caption());
            if (strval($this->border->EditValue) != "" && is_numeric($this->border->EditValue)) {
                $this->border->EditValue = FormatNumber($this->border->EditValue, null);
            }

            // rto
            $this->rto->setupEditAttributes();
            $this->rto->EditValue = $this->rto->CurrentValue;
            $this->rto->PlaceHolder = RemoveHtml($this->rto->caption());
            if (strval($this->rto->EditValue) != "" && is_numeric($this->rto->EditValue)) {
                $this->rto->EditValue = FormatNumber($this->rto->EditValue, null);
            }

            // da
            $this->da->setupEditAttributes();
            $this->da->EditValue = $this->da->CurrentValue;
            $this->da->PlaceHolder = RemoveHtml($this->da->caption());
            if (strval($this->da->EditValue) != "" && is_numeric($this->da->EditValue)) {
                $this->da->EditValue = FormatNumber($this->da->EditValue, null);
            }

            // repairing
            $this->repairing->setupEditAttributes();
            $this->repairing->EditValue = $this->repairing->CurrentValue;
            $this->repairing->PlaceHolder = RemoveHtml($this->repairing->caption());
            if (strval($this->repairing->EditValue) != "" && is_numeric($this->repairing->EditValue)) {
                $this->repairing->EditValue = FormatNumber($this->repairing->EditValue, null);
            }

            // toll
            $this->toll->setupEditAttributes();
            $this->toll->EditValue = $this->toll->CurrentValue;
            $this->toll->PlaceHolder = RemoveHtml($this->toll->caption());
            if (strval($this->toll->EditValue) != "" && is_numeric($this->toll->EditValue)) {
                $this->toll->EditValue = FormatNumber($this->toll->EditValue, null);
            }

            // other
            $this->other->setupEditAttributes();
            $this->other->EditValue = $this->other->CurrentValue;
            $this->other->PlaceHolder = RemoveHtml($this->other->caption());
            if (strval($this->other->EditValue) != "" && is_numeric($this->other->EditValue)) {
                $this->other->EditValue = FormatNumber($this->other->EditValue, null);
            }

            // cash_paid
            $this->cash_paid->setupEditAttributes();
            $this->cash_paid->EditCustomAttributes = $this->cash_paid->getEditCustomAttributes(); // PHP
            $this->cash_paid->EditValue = $this->cash_paid->CurrentValue;
            $this->cash_paid->PlaceHolder = RemoveHtml($this->cash_paid->caption());
            if (strval($this->cash_paid->EditValue) != "" && is_numeric($this->cash_paid->EditValue)) {
                $this->cash_paid->EditValue = FormatNumber($this->cash_paid->EditValue, null);
            }

            // total
            $this->total->setupEditAttributes();
            $this->total->EditCustomAttributes = $this->total->getEditCustomAttributes(); // PHP
            $this->total->EditValue = $this->total->CurrentValue;
            $this->total->PlaceHolder = RemoveHtml($this->total->caption());
            if (strval($this->total->EditValue) != "" && is_numeric($this->total->EditValue)) {
                $this->total->EditValue = FormatNumber($this->total->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->uploads->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->uploads);
            }

            // operator

            // datetime

            // diesal_lt
            $this->diesal_lt->setupEditAttributes();
            $this->diesal_lt->EditValue = $this->diesal_lt->CurrentValue;
            $this->diesal_lt->PlaceHolder = RemoveHtml($this->diesal_lt->caption());
            if (strval($this->diesal_lt->EditValue) != "" && is_numeric($this->diesal_lt->EditValue)) {
                $this->diesal_lt->EditValue = FormatNumber($this->diesal_lt->EditValue, null);
            }

            // def
            $this->def->setupEditAttributes();
            $this->def->EditValue = $this->def->CurrentValue;
            $this->def->PlaceHolder = RemoveHtml($this->def->caption());
            if (strval($this->def->EditValue) != "" && is_numeric($this->def->EditValue)) {
                $this->def->EditValue = FormatNumber($this->def->EditValue, null);
            }

            // Add refer script

            // trip
            $this->trip->HrefValue = "";

            // diesal
            $this->diesal->HrefValue = "";

            // border
            $this->border->HrefValue = "";

            // rto
            $this->rto->HrefValue = "";

            // da
            $this->da->HrefValue = "";

            // repairing
            $this->repairing->HrefValue = "";

            // toll
            $this->toll->HrefValue = "";

            // other
            $this->other->HrefValue = "";

            // cash_paid
            $this->cash_paid->HrefValue = "";

            // total
            $this->total->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // diesal_lt
            $this->diesal_lt->HrefValue = "";

            // def
            $this->def->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->trip->Visible && $this->trip->Required) {
                if (!$this->trip->IsDetailKey && EmptyValue($this->trip->FormValue)) {
                    $this->trip->addErrorMessage(str_replace("%s", $this->trip->caption(), $this->trip->RequiredErrorMessage));
                }
            }
            if ($this->diesal->Visible && $this->diesal->Required) {
                if (!$this->diesal->IsDetailKey && EmptyValue($this->diesal->FormValue)) {
                    $this->diesal->addErrorMessage(str_replace("%s", $this->diesal->caption(), $this->diesal->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->diesal->FormValue)) {
                $this->diesal->addErrorMessage($this->diesal->getErrorMessage(false));
            }
            if ($this->border->Visible && $this->border->Required) {
                if (!$this->border->IsDetailKey && EmptyValue($this->border->FormValue)) {
                    $this->border->addErrorMessage(str_replace("%s", $this->border->caption(), $this->border->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->border->FormValue)) {
                $this->border->addErrorMessage($this->border->getErrorMessage(false));
            }
            if ($this->rto->Visible && $this->rto->Required) {
                if (!$this->rto->IsDetailKey && EmptyValue($this->rto->FormValue)) {
                    $this->rto->addErrorMessage(str_replace("%s", $this->rto->caption(), $this->rto->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->rto->FormValue)) {
                $this->rto->addErrorMessage($this->rto->getErrorMessage(false));
            }
            if ($this->da->Visible && $this->da->Required) {
                if (!$this->da->IsDetailKey && EmptyValue($this->da->FormValue)) {
                    $this->da->addErrorMessage(str_replace("%s", $this->da->caption(), $this->da->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->da->FormValue)) {
                $this->da->addErrorMessage($this->da->getErrorMessage(false));
            }
            if ($this->repairing->Visible && $this->repairing->Required) {
                if (!$this->repairing->IsDetailKey && EmptyValue($this->repairing->FormValue)) {
                    $this->repairing->addErrorMessage(str_replace("%s", $this->repairing->caption(), $this->repairing->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->repairing->FormValue)) {
                $this->repairing->addErrorMessage($this->repairing->getErrorMessage(false));
            }
            if ($this->toll->Visible && $this->toll->Required) {
                if (!$this->toll->IsDetailKey && EmptyValue($this->toll->FormValue)) {
                    $this->toll->addErrorMessage(str_replace("%s", $this->toll->caption(), $this->toll->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->toll->FormValue)) {
                $this->toll->addErrorMessage($this->toll->getErrorMessage(false));
            }
            if ($this->other->Visible && $this->other->Required) {
                if (!$this->other->IsDetailKey && EmptyValue($this->other->FormValue)) {
                    $this->other->addErrorMessage(str_replace("%s", $this->other->caption(), $this->other->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->other->FormValue)) {
                $this->other->addErrorMessage($this->other->getErrorMessage(false));
            }
            if ($this->cash_paid->Visible && $this->cash_paid->Required) {
                if (!$this->cash_paid->IsDetailKey && EmptyValue($this->cash_paid->FormValue)) {
                    $this->cash_paid->addErrorMessage(str_replace("%s", $this->cash_paid->caption(), $this->cash_paid->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->cash_paid->FormValue)) {
                $this->cash_paid->addErrorMessage($this->cash_paid->getErrorMessage(false));
            }
            if ($this->total->Visible && $this->total->Required) {
                if (!$this->total->IsDetailKey && EmptyValue($this->total->FormValue)) {
                    $this->total->addErrorMessage(str_replace("%s", $this->total->caption(), $this->total->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->total->FormValue)) {
                $this->total->addErrorMessage($this->total->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->dated->Visible && $this->dated->Required) {
                if (!$this->dated->IsDetailKey && EmptyValue($this->dated->FormValue)) {
                    $this->dated->addErrorMessage(str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dated->FormValue, $this->dated->formatPattern())) {
                $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
            }
            if ($this->uploads->Visible && $this->uploads->Required) {
                if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->addErrorMessage(str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->diesal_lt->Visible && $this->diesal_lt->Required) {
                if (!$this->diesal_lt->IsDetailKey && EmptyValue($this->diesal_lt->FormValue)) {
                    $this->diesal_lt->addErrorMessage(str_replace("%s", $this->diesal_lt->caption(), $this->diesal_lt->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->diesal_lt->FormValue)) {
                $this->diesal_lt->addErrorMessage($this->diesal_lt->getErrorMessage(false));
            }
            if ($this->def->Visible && $this->def->Required) {
                if (!$this->def->IsDetailKey && EmptyValue($this->def->FormValue)) {
                    $this->def->addErrorMessage(str_replace("%s", $this->def->caption(), $this->def->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->def->FormValue)) {
                $this->def->addErrorMessage($this->def->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            $this->uploads->UploadPath = $this->uploads->getUploadPath();
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                $this->uploads->Upload->DbValue = null;
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->trip->CurrentValue != "") { // Check field with unique index
            $filter = "(`trip` = " . AdjustSql($this->trip->CurrentValue, $this->Dbid) . ")";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->trip->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->trip->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $this->uploads->UploadPath = $this->uploads->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // trip
        $this->trip->setDbValueDef($rsnew, $this->trip->CurrentValue, false);

        // diesal
        $this->diesal->setDbValueDef($rsnew, $this->diesal->CurrentValue, strval($this->diesal->CurrentValue) == "");

        // border
        $this->border->setDbValueDef($rsnew, $this->border->CurrentValue, strval($this->border->CurrentValue) == "");

        // rto
        $this->rto->setDbValueDef($rsnew, $this->rto->CurrentValue, strval($this->rto->CurrentValue) == "");

        // da
        $this->da->setDbValueDef($rsnew, $this->da->CurrentValue, strval($this->da->CurrentValue) == "");

        // repairing
        $this->repairing->setDbValueDef($rsnew, $this->repairing->CurrentValue, strval($this->repairing->CurrentValue) == "");

        // toll
        $this->toll->setDbValueDef($rsnew, $this->toll->CurrentValue, strval($this->toll->CurrentValue) == "");

        // other
        $this->other->setDbValueDef($rsnew, $this->other->CurrentValue, strval($this->other->CurrentValue) == "");

        // cash_paid
        $this->cash_paid->setDbValueDef($rsnew, $this->cash_paid->CurrentValue, false);

        // total
        $this->total->setDbValueDef($rsnew, $this->total->CurrentValue, strval($this->total->CurrentValue) == "");

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // dated
        $this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()), false);

        // uploads
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 0; // Resize width
            $this->uploads->ImageHeight = 640; // Resize height
        }

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // diesal_lt
        $this->diesal_lt->setDbValueDef($rsnew, $this->diesal_lt->CurrentValue, strval($this->diesal_lt->CurrentValue) == "");

        // def
        $this->def->setDbValueDef($rsnew, $this->def->CurrentValue, strval($this->def->CurrentValue) == "");
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['trip'])) { // trip
            $this->trip->setFormValue($row['trip']);
        }
        if (isset($row['diesal'])) { // diesal
            $this->diesal->setFormValue($row['diesal']);
        }
        if (isset($row['border'])) { // border
            $this->border->setFormValue($row['border']);
        }
        if (isset($row['rto'])) { // rto
            $this->rto->setFormValue($row['rto']);
        }
        if (isset($row['da'])) { // da
            $this->da->setFormValue($row['da']);
        }
        if (isset($row['repairing'])) { // repairing
            $this->repairing->setFormValue($row['repairing']);
        }
        if (isset($row['toll'])) { // toll
            $this->toll->setFormValue($row['toll']);
        }
        if (isset($row['other'])) { // other
            $this->other->setFormValue($row['other']);
        }
        if (isset($row['cash_paid'])) { // cash_paid
            $this->cash_paid->setFormValue($row['cash_paid']);
        }
        if (isset($row['total'])) { // total
            $this->total->setFormValue($row['total']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['dated'])) { // dated
            $this->dated->setFormValue($row['dated']);
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->setFormValue($row['uploads']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['diesal_lt'])) { // diesal_lt
            $this->diesal_lt->setFormValue($row['diesal_lt']);
        }
        if (isset($row['def'])) { // def
            $this->def->setFormValue($row['def']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "t_trip_expenses_report") {
                $validMaster = true;
                $masterTbl = Container("t_trip_expenses_report");
                if (($parm = Get("fk_trip", Get("trip"))) !== null) {
                    $masterTbl->trip->setQueryStringValue($parm);
                    $this->trip->QueryStringValue = $masterTbl->trip->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->trip->setSessionValue($this->trip->QueryStringValue);
                    $foreignKeys["trip"] = $this->trip->QueryStringValue;
                    if (!is_numeric($masterTbl->trip->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "t_trip_expenses_report") {
                $validMaster = true;
                $masterTbl = Container("t_trip_expenses_report");
                if (($parm = Post("fk_trip", Post("trip"))) !== null) {
                    $masterTbl->trip->setFormValue($parm);
                    $this->trip->FormValue = $masterTbl->trip->FormValue;
                    $this->trip->setSessionValue($this->trip->FormValue);
                    $foreignKeys["trip"] = $this->trip->FormValue;
                    if (!is_numeric($masterTbl->trip->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "t_trip_expenses_report") {
                if (!array_key_exists("trip", $foreignKeys)) { // Not current foreign key
                    $this->trip->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("texpenseslist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_trip":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
