<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class StockProcessingJobSearch extends StockProcessingJob
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "StockProcessingJobSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "stockprocessingjobsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->product->setVisibility();
        $this->product_code->setVisibility();
        $this->lot_no->setVisibility();
        $this->packing_type->setVisibility();
        $this->tmp_lot->setVisibility();
        $this->gcode->setVisibility();
        $this->dated->setVisibility();
        $this->IN->setVisibility();
        $this->OUT->setVisibility();
        $this->Balance->setVisibility();
        $this->Item->setVisibility();
        $this->new_process->setVisibility();
        $this->avg_yield->setVisibility();
        $this->remarks->setVisibility();
        $this->status->setVisibility();
        $this->url->setVisibility();
        $this->age->setVisibility();
        $this->type->setVisibility();
        $this->product_n->Visible = false;
        $this->rid->Visible = false;
        $this->code->Visible = false;
        $this->process_type->Visible = false;
        $this->packets->Visible = false;
        $this->godown->Visible = false;
        $this->godown_n->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'stock_processing_job';
        $this->TableName = 'stock_processing_job';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (stock_processing_job)
        if (!isset($GLOBALS["stock_processing_job"]) || $GLOBALS["stock_processing_job"]::class == PROJECT_NAMESPACE . "stock_processing_job") {
            $GLOBALS["stock_processing_job"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'stock_processing_job');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "stockprocessingjobview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->product_code->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->tmp_lot->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->IN->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->OUT->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Balance->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Item->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->new_process->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->avg_yield->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->url->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->age->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->type->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->godown_n->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->Item);
        $this->setupLookupOptions($this->new_process);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->godown);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "stockprocessingjoblist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->product); // product
        $this->buildSearchUrl($srchUrl, $this->product_code); // product_code
        $this->buildSearchUrl($srchUrl, $this->lot_no); // lot_no
        $this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
        $this->buildSearchUrl($srchUrl, $this->tmp_lot); // tmp_lot
        $this->buildSearchUrl($srchUrl, $this->gcode); // gcode
        $this->buildSearchUrl($srchUrl, $this->dated); // dated
        $this->buildSearchUrl($srchUrl, $this->IN); // IN
        $this->buildSearchUrl($srchUrl, $this->OUT); // OUT
        $this->buildSearchUrl($srchUrl, $this->Balance); // Balance
        $this->buildSearchUrl($srchUrl, $this->Item); // Item
        $this->buildSearchUrl($srchUrl, $this->new_process); // new_process
        $this->buildSearchUrl($srchUrl, $this->avg_yield); // avg_yield
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->url); // url
        $this->buildSearchUrl($srchUrl, $this->age); // age
        $this->buildSearchUrl($srchUrl, $this->type); // type
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_code
        if ($this->product_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lot_no
        if ($this->lot_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // tmp_lot
        if ($this->tmp_lot->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gcode
        if ($this->gcode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dated
        if ($this->dated->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // IN
        if ($this->IN->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // OUT
        if ($this->OUT->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Balance
        if ($this->Balance->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Item
        if ($this->Item->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->Item->AdvancedSearch->SearchValue)) {
            $this->Item->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Item->AdvancedSearch->SearchValue);
        }
        if (is_array($this->Item->AdvancedSearch->SearchValue2)) {
            $this->Item->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Item->AdvancedSearch->SearchValue2);
        }

        // new_process
        if ($this->new_process->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->new_process->AdvancedSearch->SearchValue)) {
            $this->new_process->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->new_process->AdvancedSearch->SearchValue);
        }
        if (is_array($this->new_process->AdvancedSearch->SearchValue2)) {
            $this->new_process->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->new_process->AdvancedSearch->SearchValue2);
        }

        // avg_yield
        if ($this->avg_yield->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // url
        if ($this->url->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // age
        if ($this->age->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // type
        if ($this->type->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // tmp_lot
        $this->tmp_lot->RowCssClass = "row";

        // gcode
        $this->gcode->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // IN
        $this->IN->RowCssClass = "row";

        // OUT
        $this->OUT->RowCssClass = "row";

        // Balance
        $this->Balance->RowCssClass = "row";

        // Item
        $this->Item->RowCssClass = "row";

        // new_process
        $this->new_process->RowCssClass = "row";

        // avg_yield
        $this->avg_yield->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // age
        $this->age->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // product_n
        $this->product_n->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // process_type
        $this->process_type->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // godown_n
        $this->godown_n->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // tmp_lot
            $this->tmp_lot->ViewValue = $this->tmp_lot->CurrentValue;

            // gcode
            $this->gcode->ViewValue = $this->gcode->CurrentValue;

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // IN
            $this->IN->ViewValue = $this->IN->CurrentValue;
            $this->IN->ViewValue = FormatNumber($this->IN->ViewValue, $this->IN->formatPattern());

            // OUT
            $this->OUT->ViewValue = $this->OUT->CurrentValue;
            $this->OUT->ViewValue = FormatNumber($this->OUT->ViewValue, $this->OUT->formatPattern());

            // Balance
            $this->Balance->ViewValue = $this->Balance->CurrentValue;
            $this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, $this->Balance->formatPattern());

            // Item
            if ($this->Item->VirtualValue != "") {
                $this->Item->ViewValue = $this->Item->VirtualValue;
            } else {
                $curVal = strval($this->Item->CurrentValue);
                if ($curVal != "") {
                    $this->Item->ViewValue = $this->Item->lookupCacheOption($curVal);
                    if ($this->Item->ViewValue === null) { // Lookup from database
                        $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                        $filterWrk = "";
                        foreach ($arwrk as $wrk) {
                            AddFilter($filterWrk, SearchFilter($this->Item->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->Item->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                        }
                        $sqlWrk = $this->Item->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $this->Item->ViewValue = new OptionValues();
                            foreach ($rswrk as $row) {
                                $arwrk = $this->Item->Lookup->renderViewRow($row);
                                $this->Item->ViewValue->add($this->Item->displayValue($arwrk));
                            }
                        } else {
                            $this->Item->ViewValue = $this->Item->CurrentValue;
                        }
                    }
                } else {
                    $this->Item->ViewValue = null;
                }
            }

            // new_process
            $curVal = strval($this->new_process->CurrentValue);
            if ($curVal != "") {
                $this->new_process->ViewValue = $this->new_process->lookupCacheOption($curVal);
                if ($this->new_process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->new_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->new_process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->new_process->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->new_process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->new_process->Lookup->renderViewRow($row);
                            $this->new_process->ViewValue->add($this->new_process->displayValue($arwrk));
                        }
                    } else {
                        $this->new_process->ViewValue = $this->new_process->CurrentValue;
                    }
                }
            } else {
                $this->new_process->ViewValue = null;
            }

            // avg_yield
            $this->avg_yield->ViewValue = $this->avg_yield->CurrentValue;
            $this->avg_yield->ViewValue = FormatNumber($this->avg_yield->ViewValue, $this->avg_yield->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // url
            $this->url->ViewValue = $this->url->CurrentValue;

            // age
            $this->age->ViewValue = $this->age->CurrentValue;
            $this->age->ViewValue = FormatNumber($this->age->ViewValue, $this->age->formatPattern());

            // type
            $this->type->ViewValue = $this->type->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // product
            $this->product->HrefValue = "";
            $this->product->TooltipValue = "";

            // product_code
            if (!EmptyValue($this->product_code->CurrentValue)) {
                $this->product_code->HrefValue = $this->product_code->getLinkPrefix() . $this->product_code->CurrentValue; // Add prefix/suffix
                $this->product_code->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
                }
            } else {
                $this->product_code->HrefValue = "";
            }
            $this->product_code->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // tmp_lot
            $this->tmp_lot->HrefValue = "";
            $this->tmp_lot->TooltipValue = "";

            // gcode
            $this->gcode->HrefValue = "";
            $this->gcode->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // IN
            $this->IN->HrefValue = "";
            $this->IN->TooltipValue = "";

            // OUT
            $this->OUT->HrefValue = "";
            $this->OUT->TooltipValue = "";

            // Balance
            $this->Balance->HrefValue = "";
            $this->Balance->TooltipValue = "";

            // Item
            $this->Item->HrefValue = "";
            $this->Item->TooltipValue = "";

            // new_process
            $this->new_process->HrefValue = "";
            $this->new_process->TooltipValue = "";

            // avg_yield
            $this->avg_yield->HrefValue = "";
            $this->avg_yield->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // url
            $this->url->HrefValue = "";
            $this->url->TooltipValue = "";

            // age
            $this->age->HrefValue = "";
            $this->age->TooltipValue = "";

            // type
            if (!EmptyValue($this->url->CurrentValue)) {
                $this->type->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
                $this->type->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
                }
            } else {
                $this->type->HrefValue = "";
            }
            $this->type->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->AdvancedSearch->SearchValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // product_code
            $this->product_code->setupEditAttributes();
            if (!$this->product_code->Raw) {
                $this->product_code->AdvancedSearch->SearchValue = HtmlDecode($this->product_code->AdvancedSearch->SearchValue);
            }
            $this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // lot_no
            $this->lot_no->setupEditAttributes();
            if (!$this->lot_no->Raw) {
                $this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->AdvancedSearch->SearchValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // tmp_lot
            $this->tmp_lot->setupEditAttributes();
            if (!$this->tmp_lot->Raw) {
                $this->tmp_lot->AdvancedSearch->SearchValue = HtmlDecode($this->tmp_lot->AdvancedSearch->SearchValue);
            }
            $this->tmp_lot->EditValue = HtmlEncode($this->tmp_lot->AdvancedSearch->SearchValue);
            $this->tmp_lot->PlaceHolder = RemoveHtml($this->tmp_lot->caption());

            // gcode
            $this->gcode->setupEditAttributes();
            if (!$this->gcode->Raw) {
                $this->gcode->AdvancedSearch->SearchValue = HtmlDecode($this->gcode->AdvancedSearch->SearchValue);
            }
            $this->gcode->EditValue = HtmlEncode($this->gcode->AdvancedSearch->SearchValue);
            $this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern()), $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // IN
            $this->IN->setupEditAttributes();
            $this->IN->EditValue = $this->IN->AdvancedSearch->SearchValue;
            $this->IN->PlaceHolder = RemoveHtml($this->IN->caption());

            // OUT
            $this->OUT->setupEditAttributes();
            $this->OUT->EditValue = $this->OUT->AdvancedSearch->SearchValue;
            $this->OUT->PlaceHolder = RemoveHtml($this->OUT->caption());

            // Balance
            $this->Balance->setupEditAttributes();
            $this->Balance->EditValue = $this->Balance->AdvancedSearch->SearchValue;
            $this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());

            // Item
            $this->Item->setupEditAttributes();
            if (!$this->Item->Raw) {
                $this->Item->AdvancedSearch->SearchValue = HtmlDecode($this->Item->AdvancedSearch->SearchValue);
            }
            $this->Item->EditValue = HtmlEncode($this->Item->AdvancedSearch->SearchValue);
            $this->Item->PlaceHolder = RemoveHtml($this->Item->caption());

            // new_process
            $this->new_process->setupEditAttributes();
            $curVal = trim(strval($this->new_process->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->new_process->AdvancedSearch->ViewValue = $this->new_process->lookupCacheOption($curVal);
            } else {
                $this->new_process->AdvancedSearch->ViewValue = $this->new_process->Lookup !== null && is_array($this->new_process->lookupOptions()) && count($this->new_process->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->new_process->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->new_process->EditValue = array_values($this->new_process->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->new_process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->new_process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->new_process->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->new_process->EditValue = $arwrk;
            }
            $this->new_process->PlaceHolder = RemoveHtml($this->new_process->caption());

            // avg_yield
            $this->avg_yield->setupEditAttributes();
            $this->avg_yield->EditValue = $this->avg_yield->AdvancedSearch->SearchValue;
            $this->avg_yield->PlaceHolder = RemoveHtml($this->avg_yield->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // url
            $this->url->setupEditAttributes();
            $this->url->EditValue = HtmlEncode($this->url->AdvancedSearch->SearchValue);
            $this->url->PlaceHolder = RemoveHtml($this->url->caption());

            // age
            $this->age->setupEditAttributes();
            $this->age->EditValue = $this->age->AdvancedSearch->SearchValue;
            $this->age->PlaceHolder = RemoveHtml($this->age->caption());

            // type
            $this->type->setupEditAttributes();
            if (!$this->type->Raw) {
                $this->type->AdvancedSearch->SearchValue = HtmlDecode($this->type->AdvancedSearch->SearchValue);
            }
            $this->type->EditValue = HtmlEncode($this->type->AdvancedSearch->SearchValue);
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->tmp_lot->AdvancedSearch->SearchValue)) {
            $this->tmp_lot->addErrorMessage($this->tmp_lot->getErrorMessage(false));
        }
        if (!CheckDate($this->dated->AdvancedSearch->SearchValue, $this->dated->formatPattern())) {
            $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
        }
        if (!CheckNumber($this->IN->AdvancedSearch->SearchValue)) {
            $this->IN->addErrorMessage($this->IN->getErrorMessage(false));
        }
        if (!CheckNumber($this->OUT->AdvancedSearch->SearchValue)) {
            $this->OUT->addErrorMessage($this->OUT->getErrorMessage(false));
        }
        if (!CheckNumber($this->Balance->AdvancedSearch->SearchValue)) {
            $this->Balance->addErrorMessage($this->Balance->getErrorMessage(false));
        }
        if (!CheckInteger($this->avg_yield->AdvancedSearch->SearchValue)) {
            $this->avg_yield->addErrorMessage($this->avg_yield->getErrorMessage(false));
        }
        if (!CheckInteger($this->age->AdvancedSearch->SearchValue)) {
            $this->age->addErrorMessage($this->age->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->product_code->AdvancedSearch->load();
        $this->lot_no->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->tmp_lot->AdvancedSearch->load();
        $this->gcode->AdvancedSearch->load();
        $this->dated->AdvancedSearch->load();
        $this->IN->AdvancedSearch->load();
        $this->OUT->AdvancedSearch->load();
        $this->Balance->AdvancedSearch->load();
        $this->Item->AdvancedSearch->load();
        $this->new_process->AdvancedSearch->load();
        $this->avg_yield->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->url->AdvancedSearch->load();
        $this->age->AdvancedSearch->load();
        $this->type->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("stockprocessingjoblist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_product":
                    break;
                case "x_packing_type":
                    break;
                case "x_Item":
                    break;
                case "x_new_process":
                    break;
                case "x_status":
                    break;
                case "x_godown":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
