<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class StockOnlineSearch extends StockOnline
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "StockOnlineSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "stockonlinesearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->_barcode->setVisibility();
        $this->design_id->setVisibility();
        $this->w_cm->Visible = false;
        $this->l_cm->Visible = false;
        $this->sqm->setVisibility();
        $this->Remarks->setVisibility();
        $this->last_remarks->setVisibility();
        $this->status->setVisibility();
        $this->consumed_by->setVisibility();
        $this->consumed_sqm->setVisibility();
        $this->consumed_status->setVisibility();
        $this->category->setVisibility();
        $this->url->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'stock_online';
        $this->TableName = 'stock_online';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (stock_online)
        if (!isset($GLOBALS["stock_online"]) || $GLOBALS["stock_online"]::class == PROJECT_NAMESPACE . "stock_online") {
            $GLOBALS["stock_online"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'stock_online');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "stockonlineview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->location->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->_barcode->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->design_id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->w_cm->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->l_cm->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->sqm->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Remarks->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->last_remarks->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->status->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->consumed_by->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->consumed_sqm->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->consumed_status->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->category->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->url->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->consumed_status);
        $this->setupLookupOptions($this->category);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "stockonlinelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->location); // location
        $this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
        $this->buildSearchUrl($srchUrl, $this->design_id); // design_id
        $this->buildSearchUrl($srchUrl, $this->sqm); // sqm
        $this->buildSearchUrl($srchUrl, $this->Remarks); // Remarks
        $this->buildSearchUrl($srchUrl, $this->last_remarks); // last_remarks
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->consumed_by); // consumed_by
        $this->buildSearchUrl($srchUrl, $this->consumed_sqm); // consumed_sqm
        $this->buildSearchUrl($srchUrl, $this->consumed_status); // consumed_status
        $this->buildSearchUrl($srchUrl, $this->category); // category
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // design_id
        if ($this->design_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Remarks
        if ($this->Remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // last_remarks
        if ($this->last_remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // consumed_by
        if ($this->consumed_by->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // consumed_sqm
        if ($this->consumed_sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // consumed_status
        if ($this->consumed_status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // design_id
        $this->design_id->RowCssClass = "row";

        // w_cm
        $this->w_cm->RowCssClass = "row";

        // l_cm
        $this->l_cm->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // Remarks
        $this->Remarks->RowCssClass = "row";

        // last_remarks
        $this->last_remarks->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // consumed_by
        $this->consumed_by->RowCssClass = "row";

        // consumed_sqm
        $this->consumed_sqm->RowCssClass = "row";

        // consumed_status
        $this->consumed_status->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
            $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // w_cm
            $this->w_cm->ViewValue = $this->w_cm->CurrentValue;
            $this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, $this->w_cm->formatPattern());

            // l_cm
            $this->l_cm->ViewValue = $this->l_cm->CurrentValue;
            $this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, $this->l_cm->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // Remarks
            $this->Remarks->ViewValue = $this->Remarks->CurrentValue;

            // last_remarks
            $this->last_remarks->ViewValue = $this->last_remarks->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // consumed_by
            $this->consumed_by->ViewValue = $this->consumed_by->CurrentValue;

            // consumed_sqm
            $this->consumed_sqm->ViewValue = $this->consumed_sqm->CurrentValue;
            $this->consumed_sqm->ViewValue = FormatNumber($this->consumed_sqm->ViewValue, $this->consumed_sqm->formatPattern());

            // consumed_status
            if (strval($this->consumed_status->CurrentValue) != "") {
                $this->consumed_status->ViewValue = $this->consumed_status->optionCaption($this->consumed_status->CurrentValue);
            } else {
                $this->consumed_status->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = $this->category->CurrentValue;
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // barcode
            if (!EmptyValue($this->_barcode->CurrentValue)) {
                $this->_barcode->HrefValue = $this->_barcode->getLinkPrefix() . $this->_barcode->CurrentValue; // Add prefix/suffix
                $this->_barcode->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->_barcode->HrefValue = FullUrl($this->_barcode->HrefValue, "href");
                }
            } else {
                $this->_barcode->HrefValue = "";
            }
            $this->_barcode->TooltipValue = "";

            // design_id
            if (!EmptyValue($this->design_id->CurrentValue)) {
                $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . $this->design_id->CurrentValue; // Add prefix/suffix
                $this->design_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
                }
            } else {
                $this->design_id->HrefValue = "";
            }
            $this->design_id->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // Remarks
            $this->Remarks->HrefValue = "";
            $this->Remarks->TooltipValue = "";

            // last_remarks
            $this->last_remarks->HrefValue = "";
            $this->last_remarks->TooltipValue = "";

            // status
            if (!EmptyValue($this->status->CurrentValue)) {
                $this->status->HrefValue = $this->status->getLinkPrefix() . $this->status->CurrentValue; // Add prefix/suffix
                $this->status->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
                }
            } else {
                $this->status->HrefValue = "";
            }
            $this->status->TooltipValue = "";

            // consumed_by
            if (!EmptyValue($this->url->CurrentValue)) {
                $this->consumed_by->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
                $this->consumed_by->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->consumed_by->HrefValue = FullUrl($this->consumed_by->HrefValue, "href");
                }
            } else {
                $this->consumed_by->HrefValue = "";
            }
            $this->consumed_by->TooltipValue = "";

            // consumed_sqm
            $this->consumed_sqm->HrefValue = "";
            $this->consumed_sqm->TooltipValue = "";

            // consumed_status
            if (!EmptyValue($this->consumed_status->CurrentValue)) {
                $this->consumed_status->HrefValue = $this->consumed_status->getLinkPrefix() . $this->consumed_status->CurrentValue; // Add prefix/suffix
                $this->consumed_status->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->consumed_status->HrefValue = FullUrl($this->consumed_status->HrefValue, "href");
                }
            } else {
                $this->consumed_status->HrefValue = "";
            }
            $this->consumed_status->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->AdvancedSearch->SearchValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = $this->_barcode->AdvancedSearch->SearchValue;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue2 = $this->_barcode->AdvancedSearch->SearchValue2;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // design_id
            $this->design_id->setupEditAttributes();
            $curVal = trim(strval($this->design_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->design_id->AdvancedSearch->ViewValue = $this->design_id->lookupCacheOption($curVal);
            } else {
                $this->design_id->AdvancedSearch->ViewValue = $this->design_id->Lookup !== null && is_array($this->design_id->lookupOptions()) && count($this->design_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->design_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->design_id->EditValue = array_values($this->design_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->design_id->AdvancedSearch->SearchValue, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->design_id->EditValue = $arwrk;
            }
            $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // Remarks
            $this->Remarks->setupEditAttributes();
            if (!$this->Remarks->Raw) {
                $this->Remarks->AdvancedSearch->SearchValue = HtmlDecode($this->Remarks->AdvancedSearch->SearchValue);
            }
            $this->Remarks->EditValue = HtmlEncode($this->Remarks->AdvancedSearch->SearchValue);
            $this->Remarks->PlaceHolder = RemoveHtml($this->Remarks->caption());

            // last_remarks
            $this->last_remarks->setupEditAttributes();
            if (!$this->last_remarks->Raw) {
                $this->last_remarks->AdvancedSearch->SearchValue = HtmlDecode($this->last_remarks->AdvancedSearch->SearchValue);
            }
            $this->last_remarks->EditValue = HtmlEncode($this->last_remarks->AdvancedSearch->SearchValue);
            $this->last_remarks->PlaceHolder = RemoveHtml($this->last_remarks->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // consumed_by
            $this->consumed_by->setupEditAttributes();
            if (!$this->consumed_by->Raw) {
                $this->consumed_by->AdvancedSearch->SearchValue = HtmlDecode($this->consumed_by->AdvancedSearch->SearchValue);
            }
            $this->consumed_by->EditValue = HtmlEncode($this->consumed_by->AdvancedSearch->SearchValue);
            $this->consumed_by->PlaceHolder = RemoveHtml($this->consumed_by->caption());

            // consumed_sqm
            $this->consumed_sqm->setupEditAttributes();
            $this->consumed_sqm->EditValue = $this->consumed_sqm->AdvancedSearch->SearchValue;
            $this->consumed_sqm->PlaceHolder = RemoveHtml($this->consumed_sqm->caption());

            // consumed_status
            $this->consumed_status->setupEditAttributes();
            $this->consumed_status->EditValue = $this->consumed_status->options(true);
            $this->consumed_status->PlaceHolder = RemoveHtml($this->consumed_status->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->AdvancedSearch->SearchValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue)) {
            $this->_barcode->addErrorMessage($this->_barcode->getErrorMessage(false));
        }
        if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue2)) {
            $this->_barcode->addErrorMessage($this->_barcode->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
            $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->consumed_sqm->AdvancedSearch->SearchValue)) {
            $this->consumed_sqm->addErrorMessage($this->consumed_sqm->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->design_id->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->Remarks->AdvancedSearch->load();
        $this->last_remarks->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->consumed_by->AdvancedSearch->load();
        $this->consumed_sqm->AdvancedSearch->load();
        $this->consumed_status->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("stockonlinelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    break;
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_consumed_status":
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
