<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for stock_lcgp
 */
class StockLcgp extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $rid;
    public $grp;
    public $product;
    public $product_code_pg;
    public $product_code;
    public $godown;
    public $godown_n;
    public $IN;
    public $OUT;
    public $Balance;
    public $packets;
    public $packing_type_n;
    public $lot_no;
    public $packing_type;
    public $url;
    public $HOLD;
    public $avg_quantity;
    public $_40;
    public $age;
    public $company_id;
    public $s_grp;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "stock_lcgp";
        $this->TableName = 'stock_lcgp';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "stock_lcgp";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            200, // Type
            269, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Sortable = false; // Allow sort
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['id'] = &$this->id;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            20, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->IsForeignKey = true; // Foreign key field
        $this->rid->UseFilter = true; // Table header filter
        $this->rid->Lookup = new Lookup($this->rid, 'stock_lcgp', true, 'rid', ["rid","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['rid'] = &$this->rid;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->grp->addMethod("getLinkPrefix", fn() => "stocklcgplist?x_grp=");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->UseFilter = true; // Table header filter
        $this->grp->Lookup = new Lookup($this->grp, 'grp', true, 'id', ["grp","","",""], '', '', [], [], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['grp'] = &$this->grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getLinkPrefix", fn() => "stocklcgplist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->UseFilter = true; // Table header filter
        $this->product->Lookup = new Lookup($this->product, 'product_g', true, 'id', ["product","","",""], '', '', [], [], [], [], [], [], false, '`product` ASC', '', "`product`");
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // product_code_pg
        $this->product_code_pg = new DbField(
            $this, // Table
            'x_product_code_pg', // Variable name
            'product_code_pg', // Name
            '`product_code_pg`', // Expression
            '`product_code_pg`', // Basic search expression
            200, // Type
            368, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_code_pg`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_code_pg->InputTextType = "text";
        $this->product_code_pg->Sortable = false; // Allow sort
        $this->product_code_pg->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_code_pg'] = &$this->product_code_pg;

        // product_code
        $this->product_code = new DbField(
            $this, // Table
            'x_product_code', // Variable name
            'product_code', // Name
            '`product_code`', // Expression
            '`product_code`', // Basic search expression
            200, // Type
            311, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_code->addMethod("getLinkPrefix", fn() => "stocklcgplist?x_product_code=");
        $this->product_code->addMethod("getLinkSuffix", fn() => "&z_product_code=LIKE");
        $this->product_code->InputTextType = "text";
        $this->product_code->UseFilter = true; // Table header filter
        $this->product_code->Lookup = new Lookup($this->product_code, 'stock_lcgp', true, 'product_code', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->product_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_code'] = &$this->product_code;

        // godown
        $this->godown = new DbField(
            $this, // Table
            'x_godown', // Variable name
            'godown', // Name
            '`godown`', // Expression
            '`godown`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->godown->addMethod("getSelectFilter", fn() => "`status` =1 and (`category` = 999 || `category` = 0)");
        $this->godown->InputTextType = "text";
        $this->godown->Raw = true;
        $this->godown->setSelectMultiple(false); // Select one
        $this->godown->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->godown->UseFilter = true; // Table header filter
        $this->godown->Lookup = new Lookup($this->godown, 'buyer_seller_view', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->godown->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['godown'] = &$this->godown;

        // godown_n
        $this->godown_n = new DbField(
            $this, // Table
            'x_godown_n', // Variable name
            'godown_n', // Name
            '`godown_n`', // Expression
            '`godown_n`', // Basic search expression
            200, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown_n`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->godown_n->addMethod("getLinkPrefix", fn() => "stocklcgplist?x_godown=");
        $this->godown_n->InputTextType = "text";
        $this->godown_n->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['godown_n'] = &$this->godown_n;

        // IN
        $this->IN = new DbField(
            $this, // Table
            'x_IN', // Variable name
            'IN', // Name
            '`IN`', // Expression
            '`IN`', // Basic search expression
            131, // Type
            57, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`IN`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->IN->InputTextType = "text";
        $this->IN->Raw = true;
        $this->IN->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->IN->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['IN'] = &$this->IN;

        // OUT
        $this->OUT = new DbField(
            $this, // Table
            'x_OUT', // Variable name
            'OUT', // Name
            '`OUT`', // Expression
            '`OUT`', // Basic search expression
            131, // Type
            56, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`OUT`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->OUT->InputTextType = "text";
        $this->OUT->Raw = true;
        $this->OUT->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->OUT->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['OUT'] = &$this->OUT;

        // Balance
        $this->Balance = new DbField(
            $this, // Table
            'x_Balance', // Variable name
            'Balance', // Name
            '`Balance`', // Expression
            '`Balance`', // Basic search expression
            131, // Type
            58, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Balance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Balance->addMethod("getLinkPrefix", fn() => "stocklcgpdlist?x_product_code=");
        $this->Balance->addMethod("getLinkSuffix", fn() => "&z_product_code=LIKE");
        $this->Balance->InputTextType = "text";
        $this->Balance->Raw = true;
        $this->Balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Balance->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Balance'] = &$this->Balance;

        // packets
        $this->packets = new DbField(
            $this, // Table
            'x_packets', // Variable name
            'packets', // Name
            '`packets`', // Expression
            '`packets`', // Basic search expression
            131, // Type
            56, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packets->InputTextType = "text";
        $this->packets->Raw = true;
        $this->packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packets'] = &$this->packets;

        // packing_type_n
        $this->packing_type_n = new DbField(
            $this, // Table
            'x_packing_type_n', // Variable name
            'packing_type_n', // Name
            '`packing_type_n`', // Expression
            '`packing_type_n`', // Basic search expression
            200, // Type
            54, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type_n`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packing_type_n->InputTextType = "text";
        $this->packing_type_n->UseFilter = true; // Table header filter
        $this->packing_type_n->Lookup = new Lookup($this->packing_type_n, 'stock_lcgp', true, 'packing_type_n', ["packing_type_n","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->packing_type_n->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['packing_type_n'] = &$this->packing_type_n;

        // lot_no
        $this->lot_no = new DbField(
            $this, // Table
            'x_lot_no', // Variable name
            'lot_no', // Name
            '`lot_no`', // Expression
            '`lot_no`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lot_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lot_no->InputTextType = "text";
        $this->lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['lot_no'] = &$this->lot_no;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packing_type->addMethod("getDefault", fn() => 0);
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->Required = true; // Required field
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // url
        $this->url = new DbField(
            $this, // Table
            'x_url', // Variable name
            'url', // Name
            '`url`', // Expression
            '`url`', // Basic search expression
            200, // Type
            409, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`url`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->url->InputTextType = "text";
        $this->url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['url'] = &$this->url;

        // HOLD
        $this->HOLD = new DbField(
            $this, // Table
            'x_HOLD', // Variable name
            'HOLD', // Name
            '`HOLD`', // Expression
            '`HOLD`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`HOLD`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->HOLD->InputTextType = "text";
        $this->HOLD->Raw = true;
        $this->HOLD->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->HOLD->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['HOLD'] = &$this->HOLD;

        // avg_quantity
        $this->avg_quantity = new DbField(
            $this, // Table
            'x_avg_quantity', // Variable name
            'avg_quantity', // Name
            '`avg_quantity`', // Expression
            '`avg_quantity`', // Basic search expression
            131, // Type
            60, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`avg_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->avg_quantity->InputTextType = "text";
        $this->avg_quantity->Raw = true;
        $this->avg_quantity->Nullable = false; // NOT NULL field
        $this->avg_quantity->Sortable = false; // Allow sort
        $this->avg_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->avg_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['avg_quantity'] = &$this->avg_quantity;

        // @
        $this->_40 = new DbField(
            $this, // Table
            'x__40', // Variable name
            '@', // Name
            '`@`', // Expression
            '`@`', // Basic search expression
            129, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`@`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_40->InputTextType = "text";
        $this->_40->Sortable = false; // Allow sort
        $this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_40->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['@'] = &$this->_40;

        // age
        $this->age = new DbField(
            $this, // Table
            'x_age', // Variable name
            'age', // Name
            '`age`', // Expression
            '`age`', // Basic search expression
            129, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`age`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->age->InputTextType = "text";
        $this->age->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->age->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['age'] = &$this->age;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => "`id`< 1000 || `category` = 1 ");
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->setSelectMultiple(false); // Select one
        $this->company_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->company_id->Lookup = new Lookup($this->company_id, 'buyer_seller_view', true, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Sortable = false; // Allow sort
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->UseFilter = true; // Table header filter
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', true, 'id', ["product_group","","",""], '', '', [], [], [], [], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "required_material_compiled") {
            $masterTable = Container("required_material_compiled");
            if ($this->rid->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->req_material_rid, $this->rid->getSessionValue(), $masterTable->req_material_rid->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        if ($this->getCurrentMasterTable() == "required_material_compiled_live") {
            $masterTable = Container("required_material_compiled_live");
            if ($this->rid->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->req_material_rid, $this->rid->getSessionValue(), $masterTable->req_material_rid->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "required_material_compiled") {
            $masterTable = Container("required_material_compiled");
            if ($this->rid->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->rid, $this->rid->getSessionValue(), $masterTable->req_material_rid->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        if ($this->getCurrentMasterTable() == "required_material_compiled_live") {
            $masterTable = Container("required_material_compiled_live");
            if ($this->rid->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->rid, $this->rid->getSessionValue(), $masterTable->req_material_rid->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "required_material_compiled":
                $key = $keys["rid"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->req_material_rid->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->req_material_rid, $keys["rid"], $this->rid->DataType, $this->Dbid);
                }
                break;
            case "required_material_compiled_live":
                $key = $keys["rid"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->req_material_rid->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->req_material_rid, $keys["rid"], $this->rid->DataType, $this->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "required_material_compiled":
                return GetKeyFilter($this->rid, $masterTable->req_material_rid->DbValue, $masterTable->req_material_rid->DataType, $masterTable->Dbid);
            case "required_material_compiled_live":
                return GetKeyFilter($this->rid, $masterTable->req_material_rid->DbValue, $masterTable->req_material_rid->DataType, $masterTable->Dbid);
        }
        return "";
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "stock_lcgp";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Site() == 0) ? "`Balance`!=0" : "FIND_IN_SET(`godown`, '" . User_Site() . "') and `Balance`!=0";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->rid->DbValue = $row['rid'];
        $this->grp->DbValue = $row['grp'];
        $this->product->DbValue = $row['product'];
        $this->product_code_pg->DbValue = $row['product_code_pg'];
        $this->product_code->DbValue = $row['product_code'];
        $this->godown->DbValue = $row['godown'];
        $this->godown_n->DbValue = $row['godown_n'];
        $this->IN->DbValue = $row['IN'];
        $this->OUT->DbValue = $row['OUT'];
        $this->Balance->DbValue = $row['Balance'];
        $this->packets->DbValue = $row['packets'];
        $this->packing_type_n->DbValue = $row['packing_type_n'];
        $this->lot_no->DbValue = $row['lot_no'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->url->DbValue = $row['url'];
        $this->HOLD->DbValue = $row['HOLD'];
        $this->avg_quantity->DbValue = $row['avg_quantity'];
        $this->_40->DbValue = $row['@'];
        $this->age->DbValue = $row['age'];
        $this->company_id->DbValue = $row['company_id'];
        $this->s_grp->DbValue = $row['s_grp'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("stocklcgplist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "stocklcgpview" => $Language->phrase("View"),
            "stocklcgpedit" => $Language->phrase("Edit"),
            "stocklcgpadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "stocklcgplist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "StockLcgpView",
            Config("API_ADD_ACTION") => "StockLcgpAdd",
            Config("API_EDIT_ACTION") => "StockLcgpEdit",
            Config("API_DELETE_ACTION") => "StockLcgpDelete",
            Config("API_LIST_ACTION") => "StockLcgpList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "stocklcgplist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("stocklcgpview", $parm);
        } else {
            $url = $this->keyUrl("stocklcgpview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "stocklcgpadd?" . $parm;
        } else {
            $url = "stocklcgpadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("stocklcgpedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("stocklcgplist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("stocklcgpadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("stocklcgplist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("stocklcgpdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "required_material_compiled" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_req_material_rid", $this->rid->getSessionValue()); // Use Session Value
        }
        if ($this->getCurrentMasterTable() == "required_material_compiled_live" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_req_material_rid", $this->rid->getSessionValue()); // Use Session Value
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->rid->setDbValue($row['rid']);
        $this->grp->setDbValue($row['grp']);
        $this->product->setDbValue($row['product']);
        $this->product_code_pg->setDbValue($row['product_code_pg']);
        $this->product_code->setDbValue($row['product_code']);
        $this->godown->setDbValue($row['godown']);
        $this->godown_n->setDbValue($row['godown_n']);
        $this->IN->setDbValue($row['IN']);
        $this->OUT->setDbValue($row['OUT']);
        $this->Balance->setDbValue($row['Balance']);
        $this->packets->setDbValue($row['packets']);
        $this->packing_type_n->setDbValue($row['packing_type_n']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->url->setDbValue($row['url']);
        $this->HOLD->setDbValue($row['HOLD']);
        $this->avg_quantity->setDbValue($row['avg_quantity']);
        $this->_40->setDbValue($row['@']);
        $this->age->setDbValue($row['age']);
        $this->company_id->setDbValue($row['company_id']);
        $this->s_grp->setDbValue($row['s_grp']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "StockLcgpList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id
        $this->id->CellCssStyle = "white-space: nowrap;";

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // grp

        // product

        // product_code_pg
        $this->product_code_pg->CellCssStyle = "white-space: nowrap;";

        // product_code

        // godown

        // godown_n

        // IN

        // OUT

        // Balance

        // packets

        // packing_type_n

        // lot_no

        // packing_type

        // url

        // HOLD

        // avg_quantity
        $this->avg_quantity->CellCssStyle = "white-space: nowrap;";

        // @
        $this->_40->CellCssStyle = "white-space: nowrap;";

        // age

        // company_id

        // s_grp
        $this->s_grp->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // rid
        $this->rid->ViewValue = $this->rid->CurrentValue;
        $this->rid->ViewValue = FormatNumber($this->rid->ViewValue, $this->rid->formatPattern());

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = FormatNumber($this->product->CurrentValue, $this->product->formatPattern());
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // product_code_pg
        $this->product_code_pg->ViewValue = $this->product_code_pg->CurrentValue;

        // product_code
        $this->product_code->ViewValue = $this->product_code->CurrentValue;

        // godown
        $curVal = strval($this->godown->CurrentValue);
        if ($curVal != "") {
            $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            if ($this->godown->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                    $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                } else {
                    $this->godown->ViewValue = FormatNumber($this->godown->CurrentValue, $this->godown->formatPattern());
                }
            }
        } else {
            $this->godown->ViewValue = null;
        }

        // godown_n
        $this->godown_n->ViewValue = $this->godown_n->CurrentValue;

        // IN
        $this->IN->ViewValue = $this->IN->CurrentValue;
        $this->IN->ViewValue = FormatNumber($this->IN->ViewValue, $this->IN->formatPattern());

        // OUT
        $this->OUT->ViewValue = $this->OUT->CurrentValue;
        $this->OUT->ViewValue = FormatNumber($this->OUT->ViewValue, $this->OUT->formatPattern());

        // Balance
        $this->Balance->ViewValue = $this->Balance->CurrentValue;
        $this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, $this->Balance->formatPattern());

        // packets
        $this->packets->ViewValue = $this->packets->CurrentValue;
        $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

        // packing_type_n
        $this->packing_type_n->ViewValue = $this->packing_type_n->CurrentValue;

        // lot_no
        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

        // packing_type
        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
        $this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, $this->packing_type->formatPattern());

        // url
        $this->url->ViewValue = $this->url->CurrentValue;

        // HOLD
        $this->HOLD->ViewValue = $this->HOLD->CurrentValue;
        $this->HOLD->ViewValue = FormatNumber($this->HOLD->ViewValue, $this->HOLD->formatPattern());

        // avg_quantity
        $this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
        $this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, $this->avg_quantity->formatPattern());

        // @
        $this->_40->ViewValue = $this->_40->CurrentValue;

        // age
        $this->age->ViewValue = $this->age->CurrentValue;

        // company_id
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = FormatNumber($this->s_grp->CurrentValue, $this->s_grp->formatPattern());
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // rid
        $this->rid->HrefValue = "";
        $this->rid->TooltipValue = "";

        // grp
        if (!EmptyValue($this->grp->CurrentValue)) {
            $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
            $this->grp->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
            }
        } else {
            $this->grp->HrefValue = "";
        }
        $this->grp->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // product_code_pg
        $this->product_code_pg->HrefValue = "";
        $this->product_code_pg->TooltipValue = "";

        // product_code
        if (!EmptyValue($this->product_code->CurrentValue)) {
            $this->product_code->HrefValue = $this->product_code->getLinkPrefix() . $this->product_code->CurrentValue . $this->product_code->getLinkSuffix(); // Add prefix/suffix
            $this->product_code->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
            }
        } else {
            $this->product_code->HrefValue = "";
        }
        $this->product_code->TooltipValue = "";

        // godown
        $this->godown->HrefValue = "";
        $this->godown->TooltipValue = "";

        // godown_n
        if (!EmptyValue($this->godown->CurrentValue)) {
            $this->godown_n->HrefValue = $this->godown_n->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
            $this->godown_n->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->godown_n->HrefValue = FullUrl($this->godown_n->HrefValue, "href");
            }
        } else {
            $this->godown_n->HrefValue = "";
        }
        $this->godown_n->TooltipValue = "";

        // IN
        $this->IN->HrefValue = "";
        $this->IN->TooltipValue = "";

        // OUT
        $this->OUT->HrefValue = "";
        $this->OUT->TooltipValue = "";

        // Balance
        if (!EmptyValue($this->product_code->CurrentValue)) {
            $this->Balance->HrefValue = $this->Balance->getLinkPrefix() . $this->product_code->CurrentValue . $this->Balance->getLinkSuffix(); // Add prefix/suffix
            $this->Balance->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->Balance->HrefValue = FullUrl($this->Balance->HrefValue, "href");
            }
        } else {
            $this->Balance->HrefValue = "";
        }
        $this->Balance->TooltipValue = "";

        // packets
        $this->packets->HrefValue = "";
        $this->packets->TooltipValue = "";

        // packing_type_n
        $this->packing_type_n->HrefValue = "";
        $this->packing_type_n->TooltipValue = "";

        // lot_no
        $this->lot_no->HrefValue = "";
        $this->lot_no->TooltipValue = "";

        // packing_type
        $this->packing_type->HrefValue = "";
        $this->packing_type->TooltipValue = "";

        // url
        $this->url->HrefValue = "";
        $this->url->TooltipValue = "";

        // HOLD
        $this->HOLD->HrefValue = "";
        $this->HOLD->TooltipValue = "";

        // avg_quantity
        $this->avg_quantity->HrefValue = "";
        $this->avg_quantity->TooltipValue = "";

        // @
        $this->_40->HrefValue = "";
        $this->_40->TooltipValue = "";

        // age
        $this->age->HrefValue = "";
        $this->age->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // s_grp
        $this->s_grp->HrefValue = "";
        $this->s_grp->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        if (!$this->id->Raw) {
            $this->id->CurrentValue = HtmlDecode($this->id->CurrentValue);
        }
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());

        // rid
        $this->rid->setupEditAttributes();
        if ($this->rid->getSessionValue() != "") {
            $this->rid->CurrentValue = GetForeignKeyValue($this->rid->getSessionValue());
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $this->rid->ViewValue = FormatNumber($this->rid->ViewValue, $this->rid->formatPattern());
        } else {
            $this->rid->EditValue = $this->rid->CurrentValue;
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
            if (strval($this->rid->EditValue) != "" && is_numeric($this->rid->EditValue)) {
                $this->rid->EditValue = FormatNumber($this->rid->EditValue, null);
            }
        }

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // product
        $this->product->setupEditAttributes();
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());

        // product_code_pg
        $this->product_code_pg->setupEditAttributes();
        if (!$this->product_code_pg->Raw) {
            $this->product_code_pg->CurrentValue = HtmlDecode($this->product_code_pg->CurrentValue);
        }
        $this->product_code_pg->EditValue = $this->product_code_pg->CurrentValue;
        $this->product_code_pg->PlaceHolder = RemoveHtml($this->product_code_pg->caption());

        // product_code
        $this->product_code->setupEditAttributes();
        if (!$this->product_code->Raw) {
            $this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
        }
        $this->product_code->EditValue = $this->product_code->CurrentValue;
        $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

        // godown
        $this->godown->setupEditAttributes();
        $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

        // godown_n
        $this->godown_n->setupEditAttributes();
        if (!$this->godown_n->Raw) {
            $this->godown_n->CurrentValue = HtmlDecode($this->godown_n->CurrentValue);
        }
        $this->godown_n->EditValue = $this->godown_n->CurrentValue;
        $this->godown_n->PlaceHolder = RemoveHtml($this->godown_n->caption());

        // IN
        $this->IN->setupEditAttributes();
        $this->IN->EditValue = $this->IN->CurrentValue;
        $this->IN->PlaceHolder = RemoveHtml($this->IN->caption());
        if (strval($this->IN->EditValue) != "" && is_numeric($this->IN->EditValue)) {
            $this->IN->EditValue = FormatNumber($this->IN->EditValue, null);
        }

        // OUT
        $this->OUT->setupEditAttributes();
        $this->OUT->EditValue = $this->OUT->CurrentValue;
        $this->OUT->PlaceHolder = RemoveHtml($this->OUT->caption());
        if (strval($this->OUT->EditValue) != "" && is_numeric($this->OUT->EditValue)) {
            $this->OUT->EditValue = FormatNumber($this->OUT->EditValue, null);
        }

        // Balance
        $this->Balance->setupEditAttributes();
        $this->Balance->EditValue = $this->Balance->CurrentValue;
        $this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());
        if (strval($this->Balance->EditValue) != "" && is_numeric($this->Balance->EditValue)) {
            $this->Balance->EditValue = FormatNumber($this->Balance->EditValue, null);
        }

        // packets
        $this->packets->setupEditAttributes();
        $this->packets->EditValue = $this->packets->CurrentValue;
        $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
        if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
            $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
        }

        // packing_type_n
        $this->packing_type_n->setupEditAttributes();
        if (!$this->packing_type_n->Raw) {
            $this->packing_type_n->CurrentValue = HtmlDecode($this->packing_type_n->CurrentValue);
        }
        $this->packing_type_n->EditValue = $this->packing_type_n->CurrentValue;
        $this->packing_type_n->PlaceHolder = RemoveHtml($this->packing_type_n->caption());

        // lot_no
        $this->lot_no->setupEditAttributes();
        if (!$this->lot_no->Raw) {
            $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
        }
        $this->lot_no->EditValue = $this->lot_no->CurrentValue;
        $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

        // packing_type
        $this->packing_type->setupEditAttributes();
        $this->packing_type->EditValue = $this->packing_type->CurrentValue;
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());
        if (strval($this->packing_type->EditValue) != "" && is_numeric($this->packing_type->EditValue)) {
            $this->packing_type->EditValue = FormatNumber($this->packing_type->EditValue, null);
        }

        // url
        $this->url->setupEditAttributes();
        if (!$this->url->Raw) {
            $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
        }
        $this->url->EditValue = $this->url->CurrentValue;
        $this->url->PlaceHolder = RemoveHtml($this->url->caption());

        // HOLD
        $this->HOLD->setupEditAttributes();
        $this->HOLD->EditValue = $this->HOLD->CurrentValue;
        $this->HOLD->PlaceHolder = RemoveHtml($this->HOLD->caption());
        if (strval($this->HOLD->EditValue) != "" && is_numeric($this->HOLD->EditValue)) {
            $this->HOLD->EditValue = FormatNumber($this->HOLD->EditValue, null);
        }

        // avg_quantity
        $this->avg_quantity->setupEditAttributes();
        $this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
        $this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());
        if (strval($this->avg_quantity->EditValue) != "" && is_numeric($this->avg_quantity->EditValue)) {
            $this->avg_quantity->EditValue = FormatNumber($this->avg_quantity->EditValue, null);
        }

        // @
        $this->_40->setupEditAttributes();
        if (!$this->_40->Raw) {
            $this->_40->CurrentValue = HtmlDecode($this->_40->CurrentValue);
        }
        $this->_40->EditValue = $this->_40->CurrentValue;
        $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

        // age
        $this->age->setupEditAttributes();
        if (!$this->age->Raw) {
            $this->age->CurrentValue = HtmlDecode($this->age->CurrentValue);
        }
        $this->age->EditValue = $this->age->CurrentValue;
        $this->age->PlaceHolder = RemoveHtml($this->age->caption());

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->IN->CurrentValue)) {
                $this->IN->Total += $this->IN->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->OUT->CurrentValue)) {
                $this->OUT->Total += $this->OUT->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->Balance->CurrentValue)) {
                $this->Balance->Total += $this->Balance->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->IN->CurrentValue = $this->IN->Total;
            $this->IN->ViewValue = $this->IN->CurrentValue;
            $this->IN->ViewValue = FormatNumber($this->IN->ViewValue, $this->IN->formatPattern());
            $this->IN->HrefValue = ""; // Clear href value
            $this->OUT->CurrentValue = $this->OUT->Total;
            $this->OUT->ViewValue = $this->OUT->CurrentValue;
            $this->OUT->ViewValue = FormatNumber($this->OUT->ViewValue, $this->OUT->formatPattern());
            $this->OUT->HrefValue = ""; // Clear href value
            $this->Balance->CurrentValue = $this->Balance->Total;
            $this->Balance->ViewValue = $this->Balance->CurrentValue;
            $this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, $this->Balance->formatPattern());
            $this->Balance->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->product_code_pg);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->godown_n);
                    $doc->exportCaption($this->IN);
                    $doc->exportCaption($this->OUT);
                    $doc->exportCaption($this->Balance);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->packing_type_n);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->url);
                    $doc->exportCaption($this->HOLD);
                    $doc->exportCaption($this->avg_quantity);
                    $doc->exportCaption($this->age);
                    $doc->exportCaption($this->company_id);
                } else {
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->IN);
                    $doc->exportCaption($this->OUT);
                    $doc->exportCaption($this->Balance);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->packing_type_n);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->age);
                    $doc->exportCaption($this->company_id);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->product_code_pg);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->godown_n);
                        $doc->exportField($this->IN);
                        $doc->exportField($this->OUT);
                        $doc->exportField($this->Balance);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->packing_type_n);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->url);
                        $doc->exportField($this->HOLD);
                        $doc->exportField($this->avg_quantity);
                        $doc->exportField($this->age);
                        $doc->exportField($this->company_id);
                    } else {
                        $doc->exportField($this->rid);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->IN);
                        $doc->exportField($this->OUT);
                        $doc->exportField($this->Balance);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->packing_type_n);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->age);
                        $doc->exportField($this->company_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->rid, '');
                $doc->exportAggregate($this->grp, '');
                $doc->exportAggregate($this->product, '');
                $doc->exportAggregate($this->product_code, '');
                $doc->exportAggregate($this->godown, '');
                $doc->exportAggregate($this->IN, 'TOTAL');
                $doc->exportAggregate($this->OUT, 'TOTAL');
                $doc->exportAggregate($this->Balance, 'TOTAL');
                $doc->exportAggregate($this->packets, '');
                $doc->exportAggregate($this->packing_type_n, '');
                $doc->exportAggregate($this->lot_no, '');
                $doc->exportAggregate($this->packing_type, '');
                $doc->exportAggregate($this->age, '');
                $doc->exportAggregate($this->company_id, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
