<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ShopEdit extends Shop
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ShopEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "shopedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->category->Visible = false;
        $this->short_description->setVisibility();
        $this->includes->setVisibility();
        $this->description->setVisibility();
        $this->price->setVisibility();
        $this->discount_coupon->setVisibility();
        $this->discount->setVisibility();
        $this->amount->setVisibility();
        $this->valid_till->setVisibility();
        $this->status->setVisibility();
        $this->_response->setVisibility();
        $this->admin_notes->setVisibility();
        $this->code->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->show_to->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'shop';
        $this->TableName = 'shop';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (shop)
        if (!isset($GLOBALS["shop"]) || $GLOBALS["shop"]::class == PROJECT_NAMESPACE . "shop") {
            $GLOBALS["shop"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'shop');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "shopview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->short_description);
        $this->setupLookupOptions($this->includes);
        $this->setupLookupOptions($this->status);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("shoplist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "shoplist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "shoplist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "shoplist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'short_description' first before field var 'x_short_description'
        $val = $CurrentForm->hasValue("short_description") ? $CurrentForm->getValue("short_description") : $CurrentForm->getValue("x_short_description");
        if (!$this->short_description->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->short_description->Visible = false; // Disable update for API request
            } else {
                $this->short_description->setFormValue($val);
            }
        }

        // Check field name 'includes' first before field var 'x_includes'
        $val = $CurrentForm->hasValue("includes") ? $CurrentForm->getValue("includes") : $CurrentForm->getValue("x_includes");
        if (!$this->includes->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->includes->Visible = false; // Disable update for API request
            } else {
                $this->includes->setFormValue($val);
            }
        }

        // Check field name 'description' first before field var 'x_description'
        $val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
        if (!$this->description->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description->Visible = false; // Disable update for API request
            } else {
                $this->description->setFormValue($val);
            }
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val);
            }
        }

        // Check field name 'discount_coupon' first before field var 'x_discount_coupon'
        $val = $CurrentForm->hasValue("discount_coupon") ? $CurrentForm->getValue("discount_coupon") : $CurrentForm->getValue("x_discount_coupon");
        if (!$this->discount_coupon->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->discount_coupon->Visible = false; // Disable update for API request
            } else {
                $this->discount_coupon->setFormValue($val);
            }
        }

        // Check field name 'discount' first before field var 'x_discount'
        $val = $CurrentForm->hasValue("discount") ? $CurrentForm->getValue("discount") : $CurrentForm->getValue("x_discount");
        if (!$this->discount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->discount->Visible = false; // Disable update for API request
            } else {
                $this->discount->setFormValue($val);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val);
            }
        }

        // Check field name 'valid_till' first before field var 'x_valid_till'
        $val = $CurrentForm->hasValue("valid_till") ? $CurrentForm->getValue("valid_till") : $CurrentForm->getValue("x_valid_till");
        if (!$this->valid_till->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->valid_till->Visible = false; // Disable update for API request
            } else {
                $this->valid_till->setFormValue($val, true, $validate);
            }
            $this->valid_till->CurrentValue = UnFormatDateTime($this->valid_till->CurrentValue, $this->valid_till->formatPattern());
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'response' first before field var 'x__response'
        $val = $CurrentForm->hasValue("response") ? $CurrentForm->getValue("response") : $CurrentForm->getValue("x__response");
        if (!$this->_response->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_response->Visible = false; // Disable update for API request
            } else {
                $this->_response->setFormValue($val);
            }
        }

        // Check field name 'admin_notes' first before field var 'x_admin_notes'
        $val = $CurrentForm->hasValue("admin_notes") ? $CurrentForm->getValue("admin_notes") : $CurrentForm->getValue("x_admin_notes");
        if (!$this->admin_notes->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->admin_notes->Visible = false; // Disable update for API request
            } else {
                $this->admin_notes->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->short_description->CurrentValue = $this->short_description->FormValue;
        $this->includes->CurrentValue = $this->includes->FormValue;
        $this->description->CurrentValue = $this->description->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->discount_coupon->CurrentValue = $this->discount_coupon->FormValue;
        $this->discount->CurrentValue = $this->discount->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->valid_till->CurrentValue = $this->valid_till->FormValue;
        $this->valid_till->CurrentValue = UnFormatDateTime($this->valid_till->CurrentValue, $this->valid_till->formatPattern());
        $this->status->CurrentValue = $this->status->FormValue;
        $this->_response->CurrentValue = $this->_response->FormValue;
        $this->admin_notes->CurrentValue = $this->admin_notes->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->category->setDbValue($row['category']);
        $this->short_description->setDbValue($row['short_description']);
        $this->includes->setDbValue($row['includes']);
        $this->description->setDbValue($row['description']);
        $this->price->setDbValue($row['price']);
        $this->discount_coupon->setDbValue($row['discount_coupon']);
        $this->discount->setDbValue($row['discount']);
        $this->amount->setDbValue($row['amount']);
        $this->valid_till->setDbValue($row['valid_till']);
        $this->status->setDbValue($row['status']);
        $this->_response->setDbValue($row['response']);
        $this->admin_notes->setDbValue($row['admin_notes']);
        $this->code->setDbValue($row['code']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->show_to->setDbValue($row['show_to']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['short_description'] = $this->short_description->DefaultValue;
        $row['includes'] = $this->includes->DefaultValue;
        $row['description'] = $this->description->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['discount_coupon'] = $this->discount_coupon->DefaultValue;
        $row['discount'] = $this->discount->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['valid_till'] = $this->valid_till->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['response'] = $this->_response->DefaultValue;
        $row['admin_notes'] = $this->admin_notes->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['show_to'] = $this->show_to->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // short_description
        $this->short_description->RowCssClass = "row";

        // includes
        $this->includes->RowCssClass = "row";

        // description
        $this->description->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // discount_coupon
        $this->discount_coupon->RowCssClass = "row";

        // discount
        $this->discount->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // valid_till
        $this->valid_till->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // response
        $this->_response->RowCssClass = "row";

        // admin_notes
        $this->admin_notes->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // show_to
        $this->show_to->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // short_description
            $curVal = strval($this->short_description->CurrentValue);
            if ($curVal != "") {
                $this->short_description->ViewValue = $this->short_description->lookupCacheOption($curVal);
                if ($this->short_description->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->short_description->Lookup->getTable()->Fields["short_description"]->searchExpression(), "=", $curVal, $this->short_description->Lookup->getTable()->Fields["short_description"]->searchDataType(), "");
                    $sqlWrk = $this->short_description->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->short_description->Lookup->renderViewRow($rswrk[0]);
                        $this->short_description->ViewValue = $this->short_description->displayValue($arwrk);
                    } else {
                        $this->short_description->ViewValue = $this->short_description->CurrentValue;
                    }
                }
            } else {
                $this->short_description->ViewValue = null;
            }
            $this->short_description->CssClass = "fw-bold";
            $this->short_description->ViewCustomAttributes = $this->short_description->getViewCustomAttributes(); // PHP

            // includes
            $curVal = strval($this->includes->CurrentValue);
            if ($curVal != "") {
                $this->includes->ViewValue = $this->includes->lookupCacheOption($curVal);
                if ($this->includes->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->includes->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->includes->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->includes->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->includes->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->includes->Lookup->renderViewRow($row);
                            $this->includes->ViewValue->add($this->includes->displayValue($arwrk));
                        }
                    } else {
                        $this->includes->ViewValue = $this->includes->CurrentValue;
                    }
                }
            } else {
                $this->includes->ViewValue = null;
            }

            // description
            $this->description->ViewValue = $this->description->CurrentValue;

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // discount_coupon
            $this->discount_coupon->ViewValue = $this->discount_coupon->CurrentValue;

            // discount
            $this->discount->ViewValue = $this->discount->CurrentValue;
            $this->discount->ViewValue = FormatNumber($this->discount->ViewValue, $this->discount->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());
            $this->amount->CssClass = "fw-bold";

            // valid_till
            $this->valid_till->ViewValue = $this->valid_till->CurrentValue;
            $this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, $this->valid_till->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // response
            $this->_response->ViewValue = $this->_response->CurrentValue;

            // admin_notes
            $this->admin_notes->ViewValue = $this->admin_notes->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // short_description
            $this->short_description->HrefValue = "";
            $this->short_description->TooltipValue = "";

            // includes
            $this->includes->HrefValue = "";
            $this->includes->TooltipValue = "";

            // description
            $this->description->HrefValue = "";
            $this->description->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // discount_coupon
            $this->discount_coupon->HrefValue = "";

            // discount
            $this->discount->HrefValue = "";
            $this->discount->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // valid_till
            $this->valid_till->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // response
            $this->_response->HrefValue = "";

            // admin_notes
            $this->admin_notes->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // short_description
            $this->short_description->setupEditAttributes();
            $curVal = strval($this->short_description->CurrentValue);
            if ($curVal != "") {
                $this->short_description->EditValue = $this->short_description->lookupCacheOption($curVal);
                if ($this->short_description->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->short_description->Lookup->getTable()->Fields["short_description"]->searchExpression(), "=", $curVal, $this->short_description->Lookup->getTable()->Fields["short_description"]->searchDataType(), "");
                    $sqlWrk = $this->short_description->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->short_description->Lookup->renderViewRow($rswrk[0]);
                        $this->short_description->EditValue = $this->short_description->displayValue($arwrk);
                    } else {
                        $this->short_description->EditValue = $this->short_description->CurrentValue;
                    }
                }
            } else {
                $this->short_description->EditValue = null;
            }
            $this->short_description->CssClass = "fw-bold";
            $this->short_description->ViewCustomAttributes = $this->short_description->getViewCustomAttributes(); // PHP

            // includes
            $this->includes->setupEditAttributes();
            $curVal = strval($this->includes->CurrentValue);
            if ($curVal != "") {
                $this->includes->EditValue = $this->includes->lookupCacheOption($curVal);
                if ($this->includes->EditValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->includes->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->includes->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->includes->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->includes->EditValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->includes->Lookup->renderViewRow($row);
                            $this->includes->EditValue->add($this->includes->displayValue($arwrk));
                        }
                    } else {
                        $this->includes->EditValue = $this->includes->CurrentValue;
                    }
                }
            } else {
                $this->includes->EditValue = null;
            }

            // description
            $this->description->setupEditAttributes();
            $this->description->EditValue = $this->description->CurrentValue;

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->CurrentValue;
            $this->price->EditValue = FormatNumber($this->price->EditValue, $this->price->formatPattern());

            // discount_coupon
            $this->discount_coupon->setupEditAttributes();
            if (!$this->discount_coupon->Raw) {
                $this->discount_coupon->CurrentValue = HtmlDecode($this->discount_coupon->CurrentValue);
            }
            $this->discount_coupon->EditValue = HtmlEncode($this->discount_coupon->CurrentValue);
            $this->discount_coupon->PlaceHolder = RemoveHtml($this->discount_coupon->caption());

            // discount
            $this->discount->setupEditAttributes();
            $this->discount->EditValue = $this->discount->CurrentValue;
            $this->discount->EditValue = FormatNumber($this->discount->EditValue, $this->discount->formatPattern());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, $this->amount->formatPattern());
            $this->amount->CssClass = "fw-bold";

            // valid_till
            $this->valid_till->setupEditAttributes();
            $this->valid_till->EditValue = HtmlEncode(FormatDateTime($this->valid_till->CurrentValue, $this->valid_till->formatPattern()));
            $this->valid_till->PlaceHolder = RemoveHtml($this->valid_till->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // response
            $this->_response->setupEditAttributes();
            $this->_response->EditValue = HtmlEncode($this->_response->CurrentValue);
            $this->_response->PlaceHolder = RemoveHtml($this->_response->caption());

            // admin_notes
            $this->admin_notes->setupEditAttributes();
            $this->admin_notes->EditValue = HtmlEncode($this->admin_notes->CurrentValue);
            $this->admin_notes->PlaceHolder = RemoveHtml($this->admin_notes->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // short_description
            $this->short_description->HrefValue = "";
            $this->short_description->TooltipValue = "";

            // includes
            $this->includes->HrefValue = "";
            $this->includes->TooltipValue = "";

            // description
            $this->description->HrefValue = "";
            $this->description->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // discount_coupon
            $this->discount_coupon->HrefValue = "";

            // discount
            $this->discount->HrefValue = "";
            $this->discount->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // valid_till
            $this->valid_till->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // response
            $this->_response->HrefValue = "";

            // admin_notes
            $this->admin_notes->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->short_description->Visible && $this->short_description->Required) {
                if (!$this->short_description->IsDetailKey && EmptyValue($this->short_description->FormValue)) {
                    $this->short_description->addErrorMessage(str_replace("%s", $this->short_description->caption(), $this->short_description->RequiredErrorMessage));
                }
            }
            if ($this->includes->Visible && $this->includes->Required) {
                if ($this->includes->FormValue == "") {
                    $this->includes->addErrorMessage(str_replace("%s", $this->includes->caption(), $this->includes->RequiredErrorMessage));
                }
            }
            if ($this->description->Visible && $this->description->Required) {
                if (!$this->description->IsDetailKey && EmptyValue($this->description->FormValue)) {
                    $this->description->addErrorMessage(str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
                }
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if ($this->discount_coupon->Visible && $this->discount_coupon->Required) {
                if (!$this->discount_coupon->IsDetailKey && EmptyValue($this->discount_coupon->FormValue)) {
                    $this->discount_coupon->addErrorMessage(str_replace("%s", $this->discount_coupon->caption(), $this->discount_coupon->RequiredErrorMessage));
                }
            }
            if ($this->discount->Visible && $this->discount->Required) {
                if (!$this->discount->IsDetailKey && EmptyValue($this->discount->FormValue)) {
                    $this->discount->addErrorMessage(str_replace("%s", $this->discount->caption(), $this->discount->RequiredErrorMessage));
                }
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if ($this->valid_till->Visible && $this->valid_till->Required) {
                if (!$this->valid_till->IsDetailKey && EmptyValue($this->valid_till->FormValue)) {
                    $this->valid_till->addErrorMessage(str_replace("%s", $this->valid_till->caption(), $this->valid_till->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->valid_till->FormValue, $this->valid_till->formatPattern())) {
                $this->valid_till->addErrorMessage($this->valid_till->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->_response->Visible && $this->_response->Required) {
                if (!$this->_response->IsDetailKey && EmptyValue($this->_response->FormValue)) {
                    $this->_response->addErrorMessage(str_replace("%s", $this->_response->caption(), $this->_response->RequiredErrorMessage));
                }
            }
            if ($this->admin_notes->Visible && $this->admin_notes->Required) {
                if (!$this->admin_notes->IsDetailKey && EmptyValue($this->admin_notes->FormValue)) {
                    $this->admin_notes->addErrorMessage(str_replace("%s", $this->admin_notes->caption(), $this->admin_notes->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // discount_coupon
        $this->discount_coupon->setDbValueDef($rsnew, $this->discount_coupon->CurrentValue, $this->discount_coupon->ReadOnly);

        // valid_till
        $this->valid_till->setDbValueDef($rsnew, UnFormatDateTime($this->valid_till->CurrentValue, $this->valid_till->formatPattern()), $this->valid_till->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // response
        $this->_response->setDbValueDef($rsnew, strval($this->_response->CurrentValue) == "1" ? "1" : "0", $this->_response->ReadOnly);

        // admin_notes
        $this->admin_notes->setDbValueDef($rsnew, $this->admin_notes->CurrentValue, $this->admin_notes->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['discount_coupon'])) { // discount_coupon
            $this->discount_coupon->CurrentValue = $row['discount_coupon'];
        }
        if (isset($row['valid_till'])) { // valid_till
            $this->valid_till->CurrentValue = $row['valid_till'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['response'])) { // response
            $this->_response->CurrentValue = $row['response'];
        }
        if (isset($row['admin_notes'])) { // admin_notes
            $this->admin_notes->CurrentValue = $row['admin_notes'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("shoplist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_category":
                    break;
                case "x_short_description":
                    break;
                case "x_includes":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	if (CurrentUserID() == -1)
    	{
    		$this->category->Visible = true;
    		$this->short_description->Visible = true;
    		$this->price->Visible = true;
    		$this->discount->Visible = true;
    		$this->valid_till->Visible = true;
    		$this->status->Visible = true;
    		$this->discount_coupon->Visible = true;
    		$this->admin_notes->Visible = true;		
    		$this->code->Visible = true;

    		//$this->category->ReadOnly = False;		
    		//$this->short_description->ReadOnly = False;
    		//$this->description->ReadOnly = False;
    		//$this->includes->ReadOnly = False;
    		//$this->price->ReadOnly = False;
    	}
    	else
    	{
    		$this->category->Visible = False;
    		$this->short_description->Visible = False;
    		$this->description->ReadOnly = True;		
    		$this->price->Visible = False;
    		$this->discount->Visible = False;
    		$this->valid_till->Visible = False;
    		$this->status->Visible = False;
    		$this->discount_coupon->Visible = False;
    		$this->admin_notes->Visible = False;
    		$this->code->Visible = False;

    		//$this->category->ReadOnly = True;		
    		//$this->short_description->ReadOnly = True;
    		//$this->description->ReadOnly = True;
    		//$this->includes->ReadOnly = True;
    		//$this->price->ReadOnly = True;
    		}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header) {
    	// Example:
    	//$header = "your header";
    		$upi = ExecuteScalar("SELECT `developer_upi_id` FROM `portal_setup` WHERE `id` = 200000");
    	$upi_name = ExecuteScalar("SELECT `developer_company` FROM `portal_setup` WHERE `id` = 200000");	
    	$str = $this->id->CurrentValue . preg_replace('/[^A-Za-z0-9 !@#$%^&*().]/u','', strip_tags(CompanyName())) . time() . '' ;
    	$qr =  'upi://pay?pa='.$upi.'%26pn='.$upi_name.'%26am='.$this->amount->CurrentValue.'%26tncu=INR%26tn='.$str.'%26tr='.$str;
    	$pay =  '<a href="'.str_replace("%26","&",$qr).'"><img class="ew-lazy" src="ewbarcode?data='.$qr.'&encode=QRCODE&height=150&color=%23000000" alt="UPI Image"><p style="font-size:7px; color:red">Scan/Click to Pay using <br>any mobile UPI app or <br>Direct bank transfer to <br>INTEGER SYSTEMS <br>at IDBI Bank,<br>A/C No: 0105102000024985, <br>IFS Code: IBKL0000105</p></a>';
    	$this->amount->Caption='Amount<br><br>'.$pay;
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
