<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ShippingAddressAdd extends ShippingAddress
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ShippingAddressAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "shippingaddressadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->type->setVisibility();
        $this->_userid->setVisibility();
        $this->formal_name->setVisibility();
        $this->country->setVisibility();
        $this->state->setVisibility();
        $this->city->setVisibility();
        $this->address->setVisibility();
        $this->city_name->Visible = false;
        $this->zipcode->setVisibility();
        $this->name->setVisibility();
        $this->_email->setVisibility();
        $this->mobile->setVisibility();
        $this->gst_number->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->cart_number->Visible = false;
        $this->r_text->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'shipping_address';
        $this->TableName = 'shipping_address';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (shipping_address)
        if (!isset($GLOBALS["shipping_address"]) || $GLOBALS["shipping_address"]::class == PROJECT_NAMESPACE . "shipping_address") {
            $GLOBALS["shipping_address"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'shipping_address');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "shippingaddressview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->_userid);
        $this->setupLookupOptions($this->country);
        $this->setupLookupOptions($this->state);
        $this->setupLookupOptions($this->city);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: Must be after loadOldRecord to prevent master key values being overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("shippingaddresslist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "shippingaddresslist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "shippingaddressview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions && !$this->getCurrentMasterTable()) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "shippingaddresslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "shippingaddresslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'type' first before field var 'x_type'
        $val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
        if (!$this->type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->type->Visible = false; // Disable update for API request
            } else {
                $this->type->setFormValue($val);
            }
        }

        // Check field name 'userid' first before field var 'x__userid'
        $val = $CurrentForm->hasValue("userid") ? $CurrentForm->getValue("userid") : $CurrentForm->getValue("x__userid");
        if (!$this->_userid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_userid->Visible = false; // Disable update for API request
            } else {
                $this->_userid->setFormValue($val);
            }
        }

        // Check field name 'formal_name' first before field var 'x_formal_name'
        $val = $CurrentForm->hasValue("formal_name") ? $CurrentForm->getValue("formal_name") : $CurrentForm->getValue("x_formal_name");
        if (!$this->formal_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->formal_name->Visible = false; // Disable update for API request
            } else {
                $this->formal_name->setFormValue($val);
            }
        }

        // Check field name 'country' first before field var 'x_country'
        $val = $CurrentForm->hasValue("country") ? $CurrentForm->getValue("country") : $CurrentForm->getValue("x_country");
        if (!$this->country->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->country->Visible = false; // Disable update for API request
            } else {
                $this->country->setFormValue($val);
            }
        }

        // Check field name 'state' first before field var 'x_state'
        $val = $CurrentForm->hasValue("state") ? $CurrentForm->getValue("state") : $CurrentForm->getValue("x_state");
        if (!$this->state->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->state->Visible = false; // Disable update for API request
            } else {
                $this->state->setFormValue($val);
            }
        }

        // Check field name 'city' first before field var 'x_city'
        $val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
        if (!$this->city->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->city->Visible = false; // Disable update for API request
            } else {
                $this->city->setFormValue($val);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'zipcode' first before field var 'x_zipcode'
        $val = $CurrentForm->hasValue("zipcode") ? $CurrentForm->getValue("zipcode") : $CurrentForm->getValue("x_zipcode");
        if (!$this->zipcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->zipcode->Visible = false; // Disable update for API request
            } else {
                $this->zipcode->setFormValue($val);
            }
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val);
            }
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }

        // Check field name 'gst_number' first before field var 'x_gst_number'
        $val = $CurrentForm->hasValue("gst_number") ? $CurrentForm->getValue("gst_number") : $CurrentForm->getValue("x_gst_number");
        if (!$this->gst_number->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gst_number->Visible = false; // Disable update for API request
            } else {
                $this->gst_number->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->type->CurrentValue = $this->type->FormValue;
        $this->_userid->CurrentValue = $this->_userid->FormValue;
        $this->formal_name->CurrentValue = $this->formal_name->FormValue;
        $this->country->CurrentValue = $this->country->FormValue;
        $this->state->CurrentValue = $this->state->FormValue;
        $this->city->CurrentValue = $this->city->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->zipcode->CurrentValue = $this->zipcode->FormValue;
        $this->name->CurrentValue = $this->name->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->gst_number->CurrentValue = $this->gst_number->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->type->setDbValue($row['type']);
        $this->_userid->setDbValue($row['userid']);
        $this->formal_name->setDbValue($row['formal_name']);
        $this->country->setDbValue($row['country']);
        $this->state->setDbValue($row['state']);
        $this->city->setDbValue($row['city']);
        if (array_key_exists('EV__city', $row)) {
            $this->city->VirtualValue = $row['EV__city']; // Set up virtual field value
        } else {
            $this->city->VirtualValue = ""; // Clear value
        }
        $this->address->setDbValue($row['address']);
        $this->city_name->setDbValue($row['city_name']);
        $this->zipcode->setDbValue($row['zipcode']);
        $this->name->setDbValue($row['name']);
        $this->_email->setDbValue($row['email']);
        $this->mobile->setDbValue($row['mobile']);
        $this->gst_number->setDbValue($row['gst_number']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->cart_number->setDbValue($row['cart_number']);
        $this->r_text->setDbValue($row['r_text']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['userid'] = $this->_userid->DefaultValue;
        $row['formal_name'] = $this->formal_name->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['state'] = $this->state->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['city_name'] = $this->city_name->DefaultValue;
        $row['zipcode'] = $this->zipcode->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['email'] = $this->_email->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['gst_number'] = $this->gst_number->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['cart_number'] = $this->cart_number->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // userid
        $this->_userid->RowCssClass = "row";

        // formal_name
        $this->formal_name->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // state
        $this->state->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // city_name
        $this->city_name->RowCssClass = "row";

        // zipcode
        $this->zipcode->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // email
        $this->_email->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // gst_number
        $this->gst_number->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // cart_number
        $this->cart_number->RowCssClass = "row";

        // r_text
        $this->r_text->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // userid
            $curVal = strval($this->_userid->CurrentValue);
            if ($curVal != "") {
                $this->_userid->ViewValue = $this->_userid->lookupCacheOption($curVal);
                if ($this->_userid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_userid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_userid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->_userid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_userid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_userid->Lookup->renderViewRow($rswrk[0]);
                        $this->_userid->ViewValue = $this->_userid->displayValue($arwrk);
                    } else {
                        $this->_userid->ViewValue = FormatNumber($this->_userid->CurrentValue, $this->_userid->formatPattern());
                    }
                }
            } else {
                $this->_userid->ViewValue = null;
            }

            // formal_name
            $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

            // country
            $curVal = strval($this->country->CurrentValue);
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
                if ($this->country->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                        $this->country->ViewValue = $this->country->displayValue($arwrk);
                    } else {
                        $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                    }
                }
            } else {
                $this->country->ViewValue = null;
            }

            // state
            $curVal = strval($this->state->CurrentValue);
            if ($curVal != "") {
                $this->state->ViewValue = $this->state->lookupCacheOption($curVal);
                if ($this->state->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->state->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->state->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->state->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->state->Lookup->renderViewRow($rswrk[0]);
                        $this->state->ViewValue = $this->state->displayValue($arwrk);
                    } else {
                        $this->state->ViewValue = FormatNumber($this->state->CurrentValue, $this->state->formatPattern());
                    }
                }
            } else {
                $this->state->ViewValue = null;
            }

            // city
            if ($this->city->VirtualValue != "") {
                $this->city->ViewValue = $this->city->VirtualValue;
            } else {
                $this->city->ViewValue = $this->city->CurrentValue;
                $curVal = strval($this->city->CurrentValue);
                if ($curVal != "") {
                    $this->city->ViewValue = $this->city->lookupCacheOption($curVal);
                    if ($this->city->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                            $this->city->ViewValue = $this->city->displayValue($arwrk);
                        } else {
                            $this->city->ViewValue = FormatNumber($this->city->CurrentValue, $this->city->formatPattern());
                        }
                    }
                } else {
                    $this->city->ViewValue = null;
                }
            }

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // city_name
            $this->city_name->ViewValue = $this->city_name->CurrentValue;

            // zipcode
            $this->zipcode->ViewValue = $this->zipcode->CurrentValue;

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // gst_number
            $this->gst_number->ViewValue = $this->gst_number->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // type
            $this->type->HrefValue = "";

            // userid
            $this->_userid->HrefValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // state
            $this->state->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // zipcode
            $this->zipcode->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // gst_number
            $this->gst_number->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // type
            $this->type->setupEditAttributes();
            $this->type->EditValue = $this->type->options(true);
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // userid
            $this->_userid->setupEditAttributes();
            if ($this->_userid->getSessionValue() != "") {
                $this->_userid->CurrentValue = GetForeignKeyValue($this->_userid->getSessionValue());
                $curVal = strval($this->_userid->CurrentValue);
                if ($curVal != "") {
                    $this->_userid->ViewValue = $this->_userid->lookupCacheOption($curVal);
                    if ($this->_userid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->_userid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_userid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $lookupFilter = $this->_userid->getSelectFilter($this); // PHP
                        $sqlWrk = $this->_userid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->_userid->Lookup->renderViewRow($rswrk[0]);
                            $this->_userid->ViewValue = $this->_userid->displayValue($arwrk);
                        } else {
                            $this->_userid->ViewValue = FormatNumber($this->_userid->CurrentValue, $this->_userid->formatPattern());
                        }
                    }
                } else {
                    $this->_userid->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->_userid->CurrentValue));
                if ($curVal != "") {
                    $this->_userid->ViewValue = $this->_userid->lookupCacheOption($curVal);
                } else {
                    $this->_userid->ViewValue = $this->_userid->Lookup !== null && is_array($this->_userid->lookupOptions()) && count($this->_userid->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->_userid->ViewValue !== null) { // Load from cache
                    $this->_userid->EditValue = array_values($this->_userid->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->_userid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->_userid->CurrentValue, $this->_userid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->_userid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_userid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->_userid->EditValue = $arwrk;
                }
                $this->_userid->PlaceHolder = RemoveHtml($this->_userid->caption());
            }

            // formal_name
            $this->formal_name->setupEditAttributes();
            if (!$this->formal_name->Raw) {
                $this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
            }
            $this->formal_name->EditValue = HtmlEncode($this->formal_name->CurrentValue);
            $this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

            // country
            $this->country->setupEditAttributes();
            $curVal = trim(strval($this->country->CurrentValue));
            if ($curVal != "") {
                $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
            } else {
                $this->country->ViewValue = $this->country->Lookup !== null && is_array($this->country->lookupOptions()) && count($this->country->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->country->ViewValue !== null) { // Load from cache
                $this->country->EditValue = array_values($this->country->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->country->CurrentValue, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->country->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->country->EditValue = $arwrk;
            }
            $this->country->PlaceHolder = RemoveHtml($this->country->caption());

            // state
            $this->state->setupEditAttributes();
            $curVal = trim(strval($this->state->CurrentValue));
            if ($curVal != "") {
                $this->state->ViewValue = $this->state->lookupCacheOption($curVal);
            } else {
                $this->state->ViewValue = $this->state->Lookup !== null && is_array($this->state->lookupOptions()) && count($this->state->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->state->ViewValue !== null) { // Load from cache
                $this->state->EditValue = array_values($this->state->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->state->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->state->CurrentValue, $this->state->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->state->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->state->EditValue = $arwrk;
            }
            $this->state->PlaceHolder = RemoveHtml($this->state->caption());

            // city
            $this->city->setupEditAttributes();
            $this->city->EditValue = $this->city->CurrentValue;
            $curVal = strval($this->city->CurrentValue);
            if ($curVal != "") {
                $this->city->EditValue = $this->city->lookupCacheOption($curVal);
                if ($this->city->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                        $this->city->EditValue = $this->city->displayValue($arwrk);
                    } else {
                        $this->city->EditValue = HtmlEncode(FormatNumber($this->city->CurrentValue, $this->city->formatPattern()));
                    }
                }
            } else {
                $this->city->EditValue = null;
            }
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // zipcode
            $this->zipcode->setupEditAttributes();
            if (!$this->zipcode->Raw) {
                $this->zipcode->CurrentValue = HtmlDecode($this->zipcode->CurrentValue);
            }
            $this->zipcode->EditValue = HtmlEncode($this->zipcode->CurrentValue);
            $this->zipcode->PlaceHolder = RemoveHtml($this->zipcode->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // email
            $this->_email->setupEditAttributes();
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // gst_number
            $this->gst_number->setupEditAttributes();
            if (!$this->gst_number->Raw) {
                $this->gst_number->CurrentValue = HtmlDecode($this->gst_number->CurrentValue);
            }
            $this->gst_number->EditValue = HtmlEncode($this->gst_number->CurrentValue);
            $this->gst_number->PlaceHolder = RemoveHtml($this->gst_number->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // Add refer script

            // type
            $this->type->HrefValue = "";

            // userid
            $this->_userid->HrefValue = "";

            // formal_name
            $this->formal_name->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // state
            $this->state->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // zipcode
            $this->zipcode->HrefValue = "";

            // name
            $this->name->HrefValue = "";

            // email
            $this->_email->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // gst_number
            $this->gst_number->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Render add option
    public function renderAddOpt($row)
    {
        global $Security, $Language, $CurrentLanguage;

        // Set up CurrentValue
        $this->type->CurrentValue = $row["type"] ?? null;
        $this->_userid->CurrentValue = $row["userid"] ?? null;
        $this->formal_name->CurrentValue = $row["formal_name"] ?? null;
        $this->country->CurrentValue = $row["country"] ?? null;
        $this->state->CurrentValue = $row["state"] ?? null;
        $this->city->CurrentValue = $row["city"] ?? null;
        $this->address->CurrentValue = $row["address"] ?? null;
        $this->zipcode->CurrentValue = $row["zipcode"] ?? null;
        $this->name->CurrentValue = $row["name"] ?? null;
        $this->_email->CurrentValue = $row["email"] ?? null;
        $this->mobile->CurrentValue = $row["mobile"] ?? null;
        $this->gst_number->CurrentValue = $row["gst_number"] ?? null;
        $this->status->CurrentValue = $row["status"] ?? null;
        $this->operator->CurrentValue = $row["operator"] ?? null;
        $this->datetime->CurrentValue = $row["datetime"] ?? null;

        // type
        if (strval($this->type->CurrentValue) != "") {
            $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
        } else {
            $this->type->ViewValue = null;
        }

        // userid
        $curVal = strval($this->_userid->CurrentValue);
        if ($curVal != "") {
            $this->_userid->ViewValue = $this->_userid->lookupCacheOption($curVal);
            if ($this->_userid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->_userid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->_userid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->_userid->getSelectFilter($this); // PHP
                $sqlWrk = $this->_userid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->_userid->Lookup->renderViewRow($rswrk[0]);
                    $this->_userid->ViewValue = $this->_userid->displayValue($arwrk);
                } else {
                    $this->_userid->ViewValue = FormatNumber($this->_userid->CurrentValue, $this->_userid->formatPattern());
                }
            }
        } else {
            $this->_userid->ViewValue = null;
        }

        // formal_name
        $this->formal_name->ViewValue = $this->formal_name->CurrentValue;

        // country
        $curVal = strval($this->country->CurrentValue);
        if ($curVal != "") {
            $this->country->ViewValue = $this->country->lookupCacheOption($curVal);
            if ($this->country->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->country->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->country->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->country->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->country->Lookup->renderViewRow($rswrk[0]);
                    $this->country->ViewValue = $this->country->displayValue($arwrk);
                } else {
                    $this->country->ViewValue = FormatNumber($this->country->CurrentValue, $this->country->formatPattern());
                }
            }
        } else {
            $this->country->ViewValue = null;
        }

        // state
        $curVal = strval($this->state->CurrentValue);
        if ($curVal != "") {
            $this->state->ViewValue = $this->state->lookupCacheOption($curVal);
            if ($this->state->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->state->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->state->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->state->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->state->Lookup->renderViewRow($rswrk[0]);
                    $this->state->ViewValue = $this->state->displayValue($arwrk);
                } else {
                    $this->state->ViewValue = FormatNumber($this->state->CurrentValue, $this->state->formatPattern());
                }
            }
        } else {
            $this->state->ViewValue = null;
        }

        // city
        if ($this->city->VirtualValue != "") {
            $this->city->ViewValue = $this->city->VirtualValue;
        } else {
            $this->city->ViewValue = $this->city->CurrentValue;
            $curVal = strval($this->city->CurrentValue);
            if ($curVal != "") {
                $this->city->ViewValue = $this->city->lookupCacheOption($curVal);
                if ($this->city->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->city->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->city->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->city->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->city->Lookup->renderViewRow($rswrk[0]);
                        $this->city->ViewValue = $this->city->displayValue($arwrk);
                    } else {
                        $this->city->ViewValue = FormatNumber($this->city->CurrentValue, $this->city->formatPattern());
                    }
                }
            } else {
                $this->city->ViewValue = null;
            }
        }

        // address
        $this->address->ViewValue = $this->address->CurrentValue;

        // zipcode
        $this->zipcode->ViewValue = $this->zipcode->CurrentValue;

        // name
        $this->name->ViewValue = $this->name->CurrentValue;

        // email
        $this->_email->ViewValue = $this->_email->CurrentValue;

        // mobile
        $this->mobile->ViewValue = $this->mobile->CurrentValue;

        // gst_number
        $this->gst_number->ViewValue = $this->gst_number->CurrentValue;

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // Set up $row
        $row["type"] = $this->type->ViewValue;
        $row["formal_name"] = $this->formal_name->ViewValue;
        $row["country"] = $this->country->ViewValue;
        $row["state"] = $this->state->ViewValue;
        $row["city"] = $this->city->ViewValue;
        $row["address"] = $this->address->ViewValue;
        $row["zipcode"] = $this->zipcode->ViewValue;
        $row["name"] = $this->name->ViewValue;
        $row["email"] = $this->_email->ViewValue;
        $row["mobile"] = $this->mobile->ViewValue;
        $row["gst_number"] = $this->gst_number->ViewValue;
        $row["status"] = $this->status->ViewValue;
        $row["operator"] = $this->operator->ViewValue;
        $row["datetime"] = $this->datetime->ViewValue;
        return $row;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->type->Visible && $this->type->Required) {
                if (!$this->type->IsDetailKey && EmptyValue($this->type->FormValue)) {
                    $this->type->addErrorMessage(str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
                }
            }
            if ($this->_userid->Visible && $this->_userid->Required) {
                if (!$this->_userid->IsDetailKey && EmptyValue($this->_userid->FormValue)) {
                    $this->_userid->addErrorMessage(str_replace("%s", $this->_userid->caption(), $this->_userid->RequiredErrorMessage));
                }
            }
            if ($this->formal_name->Visible && $this->formal_name->Required) {
                if (!$this->formal_name->IsDetailKey && EmptyValue($this->formal_name->FormValue)) {
                    $this->formal_name->addErrorMessage(str_replace("%s", $this->formal_name->caption(), $this->formal_name->RequiredErrorMessage));
                }
            }
            if ($this->country->Visible && $this->country->Required) {
                if (!$this->country->IsDetailKey && EmptyValue($this->country->FormValue)) {
                    $this->country->addErrorMessage(str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
                }
            }
            if ($this->state->Visible && $this->state->Required) {
                if (!$this->state->IsDetailKey && EmptyValue($this->state->FormValue)) {
                    $this->state->addErrorMessage(str_replace("%s", $this->state->caption(), $this->state->RequiredErrorMessage));
                }
            }
            if ($this->city->Visible && $this->city->Required) {
                if (!$this->city->IsDetailKey && EmptyValue($this->city->FormValue)) {
                    $this->city->addErrorMessage(str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
                }
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->zipcode->Visible && $this->zipcode->Required) {
                if (!$this->zipcode->IsDetailKey && EmptyValue($this->zipcode->FormValue)) {
                    $this->zipcode->addErrorMessage(str_replace("%s", $this->zipcode->caption(), $this->zipcode->RequiredErrorMessage));
                }
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->_email->Visible && $this->_email->Required) {
                if (!$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                    $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->gst_number->Visible && $this->gst_number->Required) {
                if (!$this->gst_number->IsDetailKey && EmptyValue($this->gst_number->FormValue)) {
                    $this->gst_number->addErrorMessage(str_replace("%s", $this->gst_number->caption(), $this->gst_number->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            if (Post("addopt") == "1") { // Render for add option response
                $row = $this->renderAddOpt($row);
            }
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // type
        $this->type->setDbValueDef($rsnew, $this->type->CurrentValue, false);

        // userid
        $this->_userid->setDbValueDef($rsnew, $this->_userid->CurrentValue, false);

        // formal_name
        $this->formal_name->setDbValueDef($rsnew, $this->formal_name->CurrentValue, false);

        // country
        $this->country->setDbValueDef($rsnew, $this->country->CurrentValue, false);

        // state
        $this->state->setDbValueDef($rsnew, $this->state->CurrentValue, false);

        // city
        $this->city->setDbValueDef($rsnew, $this->city->CurrentValue, false);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, false);

        // zipcode
        $this->zipcode->setDbValueDef($rsnew, $this->zipcode->CurrentValue, false);

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, false);

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, false);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, false);

        // gst_number
        $this->gst_number->setDbValueDef($rsnew, $this->gst_number->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, strval($this->status->CurrentValue) == "");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['type'])) { // type
            $this->type->setFormValue($row['type']);
        }
        if (isset($row['userid'])) { // userid
            $this->_userid->setFormValue($row['userid']);
        }
        if (isset($row['formal_name'])) { // formal_name
            $this->formal_name->setFormValue($row['formal_name']);
        }
        if (isset($row['country'])) { // country
            $this->country->setFormValue($row['country']);
        }
        if (isset($row['state'])) { // state
            $this->state->setFormValue($row['state']);
        }
        if (isset($row['city'])) { // city
            $this->city->setFormValue($row['city']);
        }
        if (isset($row['address'])) { // address
            $this->address->setFormValue($row['address']);
        }
        if (isset($row['zipcode'])) { // zipcode
            $this->zipcode->setFormValue($row['zipcode']);
        }
        if (isset($row['name'])) { // name
            $this->name->setFormValue($row['name']);
        }
        if (isset($row['email'])) { // email
            $this->_email->setFormValue($row['email']);
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->setFormValue($row['mobile']);
        }
        if (isset($row['gst_number'])) { // gst_number
            $this->gst_number->setFormValue($row['gst_number']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "production_partner") {
                $validMaster = true;
                $masterTbl = Container("production_partner");
                if (($parm = Get("fk_id", Get("_userid"))) !== null) {
                    $masterTbl->id->setQueryStringValue($parm);
                    $this->_userid->QueryStringValue = $masterTbl->id->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->_userid->setSessionValue($this->_userid->QueryStringValue);
                    $foreignKeys["_userid"] = $this->_userid->QueryStringValue;
                    if (!is_numeric($masterTbl->id->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "production_partner") {
                $validMaster = true;
                $masterTbl = Container("production_partner");
                if (($parm = Post("fk_id", Post("_userid"))) !== null) {
                    $masterTbl->id->setFormValue($parm);
                    $this->_userid->FormValue = $masterTbl->id->FormValue;
                    $this->_userid->setSessionValue($this->_userid->FormValue);
                    $foreignKeys["_userid"] = $this->_userid->FormValue;
                    if (!is_numeric($masterTbl->id->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "production_partner") {
                if (!array_key_exists("_userid", $foreignKeys)) { // Not current foreign key
                    $this->_userid->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("shippingaddresslist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_type":
                    break;
                case "x__userid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_country":
                    break;
                case "x_state":
                    break;
                case "x_city":
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
