<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ShareTransferSearch extends ShareTransfer
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ShareTransferSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "sharetransfersearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->folio_new->setVisibility();
        $this->folio_old->setVisibility();
        $this->adviser->setVisibility();
        $this->quantity->setVisibility();
        $this->transfer_date->setVisibility();
        $this->share_no_start->setVisibility();
        $this->share_no_end->setVisibility();
        $this->pan->setVisibility();
        $this->aadhaar->setVisibility();
        $this->duty_folio_new->setVisibility();
        $this->duty_company->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->updated->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'share_transfer';
        $this->TableName = 'share_transfer';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (share_transfer)
        if (!isset($GLOBALS["share_transfer"]) || $GLOBALS["share_transfer"]::class == PROJECT_NAMESPACE . "share_transfer") {
            $GLOBALS["share_transfer"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'share_transfer');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "sharetransferview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->folio_new);
        $this->setupLookupOptions($this->folio_old);
        $this->setupLookupOptions($this->adviser);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "sharetransferlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->folio_new); // folio_new
        $this->buildSearchUrl($srchUrl, $this->folio_old); // folio_old
        $this->buildSearchUrl($srchUrl, $this->adviser); // adviser
        $this->buildSearchUrl($srchUrl, $this->quantity); // quantity
        $this->buildSearchUrl($srchUrl, $this->transfer_date); // transfer_date
        $this->buildSearchUrl($srchUrl, $this->share_no_start); // share_no_start
        $this->buildSearchUrl($srchUrl, $this->share_no_end); // share_no_end
        $this->buildSearchUrl($srchUrl, $this->pan); // pan
        $this->buildSearchUrl($srchUrl, $this->aadhaar); // aadhaar
        $this->buildSearchUrl($srchUrl, $this->duty_folio_new); // duty_folio_new
        $this->buildSearchUrl($srchUrl, $this->duty_company); // duty_company
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // folio_new
        if ($this->folio_new->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // folio_old
        if ($this->folio_old->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // adviser
        if ($this->adviser->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // transfer_date
        if ($this->transfer_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // share_no_start
        if ($this->share_no_start->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // share_no_end
        if ($this->share_no_end->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // pan
        if ($this->pan->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // aadhaar
        if ($this->aadhaar->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // duty_folio_new
        if ($this->duty_folio_new->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // duty_company
        if ($this->duty_company->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // folio_new
        $this->folio_new->RowCssClass = "row";

        // folio_old
        $this->folio_old->RowCssClass = "row";

        // adviser
        $this->adviser->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // transfer_date
        $this->transfer_date->RowCssClass = "row";

        // share_no_start
        $this->share_no_start->RowCssClass = "row";

        // share_no_end
        $this->share_no_end->RowCssClass = "row";

        // pan
        $this->pan->RowCssClass = "row";

        // aadhaar
        $this->aadhaar->RowCssClass = "row";

        // duty_folio_new
        $this->duty_folio_new->RowCssClass = "row";

        // duty_company
        $this->duty_company->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // folio_new
            if ($this->folio_new->VirtualValue != "") {
                $this->folio_new->ViewValue = $this->folio_new->VirtualValue;
            } else {
                $this->folio_new->ViewValue = $this->folio_new->CurrentValue;
                $curVal = strval($this->folio_new->CurrentValue);
                if ($curVal != "") {
                    $this->folio_new->ViewValue = $this->folio_new->lookupCacheOption($curVal);
                    if ($this->folio_new->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->folio_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->folio_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->folio_new->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->folio_new->Lookup->renderViewRow($rswrk[0]);
                            $this->folio_new->ViewValue = $this->folio_new->displayValue($arwrk);
                        } else {
                            $this->folio_new->ViewValue = FormatNumber($this->folio_new->CurrentValue, $this->folio_new->formatPattern());
                        }
                    }
                } else {
                    $this->folio_new->ViewValue = null;
                }
            }

            // folio_old
            $this->folio_old->ViewValue = $this->folio_old->CurrentValue;
            $curVal = strval($this->folio_old->CurrentValue);
            if ($curVal != "") {
                $this->folio_old->ViewValue = $this->folio_old->lookupCacheOption($curVal);
                if ($this->folio_old->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->folio_old->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->folio_old->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->folio_old->getSelectFilter($this); // PHP
                    $sqlWrk = $this->folio_old->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->folio_old->Lookup->renderViewRow($rswrk[0]);
                        $this->folio_old->ViewValue = $this->folio_old->displayValue($arwrk);
                    } else {
                        $this->folio_old->ViewValue = FormatNumber($this->folio_old->CurrentValue, $this->folio_old->formatPattern());
                    }
                }
            } else {
                $this->folio_old->ViewValue = null;
            }

            // adviser
            $curVal = strval($this->adviser->CurrentValue);
            if ($curVal != "") {
                $this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
                if ($this->adviser->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->adviser->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->adviser->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->adviser->getSelectFilter($this); // PHP
                    $sqlWrk = $this->adviser->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->adviser->Lookup->renderViewRow($rswrk[0]);
                        $this->adviser->ViewValue = $this->adviser->displayValue($arwrk);
                    } else {
                        $this->adviser->ViewValue = FormatNumber($this->adviser->CurrentValue, $this->adviser->formatPattern());
                    }
                }
            } else {
                $this->adviser->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // transfer_date
            $this->transfer_date->ViewValue = $this->transfer_date->CurrentValue;
            $this->transfer_date->ViewValue = FormatDateTime($this->transfer_date->ViewValue, $this->transfer_date->formatPattern());

            // share_no_start
            $this->share_no_start->ViewValue = $this->share_no_start->CurrentValue;
            $this->share_no_start->ViewValue = FormatNumber($this->share_no_start->ViewValue, $this->share_no_start->formatPattern());

            // share_no_end
            $this->share_no_end->ViewValue = $this->share_no_end->CurrentValue;
            $this->share_no_end->ViewValue = FormatNumber($this->share_no_end->ViewValue, $this->share_no_end->formatPattern());

            // pan
            $this->pan->ViewValue = $this->pan->CurrentValue;

            // aadhaar
            $this->aadhaar->ViewValue = $this->aadhaar->CurrentValue;

            // duty_folio_new
            $this->duty_folio_new->ViewValue = $this->duty_folio_new->CurrentValue;
            $this->duty_folio_new->ViewValue = FormatNumber($this->duty_folio_new->ViewValue, $this->duty_folio_new->formatPattern());

            // duty_company
            $this->duty_company->ViewValue = $this->duty_company->CurrentValue;
            $this->duty_company->ViewValue = FormatNumber($this->duty_company->ViewValue, $this->duty_company->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // folio_new
            $this->folio_new->HrefValue = "";
            $this->folio_new->TooltipValue = "";

            // folio_old
            $this->folio_old->HrefValue = "";
            $this->folio_old->TooltipValue = "";

            // adviser
            $this->adviser->HrefValue = "";
            $this->adviser->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // transfer_date
            $this->transfer_date->HrefValue = "";
            $this->transfer_date->TooltipValue = "";

            // share_no_start
            $this->share_no_start->HrefValue = "";
            $this->share_no_start->TooltipValue = "";

            // share_no_end
            $this->share_no_end->HrefValue = "";
            $this->share_no_end->TooltipValue = "";

            // pan
            $this->pan->HrefValue = "";
            $this->pan->TooltipValue = "";

            // aadhaar
            $this->aadhaar->HrefValue = "";
            $this->aadhaar->TooltipValue = "";

            // duty_folio_new
            $this->duty_folio_new->HrefValue = "";
            $this->duty_folio_new->TooltipValue = "";

            // duty_company
            $this->duty_company->HrefValue = "";
            $this->duty_company->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // folio_new
            $this->folio_new->setupEditAttributes();
            $this->folio_new->EditValue = $this->folio_new->AdvancedSearch->SearchValue;
            $this->folio_new->PlaceHolder = RemoveHtml($this->folio_new->caption());

            // folio_old
            $this->folio_old->setupEditAttributes();
            $this->folio_old->EditValue = $this->folio_old->AdvancedSearch->SearchValue;
            $curVal = strval($this->folio_old->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->folio_old->EditValue = $this->folio_old->lookupCacheOption($curVal);
                if ($this->folio_old->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->folio_old->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->folio_old->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->folio_old->getSelectFilter($this); // PHP
                    $sqlWrk = $this->folio_old->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->folio_old->Lookup->renderViewRow($rswrk[0]);
                        $this->folio_old->EditValue = $this->folio_old->displayValue($arwrk);
                    } else {
                        $this->folio_old->EditValue = HtmlEncode(FormatNumber($this->folio_old->AdvancedSearch->SearchValue, $this->folio_old->formatPattern()));
                    }
                }
            } else {
                $this->folio_old->EditValue = null;
            }
            $this->folio_old->PlaceHolder = RemoveHtml($this->folio_old->caption());

            // adviser
            $this->adviser->setupEditAttributes();
            $curVal = trim(strval($this->adviser->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->adviser->AdvancedSearch->ViewValue = $this->adviser->lookupCacheOption($curVal);
            } else {
                $this->adviser->AdvancedSearch->ViewValue = $this->adviser->Lookup !== null && is_array($this->adviser->lookupOptions()) && count($this->adviser->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->adviser->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->adviser->EditValue = array_values($this->adviser->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->adviser->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->adviser->AdvancedSearch->SearchValue, $this->adviser->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->adviser->getSelectFilter($this); // PHP
                $sqlWrk = $this->adviser->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->adviser->EditValue = $arwrk;
            }
            $this->adviser->PlaceHolder = RemoveHtml($this->adviser->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // transfer_date
            $this->transfer_date->setupEditAttributes();
            $this->transfer_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->transfer_date->AdvancedSearch->SearchValue, $this->transfer_date->formatPattern()), $this->transfer_date->formatPattern()));
            $this->transfer_date->PlaceHolder = RemoveHtml($this->transfer_date->caption());
            $this->transfer_date->setupEditAttributes();
            $this->transfer_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->transfer_date->AdvancedSearch->SearchValue2, $this->transfer_date->formatPattern()), $this->transfer_date->formatPattern()));
            $this->transfer_date->PlaceHolder = RemoveHtml($this->transfer_date->caption());

            // share_no_start
            $this->share_no_start->setupEditAttributes();
            $this->share_no_start->EditCustomAttributes = $this->share_no_start->getEditCustomAttributes(); // PHP
            $this->share_no_start->EditValue = $this->share_no_start->AdvancedSearch->SearchValue;
            $this->share_no_start->PlaceHolder = RemoveHtml($this->share_no_start->caption());

            // share_no_end
            $this->share_no_end->setupEditAttributes();
            $this->share_no_end->EditCustomAttributes = $this->share_no_end->getEditCustomAttributes(); // PHP
            $this->share_no_end->EditValue = $this->share_no_end->AdvancedSearch->SearchValue;
            $this->share_no_end->PlaceHolder = RemoveHtml($this->share_no_end->caption());

            // pan
            $this->pan->setupEditAttributes();
            if (!$this->pan->Raw) {
                $this->pan->AdvancedSearch->SearchValue = HtmlDecode($this->pan->AdvancedSearch->SearchValue);
            }
            $this->pan->EditValue = HtmlEncode($this->pan->AdvancedSearch->SearchValue);
            $this->pan->PlaceHolder = RemoveHtml($this->pan->caption());

            // aadhaar
            $this->aadhaar->setupEditAttributes();
            if (!$this->aadhaar->Raw) {
                $this->aadhaar->AdvancedSearch->SearchValue = HtmlDecode($this->aadhaar->AdvancedSearch->SearchValue);
            }
            $this->aadhaar->EditValue = HtmlEncode($this->aadhaar->AdvancedSearch->SearchValue);
            $this->aadhaar->PlaceHolder = RemoveHtml($this->aadhaar->caption());

            // duty_folio_new
            $this->duty_folio_new->setupEditAttributes();
            $this->duty_folio_new->EditValue = $this->duty_folio_new->AdvancedSearch->SearchValue;
            $this->duty_folio_new->PlaceHolder = RemoveHtml($this->duty_folio_new->caption());

            // duty_company
            $this->duty_company->setupEditAttributes();
            $this->duty_company->EditValue = $this->duty_company->AdvancedSearch->SearchValue;
            $this->duty_company->PlaceHolder = RemoveHtml($this->duty_company->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->folio_old->AdvancedSearch->SearchValue)) {
            $this->folio_old->addErrorMessage($this->folio_old->getErrorMessage(false));
        }
        if (!CheckInteger($this->quantity->AdvancedSearch->SearchValue)) {
            $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
        }
        if (!CheckDate($this->transfer_date->AdvancedSearch->SearchValue, $this->transfer_date->formatPattern())) {
            $this->transfer_date->addErrorMessage($this->transfer_date->getErrorMessage(false));
        }
        if (!CheckDate($this->transfer_date->AdvancedSearch->SearchValue2, $this->transfer_date->formatPattern())) {
            $this->transfer_date->addErrorMessage($this->transfer_date->getErrorMessage(false));
        }
        if (!CheckInteger($this->share_no_start->AdvancedSearch->SearchValue)) {
            $this->share_no_start->addErrorMessage($this->share_no_start->getErrorMessage(false));
        }
        if (!CheckInteger($this->share_no_end->AdvancedSearch->SearchValue)) {
            $this->share_no_end->addErrorMessage($this->share_no_end->getErrorMessage(false));
        }
        if (!CheckNumber($this->duty_folio_new->AdvancedSearch->SearchValue)) {
            $this->duty_folio_new->addErrorMessage($this->duty_folio_new->getErrorMessage(false));
        }
        if (!CheckNumber($this->duty_company->AdvancedSearch->SearchValue)) {
            $this->duty_company->addErrorMessage($this->duty_company->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckInteger($this->datetime->AdvancedSearch->SearchValue)) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->folio_new->AdvancedSearch->load();
        $this->folio_old->AdvancedSearch->load();
        $this->adviser->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->transfer_date->AdvancedSearch->load();
        $this->share_no_start->AdvancedSearch->load();
        $this->share_no_end->AdvancedSearch->load();
        $this->pan->AdvancedSearch->load();
        $this->aadhaar->AdvancedSearch->load();
        $this->duty_folio_new->AdvancedSearch->load();
        $this->duty_company->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("sharetransferlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_folio_new":
                    break;
                case "x_folio_old":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_adviser":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
