<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ShareTransferAdd extends ShareTransfer
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ShareTransferAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "sharetransferadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->folio_new->setVisibility();
        $this->folio_old->setVisibility();
        $this->adviser->setVisibility();
        $this->quantity->setVisibility();
        $this->transfer_date->setVisibility();
        $this->share_no_start->setVisibility();
        $this->share_no_end->setVisibility();
        $this->pan->Visible = false;
        $this->aadhaar->Visible = false;
        $this->duty_folio_new->Visible = false;
        $this->duty_company->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->updated->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'share_transfer';
        $this->TableName = 'share_transfer';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (share_transfer)
        if (!isset($GLOBALS["share_transfer"]) || $GLOBALS["share_transfer"]::class == PROJECT_NAMESPACE . "share_transfer") {
            $GLOBALS["share_transfer"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'share_transfer');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "sharetransferview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->folio_new);
        $this->setupLookupOptions($this->folio_old);
        $this->setupLookupOptions($this->adviser);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("sharetransferlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "sharetransferlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "sharetransferview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "sharetransferlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "sharetransferlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->folio_new->DefaultValue = $this->folio_new->getDefault(); // PHP
        $this->folio_new->OldValue = $this->folio_new->DefaultValue;
        $this->transfer_date->DefaultValue = $this->transfer_date->getDefault(); // PHP
        $this->transfer_date->OldValue = $this->transfer_date->DefaultValue;
        $this->duty_folio_new->DefaultValue = $this->duty_folio_new->getDefault(); // PHP
        $this->duty_folio_new->OldValue = $this->duty_folio_new->DefaultValue;
        $this->duty_company->DefaultValue = $this->duty_company->getDefault(); // PHP
        $this->duty_company->OldValue = $this->duty_company->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->updated->DefaultValue = $this->updated->getDefault(); // PHP
        $this->updated->OldValue = $this->updated->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'folio_new' first before field var 'x_folio_new'
        $val = $CurrentForm->hasValue("folio_new") ? $CurrentForm->getValue("folio_new") : $CurrentForm->getValue("x_folio_new");
        if (!$this->folio_new->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->folio_new->Visible = false; // Disable update for API request
            } else {
                $this->folio_new->setFormValue($val);
            }
        }

        // Check field name 'folio_old' first before field var 'x_folio_old'
        $val = $CurrentForm->hasValue("folio_old") ? $CurrentForm->getValue("folio_old") : $CurrentForm->getValue("x_folio_old");
        if (!$this->folio_old->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->folio_old->Visible = false; // Disable update for API request
            } else {
                $this->folio_old->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'adviser' first before field var 'x_adviser'
        $val = $CurrentForm->hasValue("adviser") ? $CurrentForm->getValue("adviser") : $CurrentForm->getValue("x_adviser");
        if (!$this->adviser->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->adviser->Visible = false; // Disable update for API request
            } else {
                $this->adviser->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'transfer_date' first before field var 'x_transfer_date'
        $val = $CurrentForm->hasValue("transfer_date") ? $CurrentForm->getValue("transfer_date") : $CurrentForm->getValue("x_transfer_date");
        if (!$this->transfer_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->transfer_date->Visible = false; // Disable update for API request
            } else {
                $this->transfer_date->setFormValue($val, true, $validate);
            }
            $this->transfer_date->CurrentValue = UnFormatDateTime($this->transfer_date->CurrentValue, $this->transfer_date->formatPattern());
        }

        // Check field name 'share_no_start' first before field var 'x_share_no_start'
        $val = $CurrentForm->hasValue("share_no_start") ? $CurrentForm->getValue("share_no_start") : $CurrentForm->getValue("x_share_no_start");
        if (!$this->share_no_start->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->share_no_start->Visible = false; // Disable update for API request
            } else {
                $this->share_no_start->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'share_no_end' first before field var 'x_share_no_end'
        $val = $CurrentForm->hasValue("share_no_end") ? $CurrentForm->getValue("share_no_end") : $CurrentForm->getValue("x_share_no_end");
        if (!$this->share_no_end->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->share_no_end->Visible = false; // Disable update for API request
            } else {
                $this->share_no_end->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->folio_new->CurrentValue = $this->folio_new->FormValue;
        $this->folio_old->CurrentValue = $this->folio_old->FormValue;
        $this->adviser->CurrentValue = $this->adviser->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->transfer_date->CurrentValue = $this->transfer_date->FormValue;
        $this->transfer_date->CurrentValue = UnFormatDateTime($this->transfer_date->CurrentValue, $this->transfer_date->formatPattern());
        $this->share_no_start->CurrentValue = $this->share_no_start->FormValue;
        $this->share_no_end->CurrentValue = $this->share_no_end->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->folio_new->setDbValue($row['folio_new']);
        if (array_key_exists('EV__folio_new', $row)) {
            $this->folio_new->VirtualValue = $row['EV__folio_new']; // Set up virtual field value
        } else {
            $this->folio_new->VirtualValue = ""; // Clear value
        }
        $this->folio_old->setDbValue($row['folio_old']);
        $this->adviser->setDbValue($row['adviser']);
        $this->quantity->setDbValue($row['quantity']);
        $this->transfer_date->setDbValue($row['transfer_date']);
        $this->share_no_start->setDbValue($row['share_no_start']);
        $this->share_no_end->setDbValue($row['share_no_end']);
        $this->pan->setDbValue($row['pan']);
        $this->aadhaar->setDbValue($row['aadhaar']);
        $this->duty_folio_new->setDbValue($row['duty_folio_new']);
        $this->duty_company->setDbValue($row['duty_company']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->updated->setDbValue($row['updated']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['folio_new'] = $this->folio_new->DefaultValue;
        $row['folio_old'] = $this->folio_old->DefaultValue;
        $row['adviser'] = $this->adviser->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['transfer_date'] = $this->transfer_date->DefaultValue;
        $row['share_no_start'] = $this->share_no_start->DefaultValue;
        $row['share_no_end'] = $this->share_no_end->DefaultValue;
        $row['pan'] = $this->pan->DefaultValue;
        $row['aadhaar'] = $this->aadhaar->DefaultValue;
        $row['duty_folio_new'] = $this->duty_folio_new->DefaultValue;
        $row['duty_company'] = $this->duty_company->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // folio_new
        $this->folio_new->RowCssClass = "row";

        // folio_old
        $this->folio_old->RowCssClass = "row";

        // adviser
        $this->adviser->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // transfer_date
        $this->transfer_date->RowCssClass = "row";

        // share_no_start
        $this->share_no_start->RowCssClass = "row";

        // share_no_end
        $this->share_no_end->RowCssClass = "row";

        // pan
        $this->pan->RowCssClass = "row";

        // aadhaar
        $this->aadhaar->RowCssClass = "row";

        // duty_folio_new
        $this->duty_folio_new->RowCssClass = "row";

        // duty_company
        $this->duty_company->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // folio_new
            if ($this->folio_new->VirtualValue != "") {
                $this->folio_new->ViewValue = $this->folio_new->VirtualValue;
            } else {
                $this->folio_new->ViewValue = $this->folio_new->CurrentValue;
                $curVal = strval($this->folio_new->CurrentValue);
                if ($curVal != "") {
                    $this->folio_new->ViewValue = $this->folio_new->lookupCacheOption($curVal);
                    if ($this->folio_new->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->folio_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->folio_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->folio_new->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->folio_new->Lookup->renderViewRow($rswrk[0]);
                            $this->folio_new->ViewValue = $this->folio_new->displayValue($arwrk);
                        } else {
                            $this->folio_new->ViewValue = FormatNumber($this->folio_new->CurrentValue, $this->folio_new->formatPattern());
                        }
                    }
                } else {
                    $this->folio_new->ViewValue = null;
                }
            }

            // folio_old
            $this->folio_old->ViewValue = $this->folio_old->CurrentValue;
            $curVal = strval($this->folio_old->CurrentValue);
            if ($curVal != "") {
                $this->folio_old->ViewValue = $this->folio_old->lookupCacheOption($curVal);
                if ($this->folio_old->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->folio_old->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->folio_old->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->folio_old->getSelectFilter($this); // PHP
                    $sqlWrk = $this->folio_old->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->folio_old->Lookup->renderViewRow($rswrk[0]);
                        $this->folio_old->ViewValue = $this->folio_old->displayValue($arwrk);
                    } else {
                        $this->folio_old->ViewValue = FormatNumber($this->folio_old->CurrentValue, $this->folio_old->formatPattern());
                    }
                }
            } else {
                $this->folio_old->ViewValue = null;
            }

            // adviser
            $curVal = strval($this->adviser->CurrentValue);
            if ($curVal != "") {
                $this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
                if ($this->adviser->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->adviser->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->adviser->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->adviser->getSelectFilter($this); // PHP
                    $sqlWrk = $this->adviser->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->adviser->Lookup->renderViewRow($rswrk[0]);
                        $this->adviser->ViewValue = $this->adviser->displayValue($arwrk);
                    } else {
                        $this->adviser->ViewValue = FormatNumber($this->adviser->CurrentValue, $this->adviser->formatPattern());
                    }
                }
            } else {
                $this->adviser->ViewValue = null;
            }

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // transfer_date
            $this->transfer_date->ViewValue = $this->transfer_date->CurrentValue;
            $this->transfer_date->ViewValue = FormatDateTime($this->transfer_date->ViewValue, $this->transfer_date->formatPattern());

            // share_no_start
            $this->share_no_start->ViewValue = $this->share_no_start->CurrentValue;
            $this->share_no_start->ViewValue = FormatNumber($this->share_no_start->ViewValue, $this->share_no_start->formatPattern());

            // share_no_end
            $this->share_no_end->ViewValue = $this->share_no_end->CurrentValue;
            $this->share_no_end->ViewValue = FormatNumber($this->share_no_end->ViewValue, $this->share_no_end->formatPattern());

            // pan
            $this->pan->ViewValue = $this->pan->CurrentValue;

            // aadhaar
            $this->aadhaar->ViewValue = $this->aadhaar->CurrentValue;

            // duty_folio_new
            $this->duty_folio_new->ViewValue = $this->duty_folio_new->CurrentValue;
            $this->duty_folio_new->ViewValue = FormatNumber($this->duty_folio_new->ViewValue, $this->duty_folio_new->formatPattern());

            // duty_company
            $this->duty_company->ViewValue = $this->duty_company->CurrentValue;
            $this->duty_company->ViewValue = FormatNumber($this->duty_company->ViewValue, $this->duty_company->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;

            // folio_new
            $this->folio_new->HrefValue = "";

            // folio_old
            $this->folio_old->HrefValue = "";

            // adviser
            $this->adviser->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // transfer_date
            $this->transfer_date->HrefValue = "";

            // share_no_start
            $this->share_no_start->HrefValue = "";

            // share_no_end
            $this->share_no_end->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // folio_new
            $this->folio_new->setupEditAttributes();
            $this->folio_new->EditValue = $this->folio_new->CurrentValue;
            $curVal = strval($this->folio_new->CurrentValue);
            if ($curVal != "") {
                $this->folio_new->EditValue = $this->folio_new->lookupCacheOption($curVal);
                if ($this->folio_new->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->folio_new->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->folio_new->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->folio_new->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->folio_new->Lookup->renderViewRow($rswrk[0]);
                        $this->folio_new->EditValue = $this->folio_new->displayValue($arwrk);
                    } else {
                        $this->folio_new->EditValue = HtmlEncode(FormatNumber($this->folio_new->CurrentValue, $this->folio_new->formatPattern()));
                    }
                }
            } else {
                $this->folio_new->EditValue = null;
            }
            $this->folio_new->PlaceHolder = RemoveHtml($this->folio_new->caption());

            // folio_old
            $this->folio_old->setupEditAttributes();
            $this->folio_old->EditValue = $this->folio_old->CurrentValue;
            $curVal = strval($this->folio_old->CurrentValue);
            if ($curVal != "") {
                $this->folio_old->EditValue = $this->folio_old->lookupCacheOption($curVal);
                if ($this->folio_old->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->folio_old->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->folio_old->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->folio_old->getSelectFilter($this); // PHP
                    $sqlWrk = $this->folio_old->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->folio_old->Lookup->renderViewRow($rswrk[0]);
                        $this->folio_old->EditValue = $this->folio_old->displayValue($arwrk);
                    } else {
                        $this->folio_old->EditValue = HtmlEncode(FormatNumber($this->folio_old->CurrentValue, $this->folio_old->formatPattern()));
                    }
                }
            } else {
                $this->folio_old->EditValue = null;
            }
            $this->folio_old->PlaceHolder = RemoveHtml($this->folio_old->caption());

            // adviser
            $this->adviser->setupEditAttributes();
            $curVal = trim(strval($this->adviser->CurrentValue));
            if ($curVal != "") {
                $this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
            } else {
                $this->adviser->ViewValue = $this->adviser->Lookup !== null && is_array($this->adviser->lookupOptions()) && count($this->adviser->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->adviser->ViewValue !== null) { // Load from cache
                $this->adviser->EditValue = array_values($this->adviser->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->adviser->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->adviser->CurrentValue, $this->adviser->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->adviser->getSelectFilter($this); // PHP
                $sqlWrk = $this->adviser->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->adviser->EditValue = $arwrk;
            }
            $this->adviser->PlaceHolder = RemoveHtml($this->adviser->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // transfer_date
            $this->transfer_date->setupEditAttributes();
            $this->transfer_date->EditValue = HtmlEncode(FormatDateTime($this->transfer_date->CurrentValue, $this->transfer_date->formatPattern()));
            $this->transfer_date->PlaceHolder = RemoveHtml($this->transfer_date->caption());

            // share_no_start
            $this->share_no_start->setupEditAttributes();
            $this->share_no_start->EditCustomAttributes = $this->share_no_start->getEditCustomAttributes(); // PHP
            $this->share_no_start->EditValue = $this->share_no_start->CurrentValue;
            $this->share_no_start->PlaceHolder = RemoveHtml($this->share_no_start->caption());
            if (strval($this->share_no_start->EditValue) != "" && is_numeric($this->share_no_start->EditValue)) {
                $this->share_no_start->EditValue = FormatNumber($this->share_no_start->EditValue, null);
            }

            // share_no_end
            $this->share_no_end->setupEditAttributes();
            $this->share_no_end->EditCustomAttributes = $this->share_no_end->getEditCustomAttributes(); // PHP
            $this->share_no_end->EditValue = $this->share_no_end->CurrentValue;
            $this->share_no_end->PlaceHolder = RemoveHtml($this->share_no_end->caption());
            if (strval($this->share_no_end->EditValue) != "" && is_numeric($this->share_no_end->EditValue)) {
                $this->share_no_end->EditValue = FormatNumber($this->share_no_end->EditValue, null);
            }

            // operator

            // datetime

            // Add refer script

            // folio_new
            $this->folio_new->HrefValue = "";

            // folio_old
            $this->folio_old->HrefValue = "";

            // adviser
            $this->adviser->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // transfer_date
            $this->transfer_date->HrefValue = "";

            // share_no_start
            $this->share_no_start->HrefValue = "";

            // share_no_end
            $this->share_no_end->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->folio_new->Visible && $this->folio_new->Required) {
                if (!$this->folio_new->IsDetailKey && EmptyValue($this->folio_new->FormValue)) {
                    $this->folio_new->addErrorMessage(str_replace("%s", $this->folio_new->caption(), $this->folio_new->RequiredErrorMessage));
                }
            }
            if ($this->folio_old->Visible && $this->folio_old->Required) {
                if (!$this->folio_old->IsDetailKey && EmptyValue($this->folio_old->FormValue)) {
                    $this->folio_old->addErrorMessage(str_replace("%s", $this->folio_old->caption(), $this->folio_old->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->folio_old->FormValue)) {
                $this->folio_old->addErrorMessage($this->folio_old->getErrorMessage(false));
            }
            if ($this->adviser->Visible && $this->adviser->Required) {
                if (!$this->adviser->IsDetailKey && EmptyValue($this->adviser->FormValue)) {
                    $this->adviser->addErrorMessage(str_replace("%s", $this->adviser->caption(), $this->adviser->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->transfer_date->Visible && $this->transfer_date->Required) {
                if (!$this->transfer_date->IsDetailKey && EmptyValue($this->transfer_date->FormValue)) {
                    $this->transfer_date->addErrorMessage(str_replace("%s", $this->transfer_date->caption(), $this->transfer_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->transfer_date->FormValue, $this->transfer_date->formatPattern())) {
                $this->transfer_date->addErrorMessage($this->transfer_date->getErrorMessage(false));
            }
            if ($this->share_no_start->Visible && $this->share_no_start->Required) {
                if (!$this->share_no_start->IsDetailKey && EmptyValue($this->share_no_start->FormValue)) {
                    $this->share_no_start->addErrorMessage(str_replace("%s", $this->share_no_start->caption(), $this->share_no_start->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->share_no_start->FormValue)) {
                $this->share_no_start->addErrorMessage($this->share_no_start->getErrorMessage(false));
            }
            if ($this->share_no_end->Visible && $this->share_no_end->Required) {
                if (!$this->share_no_end->IsDetailKey && EmptyValue($this->share_no_end->FormValue)) {
                    $this->share_no_end->addErrorMessage(str_replace("%s", $this->share_no_end->caption(), $this->share_no_end->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->share_no_end->FormValue)) {
                $this->share_no_end->addErrorMessage($this->share_no_end->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // folio_new
        $this->folio_new->setDbValueDef($rsnew, $this->folio_new->CurrentValue, false);

        // folio_old
        $this->folio_old->setDbValueDef($rsnew, $this->folio_old->CurrentValue, false);

        // adviser
        $this->adviser->setDbValueDef($rsnew, $this->adviser->CurrentValue, false);

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, false);

        // transfer_date
        $this->transfer_date->setDbValueDef($rsnew, UnFormatDateTime($this->transfer_date->CurrentValue, $this->transfer_date->formatPattern()), false);

        // share_no_start
        $this->share_no_start->setDbValueDef($rsnew, $this->share_no_start->CurrentValue, false);

        // share_no_end
        $this->share_no_end->setDbValueDef($rsnew, $this->share_no_end->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['folio_new'])) { // folio_new
            $this->folio_new->setFormValue($row['folio_new']);
        }
        if (isset($row['folio_old'])) { // folio_old
            $this->folio_old->setFormValue($row['folio_old']);
        }
        if (isset($row['adviser'])) { // adviser
            $this->adviser->setFormValue($row['adviser']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['transfer_date'])) { // transfer_date
            $this->transfer_date->setFormValue($row['transfer_date']);
        }
        if (isset($row['share_no_start'])) { // share_no_start
            $this->share_no_start->setFormValue($row['share_no_start']);
        }
        if (isset($row['share_no_end'])) { // share_no_end
            $this->share_no_end->setFormValue($row['share_no_end']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("sharetransferlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_folio_new":
                    break;
                case "x_folio_old":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_adviser":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
