<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ServiceRequestAdd extends ServiceRequest
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ServiceRequestAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "servicerequestadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->status->Visible = false;
        $this->buyer_id->setVisibility();
        $this->product_ref->setVisibility();
        $this->current_reading->setVisibility();
        $this->product_status->setVisibility();
        $this->_error->setVisibility();
        $this->last_serve->Visible = false;
        $this->last_serve_by->Visible = false;
        $this->query_by->setVisibility();
        $this->service_executive->Visible = false;
        $this->Ins_service_executive->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->o_operator->Visible = false;
        $this->o_datetime->Visible = false;
        $this->rid_1->Visible = false;
        $this->master_reading->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'service_request';
        $this->TableName = 'service_request';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (service_request)
        if (!isset($GLOBALS["service_request"]) || $GLOBALS["service_request"]::class == PROJECT_NAMESPACE . "service_request") {
            $GLOBALS["service_request"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'service_request');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "servicerequestview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->product_ref);
        $this->setupLookupOptions($this->product_status);
        $this->setupLookupOptions($this->last_serve_by);
        $this->setupLookupOptions($this->service_executive);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("servicerequestlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "servicerequestlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "servicerequestview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "servicerequestlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "servicerequestlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->buyer_id->DefaultValue = $this->buyer_id->getDefault(); // PHP
        $this->buyer_id->OldValue = $this->buyer_id->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->rid_1->DefaultValue = $this->rid_1->getDefault(); // PHP
        $this->rid_1->OldValue = $this->rid_1->DefaultValue;
        $this->master_reading->DefaultValue = $this->master_reading->getDefault(); // PHP
        $this->master_reading->OldValue = $this->master_reading->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'buyer_id' first before field var 'x_buyer_id'
        $val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
        if (!$this->buyer_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_id->Visible = false; // Disable update for API request
            } else {
                $this->buyer_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'product_ref' first before field var 'x_product_ref'
        $val = $CurrentForm->hasValue("product_ref") ? $CurrentForm->getValue("product_ref") : $CurrentForm->getValue("x_product_ref");
        if (!$this->product_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_ref->Visible = false; // Disable update for API request
            } else {
                $this->product_ref->setFormValue($val);
            }
        }

        // Check field name 'current_reading' first before field var 'x_current_reading'
        $val = $CurrentForm->hasValue("current_reading") ? $CurrentForm->getValue("current_reading") : $CurrentForm->getValue("x_current_reading");
        if (!$this->current_reading->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->current_reading->Visible = false; // Disable update for API request
            } else {
                $this->current_reading->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'product_status' first before field var 'x_product_status'
        $val = $CurrentForm->hasValue("product_status") ? $CurrentForm->getValue("product_status") : $CurrentForm->getValue("x_product_status");
        if (!$this->product_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_status->Visible = false; // Disable update for API request
            } else {
                $this->product_status->setFormValue($val);
            }
        }

        // Check field name 'error' first before field var 'x__error'
        $val = $CurrentForm->hasValue("error") ? $CurrentForm->getValue("error") : $CurrentForm->getValue("x__error");
        if (!$this->_error->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_error->Visible = false; // Disable update for API request
            } else {
                $this->_error->setFormValue($val);
            }
        }

        // Check field name 'query_by' first before field var 'x_query_by'
        $val = $CurrentForm->hasValue("query_by") ? $CurrentForm->getValue("query_by") : $CurrentForm->getValue("x_query_by");
        if (!$this->query_by->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->query_by->Visible = false; // Disable update for API request
            } else {
                $this->query_by->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'master_reading' first before field var 'x_master_reading'
        $val = $CurrentForm->hasValue("master_reading") ? $CurrentForm->getValue("master_reading") : $CurrentForm->getValue("x_master_reading");
        if (!$this->master_reading->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->master_reading->Visible = false; // Disable update for API request
            } else {
                $this->master_reading->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
        $this->product_ref->CurrentValue = $this->product_ref->FormValue;
        $this->current_reading->CurrentValue = $this->current_reading->FormValue;
        $this->product_status->CurrentValue = $this->product_status->FormValue;
        $this->_error->CurrentValue = $this->_error->FormValue;
        $this->query_by->CurrentValue = $this->query_by->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->master_reading->CurrentValue = $this->master_reading->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->status->setDbValue($row['status']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->product_ref->setDbValue($row['product_ref']);
        $this->current_reading->setDbValue($row['current_reading']);
        $this->product_status->setDbValue($row['product_status']);
        $this->_error->setDbValue($row['error']);
        $this->last_serve->setDbValue($row['last_serve']);
        $this->last_serve_by->setDbValue($row['last_serve_by']);
        $this->query_by->setDbValue($row['query_by']);
        $this->service_executive->setDbValue($row['service_executive']);
        $this->Ins_service_executive->setDbValue($row['Ins_service_executive']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->o_operator->setDbValue($row['o_operator']);
        $this->o_datetime->setDbValue($row['o_datetime']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->master_reading->setDbValue($row['master_reading']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['buyer_id'] = $this->buyer_id->DefaultValue;
        $row['product_ref'] = $this->product_ref->DefaultValue;
        $row['current_reading'] = $this->current_reading->DefaultValue;
        $row['product_status'] = $this->product_status->DefaultValue;
        $row['error'] = $this->_error->DefaultValue;
        $row['last_serve'] = $this->last_serve->DefaultValue;
        $row['last_serve_by'] = $this->last_serve_by->DefaultValue;
        $row['query_by'] = $this->query_by->DefaultValue;
        $row['service_executive'] = $this->service_executive->DefaultValue;
        $row['Ins_service_executive'] = $this->Ins_service_executive->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['o_operator'] = $this->o_operator->DefaultValue;
        $row['o_datetime'] = $this->o_datetime->DefaultValue;
        $row['rid_1'] = $this->rid_1->DefaultValue;
        $row['master_reading'] = $this->master_reading->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // product_ref
        $this->product_ref->RowCssClass = "row";

        // current_reading
        $this->current_reading->RowCssClass = "row";

        // product_status
        $this->product_status->RowCssClass = "row";

        // error
        $this->_error->RowCssClass = "row";

        // last_serve
        $this->last_serve->RowCssClass = "row";

        // last_serve_by
        $this->last_serve_by->RowCssClass = "row";

        // query_by
        $this->query_by->RowCssClass = "row";

        // service_executive
        $this->service_executive->RowCssClass = "row";

        // Ins_service_executive
        $this->Ins_service_executive->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // o_operator
        $this->o_operator->RowCssClass = "row";

        // o_datetime
        $this->o_datetime->RowCssClass = "row";

        // rid_1
        $this->rid_1->RowCssClass = "row";

        // master_reading
        $this->master_reading->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // buyer_id
            $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // product_ref
            $curVal = strval($this->product_ref->CurrentValue);
            if ($curVal != "") {
                $this->product_ref->ViewValue = $this->product_ref->lookupCacheOption($curVal);
                if ($this->product_ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->product_ref->ViewValue = $this->product_ref->displayValue($arwrk);
                    } else {
                        $this->product_ref->ViewValue = FormatNumber($this->product_ref->CurrentValue, $this->product_ref->formatPattern());
                    }
                }
            } else {
                $this->product_ref->ViewValue = null;
            }

            // current_reading
            $this->current_reading->ViewValue = $this->current_reading->CurrentValue;
            $this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, $this->current_reading->formatPattern());

            // product_status
            $curVal = strval($this->product_status->CurrentValue);
            if ($curVal != "") {
                $this->product_status->ViewValue = $this->product_status->lookupCacheOption($curVal);
                if ($this->product_status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_status->Lookup->renderViewRow($rswrk[0]);
                        $this->product_status->ViewValue = $this->product_status->displayValue($arwrk);
                    } else {
                        $this->product_status->ViewValue = $this->product_status->CurrentValue;
                    }
                }
            } else {
                $this->product_status->ViewValue = null;
            }

            // error
            $this->_error->ViewValue = $this->_error->CurrentValue;

            // last_serve
            $this->last_serve->ViewValue = $this->last_serve->CurrentValue;
            $this->last_serve->ViewValue = FormatDateTime($this->last_serve->ViewValue, $this->last_serve->formatPattern());

            // last_serve_by
            $curVal = strval($this->last_serve_by->CurrentValue);
            if ($curVal != "") {
                $this->last_serve_by->ViewValue = $this->last_serve_by->lookupCacheOption($curVal);
                if ($this->last_serve_by->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->last_serve_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->last_serve_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->last_serve_by->getSelectFilter($this); // PHP
                    $sqlWrk = $this->last_serve_by->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->last_serve_by->Lookup->renderViewRow($rswrk[0]);
                        $this->last_serve_by->ViewValue = $this->last_serve_by->displayValue($arwrk);
                    } else {
                        $this->last_serve_by->ViewValue = FormatNumber($this->last_serve_by->CurrentValue, $this->last_serve_by->formatPattern());
                    }
                }
            } else {
                $this->last_serve_by->ViewValue = null;
            }

            // query_by
            $this->query_by->ViewValue = $this->query_by->CurrentValue;

            // service_executive
            $curVal = strval($this->service_executive->CurrentValue);
            if ($curVal != "") {
                $this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
                if ($this->service_executive->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->service_executive->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->service_executive->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->service_executive->getSelectFilter($this); // PHP
                    $sqlWrk = $this->service_executive->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->service_executive->Lookup->renderViewRow($rswrk[0]);
                        $this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
                    } else {
                        $this->service_executive->ViewValue = FormatNumber($this->service_executive->CurrentValue, $this->service_executive->formatPattern());
                    }
                }
            } else {
                $this->service_executive->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // o_operator
            $this->o_operator->ViewValue = $this->o_operator->CurrentValue;
            $this->o_operator->ViewValue = FormatNumber($this->o_operator->ViewValue, $this->o_operator->formatPattern());

            // o_datetime
            $this->o_datetime->ViewValue = $this->o_datetime->CurrentValue;
            $this->o_datetime->ViewValue = FormatDateTime($this->o_datetime->ViewValue, $this->o_datetime->formatPattern());

            // master_reading
            $this->master_reading->ViewValue = $this->master_reading->CurrentValue;
            $this->master_reading->ViewValue = FormatNumber($this->master_reading->ViewValue, $this->master_reading->formatPattern());

            // buyer_id
            $this->buyer_id->HrefValue = "";
            $this->buyer_id->TooltipValue = "";

            // product_ref
            $this->product_ref->HrefValue = "";
            $this->product_ref->TooltipValue = "";

            // current_reading
            $this->current_reading->HrefValue = "";

            // product_status
            $this->product_status->HrefValue = "";
            $this->product_status->TooltipValue = "";

            // error
            $this->_error->HrefValue = "";

            // query_by
            $this->query_by->HrefValue = "";
            $this->query_by->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // master_reading
            $this->master_reading->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->EditValue = HtmlEncode(FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern()));
                    }
                }
            } else {
                $this->buyer_id->EditValue = null;
            }
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // product_ref
            $curVal = trim(strval($this->product_ref->CurrentValue));
            if ($curVal != "") {
                $this->product_ref->ViewValue = $this->product_ref->lookupCacheOption($curVal);
            } else {
                $this->product_ref->ViewValue = $this->product_ref->Lookup !== null && is_array($this->product_ref->lookupOptions()) && count($this->product_ref->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_ref->ViewValue !== null) { // Load from cache
                $this->product_ref->EditValue = array_values($this->product_ref->lookupOptions());
                if ($this->product_ref->ViewValue == "") {
                    $this->product_ref->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_ref->CurrentValue, $this->product_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product_ref->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_ref->Lookup->renderViewRow($rswrk[0]);
                    $this->product_ref->ViewValue = $this->product_ref->displayValue($arwrk);
                } else {
                    $this->product_ref->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->product_ref->EditValue = $arwrk;
            }
            $this->product_ref->PlaceHolder = RemoveHtml($this->product_ref->caption());

            // current_reading
            $this->current_reading->setupEditAttributes();
            $this->current_reading->EditValue = $this->current_reading->CurrentValue;
            $this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());
            if (strval($this->current_reading->EditValue) != "" && is_numeric($this->current_reading->EditValue)) {
                $this->current_reading->EditValue = FormatNumber($this->current_reading->EditValue, null);
            }

            // product_status
            $this->product_status->setupEditAttributes();
            $curVal = trim(strval($this->product_status->CurrentValue));
            if ($curVal != "") {
                $this->product_status->ViewValue = $this->product_status->lookupCacheOption($curVal);
            } else {
                $this->product_status->ViewValue = $this->product_status->Lookup !== null && is_array($this->product_status->lookupOptions()) && count($this->product_status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_status->ViewValue !== null) { // Load from cache
                $this->product_status->EditValue = array_values($this->product_status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_status->CurrentValue, $this->product_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_status->EditValue = $arwrk;
            }
            $this->product_status->PlaceHolder = RemoveHtml($this->product_status->caption());

            // error
            $this->_error->setupEditAttributes();
            $this->_error->EditValue = HtmlEncode($this->_error->CurrentValue);
            $this->_error->PlaceHolder = RemoveHtml($this->_error->caption());

            // query_by
            $this->query_by->setupEditAttributes();
            if (!$this->query_by->Raw) {
                $this->query_by->CurrentValue = HtmlDecode($this->query_by->CurrentValue);
            }
            $this->query_by->EditValue = HtmlEncode($this->query_by->CurrentValue);
            $this->query_by->PlaceHolder = RemoveHtml($this->query_by->caption());

            // operator

            // datetime

            // master_reading
            $this->master_reading->setupEditAttributes();
            $this->master_reading->EditValue = $this->master_reading->CurrentValue;
            $this->master_reading->PlaceHolder = RemoveHtml($this->master_reading->caption());
            if (strval($this->master_reading->EditValue) != "" && is_numeric($this->master_reading->EditValue)) {
                $this->master_reading->EditValue = FormatNumber($this->master_reading->EditValue, null);
            }

            // Add refer script

            // buyer_id
            $this->buyer_id->HrefValue = "";

            // product_ref
            $this->product_ref->HrefValue = "";

            // current_reading
            $this->current_reading->HrefValue = "";

            // product_status
            $this->product_status->HrefValue = "";

            // error
            $this->_error->HrefValue = "";

            // query_by
            $this->query_by->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // master_reading
            $this->master_reading->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->buyer_id->Visible && $this->buyer_id->Required) {
                if (!$this->buyer_id->IsDetailKey && EmptyValue($this->buyer_id->FormValue)) {
                    $this->buyer_id->addErrorMessage(str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->buyer_id->FormValue)) {
                $this->buyer_id->addErrorMessage($this->buyer_id->getErrorMessage(false));
            }
            if ($this->product_ref->Visible && $this->product_ref->Required) {
                if (!$this->product_ref->IsDetailKey && EmptyValue($this->product_ref->FormValue)) {
                    $this->product_ref->addErrorMessage(str_replace("%s", $this->product_ref->caption(), $this->product_ref->RequiredErrorMessage));
                }
            }
            if ($this->current_reading->Visible && $this->current_reading->Required) {
                if (!$this->current_reading->IsDetailKey && EmptyValue($this->current_reading->FormValue)) {
                    $this->current_reading->addErrorMessage(str_replace("%s", $this->current_reading->caption(), $this->current_reading->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->current_reading->FormValue)) {
                $this->current_reading->addErrorMessage($this->current_reading->getErrorMessage(false));
            }
            if ($this->product_status->Visible && $this->product_status->Required) {
                if (!$this->product_status->IsDetailKey && EmptyValue($this->product_status->FormValue)) {
                    $this->product_status->addErrorMessage(str_replace("%s", $this->product_status->caption(), $this->product_status->RequiredErrorMessage));
                }
            }
            if ($this->_error->Visible && $this->_error->Required) {
                if (!$this->_error->IsDetailKey && EmptyValue($this->_error->FormValue)) {
                    $this->_error->addErrorMessage(str_replace("%s", $this->_error->caption(), $this->_error->RequiredErrorMessage));
                }
            }
            if ($this->query_by->Visible && $this->query_by->Required) {
                if (!$this->query_by->IsDetailKey && EmptyValue($this->query_by->FormValue)) {
                    $this->query_by->addErrorMessage(str_replace("%s", $this->query_by->caption(), $this->query_by->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->master_reading->Visible && $this->master_reading->Required) {
                if (!$this->master_reading->IsDetailKey && EmptyValue($this->master_reading->FormValue)) {
                    $this->master_reading->addErrorMessage(str_replace("%s", $this->master_reading->caption(), $this->master_reading->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->master_reading->FormValue)) {
                $this->master_reading->addErrorMessage($this->master_reading->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // buyer_id
        $this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, false);

        // product_ref
        $this->product_ref->setDbValueDef($rsnew, $this->product_ref->CurrentValue, false);

        // current_reading
        $this->current_reading->setDbValueDef($rsnew, $this->current_reading->CurrentValue, false);

        // product_status
        $this->product_status->setDbValueDef($rsnew, $this->product_status->CurrentValue, strval($this->product_status->CurrentValue) == "");

        // error
        $this->_error->setDbValueDef($rsnew, $this->_error->CurrentValue, false);

        // query_by
        $this->query_by->setDbValueDef($rsnew, $this->query_by->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // master_reading
        $this->master_reading->setDbValueDef($rsnew, $this->master_reading->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['buyer_id'])) { // buyer_id
            $this->buyer_id->setFormValue($row['buyer_id']);
        }
        if (isset($row['product_ref'])) { // product_ref
            $this->product_ref->setFormValue($row['product_ref']);
        }
        if (isset($row['current_reading'])) { // current_reading
            $this->current_reading->setFormValue($row['current_reading']);
        }
        if (isset($row['product_status'])) { // product_status
            $this->product_status->setFormValue($row['product_status']);
        }
        if (isset($row['error'])) { // error
            $this->_error->setFormValue($row['error']);
        }
        if (isset($row['query_by'])) { // query_by
            $this->query_by->setFormValue($row['query_by']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['master_reading'])) { // master_reading
            $this->master_reading->setFormValue($row['master_reading']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("servicerequestlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_status":
                    break;
                case "x_buyer_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_ref":
                    break;
                case "x_product_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_last_serve_by":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_service_executive":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
