<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for service_request
 */
class ServiceRequest extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $status;
    public $buyer_id;
    public $product_ref;
    public $current_reading;
    public $product_status;
    public $_error;
    public $last_serve;
    public $last_serve_by;
    public $query_by;
    public $service_executive;
    public $Ins_service_executive;
    public $operator;
    public $datetime;
    public $o_operator;
    public $o_datetime;
    public $rid_1;
    public $master_reading;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "service_request";
        $this->TableName = 'service_request';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "service_request";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 0);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'service_request', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 3;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // buyer_id
        $this->buyer_id = new DbField(
            $this, // Table
            'x_buyer_id', // Variable name
            'buyer_id', // Name
            '`buyer_id`', // Expression
            '`buyer_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_id->addMethod("getSelectFilter", fn() => "`id` > 1000 and `status` = 1");
        $this->buyer_id->addMethod("getDefault", fn() => isset($_GET['b']) ? $_GET['b'] : '');
        $this->buyer_id->InputTextType = "text";
        $this->buyer_id->Raw = true;
        $this->buyer_id->Nullable = false; // NOT NULL field
        $this->buyer_id->Required = true; // Required field
        $this->buyer_id->Lookup = new Lookup($this->buyer_id, 'buyer', false, 'id', ["name","code","mobile","city_name"], '', '', [], ["x_product_ref"], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->buyer_id) . "',COALESCE(`code`,''),'" . ValueSeparator(2, $this->buyer_id) . "',COALESCE(`mobile`,''),'" . ValueSeparator(3, $this->buyer_id) . "',COALESCE(`city_name`,''))");
        $this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['buyer_id'] = &$this->buyer_id;

        // product_ref
        $this->product_ref = new DbField(
            $this, // Table
            'x_product_ref', // Variable name
            'product_ref', // Name
            '`product_ref`', // Expression
            '`product_ref`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product_ref->InputTextType = "text";
        $this->product_ref->Raw = true;
        $this->product_ref->Required = true; // Required field
        $this->product_ref->setSelectMultiple(false); // Select one
        $this->product_ref->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product_ref->Lookup = new Lookup($this->product_ref, 'client_hardware_data', false, 'id', ["ref","name_ref","harward_code","serial_no"], '', '', ["x_buyer_id"], [], ["partner_id"], ["x_partner_id"], [], [], false, '', '', "CONCAT(COALESCE(`ref`, ''),'" . ValueSeparator(1, $this->product_ref) . "',COALESCE(`name_ref`,''),'" . ValueSeparator(2, $this->product_ref) . "',COALESCE(`harward_code`,''),'" . ValueSeparator(3, $this->product_ref) . "',COALESCE(`serial_no`,''))");
        $this->product_ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_ref->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_ref'] = &$this->product_ref;

        // current_reading
        $this->current_reading = new DbField(
            $this, // Table
            'x_current_reading', // Variable name
            'current_reading', // Name
            '`current_reading`', // Expression
            '`current_reading`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`current_reading`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->current_reading->InputTextType = "text";
        $this->current_reading->Raw = true;
        $this->current_reading->Nullable = false; // NOT NULL field
        $this->current_reading->Required = true; // Required field
        $this->current_reading->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->current_reading->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['current_reading'] = &$this->current_reading;

        // product_status
        $this->product_status = new DbField(
            $this, // Table
            'x_product_status', // Variable name
            'product_status', // Name
            '`product_status`', // Expression
            '`product_status`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product_status->addMethod("getSelectFilter", fn() => "`grp` = 21 and `status` = 1");
        $this->product_status->InputTextType = "text";
        $this->product_status->Raw = true;
        $this->product_status->setSelectMultiple(false); // Select one
        $this->product_status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product_status->Lookup = new Lookup($this->product_status, 'service_misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->product_status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_status'] = &$this->product_status;

        // error
        $this->_error = new DbField(
            $this, // Table
            'x__error', // Variable name
            'error', // Name
            '`error`', // Expression
            '`error`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`error`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->_error->InputTextType = "text";
        $this->_error->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['error'] = &$this->_error;

        // last_serve
        $this->last_serve = new DbField(
            $this, // Table
            'x_last_serve', // Variable name
            'last_serve', // Name
            '`last_serve`', // Expression
            CastDateFieldForLike("`last_serve`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`last_serve`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->last_serve->InputTextType = "text";
        $this->last_serve->Raw = true;
        $this->last_serve->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->last_serve->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['last_serve'] = &$this->last_serve;

        // last_serve_by
        $this->last_serve_by = new DbField(
            $this, // Table
            'x_last_serve_by', // Variable name
            'last_serve_by', // Name
            '`last_serve_by`', // Expression
            '`last_serve_by`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`last_serve_by`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->last_serve_by->addMethod("getSelectFilter", fn() => "FIND_IN_SET('92', `category`)");
        $this->last_serve_by->InputTextType = "text";
        $this->last_serve_by->Raw = true;
        $this->last_serve_by->setSelectMultiple(false); // Select one
        $this->last_serve_by->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->last_serve_by->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->last_serve_by->Lookup = new Lookup($this->last_serve_by, 'admin', false, 'id', ["user_name","mobile","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "CONCAT(COALESCE(`user_name`, ''),'" . ValueSeparator(1, $this->last_serve_by) . "',COALESCE(`mobile`,''))");
        $this->last_serve_by->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->last_serve_by->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['last_serve_by'] = &$this->last_serve_by;

        // query_by
        $this->query_by = new DbField(
            $this, // Table
            'x_query_by', // Variable name
            'query_by', // Name
            '`query_by`', // Expression
            '`query_by`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`query_by`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->query_by->InputTextType = "text";
        $this->query_by->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['query_by'] = &$this->query_by;

        // service_executive
        $this->service_executive = new DbField(
            $this, // Table
            'x_service_executive', // Variable name
            'service_executive', // Name
            '`service_executive`', // Expression
            '`service_executive`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`service_executive`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->service_executive->addMethod("getSelectFilter", fn() => "FIND_IN_SET('92', `category`)");
        $this->service_executive->InputTextType = "text";
        $this->service_executive->Raw = true;
        $this->service_executive->Nullable = false; // NOT NULL field
        $this->service_executive->Required = true; // Required field
        $this->service_executive->setSelectMultiple(false); // Select one
        $this->service_executive->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->service_executive->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->service_executive->Lookup = new Lookup($this->service_executive, 'admin', false, 'id', ["user_name","mobile","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "CONCAT(COALESCE(`user_name`, ''),'" . ValueSeparator(1, $this->service_executive) . "',COALESCE(`mobile`,''))");
        $this->service_executive->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->service_executive->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['service_executive'] = &$this->service_executive;

        // Ins_service_executive
        $this->Ins_service_executive = new DbField(
            $this, // Table
            'x_Ins_service_executive', // Variable name
            'Ins_service_executive', // Name
            '`Ins_service_executive`', // Expression
            '`Ins_service_executive`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Ins_service_executive`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->Ins_service_executive->InputTextType = "text";
        $this->Ins_service_executive->Nullable = false; // NOT NULL field
        $this->Ins_service_executive->Required = true; // Required field
        $this->Ins_service_executive->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Ins_service_executive'] = &$this->Ins_service_executive;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // o_operator
        $this->o_operator = new DbField(
            $this, // Table
            'x_o_operator', // Variable name
            'o_operator', // Name
            '`o_operator`', // Expression
            '`o_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`o_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->o_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->o_operator->InputTextType = "text";
        $this->o_operator->Raw = true;
        $this->o_operator->Nullable = false; // NOT NULL field
        $this->o_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->o_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['o_operator'] = &$this->o_operator;

        // o_datetime
        $this->o_datetime = new DbField(
            $this, // Table
            'x_o_datetime', // Variable name
            'o_datetime', // Name
            '`o_datetime`', // Expression
            CastDateFieldForLike("`o_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`o_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->o_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->o_datetime->InputTextType = "text";
        $this->o_datetime->Raw = true;
        $this->o_datetime->Nullable = false; // NOT NULL field
        $this->o_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->o_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['o_datetime'] = &$this->o_datetime;

        // rid_1
        $this->rid_1 = new DbField(
            $this, // Table
            'x_rid_1', // Variable name
            'rid_1', // Name
            '`rid_1`', // Expression
            '`rid_1`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid_1`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid_1->addMethod("getDefault", fn() => "--NA--");
        $this->rid_1->InputTextType = "text";
        $this->rid_1->Nullable = false; // NOT NULL field
        $this->rid_1->Sortable = false; // Allow sort
        $this->rid_1->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['rid_1'] = &$this->rid_1;

        // master_reading
        $this->master_reading = new DbField(
            $this, // Table
            'x_master_reading', // Variable name
            'master_reading', // Name
            '`master_reading`', // Expression
            '`master_reading`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`master_reading`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->master_reading->addMethod("getDefault", fn() => 0);
        $this->master_reading->InputTextType = "text";
        $this->master_reading->Raw = true;
        $this->master_reading->Nullable = false; // NOT NULL field
        $this->master_reading->Required = true; // Required field
        $this->master_reading->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->master_reading->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['master_reading'] = &$this->master_reading;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "service_request";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Category() == 92) ? "`service_executive` = " .  CurrentUserID() : "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->status->DbValue = $row['status'];
        $this->buyer_id->DbValue = $row['buyer_id'];
        $this->product_ref->DbValue = $row['product_ref'];
        $this->current_reading->DbValue = $row['current_reading'];
        $this->product_status->DbValue = $row['product_status'];
        $this->_error->DbValue = $row['error'];
        $this->last_serve->DbValue = $row['last_serve'];
        $this->last_serve_by->DbValue = $row['last_serve_by'];
        $this->query_by->DbValue = $row['query_by'];
        $this->service_executive->DbValue = $row['service_executive'];
        $this->Ins_service_executive->DbValue = $row['Ins_service_executive'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->o_operator->DbValue = $row['o_operator'];
        $this->o_datetime->DbValue = $row['o_datetime'];
        $this->rid_1->DbValue = $row['rid_1'];
        $this->master_reading->DbValue = $row['master_reading'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("servicerequestlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "servicerequestview" => $Language->phrase("View"),
            "servicerequestedit" => $Language->phrase("Edit"),
            "servicerequestadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "servicerequestlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ServiceRequestView",
            Config("API_ADD_ACTION") => "ServiceRequestAdd",
            Config("API_EDIT_ACTION") => "ServiceRequestEdit",
            Config("API_DELETE_ACTION") => "ServiceRequestDelete",
            Config("API_LIST_ACTION") => "ServiceRequestList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "servicerequestlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("servicerequestview", $parm);
        } else {
            $url = $this->keyUrl("servicerequestview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "servicerequestadd?" . $parm;
        } else {
            $url = "servicerequestadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("servicerequestedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("servicerequestlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("servicerequestadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("servicerequestlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("servicerequestdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->status->setDbValue($row['status']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->product_ref->setDbValue($row['product_ref']);
        $this->current_reading->setDbValue($row['current_reading']);
        $this->product_status->setDbValue($row['product_status']);
        $this->_error->setDbValue($row['error']);
        $this->last_serve->setDbValue($row['last_serve']);
        $this->last_serve_by->setDbValue($row['last_serve_by']);
        $this->query_by->setDbValue($row['query_by']);
        $this->service_executive->setDbValue($row['service_executive']);
        $this->Ins_service_executive->setDbValue($row['Ins_service_executive']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->o_operator->setDbValue($row['o_operator']);
        $this->o_datetime->setDbValue($row['o_datetime']);
        $this->rid_1->setDbValue($row['rid_1']);
        $this->master_reading->setDbValue($row['master_reading']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ServiceRequestList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // status

        // buyer_id

        // product_ref

        // current_reading

        // product_status

        // error

        // last_serve

        // last_serve_by

        // query_by

        // service_executive

        // Ins_service_executive

        // operator

        // datetime

        // o_operator

        // o_datetime

        // rid_1
        $this->rid_1->CellCssStyle = "white-space: nowrap;";

        // master_reading

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // buyer_id
        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                }
            }
        } else {
            $this->buyer_id->ViewValue = null;
        }

        // product_ref
        $curVal = strval($this->product_ref->CurrentValue);
        if ($curVal != "") {
            $this->product_ref->ViewValue = $this->product_ref->lookupCacheOption($curVal);
            if ($this->product_ref->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_ref->Lookup->renderViewRow($rswrk[0]);
                    $this->product_ref->ViewValue = $this->product_ref->displayValue($arwrk);
                } else {
                    $this->product_ref->ViewValue = FormatNumber($this->product_ref->CurrentValue, $this->product_ref->formatPattern());
                }
            }
        } else {
            $this->product_ref->ViewValue = null;
        }

        // current_reading
        $this->current_reading->ViewValue = $this->current_reading->CurrentValue;
        $this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, $this->current_reading->formatPattern());

        // product_status
        $curVal = strval($this->product_status->CurrentValue);
        if ($curVal != "") {
            $this->product_status->ViewValue = $this->product_status->lookupCacheOption($curVal);
            if ($this->product_status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_status->Lookup->renderViewRow($rswrk[0]);
                    $this->product_status->ViewValue = $this->product_status->displayValue($arwrk);
                } else {
                    $this->product_status->ViewValue = $this->product_status->CurrentValue;
                }
            }
        } else {
            $this->product_status->ViewValue = null;
        }

        // error
        $this->_error->ViewValue = $this->_error->CurrentValue;

        // last_serve
        $this->last_serve->ViewValue = $this->last_serve->CurrentValue;
        $this->last_serve->ViewValue = FormatDateTime($this->last_serve->ViewValue, $this->last_serve->formatPattern());

        // last_serve_by
        $curVal = strval($this->last_serve_by->CurrentValue);
        if ($curVal != "") {
            $this->last_serve_by->ViewValue = $this->last_serve_by->lookupCacheOption($curVal);
            if ($this->last_serve_by->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->last_serve_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->last_serve_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->last_serve_by->getSelectFilter($this); // PHP
                $sqlWrk = $this->last_serve_by->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->last_serve_by->Lookup->renderViewRow($rswrk[0]);
                    $this->last_serve_by->ViewValue = $this->last_serve_by->displayValue($arwrk);
                } else {
                    $this->last_serve_by->ViewValue = FormatNumber($this->last_serve_by->CurrentValue, $this->last_serve_by->formatPattern());
                }
            }
        } else {
            $this->last_serve_by->ViewValue = null;
        }

        // query_by
        $this->query_by->ViewValue = $this->query_by->CurrentValue;

        // service_executive
        $curVal = strval($this->service_executive->CurrentValue);
        if ($curVal != "") {
            $this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
            if ($this->service_executive->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->service_executive->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->service_executive->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->service_executive->getSelectFilter($this); // PHP
                $sqlWrk = $this->service_executive->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->service_executive->Lookup->renderViewRow($rswrk[0]);
                    $this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
                } else {
                    $this->service_executive->ViewValue = FormatNumber($this->service_executive->CurrentValue, $this->service_executive->formatPattern());
                }
            }
        } else {
            $this->service_executive->ViewValue = null;
        }

        // Ins_service_executive
        $this->Ins_service_executive->ViewValue = $this->Ins_service_executive->CurrentValue;

        // operator
        $this->operator->ViewValue = $this->operator->CurrentValue;
        $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // o_operator
        $this->o_operator->ViewValue = $this->o_operator->CurrentValue;
        $this->o_operator->ViewValue = FormatNumber($this->o_operator->ViewValue, $this->o_operator->formatPattern());

        // o_datetime
        $this->o_datetime->ViewValue = $this->o_datetime->CurrentValue;
        $this->o_datetime->ViewValue = FormatDateTime($this->o_datetime->ViewValue, $this->o_datetime->formatPattern());

        // rid_1
        $this->rid_1->ViewValue = $this->rid_1->CurrentValue;

        // master_reading
        $this->master_reading->ViewValue = $this->master_reading->CurrentValue;
        $this->master_reading->ViewValue = FormatNumber($this->master_reading->ViewValue, $this->master_reading->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // buyer_id
        $this->buyer_id->HrefValue = "";
        $this->buyer_id->TooltipValue = "";

        // product_ref
        $this->product_ref->HrefValue = "";
        $this->product_ref->TooltipValue = "";

        // current_reading
        $this->current_reading->HrefValue = "";
        $this->current_reading->TooltipValue = "";

        // product_status
        $this->product_status->HrefValue = "";
        $this->product_status->TooltipValue = "";

        // error
        $this->_error->HrefValue = "";
        $this->_error->TooltipValue = "";

        // last_serve
        $this->last_serve->HrefValue = "";
        $this->last_serve->TooltipValue = "";

        // last_serve_by
        $this->last_serve_by->HrefValue = "";
        $this->last_serve_by->TooltipValue = "";

        // query_by
        $this->query_by->HrefValue = "";
        $this->query_by->TooltipValue = "";

        // service_executive
        $this->service_executive->HrefValue = "";
        $this->service_executive->TooltipValue = "";

        // Ins_service_executive
        $this->Ins_service_executive->HrefValue = "";
        $this->Ins_service_executive->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // o_operator
        $this->o_operator->HrefValue = "";
        $this->o_operator->TooltipValue = "";

        // o_datetime
        $this->o_datetime->HrefValue = "";
        $this->o_datetime->TooltipValue = "";

        // rid_1
        $this->rid_1->HrefValue = "";
        $this->rid_1->TooltipValue = "";

        // master_reading
        $this->master_reading->HrefValue = "";
        $this->master_reading->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // status
        $this->status->setupEditAttributes();
        if (strval($this->status->CurrentValue) != "") {
            $this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->EditValue = null;
        }

        // buyer_id
        $this->buyer_id->setupEditAttributes();
        $this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->EditValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                }
            }
        } else {
            $this->buyer_id->EditValue = null;
        }

        // product_ref
        $this->product_ref->setupEditAttributes();
        $curVal = strval($this->product_ref->CurrentValue);
        if ($curVal != "") {
            $this->product_ref->EditValue = $this->product_ref->lookupCacheOption($curVal);
            if ($this->product_ref->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_ref->Lookup->renderViewRow($rswrk[0]);
                    $this->product_ref->EditValue = $this->product_ref->displayValue($arwrk);
                } else {
                    $this->product_ref->EditValue = FormatNumber($this->product_ref->CurrentValue, $this->product_ref->formatPattern());
                }
            }
        } else {
            $this->product_ref->EditValue = null;
        }

        // current_reading
        $this->current_reading->setupEditAttributes();
        $this->current_reading->EditValue = $this->current_reading->CurrentValue;
        $this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());
        if (strval($this->current_reading->EditValue) != "" && is_numeric($this->current_reading->EditValue)) {
            $this->current_reading->EditValue = FormatNumber($this->current_reading->EditValue, null);
        }

        // product_status
        $this->product_status->setupEditAttributes();
        $curVal = strval($this->product_status->CurrentValue);
        if ($curVal != "") {
            $this->product_status->EditValue = $this->product_status->lookupCacheOption($curVal);
            if ($this->product_status->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_status->Lookup->renderViewRow($rswrk[0]);
                    $this->product_status->EditValue = $this->product_status->displayValue($arwrk);
                } else {
                    $this->product_status->EditValue = $this->product_status->CurrentValue;
                }
            }
        } else {
            $this->product_status->EditValue = null;
        }

        // error
        $this->_error->setupEditAttributes();
        $this->_error->EditValue = $this->_error->CurrentValue;
        $this->_error->PlaceHolder = RemoveHtml($this->_error->caption());

        // last_serve
        $this->last_serve->setupEditAttributes();
        $this->last_serve->EditValue = $this->last_serve->CurrentValue;
        $this->last_serve->EditValue = FormatDateTime($this->last_serve->EditValue, $this->last_serve->formatPattern());

        // last_serve_by
        $this->last_serve_by->setupEditAttributes();
        $curVal = strval($this->last_serve_by->CurrentValue);
        if ($curVal != "") {
            $this->last_serve_by->EditValue = $this->last_serve_by->lookupCacheOption($curVal);
            if ($this->last_serve_by->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->last_serve_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->last_serve_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->last_serve_by->getSelectFilter($this); // PHP
                $sqlWrk = $this->last_serve_by->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->last_serve_by->Lookup->renderViewRow($rswrk[0]);
                    $this->last_serve_by->EditValue = $this->last_serve_by->displayValue($arwrk);
                } else {
                    $this->last_serve_by->EditValue = FormatNumber($this->last_serve_by->CurrentValue, $this->last_serve_by->formatPattern());
                }
            }
        } else {
            $this->last_serve_by->EditValue = null;
        }

        // query_by
        $this->query_by->setupEditAttributes();
        $this->query_by->EditValue = $this->query_by->CurrentValue;

        // service_executive
        $this->service_executive->setupEditAttributes();
        $this->service_executive->PlaceHolder = RemoveHtml($this->service_executive->caption());

        // Ins_service_executive
        $this->Ins_service_executive->setupEditAttributes();
        $this->Ins_service_executive->EditValue = $this->Ins_service_executive->CurrentValue;
        $this->Ins_service_executive->PlaceHolder = RemoveHtml($this->Ins_service_executive->caption());

        // operator

        // datetime

        // o_operator

        // o_datetime

        // rid_1
        $this->rid_1->setupEditAttributes();
        if (!$this->rid_1->Raw) {
            $this->rid_1->CurrentValue = HtmlDecode($this->rid_1->CurrentValue);
        }
        $this->rid_1->EditValue = $this->rid_1->CurrentValue;
        $this->rid_1->PlaceHolder = RemoveHtml($this->rid_1->caption());

        // master_reading
        $this->master_reading->setupEditAttributes();
        $this->master_reading->EditValue = $this->master_reading->CurrentValue;
        $this->master_reading->PlaceHolder = RemoveHtml($this->master_reading->caption());
        if (strval($this->master_reading->EditValue) != "" && is_numeric($this->master_reading->EditValue)) {
            $this->master_reading->EditValue = FormatNumber($this->master_reading->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->product_ref);
                    $doc->exportCaption($this->current_reading);
                    $doc->exportCaption($this->product_status);
                    $doc->exportCaption($this->_error);
                    $doc->exportCaption($this->last_serve);
                    $doc->exportCaption($this->last_serve_by);
                    $doc->exportCaption($this->query_by);
                    $doc->exportCaption($this->service_executive);
                    $doc->exportCaption($this->Ins_service_executive);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->o_operator);
                    $doc->exportCaption($this->o_datetime);
                    $doc->exportCaption($this->master_reading);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->product_ref);
                    $doc->exportCaption($this->current_reading);
                    $doc->exportCaption($this->product_status);
                    $doc->exportCaption($this->last_serve);
                    $doc->exportCaption($this->last_serve_by);
                    $doc->exportCaption($this->query_by);
                    $doc->exportCaption($this->service_executive);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->o_operator);
                    $doc->exportCaption($this->o_datetime);
                    $doc->exportCaption($this->master_reading);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->status);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->product_ref);
                        $doc->exportField($this->current_reading);
                        $doc->exportField($this->product_status);
                        $doc->exportField($this->_error);
                        $doc->exportField($this->last_serve);
                        $doc->exportField($this->last_serve_by);
                        $doc->exportField($this->query_by);
                        $doc->exportField($this->service_executive);
                        $doc->exportField($this->Ins_service_executive);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->o_operator);
                        $doc->exportField($this->o_datetime);
                        $doc->exportField($this->master_reading);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->status);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->product_ref);
                        $doc->exportField($this->current_reading);
                        $doc->exportField($this->product_status);
                        $doc->exportField($this->last_serve);
                        $doc->exportField($this->last_serve_by);
                        $doc->exportField($this->query_by);
                        $doc->exportField($this->service_executive);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->o_operator);
                        $doc->exportField($this->o_datetime);
                        $doc->exportField($this->master_reading);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
