<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ServiceReportSearch extends ServiceReport
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ServiceReportSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "servicereportsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->buyer_id->setVisibility();
        $this->hardware_id->setVisibility();
        $this->service_executive->setVisibility();
        $this->entry_time->setVisibility();
        $this->current_reading->setVisibility();
        $this->error_ref->setVisibility();
        $this->service_type->setVisibility();
        $this->complaint->setVisibility();
        $this->observation->setVisibility();
        $this->product_replaced->setVisibility();
        $this->consumable_replaced->setVisibility();
        $this->work_detail->setVisibility();
        $this->future_task->setVisibility();
        $this->last_status->setVisibility();
        $this->uploads->setVisibility();
        $this->out_time->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->a_operator->setVisibility();
        $this->invoice->setVisibility();
        $this->invoice_date->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'service_report';
        $this->TableName = 'service_report';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (service_report)
        if (!isset($GLOBALS["service_report"]) || $GLOBALS["service_report"]::class == PROJECT_NAMESPACE . "service_report") {
            $GLOBALS["service_report"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'service_report');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "servicereportview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->hardware_id);
        $this->setupLookupOptions($this->service_executive);
        $this->setupLookupOptions($this->error_ref);
        $this->setupLookupOptions($this->service_type);
        $this->setupLookupOptions($this->complaint);
        $this->setupLookupOptions($this->product_replaced);
        $this->setupLookupOptions($this->consumable_replaced);
        $this->setupLookupOptions($this->last_status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "servicereportlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
        $this->buildSearchUrl($srchUrl, $this->hardware_id); // hardware_id
        $this->buildSearchUrl($srchUrl, $this->service_executive); // service_executive
        $this->buildSearchUrl($srchUrl, $this->entry_time); // entry_time
        $this->buildSearchUrl($srchUrl, $this->current_reading); // current_reading
        $this->buildSearchUrl($srchUrl, $this->error_ref); // error_ref
        $this->buildSearchUrl($srchUrl, $this->service_type); // service_type
        $this->buildSearchUrl($srchUrl, $this->complaint); // complaint
        $this->buildSearchUrl($srchUrl, $this->observation); // observation
        $this->buildSearchUrl($srchUrl, $this->product_replaced); // product_replaced
        $this->buildSearchUrl($srchUrl, $this->consumable_replaced); // consumable_replaced
        $this->buildSearchUrl($srchUrl, $this->work_detail); // work_detail
        $this->buildSearchUrl($srchUrl, $this->future_task); // future_task
        $this->buildSearchUrl($srchUrl, $this->last_status); // last_status
        $this->buildSearchUrl($srchUrl, $this->uploads); // uploads
        $this->buildSearchUrl($srchUrl, $this->out_time); // out_time
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->a_operator); // a_operator
        $this->buildSearchUrl($srchUrl, $this->invoice); // invoice
        $this->buildSearchUrl($srchUrl, $this->invoice_date); // invoice_date
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_id
        if ($this->buyer_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // hardware_id
        if ($this->hardware_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // service_executive
        if ($this->service_executive->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // entry_time
        if ($this->entry_time->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // current_reading
        if ($this->current_reading->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // error_ref
        if ($this->error_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // service_type
        if ($this->service_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // complaint
        if ($this->complaint->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // observation
        if ($this->observation->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_replaced
        if ($this->product_replaced->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->product_replaced->AdvancedSearch->SearchValue)) {
            $this->product_replaced->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->product_replaced->AdvancedSearch->SearchValue);
        }
        if (is_array($this->product_replaced->AdvancedSearch->SearchValue2)) {
            $this->product_replaced->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->product_replaced->AdvancedSearch->SearchValue2);
        }

        // consumable_replaced
        if ($this->consumable_replaced->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->consumable_replaced->AdvancedSearch->SearchValue)) {
            $this->consumable_replaced->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->consumable_replaced->AdvancedSearch->SearchValue);
        }
        if (is_array($this->consumable_replaced->AdvancedSearch->SearchValue2)) {
            $this->consumable_replaced->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->consumable_replaced->AdvancedSearch->SearchValue2);
        }

        // work_detail
        if ($this->work_detail->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // future_task
        if ($this->future_task->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // last_status
        if ($this->last_status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // uploads
        if ($this->uploads->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // out_time
        if ($this->out_time->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // a_operator
        if ($this->a_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice
        if ($this->invoice->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice_date
        if ($this->invoice_date->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // hardware_id
        $this->hardware_id->RowCssClass = "row";

        // service_executive
        $this->service_executive->RowCssClass = "row";

        // entry_time
        $this->entry_time->RowCssClass = "row";

        // current_reading
        $this->current_reading->RowCssClass = "row";

        // error_ref
        $this->error_ref->RowCssClass = "row";

        // service_type
        $this->service_type->RowCssClass = "row";

        // complaint
        $this->complaint->RowCssClass = "row";

        // observation
        $this->observation->RowCssClass = "row";

        // product_replaced
        $this->product_replaced->RowCssClass = "row";

        // consumable_replaced
        $this->consumable_replaced->RowCssClass = "row";

        // work_detail
        $this->work_detail->RowCssClass = "row";

        // future_task
        $this->future_task->RowCssClass = "row";

        // last_status
        $this->last_status->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // out_time
        $this->out_time->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // invoice
        $this->invoice->RowCssClass = "row";

        // invoice_date
        $this->invoice_date->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // buyer_id
            $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // hardware_id
            $curVal = strval($this->hardware_id->CurrentValue);
            if ($curVal != "") {
                $this->hardware_id->ViewValue = $this->hardware_id->lookupCacheOption($curVal);
                if ($this->hardware_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->hardware_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hardware_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->hardware_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->hardware_id->Lookup->renderViewRow($rswrk[0]);
                        $this->hardware_id->ViewValue = $this->hardware_id->displayValue($arwrk);
                    } else {
                        $this->hardware_id->ViewValue = FormatNumber($this->hardware_id->CurrentValue, $this->hardware_id->formatPattern());
                    }
                }
            } else {
                $this->hardware_id->ViewValue = null;
            }

            // service_executive
            $this->service_executive->ViewValue = $this->service_executive->CurrentValue;
            $curVal = strval($this->service_executive->CurrentValue);
            if ($curVal != "") {
                $this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
                if ($this->service_executive->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->service_executive->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->service_executive->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->service_executive->getSelectFilter($this); // PHP
                    $sqlWrk = $this->service_executive->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->service_executive->Lookup->renderViewRow($rswrk[0]);
                        $this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
                    } else {
                        $this->service_executive->ViewValue = FormatNumber($this->service_executive->CurrentValue, $this->service_executive->formatPattern());
                    }
                }
            } else {
                $this->service_executive->ViewValue = null;
            }

            // entry_time
            $this->entry_time->ViewValue = $this->entry_time->CurrentValue;
            $this->entry_time->ViewValue = FormatDateTime($this->entry_time->ViewValue, $this->entry_time->formatPattern());

            // current_reading
            $this->current_reading->ViewValue = $this->current_reading->CurrentValue;
            $this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, $this->current_reading->formatPattern());

            // error_ref
            $curVal = strval($this->error_ref->CurrentValue);
            if ($curVal != "") {
                $this->error_ref->ViewValue = $this->error_ref->lookupCacheOption($curVal);
                if ($this->error_ref->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->error_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->error_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->error_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->error_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->error_ref->Lookup->renderViewRow($rswrk[0]);
                        $this->error_ref->ViewValue = $this->error_ref->displayValue($arwrk);
                    } else {
                        $this->error_ref->ViewValue = $this->error_ref->CurrentValue;
                    }
                }
            } else {
                $this->error_ref->ViewValue = null;
            }

            // service_type
            $curVal = strval($this->service_type->CurrentValue);
            if ($curVal != "") {
                $this->service_type->ViewValue = $this->service_type->lookupCacheOption($curVal);
                if ($this->service_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->service_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->service_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->service_type->Lookup->renderViewRow($rswrk[0]);
                        $this->service_type->ViewValue = $this->service_type->displayValue($arwrk);
                    } else {
                        $this->service_type->ViewValue = FormatNumber($this->service_type->CurrentValue, $this->service_type->formatPattern());
                    }
                }
            } else {
                $this->service_type->ViewValue = null;
            }

            // complaint
            $curVal = strval($this->complaint->CurrentValue);
            if ($curVal != "") {
                $this->complaint->ViewValue = $this->complaint->lookupCacheOption($curVal);
                if ($this->complaint->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->complaint->Lookup->getTable()->Fields["item"]->searchExpression(), "=", $curVal, $this->complaint->Lookup->getTable()->Fields["item"]->searchDataType(), "");
                    $lookupFilter = $this->complaint->getSelectFilter($this); // PHP
                    $sqlWrk = $this->complaint->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->complaint->Lookup->renderViewRow($rswrk[0]);
                        $this->complaint->ViewValue = $this->complaint->displayValue($arwrk);
                    } else {
                        $this->complaint->ViewValue = $this->complaint->CurrentValue;
                    }
                }
            } else {
                $this->complaint->ViewValue = null;
            }

            // observation
            $this->observation->ViewValue = $this->observation->CurrentValue;

            // product_replaced
            $curVal = strval($this->product_replaced->CurrentValue);
            if ($curVal != "") {
                $this->product_replaced->ViewValue = $this->product_replaced->lookupCacheOption($curVal);
                if ($this->product_replaced->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product_replaced->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_replaced->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->product_replaced->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_replaced->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->product_replaced->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->product_replaced->Lookup->renderViewRow($row);
                            $this->product_replaced->ViewValue->add($this->product_replaced->displayValue($arwrk));
                        }
                    } else {
                        $this->product_replaced->ViewValue = $this->product_replaced->CurrentValue;
                    }
                }
            } else {
                $this->product_replaced->ViewValue = null;
            }

            // consumable_replaced
            $curVal = strval($this->consumable_replaced->CurrentValue);
            if ($curVal != "") {
                $this->consumable_replaced->ViewValue = $this->consumable_replaced->lookupCacheOption($curVal);
                if ($this->consumable_replaced->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->consumable_replaced->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->consumable_replaced->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->consumable_replaced->getSelectFilter($this); // PHP
                    $sqlWrk = $this->consumable_replaced->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->consumable_replaced->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->consumable_replaced->Lookup->renderViewRow($row);
                            $this->consumable_replaced->ViewValue->add($this->consumable_replaced->displayValue($arwrk));
                        }
                    } else {
                        $this->consumable_replaced->ViewValue = $this->consumable_replaced->CurrentValue;
                    }
                }
            } else {
                $this->consumable_replaced->ViewValue = null;
            }

            // work_detail
            $this->work_detail->ViewValue = $this->work_detail->CurrentValue;

            // future_task
            $this->future_task->ViewValue = $this->future_task->CurrentValue;

            // last_status
            $curVal = strval($this->last_status->CurrentValue);
            if ($curVal != "") {
                $this->last_status->ViewValue = $this->last_status->lookupCacheOption($curVal);
                if ($this->last_status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->last_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->last_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->last_status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->last_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->last_status->Lookup->renderViewRow($rswrk[0]);
                        $this->last_status->ViewValue = $this->last_status->displayValue($arwrk);
                    } else {
                        $this->last_status->ViewValue = FormatNumber($this->last_status->CurrentValue, $this->last_status->formatPattern());
                    }
                }
            } else {
                $this->last_status->ViewValue = null;
            }

            // uploads
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // out_time
            $this->out_time->ViewValue = $this->out_time->CurrentValue;
            $this->out_time->ViewValue = FormatDateTime($this->out_time->ViewValue, $this->out_time->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = FormatNumber($this->a_operator->CurrentValue, $this->a_operator->formatPattern());
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // invoice
            $this->invoice->ViewValue = $this->invoice->CurrentValue;

            // invoice_date
            $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
            $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // buyer_id
            $this->buyer_id->HrefValue = "";
            $this->buyer_id->TooltipValue = "";

            // hardware_id
            $this->hardware_id->HrefValue = "";
            $this->hardware_id->TooltipValue = "";

            // service_executive
            $this->service_executive->HrefValue = "";
            $this->service_executive->TooltipValue = "";

            // entry_time
            $this->entry_time->HrefValue = "";
            $this->entry_time->TooltipValue = "";

            // current_reading
            $this->current_reading->HrefValue = "";
            $this->current_reading->TooltipValue = "";

            // error_ref
            $this->error_ref->HrefValue = "";
            $this->error_ref->TooltipValue = "";

            // service_type
            $this->service_type->HrefValue = "";
            $this->service_type->TooltipValue = "";

            // complaint
            $this->complaint->HrefValue = "";
            $this->complaint->TooltipValue = "";

            // observation
            $this->observation->HrefValue = "";
            $this->observation->TooltipValue = "";

            // product_replaced
            $this->product_replaced->HrefValue = "";
            $this->product_replaced->TooltipValue = "";

            // consumable_replaced
            $this->consumable_replaced->HrefValue = "";
            $this->consumable_replaced->TooltipValue = "";

            // work_detail
            $this->work_detail->HrefValue = "";
            $this->work_detail->TooltipValue = "";

            // future_task
            $this->future_task->HrefValue = "";
            $this->future_task->TooltipValue = "";

            // last_status
            $this->last_status->HrefValue = "";
            $this->last_status->TooltipValue = "";

            // uploads
            $this->uploads->HrefValue = "";
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
            $this->uploads->TooltipValue = "";

            // out_time
            $this->out_time->HrefValue = "";
            $this->out_time->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // invoice
            $this->invoice->HrefValue = "";
            $this->invoice->TooltipValue = "";

            // invoice_date
            $this->invoice_date->HrefValue = "";
            $this->invoice_date->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $this->buyer_id->EditValue = $this->buyer_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->buyer_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->EditValue = HtmlEncode(FormatNumber($this->buyer_id->AdvancedSearch->SearchValue, $this->buyer_id->formatPattern()));
                    }
                }
            } else {
                $this->buyer_id->EditValue = null;
            }
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // hardware_id
            $this->hardware_id->setupEditAttributes();
            $curVal = trim(strval($this->hardware_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->hardware_id->AdvancedSearch->ViewValue = $this->hardware_id->lookupCacheOption($curVal);
            } else {
                $this->hardware_id->AdvancedSearch->ViewValue = $this->hardware_id->Lookup !== null && is_array($this->hardware_id->lookupOptions()) && count($this->hardware_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->hardware_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->hardware_id->EditValue = array_values($this->hardware_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->hardware_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->hardware_id->AdvancedSearch->SearchValue, $this->hardware_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->hardware_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->hardware_id->EditValue = $arwrk;
            }
            $this->hardware_id->PlaceHolder = RemoveHtml($this->hardware_id->caption());

            // service_executive
            $this->service_executive->setupEditAttributes();
            $this->service_executive->EditValue = $this->service_executive->AdvancedSearch->SearchValue;
            $curVal = strval($this->service_executive->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->service_executive->EditValue = $this->service_executive->lookupCacheOption($curVal);
                if ($this->service_executive->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->service_executive->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->service_executive->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->service_executive->getSelectFilter($this); // PHP
                    $sqlWrk = $this->service_executive->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->service_executive->Lookup->renderViewRow($rswrk[0]);
                        $this->service_executive->EditValue = $this->service_executive->displayValue($arwrk);
                    } else {
                        $this->service_executive->EditValue = HtmlEncode(FormatNumber($this->service_executive->AdvancedSearch->SearchValue, $this->service_executive->formatPattern()));
                    }
                }
            } else {
                $this->service_executive->EditValue = null;
            }
            $this->service_executive->PlaceHolder = RemoveHtml($this->service_executive->caption());

            // entry_time
            $this->entry_time->setupEditAttributes();
            $this->entry_time->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->entry_time->AdvancedSearch->SearchValue, $this->entry_time->formatPattern()), $this->entry_time->formatPattern()));
            $this->entry_time->PlaceHolder = RemoveHtml($this->entry_time->caption());

            // current_reading
            $this->current_reading->setupEditAttributes();
            $this->current_reading->EditValue = $this->current_reading->AdvancedSearch->SearchValue;
            $this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());

            // error_ref
            $this->error_ref->setupEditAttributes();
            $curVal = trim(strval($this->error_ref->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->error_ref->AdvancedSearch->ViewValue = $this->error_ref->lookupCacheOption($curVal);
            } else {
                $this->error_ref->AdvancedSearch->ViewValue = $this->error_ref->Lookup !== null && is_array($this->error_ref->lookupOptions()) && count($this->error_ref->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->error_ref->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->error_ref->EditValue = array_values($this->error_ref->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->error_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->error_ref->AdvancedSearch->SearchValue, $this->error_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->error_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->error_ref->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->error_ref->Lookup->renderViewRow($row);
                }
                $this->error_ref->EditValue = $arwrk;
            }
            $this->error_ref->PlaceHolder = RemoveHtml($this->error_ref->caption());

            // service_type
            $this->service_type->setupEditAttributes();
            $curVal = trim(strval($this->service_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->service_type->AdvancedSearch->ViewValue = $this->service_type->lookupCacheOption($curVal);
            } else {
                $this->service_type->AdvancedSearch->ViewValue = $this->service_type->Lookup !== null && is_array($this->service_type->lookupOptions()) && count($this->service_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->service_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->service_type->EditValue = array_values($this->service_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->service_type->AdvancedSearch->SearchValue, $this->service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->service_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->service_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->service_type->EditValue = $arwrk;
            }
            $this->service_type->PlaceHolder = RemoveHtml($this->service_type->caption());

            // complaint
            $this->complaint->setupEditAttributes();
            $curVal = trim(strval($this->complaint->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->complaint->AdvancedSearch->ViewValue = $this->complaint->lookupCacheOption($curVal);
            } else {
                $this->complaint->AdvancedSearch->ViewValue = $this->complaint->Lookup !== null && is_array($this->complaint->lookupOptions()) && count($this->complaint->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->complaint->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->complaint->EditValue = array_values($this->complaint->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->complaint->Lookup->getTable()->Fields["item"]->searchExpression(), "=", $this->complaint->AdvancedSearch->SearchValue, $this->complaint->Lookup->getTable()->Fields["item"]->searchDataType(), "");
                }
                $lookupFilter = $this->complaint->getSelectFilter($this); // PHP
                $sqlWrk = $this->complaint->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->complaint->EditValue = $arwrk;
            }
            $this->complaint->PlaceHolder = RemoveHtml($this->complaint->caption());

            // observation
            $this->observation->setupEditAttributes();
            $this->observation->EditValue = HtmlEncode($this->observation->AdvancedSearch->SearchValue);
            $this->observation->PlaceHolder = RemoveHtml($this->observation->caption());

            // product_replaced
            $this->product_replaced->EditCustomAttributes = $this->product_replaced->getEditCustomAttributes(); // PHP
            $curVal = trim(strval($this->product_replaced->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product_replaced->AdvancedSearch->ViewValue = $this->product_replaced->lookupCacheOption($curVal);
            } else {
                $this->product_replaced->AdvancedSearch->ViewValue = $this->product_replaced->Lookup !== null && is_array($this->product_replaced->lookupOptions()) && count($this->product_replaced->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_replaced->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product_replaced->EditValue = array_values($this->product_replaced->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->product_replaced->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_replaced->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->product_replaced->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_replaced->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->product_replaced->Lookup->renderViewRow($row);
                }
                $this->product_replaced->EditValue = $arwrk;
            }
            $this->product_replaced->PlaceHolder = RemoveHtml($this->product_replaced->caption());

            // consumable_replaced
            $curVal = trim(strval($this->consumable_replaced->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->consumable_replaced->AdvancedSearch->ViewValue = $this->consumable_replaced->lookupCacheOption($curVal);
            } else {
                $this->consumable_replaced->AdvancedSearch->ViewValue = $this->consumable_replaced->Lookup !== null && is_array($this->consumable_replaced->lookupOptions()) && count($this->consumable_replaced->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->consumable_replaced->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->consumable_replaced->EditValue = array_values($this->consumable_replaced->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->consumable_replaced->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->consumable_replaced->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->consumable_replaced->getSelectFilter($this); // PHP
                $sqlWrk = $this->consumable_replaced->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->consumable_replaced->Lookup->renderViewRow($row);
                }
                $this->consumable_replaced->EditValue = $arwrk;
            }
            $this->consumable_replaced->PlaceHolder = RemoveHtml($this->consumable_replaced->caption());

            // work_detail
            $this->work_detail->setupEditAttributes();
            $this->work_detail->EditValue = HtmlEncode($this->work_detail->AdvancedSearch->SearchValue);
            $this->work_detail->PlaceHolder = RemoveHtml($this->work_detail->caption());

            // future_task
            $this->future_task->setupEditAttributes();
            $this->future_task->EditValue = HtmlEncode($this->future_task->AdvancedSearch->SearchValue);
            $this->future_task->PlaceHolder = RemoveHtml($this->future_task->caption());

            // last_status
            $this->last_status->setupEditAttributes();
            $curVal = trim(strval($this->last_status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->last_status->AdvancedSearch->ViewValue = $this->last_status->lookupCacheOption($curVal);
            } else {
                $this->last_status->AdvancedSearch->ViewValue = $this->last_status->Lookup !== null && is_array($this->last_status->lookupOptions()) && count($this->last_status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->last_status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->last_status->EditValue = array_values($this->last_status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->last_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->last_status->AdvancedSearch->SearchValue, $this->last_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->last_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->last_status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->last_status->EditValue = $arwrk;
            }
            $this->last_status->PlaceHolder = RemoveHtml($this->last_status->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            if (!$this->uploads->Raw) {
                $this->uploads->AdvancedSearch->SearchValue = HtmlDecode($this->uploads->AdvancedSearch->SearchValue);
            }
            $this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
            $this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

            // out_time
            $this->out_time->setupEditAttributes();
            $this->out_time->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->out_time->AdvancedSearch->SearchValue, $this->out_time->formatPattern()), $this->out_time->formatPattern()));
            $this->out_time->PlaceHolder = RemoveHtml($this->out_time->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // a_operator
            $this->a_operator->setupEditAttributes();
            $curVal = trim(strval($this->a_operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            } else {
                $this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->Lookup !== null && is_array($this->a_operator->lookupOptions()) && count($this->a_operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->a_operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->a_operator->EditValue = array_values($this->a_operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->a_operator->AdvancedSearch->SearchValue, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->a_operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->a_operator->EditValue = $arwrk;
            }
            $this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

            // invoice
            $this->invoice->setupEditAttributes();
            if (!$this->invoice->Raw) {
                $this->invoice->AdvancedSearch->SearchValue = HtmlDecode($this->invoice->AdvancedSearch->SearchValue);
            }
            $this->invoice->EditValue = HtmlEncode($this->invoice->AdvancedSearch->SearchValue);
            $this->invoice->PlaceHolder = RemoveHtml($this->invoice->caption());

            // invoice_date
            $this->invoice_date->setupEditAttributes();
            $this->invoice_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue, $this->invoice_date->formatPattern()), $this->invoice_date->formatPattern()));
            $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckInteger($this->buyer_id->AdvancedSearch->SearchValue)) {
            $this->buyer_id->addErrorMessage($this->buyer_id->getErrorMessage(false));
        }
        if (!CheckInteger($this->service_executive->AdvancedSearch->SearchValue)) {
            $this->service_executive->addErrorMessage($this->service_executive->getErrorMessage(false));
        }
        if (!CheckDate($this->entry_time->AdvancedSearch->SearchValue, $this->entry_time->formatPattern())) {
            $this->entry_time->addErrorMessage($this->entry_time->getErrorMessage(false));
        }
        if (!CheckInteger($this->current_reading->AdvancedSearch->SearchValue)) {
            $this->current_reading->addErrorMessage($this->current_reading->getErrorMessage(false));
        }
        if (!CheckDate($this->out_time->AdvancedSearch->SearchValue, $this->out_time->formatPattern())) {
            $this->out_time->addErrorMessage($this->out_time->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue, $this->invoice_date->formatPattern())) {
            $this->invoice_date->addErrorMessage($this->invoice_date->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->buyer_id->AdvancedSearch->load();
        $this->hardware_id->AdvancedSearch->load();
        $this->service_executive->AdvancedSearch->load();
        $this->entry_time->AdvancedSearch->load();
        $this->current_reading->AdvancedSearch->load();
        $this->error_ref->AdvancedSearch->load();
        $this->service_type->AdvancedSearch->load();
        $this->complaint->AdvancedSearch->load();
        $this->observation->AdvancedSearch->load();
        $this->product_replaced->AdvancedSearch->load();
        $this->consumable_replaced->AdvancedSearch->load();
        $this->work_detail->AdvancedSearch->load();
        $this->future_task->AdvancedSearch->load();
        $this->last_status->AdvancedSearch->load();
        $this->uploads->AdvancedSearch->load();
        $this->out_time->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->a_operator->AdvancedSearch->load();
        $this->invoice->AdvancedSearch->load();
        $this->invoice_date->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("servicereportlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_buyer_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_hardware_id":
                    break;
                case "x_service_executive":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_error_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_service_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_complaint":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_replaced":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_consumable_replaced":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_last_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
